/* fd_net_connector.h - SPSC ring buffers for XDP->Agave packet handoff.
   Proto 7-12 maps to ring 0-5. All rings drop on overflow. */

#ifndef HEADER_fd_src_disco_net_connector_fd_net_connector_h
#define HEADER_fd_src_disco_net_connector_fd_net_connector_h

#include "fd_netconn_ring.h"

/* Ring buffer configuration - depths must be powers of 2 for masking */
#define FD_NET_CONNECTOR_RING_DEPTH_STAKED    16384UL
#define FD_NET_CONNECTOR_RING_DEPTH_UNSTAKED  8192UL
#define FD_NET_CONNECTOR_MTU                  FD_NETCONN_RING_MTU

FD_STATIC_ASSERT( (FD_NET_CONNECTOR_RING_DEPTH_STAKED   & (FD_NET_CONNECTOR_RING_DEPTH_STAKED   - 1)) == 0, depth_must_be_pow2 );
FD_STATIC_ASSERT( (FD_NET_CONNECTOR_RING_DEPTH_UNSTAKED & (FD_NET_CONNECTOR_RING_DEPTH_UNSTAKED - 1)) == 0, depth_must_be_pow2 );

/* Compile-time footprints for static declarations */
#define FD_NET_CONNECTOR_RING_FOOTPRINT_STAKED   FD_NETCONN_RING_FOOTPRINT( FD_NET_CONNECTOR_RING_DEPTH_STAKED )
#define FD_NET_CONNECTOR_RING_FOOTPRINT_UNSTAKED FD_NETCONN_RING_FOOTPRINT( FD_NET_CONNECTOR_RING_DEPTH_UNSTAKED )

/* Ring buffer indices */
#define FD_NET_CONNECTOR_RING_GOSSIP_STAKED     0
#define FD_NET_CONNECTOR_RING_GOSSIP_UNSTAKED   1
#define FD_NET_CONNECTOR_RING_REPAIR_STAKED     2
#define FD_NET_CONNECTOR_RING_REPAIR_UNSTAKED   3
#define FD_NET_CONNECTOR_RING_ANCESTOR_UNSTAKED 4
#define FD_NET_CONNECTOR_RING_ANCESTOR_STAKED   5
#define FD_NET_CONNECTOR_RING_CNT               6

#endif /* HEADER_fd_src_disco_net_connector_fd_net_connector_h */
