/* Autogenerated: fiat_crypto.js unsaturated-solinas 25519x6 64 6 2^255-19 carry_mul carry_square carry_scmul121666 carry add sub opp selectznz to_bytes from_bytes */
/* curve description: 25519x6 */
/* machine_wordsize = 64 (from "64") */
/* requested operations: carry_mul, carry_square, carry_scmul121666, carry, add, sub, opp, selectznz, to_bytes, from_bytes */
/* n = 6 (from "6") */
/* s-c = 2^255 - [(1, 19)] (from "2^255-19") */
/* tight_bounds_multiplier = 1 (from "") */
/*  */
/* Computed values: */
/*   carry_chain = [0, 1, 2, 3, 4, 5, 0, 1] */
/*   eval z = z[0] + (z[1] << 43) + (z[2] << 85) + (z[3] << 128) + (z[4] << 170) + (z[5] << 213) */
/*   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) */
/*   balance = [0xfffffffffda, 0x7fffffffffe, 0xffffffffffe, 0x7fffffffffe, 0xffffffffffe, 0x7fffffffffe] */

#include <stdint.h>
typedef unsigned char fiat_25519x6_uint1;
typedef signed char fiat_25519x6_int1;
#if defined(__GNUC__) || defined(__clang__)
#  define FIAT_25519X6_FIAT_EXTENSION __extension__
#  define FIAT_25519X6_FIAT_INLINE __inline__
#else
#  define FIAT_25519X6_FIAT_EXTENSION
#  define FIAT_25519X6_FIAT_INLINE
#endif

FIAT_25519X6_FIAT_EXTENSION typedef signed __int128 fiat_25519x6_int128;
FIAT_25519X6_FIAT_EXTENSION typedef unsigned __int128 fiat_25519x6_uint128;

/* The type fiat_25519x6_loose_field_element is a field element with loose bounds. */
/* Bounds: [[0x0 ~> 0x180000000000], [0x0 ~> 0xc0000000000], [0x0 ~> 0x180000000000], [0x0 ~> 0xc0000000000], [0x0 ~> 0x180000000000], [0x0 ~> 0xc0000000000]] */
typedef uint64_t fiat_25519x6_loose_field_element[6];

/* The type fiat_25519x6_tight_field_element is a field element with tight bounds. */
/* Bounds: [[0x0 ~> 0x80000000000], [0x0 ~> 0x40000000000], [0x0 ~> 0x80000000000], [0x0 ~> 0x40000000000], [0x0 ~> 0x80000000000], [0x0 ~> 0x40000000000]] */
typedef uint64_t fiat_25519x6_tight_field_element[6];

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif


/*
 * The function fiat_25519x6_addcarryx_u42 is an addition with carry.
 *
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^42
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^42⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x3ffffffffff]
 *   arg3: [0x0 ~> 0x3ffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x3ffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
void fiat_25519x6_addcarryx_u42(uint64_t* out1, fiat_25519x6_uint1* out2, fiat_25519x6_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  uint64_t x1;
  uint64_t x2;
  fiat_25519x6_uint1 x3;
  x1 = ((arg1 + arg2) + arg3);
  x2 = (x1 & UINT64_C(0x3ffffffffff));
  x3 = (fiat_25519x6_uint1)(x1 >> 42);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_25519x6_subborrowx_u42 is a subtraction with borrow.
 *
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^42
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^42⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x3ffffffffff]
 *   arg3: [0x0 ~> 0x3ffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x3ffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
void fiat_25519x6_subborrowx_u42(uint64_t* out1, fiat_25519x6_uint1* out2, fiat_25519x6_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  int64_t x1;
  fiat_25519x6_int1 x2;
  uint64_t x3;
  x1 = ((int64_t)((int64_t)arg2 - (int64_t)arg1) - (int64_t)arg3);
  x2 = (fiat_25519x6_int1)(x1 >> 42);
  x3 = ((uint64_t)x1 & UINT64_C(0x3ffffffffff));
  *out1 = x3;
  *out2 = (fiat_25519x6_uint1)(0x0 - x2);
}

/*
 * The function fiat_25519x6_addcarryx_u43 is an addition with carry.
 *
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^43
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^43⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x7ffffffffff]
 *   arg3: [0x0 ~> 0x7ffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x7ffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
void fiat_25519x6_addcarryx_u43(uint64_t* out1, fiat_25519x6_uint1* out2, fiat_25519x6_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  uint64_t x1;
  uint64_t x2;
  fiat_25519x6_uint1 x3;
  x1 = ((arg1 + arg2) + arg3);
  x2 = (x1 & UINT64_C(0x7ffffffffff));
  x3 = (fiat_25519x6_uint1)(x1 >> 43);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_25519x6_subborrowx_u43 is a subtraction with borrow.
 *
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^43
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^43⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0x7ffffffffff]
 *   arg3: [0x0 ~> 0x7ffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0x7ffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
void fiat_25519x6_subborrowx_u43(uint64_t* out1, fiat_25519x6_uint1* out2, fiat_25519x6_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  int64_t x1;
  fiat_25519x6_int1 x2;
  uint64_t x3;
  x1 = ((int64_t)((int64_t)arg2 - (int64_t)arg1) - (int64_t)arg3);
  x2 = (fiat_25519x6_int1)(x1 >> 43);
  x3 = ((uint64_t)x1 & UINT64_C(0x7ffffffffff));
  *out1 = x3;
  *out2 = (fiat_25519x6_uint1)(0x0 - x2);
}

/*
 * The function fiat_25519x6_cmovznz_u64 is a single-word conditional move.
 *
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 */
void fiat_25519x6_cmovznz_u64(uint64_t* out1, fiat_25519x6_uint1 arg1, uint64_t arg2, uint64_t arg3) {
  fiat_25519x6_uint1 x1;
  uint64_t x2;
  uint64_t x3;
  x1 = (!(!arg1));
  x2 = ((uint64_t)(fiat_25519x6_int1)(0x0 - x1) & UINT64_C(0xffffffffffffffff));
  x3 = ((x2 & arg3) | ((~x2) & arg2));
  *out1 = x3;
}

/*
 * The function fiat_25519x6_carry_mul multiplies two field elements and reduces the result.
 *
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * eval arg2) mod m
 *
 */
void fiat_25519x6_carry_mul(fiat_25519x6_tight_field_element out1, const fiat_25519x6_loose_field_element arg1, const fiat_25519x6_loose_field_element arg2) {
  fiat_25519x6_uint128 x1;
  fiat_25519x6_uint128 x2;
  fiat_25519x6_uint128 x3;
  fiat_25519x6_uint128 x4;
  fiat_25519x6_uint128 x5;
  fiat_25519x6_uint128 x6;
  fiat_25519x6_uint128 x7;
  fiat_25519x6_uint128 x8;
  fiat_25519x6_uint128 x9;
  fiat_25519x6_uint128 x10;
  fiat_25519x6_uint128 x11;
  fiat_25519x6_uint128 x12;
  fiat_25519x6_uint128 x13;
  fiat_25519x6_uint128 x14;
  fiat_25519x6_uint128 x15;
  fiat_25519x6_uint128 x16;
  fiat_25519x6_uint128 x17;
  fiat_25519x6_uint128 x18;
  fiat_25519x6_uint128 x19;
  fiat_25519x6_uint128 x20;
  fiat_25519x6_uint128 x21;
  fiat_25519x6_uint128 x22;
  fiat_25519x6_uint128 x23;
  fiat_25519x6_uint128 x24;
  fiat_25519x6_uint128 x25;
  fiat_25519x6_uint128 x26;
  fiat_25519x6_uint128 x27;
  fiat_25519x6_uint128 x28;
  fiat_25519x6_uint128 x29;
  fiat_25519x6_uint128 x30;
  fiat_25519x6_uint128 x31;
  fiat_25519x6_uint128 x32;
  fiat_25519x6_uint128 x33;
  fiat_25519x6_uint128 x34;
  fiat_25519x6_uint128 x35;
  fiat_25519x6_uint128 x36;
  fiat_25519x6_uint128 x37;
  uint64_t x38;
  uint64_t x39;
  fiat_25519x6_uint128 x40;
  fiat_25519x6_uint128 x41;
  fiat_25519x6_uint128 x42;
  fiat_25519x6_uint128 x43;
  fiat_25519x6_uint128 x44;
  fiat_25519x6_uint128 x45;
  uint64_t x46;
  uint64_t x47;
  fiat_25519x6_uint128 x48;
  uint64_t x49;
  uint64_t x50;
  fiat_25519x6_uint128 x51;
  uint64_t x52;
  uint64_t x53;
  fiat_25519x6_uint128 x54;
  uint64_t x55;
  uint64_t x56;
  fiat_25519x6_uint128 x57;
  uint64_t x58;
  uint64_t x59;
  uint64_t x60;
  uint64_t x61;
  uint64_t x62;
  uint64_t x63;
  uint64_t x64;
  fiat_25519x6_uint1 x65;
  uint64_t x66;
  uint64_t x67;
  x1 = ((fiat_25519x6_uint128)(arg1[5]) * ((arg2[5]) * UINT8_C(0x26)));
  x2 = ((fiat_25519x6_uint128)(arg1[5]) * ((arg2[4]) * UINT8_C(0x13)));
  x3 = ((fiat_25519x6_uint128)(arg1[5]) * ((arg2[3]) * UINT8_C(0x26)));
  x4 = ((fiat_25519x6_uint128)(arg1[5]) * ((arg2[2]) * UINT8_C(0x13)));
  x5 = ((fiat_25519x6_uint128)(arg1[5]) * ((arg2[1]) * UINT8_C(0x26)));
  x6 = ((fiat_25519x6_uint128)(arg1[4]) * ((arg2[5]) * UINT8_C(0x13)));
  x7 = ((fiat_25519x6_uint128)(arg1[4]) * ((arg2[4]) * UINT8_C(0x13)));
  x8 = ((fiat_25519x6_uint128)(arg1[4]) * ((arg2[3]) * UINT8_C(0x13)));
  x9 = ((fiat_25519x6_uint128)(arg1[4]) * ((arg2[2]) * UINT8_C(0x13)));
  x10 = ((fiat_25519x6_uint128)(arg1[3]) * ((arg2[5]) * UINT8_C(0x26)));
  x11 = ((fiat_25519x6_uint128)(arg1[3]) * ((arg2[4]) * UINT8_C(0x13)));
  x12 = ((fiat_25519x6_uint128)(arg1[3]) * ((arg2[3]) * UINT8_C(0x26)));
  x13 = ((fiat_25519x6_uint128)(arg1[2]) * ((arg2[5]) * UINT8_C(0x13)));
  x14 = ((fiat_25519x6_uint128)(arg1[2]) * ((arg2[4]) * UINT8_C(0x13)));
  x15 = ((fiat_25519x6_uint128)(arg1[1]) * ((arg2[5]) * UINT8_C(0x26)));
  x16 = ((fiat_25519x6_uint128)(arg1[5]) * (arg2[0]));
  x17 = ((fiat_25519x6_uint128)(arg1[4]) * (arg2[1]));
  x18 = ((fiat_25519x6_uint128)(arg1[4]) * (arg2[0]));
  x19 = ((fiat_25519x6_uint128)(arg1[3]) * (arg2[2]));
  x20 = ((fiat_25519x6_uint128)(arg1[3]) * ((arg2[1]) * 0x2));
  x21 = ((fiat_25519x6_uint128)(arg1[3]) * (arg2[0]));
  x22 = ((fiat_25519x6_uint128)(arg1[2]) * (arg2[3]));
  x23 = ((fiat_25519x6_uint128)(arg1[2]) * (arg2[2]));
  x24 = ((fiat_25519x6_uint128)(arg1[2]) * (arg2[1]));
  x25 = ((fiat_25519x6_uint128)(arg1[2]) * (arg2[0]));
  x26 = ((fiat_25519x6_uint128)(arg1[1]) * (arg2[4]));
  x27 = ((fiat_25519x6_uint128)(arg1[1]) * ((arg2[3]) * 0x2));
  x28 = ((fiat_25519x6_uint128)(arg1[1]) * (arg2[2]));
  x29 = ((fiat_25519x6_uint128)(arg1[1]) * ((arg2[1]) * 0x2));
  x30 = ((fiat_25519x6_uint128)(arg1[1]) * (arg2[0]));
  x31 = ((fiat_25519x6_uint128)(arg1[0]) * (arg2[5]));
  x32 = ((fiat_25519x6_uint128)(arg1[0]) * (arg2[4]));
  x33 = ((fiat_25519x6_uint128)(arg1[0]) * (arg2[3]));
  x34 = ((fiat_25519x6_uint128)(arg1[0]) * (arg2[2]));
  x35 = ((fiat_25519x6_uint128)(arg1[0]) * (arg2[1]));
  x36 = ((fiat_25519x6_uint128)(arg1[0]) * (arg2[0]));
  x37 = (x36 + (x15 + (x14 + (x12 + (x9 + x5)))));
  x38 = (uint64_t)(x37 >> 43);
  x39 = (uint64_t)(x37 & UINT64_C(0x7ffffffffff));
  x40 = (x31 + (x26 + (x22 + (x19 + (x17 + x16)))));
  x41 = (x32 + (x27 + (x23 + (x20 + (x18 + x1)))));
  x42 = (x33 + (x28 + (x24 + (x21 + (x6 + x2)))));
  x43 = (x34 + (x29 + (x25 + (x10 + (x7 + x3)))));
  x44 = (x35 + (x30 + (x13 + (x11 + (x8 + x4)))));
  x45 = (x38 + x44);
  x46 = (uint64_t)(x45 >> 42);
  x47 = (uint64_t)(x45 & UINT64_C(0x3ffffffffff));
  x48 = (x46 + x43);
  x49 = (uint64_t)(x48 >> 43);
  x50 = (uint64_t)(x48 & UINT64_C(0x7ffffffffff));
  x51 = (x49 + x42);
  x52 = (uint64_t)(x51 >> 42);
  x53 = (uint64_t)(x51 & UINT64_C(0x3ffffffffff));
  x54 = (x52 + x41);
  x55 = (uint64_t)(x54 >> 43);
  x56 = (uint64_t)(x54 & UINT64_C(0x7ffffffffff));
  x57 = (x55 + x40);
  x58 = (uint64_t)(x57 >> 42);
  x59 = (uint64_t)(x57 & UINT64_C(0x3ffffffffff));
  x60 = (x58 * UINT8_C(0x13));
  x61 = (x39 + x60);
  x62 = (x61 >> 43);
  x63 = (x61 & UINT64_C(0x7ffffffffff));
  x64 = (x62 + x47);
  x65 = (fiat_25519x6_uint1)(x64 >> 42);
  x66 = (x64 & UINT64_C(0x3ffffffffff));
  x67 = (x65 + x50);
  out1[0] = x63;
  out1[1] = x66;
  out1[2] = x67;
  out1[3] = x53;
  out1[4] = x56;
  out1[5] = x59;
}

/*
 * The function fiat_25519x6_carry_square squares a field element and reduces the result.
 *
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * eval arg1) mod m
 *
 */
void fiat_25519x6_carry_square(fiat_25519x6_tight_field_element out1, const fiat_25519x6_loose_field_element arg1) {
  uint64_t x1;
  uint64_t x2;
  uint64_t x3;
  uint64_t x4;
  uint64_t x5;
  uint64_t x6;
  uint64_t x7;
  uint64_t x8;
  uint64_t x9;
  uint64_t x10;
  fiat_25519x6_uint128 x11;
  fiat_25519x6_uint128 x12;
  fiat_25519x6_uint128 x13;
  fiat_25519x6_uint128 x14;
  fiat_25519x6_uint128 x15;
  fiat_25519x6_uint128 x16;
  fiat_25519x6_uint128 x17;
  fiat_25519x6_uint128 x18;
  fiat_25519x6_uint128 x19;
  fiat_25519x6_uint128 x20;
  fiat_25519x6_uint128 x21;
  fiat_25519x6_uint128 x22;
  fiat_25519x6_uint128 x23;
  fiat_25519x6_uint128 x24;
  fiat_25519x6_uint128 x25;
  fiat_25519x6_uint128 x26;
  fiat_25519x6_uint128 x27;
  fiat_25519x6_uint128 x28;
  fiat_25519x6_uint128 x29;
  fiat_25519x6_uint128 x30;
  fiat_25519x6_uint128 x31;
  fiat_25519x6_uint128 x32;
  uint64_t x33;
  uint64_t x34;
  fiat_25519x6_uint128 x35;
  fiat_25519x6_uint128 x36;
  fiat_25519x6_uint128 x37;
  fiat_25519x6_uint128 x38;
  fiat_25519x6_uint128 x39;
  fiat_25519x6_uint128 x40;
  uint64_t x41;
  uint64_t x42;
  fiat_25519x6_uint128 x43;
  uint64_t x44;
  uint64_t x45;
  fiat_25519x6_uint128 x46;
  uint64_t x47;
  uint64_t x48;
  fiat_25519x6_uint128 x49;
  uint64_t x50;
  uint64_t x51;
  fiat_25519x6_uint128 x52;
  uint64_t x53;
  uint64_t x54;
  uint64_t x55;
  uint64_t x56;
  uint64_t x57;
  uint64_t x58;
  uint64_t x59;
  fiat_25519x6_uint1 x60;
  uint64_t x61;
  uint64_t x62;
  x1 = ((arg1[5]) * UINT8_C(0x13));
  x2 = (x1 * 0x2);
  x3 = ((arg1[5]) * 0x2);
  x4 = ((arg1[4]) * UINT8_C(0x13));
  x5 = (x4 * 0x2);
  x6 = ((arg1[4]) * 0x2);
  x7 = ((arg1[3]) * UINT8_C(0x13));
  x8 = ((arg1[3]) * 0x2);
  x9 = ((arg1[2]) * 0x2);
  x10 = ((arg1[1]) * 0x2);
  x11 = ((fiat_25519x6_uint128)(arg1[5]) * (x1 * 0x2));
  x12 = ((fiat_25519x6_uint128)(arg1[4]) * x2);
  x13 = ((fiat_25519x6_uint128)(arg1[4]) * x4);
  x14 = ((fiat_25519x6_uint128)(arg1[3]) * (x2 * 0x2));
  x15 = ((fiat_25519x6_uint128)(arg1[3]) * x5);
  x16 = ((fiat_25519x6_uint128)(arg1[3]) * (x7 * 0x2));
  x17 = ((fiat_25519x6_uint128)(arg1[2]) * x2);
  x18 = ((fiat_25519x6_uint128)(arg1[2]) * x5);
  x19 = ((fiat_25519x6_uint128)(arg1[2]) * x8);
  x20 = ((fiat_25519x6_uint128)(arg1[2]) * (arg1[2]));
  x21 = ((fiat_25519x6_uint128)(arg1[1]) * (x2 * 0x2));
  x22 = ((fiat_25519x6_uint128)(arg1[1]) * x6);
  x23 = ((fiat_25519x6_uint128)(arg1[1]) * (x8 * 0x2));
  x24 = ((fiat_25519x6_uint128)(arg1[1]) * x9);
  x25 = ((fiat_25519x6_uint128)(arg1[1]) * ((arg1[1]) * 0x2));
  x26 = ((fiat_25519x6_uint128)(arg1[0]) * x3);
  x27 = ((fiat_25519x6_uint128)(arg1[0]) * x6);
  x28 = ((fiat_25519x6_uint128)(arg1[0]) * x8);
  x29 = ((fiat_25519x6_uint128)(arg1[0]) * x9);
  x30 = ((fiat_25519x6_uint128)(arg1[0]) * x10);
  x31 = ((fiat_25519x6_uint128)(arg1[0]) * (arg1[0]));
  x32 = (x31 + (x21 + (x18 + x16)));
  x33 = (uint64_t)(x32 >> 43);
  x34 = (uint64_t)(x32 & UINT64_C(0x7ffffffffff));
  x35 = (x26 + (x22 + x19));
  x36 = (x27 + (x23 + (x20 + x11)));
  x37 = (x28 + (x24 + x12));
  x38 = (x29 + (x25 + (x14 + x13)));
  x39 = (x30 + (x17 + x15));
  x40 = (x33 + x39);
  x41 = (uint64_t)(x40 >> 42);
  x42 = (uint64_t)(x40 & UINT64_C(0x3ffffffffff));
  x43 = (x41 + x38);
  x44 = (uint64_t)(x43 >> 43);
  x45 = (uint64_t)(x43 & UINT64_C(0x7ffffffffff));
  x46 = (x44 + x37);
  x47 = (uint64_t)(x46 >> 42);
  x48 = (uint64_t)(x46 & UINT64_C(0x3ffffffffff));
  x49 = (x47 + x36);
  x50 = (uint64_t)(x49 >> 43);
  x51 = (uint64_t)(x49 & UINT64_C(0x7ffffffffff));
  x52 = (x50 + x35);
  x53 = (uint64_t)(x52 >> 42);
  x54 = (uint64_t)(x52 & UINT64_C(0x3ffffffffff));
  x55 = (x53 * UINT8_C(0x13));
  x56 = (x34 + x55);
  x57 = (x56 >> 43);
  x58 = (x56 & UINT64_C(0x7ffffffffff));
  x59 = (x57 + x42);
  x60 = (fiat_25519x6_uint1)(x59 >> 42);
  x61 = (x59 & UINT64_C(0x3ffffffffff));
  x62 = (x60 + x45);
  out1[0] = x58;
  out1[1] = x61;
  out1[2] = x62;
  out1[3] = x48;
  out1[4] = x51;
  out1[5] = x54;
}

/*
 * The function fiat_25519x6_carry_scmul_121666 multiplies a field element by 121666 and reduces the result.
 *
 * Postconditions:
 *   eval out1 mod m = (121666 * eval arg1) mod m
 *
 */
void fiat_25519x6_carry_scmul_121666(fiat_25519x6_tight_field_element out1, const fiat_25519x6_loose_field_element arg1) {
  uint64_t x1;
  uint64_t x2;
  uint64_t x3;
  uint64_t x4;
  uint64_t x5;
  uint64_t x6;
  uint64_t x7;
  uint64_t x8;
  uint64_t x9;
  uint64_t x10;
  uint64_t x11;
  uint64_t x12;
  uint64_t x13;
  uint64_t x14;
  uint64_t x15;
  uint64_t x16;
  uint64_t x17;
  uint64_t x18;
  uint64_t x19;
  uint64_t x20;
  uint64_t x21;
  uint64_t x22;
  uint64_t x23;
  uint64_t x24;
  uint64_t x25;
  fiat_25519x6_uint1 x26;
  uint64_t x27;
  uint64_t x28;
  fiat_25519x6_uint1 x29;
  uint64_t x30;
  uint64_t x31;
  x1 = (UINT32_C(0x1db42) * (arg1[5]));
  x2 = (UINT32_C(0x1db42) * (arg1[4]));
  x3 = (UINT32_C(0x1db42) * (arg1[3]));
  x4 = (UINT32_C(0x1db42) * (arg1[2]));
  x5 = (UINT32_C(0x1db42) * (arg1[1]));
  x6 = (UINT32_C(0x1db42) * (arg1[0]));
  x7 = (x6 >> 43);
  x8 = (x6 & UINT64_C(0x7ffffffffff));
  x9 = (x7 + x5);
  x10 = (x9 >> 42);
  x11 = (x9 & UINT64_C(0x3ffffffffff));
  x12 = (x10 + x4);
  x13 = (x12 >> 43);
  x14 = (x12 & UINT64_C(0x7ffffffffff));
  x15 = (x13 + x3);
  x16 = (x15 >> 42);
  x17 = (x15 & UINT64_C(0x3ffffffffff));
  x18 = (x16 + x2);
  x19 = (x18 >> 43);
  x20 = (x18 & UINT64_C(0x7ffffffffff));
  x21 = (x19 + x1);
  x22 = (x21 >> 42);
  x23 = (x21 & UINT64_C(0x3ffffffffff));
  x24 = (x22 * UINT8_C(0x13));
  x25 = (x8 + x24);
  x26 = (fiat_25519x6_uint1)(x25 >> 43);
  x27 = (x25 & UINT64_C(0x7ffffffffff));
  x28 = (x26 + x11);
  x29 = (fiat_25519x6_uint1)(x28 >> 42);
  x30 = (x28 & UINT64_C(0x3ffffffffff));
  x31 = (x29 + x14);
  out1[0] = x27;
  out1[1] = x30;
  out1[2] = x31;
  out1[3] = x17;
  out1[4] = x20;
  out1[5] = x23;
}

/*
 * The function fiat_25519x6_carry reduces a field element.
 *
 * Postconditions:
 *   eval out1 mod m = eval arg1 mod m
 *
 */
void fiat_25519x6_carry(fiat_25519x6_tight_field_element out1, const fiat_25519x6_loose_field_element arg1) {
  uint64_t x1;
  uint64_t x2;
  uint64_t x3;
  uint64_t x4;
  uint64_t x5;
  uint64_t x6;
  uint64_t x7;
  uint64_t x8;
  uint64_t x9;
  uint64_t x10;
  uint64_t x11;
  uint64_t x12;
  uint64_t x13;
  uint64_t x14;
  x1 = (arg1[0]);
  x2 = ((x1 >> 43) + (arg1[1]));
  x3 = ((x2 >> 42) + (arg1[2]));
  x4 = ((x3 >> 43) + (arg1[3]));
  x5 = ((x4 >> 42) + (arg1[4]));
  x6 = ((x5 >> 43) + (arg1[5]));
  x7 = ((x1 & UINT64_C(0x7ffffffffff)) + ((x6 >> 42) * UINT8_C(0x13)));
  x8 = ((fiat_25519x6_uint1)(x7 >> 43) + (x2 & UINT64_C(0x3ffffffffff)));
  x9 = (x7 & UINT64_C(0x7ffffffffff));
  x10 = (x8 & UINT64_C(0x3ffffffffff));
  x11 = ((fiat_25519x6_uint1)(x8 >> 42) + (x3 & UINT64_C(0x7ffffffffff)));
  x12 = (x4 & UINT64_C(0x3ffffffffff));
  x13 = (x5 & UINT64_C(0x7ffffffffff));
  x14 = (x6 & UINT64_C(0x3ffffffffff));
  out1[0] = x9;
  out1[1] = x10;
  out1[2] = x11;
  out1[3] = x12;
  out1[4] = x13;
  out1[5] = x14;
}

/*
 * The function fiat_25519x6_add adds two field elements.
 *
 * Postconditions:
 *   eval out1 mod m = (eval arg1 + eval arg2) mod m
 *
 */
void fiat_25519x6_add(fiat_25519x6_loose_field_element out1, const fiat_25519x6_tight_field_element arg1, const fiat_25519x6_tight_field_element arg2) {
  uint64_t x1;
  uint64_t x2;
  uint64_t x3;
  uint64_t x4;
  uint64_t x5;
  uint64_t x6;
  x1 = ((arg1[0]) + (arg2[0]));
  x2 = ((arg1[1]) + (arg2[1]));
  x3 = ((arg1[2]) + (arg2[2]));
  x4 = ((arg1[3]) + (arg2[3]));
  x5 = ((arg1[4]) + (arg2[4]));
  x6 = ((arg1[5]) + (arg2[5]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
}

/*
 * The function fiat_25519x6_sub subtracts two field elements.
 *
 * Postconditions:
 *   eval out1 mod m = (eval arg1 - eval arg2) mod m
 *
 */
void fiat_25519x6_sub(fiat_25519x6_loose_field_element out1, const fiat_25519x6_tight_field_element arg1, const fiat_25519x6_tight_field_element arg2) {
  uint64_t x1;
  uint64_t x2;
  uint64_t x3;
  uint64_t x4;
  uint64_t x5;
  uint64_t x6;
  x1 = ((UINT64_C(0xfffffffffda) + (arg1[0])) - (arg2[0]));
  x2 = ((UINT64_C(0x7fffffffffe) + (arg1[1])) - (arg2[1]));
  x3 = ((UINT64_C(0xffffffffffe) + (arg1[2])) - (arg2[2]));
  x4 = ((UINT64_C(0x7fffffffffe) + (arg1[3])) - (arg2[3]));
  x5 = ((UINT64_C(0xffffffffffe) + (arg1[4])) - (arg2[4]));
  x6 = ((UINT64_C(0x7fffffffffe) + (arg1[5])) - (arg2[5]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
}

/*
 * The function fiat_25519x6_opp negates a field element.
 *
 * Postconditions:
 *   eval out1 mod m = -eval arg1 mod m
 *
 */
void fiat_25519x6_opp(fiat_25519x6_loose_field_element out1, const fiat_25519x6_tight_field_element arg1) {
  uint64_t x1;
  uint64_t x2;
  uint64_t x3;
  uint64_t x4;
  uint64_t x5;
  uint64_t x6;
  x1 = (UINT64_C(0xfffffffffda) - (arg1[0]));
  x2 = (UINT64_C(0x7fffffffffe) - (arg1[1]));
  x3 = (UINT64_C(0xffffffffffe) - (arg1[2]));
  x4 = (UINT64_C(0x7fffffffffe) - (arg1[3]));
  x5 = (UINT64_C(0xffffffffffe) - (arg1[4]));
  x6 = (UINT64_C(0x7fffffffffe) - (arg1[5]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
}

/*
 * The function fiat_25519x6_selectznz is a multi-limb conditional select.
 *
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
void fiat_25519x6_selectznz(uint64_t out1[6], fiat_25519x6_uint1 arg1, const uint64_t arg2[6], const uint64_t arg3[6]) {
  uint64_t x1;
  uint64_t x2;
  uint64_t x3;
  uint64_t x4;
  uint64_t x5;
  uint64_t x6;
  fiat_25519x6_cmovznz_u64(&x1, arg1, (arg2[0]), (arg3[0]));
  fiat_25519x6_cmovznz_u64(&x2, arg1, (arg2[1]), (arg3[1]));
  fiat_25519x6_cmovznz_u64(&x3, arg1, (arg2[2]), (arg3[2]));
  fiat_25519x6_cmovznz_u64(&x4, arg1, (arg2[3]), (arg3[3]));
  fiat_25519x6_cmovznz_u64(&x5, arg1, (arg2[4]), (arg3[4]));
  fiat_25519x6_cmovznz_u64(&x6, arg1, (arg2[5]), (arg3[5]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
}

/*
 * The function fiat_25519x6_to_bytes serializes a field element to bytes in little-endian order.
 *
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..31]
 *
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x7f]]
 */
void fiat_25519x6_to_bytes(uint8_t out1[32], const fiat_25519x6_tight_field_element arg1) {
  uint64_t x1;
  fiat_25519x6_uint1 x2;
  uint64_t x3;
  fiat_25519x6_uint1 x4;
  uint64_t x5;
  fiat_25519x6_uint1 x6;
  uint64_t x7;
  fiat_25519x6_uint1 x8;
  uint64_t x9;
  fiat_25519x6_uint1 x10;
  uint64_t x11;
  fiat_25519x6_uint1 x12;
  uint64_t x13;
  uint64_t x14;
  fiat_25519x6_uint1 x15;
  uint64_t x16;
  fiat_25519x6_uint1 x17;
  uint64_t x18;
  fiat_25519x6_uint1 x19;
  uint64_t x20;
  fiat_25519x6_uint1 x21;
  uint64_t x22;
  fiat_25519x6_uint1 x23;
  uint64_t x24;
  fiat_25519x6_uint1 x25;
  uint64_t x26;
  uint64_t x27;
  uint64_t x28;
  uint64_t x29;
  uint8_t x30;
  uint64_t x31;
  uint8_t x32;
  uint64_t x33;
  uint8_t x34;
  uint64_t x35;
  uint8_t x36;
  uint64_t x37;
  uint8_t x38;
  uint8_t x39;
  uint64_t x40;
  uint8_t x41;
  uint64_t x42;
  uint8_t x43;
  uint64_t x44;
  uint8_t x45;
  uint64_t x46;
  uint8_t x47;
  uint64_t x48;
  uint8_t x49;
  uint8_t x50;
  uint64_t x51;
  uint8_t x52;
  uint64_t x53;
  uint8_t x54;
  uint64_t x55;
  uint8_t x56;
  uint64_t x57;
  uint8_t x58;
  uint64_t x59;
  uint8_t x60;
  uint8_t x61;
  uint8_t x62;
  uint64_t x63;
  uint8_t x64;
  uint64_t x65;
  uint8_t x66;
  uint64_t x67;
  uint8_t x68;
  uint64_t x69;
  uint8_t x70;
  uint8_t x71;
  uint64_t x72;
  uint8_t x73;
  uint64_t x74;
  uint8_t x75;
  uint64_t x76;
  uint8_t x77;
  uint64_t x78;
  uint8_t x79;
  uint64_t x80;
  uint8_t x81;
  uint8_t x82;
  uint64_t x83;
  uint8_t x84;
  uint64_t x85;
  uint8_t x86;
  uint64_t x87;
  uint8_t x88;
  uint64_t x89;
  uint8_t x90;
  uint64_t x91;
  uint8_t x92;
  uint8_t x93;
  fiat_25519x6_subborrowx_u43(&x1, &x2, 0x0, (arg1[0]), UINT64_C(0x7ffffffffed));
  fiat_25519x6_subborrowx_u42(&x3, &x4, x2, (arg1[1]), UINT64_C(0x3ffffffffff));
  fiat_25519x6_subborrowx_u43(&x5, &x6, x4, (arg1[2]), UINT64_C(0x7ffffffffff));
  fiat_25519x6_subborrowx_u42(&x7, &x8, x6, (arg1[3]), UINT64_C(0x3ffffffffff));
  fiat_25519x6_subborrowx_u43(&x9, &x10, x8, (arg1[4]), UINT64_C(0x7ffffffffff));
  fiat_25519x6_subborrowx_u42(&x11, &x12, x10, (arg1[5]), UINT64_C(0x3ffffffffff));
  fiat_25519x6_cmovznz_u64(&x13, x12, 0x0, UINT64_C(0xffffffffffffffff));
  fiat_25519x6_addcarryx_u43(&x14, &x15, 0x0, x1, (x13 & UINT64_C(0x7ffffffffed)));
  fiat_25519x6_addcarryx_u42(&x16, &x17, x15, x3, (x13 & UINT64_C(0x3ffffffffff)));
  fiat_25519x6_addcarryx_u43(&x18, &x19, x17, x5, (x13 & UINT64_C(0x7ffffffffff)));
  fiat_25519x6_addcarryx_u42(&x20, &x21, x19, x7, (x13 & UINT64_C(0x3ffffffffff)));
  fiat_25519x6_addcarryx_u43(&x22, &x23, x21, x9, (x13 & UINT64_C(0x7ffffffffff)));
  fiat_25519x6_addcarryx_u42(&x24, &x25, x23, x11, (x13 & UINT64_C(0x3ffffffffff)));
  x26 = (x24 << 5);
  x27 = (x22 << 2);
  x28 = (x18 << 5);
  x29 = (x16 << 3);
  x30 = (uint8_t)(x14 & UINT8_C(0xff));
  x31 = (x14 >> 8);
  x32 = (uint8_t)(x31 & UINT8_C(0xff));
  x33 = (x31 >> 8);
  x34 = (uint8_t)(x33 & UINT8_C(0xff));
  x35 = (x33 >> 8);
  x36 = (uint8_t)(x35 & UINT8_C(0xff));
  x37 = (x35 >> 8);
  x38 = (uint8_t)(x37 & UINT8_C(0xff));
  x39 = (uint8_t)(x37 >> 8);
  x40 = (x29 + (uint64_t)x39);
  x41 = (uint8_t)(x40 & UINT8_C(0xff));
  x42 = (x40 >> 8);
  x43 = (uint8_t)(x42 & UINT8_C(0xff));
  x44 = (x42 >> 8);
  x45 = (uint8_t)(x44 & UINT8_C(0xff));
  x46 = (x44 >> 8);
  x47 = (uint8_t)(x46 & UINT8_C(0xff));
  x48 = (x46 >> 8);
  x49 = (uint8_t)(x48 & UINT8_C(0xff));
  x50 = (uint8_t)(x48 >> 8);
  x51 = (x28 + (uint64_t)x50);
  x52 = (uint8_t)(x51 & UINT8_C(0xff));
  x53 = (x51 >> 8);
  x54 = (uint8_t)(x53 & UINT8_C(0xff));
  x55 = (x53 >> 8);
  x56 = (uint8_t)(x55 & UINT8_C(0xff));
  x57 = (x55 >> 8);
  x58 = (uint8_t)(x57 & UINT8_C(0xff));
  x59 = (x57 >> 8);
  x60 = (uint8_t)(x59 & UINT8_C(0xff));
  x61 = (uint8_t)(x59 >> 8);
  x62 = (uint8_t)(x20 & UINT8_C(0xff));
  x63 = (x20 >> 8);
  x64 = (uint8_t)(x63 & UINT8_C(0xff));
  x65 = (x63 >> 8);
  x66 = (uint8_t)(x65 & UINT8_C(0xff));
  x67 = (x65 >> 8);
  x68 = (uint8_t)(x67 & UINT8_C(0xff));
  x69 = (x67 >> 8);
  x70 = (uint8_t)(x69 & UINT8_C(0xff));
  x71 = (uint8_t)(x69 >> 8);
  x72 = (x27 + (uint64_t)x71);
  x73 = (uint8_t)(x72 & UINT8_C(0xff));
  x74 = (x72 >> 8);
  x75 = (uint8_t)(x74 & UINT8_C(0xff));
  x76 = (x74 >> 8);
  x77 = (uint8_t)(x76 & UINT8_C(0xff));
  x78 = (x76 >> 8);
  x79 = (uint8_t)(x78 & UINT8_C(0xff));
  x80 = (x78 >> 8);
  x81 = (uint8_t)(x80 & UINT8_C(0xff));
  x82 = (uint8_t)(x80 >> 8);
  x83 = (x26 + (uint64_t)x82);
  x84 = (uint8_t)(x83 & UINT8_C(0xff));
  x85 = (x83 >> 8);
  x86 = (uint8_t)(x85 & UINT8_C(0xff));
  x87 = (x85 >> 8);
  x88 = (uint8_t)(x87 & UINT8_C(0xff));
  x89 = (x87 >> 8);
  x90 = (uint8_t)(x89 & UINT8_C(0xff));
  x91 = (x89 >> 8);
  x92 = (uint8_t)(x91 & UINT8_C(0xff));
  x93 = (uint8_t)(x91 >> 8);
  out1[0] = x30;
  out1[1] = x32;
  out1[2] = x34;
  out1[3] = x36;
  out1[4] = x38;
  out1[5] = x41;
  out1[6] = x43;
  out1[7] = x45;
  out1[8] = x47;
  out1[9] = x49;
  out1[10] = x52;
  out1[11] = x54;
  out1[12] = x56;
  out1[13] = x58;
  out1[14] = x60;
  out1[15] = x61;
  out1[16] = x62;
  out1[17] = x64;
  out1[18] = x66;
  out1[19] = x68;
  out1[20] = x70;
  out1[21] = x73;
  out1[22] = x75;
  out1[23] = x77;
  out1[24] = x79;
  out1[25] = x81;
  out1[26] = x84;
  out1[27] = x86;
  out1[28] = x88;
  out1[29] = x90;
  out1[30] = x92;
  out1[31] = x93;
}

/*
 * The function fiat_25519x6_from_bytes deserializes a field element from bytes in little-endian order.
 *
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x7f]]
 */
void fiat_25519x6_from_bytes(fiat_25519x6_tight_field_element out1, const uint8_t arg1[32]) {
  uint64_t x1;
  uint64_t x2;
  uint64_t x3;
  uint64_t x4;
  uint64_t x5;
  uint64_t x6;
  uint64_t x7;
  uint64_t x8;
  uint64_t x9;
  uint64_t x10;
  uint64_t x11;
  uint64_t x12;
  uint64_t x13;
  uint64_t x14;
  uint64_t x15;
  uint8_t x16;
  uint64_t x17;
  uint64_t x18;
  uint64_t x19;
  uint64_t x20;
  uint64_t x21;
  uint64_t x22;
  uint64_t x23;
  uint64_t x24;
  uint64_t x25;
  uint64_t x26;
  uint64_t x27;
  uint64_t x28;
  uint64_t x29;
  uint64_t x30;
  uint64_t x31;
  uint8_t x32;
  uint64_t x33;
  uint64_t x34;
  uint64_t x35;
  uint64_t x36;
  uint64_t x37;
  uint64_t x38;
  uint8_t x39;
  uint64_t x40;
  uint64_t x41;
  uint64_t x42;
  uint64_t x43;
  uint64_t x44;
  uint64_t x45;
  uint8_t x46;
  uint64_t x47;
  uint64_t x48;
  uint64_t x49;
  uint64_t x50;
  uint64_t x51;
  uint64_t x52;
  uint64_t x53;
  uint64_t x54;
  uint64_t x55;
  uint64_t x56;
  uint64_t x57;
  uint8_t x58;
  uint64_t x59;
  uint64_t x60;
  uint64_t x61;
  uint64_t x62;
  uint64_t x63;
  uint64_t x64;
  uint8_t x65;
  uint64_t x66;
  uint64_t x67;
  uint64_t x68;
  uint64_t x69;
  uint64_t x70;
  x1 = ((uint64_t)(arg1[31]) << 35);
  x2 = ((uint64_t)(arg1[30]) << 27);
  x3 = ((uint64_t)(arg1[29]) << 19);
  x4 = ((uint64_t)(arg1[28]) << 11);
  x5 = ((uint64_t)(arg1[27]) << 3);
  x6 = ((uint64_t)(arg1[26]) << 38);
  x7 = ((uint64_t)(arg1[25]) << 30);
  x8 = ((uint64_t)(arg1[24]) << 22);
  x9 = ((uint64_t)(arg1[23]) << 14);
  x10 = ((uint64_t)(arg1[22]) << 6);
  x11 = ((uint64_t)(arg1[21]) << 40);
  x12 = ((uint64_t)(arg1[20]) << 32);
  x13 = ((uint64_t)(arg1[19]) << 24);
  x14 = ((uint64_t)(arg1[18]) << 16);
  x15 = ((uint64_t)(arg1[17]) << 8);
  x16 = (arg1[16]);
  x17 = ((uint64_t)(arg1[15]) << 35);
  x18 = ((uint64_t)(arg1[14]) << 27);
  x19 = ((uint64_t)(arg1[13]) << 19);
  x20 = ((uint64_t)(arg1[12]) << 11);
  x21 = ((uint64_t)(arg1[11]) << 3);
  x22 = ((uint64_t)(arg1[10]) << 37);
  x23 = ((uint64_t)(arg1[9]) << 29);
  x24 = ((uint64_t)(arg1[8]) << 21);
  x25 = ((uint64_t)(arg1[7]) << 13);
  x26 = ((uint64_t)(arg1[6]) << 5);
  x27 = ((uint64_t)(arg1[5]) << 40);
  x28 = ((uint64_t)(arg1[4]) << 32);
  x29 = ((uint64_t)(arg1[3]) << 24);
  x30 = ((uint64_t)(arg1[2]) << 16);
  x31 = ((uint64_t)(arg1[1]) << 8);
  x32 = (arg1[0]);
  x33 = (x31 + (uint64_t)x32);
  x34 = (x30 + x33);
  x35 = (x29 + x34);
  x36 = (x28 + x35);
  x37 = (x27 + x36);
  x38 = (x37 & UINT64_C(0x7ffffffffff));
  x39 = (uint8_t)(x37 >> 43);
  x40 = (x26 + (uint64_t)x39);
  x41 = (x25 + x40);
  x42 = (x24 + x41);
  x43 = (x23 + x42);
  x44 = (x22 + x43);
  x45 = (x44 & UINT64_C(0x3ffffffffff));
  x46 = (uint8_t)(x44 >> 42);
  x47 = (x21 + (uint64_t)x46);
  x48 = (x20 + x47);
  x49 = (x19 + x48);
  x50 = (x18 + x49);
  x51 = (x17 + x50);
  x52 = (x15 + (uint64_t)x16);
  x53 = (x14 + x52);
  x54 = (x13 + x53);
  x55 = (x12 + x54);
  x56 = (x11 + x55);
  x57 = (x56 & UINT64_C(0x3ffffffffff));
  x58 = (uint8_t)(x56 >> 42);
  x59 = (x10 + (uint64_t)x58);
  x60 = (x9 + x59);
  x61 = (x8 + x60);
  x62 = (x7 + x61);
  x63 = (x6 + x62);
  x64 = (x63 & UINT64_C(0x7ffffffffff));
  x65 = (uint8_t)(x63 >> 43);
  x66 = (x5 + (uint64_t)x65);
  x67 = (x4 + x66);
  x68 = (x3 + x67);
  x69 = (x2 + x68);
  x70 = (x1 + x69);
  out1[0] = x38;
  out1[1] = x45;
  out1[2] = x51;
  out1[3] = x57;
  out1[4] = x64;
  out1[5] = x70;
}
