ifdef FD_HAS_HOSTED
ifdef FD_HAS_LINUX

# Build the agave genesis static library
.PHONY: cargo-genesis

ifeq ($(RUST_PROFILE),release)
cargo-genesis:
	cd ./agave && env --unset=LDFLAGS RUSTFLAGS="$(RUSTFLAGS)" CXXFLAGS="$(RUST_CXXFLAGS)" ./cargo build --release --lib -p solana-genesis
else ifeq ($(RUST_PROFILE),release-with-debug)
cargo-genesis:
	cd ./agave && env --unset=LDFLAGS RUSTFLAGS="$(RUSTFLAGS)" CXXFLAGS="$(RUST_CXXFLAGS)" ./cargo build --profile=release-with-debug --lib -p solana-genesis
else
cargo-genesis:
	cd ./agave && env --unset=LDFLAGS RUSTFLAGS="$(RUSTFLAGS)" CXXFLAGS="$(RUST_CXXFLAGS)" ./cargo build --lib -p solana-genesis
endif

# Copy the static library to our lib directory
agave/target/$(RUST_PROFILE)/libsolana_genesis.a: cargo-genesis
	@sleep 0.1

$(OBJDIR)/lib/libagave_genesis.a: agave/target/$(RUST_PROFILE)/libsolana_genesis.a
	$(MKDIR) $(dir $@) && cp agave/target/$(RUST_PROFILE)/libsolana_genesis.a $@

# Build the fdgenesis binary
$(call make-bin,fdgenesis,main stubs,fd_util agave_genesis fdctl_version)

fdgenesis: $(OBJDIR)/bin/fdgenesis

endif
endif