use {
    solana_clock::Slot,
    std::sync::{Arc, RwLock},
};

pub trait SlotStatusNotifierInterface {
    /// Notified when a slot is optimistically confirmed
    fn notify_slot_confirmed(&self, slot: Slot, parent: Option<Slot>);

    /// Notified when a slot is marked frozen.
    fn notify_slot_processed(&self, slot: Slot, parent: Option<Slot>);

    /// Notified when a slot is rooted.
    fn notify_slot_rooted(&self, slot: Slot, parent: Option<Slot>);

    /// Notified when the first shred is received for a slot.
    fn notify_first_shred_received(&self, slot: Slot);

    /// Notified when the slot is completed.
    fn notify_completed(&self, slot: Slot);

    /// Notified when the slot has bank created.
    fn notify_created_bank(&self, slot: Slot, parent: Slot);

    /// Notified when the slot is marked "Dead"
    fn notify_slot_dead(&self, slot: Slot, parent: Slot, error: String);
}

pub type SlotStatusNotifier = Arc<RwLock<dyn SlotStatusNotifierInterface + Sync + Send>>;
