/**
 * @brief Big integer modular exponentiation Syscall test
 */

#include <solana_sdk.h>

extern uint64_t entrypoint(const uint8_t *input) {

    struct BigModExpParam{
        char* base;
        size_t base_len;
        char* exponent;
        size_t exponent_len;
        char* modulus;
        size_t modulus_len;
    } params;

    uint8_t base[32] = {
            0x98, 0x74, 0x23, 0x14, 0x72, 0x31, 0x74, 0x32, 0x84, 0x79, 0x23, 0x17, 0x43, 0x92, 0x87, 0x49,
            0x18, 0x23, 0x74, 0x39, 0x28, 0x74, 0x92, 0x37, 0x49, 0x32, 0x87, 0x19, 0x37, 0x28, 0x97, 0x19
    };
    uint8_t exponent[32] = {
            0x09, 0x48, 0x40, 0x39, 0x85, 0x40, 0x12, 0x32, 0x88, 0x94, 0x38, 0x57, 0x94, 0x75, 0x81, 0x23,
            0x47, 0x23, 0x20, 0x99, 0x08, 0x00, 0x51, 0x35, 0x61, 0x65, 0x12, 0x61, 0x66, 0x26, 0x62, 0x22
    };
    uint8_t modulus[32] = {
            0x25, 0x53, 0x23, 0x21, 0xa2, 0x14, 0x32, 0x14, 0x23, 0x12, 0x42, 0x12, 0x22, 0x22, 0x24, 0x22,
            0x2b, 0x24, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x44
    };
    uint8_t expected[32] = {
            0x22, 0x0e, 0xce, 0x1c, 0x42, 0x62, 0x4e, 0x98, 0xae, 0xe7, 0xeb, 0x86, 0x57, 0x8b, 0x2f, 0xe5,
            0xc4, 0x85, 0x5d, 0xff, 0xac, 0xcb, 0x43, 0xcc, 0xbb, 0x70, 0x8a, 0x3a, 0xb3, 0x7f, 0x18, 0x4d
    };
    uint8_t result[32];

    params.base = (char*) base;
    params.base_len = sizeof(base);
    params.exponent = (char*) exponent;
    params.exponent_len = sizeof(exponent);
    params.modulus = (char*) modulus;
    params.modulus_len = sizeof(modulus);

    uint64_t result_code = sol_big_mod_exp((uint8_t *) &params, result);

    sol_assert(0 == result_code);
    sol_assert(0 == sol_memcmp(result, expected, 32));

    return SUCCESS;
}
