use {
    crate::{input_validators, ArgConstant},
    clap::Arg,
};

pub const FEE_PAYER_ARG: ArgConstant<'static> = ArgConstant {
    name: "fee_payer",
    long: "fee-payer",
    help: "Specify the fee-payer account. This may be a keypair file, the ASK keyword \n\
           or the pubkey of an offline signer, provided an appropriate --signer argument \n\
           is also passed. Defaults to the client keypair.",
};

#[allow(deprecated)]
pub fn fee_payer_arg<'a>() -> Arg<'a> {
    Arg::new(FEE_PAYER_ARG.name)
        .long(FEE_PAYER_ARG.long)
        .takes_value(true)
        .value_name("KEYPAIR")
        .validator(|s| input_validators::is_valid_signer(s))
        .help(FEE_PAYER_ARG.help)
}
