#ifndef TEST_HELPER_LIB_H
#define TEST_HELPER_LIB_H

#ifdef __cplusplus
extern "C" {
#endif

/* Function declarations for missing Firedancer external functions */
/* These are used by Solana's cost model and runtime components */

/**
 * Returns whether to use larger max cost per block (development/benchmarking feature)
 * @return 1 if larger max cost per block should be used, 0 otherwise
 */
int fd_ext_larger_max_cost_per_block(void);

/**
 * Returns whether to use larger shred limits per block (development/benchmarking feature)
 * @return 1 if larger shred limits per block should be used, 0 otherwise
 */
int fd_ext_larger_shred_limits_per_block(void);

/**
 * Returns whether to disable status cache (development/benchmarking feature)
 * @return 1 if status cache should be disabled, 0 otherwise
 */
int fd_ext_disable_status_cache(void);

#ifdef __cplusplus
}
#endif

#endif /* TEST_HELPER_LIB_H */
