/* Do not compile this directly.  These test vectors were computed by
   running the stock openssl-1.1.1g sha512 binary on a RHEL8 box on a
   number of randomly generated text strings (not including the
   terminating '\0'). */

#if 0 /* This code generated the input test strings for OpenSSL (rng seed was 0,0) */
double _sz = 0.f;
double fac = sqrt( sqrt( 2. ) );
while( _sz < 4096. ) {
  ulong sz = (ulong)(0.5 + _sz);
  char buf[128];
  sprintf( buf, "msg.%04lu.txt", sz );
  FILE * f = fopen( buf, "w" );
  for( ulong b=0UL; b<sz; b++ ) {
    uint r = fd_rng_uint( rng ) & 63L;
    int c;
    if(      r< 10U ) c = (int)'0' + (int) r;
    else if( r< 36U ) c = (int)'A' + (int)(r-10U);
    else if( r< 62U ) c = (int)'a' + (int)(r-36U);
    else if( r==62U ) c = (int)' ';
    else              c = (int)'.';
    fputc( c, f );
  }
  fclose( f );
  _sz = (_sz<1.) ? 1. : _sz*fac;
}
#endif

struct fd_sha512_test_vector {
  char const * msg;
  ulong        sz;
  uchar        hash[ 64UL ];
};

typedef struct fd_sha512_test_vector fd_sha512_test_vector_t;

#define _(v) ((uchar)0x##v)

static fd_sha512_test_vector_t const fd_sha512_test_vector[] = {
  { "",
       0UL, { _(cf),_(83),_(e1),_(35),_(7e),_(ef),_(b8),_(bd), _(f1),_(54),_(28),_(50),_(d6),_(6d),_(80),_(07),
              _(d6),_(20),_(e4),_(05),_(0b),_(57),_(15),_(dc), _(83),_(f4),_(a9),_(21),_(d3),_(6c),_(e9),_(ce),
              _(47),_(d0),_(d1),_(3c),_(5d),_(85),_(f2),_(b0), _(ff),_(83),_(18),_(d2),_(87),_(7e),_(ec),_(2f),
              _(63),_(b9),_(31),_(bd),_(47),_(41),_(7a),_(81), _(a5),_(38),_(32),_(7a),_(f9),_(27),_(da),_(3e) } },
  { "b",
       1UL, { _(52),_(67),_(76),_(88),_(22),_(ee),_(62),_(4d), _(48),_(fc),_(e1),_(5e),_(c5),_(ca),_(79),_(cb),
              _(d6),_(02),_(cb),_(7f),_(4c),_(21),_(57),_(a5), _(16),_(55),_(69),_(91),_(f2),_(2e),_(f8),_(c7),
              _(b5),_(ef),_(7b),_(18),_(d1),_(ff),_(41),_(c5), _(93),_(70),_(ef),_(b0),_(85),_(86),_(51),_(d4),
              _(4a),_(93),_(6c),_(11),_(b7),_(b1),_(44),_(c4), _(8f),_(e0),_(4d),_(f3),_(c6),_(a3),_(e8),_(da) } },
  { "iD",
       2UL, { _(81),_(fc),_(76),_(b6),_(34),_(c1),_(d9),_(ae), _(51),_(0a),_(1c),_(0f),_(eb),_(2e),_(b0),_(44),
              _(43),_(8c),_(f1),_(a7),_(17),_(4d),_(37),_(a7), _(08),_(8d),_(5e),_(18),_(58),_(13),_(ce),_(a0),
              _(e5),_(99),_(5b),_(69),_(42),_(d4),_(98),_(1b), _(77),_(5b),_(84),_(e6),_(88),_(74),_(a9),_(3c),
              _(9f),_(17),_(7e),_(bf),_(5c),_(80),_(b1),_(a8), _(f0),_(4f),_(b7),_(6c),_(9f),_(b0),_(db),_(8c) } },
  { "Fqq",
       3UL, { _(d0),_(85),_(8c),_(68),_(7f),_(f9),_(79),_(19), _(a5),_(71),_(ab),_(b0),_(dc),_(d4),_(2d),_(eb),
              _(8d),_(83),_(46),_(d8),_(97),_(b8),_(ee),_(4e), _(a2),_(1b),_(97),_(bf),_(56),_(ac),_(02),_(d5),
              _(37),_(c9),_(fa),_(18),_(87),_(13),_(6b),_(b8), _(c0),_(2c),_(7d),_(22),_(a3),_(21),_(62),_(48),
              _(55),_(58),_(73),_(d3),_(af),_(0c),_(c8),_(f2), _(88),_(f7),_(46),_(de),_(db),_(0d),_(05),_(01) } },
  { "VXMc",
       4UL, { _(1a),_(30),_(cc),_(ae),_(5d),_(fd),_(69),_(1c), _(bc),_(fc),_(bb),_(5a),_(2d),_(d5),_(a3),_(b8),
              _(e9),_(4a),_(b2),_(2c),_(71),_(f1),_(54),_(42), _(01),_(28),_(dc),_(f9),_(e3),_(17),_(2a),_(26),
              _(62),_(47),_(85),_(5d),_(00),_(09),_(bf),_(33), _(68),_(e6),_(30),_(ec),_(28),_(2f),_(fa),_(39),
              _(6c),_(a0),_(04),_(fb),_(17),_(9c),_(a0),_(1c), _(d8),_(0e),_(53),_(66),_(f0),_(02),_(7f),_(84) } },
  { "NtJ1X",
       5UL, { _(a5),_(bb),_(95),_(ac),_(13),_(da),_(03),_(bd), _(43),_(70),_(e0),_(aa),_(b2),_(40),_(2b),_(38),
              _(73),_(0e),_(1e),_(24),_(74),_(26),_(a8),_(32), _(c3),_(1f),_(96),_(e2),_(0d),_(ae),_(99),_(7a),
              _(df),_(89),_(fd),_(94),_(03),_(15),_(8e),_(d6), _(c2),_(87),_(1d),_(13),_(8a),_(ed),_(8f),_(19),
              _(84),_(0c),_(1e),_(77),_(ec),_(70),_(3f),_(d9), _(dd),_(92),_(d1),_(16),_(58),_(9c),_(0e),_(99) } },
  { "7KbaIg",
       6UL, { _(0a),_(9c),_(49),_(f9),_(c2),_(7b),_(89),_(92), _(b6),_(81),_(82),_(60),_(3e),_(35),_(c2),_(89),
              _(ac),_(ec),_(55),_(66),_(d9),_(f5),_(d3),_(e5), _(a1),_(55),_(18),_(51),_(8c),_(06),_(ad),_(b4),
              _(33),_(ac),_(4e),_(7b),_(94),_(59),_(88),_(d0), _(29),_(40),_(32),_(b5),_(c9),_(1f),_(1e),_(d9),
              _(5c),_(b5),_(17),_(5a),_(28),_(c1),_(4d),_(c9), _(76),_(ef),_(a5),_(cd),_(19),_(ae),_(89),_(af) } },
  { "UygUSf0",
       7UL, { _(d2),_(73),_(26),_(82),_(2e),_(15),_(9b),_(f9), _(ab),_(80),_(3a),_(0e),_(f1),_(8d),_(7f),_(e2),
              _(3c),_(fb),_(54),_(78),_(15),_(c5),_(05),_(ce), _(18),_(d1),_(fb),_(91),_(e2),_(4d),_(77),_(5b),
              _(78),_(ac),_(91),_(61),_(7f),_(aa),_(4f),_(29), _(1f),_(70),_(d0),_(45),_(55),_(96),_(6c),_(67),
              _(83),_(56),_(1a),_(18),_(a3),_(1a),_(fe),_(16), _(cc),_(04),_(7b),_(5d),_(5b),_(e1),_(85),_(a0) } },
  { "9xV1XEz.",
       8UL, { _(0e),_(bb),_(75),_(12),_(6f),_(e9),_(a1),_(39), _(92),_(01),_(ea),_(01),_(7b),_(fe),_(0e),_(84),
              _(cd),_(4d),_(77),_(6f),_(57),_(c1),_(ea),_(8a), _(a3),_(cf),_(25),_(77),_(b4),_(b6),_(ac),_(d9),
              _(f7),_(45),_(95),_(21),_(03),_(7f),_(ed),_(0d), _(66),_(33),_(46),_(b3),_(82),_(65),_(28),_(d4),
              _(6a),_(cd),_(8a),_(d8),_(08),_(e1),_(e3),_(cf), _(bf),_(1a),_(06),_(bf),_(e5),_(86),_(4d),_(27) } },
  { "jWxRR18K7I",
      10UL, { _(e5),_(db),_(5f),_(ae),_(d7),_(7e),_(e5),_(c3), _(c2),_(50),_(69),_(76),_(ad),_(1e),_(83),_(e7),
              _(65),_(7e),_(f0),_(c1),_(e4),_(ad),_(e6),_(05), _(eb),_(6c),_(c6),_(aa),_(5c),_(c7),_(99),_(c7),
              _(c2),_(f4),_(07),_(cd),_(9a),_(ae),_(16),_(74), _(d5),_(af),_(42),_(15),_(e1),_(c3),_(af),_(53),
              _(c8),_(92),_(3e),_(7d),_(7d),_(0e),_(2c),_(83), _(85),_(b1),_(4c),_(8c),_(72),_(98),_(fb),_(a3) } },
  { "rTC7BzywcHB",
      11UL, { _(68),_(21),_(4e),_(84),_(56),_(4a),_(83),_(29), _(82),_(9f),_(89),_(9f),_(88),_(4a),_(d9),_(a3),
              _(22),_(be),_(b2),_(c3),_(b5),_(cc),_(bb),_(80), _(cf),_(8f),_(b2),_(bb),_(ab),_(96),_(8c),_(24),
              _(96),_(65),_(1b),_(e8),_(8c),_(12),_(e3),_(7b), _(b9),_(6a),_(b0),_(24),_(c6),_(e5),_(7f),_(b2),
              _(d4),_(e8),_(5e),_(cd),_(fb),_(29),_(1a),_(32), _(f6),_(cf),_(dc),_(90),_(f2),_(f1),_(14),_(73) } },
  { "KYDrejKUlixaO",
      13UL, { _(10),_(ef),_(bb),_(4a),_(d6),_(01),_(d6),_(d9), _(9a),_(94),_(39),_(45),_(48),_(6e),_(31),_(58),
              _(bc),_(b8),_(6f),_(5d),_(f3),_(3f),_(f1),_(ed), _(0e),_(75),_(0d),_(bc),_(3e),_(61),_(35),_(1e),
              _(86),_(ad),_(40),_(ad),_(af),_(6e),_(9a),_(2e), _(80),_(e5),_(b4),_(5f),_(a2),_(9b),_(bc),_(dc),
              _(64),_(dd),_(2b),_(3f),_(f1),_(c0),_(47),_(95), _(9c),_(c6),_(24),_(11),_(b6),_(08),_(44),_(95) } },
  { "c3GYWgTxnU9bTsd ",
      16UL, { _(d5),_(11),_(13),_(90),_(da),_(82),_(a3),_(97), _(07),_(25),_(c1),_(b0),_(3e),_(5e),_(c5),_(07),
              _(07),_(db),_(95),_(7b),_(65),_(12),_(87),_(54), _(02),_(78),_(0b),_(67),_(8d),_(6b),_(a4),_(ca),
              _(a2),_(58),_(f6),_(31),_(3d),_(cf),_(d6),_(a3), _(92),_(14),_(db),_(96),_(21),_(49),_(99),_(df),
              _(33),_(06),_(b3),_(e4),_(7c),_(21),_(f1),_(41), _(17),_(bb),_(52),_(3a),_(3b),_(10),_(76),_(78) } },
  { "BzxoAvk6xpc2SxYytT7",
      19UL, { _(af),_(04),_(cf),_(b4),_(dc),_(6a),_(6c),_(fc), _(39),_(af),_(ac),_(56),_(13),_(b7),_(83),_(dd),
              _(28),_(4b),_(80),_(55),_(8a),_(db),_(c2),_(b0), _(2a),_(0c),_(92),_(5d),_(f5),_(b7),_(1a),_(02),
              _(ae),_(8e),_(f3),_(db),_(bf),_(67),_(12),_(0a), _(22),_(17),_(a3),_(05),_(30),_(52),_(55),_(38),
              _(de),_(a5),_(80),_(22),_(13),_(39),_(5e),_(3f), _(1b),_(1b),_(73),_(12),_(71),_(9a),_(91),_(34) } },
  { "FLsH3bghT2blbH3zxmq0woF",
      23UL, { _(7f),_(58),_(08),_(95),_(bd),_(ac),_(f7),_(18), _(7b),_(e4),_(8e),_(6c),_(94),_(6f),_(1d),_(06),
              _(11),_(7f),_(57),_(bf),_(8c),_(5c),_(1a),_(b2), _(20),_(13),_(73),_(d0),_(32),_(23),_(9c),_(c7),
              _(9a),_(1e),_(dc),_(e0),_(9d),_(bd),_(59),_(24), _(37),_(6a),_(a4),_(f1),_(c7),_(44),_(0c),_(59),
              _(88),_(17),_(38),_(16),_(a5),_(83),_(86),_(3c), _(0a),_(ed),_(67),_(19),_(29),_(9a),_(b2),_(57) } },
  { "t3HE1Dtn7.y15ydE.yebYx94jvz",
      27UL, { _(1f),_(fa),_(57),_(ad),_(81),_(92),_(19),_(10), _(c6),_(fa),_(8b),_(6f),_(8f),_(a5),_(a7),_(56),
              _(cd),_(dd),_(dd),_(3b),_(46),_(f0),_(97),_(54), _(ea),_(cc),_(f8),_(73),_(c4),_(7c),_(75),_(70),
              _(d7),_(3b),_(66),_(95),_(9a),_(1d),_(ed),_(5a), _(d2),_(36),_(1c),_(e5),_(25),_(2b),_(5c),_(b3),
              _(11),_(f2),_(79),_(53),_(00),_(0e),_(3b),_(29), _(98),_(cf),_(02),_(38),_(d4),_(78),_(93),_(f7) } },
  { "w5t2OIDcc53w8fwY2GMhmg6VprXdoFIY",
      32UL, { _(31),_(73),_(9a),_(28),_(c0),_(0e),_(6c),_(5d), _(2d),_(65),_(f6),_(57),_(12),_(b4),_(ed),_(9a),
              _(94),_(3e),_(8c),_(e3),_(f8),_(4d),_(53),_(31), _(ff),_(6a),_(4f),_(df),_(86),_(2a),_(9e),_(06),
              _(87),_(10),_(ab),_(98),_(2d),_(5d),_(35),_(ee), _(b5),_(c1),_(cc),_(6a),_(35),_(61),_(45),_(26),
              _(59),_(0f),_(fe),_(0a),_(96),_(f6),_(bb),_(12), _(01),_(bc),_(8f),_(39),_(d0),_(e1),_(c1),_(1a) } },
  { "VDxLNtzPhVyoVWK2DyDxjxmsxMfYLk DfFqtOY",
      38UL, { _(40),_(a0),_(43),_(ed),_(f6),_(8b),_(6c),_(c1), _(6c),_(06),_(0f),_(6a),_(4c),_(aa),_(86),_(0e),
              _(1d),_(63),_(53),_(4b),_(8e),_(5d),_(27),_(9f), _(98),_(08),_(84),_(b9),_(30),_(da),_(d5),_(91),
              _(89),_(07),_(95),_(39),_(66),_(77),_(dd),_(b1), _(f1),_(2b),_(9f),_(14),_(20),_(a6),_(1d),_(17),
              _(1f),_(57),_(6a),_(91),_(60),_(78),_(76),_(a5), _(95),_(4d),_(c4),_(07),_(57),_(85),_(33),_(4a) } },
  { "2rlYRmoHRQ8hMBr9fQgyKF9vyrYhrCLRHbsjAuwRDXdAJ",
      45UL, { _(f6),_(31),_(ce),_(de),_(78),_(98),_(9f),_(03), _(cd),_(91),_(d6),_(b0),_(d7),_(a5),_(be),_(6c),
              _(3e),_(fc),_(61),_(01),_(79),_(9b),_(4c),_(ff), _(0d),_(6b),_(38),_(eb),_(8c),_(80),_(61),_(9e),
              _(b7),_(1e),_(3e),_(51),_(d3),_(39),_(42),_(0d), _(42),_(4c),_(17),_(e3),_(27),_(1b),_(7f),_(7c),
              _(5e),_(bd),_(ec),_(85),_(23),_(c4),_(9f),_(10), _(29),_(07),_(d1),_(b9),_(95),_(71),_(5a),_(12) } },
  { "8eNyGBR30ORAgfusejk3mC.jDybK5z6fom5VyY5ohYY5qPVlR202Ni",
      54UL, { _(63),_(03),_(5a),_(cd),_(63),_(f8),_(c8),_(46), _(44),_(c9),_(34),_(c4),_(52),_(c8),_(0e),_(78),
              _(3d),_(96),_(80),_(5e),_(9c),_(a7),_(76),_(d3), _(b2),_(c1),_(9c),_(fe),_(7f),_(91),_(e5),_(6a),
              _(aa),_(03),_(27),_(4f),_(65),_(23),_(d2),_(cd), _(80),_(4e),_(05),_(dd),_(1a),_(ec),_(2c),_(55),
              _(c0),_(56),_(bf),_(34),_(14),_(0d),_(2c),_(e2), _(94),_(e4),_(c0),_(58),_(2c),_(e9),_(b7),_(a9) } },
  { "LDVCJ9QOBrNtcfcxNzoSAj5Fm92JNPd 6DyZqeUgbAxwjg8xBnrhyz43llylaCzd",
      64UL, { _(8d),_(35),_(26),_(a7),_(92),_(6f),_(29),_(f5), _(f6),_(b9),_(f7),_(b7),_(92),_(63),_(35),_(d1),
              _(0d),_(75),_(27),_(d7),_(18),_(ae),_(97),_(40), _(f1),_(2c),_(32),_(d8),_(44),_(4e),_(1c),_(6d),
              _(7d),_(9c),_(81),_(9e),_(8f),_(39),_(09),_(24), _(36),_(dd),_(00),_(64),_(54),_(28),_(5a),_(64),
              _(bd),_(2a),_(e7),_(16),_(e0),_(a5),_(0d),_(a8), _(56),_(23),_(17),_(4b),_(f1),_(1e),_(45),_(06) } },
  { "tJ8Iob tRUbKa7gvyPl9cjj0H.Xxbc4i3DnwlBnx1aJq626jiFVRI9V mCuqVR1ZaZub HM.ZFgM",
      76UL, { _(fb),_(46),_(f8),_(09),_(88),_(69),_(1f),_(bb), _(5b),_(af),_(4a),_(31),_(3e),_(bc),_(71),_(e9),
              _(e3),_(cb),_(ba),_(cd),_(6a),_(e4),_(30),_(cf), _(72),_(b1),_(0d),_(7a),_(bf),_(13),_(99),_(38),
              _(a2),_(43),_(04),_(90),_(d4),_(3b),_(de),_(db), _(db),_(32),_(9b),_(d2),_(c6),_(e6),_(8b),_(f1),
              _(92),_(8d),_(bc),_(45),_(3a),_(41),_(ae),_(18), _(b2),_(cf),_(c1),_(cf),_(76),_(a6),_(e8),_(a8) } },
  { "c7uuV6Cbj oCB KWQXofgx.QdMOyuvpqPfQgn5Bjfjewozmop2sAYRKobfUvJzZTW1Xw.buIChdMaO6tcx6x4nDcHMO",
      91UL, { _(b1),_(52),_(7b),_(28),_(ed),_(da),_(da),_(7e), _(8a),_(24),_(57),_(ea),_(31),_(e6),_(98),_(07),
              _(32),_(6f),_(fa),_(c9),_(a8),_(72),_(9f),_(1d), _(67),_(79),_(32),_(b4),_(79),_(1d),_(8a),_(a9),
              _(54),_(64),_(0d),_(43),_(b9),_(a4),_(ce),_(ca), _(0d),_(3a),_(31),_(a3),_(e2),_(ee),_(e0),_(13),
              _(7a),_(6f),_(42),_(a6),_(5a),_(a7),_(d9),_(d0), _(be),_(17),_(c7),_(2b),_(f4),_(46),_(9f),_(39) } },
  { "3LzFnapRglwpzIMbJ8EXctoh6WrerAxBJW9ZJuEOMSYkqfNpeei.doaKwmfrjTyNh6XEt6IBhjWpD8x7YIGlgOxZJqhY8C.bFLtRim1th6C2",
     108UL, { _(2b),_(d2),_(06),_(19),_(ac),_(84),_(6b),_(49), _(64),_(d9),_(71),_(ee),_(aa),_(e1),_(f0),_(95),
              _(25),_(86),_(1f),_(d2),_(1e),_(f4),_(8c),_(53), _(22),_(58),_(0c),_(15),_(a0),_(d5),_(5b),_(03),
              _(35),_(b0),_(32),_(e2),_(ff),_(a0),_(f9),_(2c), _(93),_(15),_(fc),_(e5),_(9e),_(57),_(32),_(0b),
              _(f6),_(76),_(f6),_(29),_(a4),_(96),_(a7),_(e3), _(c0),_(ae),_(a6),_(17),_(7e),_(87),_(6a),_(97) } },
  { "aEEXD5jg55tiiS1H 8E1y NAlvmjyePXt1kxyj 6NTolaU8M2YTW3rZEc80SdUyPA42j3OIP3bnwuT37DQX1qDUBqChI1p9x5EF100PvX1MDYI7SoxlMEKiIOj5W4"
    "was",
     128UL, { _(76),_(a4),_(3f),_(22),_(60),_(c4),_(52),_(b9), _(23),_(c1),_(16),_(8a),_(51),_(2b),_(a9),_(82),
              _(c3),_(79),_(6b),_(16),_(70),_(86),_(7d),_(29), _(7d),_(de),_(34),_(da),_(92),_(d5),_(1d),_(ca),
              _(f7),_(70),_(bc),_(8c),_(08),_(ee),_(ba),_(97), _(25),_(b0),_(58),_(c1),_(88),_(8d),_(30),_(19),
              _(6f),_(53),_(b3),_(2c),_(0f),_(af),_(fe),_(b9), _(55),_(e8),_(64),_(cc),_(b5),_(33),_(7e),_(bb) } },
  { "JTFeoPLehfxOjTaCfqw7S8zNEdtju4fGksUUpRvwBhKLGQfoZbMhHDXSio.kSjbMqQ6BxELZojQPBHfa5ZAyTFvOTPOjao3FawDYx44gMXgAPE i1SiS0VPmmT747"
    ".E5aC jtqxiFRErF2dNUeEY9iPn",
     152UL, { _(74),_(11),_(ff),_(12),_(e9),_(14),_(85),_(6c), _(05),_(e6),_(34),_(73),_(d8),_(bc),_(0f),_(a8),
              _(1b),_(b6),_(70),_(60),_(5e),_(e1),_(0e),_(09), _(32),_(71),_(e0),_(d6),_(71),_(8a),_(14),_(39),
              _(2a),_(70),_(76),_(79),_(e1),_(fd),_(8d),_(ee), _(47),_(6f),_(82),_(eb),_(2f),_(32),_(c9),_(9e),
              _(37),_(45),_(d2),_(e4),_(2c),_(78),_(ff),_(b6), _(45),_(59),_(26),_(cc),_(2a),_(91),_(10),_(5b) } },
  { "dPmQescywvBsp0VWULnS.judINZ Jl.LU5jEBX2SXMgVRIesVfVWEB928ua.Sl190EQ4123eOUB1crBGYNRmMtckS4AP9.mk472DFeDGJmnOo2H5zdBdQTo3Lbu b"
    "bwks3jo3.tc5WnEU2ltAfHxe0DNJnOX2nuf7whkjcjUvRAYVYXImfLWm",
     181UL, { _(37),_(af),_(a4),_(8a),_(d6),_(51),_(2c),_(00), _(ed),_(23),_(8a),_(21),_(81),_(f4),_(cc),_(2f),
              _(72),_(00),_(48),_(51),_(0d),_(ac),_(5d),_(a3), _(10),_(c7),_(5e),_(a8),_(be),_(31),_(90),_(bc),
              _(e8),_(eb),_(4e),_(97),_(49),_(aa),_(5b),_(a3), _(10),_(84),_(de),_(9c),_(65),_(ff),_(f2),_(d1),
              _(b5),_(fe),_(5b),_(cb),_(94),_(2d),_(37),_(8b), _(58),_(53),_(f5),_(73),_(81),_(8c),_(18),_(4f) } },
  { "cMYp eDtMfODExuM92AUsd2NLrNsNdeTTLhk0sDfq XI5hD99ASJS4uEHhqXv2 4QkYURLQnqVNkMsruYfiGrBnD0T0 YeGeQlAV5zJeh4LhHxdgHbt798 4xlDzs"
    "8a7e5AIBWrfHFv9KEgxsvMvXR3WuGwU83AwF1OYhRb4 rk94PpyM219LYWetnmUHLdlRcxQxYJpvS2ScG3W5cTxDTv",
     215UL, { _(69),_(73),_(c5),_(6d),_(4b),_(68),_(ab),_(2c), _(82),_(d7),_(ec),_(1f),_(ed),_(2b),_(b7),_(73),
              _(e4),_(61),_(a1),_(93),_(ec),_(89),_(d4),_(cb), _(88),_(ad),_(06),_(a2),_(61),_(14),_(1e),_(2e),
              _(a1),_(98),_(7a),_(dd),_(0c),_(a6),_(4b),_(35), _(e8),_(01),_(7a),_(6f),_(82),_(b9),_(d9),_(8e),
              _(9c),_(ea),_(b9),_(ec),_(66),_(17),_(98),_(b4), _(d0),_(c7),_(56),_(16),_(1f),_(5d),_(56),_(5f) } },
  { "mQl9H6F9D MTPTFzT7G6GP7VuT6GYEveeqDTEte1Km12NdGrT3HjQwWG6Ezx..6sAzMBJgVi1jG.YoH9TiuT0OCVlJWHMXKjFlCTjzsIQ7pcUAjy6ekdvR7YRNfaZ"
    "346diDvv5OSXC68rZnaC40zYcUb GPyHOF3yPl.iZ8aSukVQjg2M8HjpLjIE3 ZPGXnNUZatM27yFc8tS7FZSRursjpA0wzrlAd0s SggvbOT rX1fSuYHA0IRUKO"
    "IkyRhU",
     256UL, { _(e4),_(b9),_(7c),_(45),_(6b),_(66),_(43),_(54), _(1c),_(4b),_(8e),_(49),_(67),_(79),_(82),_(81),
              _(05),_(9b),_(1a),_(94),_(7c),_(d4),_(4f),_(e2), _(28),_(a8),_(ca),_(e2),_(e5),_(78),_(15),_(0f),
              _(d1),_(d9),_(38),_(f7),_(45),_(5c),_(6d),_(71), _(d2),_(42),_(7b),_(b7),_(5e),_(e5),_(9f),_(1f),
              _(bc),_(a6),_(12),_(36),_(7a),_(57),_(09),_(ed), _(15),_(64),_(ce),_(85),_(49),_(3c),_(02),_(0c) } },
  { "VXPfqVXkyYw2O.KTL3f8guAGunDE4KKwhLGNMwqYxFq7FPdxJB84GUiV.0YJiFUpvFl9sDCadLlvcpkbTIsZkJlTlClhIkhV.dSfBNzVT5ifRiIQc cuv8vS0.Qad"
    "P1zLmOrX47mDcY p.co0Nb1KEUvipvtw8M5oV1GVTBJUq7AXNoNS7VrEV5C0jDcxmKKFfqQBLfpucB.u2GwwTe3UhDJypCKyca74UNkzBz.DonJUg86k6Yp04BNgq"
    "muLmRuEKYEgfOuswgkjvj1x6rjzyzQVu4xzofkv86o1LwWtdWbC5j9",
     304UL, { _(22),_(c2),_(30),_(2d),_(ea),_(c8),_(26),_(ab), _(14),_(eb),_(e7),_(c9),_(a2),_(8f),_(8f),_(24),
              _(33),_(06),_(96),_(08),_(bd),_(8f),_(c7),_(87), _(59),_(af),_(32),_(33),_(9e),_(d1),_(4c),_(15),
              _(81),_(02),_(df),_(46),_(5d),_(20),_(a4),_(f3), _(6c),_(fb),_(df),_(81),_(c0),_(f1),_(1a),_(e0),
              _(e8),_(9c),_(4e),_(85),_(cf),_(a8),_(46),_(af), _(9e),_(b8),_(27),_(02),_(63),_(bd),_(22),_(f7) } },
  { "ebcrSLN7lJ82shVatZzxdutOHOtjc2vS5Pvnq2s0X0PhCcFz0VhyoI1bvYnfZTGWk9sr1OWv2jc8gPwyqlyhXEfhrGiFvPUzzD3E5tPozskN8AYQ 4YMomgtB2Uh2"
    "LyFVTXPyjD8kvYaNJpGcymQwEUtc2tjtB W5ZJ8wiMgCZTBMzSA53TQjtWO1OxUAf1Ic3GwfLBlDxz.3UV4w4ycabFmYK5pJZyuhwo8ve3wdGnmMEcnpgYjymVBiJ"
    "XX6IT2rXQyI.qbMbLNJ8y9ERRj hXt2tmlkninnbGxjQBLgcr4FC9NV.urXcfA5UWkY2oWBfEHO.kKAFRlLvUYC8ymvFbMbY990Rl9Fak5cNA3jk",
     362UL, { _(67),_(08),_(fb),_(39),_(fb),_(23),_(90),_(42), _(11),_(35),_(12),_(a7),_(24),_(69),_(57),_(a8),
              _(0a),_(fa),_(3f),_(9c),_(38),_(b3),_(68),_(52), _(02),_(22),_(4b),_(2a),_(61),_(d7),_(53),_(ac),
              _(cb),_(3f),_(96),_(46),_(40),_(20),_(19),_(c3), _(fb),_(e8),_(f6),_(66),_(ba),_(23),_(78),_(67),
              _(10),_(16),_(b4),_(6e),_(a2),_(f6),_(e0),_(47), _(ca),_(fb),_(56),_(93),_(c5),_(20),_(1e),_(c6) } },
  { "ll6AZPr89CaIJevIN0oQpKqt6J5suYPKhqEBf35GRLPT2MaNdVVMkDPFvCf2r5xJZLlTmKmEs3CJUTNsCbm.EJEHYaizX ejHpuUFvrZ2YRrXah6pmmgqo1Ahf9Ak"
    "j32tCMMmgJf76ipaxND1czDXz.tHjQQBT3W7I.9HqCNGD4FvOg7rbyWvDrS99VH3LKmSvAi5mNreB6kmJ Q2LAs5l32u3CJvsQRYHZKYHGjkEoAhWWv5m3qoki7LD"
    "A3jC75J3rZv2RX9Mn.IdO19ekyH52dwTkapMfoftBuwMIcwKUJBMGHdUP17HvevpOdw2xDbzWm1YDtwfY7ZoZdewaKj3rXWLrsg hYwenx7PthQITwhOTj1PT9GLT"
    "PU3DxnuITIjjYS68cK9qjSCrIYdekqVd8pONhA5TGCW1Xq8m. l2iuVD",
     431UL, { _(aa),_(16),_(eb),_(54),_(e8),_(a2),_(97),_(3a), _(eb),_(8c),_(bc),_(0f),_(50),_(76),_(fc),_(83),
              _(58),_(7a),_(75),_(8f),_(9b),_(82),_(79),_(f7), _(98),_(c8),_(74),_(1e),_(7a),_(19),_(5c),_(45),
              _(52),_(0e),_(7b),_(92),_(c9),_(f0),_(8d),_(82), _(2b),_(54),_(57),_(ca),_(5c),_(29),_(9f),_(3c),
              _(10),_(55),_(d4),_(18),_(f3),_(1a),_(38),_(32), _(db),_(c5),_(f1),_(27),_(ab),_(28),_(ae),_(1b) } },
  { "YZp0HS3RoTw0XFx2L0nEGsM6vn2NtNTF20uqi5yjW3j3AjYMLCmUXKk1qCplZWRVVR 1pym.md IVxBrPx5NHQBs307wYYtNEcrU5kUGYcEnH1OOCbx8mmb4BPFo2"
    "oqFgQ5fUDEFkAU yy5gDYA4p NBoBp1TA4A.H6hhuN5qB0 gWGEIcZX6aKPSO4bl7qfbBz8PWojfhpUr1zJzpPKYuSb70kSuV23tkMoeKczaoTwXmgwPlFsX5neLh"
    "cx8Dx ecH5wZyQQRz8p9TovLKypS1EQglcyRODQ i3vuuQ cNlxIyWKx3X NtkPaklSCPpEWFbsYVe7GnfmFWBJ6ddLNw3.hhIOP4tifsgOftuv5hVoeFvlIU Fxe"
    "19puwIigKB.jLuhAsjWQRfXCL0R8D76hZhaRJqaeXC9etXdPQ8hmaVSbcC ToUIjw8D19e.MQ38NfO0XSfpaDLhEkKVn7Gi.IU5ZAqaDgD2eMtJy.bI9NVPkrusPi"
    "GeZweXttrLYQ",
     512UL, { _(66),_(e6),_(f6),_(f1),_(95),_(d6),_(ce),_(42), _(2c),_(c8),_(3f),_(ea),_(95),_(b6),_(41),_(a3),
              _(75),_(50),_(d3),_(e5),_(f2),_(1d),_(ab),_(d9), _(74),_(4d),_(c9),_(af),_(70),_(a5),_(a9),_(fe),
              _(c5),_(7b),_(9e),_(98),_(77),_(4a),_(37),_(a3), _(9f),_(34),_(c4),_(91),_(5b),_(02),_(26),_(eb),
              _(a6),_(59),_(67),_(85),_(80),_(ac),_(1a),_(e7), _(b5),_(4c),_(1d),_(73),_(bb),_(f2),_(c1),_(cf) } },
  { ".b2FZRWd2tgg7BDrb.3BxqcNkDqXaYcXqEjRwCzqj d6EyOXlyIWJG5ZY2u26ErTn6eVFrBP0ujhbqpSxgJ1bogvetELE.JbWtQq8f5PxZDKAFqj5w5etAbH23Rax"
    "bbTIVVvKKrCosxJuOSxQe1.dtiYRalTdriwaokcnLqHtiprRaoi7.tPYgnyi.5Z16fX9K5ycwfyhSxMpEN XYRPtGRTVCJT2pR9x9G2jPM2TdS8uft8myJ0dPjRDA"
    "qnGeyc2u Mkm2oBcsC raimvwB8YSxDRfNrXuTlxCYBPnSOUngbtq N3KzzLceGF1VS0v3KU.t5Bi.6aO23L0rvL6vbzIx.gZLy1YtEwffou.SZXb26ZJie.4vwn8"
    "fyX61w8QjWBIvRuYKP2ybXwgZtG9uCmKBzYy3Hd E0tnOV zMmROIpy348fpyy7e6lHr23wB4KPtUvqxIZOJz.b94U889OmiXwI9t8wcM0TFAgyOynznNGUnOoEsB"
    "NKptYDC9.LXFiSxGFnBtPcQAQqUIGLurHwBQzU8aXJiqUEt1AblXuIWHsYLs29eY5lw2r8CKyxD ZUFGErnfDOqWlkXqsN8Xh75bzkxTpY9ku",
     609UL, { _(31),_(23),_(d2),_(7b),_(e2),_(3f),_(9e),_(c8), _(b9),_(6a),_(89),_(60),_(44),_(87),_(50),_(93),
              _(e7),_(b4),_(29),_(7d),_(97),_(4a),_(70),_(f6), _(58),_(fa),_(43),_(c5),_(99),_(d0),_(18),_(3a),
              _(9f),_(88),_(06),_(c0),_(db),_(cf),_(28),_(4f), _(e2),_(41),_(4a),_(4f),_(41),_(49),_(1c),_(f7),
              _(45),_(45),_(2c),_(a6),_(9e),_(dd),_(8c),_(4f), _(9b),_(5f),_(8e),_(bd),_(1f),_(e1),_(ea),_(e9) } },
  { "1wb0LjMy.IWN60afDWCBUSI7IEX8bRSPQTfxRfWfTUOmAsJtxi4GIk h8gdN.NiRrarivT7QYC56PNX7K4WWD.AppAVtPf.ROzKeigI0gIYjPqR6tdaDrSgxqNxbo"
    " DQaAZbt3nliNrYlE 4PrTXCP44fynwEjmv0fD8zdLsoEjLCMx7LmKp0db56rKpj0Bk3bzdrpEbKaR.u1eBusVfMdIMJQN0dKujgCDM4i23AoPbkvnnbgKi1Gp7Zz"
    "WRqVVsTTsuclthvZPUHcuT0WBkMgF.UhkA.BkfisSJjeju5CStBZ3ONWpz41HEiEuOVuXjvcXN.LUucpUkP8snDcQ3bDW18onXXcGt3iPgNts9DRwzJgdjdIfempR"
    "eYojvGZ5bVxEPFiN6Y9IP69mNKq32B8d08W48C0r3jgd6ZFOiNBSjegh9P9wdHsR.OtCiAXq1wU7YrKfSFJEG1WBc0k5MCwP2 k7Ib6hcyEpWrUrG9leOE8XmGgU7"
    "zLVwuvnLPXGA501VPQ6.EOmwXD4D1XPM7GBBOfrypULhLVm82cOOCEt0tDNIzz9Zm3mtpIRKsPZ43JwEipTR5eW81axm5MNBhdqibdwnxL6hA117kRjanwjPwRLaN"
    "991WBjTGbozLkLAXPTGH9pNBWidBx5h.MSRpjQYLdO4PsTsViNGOuUzbkQx O.8FpN55Oe2cDPiyrEM1EGZdXZMGyvYdXATAUp8",
     724UL, { _(9f),_(43),_(50),_(c8),_(b5),_(6d),_(d4),_(34), _(86),_(d1),_(bf),_(b8),_(82),_(37),_(b5),_(11),
              _(34),_(44),_(79),_(21),_(01),_(5d),_(95),_(2e), _(5e),_(71),_(af),_(37),_(d2),_(f8),_(5f),_(8a),
              _(7a),_(1a),_(18),_(e9),_(9c),_(03),_(d6),_(44), _(b0),_(25),_(df),_(4e),_(7e),_(13),_(e0),_(5e),
              _(d1),_(09),_(d6),_(5c),_(4c),_(cc),_(25),_(06), _(01),_(90),_(84),_(01),_(4e),_(7e),_(bc),_(8d) } },
  { "3H2vU qCDMJMYHXEO6vR1F rEgET5v.mcOsjAZdXNsXKob2n1tW3qbCxFK63u9g7J2aoE3c5f0K0.MkTxjVFtWwRPFSfnVK5CzUjDIl3.auxmyhP NHGu6N6bZrN."
    "aLccmX5iZy38t2G1xrfBvTDOx5c1.EwzZUoPJlynQbwygufbCI W42m8vYW8Os3Bn5IrNMwSYcUWsJ.HwAIK ExGhMAYHciZK6.JIuqMJjMtSu bOc6esQ2UErobp"
    "zwuJwuiUnIes2IUzIyqkn1v3srJVOxq EaLVceLTQxotV7GsjtHl5NIkGimd .QLqkJjbzV tXS0aetF5 PuZVE7K21NEV.ParKsay4sgzBQZKkt9d.O IFlFyni5"
    "JphlD9gCH26otp1 Ovyj5T tLsLBpjkYaslWNp8JrWyjRpLtTPYS4G.4aLgAVQzBvJteIQiwdU47HFMoDhZYCLWuhL1z3WJee1M09yzHUoiff3idTEy45rjKRsRxH"
    "5YTR6QIpiOb7.V9qbyNbsFeMZnIIxNPOwQYAygKiJBSqYPKQogauTEL2bAlTCpjolO ni08BMe53eqGKyMyTqgJHTfAmv0xYL2BkdXqj66pHmyv lK6S1HToy2j1h"
    "RQwH b03y0.Y4Cncawl..2L3G..uIJhQZ.Jo uneuqv76EF4i0Pm3qgZc.oASNBFmwODwKbEobaqEU0NZ2ZpNcLNuJySdYlXHdm7aLa IV0tUOtYTbNFIHCHnKIYq"
    "pORdIcPXGQzzwsB8OcbbBXqGFIZyX1Sn4U.hy4erjSyvdEKOnS0xwtHYLLpwW1K9h0bW8.FxZ9AD5iXJXtLJJU Mbt0xHWrtrGQgthoiKWBepJD",
     861UL, { _(d1),_(53),_(54),_(2a),_(42),_(5f),_(d4),_(2f), _(3e),_(3c),_(b7),_(1d),_(3e),_(db),_(54),_(a0),
              _(88),_(81),_(92),_(db),_(b4),_(0d),_(f0),_(c2), _(74),_(02),_(9f),_(9b),_(36),_(4e),_(cd),_(82),
              _(bd),_(4a),_(d1),_(29),_(9f),_(61),_(49),_(18), _(eb),_(1a),_(31),_(42),_(48),_(24),_(c1),_(4a),
              _(f4),_(da),_(be),_(3f),_(f0),_(12),_(6f),_(6a), _(c7),_(f5),_(9c),_(00),_(b2),_(a7),_(9f),_(6a) } },
  { "EHcDAJdRPo.XTa.L3J8 n5T0L4Nx0v FHR1hjv6LOBYfmvKA94yd4j4PzhlVDRpxc5hM8B8YISbaMHoNeiOH6JrDZ.o3inOXVRC8CuIS3txADvLF9zOpgqqyaeAfe"
    "KQO1cujwhpYvl1WxYfosvRUjvMSMQNmf I5iSBzNICf7mIvBxuIDQLJY3fatKHO.y8YKIMRehyZ9fD8XoeXNfBlGVHfiRdPaeC.QqazqXrndHgdDqC3VOGqAl.VuD"
    "Voa4S1KoIZ5BeH0gFtyMjCwI5kjxgBNr60e2VnHQ kD odro.XkZLylZbtycKsO9Nqrnn4C8ep5ANrsBhk9pSHmLThV9b2Z1vtmnKDVpFj7lYtL5RU4F4SnlWyXyS"
    "wicpyCBgg4jx2RP3xmm3nXl EyujZMNWaqCaNiB7.YEhAoFqNe5i1CmAUvH4fsHMeGd6dN1ELF0WdFDs8uIqKZDlz5j5bFQombwYnsB6IadA2bjzils0YMmjcySz0"
    "OyJ.vyI7q1Ap3K4lfeKrypPIjBcI9mcoR0frzj1mtC8lzECVo4hChYZYI2SpiWj17l  EomguaNJu0l7NRXrN8CBZ8UUCEOQ.7XKw7DrqsL02MEbYcR5EzkjGLTf4"
    "w8CEWLaVc4PrbhtUvcFys4UEKlazqBgkgJyJw 1o7d7 EIzbBFgoYE4D0ankKzwMBZQzg6RtLHCmWTBIK0C0dP8NOFmejFJJ.dScDOsLwePAsZyTv.NS9mHREv bJ"
    "zH2EAkqr.zouia0ZZAmXA.ut5CL4E6J1g2cIcJ e omI49S4F a0YZHJyTIBrlkjGfC9mGOFXTvmeJA2qdFIflhJELTKCpg04LTE2s QhteKttLk8ri1pxFZsAkwT"
    "4CiTV.0.TSlkD9vdvP84nhr9ErKSOb1NTgZk 48dEdtIKZ3nGlVmoYspUXSUP G.GGAvEAsdglDmh.ynrX8UQ4j6aqPGh15k8CJM3IFk3bGCBMZ2JV3RcRwB F7gk"
    "JF42pfllYgMPup1L t4iOAGm",
    1024UL, { _(06),_(58),_(71),_(8a),_(85),_(24),_(4b),_(52), _(b9),_(9f),_(28),_(21),_(66),_(2b),_(c6),_(1a),
              _(35),_(7e),_(b5),_(c5),_(3f),_(4a),_(fd),_(83), _(13),_(31),_(4a),_(35),_(c5),_(bd),_(8d),_(fc),
              _(5d),_(73),_(ff),_(2b),_(b1),_(d9),_(3d),_(c2), _(0d),_(f7),_(b6),_(0c),_(e2),_(22),_(5c),_(d5),
              _(a7),_(86),_(48),_(dc),_(c6),_(02),_(95),_(57), _(67),_(61),_(0e),_(38),_(90),_(94),_(4b),_(38) } },
  { "daNzGqiGJT460qMeZC Uoi038mutAIk9wA.ACu75BnZyhH1BL8Nglb3kxAZqUYSovGaZtkqkpVINBzSoLsrAWSyGmsBLUO phAIXR.Lw.cwgoCFOMg1KwPP5C5FdN"
    "wxs8T1.K62uJwlxsArqEum6Fl45uIF5OVPt08i76qVsptq0LjK9hOovhUEQxsn8sy1eSh .v5GthlG3bqwf9IynBS4s4PY ujcTTVliejNiINSpCyDGEcgXZYbnbg"
    ".wAd LLkUPqjNumbUtfS85RQ9TWdfLbCOkGPIQj fQEZpC5BtGWY41fvO4YBY3QEd xIsxz1BCGqsUY15.viweWNv6oJ6ukom NY4jQiiOGTdCVzaVJhvH7VKJAvA"
    "rBjWmjAqV8O9pT2mWEYVDGlAxdPLQsE8IoJKCVLTzZju4sp1V4dBpBCQUIEgsZQak1QTG48VIfzhTZ3b5RzJK8SEK4NzgPq8QsAXFB8 2j7G4ebjSvrMmmbqWJF7J"
    "KOoz79VCe. H.stZvnC4ASU8mktNSM.FN8oOofhckLqjvFlbRbCqoc xh0M84aEXhVEqmTVHB TQytrT1j.6txEvkEBtRYOzRbLbooSU2e n7vl0Zru5DdOvt1PNX"
    "ucw8QtfizqcYu0 NueIvAxBf0m9CaEGorspqMBF9I00c05MSyRh65 2duXkK5urRS.AZvbxeUr3FuyGCfIHlI79Pkz.q29wuwX2s1LsOP 3aTrRWSrHmcirgl0Ib."
    "SpCGKOeOcnEC2aWrousGvlzNgVZRGyiXAE5ybTNezm4vC05ckjMBdmvtHg1cyCYEnkPH5eLfgMtF5VWTGRWjKy0xrqXd33gM4yMd3jQo99E7DCsqtADMS5r Swt8H"
    "55vULXs1JkBjwrPObIA1VDgvNo.3xlFD4xtQGPws85EGXC8..VOs0p7lbihc3zK.5sDcaAwPyj8gG5GQBbzmR4CTMlMBRcdLFiBRLFcpCjBJ50vNsd0n7B7h2NNea"
    "lPxvoHT479et8TzWe9TGs2Gr47KLYMmAhez8xXz0xp3 2FRnM8GI.ZQeu2Tf9yQz2F BMOoXYG.RwTJZWzAD8WTlCtm2K2FZnumtCJVbkrtbz3zRJcNnNJV p9WJp"
    "8feMc0g.58o1MIPx.c51bG3POkh5pkMDj5R9BAdQ8eN.x2IOwEjRNrjuQ8EKU GELUVq0Ez3ODhMyzN8k55g6rJyot3NG",
    1218UL, { _(b7),_(39),_(21),_(aa),_(57),_(b1),_(3f),_(54), _(40),_(e6),_(cf),_(85),_(39),_(2d),_(4b),_(32),
              _(20),_(b2),_(56),_(8c),_(a8),_(98),_(65),_(32), _(91),_(ce),_(4d),_(2e),_(d9),_(59),_(0b),_(93),
              _(cc),_(39),_(3a),_(2b),_(b4),_(b4),_(78),_(c2), _(3a),_(51),_(87),_(dd),_(98),_(2b),_(d3),_(9e),
              _(30),_(5e),_(d7),_(df),_(f0),_(b5),_(17),_(2e), _(7b),_(4d),_(b2),_(e8),_(84),_(08),_(41),_(61) } },
  { "WyaCHFRgfshEh.oin95IaGhqFWcimA9vbeVINPjPJKijfNYmyU EQOH2kAGFl2MCoXJcQfELiAFFp7pTHJR0BDAN4EEOUTNO NItsE6DmBObKhT0d OTu263PjcvT"
    "ZA0YIvikFKKl3dChfv459y0D7pQpG27FTISew2BA9T69lopaWL9vhHS6C3jsSOoBpftDuIzK87nWkBw K R417yL1dFLFZdWcMQPfoH9gNflfon P.WOz7TTP10RJ"
    " Ems96fm9Feg RGEZkRIeoMABnY8O6GbAaKBHpRSR2 hYXlU8FUTPCupP08ZFSCALpnrrd0JFI.WVHWfcRrAhZM J8kY4FJC75iUp pP3zPrF6heu2pR7Q8ky4I0D"
    "5LJmEJWb0T7XBSSiY2SBUcynkKl23ZwAFDeOhBsGZfPKo47Aij ir65B2DqrC2JE2PvBzLaUvAiS8WQAWCl6CdycMc2YeHP lhyTHE.pJk2fjsfB84o x0bzIqTFf"
    "cJYDkbSO NwSvbttAlaMnluF2Ug0cx7pnBDsMQ11xBN00Ld8s7PinDlsseHyktZA bN8zNRC31fpQQBJYkc1vKPs0n6KdNEprS3P bywomUEyaDtfzuDuO.UB.zf."
    "UWtc0ojxxTZkRsvk5ujY6DVb spoCRmwBct5d6b5bRUy9lHR56gXetVjF5MXZVaSTUwjeurb1J0tdfFxjIFNmX0j86p9bJTjIcvnuY 5wRE5F6ChD.EQSEud3RzIy"
    "dtOgsPAIwrG1EL8SulqTXMA5aegIGQKIoupI2yOF6kkSiQWcKNeM3NXsIKen8 H6Cyd 4iBSNARYo09YcD3MZk k.p9E0.8bN88RZfw974Al.OalzKNsZHs2wzVBK"
    "0R4vxDK0LtrOwGQNN1VUQXJykSpHbAZcavo8mjD xf8oO2yzlxqKuViVxnOIe.fNve1FWoHcRDzplzCdG4BxocjcQ.PGuMNEq6mE6CKJrK.OlaI0CLax1OJDvD1.M"
    "T4AeEcKS6VroTQ5 uAKMhEIAKzi5O9kYJ9hHBwz8c5sKoYE7JLIUKytGzDt.HOyr5CDx8qVtP2xQEf.R8xOm1TOd 0D2kiwOPqeLn6HVlqu2X1JMAUVakBEI Q7jo"
    "1ae8MWVDWxPR.3ZvSpEDb..Y.ZqED3Sq.nvcmbfiXt2mlMxc8Tj6cFlSx6 NU8tQ8cimIUkI.76N1slZdQ 34Zij9xTRR7tjFtnHWSwwXY9Wr06.57QsdSNvZvKfl"
    "D9lLTDU2BGa.gggpnJG5OnBduKWLs2wkrCRBUmjX928PP79ydscxMRivoXRUiy4.s9jIGel134RXUeLT7X9yWS1md 8DyB0m2.t21oFTS3P0CbcdzATRAxWQNrpyh"
    "ACLdNvwdHksaTiM9dk7L1ANjDMod0ChxAyE dgiJHKyjpkFRWb1O4ZQ2izDgwfZA10V1p4a7k",
    1448UL, { _(89),_(9f),_(ed),_(f0),_(4d),_(9e),_(5e),_(54), _(81),_(d7),_(f6),_(3d),_(d7),_(17),_(71),_(17),
              _(d2),_(a3),_(6a),_(60),_(86),_(9b),_(82),_(22), _(62),_(24),_(2a),_(20),_(6c),_(a2),_(c1),_(e1),
              _(d9),_(d8),_(8c),_(21),_(f4),_(2f),_(7f),_(f0), _(93),_(25),_(d7),_(4b),_(2e),_(61),_(59),_(39),
              _(65),_(e4),_(ff),_(0d),_(4a),_(b0),_(26),_(05), _(28),_(ef),_(d3),_(4e),_(9f),_(73),_(09),_(e8) } },
  { ".slPD.1ejQ250gpoe6TYnlY75g07MrvgACy2MscSFU0EBwfgPjjUYbZfxjj5d6D059ePtgop icffCdhODN54rIp3tr3H5gGf AKZ3kABOGVrH375P 18xwvebfWH"
    "4Hj87IeTFOwrZuVMI7AU6nj8 67yplooJ3M9EBoNAPWJuqrsD2QBSn6EMTFU8TBK4wnp9QATBRu.iWU.5ta8drgJUl7p3sJSCwpC0Zjp .UhiMnkHXZFRbctHu5Ac"
    "o2 OtdP9NGe4qGodpOBmT.sUJVYkg7oOp3u9nbENKe954n7AWUSB42zxe5pLi  hguSrp2ptqEA0fNIXW2VOLMPc2YcmVqUmZ jiUvNmUktciwx5xbef3wzj1AMNH"
    "QQH7GxrdmF2iDB.20n8RzCmNChi126UO2iiiIDMXoyuNjSwudcHB5U2OPj3ZulqXDiUnn9txfbjP0nAETGrF nbO7Cujnao 05BdcSG 5JCwIZbIY1jug8zDhvUgd"
    "NyM53MIsXNRxoKusC11R4BlS1iDZht2d6ccNusegPm1mbkwryZHxnjwfnzYjrmtjXxddp8w0TZMy9DM3KI76BneadIstBbHD7jtFVbfS kphGQPOkTloHsb4BkRfV"
    "Ot1s5umCxl0aWHMakwAFBdXcIzCjYkefEwMd3I6qXMijowAuZoeVR08h0tv1D57qgjhQxz30giGWvnFJuSEQ6 2ZqzL8QmD7kTkTPUAgfd4 cg5X1amXZE2egqSMH"
    "vThTAZCmoAI3SG1F3f2QsMrWdk..ZfoB zYrEM98bt7SJDUtDUwluvQ mswv mjsaaiaP2jjvRclnxcJR1rgzJlPIWKxkDXZzYfmJBzB4nT DzeUYZ7tMpErTWNYg"
    "SwbLOojROpunnX9tKpkKGN2jTWbI9GXvTjjHa HxfoJ144vgei4aDeuJXLwqqoB7SeDXibvhYAv2SgE4qD3notLTuKxJnsJk XxTwWUxoyaK0apFVRxLEUqNDeLsB"
    "puceqUdWFoifXG96Bk2GZHlP vuzBqckL9oMS2Yziao42KqbEjuo5eVGTgHg3fUVCItmNVhEsvOGryPxiwdKXrl 4P83r44W32hWrEqN8jBHJheE3kQPqR5L3iO.Y"
    "Y8uPr49qRz8Ott8SDNTnLYzej40h4 A2gybB KB180hh MhjGbR6RuUlPH9gfPwPWTH .OflxP8xroT63TEP2Qh6G6KbzGc13qGGGdP7FRUuU2Gth9aq4tMXU2R8G"
    "bpVkFetT.J1fYxNHeWfql.w WqIJv3OnaRuxn60wFmVk77DnbTCa.OUw.kmny1n6QNhf70CjHq1ZCm4fXZQxpy4Y4Ricu6Pl59biKCCc.ZtRBg9R1ppE3a2amwIGa"
    "of2tokr1nmXMTkdPNHLSOOBRZ.e9kGETffcYryHXs1I0UZHRkitZDaFtAAr4Kthzw.VtSGj09dnljtP2M41cJsVH4fl6wPAGf2IcNxawbjplUNvNx VTqYL4Gv x."
    "BzjbhJxuNaCT2qkeFAlTGCO9zJ6 hywIr0RajAuUixc5cR34fps5xNyVTyDyKCC1u654ISoEY9XfO0WYS4AoqrMMdcN0PoXp.abBy.JjGTyAX4is791dPmAkFJd.H"
    "Gvts9OvBtN5HVThOnr494.Z9QnTDG6u3owGhUbh9Ku6dkuJO3yp9acYUbuUiVBdbShZT6R3DR2HghjeIFX CDDMySxCxZx2IG",
    1722UL, { _(3a),_(43),_(6d),_(29),_(1e),_(94),_(b3),_(75), _(40),_(1f),_(09),_(62),_(7b),_(a4),_(b1),_(d0),
              _(2d),_(66),_(cd),_(5f),_(be),_(4e),_(e8),_(59), _(3d),_(8a),_(af),_(fb),_(12),_(35),_(71),_(1a),
              _(bf),_(bc),_(b6),_(b3),_(bf),_(d8),_(19),_(6d), _(b4),_(60),_(0e),_(2f),_(8f),_(e9),_(36),_(db),
              _(5f),_(b5),_(d4),_(7a),_(7c),_(29),_(11),_(87), _(ab),_(27),_(04),_(8b),_(29),_(69),_(e3),_(39) } },
  { "qJtpqGFvaGbxJCuHRK9TAHOr6I3LpnTW0PS66IKN6ekEIkkhX6rgRnoq9D.rXQfUn2UHv6JX5vTlHljju3FOIcmyfGNr2DA6DafZMNvAivUYOHOtGmG2jXJdAhqDl"
    "9QgZ1MdAYAVgPEb6kcI8vsOeu3x EzG XnoQ0c.YHcViGzk.unaZoFyZnGjIiKNLau2wDLyG7aHT8ebJN8nV7tQYrpXJ6VRsFz0yCJgZoBBAaEIS RIFI3Ug3z9yX"
    "zZZb rP HvU3dhUFLVSbidasDaWAXhtS FHw5nQ6qY2QX4FadrACp72PMqvUJeQM1E0YmetzlqT X  nu2CygN91pR98Rp.jbfxHVryVsNywcM1G4rmkBKADaTbda"
    "IVBSRAqYclMlgY.nijWMKEio1q9BGyxhXi7y5YQ.l2kKipybw8CqSA1Jk4WOhzXe wTo0rVgWQFN2rS2rQiFOHo4qzrE8tWweWuhXzUQg7n8MZqJIkwESm6dMsIyQ"
    "atYpS4f.HMzfL28FAlGmm6GA0D1eTS6qW14mHXqKRN4ojkqvcGpnz  .i490TopUpJEcv3f643HqnnPGAS7FSuJ7n.5YHroA4XHSR46hygswu0WA5tQ9DZjAaikSQ"
    "Z8XGN2N2ITpvxb4f5r3eBhiHSPtbYT97zY yJ L WdC6JJzFeNGj9 ZHxuNIcaKDx3nBZBsXg90sWtErX6Fm 1yPbGjmZHx5BHBPFRLUDaRFq1JvDcVk hcCE7VBI"
    ".57lx2F3l690RG9Re5eHZr 4w5 KnmerBTGWq.JnhxVxPGG3IS6Lr4rkRMnFFmZkPscT8uiH4Y3scRRsMl nHjnKXIpTShZeIEDlPexaJQ8nTea1yPzWMVXk1KD 6"
    "qEqbdTIWntn39b4q8IrvEX hNIi7m2fgbPo3pJHw8luoz9HRM8M61ZU39njZ6VFsF9PgfyE4QEwuDTuqbUtjC32S AOrDCmbwTZRgYME1LOBkei0rwVFXkmXSgPbK"
    "gh1b QxZPDcXME5VpGBdcpWt zeMHD4Wpe5wFcYkSPEID8gxaoBly3C.gBiihXKVxQasTC CQ8t61Y2LJqwmSIkcBngRdYJNFFnvhSRPq6tSiyQ6VgSh1lgxEWLqa"
    "4H5nHmpY9AWYjdTpAFxEGfxl6bbZ54nDP.2SN2pyf1VnT6.VxRUUtYIjzgZbq9Lagvo.qTyz7bxD0vhv7v15bKrUR1HumziVElr2drQ.HeY37vm5Bu UMwiMUvcIz"
    "ARL35iV7P6fLMpjkd7jt4eV70McbBjpqSbAZgWY03l.aH7ENFkNheuWJ3kaOWiLmSBeVqqjCClyM.4De2FUnVlD4L8UteyBKJ1nwtS4Mye8whXUVG2t F6FWUxA.P"
    "kN AM3 touSf KSXTejP3yE MSH5RzmlYxIc9V4fF9o3BveKfp0O9Qgh rYT9zJT9i3U8ix85g78QdwPXXxmqfWLUbiF 8b7awVGUtHukbU6ghpR02ThroBEzRW4y"
    "rOlHdHBhF0nD 3FDCy1rLlq4H1EhucFSTtOgQoJ.Ax D.hAWlBWDn8BYqi4O7ierER8NbqB4.uinl24iR8esy9ETu2DKaLEcW6KuPrZxu42vxEADldzUEcZWce2nj"
    "ZKxdV2iSLFr5.nB9kucU3eCCbeoqhk 1UErxJIV4Rrq.W3Z5H09n2 cK.vS.FE6kFHWXBGkA0oL1PlmRQ4peFBUidxfLDBu5vk7lG5VK0UK87hdr.gQQFewe LQd."
    "Tbc1mZJGZbfZ5HVB8fMzTGYl3.N vbqnX99GAZmOrgh9VdNaTyWYoSGDscBxf6A70ltZXdqUoYEIVBVMc5IpLEp72C0yqVvfNZZYgF5vogBFLyvpLHFet5YnysSoz"
    "b53XhDpTyTgDXi2u1ZzBYUhdhkIAB9JGENjSfPujpvvZX1CEl7.YzjjBdCtK.gZXJ0CUKiG.aLgSjpaW8YrLVgTMpRnCZVvm7NG4QfHj1ZCaenw0tslr3jnWW4IEe"
    "tHcdIWAUHbfAHeqtDF cmvSpcPcJHvLg5bilLFxeHEXYlNBi",
    2048UL, { _(3c),_(2d),_(58),_(ae),_(a2),_(12),_(85),_(69), _(f5),_(f3),_(f8),_(3f),_(3b),_(94),_(4a),_(8c),
              _(70),_(07),_(31),_(a9),_(76),_(77),_(55),_(ac), _(ee),_(3e),_(21),_(68),_(64),_(65),_(45),_(1c),
              _(58),_(dd),_(51),_(63),_(c7),_(6b),_(ab),_(2e), _(42),_(c8),_(79),_(92),_(14),_(61),_(fc),_(bd),
              _(1b),_(3b),_(7e),_(b3),_(5a),_(63),_(d0),_(3b), _(c1),_(72),_(95),_(ed),_(e5),_(77),_(4b),_(cd) } },
  { "f4fXl d Hbgzem1KvhdZuxIB6rv2ZpcI1RQ.upbyLH4ow8nLJO35p25BJJf755.5FiVIdSFVUVZZZPQxiO4Smj7drKoQ5nNaDOpzFkuLtKkDQsTYDziHObhjifWfq"
    "7UNh7UcYQbMlus24jk4IwAQm x1KIFmRs2yfB489AJ zpBLH Di01 5eP0AzGF7wu53JeGU7bGt9K8zbVJRJQ0e UhrTxr9HLFYtjHCXN6 m3IBfoBr89Ix.2CjKJ"
    "9EAUw5VxUKRgAP8xz0BR9.o2dN PRtbCtIAkyf8SQdr95hwdnk36KaDwXGGwIW649o0I sqPIDVRRMYgl2imunkzSFfXQMhtpV4ZhHMgcuiFl5LM1OVV40 bDmFUi"
    "9XSluUcRtbsNRyT9Sp8eAdtWT62aj87qThijGhPMVxCBhTmkyn8EbSMkGAdmfJGRQwMUuEqLgyzM6WR1lKj.o6NM3QetccW7KAPg6TTvmek9zQHuCvtJyD.o4aO0D"
    "mafadni1Yw6aAmF8Rdf5wNZAdExhq.45dDAUeeW27H7qDXKILirSQgKYG.VLPEMcA4wLFl2k3BWF75lhCqJmffDK 6PQprOkXREkG76HjPOmHhpyDFt8J0YfyVlmH"
    "ucdw o cC5.d6ghy 3OFThFEb3ppV7Dk2BDOiyoZ1BwA5.LC0KBuOYiUBkBsbkU4QOgnQ KklW3UezCyisXoA0pOjLDTk0L3V.sBBG1asGQOmtqSv VSOwy0B1Kzd"
    "x2lxu1byE cT25yCMQRUAzDzKzWFQ8fhLFJH3bflYTWggCkJXebdFBxwk MhdNH2k2UwuIl12pAzxFk1numiQvKWM14a5wCSo 8mj4FVopfcPQDdDY89ZUSM0WKer"
    "kN7cX1qu12IkxHkN5845fgLq5JlW7oM2GP22AxA.1510.1pr2cX RSQckHuxq38vryvIrN5b6J9tfYPAIXJFD7KNbsRaykOiKDMUvU5Kit3jbekAkUeoGtKrIj E9"
    "rZOmZOE3GlCPnlPaF0UrDeeFc8wk7A2gT7fkmi8431nIbElXe.ffhAduET3fpjEzLVBMKgHqrEMxQfczFS83C9XrlLVKilod.iJXBKLTJGDPf19p1BZXpUVq94oeU"
    "rA o3u5536NEd1vIyF VB2KFQXr1yz.aX7pD.7A3veTdavPNvpjqBqwbi5fa3wOEK1HMlw8tOQVlE3lGxXUfO2tfg0Og4NxWN3ZtUTXlQYaumDfB7CvPfxTMrGSvJ"
    "AratOpea9lvUvXEf9ifRSB uvQF2u7VT3UeSPhvGoSx3RcVB6ZRQQ22tDR qbkxnbjFY9GKmlOSNmpjdCKoFFqW2eVMe5iA8sICE25RvlLm4zaBOsEd6nwFsOfpNG"
    "nFLbRRDQJK jeM3tiS5Zxz5JYqwQ3Ld1U3sQObb6stf3YVy8qr6MHQrd3UXyNI47QCu.nABEFCf5Y 1sT67MiWrmiCRrCtdeVQJvmnEDo5FHoKvi5vdnIyavjMtUg"
    "h48x4mJVdaMKVX19C8JM99mbz3 WLtdyZM G6pAUroavCD XgNQhlw xkSKiNhAYmSycSW6wjjVyxoobq5Pgq99YOiyVG2l9QzKyVX2qEuJM7cdsMdcrw1SYdB Fq"
    "or9q23tqBNMok3MI6gJWQ1eGzqCdcbvV4GLOeN.qFKzLGExvVYirpLN1t hPpVlQX5NyFu7yU7yKM.JOT4DrMtpD47vajkCMOSJFvaomHeaJeD5y6fH21dYzGRKK2"
    "8d5zevIquueHqhGlauOR6sBlv1P1Bb198Sysbv9h6.LKP1tgOHqcUxzznTXtevZSIqL8H5z9WlBN2XBxq PF20W5McKSKiRT0gOv6tfG3ofeoq8JEY4N1RZAcPWA0"
    "fz2sAoLQF9NEATrHaxyBsSm7O2k5GEHUU.awyjaQ4C.qTwq1Dc3I0ptt0fO3nwFmYKvYVC0PZuNM7DLbTkPTEcpHS4Jp9wE.olPDOdqWoCYFGFU0NzzM9p4N8vsXH"
    "pcHEeoxmewyrW CjlMAEe9OUrM7NzRJbS8kmctCIXD4juvnYNBHi1tq9cAzmtsjCTIL5WaSt4LVzXr7QR6uxCmZwhDU6Sc7YA8MQvLye.7Xt1eZpQ3B0O42e3aAio"
    "sfQ376SSW0z13e1XarID43DfFaOcErW.feuv5t8bYGSacyu1vTQuCldByl8tAFoHXKV5mZuqiyDY1Wb.UbZQj1pB8vKuLYsPypxBDbEoRASvHJzP0u0l0Maq6csce"
    "TNxbctAAysTWIy59MJOcoD80t8qmlg2UV3JmKk2p5os 99QKCr2jmgtB2SaoxfDX0UftI8.f5MaS4tasHiQS0L8nAPIuAQVc83VqTXxpyhY 1wny 7UvQhuPzImAd"
    "6ZBszK8vQwfo5DL7Bmmlb4n7MmoXAh3HFda6Tx4RnDBX8w4RucEaLHUDQZAc",
    2435UL, { _(2c),_(bd),_(20),_(77),_(d8),_(56),_(5a),_(52), _(e3),_(89),_(3f),_(0c),_(df),_(a6),_(f6),_(73),
              _(d8),_(57),_(ad),_(51),_(79),_(47),_(62),_(ae), _(06),_(5b),_(6e),_(1d),_(50),_(71),_(40),_(36),
              _(57),_(f4),_(23),_(f8),_(55),_(4c),_(e7),_(fe), _(fc),_(41),_(1f),_(ce),_(22),_(c3),_(ce),_(50),
              _(bd),_(42),_(29),_(41),_(0a),_(44),_(a7),_(3a), _(c8),_(b7),_(c7),_(0b),_(de),_(de),_(bc),_(93) } },
  { "yVzRtPj.17eZmMjy0gUkG8E1Wa0AF.K0SubfN6azLeLypFuEbiRU6ShahaJCb.ElSjQ9SpQUX EyywSksDZ 32AKilxKggEp E93hxcxlJ7rANkPiUfuVrwflJ.3j"
    "xjjBxFDG9RUgzIooOT8yhiO1xh5JDTiWYWwoq6P6EdJ9DW4tYvMGNz2pmLKxWv9E6dV81iVv9O0IIE38Ua2j2xrycNUDxImnynHeXvJLW0.c3VsE2zD9R.fDdwes0"
    "PDAHC5j31JOJFfpAWtwC6PCh50NU6jcEjtaHFLIwLwZaiP1KmAQET881f4yZOE9taL5Envc8VR4xNnlUEyk8EXD8sL4iT84rSvfqdhrETUcqQhkV4BPC36 VC6c9A"
    "vypgl1jBWIeEO1qlftwm4iiy37rMaCIXmq20gV4dv6RL9UL6xRIg4jFRthnqXPD111wZXueM5fjSaCpe pLCvV41QuMEWTzQgr7GfPCd3HBp9BPryYccGptALvgU2"
    "aE9QX1JFKU2uHgzbYuqmWLfpUEYFhZvo8rwX2xk4bzKKfs39XJknRKkvB3xuvU2mCGG7lgCnmSAD1q0Buld0 VOzWA0ZrS9ntizjo1lLdL0tR.UAefc3hjUTdOCHZ"
    "7S.LCJgRdoyhWvt wcC9QixQnMvUFD0zPUlaPhclzEHp1YIQRdFnfsPHAwRd9Ecb4Bd8eB504Y1IlIpd9329c 9NLTzIDmsIvCRlC eF4b7lQ.2z3w1uB5mLChEyN"
    "U5A dP8f3XaqGgS 7ZHGOzjP5uRInQjxQ5rmp3vPl2NcgZ wZq4WfpDn68k4ekL3jVHSiubCqa9EBmYa4QScIOYOE0dI7kPJnjW6mVt4cRBP5 gIpX3JZt yCGizV"
    "LdBEtFKvTaGOWiGCJMf6NrDRxN oVP9nRvTU .yZ68XlGq3Z5eyNIGAcs6klQC39PT3DW6xgvLxISoOsY2FjMrqy8jO.5tjIf42m6vRXt0JaJnWJt93tGG3PcqsTK"
    "F4o83W4mloDXjBMW2V9p0yY o7cUoToZm.oSxopz9qVU2igSviRy87kvQjcrheH2AnjHpODgBk59ebjMYIQxwo2XiVQMVI9V1 AUAeEitMEolIL1EZdC7aRpurkG2"
    "BClr2Ks1UE3m4.KyTpNtXDjCqGRTdqAeL3isvl2gFO2F.jci6ROMCBgXdKYe9xozyvWIyrlt0WNDi9aRYR.8FtS HgK08Y hkK3JBGBUJEXq5znvGctHrdswpLI8j"
    "7O.8BGFttaflgVODdL1e5iWmllDGebWcmVtFnSAzemtM2lCpA.vzyu7c0cXxLZ1qEVfs8sMi4QTW91QKXd2bRUozYP3mXZMXaNAlgUdAdaV0TPZf8nsJOhZTMgIze"
    "3fEBLSokbPmks6aQROEyRKKTV9O1FJ9dPCYQDYhfGrH7MIgfluKo1NSK0q28FwMW3i.BP6CAn4JmjRGQqPAMG8oeCNECCR5XEoBn9bxCyB9.PPpY.nvbrhbbUGJ2I"
    "KbuIvFQMtFw FB3VylJDkTAkMxeeZ81lqnF.Bo9Y78xvYDm5rvojYaWrAEbsHTBwy4X7g4m1EUYnI4vaR8C2XPiEkwX5A.Fysx3VqnaX0rcDYun5LRbRmybVBJLkt"
    "q91VCuPYokJ7TVCxMKyynHkeMhm.NEjOvL2PT.2VKbFPYJ1u22vxUQqTi lXYECO0IgsV23gg2 ryCU3IpjBRDbIZJDBGA3sBQe.tN050tderdElp0mmoPFt1lB38"
    "4iYdHqiz40KxLlEXWArEbbT nGgKD37Qvw9FFQfVTueqYvrvJ6929FGAjVNMy6J5AbJEn6GFO7znbvPg2hBbpYDd98FCNjzRbNmsmsyRbiIhj5zb9F5TxavtiM7uB"
    "UYUIsFX FCrxckh3TEAehLCHuwCq5yBDULZFfOjw40Q7RatyN3.S21d1Id8LGtFkF4PT4GUKnd 9ITMVj28s0k9Z1wooQmtR0v0WcgMy8TqyW8G67jR0RgEhYURyG"
    "jxgAEWHKd774qsGDbLnvrkflljARkhAqTm1b5mjsNGDq9xm1NX0ZvM70kBbMFnfNpLYXvvWIvwOtkcAS6kNBbKTsa7ZVf2jk0qpGdE H6eihMWyxutGqUYFiHZNgy"
    "z.wivolJH lpmJJ08iUFpUUdPPf9SyRobvKr1zsOfdckZO2xyBG0VBX1V2HhDoke sRqr0g7tAYxB7KcJsSQ3r1qZbxvCLiqt2tOo Ec0D.G4cCpLwrdj x JOX.L"
    "HCsDyoFFJ7CEAUSvcNy49AYkI3uxUOxbHWdCovVrn2pFgIqC1UYo8FUHzDq0cvP9EqZ5UAGdXK0zRRbic8cfFuzDotyVy2GymiUXnKcXSEhbDk zJ6gO8lUU43 oM"
    "e4P57V0Jw2XuL 3r3Y8SiilV9H82dd16UYSr8UapqjQyO.MCd7vCunZIuBK1OuXo4N2.OduHy5ax33igzcf fVFnSyqTETkkMKBVjJWVeyWx0OtEJKCL8JgMd cLP"
    "TU4MKqanEcSImZ4iDiJfBoGwNorpkE.f5XSA cwT5yXq49ME2OM.aRxI0iB BokWAUp19wjQrdh7Fo49zKHiX bUfYeuaPBF oI1CjQ5GM5LAEpmJg7vHsu uiJWn"
    "L819cuq04UxDa PEJ93e2I4evrUc4C8Xo4HLQ7X7arWWnognV8q3sAc1QzTqVJgZJwI8q8wKB9gJg6RoNlhekx9c8U9FONfbYrJT8GdFxHxiVhjd9kIITEDkfnlgp"
    "UqkDdSJ1edXyalI5nDdHFnLL52LSo8gLvIdSpenTou JOBNkovymhTNp2 27DFp9o9DSZyQXEBMJUja2aJk3vFJ uMwQYJBBlVMSiS7vJTc26tcYEo0F0rvdj.V1y"
    "cSYLnVow vMdTQ6M4h3Ud",
    2896UL, { _(7b),_(72),_(9b),_(d9),_(53),_(4d),_(a8),_(78), _(36),_(52),_(e0),_(d5),_(91),_(e0),_(b7),_(98),
              _(98),_(37),_(7c),_(d5),_(0e),_(52),_(ca),_(ef), _(e9),_(81),_(07),_(d6),_(b7),_(4c),_(b2),_(c7),
              _(de),_(5d),_(79),_(82),_(f4),_(08),_(44),_(e7), _(9c),_(b4),_(cc),_(89),_(d1),_(6c),_(3f),_(c6),
              _(86),_(8e),_(b6),_(d0),_(36),_(8f),_(ae),_(5b), _(0d),_(8f),_(77),_(f4),_(79),_(a0),_(1c),_(dc) } },
  { "n8to4sc zBazWfisknLAjdCso w7WbNg.xm6fGFFymzY1awSjmTRwDyeIBiPoD2Vgh FOAP0jDpgyIfS8L06NtPwbdPlC2dhy7ekKN02aaVPWPwe6Ex1HC4RSMP1q"
    "wiGLpOYO3nsdhCJ820yjLLmXZ9Y88VdPdXEFNfPp2SJeyOzsBbZfVzYPzTss1UbdQ20tUB45TR3gcAyJ0xnpjhUH1WHu x96MOzEwm2qscMahHi61gE8iXjgJ.0MR"
    "ZFX7XBjywQMHmfYyn4oa9lwFDUhBiKiohmFWtWJjnnXGbfquJcZJFqCGhagtd6STIyCrlg0 fPsBKdeLdkiyttTILz6BxpHSWot5jXvtu4k0Lielkea1IB2sognZ5"
    "wSeyNpHnm60U2orvmMxqRFJEI1wHl fDdngrhBRRoyruaicZWt2jVdgfZUZ7v9lVc PWDp0VH.kmgB9yR7BLTIFV5LpGVF7 xp5bfNbmfK1fHCBGsB5QchnLw6x8W"
    "0e0hpdxLWd24cvF5w5TmFX91vpTamjMSHVoBT3wKYdTs67tgXicAV8zAeYjP5nffO76xG63J5yA6LKnt6uwWcnxYIUCS8JzIagoP 6gA47GAMByihF42FFFw1Z8qq"
    "XW9tr.Cuh.ci pfAu1  0ZDHVMBpva7CwXnyBDwmGaYJTrD.SCu4A.FyhByjcMyuwR2u4 qLx0EUA1ZTKzAYKvze.o qGkpiCb.vysHGMBkJZ67fQsK5gbv0er5qv"
    "uVCN3nTkqLBXs6d0sniBspuoeaLl7UHTZ yty6.X8XN0qxWufzYHVb6iRf1SUE5Y3XcRjX2hPuvLOTSp tK8UZEmG5EAFfusc3vooczUoRz3QD2LyosCf4Q xt4VL"
    " BO.pEvh6cYGY8PIocsfiDMSCVwWZ2maggoY9NBdci1pFruRxgg.myPw LA9799em4nazwEckowBHr1qkVhJpiFK 7gZafumYzJMCnCd5h0XGOWHgb0iJDbav.uIj"
    "aF4JG4X7AbW2UY0Z 7LiZOb A7t2mlqDoOUM6eYzKh.gXYxcM8GXZ7OjDRz1pX2qcs2FCWX9YPWrM2pxlszZE3TS2WW1.bcuDNcHfrGcyuRgOxGwcSWVkqddczBK6"
    "kjw2fpXATB1cu81LPk0U0rnnMsQ6nveQOmf8P1W6VIqBvomBWvKlGsMjJdFnzMyTDrbXY0I1sM7YIdauYJIICMnWFe7ru ecuijUCPhxLIXCgUj030wH8wNjnYulm"
    "G4.h3mrWZyYVER9GNE.lpcXnCmMmbuZ720DqVzobQXlKfsCN RUWiHAWf 0O4lWD6m1gCv.ViuqjWKIKgflsl7NFxrJpuClJg2XywlGS68lXNLKHAeNzf7q46O Nq"
    "vSVELogVuCK9jsvmGBatT9STIHoDgMXMlHk64ccjdwMnRHAeiLwpps8 AKQM2SRDULSptqqBJtKwfXPmv8SphYhGixWsoYwlqb7SlHF aDX1ClaC3MNgNePLzDd1Y"
    "rEEcje ClIxq9OHT85PTU0i 4QHiut5PSCHX4e85 dwVq6U5Yn9izrzsL5dBFZIMrKnZrpEbP xjv9IAE9SbFUYkfmBj9VtwUu0EeSfm5AXOdmgslLMHRvGK5d1sO"
    "ROT4U9lgUwAqibTpAdtWgEB.ut6B8TwVP7teTLgwHiKEHyEhWQGvoHTwgyMXKLOojLbfHdUEH86 lJ70cjxYYtWoDLiuVkG3O7udCrAjDvYCvcyEL60vCVIZvAW.1"
    "3db9cB36 mST KBFs5XsTOVuQqQdYl5mAAHpgn5gTKEcocrAOEzE3j4pyyQrysmWhkcMIHRV6GIG4jXRvlz9zQayMIip4AGImjkZdi8WJVUMNFTqk20GGMG3RxPYw"
    "EtB ChVMuOggUwq7aMbPBJV3FjeoRuJkrmOSp0uz4lbWuznlg2N80zO2 By0cC.san9od mngGb2DRDy0cikLs2pUM1XLbTPf9BVQdncbiZi.KN9FmQxMCV9nLl2a"
    "wu.c69cQsQEOpRLOea87m.ccTizwQJw3W60FVL8CvjEKYLH U7ddFsrY bmFYNmQEQUXGQcZY9XfF3r0vvR Uaqp7rgdWpVR4tnlhuzUq1CMX34C4dImyqem YV4R"
    "hB5oxObgmCMBnx5Ai d4S36PfF258i.WBEejSkSM8ftAogQ2sNuu0BNP8FftJ l5601sWtEdSb9JZRoqCP VHELYWDIGSN23SlH.TpK9mzGCPVNNthK9MIpfJzWTM"
    "qhuj0ycc3.TTD2hVYBb .NnsWcL5jeRveqg9Vtn62BIMab.1iKXv12dUMTMiOhK5SnmtPhMtqJbicfUGJKhJd5NZRrpIn4aE.zCPIKcsAMeeakNJ7E6oMnUj tIME"
    "NEOTF2Pzp93FC.8kwRt9SsjdvwRXZa8S7zffeb5gCKmxsoNK5f8b hSw4bJEfR.Hbif0C4mwJC20 Vl3ZJisk4pv 4XxbpMgQ2hdn4rVFhvHpm2V5xtucAQGR4fDd"
    "PjvfskSl1E.DnsRI.0i89PuDCeIPJVLDjY8TkGiDbXmHPiiBIrdvtl7LVMXkG7vye2AKfreSqsh0fZTesk7Nnvt7OMalse.Age rmi1mLo2yf8tssKZsQ96npTu7f"
    "KU aOqX8HJDJ3tjkDUCe.eAZW09OCmUUJcic5sKWBG.gN6Ir zzkZn4fZg24pbWfr3Ijfw38ehQhBJlQkonbO6ZOXfCB6 YvWia62NiGO99Hwg0tELLVeznDcMLiS"
    "tL7pU5EZvrqic8aiqAJC5tLs6IDM3SDm Eu8EOPotbLGtgeL6Y916AA.tpNYD18FPjKzQinybSklJ Rixtp3IZYLdqaKIL9Vx2ktNcDnddp 8YGum07r96mjZZ1Y9"
    "hL3Ua6Qk2jwkoRmqu8CA F3Yy8HgM3t.ZFxEJGDoqZMbYpAedRoHcQ9 YtsXDo3.0cyrJ0WmMQxqGYTJvek7oTjzgZnaT.SNHONdSA8xH4MGznX0WIM75PYxvnlqT"
    "f daH5uE8kWsDDkQBu795kdDHgMP3.qbVpg.nXPfSyR6lkRNXlbwu9Q.FrXY8XvP9Bc4uT31VBdB18isYG5ZpGVlIu oNIPhBLRiKsFPgPtUaMzFoFnN63Q8W4vCn"
    "VewMKkyEcMYJBgPRt1gBHyIrnD6R6JlT.xa0taQFnytEuXPyyZTS3 T0GPWAQ1mMwqTC.uSvwSRVsLfmTvGuvXYf7cEP.AELTACBseVzDxWgRvkHjC0RPVhH4x6bw"
    "E srpcLOJ38Hzo91S.7nNlPt30UeFOcubXNHSu5LfXG6AVQCbCXvvmG2 uhpXrKjeVkA1c9T6Esrc5IpMbNMqcztiEWiC3cN5.YCMxrMb8BnYLK4SEM3PuOWfq.o9"
    ".e1hqcDXFbkMp2LhCDrreKQPuaQt2oYMbN6ErE570DMjE3oz4vOV655WBmEtMTmwjXhZp",
    3444UL, { _(b4),_(bb),_(ce),_(f0),_(90),_(07),_(dd),_(8d), _(91),_(bd),_(f5),_(a6),_(84),_(3a),_(73),_(e6),
              _(1f),_(bf),_(bc),_(cf),_(95),_(37),_(d5),_(54), _(b4),_(a4),_(db),_(64),_(8b),_(9b),_(bf),_(dd),
              _(fe),_(d9),_(0e),_(dd),_(63),_(44),_(8e),_(66), _(e2),_(06),_(4a),_(78),_(ea),_(ac),_(84),_(1c),
              _(6b),_(2b),_(0c),_(b3),_(58),_(a4),_(74),_(e2), _(58),_(6e),_(ae),_(c5),_(bf),_(32),_(dc),_(b1) } },
# if 0 /* skip due to pedantic language limitations */
  { "gWiBgQgb4tlBXu2 R9mxJ3QPc6uhARweI2NxW3aenLX1Qv kj MHy1okscc8HfMDBujAhrcvdDUxyGfMAH6Rcx 7zc8thdHHIgRE6gOYGpql1qeNHdQjibP8LgqD3"
    "G.OdZoLkP01Qtv8OaRSI7NMbCBhucFC.men4.3bQHCnAAsxGxtaoQ3lQJSWwc42sIY0m5.ssVPY798GgPcRMLn1VeFy459ikUhVTCjmc XdUnfBSk8j1WeVrrgxYZ"
    "6aiaMaOcqzbUb4sYtMyUJon.Vbn  cGJf53YHCoB4glAaaCMaL6oGnovlFWMXx5aYm1aqzvhc.W9yegrZrU H3Ve4ocdr.P2FJRISEEs5ODhyO4RKLaWjt7mZPKKe"
    "E8Eknr40V3kSsX3v9TSfIwjBItctZEtiI0lJZMO93ttALpxnD0H4M2s7Z.KaYIqFyf3apcNnVVcm leCunV5ZfORkpt6fpYVWDyIkYi7Nzcg1Ybsgg9oz0jElxkCM"
    "WOqq2yFtofsN5AouzOJCjQ9OUeyd0O7GpnJw rv.M21GwmDYnfaQ9wqEs5xxIREPHMtwpgWjdVkFT4T9RL3aRtsrnARipGjSoBUFD61lLy8sZjh.rQmgz8oS6ghgv"
    "6t.WNIyUyPFlsmrlH3sLoXHNbvCKbRuwp8F0Pe97Ac.RgECbhS7qOSQTgVQW4KyntE9 m L47j8EN etygbkEYlNsl74U0lexy5j8lju7tH7DRnAWr2ATQq7nscho"
    "7r5kyxVyDMXV3SRhuKMf4prQhvCRbWfHxfv7ggsYkHP12pWlu8sGrxAnV2TnXXPRz8eUAZvz.sYmWQnqYG5a3vhjVPstn ZiBRI0hXoduStwEOFH66qRILhcYetOt"
    "2byi7.hw82aFXyTGwdAfG0D5rjU.RSiUfx3C98oP5wIjw2bPjOEuue3pQa03JguysDV2Lwy3nwMsORENnZX.YH.2mS6VrM3TKPBAAgbD3GDaDg5kvdBMS0erEx6ON"
    "ezPiyQC6sVVfKTtS0d3RJXLZLUWMb36RmsaiAhSltkMNjAVsmSvwbk7hAuKpltFscts 6Ho4Ztl3gBNM4QPpng1xcuIWJm5XkBbzKfPfFlMaUwkfm0CZcAXN4sMJ6"
    "b7h2rQgQ0e.W  LOogyrsGXenTaH5El4qRJrNK75G4qb THWPw9.YH1uuLSQ4C. CRt82iVYX0inNVyLzVBq8mxgpMJCrhEmVgOsLWmc.QtV8 Sb7 jHG7ex2Tame"
    "BN3spHQhpc4AYMowa9Tvbel2g8aFwBaJXO7PC57oSJ9iZXsApaqVWFSwYPdic8CDUX7WW4.wmvSPF0q.6VV1j139BhxkZ3lkt8ygdor1TBY7kEQpWGtRAlWenIAl6"
    "v9VPiVGRBha7dWT9ZOkggFjy21XYANI.LOL97qVL95QRBLvK89tHhUk.5q6b4nivVHncgmQt5yvGUPATB83DAuIixduXLIuzrct6NFeYm9kFmYf3vEgy 3eb5eFRa"
    "CnnnlrL0ov3QS1VezPtjc5jaQ0C1Q18lmWYemOP ONlpD9q3ymsP5yBrXJ8ICNd5wRjb3sCspU1UTPW.PJMor9RfDAedxqUmOFH5TnQA7guy95AM76JqVc29CFfRJ"
    "F8oitsDGROF65QlDA vnsMJuFBpBhxfOtI5KY EQbPkUSuv6tS53y 0ZVZFEYlWfjsjKxNv9w4y7Fn93wxfcwZBOUr1MiftAXBzHaVy.JWCDKw 0g O6mz9A72oyA"
    "OfFZ znEuPV4TQ5cX.kfKjwhw0hB4G4PW1s8Qd0V A591aS6IjSHySFUvzw4pCU6jyZ8xLdIv5PIKWsLaWcdsOOQ7i vSfOXda34SjbsxNsDd5TP5GZ8vCR6lGONI"
    "wA2bDF4OEPElA.xsPT5RCdcy53FedQ3 RasyAiFZkZ3bffJIvmctACZXBhZ1g.HaRfNzrBzLh MMh.67ue4onxNXuuschk1b8E2xw.pEe0t4kYWTYoVBDWAu4WYy0"
    "14WxKYPrvUMPwdgo wWRkLWldjJ78gTfY5L8nKhggqVP19r1Xq5ehDF5wVHe 4uylUTsxKweQbMVuKu62nGgJnRtYEe9rAlW3htTXFSOgilQu9oOf MrA3OtWUava"
    "b0TtLS2OWTtkQaLow66HwG2KYdGK.Z0vChmB2lBHG0Ul D 3hIeU0NzqQ1ps5XsSCyapqdjv79qGJloIP3RClNA30zEzWa2dLk2YF60RSFjfsgVgz5D WkHXjJ7FM"
    "LQCfaTUzGXnTIbYivvCD0AHWzKOP0Xu4CHmCNy2hNXQyE1TD4Baz7CHMeWq6Ba2AqJsj0k60r1SjbTnFwLt2J uCDr7a8Hiz4ELm1j7BdP1rly55gN3iHGb3aRD9m"
    "E.n2zfuVZ.whEsHrRKRo90KRJhI8WEKqei23u4KejJzzcDEa104 sAM7P5NJUnS9f4R19UaPv5HseNrm1qY49Vu8lNbuzFL5pNPEGanf0CseysfHN4IbffwJOEOkh"
    "xeyCbbp7TbI kAmjjfz2602g5u5UEPv4hMdwG7nJCF7FTe9R0mu.dtUPXoqSE5l1nR06 fW3oaadPgKQi8lzz4ByXQ6TWCP1hXUQM2gUGB5ibsihkXPZgN3JPE1 t"
    "2fekDwbGN6f0vMJxGEfCz51TVq113SnSUe2jVWIupxYZFzUJo8sak5Wyp4Pu8RasQWO9BZG N0pXWmIn1NIRmJ1CkY3H52QyUm4TByjmsAhqMsOb6Hu.mibMVXbWo"
    "uWeYhwTzNJ1vbyNGgWmCeS.TCrIjVAe6s1Xgv2N8Kj26ZoGMexs4I2lkYPX41gxPxbw4QWwbS.  1spqQDrLQIf2miXNSyjn7MOj10deN TEnSKuFp c.in8asyPv"
    "Bnx2ZoOgr9fXt7fjm8H.iNQFSTIk3v2zrWppCl6kVTdqAkrfJGv.BL9cZuMo23NktRVD9VHJ7WNNPhqgmDedN2.yq9ozKQuhxpGHyooUBLZBipAtNMwyTXfbd.CGb"
    "zAIzzI9hnOht4JJslzv8zTtd3cssAQ2hf6b9eOLrTigZVdXnIxLP uenbwxQUs5.UTA6JihYvFoVtwjCBAnap YQWiOZgzZ11iaYDblK1jatHo2rtLHL2kkI8b2Jl"
    "AKurROMwmP6ZGUtMGenyiCKgbhSL lZ9bBH4U9Ve61x1hOh.4OZZumZei2r6f1Jdl0hispS2pxzcpL8FKDYwaVfK7MhWiKpekawfMd2qSj7MeZGS2YuDa.5T9Mwg5"
    "g7IkA2mYlfffda3bMpP06xvjNm2cfA51gjl9LH.f8Fb0g8ZG33Z7oTfy244wmdKJP58oCAoxyd2NlpRDmHdW9jfUitsobgxqc8c.ZoYNG9v 4VHn DncziRJBYefl"
    "mbOlEHUBI.tc.1VWJ41X0nvisJkUQmwKH6g.NvzsBIAUN4ysZIhmcrYu0zAK 9cE0tz7eftfv7p75KIz1UrKy28 OaD2XZiDi11hB.1UVpPKTEfpqJAjbfRONxerR"
    "6ETJg5UiLYibAkPsVWZvXfMv6QchKTKTyHsyrzM3BTXbHAZpEN4rjOEJDzfD56df QX4RJu1kqokLFA27hAPfYYcGOTO4KELUARrsWRV 9TtV1ud07NfbzxuACXVK"
    "8dcryL6b7NSGA5QgM655 7S6P RFjPDR 81B0CWJKyzFSdmy2TUXsfWuQFPNyB1Wr8ybMqheW0gioAzKdx9bAnFmruzmULVfgzKuqbV2fQk L0nePsUq1R77lZvEM"
    "Wbc72f3SLgZ5hazfeaAc9qAg99tu6lF8ZbNvAXP1WSMxsogYE4TsJEL5poxMFxGknokfOhcbyQNqx8rgR1MRVJf3oYk6iJW6AXjpPPHIRMoUGFiO3gVc20AXfhimu"
    "6 IaTn4cCOxcWkTEmwjo0E163Oitnkek1utXhdxPo43VEBAMtmETd9nbf368orrMnULFTck62ndNeZ0pO KZfyTFbTpjH3PwXvd8KvCBng7CUR4P5jMDo8AHi8D.U"
    "M3YkA RLC5zWPBVsxvCgmz90U9Iig0szTLGcxeS.pjicBc7yA QOiAA9OreTZ3xNjJuYdUoVzTex6sRlEP55O 3O0zvK16Ey",
    4096UL, { _(d6),_(46),_(ac),_(c8),_(29),_(bf),_(34),_(6b), _(09),_(e1),_(fb),_(f9),_(84),_(3c),_(72),_(ca),
              _(63),_(75),_(87),_(10),_(a1),_(a1),_(25),_(96), _(35),_(bb),_(95),_(dc),_(b9),_(cf),_(3f),_(4b),
              _(2c),_(0f),_(a4),_(86),_(aa),_(4f),_(3b),_(ff), _(e7),_(4d),_(8f),_(c7),_(53),_(fa),_(96),_(6f),
              _(98),_(e3),_(ad),_(ea),_(48),_(a2),_(19),_(2e), _(d2),_(c9),_(a1),_(20),_(89),_(95),_(63),_(99) } },
# endif
  { NULL, /* Terminate the list of vectors */
       0UL, { _(00),_(00),_(00),_(00),_(00),_(00),_(00),_(00), _(00),_(00),_(00),_(00),_(00),_(00),_(00),_(00),
              _(00),_(00),_(00),_(00),_(00),_(00),_(00),_(00), _(00),_(00),_(00),_(00),_(00),_(00),_(00),_(00),
              _(00),_(00),_(00),_(00),_(00),_(00),_(00),_(00), _(00),_(00),_(00),_(00),_(00),_(00),_(00),_(00),
              _(00),_(00),_(00),_(00),_(00),_(00),_(00),_(00), _(00),_(00),_(00),_(00),_(00),_(00),_(00),_(00) } }
};

#undef _

