/* Note: This file is auto generated. */
#ifndef HEADER_fd_src_ballet_reedsol_fd_reedsol_fderiv_h
#define HEADER_fd_src_ballet_reedsol_fd_reedsol_fderiv_h

#include "fd_reedsol_private.h"

/* This file implements the formal derivative computation of a
   polynomial stored in the coefficient basis.  The computation is
   described in section IV of the Lin, et al. paper, and especially part
   IV.B.

   The main macro this file provides is FD_REEDSOL_GEN_FDERIV.  The rest
   of this file is auto-generated implementation details.

   The formal derivative of a polynomial P(x) over a finite field comes
   from treating the x as if it were a real value, taking the
   derivative, and then re-interpreting the resulting polynomial back as
   being over the original finite field.  More precisely, it's the
   linear operator on polynomials that maps x^n to
        x^(n-1) + x^(n-1) + ... + x^(n-1)
        |-------------------------------|
                n terms

   Since our finite field is GF(2^8), then x^n maps to 0 if n is even
   and x^(n-1) if n is odd.

   Basically, this operator is useful because it obeys the formal
   equivalent of the product rule. */

/* FD_REEDSOL_GEN_FDERIV: Inserts code to compute the formal derivative
   of a polynomial of length n, where both the input and output
   polynomial are in the coefficient basis.

   n must be a power of 2 (only 16, 32, 64, 128 are emitted by the code
   generator at the moment).

   The n arguments that follow the first should be vector variables of
   type gf_t.  These are used as input and output, since there's no
   other good way to return n vector values.  As such, this macro is not
   robust.

   The formal derivative is computed in a vectorized fashion, i.e. the
   transform of the ith byte is computed and stored in the ith byte of
   the output for each i independently. */

#define FD_REEDSOL_PRIVATE_EXPAND( M, ... ) M(  __VA_ARGS__ )

#define FD_REEDSOL_GENERATE_FDERIV(  n, ...) FD_REEDSOL_PRIVATE_EXPAND( FD_REEDSOL_FDERIV_IMPL_##n,  __VA_ARGS__ )

#define FD_REEDSOL_FDERIV_IMPL_16( in00    , \
    in01, in02, in03, in04, in05, in06, in07, \
    in08, in09, in10, in11, in12, in13, in14, \
    in15)                                    \
  do {                                       \
    in00 = GF_MUL( in00, 1 );                \
    in00 = gf_zero();                        \
    in01 = GF_MUL( in01, 1 );                \
    in00 = GF_ADD( in00, in01 );             \
    in01 = gf_zero();                        \
    in02 = GF_MUL( in02, 122 );              \
    in00 = GF_ADD( in00, in02 );             \
    in02 = gf_zero();                        \
    in03 = GF_MUL( in03, 122 );              \
    in02 = GF_ADD( in02, in03 );             \
    in01 = GF_ADD( in01, in03 );             \
    in03 = gf_zero();                        \
    in04 = GF_MUL( in04, 32 );               \
    in00 = GF_ADD( in00, in04 );             \
    in04 = gf_zero();                        \
    in05 = GF_MUL( in05, 32 );               \
    in04 = GF_ADD( in04, in05 );             \
    in01 = GF_ADD( in01, in05 );             \
    in05 = gf_zero();                        \
    in06 = GF_MUL( in06, 251 );              \
    in04 = GF_ADD( in04, in06 );             \
    in02 = GF_ADD( in02, in06 );             \
    in06 = gf_zero();                        \
    in07 = GF_MUL( in07, 251 );              \
    in06 = GF_ADD( in06, in07 );             \
    in05 = GF_ADD( in05, in07 );             \
    in03 = GF_ADD( in03, in07 );             \
    in07 = gf_zero();                        \
    in08 = GF_MUL( in08, 41 );               \
    in00 = GF_ADD( in00, in08 );             \
    in08 = gf_zero();                        \
    in09 = GF_MUL( in09, 41 );               \
    in08 = GF_ADD( in08, in09 );             \
    in01 = GF_ADD( in01, in09 );             \
    in09 = gf_zero();                        \
    in10 = GF_MUL( in10, 118 );              \
    in08 = GF_ADD( in08, in10 );             \
    in02 = GF_ADD( in02, in10 );             \
    in10 = gf_zero();                        \
    in11 = GF_MUL( in11, 118 );              \
    in10 = GF_ADD( in10, in11 );             \
    in09 = GF_ADD( in09, in11 );             \
    in03 = GF_ADD( in03, in11 );             \
    in11 = gf_zero();                        \
    in12 = GF_MUL( in12, 73 );               \
    in08 = GF_ADD( in08, in12 );             \
    in04 = GF_ADD( in04, in12 );             \
    in12 = gf_zero();                        \
    in13 = GF_MUL( in13, 73 );               \
    in12 = GF_ADD( in12, in13 );             \
    in09 = GF_ADD( in09, in13 );             \
    in05 = GF_ADD( in05, in13 );             \
    in13 = gf_zero();                        \
    in14 = GF_MUL( in14, 102 );              \
    in12 = GF_ADD( in12, in14 );             \
    in10 = GF_ADD( in10, in14 );             \
    in06 = GF_ADD( in06, in14 );             \
    in14 = gf_zero();                        \
    in15 = GF_MUL( in15, 102 );              \
    in14 = GF_ADD( in14, in15 );             \
    in13 = GF_ADD( in13, in15 );             \
    in11 = GF_ADD( in11, in15 );             \
    in07 = GF_ADD( in07, in15 );             \
    in15 = gf_zero();                        \
    in00 = GF_MUL( in00, 1 );                \
    in01 = GF_MUL( in01, 1 );                \
    in02 = GF_MUL( in02, 6 );                \
    in03 = GF_MUL( in03, 6 );                \
    in04 = GF_MUL( in04, 108 );              \
    in05 = GF_MUL( in05, 108 );              \
    in06 = GF_MUL( in06, 117 );              \
    in07 = GF_MUL( in07, 117 );              \
    in08 = GF_MUL( in08, 208 );              \
    in09 = GF_MUL( in09, 208 );              \
    in10 = GF_MUL( in10, 218 );              \
    in11 = GF_MUL( in11, 218 );              \
    in12 = GF_MUL( in12, 136 );              \
    in13 = GF_MUL( in13, 136 );              \
    in14 = GF_MUL( in14, 23 );               \
    in15 = GF_MUL( in15, 23 );               \
  } while( 0 )

#define FD_REEDSOL_FDERIV_IMPL_32( in00    , \
    in01, in02, in03, in04, in05, in06, in07, \
    in08, in09, in10, in11, in12, in13, in14, \
    in15, in16, in17, in18, in19, in20, in21, \
    in22, in23, in24, in25, in26, in27, in28, \
    in29, in30, in31)                        \
  do {                                       \
    in00 = GF_MUL( in00, 1 );                \
    in00 = gf_zero();                        \
    in01 = GF_MUL( in01, 1 );                \
    in00 = GF_ADD( in00, in01 );             \
    in01 = gf_zero();                        \
    in02 = GF_MUL( in02, 122 );              \
    in00 = GF_ADD( in00, in02 );             \
    in02 = gf_zero();                        \
    in03 = GF_MUL( in03, 122 );              \
    in02 = GF_ADD( in02, in03 );             \
    in01 = GF_ADD( in01, in03 );             \
    in03 = gf_zero();                        \
    in04 = GF_MUL( in04, 32 );               \
    in00 = GF_ADD( in00, in04 );             \
    in04 = gf_zero();                        \
    in05 = GF_MUL( in05, 32 );               \
    in04 = GF_ADD( in04, in05 );             \
    in01 = GF_ADD( in01, in05 );             \
    in05 = gf_zero();                        \
    in06 = GF_MUL( in06, 251 );              \
    in04 = GF_ADD( in04, in06 );             \
    in02 = GF_ADD( in02, in06 );             \
    in06 = gf_zero();                        \
    in07 = GF_MUL( in07, 251 );              \
    in06 = GF_ADD( in06, in07 );             \
    in05 = GF_ADD( in05, in07 );             \
    in03 = GF_ADD( in03, in07 );             \
    in07 = gf_zero();                        \
    in08 = GF_MUL( in08, 41 );               \
    in00 = GF_ADD( in00, in08 );             \
    in08 = gf_zero();                        \
    in09 = GF_MUL( in09, 41 );               \
    in08 = GF_ADD( in08, in09 );             \
    in01 = GF_ADD( in01, in09 );             \
    in09 = gf_zero();                        \
    in10 = GF_MUL( in10, 118 );              \
    in08 = GF_ADD( in08, in10 );             \
    in02 = GF_ADD( in02, in10 );             \
    in10 = gf_zero();                        \
    in11 = GF_MUL( in11, 118 );              \
    in10 = GF_ADD( in10, in11 );             \
    in09 = GF_ADD( in09, in11 );             \
    in03 = GF_ADD( in03, in11 );             \
    in11 = gf_zero();                        \
    in12 = GF_MUL( in12, 73 );               \
    in08 = GF_ADD( in08, in12 );             \
    in04 = GF_ADD( in04, in12 );             \
    in12 = gf_zero();                        \
    in13 = GF_MUL( in13, 73 );               \
    in12 = GF_ADD( in12, in13 );             \
    in09 = GF_ADD( in09, in13 );             \
    in05 = GF_ADD( in05, in13 );             \
    in13 = gf_zero();                        \
    in14 = GF_MUL( in14, 102 );              \
    in12 = GF_ADD( in12, in14 );             \
    in10 = GF_ADD( in10, in14 );             \
    in06 = GF_ADD( in06, in14 );             \
    in14 = gf_zero();                        \
    in15 = GF_MUL( in15, 102 );              \
    in14 = GF_ADD( in14, in15 );             \
    in13 = GF_ADD( in13, in15 );             \
    in11 = GF_ADD( in11, in15 );             \
    in07 = GF_ADD( in07, in15 );             \
    in15 = gf_zero();                        \
    in16 = GF_MUL( in16, 31 );               \
    in00 = GF_ADD( in00, in16 );             \
    in16 = gf_zero();                        \
    in17 = GF_MUL( in17, 31 );               \
    in16 = GF_ADD( in16, in17 );             \
    in01 = GF_ADD( in01, in17 );             \
    in17 = gf_zero();                        \
    in18 = GF_MUL( in18, 127 );              \
    in16 = GF_ADD( in16, in18 );             \
    in02 = GF_ADD( in02, in18 );             \
    in18 = gf_zero();                        \
    in19 = GF_MUL( in19, 127 );              \
    in18 = GF_ADD( in18, in19 );             \
    in17 = GF_ADD( in17, in19 );             \
    in03 = GF_ADD( in03, in19 );             \
    in19 = gf_zero();                        \
    in20 = GF_MUL( in20, 199 );              \
    in16 = GF_ADD( in16, in20 );             \
    in04 = GF_ADD( in04, in20 );             \
    in20 = gf_zero();                        \
    in21 = GF_MUL( in21, 199 );              \
    in20 = GF_ADD( in20, in21 );             \
    in17 = GF_ADD( in17, in21 );             \
    in05 = GF_ADD( in05, in21 );             \
    in21 = gf_zero();                        \
    in22 = GF_MUL( in22, 91 );               \
    in20 = GF_ADD( in20, in22 );             \
    in18 = GF_ADD( in18, in22 );             \
    in06 = GF_ADD( in06, in22 );             \
    in22 = gf_zero();                        \
    in23 = GF_MUL( in23, 91 );               \
    in22 = GF_ADD( in22, in23 );             \
    in21 = GF_ADD( in21, in23 );             \
    in19 = GF_ADD( in19, in23 );             \
    in07 = GF_ADD( in07, in23 );             \
    in23 = gf_zero();                        \
    in24 = GF_MUL( in24, 32 );               \
    in16 = GF_ADD( in16, in24 );             \
    in08 = GF_ADD( in08, in24 );             \
    in24 = gf_zero();                        \
    in25 = GF_MUL( in25, 32 );               \
    in24 = GF_ADD( in24, in25 );             \
    in17 = GF_ADD( in17, in25 );             \
    in09 = GF_ADD( in09, in25 );             \
    in25 = gf_zero();                        \
    in26 = GF_MUL( in26, 251 );              \
    in24 = GF_ADD( in24, in26 );             \
    in18 = GF_ADD( in18, in26 );             \
    in10 = GF_ADD( in10, in26 );             \
    in26 = gf_zero();                        \
    in27 = GF_MUL( in27, 251 );              \
    in26 = GF_ADD( in26, in27 );             \
    in25 = GF_ADD( in25, in27 );             \
    in19 = GF_ADD( in19, in27 );             \
    in11 = GF_ADD( in11, in27 );             \
    in27 = gf_zero();                        \
    in28 = GF_MUL( in28, 116 );              \
    in24 = GF_ADD( in24, in28 );             \
    in20 = GF_ADD( in20, in28 );             \
    in12 = GF_ADD( in12, in28 );             \
    in28 = gf_zero();                        \
    in29 = GF_MUL( in29, 116 );              \
    in28 = GF_ADD( in28, in29 );             \
    in25 = GF_ADD( in25, in29 );             \
    in21 = GF_ADD( in21, in29 );             \
    in13 = GF_ADD( in13, in29 );             \
    in29 = gf_zero();                        \
    in30 = GF_MUL( in30, 22 );               \
    in28 = GF_ADD( in28, in30 );             \
    in26 = GF_ADD( in26, in30 );             \
    in22 = GF_ADD( in22, in30 );             \
    in14 = GF_ADD( in14, in30 );             \
    in30 = gf_zero();                        \
    in31 = GF_MUL( in31, 22 );               \
    in30 = GF_ADD( in30, in31 );             \
    in29 = GF_ADD( in29, in31 );             \
    in27 = GF_ADD( in27, in31 );             \
    in23 = GF_ADD( in23, in31 );             \
    in15 = GF_ADD( in15, in31 );             \
    in31 = gf_zero();                        \
    in00 = GF_MUL( in00, 1 );                \
    in01 = GF_MUL( in01, 1 );                \
    in02 = GF_MUL( in02, 6 );                \
    in03 = GF_MUL( in03, 6 );                \
    in04 = GF_MUL( in04, 108 );              \
    in05 = GF_MUL( in05, 108 );              \
    in06 = GF_MUL( in06, 117 );              \
    in07 = GF_MUL( in07, 117 );              \
    in08 = GF_MUL( in08, 208 );              \
    in09 = GF_MUL( in09, 208 );              \
    in10 = GF_MUL( in10, 218 );              \
    in11 = GF_MUL( in11, 218 );              \
    in12 = GF_MUL( in12, 136 );              \
    in13 = GF_MUL( in13, 136 );              \
    in14 = GF_MUL( in14, 23 );               \
    in15 = GF_MUL( in15, 23 );               \
    in16 = GF_MUL( in16, 42 );               \
    in17 = GF_MUL( in17, 42 );               \
    in18 = GF_MUL( in18, 252 );              \
    in19 = GF_MUL( in19, 252 );              \
    in20 = GF_MUL( in20, 158 );              \
    in21 = GF_MUL( in21, 158 );              \
    in22 = GF_MUL( in22, 99 );               \
    in23 = GF_MUL( in23, 99 );               \
    in24 = GF_MUL( in24, 108 );              \
    in25 = GF_MUL( in25, 108 );              \
    in26 = GF_MUL( in26, 117 );              \
    in27 = GF_MUL( in27, 117 );              \
    in28 = GF_MUL( in28, 233 );              \
    in29 = GF_MUL( in29, 233 );              \
    in30 = GF_MUL( in30, 76 );               \
    in31 = GF_MUL( in31, 76 );               \
  } while( 0 )

#define FD_REEDSOL_FDERIV_IMPL_64( in00    , \
    in01, in02, in03, in04, in05, in06, in07, \
    in08, in09, in10, in11, in12, in13, in14, \
    in15, in16, in17, in18, in19, in20, in21, \
    in22, in23, in24, in25, in26, in27, in28, \
    in29, in30, in31, in32, in33, in34, in35, \
    in36, in37, in38, in39, in40, in41, in42, \
    in43, in44, in45, in46, in47, in48, in49, \
    in50, in51, in52, in53, in54, in55, in56, \
    in57, in58, in59, in60, in61, in62, in63) \
  do {                                       \
    in00 = GF_MUL( in00, 1 );                \
    in00 = gf_zero();                        \
    in01 = GF_MUL( in01, 1 );                \
    in00 = GF_ADD( in00, in01 );             \
    in01 = gf_zero();                        \
    in02 = GF_MUL( in02, 122 );              \
    in00 = GF_ADD( in00, in02 );             \
    in02 = gf_zero();                        \
    in03 = GF_MUL( in03, 122 );              \
    in02 = GF_ADD( in02, in03 );             \
    in01 = GF_ADD( in01, in03 );             \
    in03 = gf_zero();                        \
    in04 = GF_MUL( in04, 32 );               \
    in00 = GF_ADD( in00, in04 );             \
    in04 = gf_zero();                        \
    in05 = GF_MUL( in05, 32 );               \
    in04 = GF_ADD( in04, in05 );             \
    in01 = GF_ADD( in01, in05 );             \
    in05 = gf_zero();                        \
    in06 = GF_MUL( in06, 251 );              \
    in04 = GF_ADD( in04, in06 );             \
    in02 = GF_ADD( in02, in06 );             \
    in06 = gf_zero();                        \
    in07 = GF_MUL( in07, 251 );              \
    in06 = GF_ADD( in06, in07 );             \
    in05 = GF_ADD( in05, in07 );             \
    in03 = GF_ADD( in03, in07 );             \
    in07 = gf_zero();                        \
    in08 = GF_MUL( in08, 41 );               \
    in00 = GF_ADD( in00, in08 );             \
    in08 = gf_zero();                        \
    in09 = GF_MUL( in09, 41 );               \
    in08 = GF_ADD( in08, in09 );             \
    in01 = GF_ADD( in01, in09 );             \
    in09 = gf_zero();                        \
    in10 = GF_MUL( in10, 118 );              \
    in08 = GF_ADD( in08, in10 );             \
    in02 = GF_ADD( in02, in10 );             \
    in10 = gf_zero();                        \
    in11 = GF_MUL( in11, 118 );              \
    in10 = GF_ADD( in10, in11 );             \
    in09 = GF_ADD( in09, in11 );             \
    in03 = GF_ADD( in03, in11 );             \
    in11 = gf_zero();                        \
    in12 = GF_MUL( in12, 73 );               \
    in08 = GF_ADD( in08, in12 );             \
    in04 = GF_ADD( in04, in12 );             \
    in12 = gf_zero();                        \
    in13 = GF_MUL( in13, 73 );               \
    in12 = GF_ADD( in12, in13 );             \
    in09 = GF_ADD( in09, in13 );             \
    in05 = GF_ADD( in05, in13 );             \
    in13 = gf_zero();                        \
    in14 = GF_MUL( in14, 102 );              \
    in12 = GF_ADD( in12, in14 );             \
    in10 = GF_ADD( in10, in14 );             \
    in06 = GF_ADD( in06, in14 );             \
    in14 = gf_zero();                        \
    in15 = GF_MUL( in15, 102 );              \
    in14 = GF_ADD( in14, in15 );             \
    in13 = GF_ADD( in13, in15 );             \
    in11 = GF_ADD( in11, in15 );             \
    in07 = GF_ADD( in07, in15 );             \
    in15 = gf_zero();                        \
    in16 = GF_MUL( in16, 31 );               \
    in00 = GF_ADD( in00, in16 );             \
    in16 = gf_zero();                        \
    in17 = GF_MUL( in17, 31 );               \
    in16 = GF_ADD( in16, in17 );             \
    in01 = GF_ADD( in01, in17 );             \
    in17 = gf_zero();                        \
    in18 = GF_MUL( in18, 127 );              \
    in16 = GF_ADD( in16, in18 );             \
    in02 = GF_ADD( in02, in18 );             \
    in18 = gf_zero();                        \
    in19 = GF_MUL( in19, 127 );              \
    in18 = GF_ADD( in18, in19 );             \
    in17 = GF_ADD( in17, in19 );             \
    in03 = GF_ADD( in03, in19 );             \
    in19 = gf_zero();                        \
    in20 = GF_MUL( in20, 199 );              \
    in16 = GF_ADD( in16, in20 );             \
    in04 = GF_ADD( in04, in20 );             \
    in20 = gf_zero();                        \
    in21 = GF_MUL( in21, 199 );              \
    in20 = GF_ADD( in20, in21 );             \
    in17 = GF_ADD( in17, in21 );             \
    in05 = GF_ADD( in05, in21 );             \
    in21 = gf_zero();                        \
    in22 = GF_MUL( in22, 91 );               \
    in20 = GF_ADD( in20, in22 );             \
    in18 = GF_ADD( in18, in22 );             \
    in06 = GF_ADD( in06, in22 );             \
    in22 = gf_zero();                        \
    in23 = GF_MUL( in23, 91 );               \
    in22 = GF_ADD( in22, in23 );             \
    in21 = GF_ADD( in21, in23 );             \
    in19 = GF_ADD( in19, in23 );             \
    in07 = GF_ADD( in07, in23 );             \
    in23 = gf_zero();                        \
    in24 = GF_MUL( in24, 32 );               \
    in16 = GF_ADD( in16, in24 );             \
    in08 = GF_ADD( in08, in24 );             \
    in24 = gf_zero();                        \
    in25 = GF_MUL( in25, 32 );               \
    in24 = GF_ADD( in24, in25 );             \
    in17 = GF_ADD( in17, in25 );             \
    in09 = GF_ADD( in09, in25 );             \
    in25 = gf_zero();                        \
    in26 = GF_MUL( in26, 251 );              \
    in24 = GF_ADD( in24, in26 );             \
    in18 = GF_ADD( in18, in26 );             \
    in10 = GF_ADD( in10, in26 );             \
    in26 = gf_zero();                        \
    in27 = GF_MUL( in27, 251 );              \
    in26 = GF_ADD( in26, in27 );             \
    in25 = GF_ADD( in25, in27 );             \
    in19 = GF_ADD( in19, in27 );             \
    in11 = GF_ADD( in11, in27 );             \
    in27 = gf_zero();                        \
    in28 = GF_MUL( in28, 116 );              \
    in24 = GF_ADD( in24, in28 );             \
    in20 = GF_ADD( in20, in28 );             \
    in12 = GF_ADD( in12, in28 );             \
    in28 = gf_zero();                        \
    in29 = GF_MUL( in29, 116 );              \
    in28 = GF_ADD( in28, in29 );             \
    in25 = GF_ADD( in25, in29 );             \
    in21 = GF_ADD( in21, in29 );             \
    in13 = GF_ADD( in13, in29 );             \
    in29 = gf_zero();                        \
    in30 = GF_MUL( in30, 22 );               \
    in28 = GF_ADD( in28, in30 );             \
    in26 = GF_ADD( in26, in30 );             \
    in22 = GF_ADD( in22, in30 );             \
    in14 = GF_ADD( in14, in30 );             \
    in30 = gf_zero();                        \
    in31 = GF_MUL( in31, 22 );               \
    in30 = GF_ADD( in30, in31 );             \
    in29 = GF_ADD( in29, in31 );             \
    in27 = GF_ADD( in27, in31 );             \
    in23 = GF_ADD( in23, in31 );             \
    in15 = GF_ADD( in15, in31 );             \
    in31 = gf_zero();                        \
    in32 = GF_MUL( in32, 194 );              \
    in00 = GF_ADD( in00, in32 );             \
    in32 = gf_zero();                        \
    in33 = GF_MUL( in33, 194 );              \
    in32 = GF_ADD( in32, in33 );             \
    in01 = GF_ADD( in01, in33 );             \
    in33 = gf_zero();                        \
    in34 = GF_MUL( in34, 212 );              \
    in32 = GF_ADD( in32, in34 );             \
    in02 = GF_ADD( in02, in34 );             \
    in34 = gf_zero();                        \
    in35 = GF_MUL( in35, 212 );              \
    in34 = GF_ADD( in34, in35 );             \
    in33 = GF_ADD( in33, in35 );             \
    in03 = GF_ADD( in03, in35 );             \
    in35 = gf_zero();                        \
    in36 = GF_MUL( in36, 101 );              \
    in32 = GF_ADD( in32, in36 );             \
    in04 = GF_ADD( in04, in36 );             \
    in36 = gf_zero();                        \
    in37 = GF_MUL( in37, 101 );              \
    in36 = GF_ADD( in36, in37 );             \
    in33 = GF_ADD( in33, in37 );             \
    in05 = GF_ADD( in05, in37 );             \
    in37 = gf_zero();                        \
    in38 = GF_MUL( in38, 159 );              \
    in36 = GF_ADD( in36, in38 );             \
    in34 = GF_ADD( in34, in38 );             \
    in06 = GF_ADD( in06, in38 );             \
    in38 = gf_zero();                        \
    in39 = GF_MUL( in39, 159 );              \
    in38 = GF_ADD( in38, in39 );             \
    in37 = GF_ADD( in37, in39 );             \
    in35 = GF_ADD( in35, in39 );             \
    in07 = GF_ADD( in07, in39 );             \
    in39 = gf_zero();                        \
    in40 = GF_MUL( in40, 249 );              \
    in32 = GF_ADD( in32, in40 );             \
    in08 = GF_ADD( in08, in40 );             \
    in40 = gf_zero();                        \
    in41 = GF_MUL( in41, 249 );              \
    in40 = GF_ADD( in40, in41 );             \
    in33 = GF_ADD( in33, in41 );             \
    in09 = GF_ADD( in09, in41 );             \
    in41 = gf_zero();                        \
    in42 = GF_MUL( in42, 165 );              \
    in40 = GF_ADD( in40, in42 );             \
    in34 = GF_ADD( in34, in42 );             \
    in10 = GF_ADD( in10, in42 );             \
    in42 = gf_zero();                        \
    in43 = GF_MUL( in43, 165 );              \
    in42 = GF_ADD( in42, in43 );             \
    in41 = GF_ADD( in41, in43 );             \
    in35 = GF_ADD( in35, in43 );             \
    in11 = GF_ADD( in11, in43 );             \
    in43 = gf_zero();                        \
    in44 = GF_MUL( in44, 86 );               \
    in40 = GF_ADD( in40, in44 );             \
    in36 = GF_ADD( in36, in44 );             \
    in12 = GF_ADD( in12, in44 );             \
    in44 = gf_zero();                        \
    in45 = GF_MUL( in45, 86 );               \
    in44 = GF_ADD( in44, in45 );             \
    in41 = GF_ADD( in41, in45 );             \
    in37 = GF_ADD( in37, in45 );             \
    in13 = GF_ADD( in13, in45 );             \
    in45 = gf_zero();                        \
    in46 = GF_MUL( in46, 25 );               \
    in44 = GF_ADD( in44, in46 );             \
    in42 = GF_ADD( in42, in46 );             \
    in38 = GF_ADD( in38, in46 );             \
    in14 = GF_ADD( in14, in46 );             \
    in46 = gf_zero();                        \
    in47 = GF_MUL( in47, 25 );               \
    in46 = GF_ADD( in46, in47 );             \
    in45 = GF_ADD( in45, in47 );             \
    in43 = GF_ADD( in43, in47 );             \
    in39 = GF_ADD( in39, in47 );             \
    in15 = GF_ADD( in15, in47 );             \
    in47 = gf_zero();                        \
    in48 = GF_MUL( in48, 150 );              \
    in32 = GF_ADD( in32, in48 );             \
    in16 = GF_ADD( in16, in48 );             \
    in48 = gf_zero();                        \
    in49 = GF_MUL( in49, 150 );              \
    in48 = GF_ADD( in48, in49 );             \
    in33 = GF_ADD( in33, in49 );             \
    in17 = GF_ADD( in17, in49 );             \
    in49 = gf_zero();                        \
    in50 = GF_MUL( in50, 57 );               \
    in48 = GF_ADD( in48, in50 );             \
    in34 = GF_ADD( in34, in50 );             \
    in18 = GF_ADD( in18, in50 );             \
    in50 = gf_zero();                        \
    in51 = GF_MUL( in51, 57 );               \
    in50 = GF_ADD( in50, in51 );             \
    in49 = GF_ADD( in49, in51 );             \
    in35 = GF_ADD( in35, in51 );             \
    in19 = GF_ADD( in19, in51 );             \
    in51 = gf_zero();                        \
    in52 = GF_MUL( in52, 55 );               \
    in48 = GF_ADD( in48, in52 );             \
    in36 = GF_ADD( in36, in52 );             \
    in20 = GF_ADD( in20, in52 );             \
    in52 = gf_zero();                        \
    in53 = GF_MUL( in53, 55 );               \
    in52 = GF_ADD( in52, in53 );             \
    in49 = GF_ADD( in49, in53 );             \
    in37 = GF_ADD( in37, in53 );             \
    in21 = GF_ADD( in21, in53 );             \
    in53 = gf_zero();                        \
    in54 = GF_MUL( in54, 115 );              \
    in52 = GF_ADD( in52, in54 );             \
    in50 = GF_ADD( in50, in54 );             \
    in38 = GF_ADD( in38, in54 );             \
    in22 = GF_ADD( in22, in54 );             \
    in54 = gf_zero();                        \
    in55 = GF_MUL( in55, 115 );              \
    in54 = GF_ADD( in54, in55 );             \
    in53 = GF_ADD( in53, in55 );             \
    in51 = GF_ADD( in51, in55 );             \
    in39 = GF_ADD( in39, in55 );             \
    in23 = GF_ADD( in23, in55 );             \
    in55 = gf_zero();                        \
    in56 = GF_MUL( in56, 101 );              \
    in48 = GF_ADD( in48, in56 );             \
    in40 = GF_ADD( in40, in56 );             \
    in24 = GF_ADD( in24, in56 );             \
    in56 = gf_zero();                        \
    in57 = GF_MUL( in57, 101 );              \
    in56 = GF_ADD( in56, in57 );             \
    in49 = GF_ADD( in49, in57 );             \
    in41 = GF_ADD( in41, in57 );             \
    in25 = GF_ADD( in25, in57 );             \
    in57 = gf_zero();                        \
    in58 = GF_MUL( in58, 159 );              \
    in56 = GF_ADD( in56, in58 );             \
    in50 = GF_ADD( in50, in58 );             \
    in42 = GF_ADD( in42, in58 );             \
    in26 = GF_ADD( in26, in58 );             \
    in58 = gf_zero();                        \
    in59 = GF_MUL( in59, 159 );              \
    in58 = GF_ADD( in58, in59 );             \
    in57 = GF_ADD( in57, in59 );             \
    in51 = GF_ADD( in51, in59 );             \
    in43 = GF_ADD( in43, in59 );             \
    in27 = GF_ADD( in27, in59 );             \
    in59 = gf_zero();                        \
    in60 = GF_MUL( in60, 60 );               \
    in56 = GF_ADD( in56, in60 );             \
    in52 = GF_ADD( in52, in60 );             \
    in44 = GF_ADD( in44, in60 );             \
    in28 = GF_ADD( in28, in60 );             \
    in60 = gf_zero();                        \
    in61 = GF_MUL( in61, 60 );               \
    in60 = GF_ADD( in60, in61 );             \
    in57 = GF_ADD( in57, in61 );             \
    in53 = GF_ADD( in53, in61 );             \
    in45 = GF_ADD( in45, in61 );             \
    in29 = GF_ADD( in29, in61 );             \
    in61 = gf_zero();                        \
    in62 = GF_MUL( in62, 10 );               \
    in60 = GF_ADD( in60, in62 );             \
    in58 = GF_ADD( in58, in62 );             \
    in54 = GF_ADD( in54, in62 );             \
    in46 = GF_ADD( in46, in62 );             \
    in30 = GF_ADD( in30, in62 );             \
    in62 = gf_zero();                        \
    in63 = GF_MUL( in63, 10 );               \
    in62 = GF_ADD( in62, in63 );             \
    in61 = GF_ADD( in61, in63 );             \
    in59 = GF_ADD( in59, in63 );             \
    in55 = GF_ADD( in55, in63 );             \
    in47 = GF_ADD( in47, in63 );             \
    in31 = GF_ADD( in31, in63 );             \
    in63 = gf_zero();                        \
    in00 = GF_MUL( in00, 1 );                \
    in01 = GF_MUL( in01, 1 );                \
    in02 = GF_MUL( in02, 6 );                \
    in03 = GF_MUL( in03, 6 );                \
    in04 = GF_MUL( in04, 108 );              \
    in05 = GF_MUL( in05, 108 );              \
    in06 = GF_MUL( in06, 117 );              \
    in07 = GF_MUL( in07, 117 );              \
    in08 = GF_MUL( in08, 208 );              \
    in09 = GF_MUL( in09, 208 );              \
    in10 = GF_MUL( in10, 218 );              \
    in11 = GF_MUL( in11, 218 );              \
    in12 = GF_MUL( in12, 136 );              \
    in13 = GF_MUL( in13, 136 );              \
    in14 = GF_MUL( in14, 23 );               \
    in15 = GF_MUL( in15, 23 );               \
    in16 = GF_MUL( in16, 42 );               \
    in17 = GF_MUL( in17, 42 );               \
    in18 = GF_MUL( in18, 252 );              \
    in19 = GF_MUL( in19, 252 );              \
    in20 = GF_MUL( in20, 158 );              \
    in21 = GF_MUL( in21, 158 );              \
    in22 = GF_MUL( in22, 99 );               \
    in23 = GF_MUL( in23, 99 );               \
    in24 = GF_MUL( in24, 108 );              \
    in25 = GF_MUL( in25, 108 );              \
    in26 = GF_MUL( in26, 117 );              \
    in27 = GF_MUL( in27, 117 );              \
    in28 = GF_MUL( in28, 233 );              \
    in29 = GF_MUL( in29, 233 );              \
    in30 = GF_MUL( in30, 76 );               \
    in31 = GF_MUL( in31, 76 );               \
    in32 = GF_MUL( in32, 165 );              \
    in33 = GF_MUL( in33, 165 );              \
    in34 = GF_MUL( in34, 249 );              \
    in35 = GF_MUL( in35, 249 );              \
    in36 = GF_MUL( in36, 196 );              \
    in37 = GF_MUL( in37, 196 );              \
    in38 = GF_MUL( in38, 162 );              \
    in39 = GF_MUL( in39, 162 );              \
    in40 = GF_MUL( in40, 212 );              \
    in41 = GF_MUL( in41, 212 );              \
    in42 = GF_MUL( in42, 194 );              \
    in43 = GF_MUL( in43, 194 );              \
    in44 = GF_MUL( in44, 37 );               \
    in45 = GF_MUL( in45, 37 );               \
    in46 = GF_MUL( in46, 222 );              \
    in47 = GF_MUL( in47, 222 );              \
    in48 = GF_MUL( in48, 15 );               \
    in49 = GF_MUL( in49, 15 );               \
    in50 = GF_MUL( in50, 34 );               \
    in51 = GF_MUL( in51, 34 );               \
    in52 = GF_MUL( in52, 94 );               \
    in53 = GF_MUL( in53, 94 );               \
    in54 = GF_MUL( in54, 217 );              \
    in55 = GF_MUL( in55, 217 );              \
    in56 = GF_MUL( in56, 196 );              \
    in57 = GF_MUL( in57, 196 );              \
    in58 = GF_MUL( in58, 162 );              \
    in59 = GF_MUL( in59, 162 );              \
    in60 = GF_MUL( in60, 171 );              \
    in61 = GF_MUL( in61, 171 );              \
    in62 = GF_MUL( in62, 221 );              \
    in63 = GF_MUL( in63, 221 );              \
  } while( 0 )

#define FD_REEDSOL_FDERIV_IMPL_128( in00, in01, \
    in02, in03, in04, in05, in06, in07, in08  , \
    in09, in10, in11, in12, in13, in14, in15  , \
    in16, in17, in18, in19, in20, in21, in22  , \
    in23, in24, in25, in26, in27, in28, in29  , \
    in30, in31, in32, in33, in34, in35, in36  , \
    in37, in38, in39, in40, in41, in42, in43  , \
    in44, in45, in46, in47, in48, in49, in50  , \
    in51, in52, in53, in54, in55, in56, in57  , \
    in58, in59, in60, in61, in62, in63, in64  , \
    in65, in66, in67, in68, in69, in70, in71  , \
    in72, in73, in74, in75, in76, in77, in78  , \
    in79, in80, in81, in82, in83, in84, in85  , \
    in86, in87, in88, in89, in90, in91, in92  , \
    in93, in94, in95, in96, in97, in98, in99  , \
    in100, in101, in102, in103, in104, in105  , \
    in106, in107, in108, in109, in110, in111  , \
    in112, in113, in114, in115, in116, in117  , \
    in118, in119, in120, in121, in122, in123  , \
    in124, in125, in126, in127)                 \
  do {                                          \
    in00 = GF_MUL( in00, 1 );                   \
    in00 = gf_zero();                           \
    in01 = GF_MUL( in01, 1 );                   \
    in00 = GF_ADD( in00, in01 );                \
    in01 = gf_zero();                           \
    in02 = GF_MUL( in02, 122 );                 \
    in00 = GF_ADD( in00, in02 );                \
    in02 = gf_zero();                           \
    in03 = GF_MUL( in03, 122 );                 \
    in02 = GF_ADD( in02, in03 );                \
    in01 = GF_ADD( in01, in03 );                \
    in03 = gf_zero();                           \
    in04 = GF_MUL( in04, 32 );                  \
    in00 = GF_ADD( in00, in04 );                \
    in04 = gf_zero();                           \
    in05 = GF_MUL( in05, 32 );                  \
    in04 = GF_ADD( in04, in05 );                \
    in01 = GF_ADD( in01, in05 );                \
    in05 = gf_zero();                           \
    in06 = GF_MUL( in06, 251 );                 \
    in04 = GF_ADD( in04, in06 );                \
    in02 = GF_ADD( in02, in06 );                \
    in06 = gf_zero();                           \
    in07 = GF_MUL( in07, 251 );                 \
    in06 = GF_ADD( in06, in07 );                \
    in05 = GF_ADD( in05, in07 );                \
    in03 = GF_ADD( in03, in07 );                \
    in07 = gf_zero();                           \
    in08 = GF_MUL( in08, 41 );                  \
    in00 = GF_ADD( in00, in08 );                \
    in08 = gf_zero();                           \
    in09 = GF_MUL( in09, 41 );                  \
    in08 = GF_ADD( in08, in09 );                \
    in01 = GF_ADD( in01, in09 );                \
    in09 = gf_zero();                           \
    in10 = GF_MUL( in10, 118 );                 \
    in08 = GF_ADD( in08, in10 );                \
    in02 = GF_ADD( in02, in10 );                \
    in10 = gf_zero();                           \
    in11 = GF_MUL( in11, 118 );                 \
    in10 = GF_ADD( in10, in11 );                \
    in09 = GF_ADD( in09, in11 );                \
    in03 = GF_ADD( in03, in11 );                \
    in11 = gf_zero();                           \
    in12 = GF_MUL( in12, 73 );                  \
    in08 = GF_ADD( in08, in12 );                \
    in04 = GF_ADD( in04, in12 );                \
    in12 = gf_zero();                           \
    in13 = GF_MUL( in13, 73 );                  \
    in12 = GF_ADD( in12, in13 );                \
    in09 = GF_ADD( in09, in13 );                \
    in05 = GF_ADD( in05, in13 );                \
    in13 = gf_zero();                           \
    in14 = GF_MUL( in14, 102 );                 \
    in12 = GF_ADD( in12, in14 );                \
    in10 = GF_ADD( in10, in14 );                \
    in06 = GF_ADD( in06, in14 );                \
    in14 = gf_zero();                           \
    in15 = GF_MUL( in15, 102 );                 \
    in14 = GF_ADD( in14, in15 );                \
    in13 = GF_ADD( in13, in15 );                \
    in11 = GF_ADD( in11, in15 );                \
    in07 = GF_ADD( in07, in15 );                \
    in15 = gf_zero();                           \
    in16 = GF_MUL( in16, 31 );                  \
    in00 = GF_ADD( in00, in16 );                \
    in16 = gf_zero();                           \
    in17 = GF_MUL( in17, 31 );                  \
    in16 = GF_ADD( in16, in17 );                \
    in01 = GF_ADD( in01, in17 );                \
    in17 = gf_zero();                           \
    in18 = GF_MUL( in18, 127 );                 \
    in16 = GF_ADD( in16, in18 );                \
    in02 = GF_ADD( in02, in18 );                \
    in18 = gf_zero();                           \
    in19 = GF_MUL( in19, 127 );                 \
    in18 = GF_ADD( in18, in19 );                \
    in17 = GF_ADD( in17, in19 );                \
    in03 = GF_ADD( in03, in19 );                \
    in19 = gf_zero();                           \
    in20 = GF_MUL( in20, 199 );                 \
    in16 = GF_ADD( in16, in20 );                \
    in04 = GF_ADD( in04, in20 );                \
    in20 = gf_zero();                           \
    in21 = GF_MUL( in21, 199 );                 \
    in20 = GF_ADD( in20, in21 );                \
    in17 = GF_ADD( in17, in21 );                \
    in05 = GF_ADD( in05, in21 );                \
    in21 = gf_zero();                           \
    in22 = GF_MUL( in22, 91 );                  \
    in20 = GF_ADD( in20, in22 );                \
    in18 = GF_ADD( in18, in22 );                \
    in06 = GF_ADD( in06, in22 );                \
    in22 = gf_zero();                           \
    in23 = GF_MUL( in23, 91 );                  \
    in22 = GF_ADD( in22, in23 );                \
    in21 = GF_ADD( in21, in23 );                \
    in19 = GF_ADD( in19, in23 );                \
    in07 = GF_ADD( in07, in23 );                \
    in23 = gf_zero();                           \
    in24 = GF_MUL( in24, 32 );                  \
    in16 = GF_ADD( in16, in24 );                \
    in08 = GF_ADD( in08, in24 );                \
    in24 = gf_zero();                           \
    in25 = GF_MUL( in25, 32 );                  \
    in24 = GF_ADD( in24, in25 );                \
    in17 = GF_ADD( in17, in25 );                \
    in09 = GF_ADD( in09, in25 );                \
    in25 = gf_zero();                           \
    in26 = GF_MUL( in26, 251 );                 \
    in24 = GF_ADD( in24, in26 );                \
    in18 = GF_ADD( in18, in26 );                \
    in10 = GF_ADD( in10, in26 );                \
    in26 = gf_zero();                           \
    in27 = GF_MUL( in27, 251 );                 \
    in26 = GF_ADD( in26, in27 );                \
    in25 = GF_ADD( in25, in27 );                \
    in19 = GF_ADD( in19, in27 );                \
    in11 = GF_ADD( in11, in27 );                \
    in27 = gf_zero();                           \
    in28 = GF_MUL( in28, 116 );                 \
    in24 = GF_ADD( in24, in28 );                \
    in20 = GF_ADD( in20, in28 );                \
    in12 = GF_ADD( in12, in28 );                \
    in28 = gf_zero();                           \
    in29 = GF_MUL( in29, 116 );                 \
    in28 = GF_ADD( in28, in29 );                \
    in25 = GF_ADD( in25, in29 );                \
    in21 = GF_ADD( in21, in29 );                \
    in13 = GF_ADD( in13, in29 );                \
    in29 = gf_zero();                           \
    in30 = GF_MUL( in30, 22 );                  \
    in28 = GF_ADD( in28, in30 );                \
    in26 = GF_ADD( in26, in30 );                \
    in22 = GF_ADD( in22, in30 );                \
    in14 = GF_ADD( in14, in30 );                \
    in30 = gf_zero();                           \
    in31 = GF_MUL( in31, 22 );                  \
    in30 = GF_ADD( in30, in31 );                \
    in29 = GF_ADD( in29, in31 );                \
    in27 = GF_ADD( in27, in31 );                \
    in23 = GF_ADD( in23, in31 );                \
    in15 = GF_ADD( in15, in31 );                \
    in31 = gf_zero();                           \
    in32 = GF_MUL( in32, 194 );                 \
    in00 = GF_ADD( in00, in32 );                \
    in32 = gf_zero();                           \
    in33 = GF_MUL( in33, 194 );                 \
    in32 = GF_ADD( in32, in33 );                \
    in01 = GF_ADD( in01, in33 );                \
    in33 = gf_zero();                           \
    in34 = GF_MUL( in34, 212 );                 \
    in32 = GF_ADD( in32, in34 );                \
    in02 = GF_ADD( in02, in34 );                \
    in34 = gf_zero();                           \
    in35 = GF_MUL( in35, 212 );                 \
    in34 = GF_ADD( in34, in35 );                \
    in33 = GF_ADD( in33, in35 );                \
    in03 = GF_ADD( in03, in35 );                \
    in35 = gf_zero();                           \
    in36 = GF_MUL( in36, 101 );                 \
    in32 = GF_ADD( in32, in36 );                \
    in04 = GF_ADD( in04, in36 );                \
    in36 = gf_zero();                           \
    in37 = GF_MUL( in37, 101 );                 \
    in36 = GF_ADD( in36, in37 );                \
    in33 = GF_ADD( in33, in37 );                \
    in05 = GF_ADD( in05, in37 );                \
    in37 = gf_zero();                           \
    in38 = GF_MUL( in38, 159 );                 \
    in36 = GF_ADD( in36, in38 );                \
    in34 = GF_ADD( in34, in38 );                \
    in06 = GF_ADD( in06, in38 );                \
    in38 = gf_zero();                           \
    in39 = GF_MUL( in39, 159 );                 \
    in38 = GF_ADD( in38, in39 );                \
    in37 = GF_ADD( in37, in39 );                \
    in35 = GF_ADD( in35, in39 );                \
    in07 = GF_ADD( in07, in39 );                \
    in39 = gf_zero();                           \
    in40 = GF_MUL( in40, 249 );                 \
    in32 = GF_ADD( in32, in40 );                \
    in08 = GF_ADD( in08, in40 );                \
    in40 = gf_zero();                           \
    in41 = GF_MUL( in41, 249 );                 \
    in40 = GF_ADD( in40, in41 );                \
    in33 = GF_ADD( in33, in41 );                \
    in09 = GF_ADD( in09, in41 );                \
    in41 = gf_zero();                           \
    in42 = GF_MUL( in42, 165 );                 \
    in40 = GF_ADD( in40, in42 );                \
    in34 = GF_ADD( in34, in42 );                \
    in10 = GF_ADD( in10, in42 );                \
    in42 = gf_zero();                           \
    in43 = GF_MUL( in43, 165 );                 \
    in42 = GF_ADD( in42, in43 );                \
    in41 = GF_ADD( in41, in43 );                \
    in35 = GF_ADD( in35, in43 );                \
    in11 = GF_ADD( in11, in43 );                \
    in43 = gf_zero();                           \
    in44 = GF_MUL( in44, 86 );                  \
    in40 = GF_ADD( in40, in44 );                \
    in36 = GF_ADD( in36, in44 );                \
    in12 = GF_ADD( in12, in44 );                \
    in44 = gf_zero();                           \
    in45 = GF_MUL( in45, 86 );                  \
    in44 = GF_ADD( in44, in45 );                \
    in41 = GF_ADD( in41, in45 );                \
    in37 = GF_ADD( in37, in45 );                \
    in13 = GF_ADD( in13, in45 );                \
    in45 = gf_zero();                           \
    in46 = GF_MUL( in46, 25 );                  \
    in44 = GF_ADD( in44, in46 );                \
    in42 = GF_ADD( in42, in46 );                \
    in38 = GF_ADD( in38, in46 );                \
    in14 = GF_ADD( in14, in46 );                \
    in46 = gf_zero();                           \
    in47 = GF_MUL( in47, 25 );                  \
    in46 = GF_ADD( in46, in47 );                \
    in45 = GF_ADD( in45, in47 );                \
    in43 = GF_ADD( in43, in47 );                \
    in39 = GF_ADD( in39, in47 );                \
    in15 = GF_ADD( in15, in47 );                \
    in47 = gf_zero();                           \
    in48 = GF_MUL( in48, 150 );                 \
    in32 = GF_ADD( in32, in48 );                \
    in16 = GF_ADD( in16, in48 );                \
    in48 = gf_zero();                           \
    in49 = GF_MUL( in49, 150 );                 \
    in48 = GF_ADD( in48, in49 );                \
    in33 = GF_ADD( in33, in49 );                \
    in17 = GF_ADD( in17, in49 );                \
    in49 = gf_zero();                           \
    in50 = GF_MUL( in50, 57 );                  \
    in48 = GF_ADD( in48, in50 );                \
    in34 = GF_ADD( in34, in50 );                \
    in18 = GF_ADD( in18, in50 );                \
    in50 = gf_zero();                           \
    in51 = GF_MUL( in51, 57 );                  \
    in50 = GF_ADD( in50, in51 );                \
    in49 = GF_ADD( in49, in51 );                \
    in35 = GF_ADD( in35, in51 );                \
    in19 = GF_ADD( in19, in51 );                \
    in51 = gf_zero();                           \
    in52 = GF_MUL( in52, 55 );                  \
    in48 = GF_ADD( in48, in52 );                \
    in36 = GF_ADD( in36, in52 );                \
    in20 = GF_ADD( in20, in52 );                \
    in52 = gf_zero();                           \
    in53 = GF_MUL( in53, 55 );                  \
    in52 = GF_ADD( in52, in53 );                \
    in49 = GF_ADD( in49, in53 );                \
    in37 = GF_ADD( in37, in53 );                \
    in21 = GF_ADD( in21, in53 );                \
    in53 = gf_zero();                           \
    in54 = GF_MUL( in54, 115 );                 \
    in52 = GF_ADD( in52, in54 );                \
    in50 = GF_ADD( in50, in54 );                \
    in38 = GF_ADD( in38, in54 );                \
    in22 = GF_ADD( in22, in54 );                \
    in54 = gf_zero();                           \
    in55 = GF_MUL( in55, 115 );                 \
    in54 = GF_ADD( in54, in55 );                \
    in53 = GF_ADD( in53, in55 );                \
    in51 = GF_ADD( in51, in55 );                \
    in39 = GF_ADD( in39, in55 );                \
    in23 = GF_ADD( in23, in55 );                \
    in55 = gf_zero();                           \
    in56 = GF_MUL( in56, 101 );                 \
    in48 = GF_ADD( in48, in56 );                \
    in40 = GF_ADD( in40, in56 );                \
    in24 = GF_ADD( in24, in56 );                \
    in56 = gf_zero();                           \
    in57 = GF_MUL( in57, 101 );                 \
    in56 = GF_ADD( in56, in57 );                \
    in49 = GF_ADD( in49, in57 );                \
    in41 = GF_ADD( in41, in57 );                \
    in25 = GF_ADD( in25, in57 );                \
    in57 = gf_zero();                           \
    in58 = GF_MUL( in58, 159 );                 \
    in56 = GF_ADD( in56, in58 );                \
    in50 = GF_ADD( in50, in58 );                \
    in42 = GF_ADD( in42, in58 );                \
    in26 = GF_ADD( in26, in58 );                \
    in58 = gf_zero();                           \
    in59 = GF_MUL( in59, 159 );                 \
    in58 = GF_ADD( in58, in59 );                \
    in57 = GF_ADD( in57, in59 );                \
    in51 = GF_ADD( in51, in59 );                \
    in43 = GF_ADD( in43, in59 );                \
    in27 = GF_ADD( in27, in59 );                \
    in59 = gf_zero();                           \
    in60 = GF_MUL( in60, 60 );                  \
    in56 = GF_ADD( in56, in60 );                \
    in52 = GF_ADD( in52, in60 );                \
    in44 = GF_ADD( in44, in60 );                \
    in28 = GF_ADD( in28, in60 );                \
    in60 = gf_zero();                           \
    in61 = GF_MUL( in61, 60 );                  \
    in60 = GF_ADD( in60, in61 );                \
    in57 = GF_ADD( in57, in61 );                \
    in53 = GF_ADD( in53, in61 );                \
    in45 = GF_ADD( in45, in61 );                \
    in29 = GF_ADD( in29, in61 );                \
    in61 = gf_zero();                           \
    in62 = GF_MUL( in62, 10 );                  \
    in60 = GF_ADD( in60, in62 );                \
    in58 = GF_ADD( in58, in62 );                \
    in54 = GF_ADD( in54, in62 );                \
    in46 = GF_ADD( in46, in62 );                \
    in30 = GF_ADD( in30, in62 );                \
    in62 = gf_zero();                           \
    in63 = GF_MUL( in63, 10 );                  \
    in62 = GF_ADD( in62, in63 );                \
    in61 = GF_ADD( in61, in63 );                \
    in59 = GF_ADD( in59, in63 );                \
    in55 = GF_ADD( in55, in63 );                \
    in47 = GF_ADD( in47, in63 );                \
    in31 = GF_ADD( in31, in63 );                \
    in63 = gf_zero();                           \
    in64 = GF_MUL( in64, 232 );                 \
    in00 = GF_ADD( in00, in64 );                \
    in64 = gf_zero();                           \
    in65 = GF_MUL( in65, 232 );                 \
    in64 = GF_ADD( in64, in65 );                \
    in01 = GF_ADD( in01, in65 );                \
    in65 = gf_zero();                           \
    in66 = GF_MUL( in66, 44 );                  \
    in64 = GF_ADD( in64, in66 );                \
    in02 = GF_ADD( in02, in66 );                \
    in66 = gf_zero();                           \
    in67 = GF_MUL( in67, 44 );                  \
    in66 = GF_ADD( in66, in67 );                \
    in65 = GF_ADD( in65, in67 );                \
    in03 = GF_ADD( in03, in67 );                \
    in67 = gf_zero();                           \
    in68 = GF_MUL( in68, 76 );                  \
    in64 = GF_ADD( in64, in68 );                \
    in04 = GF_ADD( in04, in68 );                \
    in68 = gf_zero();                           \
    in69 = GF_MUL( in69, 76 );                  \
    in68 = GF_ADD( in68, in69 );                \
    in65 = GF_ADD( in65, in69 );                \
    in05 = GF_ADD( in05, in69 );                \
    in69 = gf_zero();                           \
    in70 = GF_MUL( in70, 233 );                 \
    in68 = GF_ADD( in68, in70 );                \
    in66 = GF_ADD( in66, in70 );                \
    in06 = GF_ADD( in06, in70 );                \
    in70 = gf_zero();                           \
    in71 = GF_MUL( in71, 233 );                 \
    in70 = GF_ADD( in70, in71 );                \
    in69 = GF_ADD( in69, in71 );                \
    in67 = GF_ADD( in67, in71 );                \
    in07 = GF_ADD( in07, in71 );                \
    in71 = gf_zero();                           \
    in72 = GF_MUL( in72, 183 );                 \
    in64 = GF_ADD( in64, in72 );                \
    in08 = GF_ADD( in08, in72 );                \
    in72 = gf_zero();                           \
    in73 = GF_MUL( in73, 183 );                 \
    in72 = GF_ADD( in72, in73 );                \
    in65 = GF_ADD( in65, in73 );                \
    in09 = GF_ADD( in09, in73 );                \
    in73 = gf_zero();                           \
    in74 = GF_MUL( in74, 184 );                 \
    in72 = GF_ADD( in72, in74 );                \
    in66 = GF_ADD( in66, in74 );                \
    in10 = GF_ADD( in10, in74 );                \
    in74 = gf_zero();                           \
    in75 = GF_MUL( in75, 184 );                 \
    in74 = GF_ADD( in74, in75 );                \
    in73 = GF_ADD( in73, in75 );                \
    in67 = GF_ADD( in67, in75 );                \
    in11 = GF_ADD( in11, in75 );                \
    in75 = gf_zero();                           \
    in76 = GF_MUL( in76, 99 );                  \
    in72 = GF_ADD( in72, in76 );                \
    in68 = GF_ADD( in68, in76 );                \
    in12 = GF_ADD( in12, in76 );                \
    in76 = gf_zero();                           \
    in77 = GF_MUL( in77, 99 );                  \
    in76 = GF_ADD( in76, in77 );                \
    in73 = GF_ADD( in73, in77 );                \
    in69 = GF_ADD( in69, in77 );                \
    in13 = GF_ADD( in13, in77 );                \
    in77 = gf_zero();                           \
    in78 = GF_MUL( in78, 158 );                 \
    in76 = GF_ADD( in76, in78 );                \
    in74 = GF_ADD( in74, in78 );                \
    in70 = GF_ADD( in70, in78 );                \
    in14 = GF_ADD( in14, in78 );                \
    in78 = gf_zero();                           \
    in79 = GF_MUL( in79, 158 );                 \
    in78 = GF_ADD( in78, in79 );                \
    in77 = GF_ADD( in77, in79 );                \
    in75 = GF_ADD( in75, in79 );                \
    in71 = GF_ADD( in71, in79 );                \
    in15 = GF_ADD( in15, in79 );                \
    in79 = gf_zero();                           \
    in80 = GF_MUL( in80, 151 );                 \
    in64 = GF_ADD( in64, in80 );                \
    in16 = GF_ADD( in16, in80 );                \
    in80 = gf_zero();                           \
    in81 = GF_MUL( in81, 151 );                 \
    in80 = GF_ADD( in80, in81 );                \
    in65 = GF_ADD( in65, in81 );                \
    in17 = GF_ADD( in17, in81 );                \
    in81 = gf_zero();                           \
    in82 = GF_MUL( in82, 67 );                  \
    in80 = GF_ADD( in80, in82 );                \
    in66 = GF_ADD( in66, in82 );                \
    in18 = GF_ADD( in18, in82 );                \
    in82 = gf_zero();                           \
    in83 = GF_MUL( in83, 67 );                  \
    in82 = GF_ADD( in82, in83 );                \
    in81 = GF_ADD( in81, in83 );                \
    in67 = GF_ADD( in67, in83 );                \
    in19 = GF_ADD( in19, in83 );                \
    in83 = gf_zero();                           \
    in84 = GF_MUL( in84, 23 );                  \
    in80 = GF_ADD( in80, in84 );                \
    in68 = GF_ADD( in68, in84 );                \
    in20 = GF_ADD( in20, in84 );                \
    in84 = gf_zero();                           \
    in85 = GF_MUL( in85, 23 );                  \
    in84 = GF_ADD( in84, in85 );                \
    in81 = GF_ADD( in81, in85 );                \
    in69 = GF_ADD( in69, in85 );                \
    in21 = GF_ADD( in21, in85 );                \
    in85 = gf_zero();                           \
    in86 = GF_MUL( in86, 136 );                 \
    in84 = GF_ADD( in84, in86 );                \
    in82 = GF_ADD( in82, in86 );                \
    in70 = GF_ADD( in70, in86 );                \
    in22 = GF_ADD( in22, in86 );                \
    in86 = gf_zero();                           \
    in87 = GF_MUL( in87, 136 );                 \
    in86 = GF_ADD( in86, in87 );                \
    in85 = GF_ADD( in85, in87 );                \
    in83 = GF_ADD( in83, in87 );                \
    in71 = GF_ADD( in71, in87 );                \
    in23 = GF_ADD( in23, in87 );                \
    in87 = gf_zero();                           \
    in88 = GF_MUL( in88, 76 );                  \
    in80 = GF_ADD( in80, in88 );                \
    in72 = GF_ADD( in72, in88 );                \
    in24 = GF_ADD( in24, in88 );                \
    in88 = gf_zero();                           \
    in89 = GF_MUL( in89, 76 );                  \
    in88 = GF_ADD( in88, in89 );                \
    in81 = GF_ADD( in81, in89 );                \
    in73 = GF_ADD( in73, in89 );                \
    in25 = GF_ADD( in25, in89 );                \
    in89 = gf_zero();                           \
    in90 = GF_MUL( in90, 233 );                 \
    in88 = GF_ADD( in88, in90 );                \
    in82 = GF_ADD( in82, in90 );                \
    in74 = GF_ADD( in74, in90 );                \
    in26 = GF_ADD( in26, in90 );                \
    in90 = gf_zero();                           \
    in91 = GF_MUL( in91, 233 );                 \
    in90 = GF_ADD( in90, in91 );                \
    in89 = GF_ADD( in89, in91 );                \
    in83 = GF_ADD( in83, in91 );                \
    in75 = GF_ADD( in75, in91 );                \
    in27 = GF_ADD( in27, in91 );                \
    in91 = gf_zero();                           \
    in92 = GF_MUL( in92, 117 );                 \
    in88 = GF_ADD( in88, in92 );                \
    in84 = GF_ADD( in84, in92 );                \
    in76 = GF_ADD( in76, in92 );                \
    in28 = GF_ADD( in28, in92 );                \
    in92 = gf_zero();                           \
    in93 = GF_MUL( in93, 117 );                 \
    in92 = GF_ADD( in92, in93 );                \
    in89 = GF_ADD( in89, in93 );                \
    in85 = GF_ADD( in85, in93 );                \
    in77 = GF_ADD( in77, in93 );                \
    in29 = GF_ADD( in29, in93 );                \
    in93 = gf_zero();                           \
    in94 = GF_MUL( in94, 108 );                 \
    in92 = GF_ADD( in92, in94 );                \
    in90 = GF_ADD( in90, in94 );                \
    in86 = GF_ADD( in86, in94 );                \
    in78 = GF_ADD( in78, in94 );                \
    in30 = GF_ADD( in30, in94 );                \
    in94 = gf_zero();                           \
    in95 = GF_MUL( in95, 108 );                 \
    in94 = GF_ADD( in94, in95 );                \
    in93 = GF_ADD( in93, in95 );                \
    in91 = GF_ADD( in91, in95 );                \
    in87 = GF_ADD( in87, in95 );                \
    in79 = GF_ADD( in79, in95 );                \
    in31 = GF_ADD( in31, in95 );                \
    in95 = gf_zero();                           \
    in96 = GF_MUL( in96, 120 );                 \
    in64 = GF_ADD( in64, in96 );                \
    in32 = GF_ADD( in32, in96 );                \
    in96 = gf_zero();                           \
    in97 = GF_MUL( in97, 120 );                 \
    in96 = GF_ADD( in96, in97 );                \
    in65 = GF_ADD( in65, in97 );                \
    in33 = GF_ADD( in33, in97 );                \
    in97 = gf_zero();                           \
    in98 = GF_MUL( in98, 20 );                  \
    in96 = GF_ADD( in96, in98 );                \
    in66 = GF_ADD( in66, in98 );                \
    in34 = GF_ADD( in34, in98 );                \
    in98 = gf_zero();                           \
    in99 = GF_MUL( in99, 20 );                  \
    in98 = GF_ADD( in98, in99 );                \
    in97 = GF_ADD( in97, in99 );                \
    in67 = GF_ADD( in67, in99 );                \
    in35 = GF_ADD( in35, in99 );                \
    in99 = gf_zero();                           \
    in100 = GF_MUL( in100, 187 );               \
    in96 = GF_ADD( in96, in100 );               \
    in68 = GF_ADD( in68, in100 );               \
    in36 = GF_ADD( in36, in100 );               \
    in100 = gf_zero();                          \
    in101 = GF_MUL( in101, 187 );               \
    in100 = GF_ADD( in100, in101 );             \
    in97 = GF_ADD( in97, in101 );               \
    in69 = GF_ADD( in69, in101 );               \
    in37 = GF_ADD( in37, in101 );               \
    in101 = gf_zero();                          \
    in102 = GF_MUL( in102, 186 );               \
    in100 = GF_ADD( in100, in102 );             \
    in98 = GF_ADD( in98, in102 );               \
    in70 = GF_ADD( in70, in102 );               \
    in38 = GF_ADD( in38, in102 );               \
    in102 = gf_zero();                          \
    in103 = GF_MUL( in103, 186 );               \
    in102 = GF_ADD( in102, in103 );             \
    in101 = GF_ADD( in101, in103 );             \
    in99 = GF_ADD( in99, in103 );               \
    in71 = GF_ADD( in71, in103 );               \
    in39 = GF_ADD( in39, in103 );               \
    in103 = gf_zero();                          \
    in104 = GF_MUL( in104, 36 );                \
    in96 = GF_ADD( in96, in104 );               \
    in72 = GF_ADD( in72, in104 );               \
    in40 = GF_ADD( in40, in104 );               \
    in104 = gf_zero();                          \
    in105 = GF_MUL( in105, 36 );                \
    in104 = GF_ADD( in104, in105 );             \
    in97 = GF_ADD( in97, in105 );               \
    in73 = GF_ADD( in73, in105 );               \
    in41 = GF_ADD( in41, in105 );               \
    in105 = gf_zero();                          \
    in106 = GF_MUL( in106, 14 );                \
    in104 = GF_ADD( in104, in106 );             \
    in98 = GF_ADD( in98, in106 );               \
    in74 = GF_ADD( in74, in106 );               \
    in42 = GF_ADD( in42, in106 );               \
    in106 = gf_zero();                          \
    in107 = GF_MUL( in107, 14 );                \
    in106 = GF_ADD( in106, in107 );             \
    in105 = GF_ADD( in105, in107 );             \
    in99 = GF_ADD( in99, in107 );               \
    in75 = GF_ADD( in75, in107 );               \
    in43 = GF_ADD( in43, in107 );               \
    in107 = gf_zero();                          \
    in108 = GF_MUL( in108, 244 );               \
    in104 = GF_ADD( in104, in108 );             \
    in100 = GF_ADD( in100, in108 );             \
    in76 = GF_ADD( in76, in108 );               \
    in44 = GF_ADD( in44, in108 );               \
    in108 = gf_zero();                          \
    in109 = GF_MUL( in109, 244 );               \
    in108 = GF_ADD( in108, in109 );             \
    in105 = GF_ADD( in105, in109 );             \
    in101 = GF_ADD( in101, in109 );             \
    in77 = GF_ADD( in77, in109 );               \
    in45 = GF_ADD( in45, in109 );               \
    in109 = gf_zero();                          \
    in110 = GF_MUL( in110, 221 );               \
    in108 = GF_ADD( in108, in110 );             \
    in106 = GF_ADD( in106, in110 );             \
    in102 = GF_ADD( in102, in110 );             \
    in78 = GF_ADD( in78, in110 );               \
    in46 = GF_ADD( in46, in110 );               \
    in110 = gf_zero();                          \
    in111 = GF_MUL( in111, 221 );               \
    in110 = GF_ADD( in110, in111 );             \
    in109 = GF_ADD( in109, in111 );             \
    in107 = GF_ADD( in107, in111 );             \
    in103 = GF_ADD( in103, in111 );             \
    in79 = GF_ADD( in79, in111 );               \
    in47 = GF_ADD( in47, in111 );               \
    in111 = gf_zero();                          \
    in112 = GF_MUL( in112, 65 );                \
    in96 = GF_ADD( in96, in112 );               \
    in80 = GF_ADD( in80, in112 );               \
    in48 = GF_ADD( in48, in112 );               \
    in112 = gf_zero();                          \
    in113 = GF_MUL( in113, 65 );                \
    in112 = GF_ADD( in112, in113 );             \
    in97 = GF_ADD( in97, in113 );               \
    in81 = GF_ADD( in81, in113 );               \
    in49 = GF_ADD( in49, in113 );               \
    in113 = gf_zero();                          \
    in114 = GF_MUL( in114, 145 );               \
    in112 = GF_ADD( in112, in114 );             \
    in98 = GF_ADD( in98, in114 );               \
    in82 = GF_ADD( in82, in114 );               \
    in50 = GF_ADD( in50, in114 );               \
    in114 = gf_zero();                          \
    in115 = GF_MUL( in115, 145 );               \
    in114 = GF_ADD( in114, in115 );             \
    in113 = GF_ADD( in113, in115 );             \
    in99 = GF_ADD( in99, in115 );               \
    in83 = GF_ADD( in83, in115 );               \
    in51 = GF_ADD( in51, in115 );               \
    in115 = gf_zero();                          \
    in116 = GF_MUL( in116, 200 );               \
    in112 = GF_ADD( in112, in116 );             \
    in100 = GF_ADD( in100, in116 );             \
    in84 = GF_ADD( in84, in116 );               \
    in52 = GF_ADD( in52, in116 );               \
    in116 = gf_zero();                          \
    in117 = GF_MUL( in117, 200 );               \
    in116 = GF_ADD( in116, in117 );             \
    in113 = GF_ADD( in113, in117 );             \
    in101 = GF_ADD( in101, in117 );             \
    in85 = GF_ADD( in85, in117 );               \
    in53 = GF_ADD( in53, in117 );               \
    in117 = gf_zero();                          \
    in118 = GF_MUL( in118, 215 );               \
    in116 = GF_ADD( in116, in118 );             \
    in114 = GF_ADD( in114, in118 );             \
    in102 = GF_ADD( in102, in118 );             \
    in86 = GF_ADD( in86, in118 );               \
    in54 = GF_ADD( in54, in118 );               \
    in118 = gf_zero();                          \
    in119 = GF_MUL( in119, 215 );               \
    in118 = GF_ADD( in118, in119 );             \
    in117 = GF_ADD( in117, in119 );             \
    in115 = GF_ADD( in115, in119 );             \
    in103 = GF_ADD( in103, in119 );             \
    in87 = GF_ADD( in87, in119 );               \
    in55 = GF_ADD( in55, in119 );               \
    in119 = gf_zero();                          \
    in120 = GF_MUL( in120, 187 );               \
    in112 = GF_ADD( in112, in120 );             \
    in104 = GF_ADD( in104, in120 );             \
    in88 = GF_ADD( in88, in120 );               \
    in56 = GF_ADD( in56, in120 );               \
    in120 = gf_zero();                          \
    in121 = GF_MUL( in121, 187 );               \
    in120 = GF_ADD( in120, in121 );             \
    in113 = GF_ADD( in113, in121 );             \
    in105 = GF_ADD( in105, in121 );             \
    in89 = GF_ADD( in89, in121 );               \
    in57 = GF_ADD( in57, in121 );               \
    in121 = gf_zero();                          \
    in122 = GF_MUL( in122, 186 );               \
    in120 = GF_ADD( in120, in122 );             \
    in114 = GF_ADD( in114, in122 );             \
    in106 = GF_ADD( in106, in122 );             \
    in90 = GF_ADD( in90, in122 );               \
    in58 = GF_ADD( in58, in122 );               \
    in122 = gf_zero();                          \
    in123 = GF_MUL( in123, 186 );               \
    in122 = GF_ADD( in122, in123 );             \
    in121 = GF_ADD( in121, in123 );             \
    in115 = GF_ADD( in115, in123 );             \
    in107 = GF_ADD( in107, in123 );             \
    in91 = GF_ADD( in91, in123 );               \
    in59 = GF_ADD( in59, in123 );               \
    in123 = gf_zero();                          \
    in124 = GF_MUL( in124, 254 );               \
    in120 = GF_ADD( in120, in124 );             \
    in116 = GF_ADD( in116, in124 );             \
    in108 = GF_ADD( in108, in124 );             \
    in92 = GF_ADD( in92, in124 );               \
    in60 = GF_ADD( in60, in124 );               \
    in124 = gf_zero();                          \
    in125 = GF_MUL( in125, 254 );               \
    in124 = GF_ADD( in124, in125 );             \
    in121 = GF_ADD( in121, in125 );             \
    in117 = GF_ADD( in117, in125 );             \
    in109 = GF_ADD( in109, in125 );             \
    in93 = GF_ADD( in93, in125 );               \
    in61 = GF_ADD( in61, in125 );               \
    in125 = gf_zero();                          \
    in126 = GF_MUL( in126, 222 );               \
    in124 = GF_ADD( in124, in126 );             \
    in122 = GF_ADD( in122, in126 );             \
    in118 = GF_ADD( in118, in126 );             \
    in110 = GF_ADD( in110, in126 );             \
    in94 = GF_ADD( in94, in126 );               \
    in62 = GF_ADD( in62, in126 );               \
    in126 = gf_zero();                          \
    in127 = GF_MUL( in127, 222 );               \
    in126 = GF_ADD( in126, in127 );             \
    in125 = GF_ADD( in125, in127 );             \
    in123 = GF_ADD( in123, in127 );             \
    in119 = GF_ADD( in119, in127 );             \
    in111 = GF_ADD( in111, in127 );             \
    in95 = GF_ADD( in95, in127 );               \
    in63 = GF_ADD( in63, in127 );               \
    in127 = gf_zero();                          \
    in00 = GF_MUL( in00, 1 );                   \
    in01 = GF_MUL( in01, 1 );                   \
    in02 = GF_MUL( in02, 6 );                   \
    in03 = GF_MUL( in03, 6 );                   \
    in04 = GF_MUL( in04, 108 );                 \
    in05 = GF_MUL( in05, 108 );                 \
    in06 = GF_MUL( in06, 117 );                 \
    in07 = GF_MUL( in07, 117 );                 \
    in08 = GF_MUL( in08, 208 );                 \
    in09 = GF_MUL( in09, 208 );                 \
    in10 = GF_MUL( in10, 218 );                 \
    in11 = GF_MUL( in11, 218 );                 \
    in12 = GF_MUL( in12, 136 );                 \
    in13 = GF_MUL( in13, 136 );                 \
    in14 = GF_MUL( in14, 23 );                  \
    in15 = GF_MUL( in15, 23 );                  \
    in16 = GF_MUL( in16, 42 );                  \
    in17 = GF_MUL( in17, 42 );                  \
    in18 = GF_MUL( in18, 252 );                 \
    in19 = GF_MUL( in19, 252 );                 \
    in20 = GF_MUL( in20, 158 );                 \
    in21 = GF_MUL( in21, 158 );                 \
    in22 = GF_MUL( in22, 99 );                  \
    in23 = GF_MUL( in23, 99 );                  \
    in24 = GF_MUL( in24, 108 );                 \
    in25 = GF_MUL( in25, 108 );                 \
    in26 = GF_MUL( in26, 117 );                 \
    in27 = GF_MUL( in27, 117 );                 \
    in28 = GF_MUL( in28, 233 );                 \
    in29 = GF_MUL( in29, 233 );                 \
    in30 = GF_MUL( in30, 76 );                  \
    in31 = GF_MUL( in31, 76 );                  \
    in32 = GF_MUL( in32, 165 );                 \
    in33 = GF_MUL( in33, 165 );                 \
    in34 = GF_MUL( in34, 249 );                 \
    in35 = GF_MUL( in35, 249 );                 \
    in36 = GF_MUL( in36, 196 );                 \
    in37 = GF_MUL( in37, 196 );                 \
    in38 = GF_MUL( in38, 162 );                 \
    in39 = GF_MUL( in39, 162 );                 \
    in40 = GF_MUL( in40, 212 );                 \
    in41 = GF_MUL( in41, 212 );                 \
    in42 = GF_MUL( in42, 194 );                 \
    in43 = GF_MUL( in43, 194 );                 \
    in44 = GF_MUL( in44, 37 );                  \
    in45 = GF_MUL( in45, 37 );                  \
    in46 = GF_MUL( in46, 222 );                 \
    in47 = GF_MUL( in47, 222 );                 \
    in48 = GF_MUL( in48, 15 );                  \
    in49 = GF_MUL( in49, 15 );                  \
    in50 = GF_MUL( in50, 34 );                  \
    in51 = GF_MUL( in51, 34 );                  \
    in52 = GF_MUL( in52, 94 );                  \
    in53 = GF_MUL( in53, 94 );                  \
    in54 = GF_MUL( in54, 217 );                 \
    in55 = GF_MUL( in55, 217 );                 \
    in56 = GF_MUL( in56, 196 );                 \
    in57 = GF_MUL( in57, 196 );                 \
    in58 = GF_MUL( in58, 162 );                 \
    in59 = GF_MUL( in59, 162 );                 \
    in60 = GF_MUL( in60, 171 );                 \
    in61 = GF_MUL( in61, 171 );                 \
    in62 = GF_MUL( in62, 221 );                 \
    in63 = GF_MUL( in63, 221 );                 \
    in64 = GF_MUL( in64, 250 );                 \
    in65 = GF_MUL( in65, 250 );                 \
    in66 = GF_MUL( in66, 38 );                  \
    in67 = GF_MUL( in67, 38 );                  \
    in68 = GF_MUL( in68, 22 );                  \
    in69 = GF_MUL( in69, 22 );                  \
    in70 = GF_MUL( in70, 116 );                 \
    in71 = GF_MUL( in71, 116 );                 \
    in72 = GF_MUL( in72, 175 );                 \
    in73 = GF_MUL( in73, 175 );                 \
    in74 = GF_MUL( in74, 197 );                 \
    in75 = GF_MUL( in75, 197 );                 \
    in76 = GF_MUL( in76, 91 );                  \
    in77 = GF_MUL( in77, 91 );                  \
    in78 = GF_MUL( in78, 199 );                 \
    in79 = GF_MUL( in79, 199 );                 \
    in80 = GF_MUL( in80, 92 );                  \
    in81 = GF_MUL( in81, 92 );                  \
    in82 = GF_MUL( in82, 213 );                 \
    in83 = GF_MUL( in83, 213 );                 \
    in84 = GF_MUL( in84, 102 );                 \
    in85 = GF_MUL( in85, 102 );                 \
    in86 = GF_MUL( in86, 73 );                  \
    in87 = GF_MUL( in87, 73 );                  \
    in88 = GF_MUL( in88, 22 );                  \
    in89 = GF_MUL( in89, 22 );                  \
    in90 = GF_MUL( in90, 116 );                 \
    in91 = GF_MUL( in91, 116 );                 \
    in92 = GF_MUL( in92, 251 );                 \
    in93 = GF_MUL( in93, 251 );                 \
    in94 = GF_MUL( in94, 32 );                  \
    in95 = GF_MUL( in95, 32 );                  \
    in96 = GF_MUL( in96, 219 );                 \
    in97 = GF_MUL( in97, 219 );                 \
    in98 = GF_MUL( in98, 224 );                 \
    in99 = GF_MUL( in99, 224 );                 \
    in100 = GF_MUL( in100, 123 );               \
    in101 = GF_MUL( in101, 123 );               \
    in102 = GF_MUL( in102, 7 );                 \
    in103 = GF_MUL( in103, 7 );                 \
    in104 = GF_MUL( in104, 96 );                \
    in105 = GF_MUL( in105, 96 );                \
    in106 = GF_MUL( in106, 93 );                \
    in107 = GF_MUL( in107, 93 );                \
    in108 = GF_MUL( in108, 3 );                 \
    in109 = GF_MUL( in109, 3 );                 \
    in110 = GF_MUL( in110, 10 );                \
    in111 = GF_MUL( in111, 10 );                \
    in112 = GF_MUL( in112, 95 );                \
    in113 = GF_MUL( in113, 95 );                \
    in114 = GF_MUL( in114, 223 );               \
    in115 = GF_MUL( in115, 223 );               \
    in116 = GF_MUL( in116, 210 );               \
    in117 = GF_MUL( in117, 210 );               \
    in118 = GF_MUL( in118, 214 );               \
    in119 = GF_MUL( in119, 214 );               \
    in120 = GF_MUL( in120, 123 );               \
    in121 = GF_MUL( in121, 123 );               \
    in122 = GF_MUL( in122, 7 );                 \
    in123 = GF_MUL( in123, 7 );                 \
    in124 = GF_MUL( in124, 126 );               \
    in125 = GF_MUL( in125, 126 );               \
    in126 = GF_MUL( in126, 25 );                \
    in127 = GF_MUL( in127, 25 );                \
  } while( 0 )

#define FD_REEDSOL_FDERIV_IMPL_256( in00, in01, \
    in02, in03, in04, in05, in06, in07, in08  , \
    in09, in10, in11, in12, in13, in14, in15  , \
    in16, in17, in18, in19, in20, in21, in22  , \
    in23, in24, in25, in26, in27, in28, in29  , \
    in30, in31, in32, in33, in34, in35, in36  , \
    in37, in38, in39, in40, in41, in42, in43  , \
    in44, in45, in46, in47, in48, in49, in50  , \
    in51, in52, in53, in54, in55, in56, in57  , \
    in58, in59, in60, in61, in62, in63, in64  , \
    in65, in66, in67, in68, in69, in70, in71  , \
    in72, in73, in74, in75, in76, in77, in78  , \
    in79, in80, in81, in82, in83, in84, in85  , \
    in86, in87, in88, in89, in90, in91, in92  , \
    in93, in94, in95, in96, in97, in98, in99  , \
    in100, in101, in102, in103, in104, in105  , \
    in106, in107, in108, in109, in110, in111  , \
    in112, in113, in114, in115, in116, in117  , \
    in118, in119, in120, in121, in122, in123  , \
    in124, in125, in126, in127, in128, in129  , \
    in130, in131, in132, in133, in134, in135  , \
    in136, in137, in138, in139, in140, in141  , \
    in142, in143, in144, in145, in146, in147  , \
    in148, in149, in150, in151, in152, in153  , \
    in154, in155, in156, in157, in158, in159  , \
    in160, in161, in162, in163, in164, in165  , \
    in166, in167, in168, in169, in170, in171  , \
    in172, in173, in174, in175, in176, in177  , \
    in178, in179, in180, in181, in182, in183  , \
    in184, in185, in186, in187, in188, in189  , \
    in190, in191, in192, in193, in194, in195  , \
    in196, in197, in198, in199, in200, in201  , \
    in202, in203, in204, in205, in206, in207  , \
    in208, in209, in210, in211, in212, in213  , \
    in214, in215, in216, in217, in218, in219  , \
    in220, in221, in222, in223, in224, in225  , \
    in226, in227, in228, in229, in230, in231  , \
    in232, in233, in234, in235, in236, in237  , \
    in238, in239, in240, in241, in242, in243  , \
    in244, in245, in246, in247, in248, in249  , \
    in250, in251, in252, in253, in254, in255)   \
  do {                                          \
    in00 = GF_MUL( in00, 1 );                   \
    in00 = gf_zero();                           \
    in01 = GF_MUL( in01, 1 );                   \
    in00 = GF_ADD( in00, in01 );                \
    in01 = gf_zero();                           \
    in02 = GF_MUL( in02, 122 );                 \
    in00 = GF_ADD( in00, in02 );                \
    in02 = gf_zero();                           \
    in03 = GF_MUL( in03, 122 );                 \
    in02 = GF_ADD( in02, in03 );                \
    in01 = GF_ADD( in01, in03 );                \
    in03 = gf_zero();                           \
    in04 = GF_MUL( in04, 32 );                  \
    in00 = GF_ADD( in00, in04 );                \
    in04 = gf_zero();                           \
    in05 = GF_MUL( in05, 32 );                  \
    in04 = GF_ADD( in04, in05 );                \
    in01 = GF_ADD( in01, in05 );                \
    in05 = gf_zero();                           \
    in06 = GF_MUL( in06, 251 );                 \
    in04 = GF_ADD( in04, in06 );                \
    in02 = GF_ADD( in02, in06 );                \
    in06 = gf_zero();                           \
    in07 = GF_MUL( in07, 251 );                 \
    in06 = GF_ADD( in06, in07 );                \
    in05 = GF_ADD( in05, in07 );                \
    in03 = GF_ADD( in03, in07 );                \
    in07 = gf_zero();                           \
    in08 = GF_MUL( in08, 41 );                  \
    in00 = GF_ADD( in00, in08 );                \
    in08 = gf_zero();                           \
    in09 = GF_MUL( in09, 41 );                  \
    in08 = GF_ADD( in08, in09 );                \
    in01 = GF_ADD( in01, in09 );                \
    in09 = gf_zero();                           \
    in10 = GF_MUL( in10, 118 );                 \
    in08 = GF_ADD( in08, in10 );                \
    in02 = GF_ADD( in02, in10 );                \
    in10 = gf_zero();                           \
    in11 = GF_MUL( in11, 118 );                 \
    in10 = GF_ADD( in10, in11 );                \
    in09 = GF_ADD( in09, in11 );                \
    in03 = GF_ADD( in03, in11 );                \
    in11 = gf_zero();                           \
    in12 = GF_MUL( in12, 73 );                  \
    in08 = GF_ADD( in08, in12 );                \
    in04 = GF_ADD( in04, in12 );                \
    in12 = gf_zero();                           \
    in13 = GF_MUL( in13, 73 );                  \
    in12 = GF_ADD( in12, in13 );                \
    in09 = GF_ADD( in09, in13 );                \
    in05 = GF_ADD( in05, in13 );                \
    in13 = gf_zero();                           \
    in14 = GF_MUL( in14, 102 );                 \
    in12 = GF_ADD( in12, in14 );                \
    in10 = GF_ADD( in10, in14 );                \
    in06 = GF_ADD( in06, in14 );                \
    in14 = gf_zero();                           \
    in15 = GF_MUL( in15, 102 );                 \
    in14 = GF_ADD( in14, in15 );                \
    in13 = GF_ADD( in13, in15 );                \
    in11 = GF_ADD( in11, in15 );                \
    in07 = GF_ADD( in07, in15 );                \
    in15 = gf_zero();                           \
    in16 = GF_MUL( in16, 31 );                  \
    in00 = GF_ADD( in00, in16 );                \
    in16 = gf_zero();                           \
    in17 = GF_MUL( in17, 31 );                  \
    in16 = GF_ADD( in16, in17 );                \
    in01 = GF_ADD( in01, in17 );                \
    in17 = gf_zero();                           \
    in18 = GF_MUL( in18, 127 );                 \
    in16 = GF_ADD( in16, in18 );                \
    in02 = GF_ADD( in02, in18 );                \
    in18 = gf_zero();                           \
    in19 = GF_MUL( in19, 127 );                 \
    in18 = GF_ADD( in18, in19 );                \
    in17 = GF_ADD( in17, in19 );                \
    in03 = GF_ADD( in03, in19 );                \
    in19 = gf_zero();                           \
    in20 = GF_MUL( in20, 199 );                 \
    in16 = GF_ADD( in16, in20 );                \
    in04 = GF_ADD( in04, in20 );                \
    in20 = gf_zero();                           \
    in21 = GF_MUL( in21, 199 );                 \
    in20 = GF_ADD( in20, in21 );                \
    in17 = GF_ADD( in17, in21 );                \
    in05 = GF_ADD( in05, in21 );                \
    in21 = gf_zero();                           \
    in22 = GF_MUL( in22, 91 );                  \
    in20 = GF_ADD( in20, in22 );                \
    in18 = GF_ADD( in18, in22 );                \
    in06 = GF_ADD( in06, in22 );                \
    in22 = gf_zero();                           \
    in23 = GF_MUL( in23, 91 );                  \
    in22 = GF_ADD( in22, in23 );                \
    in21 = GF_ADD( in21, in23 );                \
    in19 = GF_ADD( in19, in23 );                \
    in07 = GF_ADD( in07, in23 );                \
    in23 = gf_zero();                           \
    in24 = GF_MUL( in24, 32 );                  \
    in16 = GF_ADD( in16, in24 );                \
    in08 = GF_ADD( in08, in24 );                \
    in24 = gf_zero();                           \
    in25 = GF_MUL( in25, 32 );                  \
    in24 = GF_ADD( in24, in25 );                \
    in17 = GF_ADD( in17, in25 );                \
    in09 = GF_ADD( in09, in25 );                \
    in25 = gf_zero();                           \
    in26 = GF_MUL( in26, 251 );                 \
    in24 = GF_ADD( in24, in26 );                \
    in18 = GF_ADD( in18, in26 );                \
    in10 = GF_ADD( in10, in26 );                \
    in26 = gf_zero();                           \
    in27 = GF_MUL( in27, 251 );                 \
    in26 = GF_ADD( in26, in27 );                \
    in25 = GF_ADD( in25, in27 );                \
    in19 = GF_ADD( in19, in27 );                \
    in11 = GF_ADD( in11, in27 );                \
    in27 = gf_zero();                           \
    in28 = GF_MUL( in28, 116 );                 \
    in24 = GF_ADD( in24, in28 );                \
    in20 = GF_ADD( in20, in28 );                \
    in12 = GF_ADD( in12, in28 );                \
    in28 = gf_zero();                           \
    in29 = GF_MUL( in29, 116 );                 \
    in28 = GF_ADD( in28, in29 );                \
    in25 = GF_ADD( in25, in29 );                \
    in21 = GF_ADD( in21, in29 );                \
    in13 = GF_ADD( in13, in29 );                \
    in29 = gf_zero();                           \
    in30 = GF_MUL( in30, 22 );                  \
    in28 = GF_ADD( in28, in30 );                \
    in26 = GF_ADD( in26, in30 );                \
    in22 = GF_ADD( in22, in30 );                \
    in14 = GF_ADD( in14, in30 );                \
    in30 = gf_zero();                           \
    in31 = GF_MUL( in31, 22 );                  \
    in30 = GF_ADD( in30, in31 );                \
    in29 = GF_ADD( in29, in31 );                \
    in27 = GF_ADD( in27, in31 );                \
    in23 = GF_ADD( in23, in31 );                \
    in15 = GF_ADD( in15, in31 );                \
    in31 = gf_zero();                           \
    in32 = GF_MUL( in32, 194 );                 \
    in00 = GF_ADD( in00, in32 );                \
    in32 = gf_zero();                           \
    in33 = GF_MUL( in33, 194 );                 \
    in32 = GF_ADD( in32, in33 );                \
    in01 = GF_ADD( in01, in33 );                \
    in33 = gf_zero();                           \
    in34 = GF_MUL( in34, 212 );                 \
    in32 = GF_ADD( in32, in34 );                \
    in02 = GF_ADD( in02, in34 );                \
    in34 = gf_zero();                           \
    in35 = GF_MUL( in35, 212 );                 \
    in34 = GF_ADD( in34, in35 );                \
    in33 = GF_ADD( in33, in35 );                \
    in03 = GF_ADD( in03, in35 );                \
    in35 = gf_zero();                           \
    in36 = GF_MUL( in36, 101 );                 \
    in32 = GF_ADD( in32, in36 );                \
    in04 = GF_ADD( in04, in36 );                \
    in36 = gf_zero();                           \
    in37 = GF_MUL( in37, 101 );                 \
    in36 = GF_ADD( in36, in37 );                \
    in33 = GF_ADD( in33, in37 );                \
    in05 = GF_ADD( in05, in37 );                \
    in37 = gf_zero();                           \
    in38 = GF_MUL( in38, 159 );                 \
    in36 = GF_ADD( in36, in38 );                \
    in34 = GF_ADD( in34, in38 );                \
    in06 = GF_ADD( in06, in38 );                \
    in38 = gf_zero();                           \
    in39 = GF_MUL( in39, 159 );                 \
    in38 = GF_ADD( in38, in39 );                \
    in37 = GF_ADD( in37, in39 );                \
    in35 = GF_ADD( in35, in39 );                \
    in07 = GF_ADD( in07, in39 );                \
    in39 = gf_zero();                           \
    in40 = GF_MUL( in40, 249 );                 \
    in32 = GF_ADD( in32, in40 );                \
    in08 = GF_ADD( in08, in40 );                \
    in40 = gf_zero();                           \
    in41 = GF_MUL( in41, 249 );                 \
    in40 = GF_ADD( in40, in41 );                \
    in33 = GF_ADD( in33, in41 );                \
    in09 = GF_ADD( in09, in41 );                \
    in41 = gf_zero();                           \
    in42 = GF_MUL( in42, 165 );                 \
    in40 = GF_ADD( in40, in42 );                \
    in34 = GF_ADD( in34, in42 );                \
    in10 = GF_ADD( in10, in42 );                \
    in42 = gf_zero();                           \
    in43 = GF_MUL( in43, 165 );                 \
    in42 = GF_ADD( in42, in43 );                \
    in41 = GF_ADD( in41, in43 );                \
    in35 = GF_ADD( in35, in43 );                \
    in11 = GF_ADD( in11, in43 );                \
    in43 = gf_zero();                           \
    in44 = GF_MUL( in44, 86 );                  \
    in40 = GF_ADD( in40, in44 );                \
    in36 = GF_ADD( in36, in44 );                \
    in12 = GF_ADD( in12, in44 );                \
    in44 = gf_zero();                           \
    in45 = GF_MUL( in45, 86 );                  \
    in44 = GF_ADD( in44, in45 );                \
    in41 = GF_ADD( in41, in45 );                \
    in37 = GF_ADD( in37, in45 );                \
    in13 = GF_ADD( in13, in45 );                \
    in45 = gf_zero();                           \
    in46 = GF_MUL( in46, 25 );                  \
    in44 = GF_ADD( in44, in46 );                \
    in42 = GF_ADD( in42, in46 );                \
    in38 = GF_ADD( in38, in46 );                \
    in14 = GF_ADD( in14, in46 );                \
    in46 = gf_zero();                           \
    in47 = GF_MUL( in47, 25 );                  \
    in46 = GF_ADD( in46, in47 );                \
    in45 = GF_ADD( in45, in47 );                \
    in43 = GF_ADD( in43, in47 );                \
    in39 = GF_ADD( in39, in47 );                \
    in15 = GF_ADD( in15, in47 );                \
    in47 = gf_zero();                           \
    in48 = GF_MUL( in48, 150 );                 \
    in32 = GF_ADD( in32, in48 );                \
    in16 = GF_ADD( in16, in48 );                \
    in48 = gf_zero();                           \
    in49 = GF_MUL( in49, 150 );                 \
    in48 = GF_ADD( in48, in49 );                \
    in33 = GF_ADD( in33, in49 );                \
    in17 = GF_ADD( in17, in49 );                \
    in49 = gf_zero();                           \
    in50 = GF_MUL( in50, 57 );                  \
    in48 = GF_ADD( in48, in50 );                \
    in34 = GF_ADD( in34, in50 );                \
    in18 = GF_ADD( in18, in50 );                \
    in50 = gf_zero();                           \
    in51 = GF_MUL( in51, 57 );                  \
    in50 = GF_ADD( in50, in51 );                \
    in49 = GF_ADD( in49, in51 );                \
    in35 = GF_ADD( in35, in51 );                \
    in19 = GF_ADD( in19, in51 );                \
    in51 = gf_zero();                           \
    in52 = GF_MUL( in52, 55 );                  \
    in48 = GF_ADD( in48, in52 );                \
    in36 = GF_ADD( in36, in52 );                \
    in20 = GF_ADD( in20, in52 );                \
    in52 = gf_zero();                           \
    in53 = GF_MUL( in53, 55 );                  \
    in52 = GF_ADD( in52, in53 );                \
    in49 = GF_ADD( in49, in53 );                \
    in37 = GF_ADD( in37, in53 );                \
    in21 = GF_ADD( in21, in53 );                \
    in53 = gf_zero();                           \
    in54 = GF_MUL( in54, 115 );                 \
    in52 = GF_ADD( in52, in54 );                \
    in50 = GF_ADD( in50, in54 );                \
    in38 = GF_ADD( in38, in54 );                \
    in22 = GF_ADD( in22, in54 );                \
    in54 = gf_zero();                           \
    in55 = GF_MUL( in55, 115 );                 \
    in54 = GF_ADD( in54, in55 );                \
    in53 = GF_ADD( in53, in55 );                \
    in51 = GF_ADD( in51, in55 );                \
    in39 = GF_ADD( in39, in55 );                \
    in23 = GF_ADD( in23, in55 );                \
    in55 = gf_zero();                           \
    in56 = GF_MUL( in56, 101 );                 \
    in48 = GF_ADD( in48, in56 );                \
    in40 = GF_ADD( in40, in56 );                \
    in24 = GF_ADD( in24, in56 );                \
    in56 = gf_zero();                           \
    in57 = GF_MUL( in57, 101 );                 \
    in56 = GF_ADD( in56, in57 );                \
    in49 = GF_ADD( in49, in57 );                \
    in41 = GF_ADD( in41, in57 );                \
    in25 = GF_ADD( in25, in57 );                \
    in57 = gf_zero();                           \
    in58 = GF_MUL( in58, 159 );                 \
    in56 = GF_ADD( in56, in58 );                \
    in50 = GF_ADD( in50, in58 );                \
    in42 = GF_ADD( in42, in58 );                \
    in26 = GF_ADD( in26, in58 );                \
    in58 = gf_zero();                           \
    in59 = GF_MUL( in59, 159 );                 \
    in58 = GF_ADD( in58, in59 );                \
    in57 = GF_ADD( in57, in59 );                \
    in51 = GF_ADD( in51, in59 );                \
    in43 = GF_ADD( in43, in59 );                \
    in27 = GF_ADD( in27, in59 );                \
    in59 = gf_zero();                           \
    in60 = GF_MUL( in60, 60 );                  \
    in56 = GF_ADD( in56, in60 );                \
    in52 = GF_ADD( in52, in60 );                \
    in44 = GF_ADD( in44, in60 );                \
    in28 = GF_ADD( in28, in60 );                \
    in60 = gf_zero();                           \
    in61 = GF_MUL( in61, 60 );                  \
    in60 = GF_ADD( in60, in61 );                \
    in57 = GF_ADD( in57, in61 );                \
    in53 = GF_ADD( in53, in61 );                \
    in45 = GF_ADD( in45, in61 );                \
    in29 = GF_ADD( in29, in61 );                \
    in61 = gf_zero();                           \
    in62 = GF_MUL( in62, 10 );                  \
    in60 = GF_ADD( in60, in62 );                \
    in58 = GF_ADD( in58, in62 );                \
    in54 = GF_ADD( in54, in62 );                \
    in46 = GF_ADD( in46, in62 );                \
    in30 = GF_ADD( in30, in62 );                \
    in62 = gf_zero();                           \
    in63 = GF_MUL( in63, 10 );                  \
    in62 = GF_ADD( in62, in63 );                \
    in61 = GF_ADD( in61, in63 );                \
    in59 = GF_ADD( in59, in63 );                \
    in55 = GF_ADD( in55, in63 );                \
    in47 = GF_ADD( in47, in63 );                \
    in31 = GF_ADD( in31, in63 );                \
    in63 = gf_zero();                           \
    in64 = GF_MUL( in64, 232 );                 \
    in00 = GF_ADD( in00, in64 );                \
    in64 = gf_zero();                           \
    in65 = GF_MUL( in65, 232 );                 \
    in64 = GF_ADD( in64, in65 );                \
    in01 = GF_ADD( in01, in65 );                \
    in65 = gf_zero();                           \
    in66 = GF_MUL( in66, 44 );                  \
    in64 = GF_ADD( in64, in66 );                \
    in02 = GF_ADD( in02, in66 );                \
    in66 = gf_zero();                           \
    in67 = GF_MUL( in67, 44 );                  \
    in66 = GF_ADD( in66, in67 );                \
    in65 = GF_ADD( in65, in67 );                \
    in03 = GF_ADD( in03, in67 );                \
    in67 = gf_zero();                           \
    in68 = GF_MUL( in68, 76 );                  \
    in64 = GF_ADD( in64, in68 );                \
    in04 = GF_ADD( in04, in68 );                \
    in68 = gf_zero();                           \
    in69 = GF_MUL( in69, 76 );                  \
    in68 = GF_ADD( in68, in69 );                \
    in65 = GF_ADD( in65, in69 );                \
    in05 = GF_ADD( in05, in69 );                \
    in69 = gf_zero();                           \
    in70 = GF_MUL( in70, 233 );                 \
    in68 = GF_ADD( in68, in70 );                \
    in66 = GF_ADD( in66, in70 );                \
    in06 = GF_ADD( in06, in70 );                \
    in70 = gf_zero();                           \
    in71 = GF_MUL( in71, 233 );                 \
    in70 = GF_ADD( in70, in71 );                \
    in69 = GF_ADD( in69, in71 );                \
    in67 = GF_ADD( in67, in71 );                \
    in07 = GF_ADD( in07, in71 );                \
    in71 = gf_zero();                           \
    in72 = GF_MUL( in72, 183 );                 \
    in64 = GF_ADD( in64, in72 );                \
    in08 = GF_ADD( in08, in72 );                \
    in72 = gf_zero();                           \
    in73 = GF_MUL( in73, 183 );                 \
    in72 = GF_ADD( in72, in73 );                \
    in65 = GF_ADD( in65, in73 );                \
    in09 = GF_ADD( in09, in73 );                \
    in73 = gf_zero();                           \
    in74 = GF_MUL( in74, 184 );                 \
    in72 = GF_ADD( in72, in74 );                \
    in66 = GF_ADD( in66, in74 );                \
    in10 = GF_ADD( in10, in74 );                \
    in74 = gf_zero();                           \
    in75 = GF_MUL( in75, 184 );                 \
    in74 = GF_ADD( in74, in75 );                \
    in73 = GF_ADD( in73, in75 );                \
    in67 = GF_ADD( in67, in75 );                \
    in11 = GF_ADD( in11, in75 );                \
    in75 = gf_zero();                           \
    in76 = GF_MUL( in76, 99 );                  \
    in72 = GF_ADD( in72, in76 );                \
    in68 = GF_ADD( in68, in76 );                \
    in12 = GF_ADD( in12, in76 );                \
    in76 = gf_zero();                           \
    in77 = GF_MUL( in77, 99 );                  \
    in76 = GF_ADD( in76, in77 );                \
    in73 = GF_ADD( in73, in77 );                \
    in69 = GF_ADD( in69, in77 );                \
    in13 = GF_ADD( in13, in77 );                \
    in77 = gf_zero();                           \
    in78 = GF_MUL( in78, 158 );                 \
    in76 = GF_ADD( in76, in78 );                \
    in74 = GF_ADD( in74, in78 );                \
    in70 = GF_ADD( in70, in78 );                \
    in14 = GF_ADD( in14, in78 );                \
    in78 = gf_zero();                           \
    in79 = GF_MUL( in79, 158 );                 \
    in78 = GF_ADD( in78, in79 );                \
    in77 = GF_ADD( in77, in79 );                \
    in75 = GF_ADD( in75, in79 );                \
    in71 = GF_ADD( in71, in79 );                \
    in15 = GF_ADD( in15, in79 );                \
    in79 = gf_zero();                           \
    in80 = GF_MUL( in80, 151 );                 \
    in64 = GF_ADD( in64, in80 );                \
    in16 = GF_ADD( in16, in80 );                \
    in80 = gf_zero();                           \
    in81 = GF_MUL( in81, 151 );                 \
    in80 = GF_ADD( in80, in81 );                \
    in65 = GF_ADD( in65, in81 );                \
    in17 = GF_ADD( in17, in81 );                \
    in81 = gf_zero();                           \
    in82 = GF_MUL( in82, 67 );                  \
    in80 = GF_ADD( in80, in82 );                \
    in66 = GF_ADD( in66, in82 );                \
    in18 = GF_ADD( in18, in82 );                \
    in82 = gf_zero();                           \
    in83 = GF_MUL( in83, 67 );                  \
    in82 = GF_ADD( in82, in83 );                \
    in81 = GF_ADD( in81, in83 );                \
    in67 = GF_ADD( in67, in83 );                \
    in19 = GF_ADD( in19, in83 );                \
    in83 = gf_zero();                           \
    in84 = GF_MUL( in84, 23 );                  \
    in80 = GF_ADD( in80, in84 );                \
    in68 = GF_ADD( in68, in84 );                \
    in20 = GF_ADD( in20, in84 );                \
    in84 = gf_zero();                           \
    in85 = GF_MUL( in85, 23 );                  \
    in84 = GF_ADD( in84, in85 );                \
    in81 = GF_ADD( in81, in85 );                \
    in69 = GF_ADD( in69, in85 );                \
    in21 = GF_ADD( in21, in85 );                \
    in85 = gf_zero();                           \
    in86 = GF_MUL( in86, 136 );                 \
    in84 = GF_ADD( in84, in86 );                \
    in82 = GF_ADD( in82, in86 );                \
    in70 = GF_ADD( in70, in86 );                \
    in22 = GF_ADD( in22, in86 );                \
    in86 = gf_zero();                           \
    in87 = GF_MUL( in87, 136 );                 \
    in86 = GF_ADD( in86, in87 );                \
    in85 = GF_ADD( in85, in87 );                \
    in83 = GF_ADD( in83, in87 );                \
    in71 = GF_ADD( in71, in87 );                \
    in23 = GF_ADD( in23, in87 );                \
    in87 = gf_zero();                           \
    in88 = GF_MUL( in88, 76 );                  \
    in80 = GF_ADD( in80, in88 );                \
    in72 = GF_ADD( in72, in88 );                \
    in24 = GF_ADD( in24, in88 );                \
    in88 = gf_zero();                           \
    in89 = GF_MUL( in89, 76 );                  \
    in88 = GF_ADD( in88, in89 );                \
    in81 = GF_ADD( in81, in89 );                \
    in73 = GF_ADD( in73, in89 );                \
    in25 = GF_ADD( in25, in89 );                \
    in89 = gf_zero();                           \
    in90 = GF_MUL( in90, 233 );                 \
    in88 = GF_ADD( in88, in90 );                \
    in82 = GF_ADD( in82, in90 );                \
    in74 = GF_ADD( in74, in90 );                \
    in26 = GF_ADD( in26, in90 );                \
    in90 = gf_zero();                           \
    in91 = GF_MUL( in91, 233 );                 \
    in90 = GF_ADD( in90, in91 );                \
    in89 = GF_ADD( in89, in91 );                \
    in83 = GF_ADD( in83, in91 );                \
    in75 = GF_ADD( in75, in91 );                \
    in27 = GF_ADD( in27, in91 );                \
    in91 = gf_zero();                           \
    in92 = GF_MUL( in92, 117 );                 \
    in88 = GF_ADD( in88, in92 );                \
    in84 = GF_ADD( in84, in92 );                \
    in76 = GF_ADD( in76, in92 );                \
    in28 = GF_ADD( in28, in92 );                \
    in92 = gf_zero();                           \
    in93 = GF_MUL( in93, 117 );                 \
    in92 = GF_ADD( in92, in93 );                \
    in89 = GF_ADD( in89, in93 );                \
    in85 = GF_ADD( in85, in93 );                \
    in77 = GF_ADD( in77, in93 );                \
    in29 = GF_ADD( in29, in93 );                \
    in93 = gf_zero();                           \
    in94 = GF_MUL( in94, 108 );                 \
    in92 = GF_ADD( in92, in94 );                \
    in90 = GF_ADD( in90, in94 );                \
    in86 = GF_ADD( in86, in94 );                \
    in78 = GF_ADD( in78, in94 );                \
    in30 = GF_ADD( in30, in94 );                \
    in94 = gf_zero();                           \
    in95 = GF_MUL( in95, 108 );                 \
    in94 = GF_ADD( in94, in95 );                \
    in93 = GF_ADD( in93, in95 );                \
    in91 = GF_ADD( in91, in95 );                \
    in87 = GF_ADD( in87, in95 );                \
    in79 = GF_ADD( in79, in95 );                \
    in31 = GF_ADD( in31, in95 );                \
    in95 = gf_zero();                           \
    in96 = GF_MUL( in96, 120 );                 \
    in64 = GF_ADD( in64, in96 );                \
    in32 = GF_ADD( in32, in96 );                \
    in96 = gf_zero();                           \
    in97 = GF_MUL( in97, 120 );                 \
    in96 = GF_ADD( in96, in97 );                \
    in65 = GF_ADD( in65, in97 );                \
    in33 = GF_ADD( in33, in97 );                \
    in97 = gf_zero();                           \
    in98 = GF_MUL( in98, 20 );                  \
    in96 = GF_ADD( in96, in98 );                \
    in66 = GF_ADD( in66, in98 );                \
    in34 = GF_ADD( in34, in98 );                \
    in98 = gf_zero();                           \
    in99 = GF_MUL( in99, 20 );                  \
    in98 = GF_ADD( in98, in99 );                \
    in97 = GF_ADD( in97, in99 );                \
    in67 = GF_ADD( in67, in99 );                \
    in35 = GF_ADD( in35, in99 );                \
    in99 = gf_zero();                           \
    in100 = GF_MUL( in100, 187 );               \
    in96 = GF_ADD( in96, in100 );               \
    in68 = GF_ADD( in68, in100 );               \
    in36 = GF_ADD( in36, in100 );               \
    in100 = gf_zero();                          \
    in101 = GF_MUL( in101, 187 );               \
    in100 = GF_ADD( in100, in101 );             \
    in97 = GF_ADD( in97, in101 );               \
    in69 = GF_ADD( in69, in101 );               \
    in37 = GF_ADD( in37, in101 );               \
    in101 = gf_zero();                          \
    in102 = GF_MUL( in102, 186 );               \
    in100 = GF_ADD( in100, in102 );             \
    in98 = GF_ADD( in98, in102 );               \
    in70 = GF_ADD( in70, in102 );               \
    in38 = GF_ADD( in38, in102 );               \
    in102 = gf_zero();                          \
    in103 = GF_MUL( in103, 186 );               \
    in102 = GF_ADD( in102, in103 );             \
    in101 = GF_ADD( in101, in103 );             \
    in99 = GF_ADD( in99, in103 );               \
    in71 = GF_ADD( in71, in103 );               \
    in39 = GF_ADD( in39, in103 );               \
    in103 = gf_zero();                          \
    in104 = GF_MUL( in104, 36 );                \
    in96 = GF_ADD( in96, in104 );               \
    in72 = GF_ADD( in72, in104 );               \
    in40 = GF_ADD( in40, in104 );               \
    in104 = gf_zero();                          \
    in105 = GF_MUL( in105, 36 );                \
    in104 = GF_ADD( in104, in105 );             \
    in97 = GF_ADD( in97, in105 );               \
    in73 = GF_ADD( in73, in105 );               \
    in41 = GF_ADD( in41, in105 );               \
    in105 = gf_zero();                          \
    in106 = GF_MUL( in106, 14 );                \
    in104 = GF_ADD( in104, in106 );             \
    in98 = GF_ADD( in98, in106 );               \
    in74 = GF_ADD( in74, in106 );               \
    in42 = GF_ADD( in42, in106 );               \
    in106 = gf_zero();                          \
    in107 = GF_MUL( in107, 14 );                \
    in106 = GF_ADD( in106, in107 );             \
    in105 = GF_ADD( in105, in107 );             \
    in99 = GF_ADD( in99, in107 );               \
    in75 = GF_ADD( in75, in107 );               \
    in43 = GF_ADD( in43, in107 );               \
    in107 = gf_zero();                          \
    in108 = GF_MUL( in108, 244 );               \
    in104 = GF_ADD( in104, in108 );             \
    in100 = GF_ADD( in100, in108 );             \
    in76 = GF_ADD( in76, in108 );               \
    in44 = GF_ADD( in44, in108 );               \
    in108 = gf_zero();                          \
    in109 = GF_MUL( in109, 244 );               \
    in108 = GF_ADD( in108, in109 );             \
    in105 = GF_ADD( in105, in109 );             \
    in101 = GF_ADD( in101, in109 );             \
    in77 = GF_ADD( in77, in109 );               \
    in45 = GF_ADD( in45, in109 );               \
    in109 = gf_zero();                          \
    in110 = GF_MUL( in110, 221 );               \
    in108 = GF_ADD( in108, in110 );             \
    in106 = GF_ADD( in106, in110 );             \
    in102 = GF_ADD( in102, in110 );             \
    in78 = GF_ADD( in78, in110 );               \
    in46 = GF_ADD( in46, in110 );               \
    in110 = gf_zero();                          \
    in111 = GF_MUL( in111, 221 );               \
    in110 = GF_ADD( in110, in111 );             \
    in109 = GF_ADD( in109, in111 );             \
    in107 = GF_ADD( in107, in111 );             \
    in103 = GF_ADD( in103, in111 );             \
    in79 = GF_ADD( in79, in111 );               \
    in47 = GF_ADD( in47, in111 );               \
    in111 = gf_zero();                          \
    in112 = GF_MUL( in112, 65 );                \
    in96 = GF_ADD( in96, in112 );               \
    in80 = GF_ADD( in80, in112 );               \
    in48 = GF_ADD( in48, in112 );               \
    in112 = gf_zero();                          \
    in113 = GF_MUL( in113, 65 );                \
    in112 = GF_ADD( in112, in113 );             \
    in97 = GF_ADD( in97, in113 );               \
    in81 = GF_ADD( in81, in113 );               \
    in49 = GF_ADD( in49, in113 );               \
    in113 = gf_zero();                          \
    in114 = GF_MUL( in114, 145 );               \
    in112 = GF_ADD( in112, in114 );             \
    in98 = GF_ADD( in98, in114 );               \
    in82 = GF_ADD( in82, in114 );               \
    in50 = GF_ADD( in50, in114 );               \
    in114 = gf_zero();                          \
    in115 = GF_MUL( in115, 145 );               \
    in114 = GF_ADD( in114, in115 );             \
    in113 = GF_ADD( in113, in115 );             \
    in99 = GF_ADD( in99, in115 );               \
    in83 = GF_ADD( in83, in115 );               \
    in51 = GF_ADD( in51, in115 );               \
    in115 = gf_zero();                          \
    in116 = GF_MUL( in116, 200 );               \
    in112 = GF_ADD( in112, in116 );             \
    in100 = GF_ADD( in100, in116 );             \
    in84 = GF_ADD( in84, in116 );               \
    in52 = GF_ADD( in52, in116 );               \
    in116 = gf_zero();                          \
    in117 = GF_MUL( in117, 200 );               \
    in116 = GF_ADD( in116, in117 );             \
    in113 = GF_ADD( in113, in117 );             \
    in101 = GF_ADD( in101, in117 );             \
    in85 = GF_ADD( in85, in117 );               \
    in53 = GF_ADD( in53, in117 );               \
    in117 = gf_zero();                          \
    in118 = GF_MUL( in118, 215 );               \
    in116 = GF_ADD( in116, in118 );             \
    in114 = GF_ADD( in114, in118 );             \
    in102 = GF_ADD( in102, in118 );             \
    in86 = GF_ADD( in86, in118 );               \
    in54 = GF_ADD( in54, in118 );               \
    in118 = gf_zero();                          \
    in119 = GF_MUL( in119, 215 );               \
    in118 = GF_ADD( in118, in119 );             \
    in117 = GF_ADD( in117, in119 );             \
    in115 = GF_ADD( in115, in119 );             \
    in103 = GF_ADD( in103, in119 );             \
    in87 = GF_ADD( in87, in119 );               \
    in55 = GF_ADD( in55, in119 );               \
    in119 = gf_zero();                          \
    in120 = GF_MUL( in120, 187 );               \
    in112 = GF_ADD( in112, in120 );             \
    in104 = GF_ADD( in104, in120 );             \
    in88 = GF_ADD( in88, in120 );               \
    in56 = GF_ADD( in56, in120 );               \
    in120 = gf_zero();                          \
    in121 = GF_MUL( in121, 187 );               \
    in120 = GF_ADD( in120, in121 );             \
    in113 = GF_ADD( in113, in121 );             \
    in105 = GF_ADD( in105, in121 );             \
    in89 = GF_ADD( in89, in121 );               \
    in57 = GF_ADD( in57, in121 );               \
    in121 = gf_zero();                          \
    in122 = GF_MUL( in122, 186 );               \
    in120 = GF_ADD( in120, in122 );             \
    in114 = GF_ADD( in114, in122 );             \
    in106 = GF_ADD( in106, in122 );             \
    in90 = GF_ADD( in90, in122 );               \
    in58 = GF_ADD( in58, in122 );               \
    in122 = gf_zero();                          \
    in123 = GF_MUL( in123, 186 );               \
    in122 = GF_ADD( in122, in123 );             \
    in121 = GF_ADD( in121, in123 );             \
    in115 = GF_ADD( in115, in123 );             \
    in107 = GF_ADD( in107, in123 );             \
    in91 = GF_ADD( in91, in123 );               \
    in59 = GF_ADD( in59, in123 );               \
    in123 = gf_zero();                          \
    in124 = GF_MUL( in124, 254 );               \
    in120 = GF_ADD( in120, in124 );             \
    in116 = GF_ADD( in116, in124 );             \
    in108 = GF_ADD( in108, in124 );             \
    in92 = GF_ADD( in92, in124 );               \
    in60 = GF_ADD( in60, in124 );               \
    in124 = gf_zero();                          \
    in125 = GF_MUL( in125, 254 );               \
    in124 = GF_ADD( in124, in125 );             \
    in121 = GF_ADD( in121, in125 );             \
    in117 = GF_ADD( in117, in125 );             \
    in109 = GF_ADD( in109, in125 );             \
    in93 = GF_ADD( in93, in125 );               \
    in61 = GF_ADD( in61, in125 );               \
    in125 = gf_zero();                          \
    in126 = GF_MUL( in126, 222 );               \
    in124 = GF_ADD( in124, in126 );             \
    in122 = GF_ADD( in122, in126 );             \
    in118 = GF_ADD( in118, in126 );             \
    in110 = GF_ADD( in110, in126 );             \
    in94 = GF_ADD( in94, in126 );               \
    in62 = GF_ADD( in62, in126 );               \
    in126 = gf_zero();                          \
    in127 = GF_MUL( in127, 222 );               \
    in126 = GF_ADD( in126, in127 );             \
    in125 = GF_ADD( in125, in127 );             \
    in123 = GF_ADD( in123, in127 );             \
    in119 = GF_ADD( in119, in127 );             \
    in111 = GF_ADD( in111, in127 );             \
    in95 = GF_ADD( in95, in127 );               \
    in63 = GF_ADD( in63, in127 );               \
    in127 = gf_zero();                          \
    in128 = GF_MUL( in128, 71 );                \
    in00 = GF_ADD( in00, in128 );               \
    in128 = gf_zero();                          \
    in129 = GF_MUL( in129, 71 );                \
    in128 = GF_ADD( in128, in129 );             \
    in01 = GF_ADD( in01, in129 );               \
    in129 = gf_zero();                          \
    in130 = GF_MUL( in130, 144 );               \
    in128 = GF_ADD( in128, in130 );             \
    in02 = GF_ADD( in02, in130 );               \
    in130 = gf_zero();                          \
    in131 = GF_MUL( in131, 144 );               \
    in130 = GF_ADD( in130, in131 );             \
    in129 = GF_ADD( in129, in131 );             \
    in03 = GF_ADD( in03, in131 );               \
    in131 = gf_zero();                          \
    in132 = GF_MUL( in132, 8 );                 \
    in128 = GF_ADD( in128, in132 );             \
    in04 = GF_ADD( in04, in132 );               \
    in132 = gf_zero();                          \
    in133 = GF_MUL( in133, 8 );                 \
    in132 = GF_ADD( in132, in133 );             \
    in129 = GF_ADD( in129, in133 );             \
    in05 = GF_ADD( in05, in133 );               \
    in133 = gf_zero();                          \
    in134 = GF_MUL( in134, 247 );               \
    in132 = GF_ADD( in132, in134 );             \
    in130 = GF_ADD( in130, in134 );             \
    in06 = GF_ADD( in06, in134 );               \
    in134 = gf_zero();                          \
    in135 = GF_MUL( in135, 247 );               \
    in134 = GF_ADD( in134, in135 );             \
    in133 = GF_ADD( in133, in135 );             \
    in131 = GF_ADD( in131, in135 );             \
    in07 = GF_ADD( in07, in135 );               \
    in135 = gf_zero();                          \
    in136 = GF_MUL( in136, 77 );                \
    in128 = GF_ADD( in128, in136 );             \
    in08 = GF_ADD( in08, in136 );               \
    in136 = gf_zero();                          \
    in137 = GF_MUL( in137, 77 );                \
    in136 = GF_ADD( in136, in137 );             \
    in129 = GF_ADD( in129, in137 );             \
    in09 = GF_ADD( in09, in137 );               \
    in137 = gf_zero();                          \
    in138 = GF_MUL( in138, 147 );               \
    in136 = GF_ADD( in136, in138 );             \
    in130 = GF_ADD( in130, in138 );             \
    in10 = GF_ADD( in10, in138 );               \
    in138 = gf_zero();                          \
    in139 = GF_MUL( in139, 147 );               \
    in138 = GF_ADD( in138, in139 );             \
    in137 = GF_ADD( in137, in139 );             \
    in131 = GF_ADD( in131, in139 );             \
    in11 = GF_ADD( in11, in139 );               \
    in139 = gf_zero();                          \
    in140 = GF_MUL( in140, 85 );                \
    in136 = GF_ADD( in136, in140 );             \
    in132 = GF_ADD( in132, in140 );             \
    in12 = GF_ADD( in12, in140 );               \
    in140 = gf_zero();                          \
    in141 = GF_MUL( in141, 85 );                \
    in140 = GF_ADD( in140, in141 );             \
    in137 = GF_ADD( in137, in141 );             \
    in133 = GF_ADD( in133, in141 );             \
    in13 = GF_ADD( in13, in141 );               \
    in141 = gf_zero();                          \
    in142 = GF_MUL( in142, 151 );               \
    in140 = GF_ADD( in140, in142 );             \
    in138 = GF_ADD( in138, in142 );             \
    in134 = GF_ADD( in134, in142 );             \
    in14 = GF_ADD( in14, in142 );               \
    in142 = gf_zero();                          \
    in143 = GF_MUL( in143, 151 );               \
    in142 = GF_ADD( in142, in143 );             \
    in141 = GF_ADD( in141, in143 );             \
    in139 = GF_ADD( in139, in143 );             \
    in135 = GF_ADD( in135, in143 );             \
    in15 = GF_ADD( in15, in143 );               \
    in143 = gf_zero();                          \
    in144 = GF_MUL( in144, 206 );               \
    in128 = GF_ADD( in128, in144 );             \
    in16 = GF_ADD( in16, in144 );               \
    in144 = gf_zero();                          \
    in145 = GF_MUL( in145, 206 );               \
    in144 = GF_ADD( in144, in145 );             \
    in129 = GF_ADD( in129, in145 );             \
    in17 = GF_ADD( in17, in145 );               \
    in145 = gf_zero();                          \
    in146 = GF_MUL( in146, 214 );               \
    in144 = GF_ADD( in144, in146 );             \
    in130 = GF_ADD( in130, in146 );             \
    in18 = GF_ADD( in18, in146 );               \
    in146 = gf_zero();                          \
    in147 = GF_MUL( in147, 214 );               \
    in146 = GF_ADD( in146, in147 );             \
    in145 = GF_ADD( in145, in147 );             \
    in131 = GF_ADD( in131, in147 );             \
    in19 = GF_ADD( in19, in147 );               \
    in147 = gf_zero();                          \
    in148 = GF_MUL( in148, 248 );               \
    in144 = GF_ADD( in144, in148 );             \
    in132 = GF_ADD( in132, in148 );             \
    in20 = GF_ADD( in20, in148 );               \
    in148 = gf_zero();                          \
    in149 = GF_MUL( in149, 248 );               \
    in148 = GF_ADD( in148, in149 );             \
    in145 = GF_ADD( in145, in149 );             \
    in133 = GF_ADD( in133, in149 );             \
    in21 = GF_ADD( in21, in149 );               \
    in149 = gf_zero();                          \
    in150 = GF_MUL( in150, 223 );               \
    in148 = GF_ADD( in148, in150 );             \
    in146 = GF_ADD( in146, in150 );             \
    in134 = GF_ADD( in134, in150 );             \
    in22 = GF_ADD( in22, in150 );               \
    in150 = gf_zero();                          \
    in151 = GF_MUL( in151, 223 );               \
    in150 = GF_ADD( in150, in151 );             \
    in149 = GF_ADD( in149, in151 );             \
    in147 = GF_ADD( in147, in151 );             \
    in135 = GF_ADD( in135, in151 );             \
    in23 = GF_ADD( in23, in151 );               \
    in151 = gf_zero();                          \
    in152 = GF_MUL( in152, 8 );                 \
    in144 = GF_ADD( in144, in152 );             \
    in136 = GF_ADD( in136, in152 );             \
    in24 = GF_ADD( in24, in152 );               \
    in152 = gf_zero();                          \
    in153 = GF_MUL( in153, 8 );                 \
    in152 = GF_ADD( in152, in153 );             \
    in145 = GF_ADD( in145, in153 );             \
    in137 = GF_ADD( in137, in153 );             \
    in25 = GF_ADD( in25, in153 );               \
    in153 = gf_zero();                          \
    in154 = GF_MUL( in154, 247 );               \
    in152 = GF_ADD( in152, in154 );             \
    in146 = GF_ADD( in146, in154 );             \
    in138 = GF_ADD( in138, in154 );             \
    in26 = GF_ADD( in26, in154 );               \
    in154 = gf_zero();                          \
    in155 = GF_MUL( in155, 247 );               \
    in154 = GF_ADD( in154, in155 );             \
    in153 = GF_ADD( in153, in155 );             \
    in147 = GF_ADD( in147, in155 );             \
    in139 = GF_ADD( in139, in155 );             \
    in27 = GF_ADD( in27, in155 );               \
    in155 = gf_zero();                          \
    in156 = GF_MUL( in156, 29 );                \
    in152 = GF_ADD( in152, in156 );             \
    in148 = GF_ADD( in148, in156 );             \
    in140 = GF_ADD( in140, in156 );             \
    in28 = GF_ADD( in28, in156 );               \
    in156 = gf_zero();                          \
    in157 = GF_MUL( in157, 29 );                \
    in156 = GF_ADD( in156, in157 );             \
    in153 = GF_ADD( in153, in157 );             \
    in149 = GF_ADD( in149, in157 );             \
    in141 = GF_ADD( in141, in157 );             \
    in29 = GF_ADD( in29, in157 );               \
    in157 = gf_zero();                          \
    in158 = GF_MUL( in158, 139 );               \
    in156 = GF_ADD( in156, in158 );             \
    in154 = GF_ADD( in154, in158 );             \
    in150 = GF_ADD( in150, in158 );             \
    in142 = GF_ADD( in142, in158 );             \
    in30 = GF_ADD( in30, in158 );               \
    in158 = gf_zero();                          \
    in159 = GF_MUL( in159, 139 );               \
    in158 = GF_ADD( in158, in159 );             \
    in157 = GF_ADD( in157, in159 );             \
    in155 = GF_ADD( in155, in159 );             \
    in151 = GF_ADD( in151, in159 );             \
    in143 = GF_ADD( in143, in159 );             \
    in31 = GF_ADD( in31, in159 );               \
    in159 = gf_zero();                          \
    in160 = GF_MUL( in160, 190 );               \
    in128 = GF_ADD( in128, in160 );             \
    in32 = GF_ADD( in32, in160 );               \
    in160 = gf_zero();                          \
    in161 = GF_MUL( in161, 190 );               \
    in160 = GF_ADD( in160, in161 );             \
    in129 = GF_ADD( in129, in161 );             \
    in33 = GF_ADD( in33, in161 );               \
    in161 = gf_zero();                          \
    in162 = GF_MUL( in162, 53 );                \
    in160 = GF_ADD( in160, in162 );             \
    in130 = GF_ADD( in130, in162 );             \
    in34 = GF_ADD( in34, in162 );               \
    in162 = gf_zero();                          \
    in163 = GF_MUL( in163, 53 );                \
    in162 = GF_ADD( in162, in163 );             \
    in161 = GF_ADD( in161, in163 );             \
    in131 = GF_ADD( in131, in163 );             \
    in35 = GF_ADD( in35, in163 );               \
    in163 = gf_zero();                          \
    in164 = GF_MUL( in164, 94 );                \
    in160 = GF_ADD( in160, in164 );             \
    in132 = GF_ADD( in132, in164 );             \
    in36 = GF_ADD( in36, in164 );               \
    in164 = gf_zero();                          \
    in165 = GF_MUL( in165, 94 );                \
    in164 = GF_ADD( in164, in165 );             \
    in161 = GF_ADD( in161, in165 );             \
    in133 = GF_ADD( in133, in165 );             \
    in37 = GF_ADD( in37, in165 );               \
    in165 = gf_zero();                          \
    in166 = GF_MUL( in166, 238 );               \
    in164 = GF_ADD( in164, in166 );             \
    in162 = GF_ADD( in162, in166 );             \
    in134 = GF_ADD( in134, in166 );             \
    in38 = GF_ADD( in38, in166 );               \
    in166 = gf_zero();                          \
    in167 = GF_MUL( in167, 238 );               \
    in166 = GF_ADD( in166, in167 );             \
    in165 = GF_ADD( in165, in167 );             \
    in163 = GF_ADD( in163, in167 );             \
    in135 = GF_ADD( in135, in167 );             \
    in39 = GF_ADD( in39, in167 );               \
    in167 = gf_zero();                          \
    in168 = GF_MUL( in168, 121 );               \
    in160 = GF_ADD( in160, in168 );             \
    in136 = GF_ADD( in136, in168 );             \
    in40 = GF_ADD( in40, in168 );               \
    in168 = gf_zero();                          \
    in169 = GF_MUL( in169, 121 );               \
    in168 = GF_ADD( in168, in169 );             \
    in161 = GF_ADD( in161, in169 );             \
    in137 = GF_ADD( in137, in169 );             \
    in41 = GF_ADD( in41, in169 );               \
    in169 = gf_zero();                          \
    in170 = GF_MUL( in170, 110 );               \
    in168 = GF_ADD( in168, in170 );             \
    in162 = GF_ADD( in162, in170 );             \
    in138 = GF_ADD( in138, in170 );             \
    in42 = GF_ADD( in42, in170 );               \
    in170 = gf_zero();                          \
    in171 = GF_MUL( in171, 110 );               \
    in170 = GF_ADD( in170, in171 );             \
    in169 = GF_ADD( in169, in171 );             \
    in163 = GF_ADD( in163, in171 );             \
    in139 = GF_ADD( in139, in171 );             \
    in43 = GF_ADD( in43, in171 );               \
    in171 = gf_zero();                          \
    in172 = GF_MUL( in172, 155 );               \
    in168 = GF_ADD( in168, in172 );             \
    in164 = GF_ADD( in164, in172 );             \
    in140 = GF_ADD( in140, in172 );             \
    in44 = GF_ADD( in44, in172 );               \
    in172 = gf_zero();                          \
    in173 = GF_MUL( in173, 155 );               \
    in172 = GF_ADD( in172, in173 );             \
    in169 = GF_ADD( in169, in173 );             \
    in165 = GF_ADD( in165, in173 );             \
    in141 = GF_ADD( in141, in173 );             \
    in45 = GF_ADD( in45, in173 );               \
    in173 = gf_zero();                          \
    in174 = GF_MUL( in174, 65 );                \
    in172 = GF_ADD( in172, in174 );             \
    in170 = GF_ADD( in170, in174 );             \
    in166 = GF_ADD( in166, in174 );             \
    in142 = GF_ADD( in142, in174 );             \
    in46 = GF_ADD( in46, in174 );               \
    in174 = gf_zero();                          \
    in175 = GF_MUL( in175, 65 );                \
    in174 = GF_ADD( in174, in175 );             \
    in173 = GF_ADD( in173, in175 );             \
    in171 = GF_ADD( in171, in175 );             \
    in167 = GF_ADD( in167, in175 );             \
    in143 = GF_ADD( in143, in175 );             \
    in47 = GF_ADD( in47, in175 );               \
    in175 = gf_zero();                          \
    in176 = GF_MUL( in176, 171 );               \
    in160 = GF_ADD( in160, in176 );             \
    in144 = GF_ADD( in144, in176 );             \
    in48 = GF_ADD( in48, in176 );               \
    in176 = gf_zero();                          \
    in177 = GF_MUL( in177, 171 );               \
    in176 = GF_ADD( in176, in177 );             \
    in161 = GF_ADD( in161, in177 );             \
    in145 = GF_ADD( in145, in177 );             \
    in49 = GF_ADD( in49, in177 );               \
    in177 = gf_zero();                          \
    in178 = GF_MUL( in178, 73 );                \
    in176 = GF_ADD( in176, in178 );             \
    in162 = GF_ADD( in162, in178 );             \
    in146 = GF_ADD( in146, in178 );             \
    in50 = GF_ADD( in50, in178 );               \
    in178 = gf_zero();                          \
    in179 = GF_MUL( in179, 73 );                \
    in178 = GF_ADD( in178, in179 );             \
    in177 = GF_ADD( in177, in179 );             \
    in163 = GF_ADD( in163, in179 );             \
    in147 = GF_ADD( in147, in179 );             \
    in51 = GF_ADD( in51, in179 );               \
    in179 = gf_zero();                          \
    in180 = GF_MUL( in180, 196 );               \
    in176 = GF_ADD( in176, in180 );             \
    in164 = GF_ADD( in164, in180 );             \
    in148 = GF_ADD( in148, in180 );             \
    in52 = GF_ADD( in52, in180 );               \
    in180 = gf_zero();                          \
    in181 = GF_MUL( in181, 196 );               \
    in180 = GF_ADD( in180, in181 );             \
    in177 = GF_ADD( in177, in181 );             \
    in165 = GF_ADD( in165, in181 );             \
    in149 = GF_ADD( in149, in181 );             \
    in53 = GF_ADD( in53, in181 );               \
    in181 = gf_zero();                          \
    in182 = GF_MUL( in182, 213 );               \
    in180 = GF_ADD( in180, in182 );             \
    in178 = GF_ADD( in178, in182 );             \
    in166 = GF_ADD( in166, in182 );             \
    in150 = GF_ADD( in150, in182 );             \
    in54 = GF_ADD( in54, in182 );               \
    in182 = gf_zero();                          \
    in183 = GF_MUL( in183, 213 );               \
    in182 = GF_ADD( in182, in183 );             \
    in181 = GF_ADD( in181, in183 );             \
    in179 = GF_ADD( in179, in183 );             \
    in167 = GF_ADD( in167, in183 );             \
    in151 = GF_ADD( in151, in183 );             \
    in55 = GF_ADD( in55, in183 );               \
    in183 = gf_zero();                          \
    in184 = GF_MUL( in184, 94 );                \
    in176 = GF_ADD( in176, in184 );             \
    in168 = GF_ADD( in168, in184 );             \
    in152 = GF_ADD( in152, in184 );             \
    in56 = GF_ADD( in56, in184 );               \
    in184 = gf_zero();                          \
    in185 = GF_MUL( in185, 94 );                \
    in184 = GF_ADD( in184, in185 );             \
    in177 = GF_ADD( in177, in185 );             \
    in169 = GF_ADD( in169, in185 );             \
    in153 = GF_ADD( in153, in185 );             \
    in57 = GF_ADD( in57, in185 );               \
    in185 = gf_zero();                          \
    in186 = GF_MUL( in186, 238 );               \
    in184 = GF_ADD( in184, in186 );             \
    in178 = GF_ADD( in178, in186 );             \
    in170 = GF_ADD( in170, in186 );             \
    in154 = GF_ADD( in154, in186 );             \
    in58 = GF_ADD( in58, in186 );               \
    in186 = gf_zero();                          \
    in187 = GF_MUL( in187, 238 );               \
    in186 = GF_ADD( in186, in187 );             \
    in185 = GF_ADD( in185, in187 );             \
    in179 = GF_ADD( in179, in187 );             \
    in171 = GF_ADD( in171, in187 );             \
    in155 = GF_ADD( in155, in187 );             \
    in59 = GF_ADD( in59, in187 );               \
    in187 = gf_zero();                          \
    in188 = GF_MUL( in188, 15 );                \
    in184 = GF_ADD( in184, in188 );             \
    in180 = GF_ADD( in180, in188 );             \
    in172 = GF_ADD( in172, in188 );             \
    in156 = GF_ADD( in156, in188 );             \
    in60 = GF_ADD( in60, in188 );               \
    in188 = gf_zero();                          \
    in189 = GF_MUL( in189, 15 );                \
    in188 = GF_ADD( in188, in189 );             \
    in185 = GF_ADD( in185, in189 );             \
    in181 = GF_ADD( in181, in189 );             \
    in173 = GF_ADD( in173, in189 );             \
    in157 = GF_ADD( in157, in189 );             \
    in61 = GF_ADD( in61, in189 );               \
    in189 = gf_zero();                          \
    in190 = GF_MUL( in190, 140 );               \
    in188 = GF_ADD( in188, in190 );             \
    in186 = GF_ADD( in186, in190 );             \
    in182 = GF_ADD( in182, in190 );             \
    in174 = GF_ADD( in174, in190 );             \
    in158 = GF_ADD( in158, in190 );             \
    in62 = GF_ADD( in62, in190 );               \
    in190 = gf_zero();                          \
    in191 = GF_MUL( in191, 140 );               \
    in190 = GF_ADD( in190, in191 );             \
    in189 = GF_ADD( in189, in191 );             \
    in187 = GF_ADD( in187, in191 );             \
    in183 = GF_ADD( in183, in191 );             \
    in175 = GF_ADD( in175, in191 );             \
    in159 = GF_ADD( in159, in191 );             \
    in63 = GF_ADD( in63, in191 );               \
    in191 = gf_zero();                          \
    in192 = GF_MUL( in192, 58 );                \
    in128 = GF_ADD( in128, in192 );             \
    in64 = GF_ADD( in64, in192 );               \
    in192 = gf_zero();                          \
    in193 = GF_MUL( in193, 58 );                \
    in192 = GF_ADD( in192, in193 );             \
    in129 = GF_ADD( in129, in193 );             \
    in65 = GF_ADD( in65, in193 );               \
    in193 = gf_zero();                          \
    in194 = GF_MUL( in194, 11 );                \
    in192 = GF_ADD( in192, in194 );             \
    in130 = GF_ADD( in130, in194 );             \
    in66 = GF_ADD( in66, in194 );               \
    in194 = gf_zero();                          \
    in195 = GF_MUL( in195, 11 );                \
    in194 = GF_ADD( in194, in195 );             \
    in193 = GF_ADD( in193, in195 );             \
    in131 = GF_ADD( in131, in195 );             \
    in67 = GF_ADD( in67, in195 );               \
    in195 = gf_zero();                          \
    in196 = GF_MUL( in196, 19 );                \
    in192 = GF_ADD( in192, in196 );             \
    in132 = GF_ADD( in132, in196 );             \
    in68 = GF_ADD( in68, in196 );               \
    in196 = gf_zero();                          \
    in197 = GF_MUL( in197, 19 );                \
    in196 = GF_ADD( in196, in197 );             \
    in193 = GF_ADD( in193, in197 );             \
    in133 = GF_ADD( in133, in197 );             \
    in69 = GF_ADD( in69, in197 );               \
    in197 = gf_zero();                          \
    in198 = GF_MUL( in198, 125 );               \
    in196 = GF_ADD( in196, in198 );             \
    in194 = GF_ADD( in194, in198 );             \
    in134 = GF_ADD( in134, in198 );             \
    in70 = GF_ADD( in70, in198 );               \
    in198 = gf_zero();                          \
    in199 = GF_MUL( in199, 125 );               \
    in198 = GF_ADD( in198, in199 );             \
    in197 = GF_ADD( in197, in199 );             \
    in195 = GF_ADD( in195, in199 );             \
    in135 = GF_ADD( in135, in199 );             \
    in71 = GF_ADD( in71, in199 );               \
    in199 = gf_zero();                          \
    in200 = GF_MUL( in200, 228 );               \
    in192 = GF_ADD( in192, in200 );             \
    in136 = GF_ADD( in136, in200 );             \
    in72 = GF_ADD( in72, in200 );               \
    in200 = gf_zero();                          \
    in201 = GF_MUL( in201, 228 );               \
    in200 = GF_ADD( in200, in201 );             \
    in193 = GF_ADD( in193, in201 );             \
    in137 = GF_ADD( in137, in201 );             \
    in73 = GF_ADD( in73, in201 );               \
    in201 = gf_zero();                          \
    in202 = GF_MUL( in202, 46 );                \
    in200 = GF_ADD( in200, in202 );             \
    in194 = GF_ADD( in194, in202 );             \
    in138 = GF_ADD( in138, in202 );             \
    in74 = GF_ADD( in74, in202 );               \
    in202 = gf_zero();                          \
    in203 = GF_MUL( in203, 46 );                \
    in202 = GF_ADD( in202, in203 );             \
    in201 = GF_ADD( in201, in203 );             \
    in195 = GF_ADD( in195, in203 );             \
    in139 = GF_ADD( in139, in203 );             \
    in75 = GF_ADD( in75, in203 );               \
    in203 = gf_zero();                          \
    in204 = GF_MUL( in204, 209 );               \
    in200 = GF_ADD( in200, in204 );             \
    in196 = GF_ADD( in196, in204 );             \
    in140 = GF_ADD( in140, in204 );             \
    in76 = GF_ADD( in76, in204 );               \
    in204 = gf_zero();                          \
    in205 = GF_MUL( in205, 209 );               \
    in204 = GF_ADD( in204, in205 );             \
    in201 = GF_ADD( in201, in205 );             \
    in197 = GF_ADD( in197, in205 );             \
    in141 = GF_ADD( in141, in205 );             \
    in77 = GF_ADD( in77, in205 );               \
    in205 = gf_zero();                          \
    in206 = GF_MUL( in206, 169 );               \
    in204 = GF_ADD( in204, in206 );             \
    in202 = GF_ADD( in202, in206 );             \
    in198 = GF_ADD( in198, in206 );             \
    in142 = GF_ADD( in142, in206 );             \
    in78 = GF_ADD( in78, in206 );               \
    in206 = gf_zero();                          \
    in207 = GF_MUL( in207, 169 );               \
    in206 = GF_ADD( in206, in207 );             \
    in205 = GF_ADD( in205, in207 );             \
    in203 = GF_ADD( in203, in207 );             \
    in199 = GF_ADD( in199, in207 );             \
    in143 = GF_ADD( in143, in207 );             \
    in79 = GF_ADD( in79, in207 );               \
    in207 = gf_zero();                          \
    in208 = GF_MUL( in208, 236 );               \
    in192 = GF_ADD( in192, in208 );             \
    in144 = GF_ADD( in144, in208 );             \
    in80 = GF_ADD( in80, in208 );               \
    in208 = gf_zero();                          \
    in209 = GF_MUL( in209, 236 );               \
    in208 = GF_ADD( in208, in209 );             \
    in193 = GF_ADD( in193, in209 );             \
    in145 = GF_ADD( in145, in209 );             \
    in81 = GF_ADD( in81, in209 );               \
    in209 = gf_zero();                          \
    in210 = GF_MUL( in210, 217 );               \
    in208 = GF_ADD( in208, in210 );             \
    in194 = GF_ADD( in194, in210 );             \
    in146 = GF_ADD( in146, in210 );             \
    in82 = GF_ADD( in82, in210 );               \
    in210 = gf_zero();                          \
    in211 = GF_MUL( in211, 217 );               \
    in210 = GF_ADD( in210, in211 );             \
    in209 = GF_ADD( in209, in211 );             \
    in195 = GF_ADD( in195, in211 );             \
    in147 = GF_ADD( in147, in211 );             \
    in83 = GF_ADD( in83, in211 );               \
    in211 = gf_zero();                          \
    in212 = GF_MUL( in212, 204 );               \
    in208 = GF_ADD( in208, in212 );             \
    in196 = GF_ADD( in196, in212 );             \
    in148 = GF_ADD( in148, in212 );             \
    in84 = GF_ADD( in84, in212 );               \
    in212 = gf_zero();                          \
    in213 = GF_MUL( in213, 204 );               \
    in212 = GF_ADD( in212, in213 );             \
    in209 = GF_ADD( in209, in213 );             \
    in197 = GF_ADD( in197, in213 );             \
    in149 = GF_ADD( in149, in213 );             \
    in85 = GF_ADD( in85, in213 );               \
    in213 = gf_zero();                          \
    in214 = GF_MUL( in214, 34 );                \
    in212 = GF_ADD( in212, in214 );             \
    in210 = GF_ADD( in210, in214 );             \
    in198 = GF_ADD( in198, in214 );             \
    in150 = GF_ADD( in150, in214 );             \
    in86 = GF_ADD( in86, in214 );               \
    in214 = gf_zero();                          \
    in215 = GF_MUL( in215, 34 );                \
    in214 = GF_ADD( in214, in215 );             \
    in213 = GF_ADD( in213, in215 );             \
    in211 = GF_ADD( in211, in215 );             \
    in199 = GF_ADD( in199, in215 );             \
    in151 = GF_ADD( in151, in215 );             \
    in87 = GF_ADD( in87, in215 );               \
    in215 = gf_zero();                          \
    in216 = GF_MUL( in216, 19 );                \
    in208 = GF_ADD( in208, in216 );             \
    in200 = GF_ADD( in200, in216 );             \
    in152 = GF_ADD( in152, in216 );             \
    in88 = GF_ADD( in88, in216 );               \
    in216 = gf_zero();                          \
    in217 = GF_MUL( in217, 19 );                \
    in216 = GF_ADD( in216, in217 );             \
    in209 = GF_ADD( in209, in217 );             \
    in201 = GF_ADD( in201, in217 );             \
    in153 = GF_ADD( in153, in217 );             \
    in89 = GF_ADD( in89, in217 );               \
    in217 = gf_zero();                          \
    in218 = GF_MUL( in218, 125 );               \
    in216 = GF_ADD( in216, in218 );             \
    in210 = GF_ADD( in210, in218 );             \
    in202 = GF_ADD( in202, in218 );             \
    in154 = GF_ADD( in154, in218 );             \
    in90 = GF_ADD( in90, in218 );               \
    in218 = gf_zero();                          \
    in219 = GF_MUL( in219, 125 );               \
    in218 = GF_ADD( in218, in219 );             \
    in217 = GF_ADD( in217, in219 );             \
    in211 = GF_ADD( in211, in219 );             \
    in203 = GF_ADD( in203, in219 );             \
    in155 = GF_ADD( in155, in219 );             \
    in91 = GF_ADD( in91, in219 );               \
    in219 = gf_zero();                          \
    in220 = GF_MUL( in220, 90 );                \
    in216 = GF_ADD( in216, in220 );             \
    in212 = GF_ADD( in212, in220 );             \
    in204 = GF_ADD( in204, in220 );             \
    in156 = GF_ADD( in156, in220 );             \
    in92 = GF_ADD( in92, in220 );               \
    in220 = gf_zero();                          \
    in221 = GF_MUL( in221, 90 );                \
    in220 = GF_ADD( in220, in221 );             \
    in217 = GF_ADD( in217, in221 );             \
    in213 = GF_ADD( in213, in221 );             \
    in205 = GF_ADD( in205, in221 );             \
    in157 = GF_ADD( in157, in221 );             \
    in93 = GF_ADD( in93, in221 );               \
    in221 = gf_zero();                          \
    in222 = GF_MUL( in222, 27 );                \
    in220 = GF_ADD( in220, in222 );             \
    in218 = GF_ADD( in218, in222 );             \
    in214 = GF_ADD( in214, in222 );             \
    in206 = GF_ADD( in206, in222 );             \
    in158 = GF_ADD( in158, in222 );             \
    in94 = GF_ADD( in94, in222 );               \
    in222 = gf_zero();                          \
    in223 = GF_MUL( in223, 27 );                \
    in222 = GF_ADD( in222, in223 );             \
    in221 = GF_ADD( in221, in223 );             \
    in219 = GF_ADD( in219, in223 );             \
    in215 = GF_ADD( in215, in223 );             \
    in207 = GF_ADD( in207, in223 );             \
    in159 = GF_ADD( in159, in223 );             \
    in95 = GF_ADD( in95, in223 );               \
    in223 = gf_zero();                          \
    in224 = GF_MUL( in224, 30 );                \
    in192 = GF_ADD( in192, in224 );             \
    in160 = GF_ADD( in160, in224 );             \
    in96 = GF_ADD( in96, in224 );               \
    in224 = gf_zero();                          \
    in225 = GF_MUL( in225, 30 );                \
    in224 = GF_ADD( in224, in225 );             \
    in193 = GF_ADD( in193, in225 );             \
    in161 = GF_ADD( in161, in225 );             \
    in97 = GF_ADD( in97, in225 );               \
    in225 = gf_zero();                          \
    in226 = GF_MUL( in226, 5 );                 \
    in224 = GF_ADD( in224, in226 );             \
    in194 = GF_ADD( in194, in226 );             \
    in162 = GF_ADD( in162, in226 );             \
    in98 = GF_ADD( in98, in226 );               \
    in226 = gf_zero();                          \
    in227 = GF_MUL( in227, 5 );                 \
    in226 = GF_ADD( in226, in227 );             \
    in225 = GF_ADD( in225, in227 );             \
    in195 = GF_ADD( in195, in227 );             \
    in163 = GF_ADD( in163, in227 );             \
    in99 = GF_ADD( in99, in227 );               \
    in227 = gf_zero();                          \
    in228 = GF_MUL( in228, 231 );               \
    in224 = GF_ADD( in224, in228 );             \
    in196 = GF_ADD( in196, in228 );             \
    in164 = GF_ADD( in164, in228 );             \
    in100 = GF_ADD( in100, in228 );             \
    in228 = gf_zero();                          \
    in229 = GF_MUL( in229, 231 );               \
    in228 = GF_ADD( in228, in229 );             \
    in225 = GF_ADD( in225, in229 );             \
    in197 = GF_ADD( in197, in229 );             \
    in165 = GF_ADD( in165, in229 );             \
    in101 = GF_ADD( in101, in229 );             \
    in229 = gf_zero();                          \
    in230 = GF_MUL( in230, 160 );               \
    in228 = GF_ADD( in228, in230 );             \
    in226 = GF_ADD( in226, in230 );             \
    in198 = GF_ADD( in198, in230 );             \
    in166 = GF_ADD( in166, in230 );             \
    in102 = GF_ADD( in102, in230 );             \
    in230 = gf_zero();                          \
    in231 = GF_MUL( in231, 160 );               \
    in230 = GF_ADD( in230, in231 );             \
    in229 = GF_ADD( in229, in231 );             \
    in227 = GF_ADD( in227, in231 );             \
    in199 = GF_ADD( in199, in231 );             \
    in167 = GF_ADD( in167, in231 );             \
    in103 = GF_ADD( in103, in231 );             \
    in231 = gf_zero();                          \
    in232 = GF_MUL( in232, 9 );                 \
    in224 = GF_ADD( in224, in232 );             \
    in200 = GF_ADD( in200, in232 );             \
    in168 = GF_ADD( in168, in232 );             \
    in104 = GF_ADD( in104, in232 );             \
    in232 = gf_zero();                          \
    in233 = GF_MUL( in233, 9 );                 \
    in232 = GF_ADD( in232, in233 );             \
    in225 = GF_ADD( in225, in233 );             \
    in201 = GF_ADD( in201, in233 );             \
    in169 = GF_ADD( in169, in233 );             \
    in105 = GF_ADD( in105, in233 );             \
    in233 = gf_zero();                          \
    in234 = GF_MUL( in234, 141 );               \
    in232 = GF_ADD( in232, in234 );             \
    in226 = GF_ADD( in226, in234 );             \
    in202 = GF_ADD( in202, in234 );             \
    in170 = GF_ADD( in170, in234 );             \
    in106 = GF_ADD( in106, in234 );             \
    in234 = gf_zero();                          \
    in235 = GF_MUL( in235, 141 );               \
    in234 = GF_ADD( in234, in235 );             \
    in233 = GF_ADD( in233, in235 );             \
    in227 = GF_ADD( in227, in235 );             \
    in203 = GF_ADD( in203, in235 );             \
    in171 = GF_ADD( in171, in235 );             \
    in107 = GF_ADD( in107, in235 );             \
    in235 = gf_zero();                          \
    in236 = GF_MUL( in236, 61 );                \
    in232 = GF_ADD( in232, in236 );             \
    in228 = GF_ADD( in228, in236 );             \
    in204 = GF_ADD( in204, in236 );             \
    in172 = GF_ADD( in172, in236 );             \
    in108 = GF_ADD( in108, in236 );             \
    in236 = gf_zero();                          \
    in237 = GF_MUL( in237, 61 );                \
    in236 = GF_ADD( in236, in237 );             \
    in233 = GF_ADD( in233, in237 );             \
    in229 = GF_ADD( in229, in237 );             \
    in205 = GF_ADD( in205, in237 );             \
    in173 = GF_ADD( in173, in237 );             \
    in109 = GF_ADD( in109, in237 );             \
    in237 = gf_zero();                          \
    in238 = GF_MUL( in238, 112 );               \
    in236 = GF_ADD( in236, in238 );             \
    in234 = GF_ADD( in234, in238 );             \
    in230 = GF_ADD( in230, in238 );             \
    in206 = GF_ADD( in206, in238 );             \
    in174 = GF_ADD( in174, in238 );             \
    in110 = GF_ADD( in110, in238 );             \
    in238 = gf_zero();                          \
    in239 = GF_MUL( in239, 112 );               \
    in238 = GF_ADD( in238, in239 );             \
    in237 = GF_ADD( in237, in239 );             \
    in235 = GF_ADD( in235, in239 );             \
    in231 = GF_ADD( in231, in239 );             \
    in207 = GF_ADD( in207, in239 );             \
    in175 = GF_ADD( in175, in239 );             \
    in111 = GF_ADD( in111, in239 );             \
    in239 = gf_zero();                          \
    in240 = GF_MUL( in240, 87 );                \
    in224 = GF_ADD( in224, in240 );             \
    in208 = GF_ADD( in208, in240 );             \
    in176 = GF_ADD( in176, in240 );             \
    in112 = GF_ADD( in112, in240 );             \
    in240 = gf_zero();                          \
    in241 = GF_MUL( in241, 87 );                \
    in240 = GF_ADD( in240, in241 );             \
    in225 = GF_ADD( in225, in241 );             \
    in209 = GF_ADD( in209, in241 );             \
    in177 = GF_ADD( in177, in241 );             \
    in113 = GF_ADD( in113, in241 );             \
    in241 = gf_zero();                          \
    in242 = GF_MUL( in242, 99 );                \
    in240 = GF_ADD( in240, in242 );             \
    in226 = GF_ADD( in226, in242 );             \
    in210 = GF_ADD( in210, in242 );             \
    in178 = GF_ADD( in178, in242 );             \
    in114 = GF_ADD( in114, in242 );             \
    in242 = gf_zero();                          \
    in243 = GF_MUL( in243, 99 );                \
    in242 = GF_ADD( in242, in243 );             \
    in241 = GF_ADD( in241, in243 );             \
    in227 = GF_ADD( in227, in243 );             \
    in211 = GF_ADD( in211, in243 );             \
    in179 = GF_ADD( in179, in243 );             \
    in115 = GF_ADD( in115, in243 );             \
    in243 = gf_zero();                          \
    in244 = GF_MUL( in244, 50 );                \
    in240 = GF_ADD( in240, in244 );             \
    in228 = GF_ADD( in228, in244 );             \
    in212 = GF_ADD( in212, in244 );             \
    in180 = GF_ADD( in180, in244 );             \
    in116 = GF_ADD( in116, in244 );             \
    in244 = gf_zero();                          \
    in245 = GF_MUL( in245, 50 );                \
    in244 = GF_ADD( in244, in245 );             \
    in241 = GF_ADD( in241, in245 );             \
    in229 = GF_ADD( in229, in245 );             \
    in213 = GF_ADD( in213, in245 );             \
    in181 = GF_ADD( in181, in245 );             \
    in117 = GF_ADD( in117, in245 );             \
    in245 = gf_zero();                          \
    in246 = GF_MUL( in246, 252 );               \
    in244 = GF_ADD( in244, in246 );             \
    in242 = GF_ADD( in242, in246 );             \
    in230 = GF_ADD( in230, in246 );             \
    in214 = GF_ADD( in214, in246 );             \
    in182 = GF_ADD( in182, in246 );             \
    in118 = GF_ADD( in118, in246 );             \
    in246 = gf_zero();                          \
    in247 = GF_MUL( in247, 252 );               \
    in246 = GF_ADD( in246, in247 );             \
    in245 = GF_ADD( in245, in247 );             \
    in243 = GF_ADD( in243, in247 );             \
    in231 = GF_ADD( in231, in247 );             \
    in215 = GF_ADD( in215, in247 );             \
    in183 = GF_ADD( in183, in247 );             \
    in119 = GF_ADD( in119, in247 );             \
    in247 = gf_zero();                          \
    in248 = GF_MUL( in248, 231 );               \
    in240 = GF_ADD( in240, in248 );             \
    in232 = GF_ADD( in232, in248 );             \
    in216 = GF_ADD( in216, in248 );             \
    in184 = GF_ADD( in184, in248 );             \
    in120 = GF_ADD( in120, in248 );             \
    in248 = gf_zero();                          \
    in249 = GF_MUL( in249, 231 );               \
    in248 = GF_ADD( in248, in249 );             \
    in241 = GF_ADD( in241, in249 );             \
    in233 = GF_ADD( in233, in249 );             \
    in217 = GF_ADD( in217, in249 );             \
    in185 = GF_ADD( in185, in249 );             \
    in121 = GF_ADD( in121, in249 );             \
    in249 = gf_zero();                          \
    in250 = GF_MUL( in250, 160 );               \
    in248 = GF_ADD( in248, in250 );             \
    in242 = GF_ADD( in242, in250 );             \
    in234 = GF_ADD( in234, in250 );             \
    in218 = GF_ADD( in218, in250 );             \
    in186 = GF_ADD( in186, in250 );             \
    in122 = GF_ADD( in122, in250 );             \
    in250 = gf_zero();                          \
    in251 = GF_MUL( in251, 160 );               \
    in250 = GF_ADD( in250, in251 );             \
    in249 = GF_ADD( in249, in251 );             \
    in243 = GF_ADD( in243, in251 );             \
    in235 = GF_ADD( in235, in251 );             \
    in219 = GF_ADD( in219, in251 );             \
    in187 = GF_ADD( in187, in251 );             \
    in123 = GF_ADD( in123, in251 );             \
    in251 = gf_zero();                          \
    in252 = GF_MUL( in252, 177 );               \
    in248 = GF_ADD( in248, in252 );             \
    in244 = GF_ADD( in244, in252 );             \
    in236 = GF_ADD( in236, in252 );             \
    in220 = GF_ADD( in220, in252 );             \
    in188 = GF_ADD( in188, in252 );             \
    in124 = GF_ADD( in124, in252 );             \
    in252 = gf_zero();                          \
    in253 = GF_MUL( in253, 177 );               \
    in252 = GF_ADD( in252, in253 );             \
    in249 = GF_ADD( in249, in253 );             \
    in245 = GF_ADD( in245, in253 );             \
    in237 = GF_ADD( in237, in253 );             \
    in221 = GF_ADD( in221, in253 );             \
    in189 = GF_ADD( in189, in253 );             \
    in125 = GF_ADD( in125, in253 );             \
    in253 = gf_zero();                          \
    in254 = GF_MUL( in254, 185 );               \
    in252 = GF_ADD( in252, in254 );             \
    in250 = GF_ADD( in250, in254 );             \
    in246 = GF_ADD( in246, in254 );             \
    in238 = GF_ADD( in238, in254 );             \
    in222 = GF_ADD( in222, in254 );             \
    in190 = GF_ADD( in190, in254 );             \
    in126 = GF_ADD( in126, in254 );             \
    in254 = gf_zero();                          \
    in255 = GF_MUL( in255, 185 );               \
    in254 = GF_ADD( in254, in255 );             \
    in253 = GF_ADD( in253, in255 );             \
    in251 = GF_ADD( in251, in255 );             \
    in247 = GF_ADD( in247, in255 );             \
    in239 = GF_ADD( in239, in255 );             \
    in223 = GF_ADD( in223, in255 );             \
    in191 = GF_ADD( in191, in255 );             \
    in127 = GF_ADD( in127, in255 );             \
    in255 = gf_zero();                          \
    in00 = GF_MUL( in00, 1 );                   \
    in01 = GF_MUL( in01, 1 );                   \
    in02 = GF_MUL( in02, 6 );                   \
    in03 = GF_MUL( in03, 6 );                   \
    in04 = GF_MUL( in04, 108 );                 \
    in05 = GF_MUL( in05, 108 );                 \
    in06 = GF_MUL( in06, 117 );                 \
    in07 = GF_MUL( in07, 117 );                 \
    in08 = GF_MUL( in08, 208 );                 \
    in09 = GF_MUL( in09, 208 );                 \
    in10 = GF_MUL( in10, 218 );                 \
    in11 = GF_MUL( in11, 218 );                 \
    in12 = GF_MUL( in12, 136 );                 \
    in13 = GF_MUL( in13, 136 );                 \
    in14 = GF_MUL( in14, 23 );                  \
    in15 = GF_MUL( in15, 23 );                  \
    in16 = GF_MUL( in16, 42 );                  \
    in17 = GF_MUL( in17, 42 );                  \
    in18 = GF_MUL( in18, 252 );                 \
    in19 = GF_MUL( in19, 252 );                 \
    in20 = GF_MUL( in20, 158 );                 \
    in21 = GF_MUL( in21, 158 );                 \
    in22 = GF_MUL( in22, 99 );                  \
    in23 = GF_MUL( in23, 99 );                  \
    in24 = GF_MUL( in24, 108 );                 \
    in25 = GF_MUL( in25, 108 );                 \
    in26 = GF_MUL( in26, 117 );                 \
    in27 = GF_MUL( in27, 117 );                 \
    in28 = GF_MUL( in28, 233 );                 \
    in29 = GF_MUL( in29, 233 );                 \
    in30 = GF_MUL( in30, 76 );                  \
    in31 = GF_MUL( in31, 76 );                  \
    in32 = GF_MUL( in32, 165 );                 \
    in33 = GF_MUL( in33, 165 );                 \
    in34 = GF_MUL( in34, 249 );                 \
    in35 = GF_MUL( in35, 249 );                 \
    in36 = GF_MUL( in36, 196 );                 \
    in37 = GF_MUL( in37, 196 );                 \
    in38 = GF_MUL( in38, 162 );                 \
    in39 = GF_MUL( in39, 162 );                 \
    in40 = GF_MUL( in40, 212 );                 \
    in41 = GF_MUL( in41, 212 );                 \
    in42 = GF_MUL( in42, 194 );                 \
    in43 = GF_MUL( in43, 194 );                 \
    in44 = GF_MUL( in44, 37 );                  \
    in45 = GF_MUL( in45, 37 );                  \
    in46 = GF_MUL( in46, 222 );                 \
    in47 = GF_MUL( in47, 222 );                 \
    in48 = GF_MUL( in48, 15 );                  \
    in49 = GF_MUL( in49, 15 );                  \
    in50 = GF_MUL( in50, 34 );                  \
    in51 = GF_MUL( in51, 34 );                  \
    in52 = GF_MUL( in52, 94 );                  \
    in53 = GF_MUL( in53, 94 );                  \
    in54 = GF_MUL( in54, 217 );                 \
    in55 = GF_MUL( in55, 217 );                 \
    in56 = GF_MUL( in56, 196 );                 \
    in57 = GF_MUL( in57, 196 );                 \
    in58 = GF_MUL( in58, 162 );                 \
    in59 = GF_MUL( in59, 162 );                 \
    in60 = GF_MUL( in60, 171 );                 \
    in61 = GF_MUL( in61, 171 );                 \
    in62 = GF_MUL( in62, 221 );                 \
    in63 = GF_MUL( in63, 221 );                 \
    in64 = GF_MUL( in64, 250 );                 \
    in65 = GF_MUL( in65, 250 );                 \
    in66 = GF_MUL( in66, 38 );                  \
    in67 = GF_MUL( in67, 38 );                  \
    in68 = GF_MUL( in68, 22 );                  \
    in69 = GF_MUL( in69, 22 );                  \
    in70 = GF_MUL( in70, 116 );                 \
    in71 = GF_MUL( in71, 116 );                 \
    in72 = GF_MUL( in72, 175 );                 \
    in73 = GF_MUL( in73, 175 );                 \
    in74 = GF_MUL( in74, 197 );                 \
    in75 = GF_MUL( in75, 197 );                 \
    in76 = GF_MUL( in76, 91 );                  \
    in77 = GF_MUL( in77, 91 );                  \
    in78 = GF_MUL( in78, 199 );                 \
    in79 = GF_MUL( in79, 199 );                 \
    in80 = GF_MUL( in80, 92 );                  \
    in81 = GF_MUL( in81, 92 );                  \
    in82 = GF_MUL( in82, 213 );                 \
    in83 = GF_MUL( in83, 213 );                 \
    in84 = GF_MUL( in84, 102 );                 \
    in85 = GF_MUL( in85, 102 );                 \
    in86 = GF_MUL( in86, 73 );                  \
    in87 = GF_MUL( in87, 73 );                  \
    in88 = GF_MUL( in88, 22 );                  \
    in89 = GF_MUL( in89, 22 );                  \
    in90 = GF_MUL( in90, 116 );                 \
    in91 = GF_MUL( in91, 116 );                 \
    in92 = GF_MUL( in92, 251 );                 \
    in93 = GF_MUL( in93, 251 );                 \
    in94 = GF_MUL( in94, 32 );                  \
    in95 = GF_MUL( in95, 32 );                  \
    in96 = GF_MUL( in96, 219 );                 \
    in97 = GF_MUL( in97, 219 );                 \
    in98 = GF_MUL( in98, 224 );                 \
    in99 = GF_MUL( in99, 224 );                 \
    in100 = GF_MUL( in100, 123 );               \
    in101 = GF_MUL( in101, 123 );               \
    in102 = GF_MUL( in102, 7 );                 \
    in103 = GF_MUL( in103, 7 );                 \
    in104 = GF_MUL( in104, 96 );                \
    in105 = GF_MUL( in105, 96 );                \
    in106 = GF_MUL( in106, 93 );                \
    in107 = GF_MUL( in107, 93 );                \
    in108 = GF_MUL( in108, 3 );                 \
    in109 = GF_MUL( in109, 3 );                 \
    in110 = GF_MUL( in110, 10 );                \
    in111 = GF_MUL( in111, 10 );                \
    in112 = GF_MUL( in112, 95 );                \
    in113 = GF_MUL( in113, 95 );                \
    in114 = GF_MUL( in114, 223 );               \
    in115 = GF_MUL( in115, 223 );               \
    in116 = GF_MUL( in116, 210 );               \
    in117 = GF_MUL( in117, 210 );               \
    in118 = GF_MUL( in118, 214 );               \
    in119 = GF_MUL( in119, 214 );               \
    in120 = GF_MUL( in120, 123 );               \
    in121 = GF_MUL( in121, 123 );               \
    in122 = GF_MUL( in122, 7 );                 \
    in123 = GF_MUL( in123, 7 );                 \
    in124 = GF_MUL( in124, 126 );               \
    in125 = GF_MUL( in125, 126 );               \
    in126 = GF_MUL( in126, 25 );                \
    in127 = GF_MUL( in127, 25 );                \
    in128 = GF_MUL( in128, 4 );                 \
    in129 = GF_MUL( in129, 4 );                 \
    in130 = GF_MUL( in130, 24 );                \
    in131 = GF_MUL( in131, 24 );                \
    in132 = GF_MUL( in132, 173 );               \
    in133 = GF_MUL( in133, 173 );               \
    in134 = GF_MUL( in134, 201 );               \
    in135 = GF_MUL( in135, 201 );               \
    in136 = GF_MUL( in136, 103 );               \
    in137 = GF_MUL( in137, 103 );               \
    in138 = GF_MUL( in138, 79 );                \
    in139 = GF_MUL( in139, 79 );                \
    in140 = GF_MUL( in140, 26 );                \
    in141 = GF_MUL( in141, 26 );                \
    in142 = GF_MUL( in142, 92 );                \
    in143 = GF_MUL( in143, 92 );                \
    in144 = GF_MUL( in144, 168 );               \
    in145 = GF_MUL( in145, 168 );               \
    in146 = GF_MUL( in146, 215 );               \
    in147 = GF_MUL( in147, 215 );               \
    in148 = GF_MUL( in148, 66 );                \
    in149 = GF_MUL( in149, 66 );                \
    in150 = GF_MUL( in150, 145 );               \
    in151 = GF_MUL( in151, 145 );               \
    in152 = GF_MUL( in152, 173 );               \
    in153 = GF_MUL( in153, 173 );               \
    in154 = GF_MUL( in154, 201 );               \
    in155 = GF_MUL( in155, 201 );               \
    in156 = GF_MUL( in156, 131 );               \
    in157 = GF_MUL( in157, 131 );               \
    in158 = GF_MUL( in158, 45 );                \
    in159 = GF_MUL( in159, 45 );                \
    in160 = GF_MUL( in160, 174 );               \
    in161 = GF_MUL( in161, 174 );               \
    in162 = GF_MUL( in162, 195 );               \
    in163 = GF_MUL( in163, 195 );               \
    in164 = GF_MUL( in164, 55 );                \
    in165 = GF_MUL( in165, 55 );                \
    in166 = GF_MUL( in166, 178 );               \
    in167 = GF_MUL( in167, 178 );               \
    in168 = GF_MUL( in168, 119 );               \
    in169 = GF_MUL( in169, 119 );               \
    in170 = GF_MUL( in170, 47 );                \
    in171 = GF_MUL( in171, 47 );                \
    in172 = GF_MUL( in172, 148 );               \
    in173 = GF_MUL( in173, 148 );               \
    in174 = GF_MUL( in174, 95 );                \
    in175 = GF_MUL( in175, 95 );                \
    in176 = GF_MUL( in176, 60 );                \
    in177 = GF_MUL( in177, 60 );                \
    in178 = GF_MUL( in178, 136 );               \
    in179 = GF_MUL( in179, 136 );               \
    in180 = GF_MUL( in180, 101 );               \
    in181 = GF_MUL( in181, 101 );               \
    in182 = GF_MUL( in182, 67 );                \
    in183 = GF_MUL( in183, 67 );                \
    in184 = GF_MUL( in184, 55 );                \
    in185 = GF_MUL( in185, 55 );                \
    in186 = GF_MUL( in186, 178 );               \
    in187 = GF_MUL( in187, 178 );               \
    in188 = GF_MUL( in188, 150 );               \
    in189 = GF_MUL( in189, 150 );               \
    in190 = GF_MUL( in190, 83 );                \
    in191 = GF_MUL( in191, 83 );                \
    in192 = GF_MUL( in192, 207 );               \
    in193 = GF_MUL( in193, 207 );               \
    in194 = GF_MUL( in194, 152 );               \
    in195 = GF_MUL( in195, 152 );               \
    in196 = GF_MUL( in196, 88 );                \
    in197 = GF_MUL( in197, 88 );                \
    in198 = GF_MUL( in198, 205 );               \
    in199 = GF_MUL( in199, 205 );               \
    in200 = GF_MUL( in200, 134 );               \
    in201 = GF_MUL( in201, 134 );               \
    in202 = GF_MUL( in202, 51 );                \
    in203 = GF_MUL( in203, 51 );                \
    in204 = GF_MUL( in204, 113 );               \
    in205 = GF_MUL( in205, 113 );               \
    in206 = GF_MUL( in206, 59 );                \
    in207 = GF_MUL( in207, 59 );                \
    in208 = GF_MUL( in208, 109 );               \
    in209 = GF_MUL( in209, 109 );               \
    in210 = GF_MUL( in210, 115 );               \
    in211 = GF_MUL( in211, 115 );               \
    in212 = GF_MUL( in212, 133 );               \
    in213 = GF_MUL( in213, 133 );               \
    in214 = GF_MUL( in214, 57 );                \
    in215 = GF_MUL( in215, 57 );                \
    in216 = GF_MUL( in216, 88 );                \
    in217 = GF_MUL( in217, 88 );                \
    in218 = GF_MUL( in218, 205 );               \
    in219 = GF_MUL( in219, 205 );               \
    in220 = GF_MUL( in220, 203 );               \
    in221 = GF_MUL( in221, 203 );               \
    in222 = GF_MUL( in222, 128 );               \
    in223 = GF_MUL( in223, 128 );               \
    in224 = GF_MUL( in224, 75 );                \
    in225 = GF_MUL( in225, 75 );                \
    in226 = GF_MUL( in226, 167 );               \
    in227 = GF_MUL( in227, 167 );               \
    in228 = GF_MUL( in228, 241 );               \
    in229 = GF_MUL( in229, 241 );               \
    in230 = GF_MUL( in230, 28 );                \
    in231 = GF_MUL( in231, 28 );                \
    in232 = GF_MUL( in232, 157 );               \
    in233 = GF_MUL( in233, 157 );               \
    in234 = GF_MUL( in234, 105 );               \
    in235 = GF_MUL( in235, 105 );               \
    in236 = GF_MUL( in236, 12 );                \
    in237 = GF_MUL( in237, 12 );                \
    in238 = GF_MUL( in238, 40 );                \
    in239 = GF_MUL( in239, 40 );                \
    in240 = GF_MUL( in240, 97 );                \
    in241 = GF_MUL( in241, 97 );                \
    in242 = GF_MUL( in242, 91 );                \
    in243 = GF_MUL( in243, 91 );                \
    in244 = GF_MUL( in244, 111 );               \
    in245 = GF_MUL( in245, 111 );               \
    in246 = GF_MUL( in246, 127 );               \
    in247 = GF_MUL( in247, 127 );               \
    in248 = GF_MUL( in248, 241 );               \
    in249 = GF_MUL( in249, 241 );               \
    in250 = GF_MUL( in250, 28 );                \
    in251 = GF_MUL( in251, 28 );                \
    in252 = GF_MUL( in252, 229 );               \
    in253 = GF_MUL( in253, 229 );               \
    in254 = GF_MUL( in254, 100 );               \
    in255 = GF_MUL( in255, 100 );               \
  } while( 0 )

#endif /* HEADER_fd_src_ballet_reedsol_fd_reedsol_fderiv_h */
