/* Code generated by gen_wycheproofs.py. DO NOT EDIT. */
/* Generated at 2024-03-07T22:55:49.790538+00:00 */

#include "../fd_ballet_base.h"

#if FD_USING_GCC && __GNUC__ >= 15
#pragma GCC diagnostic ignored "-Wunterminated-string-initialization"
#endif

struct fd_x25519_verify_wycheproof {
  char const *  comment;
  uchar         shared[32];
  uchar         prv[32];
  uchar         pub[32];
  uint          tc_id;
  int           ok;
};

typedef struct fd_x25519_verify_wycheproof fd_x25519_verify_wycheproof_t;

static fd_x25519_verify_wycheproof_t const x25519_verify_wycheproofs[] = {
  { .tc_id   = 1,
    .comment = "normal case",
    .shared  = "\x43\x6a\x2c\x04\x0c\xf4\x5f\xea\x9b\x29\xa0\xcb\x81\xb1\xf4\x14\x58\xf8\x63\xd0\xd6\x1b\x45\x3d\x0a\x98\x27\x20\xd6\xd6\x13\x20",
    .prv     = "\xc8\xa9\xd5\xa9\x10\x91\xad\x85\x1c\x66\x8b\x07\x36\xc1\xc9\xa0\x29\x36\xc0\xd3\xad\x62\x67\x08\x58\x08\x80\x47\xba\x05\x74\x75",
    .pub     = "\x50\x4a\x36\x99\x9f\x48\x9c\xd2\xfd\xbc\x08\xba\xff\x3d\x88\xfa\x00\x56\x9b\xa9\x86\xcb\xa2\x25\x48\xff\xde\x80\xf9\x80\x68\x29",
    .ok      = 1 },
  { .tc_id   = 2,
    .comment = "public key on twist",
    .shared  = "\x27\x9d\xf6\x7a\x7c\x46\x11\xdb\x47\x08\xa0\xe8\x28\x2b\x19\x5e\x5a\xc0\xed\x6f\x4b\x2f\x29\x2c\x6f\xbd\x0a\xca\xc3\x0d\x13\x32",
    .prv     = "\xd8\x5d\x8c\x06\x1a\x50\x80\x4a\xc4\x88\xad\x77\x4a\xc7\x16\xc3\xf5\xba\x71\x4b\x27\x12\xe0\x48\x49\x13\x79\xa5\x00\x21\x19\x58",
    .pub     = "\x63\xaa\x40\xc6\xe3\x83\x46\xc5\xca\xf2\x3a\x6d\xf0\xa5\xe6\xc8\x08\x89\xa0\x86\x47\xe5\x51\xb3\x56\x34\x49\xbe\xfc\xfc\x97\x33",
    .ok      = 1 },
  { .tc_id   = 3,
    .comment = "public key on twist",
    .shared  = "\x4b\xc7\xe0\x1e\x7d\x83\xd6\xcf\x67\x63\x2b\xf9\x00\x33\x48\x7a\x5f\xc2\x9e\xba\x53\x28\x89\x0e\xa7\xb1\x02\x6d\x23\xb9\xa4\x5f",
    .prv     = "\xc8\xb4\x5b\xfd\x32\xe5\x53\x25\xd9\xfd\x64\x8c\xb3\x02\x84\x80\x39\x00\x0b\x39\x0e\x44\xd5\x21\xe5\x8a\xab\x3b\x29\xa6\x96\x4b",
    .pub     = "\x0f\x83\xc3\x6f\xde\xd9\xd3\x2f\xad\xf4\xef\xa3\xae\x93\xa9\x0b\xb5\xcf\xa6\x68\x93\xbc\x41\x2c\x43\xfa\x72\x87\xdb\xb9\x97\x79",
    .ok      = 1 },
  { .tc_id   = 4,
    .comment = "public key on twist",
    .shared  = "\x11\x9d\x37\xed\x4b\x10\x9c\xbd\x64\x18\xb1\xf2\x8d\xea\x83\xc8\x36\xc8\x44\x71\x5c\xdf\x98\xa3\xa8\xc3\x62\x19\x1d\xeb\xd5\x14",
    .prv     = "\xf8\x76\xe3\x4b\xcb\xe1\xf4\x7f\xbc\x0f\xdd\xfd\x7c\x1e\x1a\xa5\x3d\x57\xbf\xe0\xf6\x6d\x24\x30\x67\xb4\x24\xbb\x62\x10\xbe\x51",
    .pub     = "\x0b\x82\x11\xa2\xb6\x04\x90\x97\xf6\x87\x1c\x6c\x05\x2d\x3c\x5f\xc1\xba\x17\xda\x9e\x32\xae\x45\x84\x03\xb0\x5b\xb2\x83\x09\x2a",
    .ok      = 1 },
  { .tc_id   = 5,
    .comment = "public key on twist",
    .shared  = "\xcc\x48\x73\xae\xd3\xfc\xee\x4b\x3a\xae\xa7\xf0\xd2\x07\x16\xb4\x27\x63\x59\x08\x1f\x63\x4b\x7b\xea\x4b\x70\x5b\xfc\x8a\x4d\x3e",
    .prv     = "\x00\x6a\xc1\xf3\xa6\x53\xa4\xcd\xb1\xd3\x7b\xba\x94\x73\x8f\x8b\x95\x7a\x57\xbe\xb2\x4d\x64\x6e\x99\x4d\xc2\x9a\x27\x6a\xad\x45",
    .pub     = "\x34\x3a\xc2\x0a\x3b\x9c\x6a\x27\xb1\x00\x81\x76\x50\x9a\xd3\x07\x35\x85\x6e\xc1\xc8\xd8\xfc\xae\x13\x91\x2d\x08\xd1\x52\xf4\x6c",
    .ok      = 1 },
  { .tc_id   = 6,
    .comment = "public key on twist",
    .shared  = "\xb6\xf8\xe2\xfc\xb1\xaf\xfc\x79\xe2\xff\x79\x83\x19\xb2\x70\x11\x39\xb9\x5a\xd6\xdd\x07\xf0\x5c\xba\xc7\x8b\xd8\x3e\xdf\xd9\x2e",
    .prv     = "\x08\xda\x77\xb2\x6d\x06\xdf\xf9\xd9\xf7\xfd\x4c\x5b\x37\x69\xf8\xcd\xd5\xb3\x05\x16\xa5\xab\x80\x6b\xe3\x24\xff\x3e\xb6\x9e\x60",
    .pub     = "\xfa\x69\x5f\xc7\xbe\x8d\x1b\xe5\xbf\x70\x48\x98\xf3\x88\xc4\x52\xba\xfd\xd3\xb8\xea\xe8\x05\xf8\x68\x1a\x8d\x15\xc2\xd4\xe1\x42",
    .ok      = 1 },
  { .tc_id   = 7,
    .comment = "public key on twist",
    .shared  = "\xb8\x7a\x17\x22\xcc\x6c\x1e\x2f\xee\xcb\x54\xe9\x7a\xbd\x5a\x22\xac\xc2\x76\x16\xf7\x8f\x6e\x31\x5f\xd2\xb7\x3d\x9f\x22\x1e\x57",
    .prv     = "\xd0\x3e\xdd\xe9\xf3\xe7\xb7\x99\x04\x5f\x9a\xc3\x79\x3d\x4a\x92\x77\xda\xde\xad\xc4\x1b\xec\x02\x90\xf8\x1f\x74\x4f\x73\x77\x5f",
    .pub     = "\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 8,
    .comment = "public key on twist",
    .shared  = "\xa2\x9d\x8d\xad\x28\xd5\x90\xcd\x30\x17\xaa\x97\xa4\x76\x1f\x85\x1b\xf1\xd3\x67\x2b\x04\x2a\x42\x56\xa4\x58\x81\xe2\xad\x90\x35",
    .prv     = "\xe0\x9d\x57\xa9\x14\xe3\xc2\x90\x36\xfd\x9a\x44\x2b\xa5\x26\xb5\xcd\xcd\xf2\x82\x16\x15\x3e\x63\x6c\x10\x67\x7a\xca\xb6\xbd\x6a",
    .pub     = "\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 9,
    .comment = "public key on twist",
    .shared  = "\xe7\x03\xbc\x8a\xa9\x4b\x7d\x87\xba\x34\xe2\x67\x83\x53\xd1\x2c\xda\xaa\x1a\x97\xb5\xca\x3e\x1b\x8c\x06\x0c\x46\x36\x08\x7f\x07",
    .prv     = "\xe0\xed\x78\xe6\xee\x02\xf0\x8b\xec\x1c\x15\xd6\x6f\xbb\xe5\xb8\x3f\xfc\x37\xea\x14\xe1\x51\x2c\xc1\xbd\x4b\x2e\xa6\xd8\x06\x6f",
    .pub     = "\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 10,
    .comment = "public key on twist",
    .shared  = "\xff\x5c\xf0\x41\xe9\x24\xdb\xe1\xa6\x4a\xc9\xbd\xba\x96\xbd\xcd\xfa\xf7\xd5\x9d\x91\xc7\xe3\x3e\x76\xed\x0e\x4c\x8c\x83\x64\x46",
    .prv     = "\xa8\xa1\xa2\xec\x9f\xa9\x91\x5a\xe7\xaa\xce\x6a\x37\xc6\x85\x91\xd3\x9e\x15\x99\x5c\x4e\xf5\xeb\xd3\x56\x1c\x02\xf7\x2d\xda\x41",
    .pub     = "\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 11,
    .comment = "public key on twist",
    .shared  = "\xa9\x2a\x96\xfa\x02\x99\x60\xf9\x53\x0e\x6f\xe3\x7e\x24\x29\xcd\x11\x3b\xe4\xd8\xf3\xf4\x43\x1f\x85\x46\xe6\xc7\x63\x51\x47\x5d",
    .prv     = "\xa8\xc9\xdf\x58\x20\xeb\x39\x9d\x47\x1d\xfa\x32\x15\xd9\x60\x55\xb3\xc7\xd0\xf4\xea\x49\xf8\xab\x02\x8d\x6a\x6e\x31\x94\x51\x7b",
    .pub     = "\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 12,
    .comment = "public key on twist",
    .shared  = "\x9f\x89\x54\x86\x81\x58\xec\x62\xb6\xb5\x86\xb8\xca\xe1\xd6\x7d\x1b\x9f\x4c\x03\xd5\xb3\xca\x03\x93\xce\xe7\x1a\xcc\xc9\xab\x65",
    .prv     = "\xd0\xd3\x1c\x49\x1c\xbd\x39\x27\x18\x59\xb4\xa6\x3a\x31\x68\x26\x50\x7b\x1d\xb8\xc7\x01\x70\x9f\xd0\xff\xe3\xeb\x21\xc4\x46\x7c",
    .pub     = "\xff\xff\xff\x0f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 13,
    .comment = "public key on twist",
    .shared  = "\x6c\xbf\x1d\xc9\xaf\x97\xbc\x14\x85\x13\xa1\x8b\xe4\xa2\x57\xde\x1a\x3b\x06\x55\x84\xdf\x94\xe8\xb4\x3c\x1a\xb8\x97\x20\xb1\x10",
    .prv     = "\xd0\x53\xe7\xbf\x19\x02\x61\x9c\xd6\x1c\x9c\x73\x9e\x09\xd5\x4c\x41\x47\xf4\x6d\x19\x07\x20\x96\x6f\x7d\xe1\xd9\xcf\xfb\xbd\x4e",
    .pub     = "\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 14,
    .comment = "public key on twist",
    .shared  = "\x38\x28\x4b\x70\x86\x09\x5a\x94\x06\x02\x8c\x1f\x80\x0c\x07\x1e\xa1\x06\x03\x9a\xd7\xa1\xd7\xf8\x2f\xe0\x09\x06\xfd\x90\x59\x4b",
    .prv     = "\xa0\x21\xd7\x50\x09\xa4\x59\x6e\x5a\x33\xf1\x29\x21\xc1\x0f\x36\x70\x93\x3b\xc8\x0d\xde\x3b\xba\x22\x88\x1b\x61\x20\x58\x21\x44",
    .pub     = "\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 15,
    .comment = "public key on twist",
    .shared  = "\xc7\x21\x04\x1d\xf0\x24\x40\x71\x79\x4a\x8d\xb0\x6b\x9f\x7e\xae\xec\x69\x0c\x25\x72\x65\x34\x36\x66\xf4\x41\x6f\x41\x66\x84\x0f",
    .prv     = "\xa8\x9c\x66\x87\xf9\x9b\xd5\x69\xa0\x1f\xd8\xbd\x43\x82\x36\x16\x0d\x15\xce\x2c\x57\xc1\xd7\x1e\xba\xa3\xf2\xda\x88\x23\x38\x63",
    .pub     = "\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 16,
    .comment = "public key on twist",
    .shared  = "\x25\xff\x9a\x66\x31\xb1\x43\xdb\xdb\xdc\x20\x7b\x38\xe3\x8f\x83\x2a\xe0\x79\xa5\x2a\x61\x8c\x53\x43\x22\xe7\x73\x45\xfd\x90\x49",
    .prv     = "\x68\x96\x4b\xca\x51\x46\x5b\xf0\xf5\xba\x52\x4b\x14\x82\xce\xff\x0e\x96\x0a\x1e\xd9\xf4\x8d\xcc\x30\xf1\x60\x8d\x0e\x50\x1a\x50",
    .pub     = "\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 17,
    .comment = "public key on twist",
    .shared  = "\xf2\x94\xe7\x92\x2c\x6c\xea\x58\x7a\xef\xe7\x29\x11\x63\x0d\x50\xf2\x45\x6a\x2b\xa7\xf2\x12\x07\xd5\x7f\x1e\xcc\xe0\x4f\x62\x13",
    .prv     = "\xa8\xe5\x6b\xb1\x3a\x9f\x2b\x33\xb8\xe6\x75\x0b\x4a\x6e\x66\x21\xdc\x26\xae\x8c\x5c\x62\x4a\x09\x92\xc8\xf0\xd5\xb9\x10\xf1\x70",
    .pub     = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 18,
    .comment = "public key on twist",
    .shared  = "\xff\x47\x15\xbd\x8c\xf8\x47\xb7\x7c\x24\x4c\xe2\xd9\xb0\x08\xb1\x9e\xfa\xa8\xe8\x45\xfe\xb8\x5c\xe4\x88\x9b\x5b\x2c\x6a\x4b\x4d",
    .prv     = "\xe0\x45\xf5\x5c\x15\x94\x51\xe9\x78\x14\xd7\x47\x05\x0f\xd7\x76\x9b\xd4\x78\x43\x4a\x01\x87\x6a\x56\xe5\x53\xf6\x63\x84\xa7\x4c",
    .pub     = "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 19,
    .comment = "public key on twist",
    .shared  = "\x61\xea\xce\x52\xda\x5f\x5e\xce\xfa\xfa\x4f\x19\x9b\x07\x7f\xf6\x4f\x2e\x3d\x2a\x6e\xce\x6f\x8e\xc0\x49\x78\x26\xb2\x12\xef\x5f",
    .prv     = "\x10\x5d\x62\x1e\x1e\xf3\x39\xc3\xd9\x92\x45\xcf\xb7\x7c\xd3\xa5\xbd\x0c\x44\x27\xa0\xe4\xd8\x75\x2c\x3b\x51\xf0\x45\x88\x9b\x4f",
    .pub     = "\xff\xff\xff\x03\x00\x00\xf8\xff\xff\x1f\x00\x00\xc0\xff\xff\xff\x00\x00\x00\xfe\xff\xff\x07\x00\x00\xf0\xff\xff\x3f\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 20,
    .comment = "public key on twist",
    .shared  = "\xff\x1b\x50\x9a\x0a\x1a\x54\x72\x60\x86\xf1\xe1\xc0\xac\xf0\x40\xab\x46\x3a\x2a\x54\x2e\x5d\x54\xe9\x2c\x6d\xf8\x12\x6c\xf6\x36",
    .prv     = "\xd8\x8a\x44\x1e\x70\x6f\x60\x6a\xe7\xf6\x30\xf8\xb2\x1f\x3c\x25\x54\x73\x9e\x3e\x54\x9f\x80\x41\x18\xc0\x37\x71\xf6\x08\x01\x7b",
    .pub     = "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f\x00\x00",
    .ok      = 1 },
  { .tc_id   = 21,
    .comment = "public key on twist",
    .shared  = "\xf1\x34\xe6\x26\x7b\xf9\x39\x03\x08\x51\x17\xb9\x99\x32\xcc\x0c\x7b\xa2\x6f\x25\xfc\xa1\x21\x02\xa2\x6d\x75\x33\xd9\xc4\x27\x2a",
    .prv     = "\x80\xbb\xad\x16\x82\x22\x27\x62\x00\xaa\xfd\x36\xf7\xf2\x5f\xdc\x02\x56\x32\xd8\xbf\x9f\x63\x54\xbb\x76\x2e\x06\xfb\x63\xe2\x50",
    .pub     = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00",
    .ok      = 1 },
  { .tc_id   = 22,
    .comment = "public key on twist",
    .shared  = "\x74\xbf\xc1\x5e\x55\x97\xe9\xf5\x19\x3f\x94\x1e\x10\xa5\xc0\x08\xfc\x89\xf0\x51\x39\x27\x23\x88\x6a\x4a\x8f\xe5\x09\x3a\x73\x54",
    .prv     = "\x68\xe1\x34\x09\x2e\x94\xe6\x22\xc8\xa0\xcd\x18\xaf\xf5\x5b\xe2\x3d\xab\xd9\x94\xeb\xde\xe9\x82\xd9\x06\x01\xf6\xf0\xf4\xb3\x69",
    .pub     = "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f",
    .ok      = 1 },
  { .tc_id   = 23,
    .comment = "public key on twist",
    .shared  = "\x0d\x41\xa5\xb3\xaf\x77\x0b\xf2\xfc\xd3\x4f\xf7\x97\x22\x43\xa0\xe2\xcf\x4d\x34\xf2\x04\x6a\x14\x45\x81\xae\x1e\xc6\x8d\xf0\x3b",
    .prv     = "\xe8\xe4\x3f\xc1\xeb\xac\x0b\xbc\x9b\x99\xc8\x03\x5e\xe1\xac\x59\xb9\x0f\x19\xa1\x6c\x42\xc0\xb9\x0f\x96\xad\xfc\xc5\xfd\xee\x78",
    .pub     = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20",
    .ok      = 1 },
  { .tc_id   = 24,
    .comment = "public key on twist",
    .shared  = "\x58\x94\xe0\x96\x35\x83\xae\x14\xa0\xb8\x04\x20\x89\x41\x67\xf4\xb7\x59\xc8\xd2\xeb\x9b\x69\xcb\x67\x55\x43\xf6\x65\x10\xf6\x46",
    .prv     = "\x18\xbf\xfb\x16\xf9\x26\x80\xa9\xe2\x67\x47\x3e\x43\xc4\x64\x47\x6d\x53\x72\xdd\xd1\xf6\x64\xf3\xd0\x67\x8e\xfe\x7c\x98\xbc\x79",
    .pub     = "\x00\x00\x00\xfc\xff\xff\x07\x00\x00\xe0\xff\xff\x3f\x00\x00\x00\xff\xff\xff\x01\x00\x00\xf8\xff\xff\x0f\x00\x00\xc0\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 25,
    .comment = "public key on twist",
    .shared  = "\xf8\x62\x4d\x6e\x35\xe6\xc5\x48\xac\x47\x83\x2f\x2e\x5d\x15\x1a\x8e\x53\xb9\x29\x03\x63\xb2\x8d\x2a\xb8\xd8\x4a\xb7\xcb\x6a\x72",
    .prv     = "\x30\x03\x05\xeb\x00\x2b\xf8\x6c\x71\xfe\x9c\x0b\x31\x19\x93\x72\x7b\x9d\xc6\x18\xd0\xce\x72\x51\xd0\xdf\xd8\x55\x2d\x17\x90\x5d",
    .pub     = "\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 26,
    .comment = "public key on twist",
    .shared  = "\xbf\xe1\x83\xba\x3d\x41\x57\xa7\xb5\x3e\xf1\x78\x61\x3d\xb6\x19\xe2\x78\x00\xf8\x53\x59\xc0\xb3\x9a\x9f\xd6\xe3\x21\x52\xc2\x08",
    .prv     = "\x80\xda\x9f\x02\x84\x22\x47\xd4\xad\xe5\xdd\xba\xc5\x1d\xbc\xe5\x5e\xa7\xdc\xa2\x84\x4e\x7f\x97\xab\x89\x87\xce\x7f\xd8\xbc\x71",
    .pub     = "\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 27,
    .comment = "public key on twist",
    .shared  = "\xbc\xa4\xa0\x72\x4f\x5c\x1f\xeb\x18\x40\x78\x44\x8c\x89\x8c\x86\x20\xe7\xca\xf8\x1f\x64\xcc\xa7\x46\xf5\x57\xdf\xf2\x49\x88\x59",
    .prv     = "\x80\x6e\x7f\x26\xca\x32\x46\xde\x81\x82\x94\x6c\xbe\xd0\x9f\x52\xb9\x5d\xa6\x26\xc8\x23\xc7\xb5\x04\x50\x00\x1a\x47\xb7\xb2\x52",
    .pub     = "\xed\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfe\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 28,
    .comment = "public key on twist",
    .shared  = "\xb3\x41\x8a\x52\x46\x4c\x15\xab\x0c\xac\xbb\xd4\x38\x87\xa1\x19\x92\x06\xd5\x92\x29\xce\xd4\x92\x02\x30\x06\x38\xd7\xa4\x0f\x04",
    .prv     = "\x58\x35\x4f\xd6\x4b\xc0\x22\xcb\xa3\xa7\x1b\x2a\xe6\x42\x81\xe4\xea\x7b\xf6\xd6\x5f\xdb\xae\xad\x14\x40\xee\xb1\x86\x04\xfe\x62",
    .pub     = "\xed\xff\xff\xff\xff\xff\xff\xfe\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 29,
    .comment = "public key on twist",
    .shared  = "\xfc\xde\x6e\x0a\x3d\x5f\xd5\xb6\x3f\x10\xc2\xd3\xaa\xd4\xef\xa0\x51\x96\xf2\x6b\xc0\xcb\x26\xfd\x6d\x9d\x3b\xd0\x15\xea\xa7\x4f",
    .prv     = "\xf0\x01\x9c\xf0\x51\x59\x79\x4c\xc8\x05\x2b\x00\xc2\xe7\x5b\x7f\x46\xfb\x66\x93\xc4\xb3\x8c\x02\xb1\x2a\x4f\xe2\x72\xe8\x55\x6a",
    .pub     = "\xed\xff\xff\xff\xff\xff\xef\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 30,
    .comment = "public key on twist",
    .shared  = "\x7d\x62\xf1\x89\x44\x4c\x62\x31\xa4\x8a\xfa\xb1\x0a\x0a\xf2\xee\xe4\xa5\x2e\x43\x1e\xa0\x5f\xf7\x81\xd6\x16\xaf\x21\x14\x67\x2f",
    .prv     = "\xd0\xfc\xa6\x4c\xc5\xf3\xa0\xc8\xe7\x5c\x82\x4e\x8b\x09\xd1\x61\x5a\xa7\x9a\xeb\xa1\x39\xbb\x73\x02\xe2\xbb\x2f\xcb\xe5\x4b\x40",
    .pub     = "\xed\xfe\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 31,
    .comment = "public key on twist",
    .shared  = "\x07\xba\x5f\xcb\xda\x21\xa9\xa1\x78\x45\xc4\x01\x49\x2b\x10\xe6\xde\x0a\x16\x8d\x5c\x94\xb6\x06\x69\x4c\x11\xba\xc3\x9b\xea\x41",
    .prv     = "\xd0\x24\x56\xe4\x56\x91\x1d\x3c\x6c\xd0\x54\x93\x31\x99\x80\x77\x32\xdf\xdc\x95\x86\x42\xad\x1a\xeb\xe9\x00\xc7\x93\xbe\xf2\x4a",
    .pub     = "\xea\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 32,
    .comment = "public key = 0",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x88\x22\x74\x94\x03\x8f\x2b\xb8\x11\xd4\x78\x05\xbc\xdf\x04\xa2\xac\x58\x5a\xda\x7f\x2f\x23\x38\x9b\xfd\x46\x58\xf9\xdd\xd4\x5e",
    .pub     = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 0 },
  { .tc_id   = 33,
    .comment = "public key = 1",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x48\x23\x2e\x89\x72\xb6\x1c\x7e\x61\x93\x0e\xb9\x45\x0b\x50\x70\xea\xe1\xc6\x70\x47\x56\x85\x54\x1f\x04\x76\x21\x7e\x48\x18\x4f",
    .pub     = "\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 0 },
  { .tc_id   = 34,
    .comment = "edge case public key",
    .shared  = "\x34\xb7\xe4\xfa\x53\x26\x44\x20\xd9\xf9\x43\xd1\x55\x13\x90\x23\x42\xb3\x86\xb1\x72\xa0\xb0\xb7\xc8\xb8\xf2\xdd\x3d\x66\x9f\x59",
    .prv     = "\xa8\x38\x6f\x7f\x16\xc5\x07\x31\xd6\x4f\x82\xe6\xa1\x70\xb1\x42\xa4\xe3\x4f\x31\xfd\x77\x68\xfc\xb8\x90\x29\x25\xe7\xd1\xe2\x5a",
    .pub     = "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 35,
    .comment = "edge case public key",
    .shared  = "\x3a\xa2\x27\xa3\x07\x81\xed\x74\x6b\xd4\xb3\x36\x5e\x5f\x61\x46\x1b\x84\x4d\x09\x41\x0c\x70\x57\x0a\xbd\x0d\x75\x57\x4d\xfc\x77",
    .prv     = "\xd0\x5a\xbd\x08\xbf\x5e\x62\x53\x8c\xb9\xa5\xed\x10\x5d\xbe\xdd\x6d\xe3\x8d\x07\x94\x00\x85\x07\x2b\x43\x11\xc2\x67\x8e\xd7\x7d",
    .pub     = "\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 36,
    .comment = "edge case public key",
    .shared  = "\x97\x75\x5e\x7e\x77\x57\x89\x18\x4e\x17\x68\x47\xff\xbc\x2f\x8e\xf9\x87\x99\xd4\x6a\x70\x9c\x6a\x1c\x0f\xfd\x29\x08\x1d\x70\x39",
    .prv     = "\xf0\xb8\xb0\x99\x8c\x83\x94\x36\x4d\x7d\xcb\x25\xa3\x88\x5e\x57\x13\x74\xf9\x16\x15\x27\x54\x40\xdb\x06\x45\xee\x7c\x0a\x6f\x6b",
    .pub     = "\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 37,
    .comment = "edge case public key",
    .shared  = "\xc2\x12\xbf\xce\xb9\x1f\x85\x88\xd4\x6c\xd9\x46\x84\xc2\xc9\xee\x07\x34\x08\x77\x96\xdc\x0a\x9f\x34\x04\xff\x53\x40\x12\x12\x3d",
    .prv     = "\xd0\x0c\x35\xdc\x17\x46\x0f\x36\x0b\xfa\xe7\xb9\x46\x47\xbc\x4e\x9a\x7a\xd9\xce\x82\xab\xea\xdb\x50\xa2\xf1\xa0\x73\x6e\x21\x75",
    .pub     = "\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 38,
    .comment = "edge case public key",
    .shared  = "\x38\x8f\xaf\xfb\x4a\x85\xd0\x67\x02\xba\x3e\x47\x9c\x6b\x21\x6a\x8f\x33\xef\xce\x05\x42\x97\x9b\xf1\x29\xd8\x60\xf9\x3b\x9f\x02",
    .prv     = "\x38\x5f\xc8\x05\x89\x00\xa8\x50\x21\xdd\x92\x42\x5d\x2f\xb3\x9a\x62\xd4\xe2\x3a\xef\x1d\x51\x04\xc4\xc2\xd8\x87\x12\xd3\x9e\x4d",
    .pub     = "\xff\xff\xff\xff\xff\xff\x0f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 39,
    .comment = "edge case public key",
    .shared  = "\x87\x7f\xec\x06\x69\xd8\xc1\xa5\xc8\x66\x64\x14\x20\xee\xa9\xf6\xbd\x1d\xfd\x38\xd3\x6a\x5d\x55\xa8\xc0\xab\x2b\xf3\x10\x5c\x68",
    .prv     = "\xe0\x61\x4b\x0c\x40\x8a\xf2\x4d\x9d\x24\xc0\xa7\x2f\x91\x37\xfb\xd6\xb1\x6f\x02\xcc\xc9\x47\x97\xea\x39\x71\xab\x16\x07\x3a\x7f",
    .pub     = "\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 40,
    .comment = "edge case public key",
    .shared  = "\x18\x03\x73\xea\x0f\x23\xea\x73\x44\x7e\x5a\x90\x39\x8a\x97\xd4\x90\xb5\x41\xc6\x93\x20\x71\x9d\x7d\xd7\x33\xfb\x80\xd5\x48\x0f",
    .prv     = "\xf0\x04\xb8\xfd\x05\xd9\xff\xfd\x85\x3c\xdc\x6d\x22\x66\x38\x9b\x73\x7e\x8d\xfc\x29\x6a\xd0\x0b\x5a\x69\xb2\xa9\xdc\xf7\x29\x56",
    .pub     = "\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 41,
    .comment = "edge case public key",
    .shared  = "\x20\x81\x42\x35\x0a\xf9\x38\xab\xa5\x2a\x15\x6d\xce\x19\xd3\xc2\x7a\xb1\x62\x87\x29\x68\x3c\xf4\xef\x26\x67\xc3\xdc\x60\xcf\x38",
    .prv     = "\xe8\x0b\xf0\xe6\x09\xbf\x3b\x03\x5b\x55\x2f\x9d\xb7\xe9\xec\xbc\x44\xa0\x4b\x79\x10\xb1\x49\x36\x61\xa5\x24\xf4\x6c\x3c\x22\x77",
    .pub     = "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 42,
    .comment = "edge case public key",
    .shared  = "\x1c\x32\x63\x89\x0f\x7a\x08\x1c\xef\xe5\x0c\xb9\x2a\xbd\x49\x65\x82\xd9\x0d\xcc\x2b\x9c\xb8\x58\xbd\x28\x68\x54\xaa\x6b\x0a\x7e",
    .prv     = "\x48\x89\x0e\x95\xd1\xb0\x3e\x60\x3b\xcb\x51\xfd\xf6\xf2\x96\xf1\xf1\xd1\x0f\x5d\xf1\x0e\x00\xb8\xa2\x5c\x98\x09\xf9\xaa\x1a\x54",
    .pub     = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 43,
    .comment = "edge case public key",
    .shared  = "\x56\x12\x8e\x78\xd7\xc6\x6f\x48\xe8\x63\xe7\xe6\xf2\xca\xa9\xc0\x98\x8f\xd4\x39\xde\xac\x11\xd4\xaa\xc9\x66\x40\x83\x08\x7f\x7a",
    .prv     = "\xa8\x06\xf1\xe3\x9b\x74\x26\x15\xa7\xdd\xe3\xb2\x94\x15\xed\x82\x7c\x68\xf0\x7d\x4a\x47\xa4\xd9\x59\x5c\x40\xc7\xfc\xcb\x92\x63",
    .pub     = "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 44,
    .comment = "edge case public key",
    .shared  = "\x30\xec\xa5\x6f\x1f\x1c\x2e\x8f\xf7\x80\x13\x4e\x0e\x93\x82\xc5\x92\x7d\x30\x5d\x86\xb5\x34\x77\xe9\xae\xca\x79\xfc\x9c\xed\x05",
    .prv     = "\x98\x99\xd5\xe2\x65\xe1\xfc\x7c\x32\x34\x52\x27\xd6\x69\x9a\x6d\x6b\x55\x17\xcf\x33\xb4\x3a\xb1\x56\xee\x20\xdf\x48\x78\x79\x4e",
    .pub     = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 45,
    .comment = "edge case public key",
    .shared  = "\xcb\x21\xb7\xaa\x3f\x99\x2e\xcf\xc9\x29\x54\x84\x91\x54\xb3\xaf\x6b\x96\xa0\x1f\x17\xbf\x21\xc6\x12\xda\x74\x8d\xb3\x8e\xb3\x64",
    .prv     = "\xd8\x42\x31\x6e\x54\x76\xae\xae\xe8\x38\x20\x42\x58\xa0\x6f\x15\xde\x01\x1b\xa4\x0b\x99\x62\x70\x5e\x7f\x6e\x88\x9f\xe7\x1f\x40",
    .pub     = "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 46,
    .comment = "edge case public key",
    .shared  = "\xc5\xca\xf8\xca\xbc\x36\xf0\x86\xde\xaf\x1a\xb2\x26\x43\x40\x98\xc2\x22\xab\xdf\x8a\xcd\x3c\xe7\x5c\x75\xe9\xde\xbb\x27\x15\x24",
    .prv     = "\xa0\x93\x3e\xe3\x05\x12\xb2\x5e\xe4\xe9\x00\xaa\xa0\x7f\x73\xe5\x07\xa8\xec\x53\xb5\x3a\x44\x62\x6e\x0f\x58\x9a\xf4\xe0\x35\x6c",
    .pub     = "\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 47,
    .comment = "edge case public key",
    .shared  = "\x4d\x46\x05\x2c\x7e\xab\xba\x21\x5d\xf8\xd9\x13\x27\xe0\xc4\x61\x04\x21\xd2\xd9\x12\x9b\x14\x86\xd9\x14\xc7\x66\xcf\x10\x4c\x27",
    .prv     = "\x38\xd6\x40\x3e\x13\x77\x73\x4c\xdc\xe9\x82\x85\xe8\x20\xf2\x56\xad\x6b\x76\x9d\x6b\x56\x12\xbc\xf4\x2c\xf2\xb9\x79\x45\xc0\x73",
    .pub     = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 48,
    .comment = "edge case public key",
    .shared  = "\xa0\xe0\x31\x51\x75\x78\x83\x62\xd4\xeb\xe0\x5e\x6a\xc7\x6d\x52\xd4\x01\x87\xbd\x68\x74\x92\xaf\x05\xab\xc7\xba\x7c\x70\x19\x7d",
    .prv     = "\x18\x21\x91\xb7\x05\x2e\x9c\xd6\x30\xef\x08\x00\x7f\xc6\xb4\x3b\xc7\x65\x29\x13\xbe\x67\x74\xe2\xfd\x27\x1b\x71\xb9\x62\xa6\x41",
    .pub     = "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x03",
    .ok      = 1 },
  { .tc_id   = 49,
    .comment = "edge case public key",
    .shared  = "\x5e\x64\x92\x4b\x91\x87\x3b\x49\x9a\x54\x02\xfa\x64\x33\x7c\x65\xd4\xb2\xed\x54\xbe\xeb\x3f\xa5\xd7\x34\x78\x09\xe4\x3a\xef\x1c",
    .prv     = "\x10\x62\x21\xfe\x56\x94\xa7\x10\xd6\xe1\x47\x69\x6c\x5d\x5b\x93\xd6\x88\x7d\x58\x4f\x24\xf2\x28\x18\x2e\xbe\x1b\x1d\x2d\xb8\x5d",
    .pub     = "\xff\xff\xff\x0f\x00\x00\x00\xff\xff\xff\x0f\x00\x00\x00\xff\xff\xff\x0f\x00\x00\x00\xff\xff\xff\x0f\x00\x00\x00\xff\xff\xff\x0f",
    .ok      = 1 },
  { .tc_id   = 50,
    .comment = "edge case public key",
    .shared  = "\xc0\x52\x46\x6f\x97\x12\xd9\xec\x4e\xf4\x0f\x27\x6b\xb7\xe6\x44\x1c\x54\x34\xa8\x3e\xfd\x8e\x41\xd2\x0c\xe8\x3f\x2d\xbf\x59\x52",
    .prv     = "\xd0\x35\xde\x94\x56\x08\x0d\x85\xa9\x12\x08\x3b\x2e\x3c\x7d\xdd\x79\x71\xf7\x86\xf2\x5a\x96\xc5\xe7\x82\xcf\x6f\x43\x76\xe3\x62",
    .pub     = "\x00\x00\x00\xfc\xff\xff\x03\x00\x00\xe0\xff\xff\x1f\x00\x00\x00\xff\xff\xff\x00\x00\x00\xf8\xff\xff\x07\x00\x00\xc0\xff\xff\x3f",
    .ok      = 1 },
  { .tc_id   = 51,
    .comment = "edge case public key",
    .shared  = "\xd1\x51\xb9\x7c\xba\x9c\x25\xd4\x8e\x6d\x57\x63\x38\xb9\x7d\x53\xdd\x8b\x25\xe8\x4f\x65\xf7\xa2\x09\x1a\x17\x01\x63\x17\xc5\x53",
    .prv     = "\xa8\xf3\x73\x18\xa4\xc7\x60\xf3\xcb\x2d\x89\x48\x22\x91\x87\x35\x68\x3c\xb1\xed\xac\xf3\xe6\x66\xe1\x56\x94\x15\x49\x78\xfd\x6d",
    .pub     = "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3f",
    .ok      = 1 },
  { .tc_id   = 52,
    .comment = "edge case public key",
    .shared  = "\x57\x16\x29\x6b\xaf\x2b\x1a\x6b\x9c\xd1\x5b\x23\xba\x86\x82\x97\x43\xd6\x0b\x03\x96\x56\x9b\xe1\xd5\xb4\x00\x14\xc0\x6b\x47\x7d",
    .prv     = "\x20\xd4\xd6\x24\xcf\x73\x2f\x82\x6f\x09\xe8\x08\x80\x17\x74\x2f\x13\xf2\xda\x98\xf4\xdc\xf4\xb4\x05\x19\xad\xb7\x90\xce\xbf\x64",
    .pub     = "\xed\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5f",
    .ok      = 1 },
  { .tc_id   = 53,
    .comment = "edge case public key",
    .shared  = "\xdd\xbd\x56\xd0\x45\x4b\x79\x4c\x1d\x1d\x49\x23\xf0\x23\xa5\x1f\x6f\x34\xef\x3f\x48\x68\xe3\xd6\x65\x93\x07\xc6\x83\xc7\x41\x26",
    .prv     = "\xd8\x06\xa7\x35\xd1\x38\xef\xb3\xb4\x04\x68\x3c\x9d\x84\x48\x5a\xb4\xaf\x54\x0d\x0a\xf2\x53\xb5\x74\x32\x3d\x89\x13\x00\x3c\x66",
    .pub     = "\xed\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 54,
    .comment = "edge case public key",
    .shared  = "\x80\x39\xee\xbe\xd1\xa4\xf3\xb8\x11\xea\x92\x10\x2a\x62\x67\xd4\xda\x41\x23\x70\xf3\xf0\xd6\xb7\x0f\x1f\xaa\xa2\xe8\xd5\x23\x6d",
    .prv     = "\x18\x41\x98\xc6\x22\x81\x77\xf3\xef\x41\xdc\x9a\x34\x12\x58\xf8\x18\x1a\xe3\x65\xfe\x9e\xc9\x8d\x93\x63\x9b\x0b\xbe\xe1\x46\x7d",
    .pub     = "\xff\xff\xff\xff\xfe\xff\xff\x7f\xff\xff\xff\xff\xfe\xff\xff\x7f\xff\xff\xff\xff\xfe\xff\xff\x7f\xff\xff\xff\xff\xfe\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 55,
    .comment = "edge case public key",
    .shared  = "\xb6\x95\x24\xe3\x95\x5d\xa2\x3d\xf6\xad\x1a\x7c\xd3\x85\x40\x04\x7f\x50\x86\x0f\x1c\x8f\xde\xd9\xb1\xfd\xfc\xc9\xe8\x12\xa0\x35",
    .prv     = "\xf0\xa4\x6a\x7f\x4b\x98\x9f\xe5\x15\xed\xc4\x41\x10\x93\x46\xba\x74\x6e\xc1\x51\x68\x96\xec\x5b\x7e\x4f\x4d\x90\x30\x64\xb4\x63",
    .pub     = "\xed\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfe\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 56,
    .comment = "edge case public key",
    .shared  = "\xe4\x17\xbb\x88\x54\xf3\xb4\xf7\x0e\xce\xa5\x57\x45\x4c\x5c\x4e\x5f\x38\x04\xae\x53\x79\x60\xa8\x09\x7b\x9f\x33\x84\x10\xd7\x57",
    .prv     = "\x88\x18\x74\xfd\xa3\xa9\x9c\x0f\x02\x16\xe1\x17\x2f\xbd\x07\xab\x1c\x7d\xf7\x86\x02\xcc\x6b\x11\x26\x4e\x57\xaa\xb5\xf2\x3a\x49",
    .pub     = "\xed\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfe\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 57,
    .comment = "edge case public key",
    .shared  = "\xaf\xca\x72\xbb\x8e\xf7\x27\xb6\x0c\x53\x0c\x93\x7a\x2f\x7d\x06\xbb\x39\xc3\x9b\x90\x3a\x7f\x44\x35\xb3\xf5\xd8\xfc\x1c\xa8\x10",
    .prv     = "\xb8\xd0\xf1\xae\x05\xa5\x07\x28\x31\x44\x31\x50\xe2\x02\xac\x6d\xb0\x03\x22\xcd\xf3\x41\xf4\x67\xe9\xf2\x96\x58\x8b\x04\xdb\x72",
    .pub     = "\xed\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfe\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 58,
    .comment = "edge case public key",
    .shared  = "\x7e\x41\xc2\x88\x6f\xed\x4a\xf0\x4c\x16\x41\xa5\x9a\xf9\x38\x02\xf2\x5a\xf0\xf9\xcb\xa7\xa2\x9a\xe7\x2e\x2a\x92\xf3\x5a\x1e\x5a",
    .prv     = "\xc8\x61\x9b\xa9\x88\x85\x9d\xb7\xd6\xf2\x0f\xbf\x3f\xfb\x8b\x11\x34\x18\xcc\x27\x80\x65\xb4\xe8\xbb\x6d\x4e\x5b\x3e\x7c\xb5\x69",
    .pub     = "\xed\xff\xff\xff\xff\xff\xff\xff\xfe\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 59,
    .comment = "edge case public key",
    .shared  = "\xdd\x3a\xbd\x47\x46\xbf\x4f\x2a\x0d\x93\xc0\x2a\x7d\x19\xf7\x6d\x92\x1c\x09\x0d\x07\xe6\xea\x5a\xba\xe7\xf2\x88\x48\x35\x59\x47",
    .prv     = "\xf8\xd4\xca\x1f\x37\xa3\x0e\xc9\xac\xd6\xdb\xe5\xa6\xe1\x50\xe5\xbc\x44\x7d\x22\xb3\x55\xd8\x0b\xa0\x02\xc5\xb0\x5c\x26\x93\x5d",
    .pub     = "\xed\xff\xff\xff\xfe\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 60,
    .comment = "edge case public key",
    .shared  = "\x8c\x27\xb3\xbf\xf8\xd3\xc1\xf6\xda\xf2\xd3\xb7\xb3\x47\x9c\xf9\xad\x20\x56\xe2\x00\x2b\xe2\x47\x99\x2a\x3b\x29\xde\x13\xa6\x25",
    .prv     = "\x88\x03\x7a\xc8\xe3\x3c\x72\xc2\xc5\x10\x37\xc7\xc8\xc5\x28\x8b\xba\x92\x65\xc8\x2f\xd8\xc3\x17\x96\xdd\x7e\xa5\xdf\x9a\xaa\x4a",
    .pub     = "\xed\xff\xff\xef\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 61,
    .comment = "edge case public key",
    .shared  = "\x8e\x1d\x22\x07\xb4\x74\x32\xf8\x81\x67\x74\x48\xb9\xd4\x26\xa3\x0d\xe1\xa1\xf3\xfd\x38\xca\xd6\xf4\xb2\x3d\xbd\xfe\x8a\x29\x01",
    .prv     = "\x50\x34\xee\x7b\xf8\x3a\x13\xd9\x16\x7d\xf8\x6b\x06\x40\x29\x4f\x36\x20\xf4\xf4\xd9\x03\x0e\x5e\x29\x3f\x91\x90\x82\x4a\xe5\x62",
    .pub     = "\xed\xff\xfe\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 62,
    .comment = "edge case public key",
    .shared  = "\x2c\xf6\x97\x4b\x0c\x07\x0e\x37\x07\xbf\x92\xe7\x21\xd3\xea\x9d\xe3\xdb\x6f\x61\xed\x81\x0e\x0a\x23\xd7\x2d\x43\x33\x65\xf6\x31",
    .prv     = "\x40\xbd\x4e\x1c\xaf\x39\xd9\xde\xf7\x66\x38\x23\x50\x2d\xad\x3e\x7d\x30\xeb\x6e\xb0\x1e\x9b\x89\x51\x6d\x4f\x2f\x45\xb7\xcd\x7f",
    .pub     = "\xeb\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 63,
    .comment = "public key with low order",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\xe0\xf9\x78\xdf\xcd\x3a\x8f\x1a\x50\x93\x41\x8d\xe5\x41\x36\xa5\x84\xc2\x0b\x7b\x34\x9a\xfd\xf6\xc0\x52\x08\x86\xf9\x5b\x12\x72",
    .pub     = "\xe0\xeb\x7a\x7c\x3b\x41\xb8\xae\x16\x56\xe3\xfa\xf1\x9f\xc4\x6a\xda\x09\x8d\xeb\x9c\x32\xb1\xfd\x86\x62\x05\x16\x5f\x49\xb8\x00",
    .ok      = 0 },
  { .tc_id   = 64,
    .comment = "public key with low order",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x38\x73\x55\xd9\x95\x61\x60\x90\x50\x3a\xaf\xad\x49\xda\x01\xfb\x3d\xc3\xed\xa9\x62\x70\x4e\xae\xe6\xb8\x6f\x9e\x20\xc9\x25\x79",
    .pub     = "\x5f\x9c\x95\xbc\xa3\x50\x8c\x24\xb1\xd0\xb1\x55\x9c\x83\xef\x5b\x04\x44\x5c\xc4\x58\x1c\x8e\x86\xd8\x22\x4e\xdd\xd0\x9f\x11\x57",
    .ok      = 0 },
  { .tc_id   = 65,
    .comment = "public key with low order",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\xc8\xfe\x0d\xf9\x2a\xe6\x8a\x03\x02\x3f\xc0\xc9\xad\xb9\x55\x7d\x31\xbe\x7f\xee\xd0\xd3\xab\x36\xc5\x58\x14\x3d\xaf\x4d\xbb\x40",
    .pub     = "\xec\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 0 },
  { .tc_id   = 66,
    .comment = "public key with low order",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\xc8\xd7\x4a\xcd\xe5\x93\x4e\x64\xb9\x89\x5d\x5f\xf7\xaf\xbf\xfd\x7f\x70\x4f\x7d\xfc\xcf\xf7\xac\x28\xfa\x62\xa1\xe6\x41\x03\x47",
    .pub     = "\xe0\xeb\x7a\x7c\x3b\x41\xb8\xae\x16\x56\xe3\xfa\xf1\x9f\xc4\x6a\xda\x09\x8d\xeb\x9c\x32\xb1\xfd\x86\x62\x05\x16\x5f\x49\xb8\x80",
    .ok      = 0 },
  { .tc_id   = 67,
    .comment = "public key with low order",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\xb8\x56\x49\xd5\x12\x0e\x01\xe8\xcc\xaf\x7b\x2f\xb8\xd8\x1b\x62\xe8\xad\x6f\x3d\x5c\x05\x53\xfd\xde\x19\x06\xcb\x9d\x79\xc0\x50",
    .pub     = "\x5f\x9c\x95\xbc\xa3\x50\x8c\x24\xb1\xd0\xb1\x55\x9c\x83\xef\x5b\x04\x44\x5c\xc4\x58\x1c\x8e\x86\xd8\x22\x4e\xdd\xd0\x9f\x11\xd7",
    .ok      = 0 },
  { .tc_id   = 68,
    .comment = "public key with low order",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x20\x64\xb2\xf4\xc9\xdc\x97\xec\x7c\xf5\x89\x32\xfd\xfa\x32\x65\xba\x6e\xa4\xd1\x1f\x02\x59\xb8\xef\xc8\xaf\xb3\x5d\xb8\x8c\x48",
    .pub     = "\xec\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
    .ok      = 0 },
  { .tc_id   = 69,
    .comment = "public key with low order",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x78\x6a\x33\xa4\xf7\xaf\x29\x7a\x20\xe7\x64\x29\x25\x93\x2b\xf5\x09\xe7\x07\x0f\xa1\xbc\x36\x98\x6a\xf1\xeb\x13\xf4\xf5\x0b\x55",
    .pub     = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 0 },
  { .tc_id   = 70,
    .comment = "public key with low order",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x78\x6a\x33\xa4\xf7\xaf\x29\x7a\x20\xe7\x64\x29\x25\x93\x2b\xf5\x09\xe7\x07\x0f\xa1\xbc\x36\x98\x6a\xf1\xeb\x13\xf4\xf5\x0b\x55",
    .pub     = "\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 0 },
  { .tc_id   = 71,
    .comment = "public key with low order",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x78\x6a\x33\xa4\xf7\xaf\x29\x7a\x20\xe7\x64\x29\x25\x93\x2b\xf5\x09\xe7\x07\x0f\xa1\xbc\x36\x98\x6a\xf1\xeb\x13\xf4\xf5\x0b\x55",
    .pub     = "\xec\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 0 },
  { .tc_id   = 72,
    .comment = "public key with low order",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x78\x6a\x33\xa4\xf7\xaf\x29\x7a\x20\xe7\x64\x29\x25\x93\x2b\xf5\x09\xe7\x07\x0f\xa1\xbc\x36\x98\x6a\xf1\xeb\x13\xf4\xf5\x0b\x55",
    .pub     = "\x5f\x9c\x95\xbc\xa3\x50\x8c\x24\xb1\xd0\xb1\x55\x9c\x83\xef\x5b\x04\x44\x5c\xc4\x58\x1c\x8e\x86\xd8\x22\x4e\xdd\xd0\x9f\x11\x57",
    .ok      = 0 },
  { .tc_id   = 73,
    .comment = "public key with low order",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x78\x6a\x33\xa4\xf7\xaf\x29\x7a\x20\xe7\x64\x29\x25\x93\x2b\xf5\x09\xe7\x07\x0f\xa1\xbc\x36\x98\x6a\xf1\xeb\x13\xf4\xf5\x0b\x55",
    .pub     = "\xe0\xeb\x7a\x7c\x3b\x41\xb8\xae\x16\x56\xe3\xfa\xf1\x9f\xc4\x6a\xda\x09\x8d\xeb\x9c\x32\xb1\xfd\x86\x62\x05\x16\x5f\x49\xb8\x00",
    .ok      = 0 },
  { .tc_id   = 74,
    .comment = "public key with low order",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x78\x6a\x33\xa4\xf7\xaf\x29\x7a\x20\xe7\x64\x29\x25\x93\x2b\xf5\x09\xe7\x07\x0f\xa1\xbc\x36\x98\x6a\xf1\xeb\x13\xf4\xf5\x0b\x55",
    .pub     = "\xed\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 0 },
  { .tc_id   = 75,
    .comment = "public key with low order",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x78\x6a\x33\xa4\xf7\xaf\x29\x7a\x20\xe7\x64\x29\x25\x93\x2b\xf5\x09\xe7\x07\x0f\xa1\xbc\x36\x98\x6a\xf1\xeb\x13\xf4\xf5\x0b\x55",
    .pub     = "\xee\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 0 },
  { .tc_id   = 76,
    .comment = "public key with low order",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x78\x6a\x33\xa4\xf7\xaf\x29\x7a\x20\xe7\x64\x29\x25\x93\x2b\xf5\x09\xe7\x07\x0f\xa1\xbc\x36\x98\x6a\xf1\xeb\x13\xf4\xf5\x0b\x55",
    .pub     = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80",
    .ok      = 0 },
  { .tc_id   = 77,
    .comment = "public key with low order",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x78\x6a\x33\xa4\xf7\xaf\x29\x7a\x20\xe7\x64\x29\x25\x93\x2b\xf5\x09\xe7\x07\x0f\xa1\xbc\x36\x98\x6a\xf1\xeb\x13\xf4\xf5\x0b\x55",
    .pub     = "\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80",
    .ok      = 0 },
  { .tc_id   = 78,
    .comment = "public key with low order",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x78\x6a\x33\xa4\xf7\xaf\x29\x7a\x20\xe7\x64\x29\x25\x93\x2b\xf5\x09\xe7\x07\x0f\xa1\xbc\x36\x98\x6a\xf1\xeb\x13\xf4\xf5\x0b\x55",
    .pub     = "\xec\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
    .ok      = 0 },
  { .tc_id   = 79,
    .comment = "public key with low order",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x78\x6a\x33\xa4\xf7\xaf\x29\x7a\x20\xe7\x64\x29\x25\x93\x2b\xf5\x09\xe7\x07\x0f\xa1\xbc\x36\x98\x6a\xf1\xeb\x13\xf4\xf5\x0b\x55",
    .pub     = "\x5f\x9c\x95\xbc\xa3\x50\x8c\x24\xb1\xd0\xb1\x55\x9c\x83\xef\x5b\x04\x44\x5c\xc4\x58\x1c\x8e\x86\xd8\x22\x4e\xdd\xd0\x9f\x11\xd7",
    .ok      = 0 },
  { .tc_id   = 80,
    .comment = "public key with low order",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x78\x6a\x33\xa4\xf7\xaf\x29\x7a\x20\xe7\x64\x29\x25\x93\x2b\xf5\x09\xe7\x07\x0f\xa1\xbc\x36\x98\x6a\xf1\xeb\x13\xf4\xf5\x0b\x55",
    .pub     = "\xe0\xeb\x7a\x7c\x3b\x41\xb8\xae\x16\x56\xe3\xfa\xf1\x9f\xc4\x6a\xda\x09\x8d\xeb\x9c\x32\xb1\xfd\x86\x62\x05\x16\x5f\x49\xb8\x80",
    .ok      = 0 },
  { .tc_id   = 81,
    .comment = "public key with low order",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x78\x6a\x33\xa4\xf7\xaf\x29\x7a\x20\xe7\x64\x29\x25\x93\x2b\xf5\x09\xe7\x07\x0f\xa1\xbc\x36\x98\x6a\xf1\xeb\x13\xf4\xf5\x0b\x55",
    .pub     = "\xed\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
    .ok      = 0 },
  { .tc_id   = 82,
    .comment = "public key with low order",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x78\x6a\x33\xa4\xf7\xaf\x29\x7a\x20\xe7\x64\x29\x25\x93\x2b\xf5\x09\xe7\x07\x0f\xa1\xbc\x36\x98\x6a\xf1\xeb\x13\xf4\xf5\x0b\x55",
    .pub     = "\xee\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
    .ok      = 0 },
  { .tc_id   = 83,
    .comment = "public key = 57896044618658097711785492504343953926634992332820282019728792003956564819949",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x40\xff\x58\x6e\x73\xd6\x1f\x09\x60\xdc\x2d\x76\x3a\xc1\x9e\x98\x22\x5f\x11\x94\xf6\xfe\x43\xd5\xdd\x97\xad\x55\xb3\xd3\x59\x61",
    .pub     = "\xed\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 0 },
  { .tc_id   = 84,
    .comment = "public key = 57896044618658097711785492504343953926634992332820282019728792003956564819950",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x58\x4f\xce\xae\xba\xe9\x44\xbf\xe9\x3b\x2e\x0d\x0a\x57\x5f\x70\x6c\xe5\xad\xa1\xda\x2b\x13\x11\xc3\xb4\x21\xf9\x18\x6c\x7a\x6f",
    .pub     = "\xee\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 0 },
  { .tc_id   = 85,
    .comment = "non-canonical public key",
    .shared  = "\xb4\xd1\x0e\x83\x27\x14\x97\x2f\x96\xbd\x33\x82\xe4\xd0\x82\xa2\x1a\x83\x33\xa1\x63\x15\xb3\xff\xb5\x36\x06\x1d\x24\x82\x36\x0d",
    .prv     = "\x00\x16\xb6\x2a\xf5\xca\xbd\xe8\xc4\x09\x38\xeb\xf2\x10\x8e\x05\xd2\x7f\xa0\x53\x3e\xd8\x5d\x70\x01\x5a\xd4\xad\x39\x76\x2d\x54",
    .pub     = "\xef\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 86,
    .comment = "non-canonical public key",
    .shared  = "\x51\x5e\xac\x8f\x1e\xd0\xb0\x0c\x70\x76\x23\x22\xc3\xef\x86\x71\x6c\xd2\xc5\x1f\xe7\x7c\xec\x3d\x31\xb6\x38\x8b\xc6\xee\xa3\x36",
    .prv     = "\xd8\x36\x50\xba\x7c\xec\x11\x58\x81\x91\x62\x55\xe3\xfa\x5f\xa0\xd6\xb8\xdc\xf9\x68\x73\x1b\xd2\xc9\xd2\xae\xc3\xf5\x61\xf6\x49",
    .pub     = "\xf0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 87,
    .comment = "non-canonical public key",
    .shared  = "\x69\x19\x99\x2d\x6a\x59\x1e\x77\xb3\xf2\xba\xcb\xd7\x4c\xaf\x3a\xea\x4b\xe4\x80\x2b\x18\xb2\xbc\x07\xeb\x09\xad\xe3\xad\x66\x62",
    .prv     = "\x88\xdd\x14\xe2\x71\x1e\xbd\x0b\x00\x26\xc6\x51\x26\x4c\xa9\x65\xe7\xe3\xda\x50\x82\x78\x9f\xba\xb7\xe2\x44\x25\xe7\xb4\x37\x7e",
    .pub     = "\xf1\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 88,
    .comment = "non-canonical public key",
    .shared  = "\x9c\x03\x4f\xcd\x8d\x3b\xf6\x99\x64\x95\x8c\x01\x05\x16\x1f\xcb\x5d\x1e\xa5\xb8\xf8\xab\xb3\x71\x49\x1e\x42\xa7\x68\x4c\x23\x22",
    .prv     = "\x98\xc2\xb0\x8c\xba\xc1\x4e\x15\x95\x31\x54\xe3\xb5\x58\xd4\x2b\xb1\x26\x8a\x36\x5b\x0e\xf2\xf2\x27\x25\x12\x9d\x8a\xc5\xcb\x7f",
    .pub     = "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 89,
    .comment = "non-canonical public key",
    .shared  = "\xed\x18\xb0\x6d\xa5\x12\xca\xb6\x3f\x22\xd2\xd5\x1d\x77\xd9\x9f\xac\xd3\xc4\x50\x2e\x4a\xbf\x4e\x97\xb0\x94\xc2\x0a\x9d\xdf\x10",
    .prv     = "\xc0\x69\x7b\x6f\x05\xe0\xf3\x43\x3b\x44\xea\x35\x2f\x20\x50\x8e\xb0\x62\x30\x98\xa7\x77\x08\x53\xaf\x5c\xa0\x97\x27\x34\x0c\x4e",
    .pub     = "\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80",
    .ok      = 1 },
  { .tc_id   = 90,
    .comment = "non-canonical public key",
    .shared  = "\x44\x8c\xe4\x10\xff\xfc\x7e\x61\x49\xc5\xab\xec\x0a\xd5\xf3\x60\x7d\xfd\xe8\xa3\x4e\x2a\xc3\x24\x3c\x30\x09\x17\x61\x68\xb4\x32",
    .prv     = "\x18\x42\x2b\x58\xa1\x8e\x0f\x45\x19\xb7\xa8\x87\xb8\xcf\xb6\x49\xe0\xbf\xe4\xb3\x4d\x75\x96\x33\x50\xa9\x94\x4e\x5b\x7f\x5b\x7e",
    .pub     = "\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80",
    .ok      = 1 },
  { .tc_id   = 91,
    .comment = "non-canonical public key",
    .shared  = "\x03\xa6\x33\xdf\x01\x48\x0d\x0d\x50\x48\xd9\x2f\x51\xb2\x0d\xc1\xd1\x1f\x73\xe9\x51\x5c\x69\x94\x29\xb9\x0a\x4f\x69\x03\x12\x2a",
    .prv     = "\x20\x62\x0d\x82\x48\x77\x07\xbe\xdf\x9e\xe3\x54\x9e\x95\xcb\x93\x90\xd2\x61\x8f\x50\xcf\x6a\xcb\xa4\x7f\xfa\xa1\x03\x22\x4a\x6f",
    .pub     = "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80",
    .ok      = 1 },
  { .tc_id   = 92,
    .comment = "non-canonical public key",
    .shared  = "\x9b\x01\x28\x77\x17\xd7\x2f\x4c\xfb\x58\x3e\xc8\x5f\x8f\x93\x68\x49\xb1\x7d\x97\x8d\xba\xe7\xb8\x37\xdb\x56\xa6\x2f\x10\x0a\x68",
    .prv     = "\x28\x5a\x6a\x7c\xee\xb7\x12\x2f\x2c\x78\xd9\x9c\x53\xb2\xa9\x02\xb4\x90\x89\x2f\x7d\xff\x32\x6f\x89\xd1\x26\x73\xc3\x10\x1b\x53",
    .pub     = "\xda\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
    .ok      = 1 },
  { .tc_id   = 93,
    .comment = "non-canonical public key",
    .shared  = "\xdf\xe6\x08\x31\xc9\xf4\xf9\x6c\x81\x6e\x51\x04\x88\x04\xdb\xdc\x27\x79\x5d\x76\x0e\xce\xd7\x5e\xf5\x75\xcb\xe3\xb4\x64\x05\x4b",
    .prv     = "\xc8\xe0\x33\x0a\xe9\xdc\xee\xff\x88\x7f\xba\x76\x12\x25\x87\x9a\x4b\xd2\xe0\xdb\x08\x79\x92\x44\x13\x6e\x47\x21\xb2\xc8\x89\x70",
    .pub     = "\xdb\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
    .ok      = 1 },
  { .tc_id   = 94,
    .comment = "non-canonical public key",
    .shared  = "\x50\xbf\xa8\x26\xca\x77\x03\x6d\xd2\xbb\xfd\x09\x2c\x3f\x78\xe2\xe4\xa1\xf9\x80\xd7\xc8\xe7\x8f\x2f\x14\xdc\xa3\xcc\xe5\xcc\x3c",
    .prv     = "\x10\xdb\x62\x10\xfc\x1f\xb1\x33\x82\x47\x2f\xa1\x78\x7b\x00\x4b\x5d\x11\x86\x8a\xb3\xa7\x95\x10\xe0\xce\xe3\x0f\x4a\x6d\xf2\x6b",
    .pub     = "\xdc\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
    .ok      = 1 },
  { .tc_id   = 95,
    .comment = "non-canonical public key",
    .shared  = "\x13\xda\x56\x95\xa4\xc2\x06\x11\x54\x09\xb5\x27\x7a\x93\x47\x82\xfe\x98\x5f\xa0\x50\xbc\x90\x2c\xba\x56\x16\xf9\x15\x6f\xe2\x77",
    .prv     = "\x90\x41\xc6\xe0\x44\xa2\x77\xdf\x84\x66\x27\x5c\xa8\xb5\xee\x0d\xa7\xbc\x02\x86\x48\x05\x4a\xde\x5c\x59\x2a\xdd\x30\x57\x47\x4e",
    .pub     = "\xea\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
    .ok      = 1 },
  { .tc_id   = 96,
    .comment = "non-canonical public key",
    .shared  = "\x63\x48\x3b\x5d\x69\x23\x6c\x63\xcd\xdb\xed\x33\xd8\xe2\x2b\xae\xcc\x2b\x0c\xcf\x88\x65\x98\xe8\x63\xc8\x44\xd2\xbf\x25\x67\x04",
    .prv     = "\xb8\xd4\x99\x04\x1a\x67\x13\xc0\xf6\xf8\x76\xdb\x74\x06\x58\x7f\xdb\x44\x58\x2f\x95\x42\x35\x6a\xe8\x9c\xfa\x95\x8a\x34\xd2\x66",
    .pub     = "\xeb\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
    .ok      = 1 },
  { .tc_id   = 97,
    .comment = "non-canonical public key",
    .shared  = "\xe9\xdb\x74\xbc\x88\xd0\xd9\xbf\x04\x6d\xdd\x13\xf9\x43\xbc\xcb\xe6\xdb\xb4\x7d\x49\x32\x3f\x8d\xfe\xed\xc4\xa6\x94\x99\x1a\x3c",
    .prv     = "\xc8\x5f\x08\xe6\x0c\x84\x5f\x82\x09\x91\x41\xa6\x6d\xc4\x58\x3d\x2b\x10\x40\x46\x2c\x54\x4d\x33\xd0\x45\x3b\x20\xb1\xa6\x37\x7e",
    .pub     = "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff",
    .ok      = 1 },
  { .tc_id   = 98,
    .comment = "public key = 57896044618658097711785492504343953926634992332820282019728792003956564819968",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x78\x87\x88\x9b\xac\x4c\x62\x9a\x10\x1d\x37\x24\xf2\xed\x8b\x98\xd9\x36\xfd\xe7\x9e\x1a\x1f\x77\xd8\x67\x79\x62\x6b\xf8\xf2\x63",
    .pub     = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80",
    .ok      = 0 },
  { .tc_id   = 99,
    .comment = "public key = 57896044618658097711785492504343953926634992332820282019728792003956564819969",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\xe0\x79\x71\xee\x82\x0e\x48\xb0\xb2\x66\xd8\xbe\x3c\xdb\xbb\x5e\x90\x0a\x43\xf5\x9e\xe8\x53\x5c\x65\x72\x41\x86\x15\xde\x49\x62",
    .pub     = "\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80",
    .ok      = 0 },
  { .tc_id   = 100,
    .comment = "RFC 7748",
    .shared  = "\xc3\xda\x55\x37\x9d\xe9\xc6\x90\x8e\x94\xea\x4d\xf2\x8d\x08\x4f\x32\xec\xcf\x03\x49\x1c\x71\xf7\x54\xb4\x07\x55\x77\xa2\x85\x52",
    .prv     = "\xa0\x46\xe3\x6b\xf0\x52\x7c\x9d\x3b\x16\x15\x4b\x82\x46\x5e\xdd\x62\x14\x4c\x0a\xc1\xfc\x5a\x18\x50\x6a\x22\x44\xba\x44\x9a\x44",
    .pub     = "\xe6\xdb\x68\x67\x58\x30\x30\xdb\x35\x94\xc1\xa4\x24\xb1\x5f\x7c\x72\x66\x24\xec\x26\xb3\x35\x3b\x10\xa9\x03\xa6\xd0\xab\x1c\x4c",
    .ok      = 1 },
  { .tc_id   = 101,
    .comment = "RFC 7748",
    .shared  = "\x95\xcb\xde\x94\x76\xe8\x90\x7d\x7a\xad\xe4\x5c\xb4\xb8\x73\xf8\x8b\x59\x5a\x68\x79\x9f\xa1\x52\xe6\xf8\xf7\x64\x7a\xac\x79\x57",
    .prv     = "\x48\x66\xe9\xd4\xd1\xb4\x67\x3c\x5a\xd2\x26\x91\x95\x7d\x6a\xf5\xc1\x1b\x64\x21\xe0\xea\x01\xd4\x2c\xa4\x16\x9e\x79\x18\xba\x4d",
    .pub     = "\xe5\x21\x0f\x12\x78\x68\x11\xd3\xf4\xb7\x95\x9d\x05\x38\xae\x2c\x31\xdb\xe7\x10\x6f\xc0\x3c\x3e\xfc\x4c\xd5\x49\xc7\x15\xa4\x13",
    .ok      = 1 },
  { .tc_id   = 102,
    .comment = "RFC 8037, Section A.6",
    .shared  = "\x4a\x5d\x9d\x5b\xa4\xce\x2d\xe1\x72\x8e\x3b\xf4\x80\x35\x0f\x25\xe0\x7e\x21\xc9\x47\xd1\x9e\x33\x76\xf0\x9b\x3c\x1e\x16\x17\x42",
    .prv     = "\x77\x07\x6d\x0a\x73\x18\xa5\x7d\x3c\x16\xc1\x72\x51\xb2\x66\x45\xdf\x4c\x2f\x87\xeb\xc0\x99\x2a\xb1\x77\xfb\xa5\x1d\xb9\x2c\x2a",
    .pub     = "\xde\x9e\xdb\x7d\x7b\x7d\xc1\xb4\xd3\x5b\x61\xc2\xec\xe4\x35\x37\x3f\x83\x43\xc8\x5b\x78\x67\x4d\xad\xfc\x7e\x14\x6f\x88\x2b\x4f",
    .ok      = 1 },
  { .tc_id   = 103,
    .comment = "edge case for shared secret",
    .shared  = "\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x60\xa3\xa4\xf1\x30\xb9\x8a\x5b\xe4\xb1\xce\xdb\x7c\xb8\x55\x84\xa3\x52\x0e\x14\x2d\x47\x4d\xc9\xcc\xb9\x09\xa0\x73\xa9\x76\x7f",
    .pub     = "\xb7\xb6\xd3\x9c\x76\x5c\xb6\x0c\x0c\x85\x42\xf4\xf3\x95\x2f\xfb\x51\xd3\x00\x2d\x4a\xeb\x9f\x8f\xf9\x88\xb1\x92\x04\x3e\x6d\x0a",
    .ok      = 1 },
  { .tc_id   = 104,
    .comment = "edge case for shared secret",
    .shared  = "\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x60\xa3\xa4\xf1\x30\xb9\x8a\x5b\xe4\xb1\xce\xdb\x7c\xb8\x55\x84\xa3\x52\x0e\x14\x2d\x47\x4d\xc9\xcc\xb9\x09\xa0\x73\xa9\x76\x7f",
    .pub     = "\x3b\x18\xdf\x1e\x50\xb8\x99\xeb\xd5\x88\xc3\x16\x1c\xbd\x3b\xf9\x8e\xbc\xc2\xc1\xf7\xdf\x53\xb8\x11\xbd\x0e\x91\xb4\xd5\x15\x3d",
    .ok      = 1 },
  { .tc_id   = 105,
    .comment = "edge case for shared secret",
    .shared  = "\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x60\xa3\xa4\xf1\x30\xb9\x8a\x5b\xe4\xb1\xce\xdb\x7c\xb8\x55\x84\xa3\x52\x0e\x14\x2d\x47\x4d\xc9\xcc\xb9\x09\xa0\x73\xa9\x76\x7f",
    .pub     = "\xca\xb6\xf9\xe7\xd8\xce\x00\xdf\xce\xa9\xbb\xd8\xf0\x69\xef\x7f\xb2\xac\x50\x4a\xbf\x83\xb8\x7d\xb6\x01\xb5\xae\x0a\x7f\x76\x15",
    .ok      = 1 },
  { .tc_id   = 106,
    .comment = "edge case for shared secret",
    .shared  = "\xfe\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3f",
    .prv     = "\x60\xa3\xa4\xf1\x30\xb9\x8a\x5b\xe4\xb1\xce\xdb\x7c\xb8\x55\x84\xa3\x52\x0e\x14\x2d\x47\x4d\xc9\xcc\xb9\x09\xa0\x73\xa9\x76\x7f",
    .pub     = "\x49\x77\xd0\xd8\x97\xe1\xba\x56\x65\x90\xf6\x0f\x2e\xb0\xdb\x6f\x7b\x24\xc1\x3d\x43\x69\x18\xcc\xfd\x32\x70\x8d\xfa\xd7\xe2\x47",
    .ok      = 1 },
  { .tc_id   = 107,
    .comment = "edge case for shared secret",
    .shared  = "\xfc\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3f",
    .prv     = "\x60\xa3\xa4\xf1\x30\xb9\x8a\x5b\xe4\xb1\xce\xdb\x7c\xb8\x55\x84\xa3\x52\x0e\x14\x2d\x47\x4d\xc9\xcc\xb9\x09\xa0\x73\xa9\x76\x7f",
    .pub     = "\x98\x73\x0b\xc0\x3e\x29\xe8\xb0\x57\xfb\x1d\x20\xef\x8c\x0b\xff\xc8\x22\x48\x5d\x3d\xb7\xf4\x5f\x4e\x3c\xc2\xc3\xc6\xd1\xd1\x4c",
    .ok      = 1 },
  { .tc_id   = 108,
    .comment = "edge case for shared secret",
    .shared  = "\xf9\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3f",
    .prv     = "\x60\xa3\xa4\xf1\x30\xb9\x8a\x5b\xe4\xb1\xce\xdb\x7c\xb8\x55\x84\xa3\x52\x0e\x14\x2d\x47\x4d\xc9\xcc\xb9\x09\xa0\x73\xa9\x76\x7f",
    .pub     = "\x97\xb4\xff\xf6\x82\xdf\x7f\x09\x6c\xd1\x75\x65\x69\xe2\x52\xdb\x48\x2d\x45\x40\x6a\x31\x98\xa1\xaf\xf2\x82\xa5\xda\x47\x4c\x49",
    .ok      = 1 },
  { .tc_id   = 109,
    .comment = "edge case for shared secret",
    .shared  = "\xf3\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3f",
    .prv     = "\x60\xa3\xa4\xf1\x30\xb9\x8a\x5b\xe4\xb1\xce\xdb\x7c\xb8\x55\x84\xa3\x52\x0e\x14\x2d\x47\x4d\xc9\xcc\xb9\x09\xa0\x73\xa9\x76\x7f",
    .pub     = "\x31\x77\x81\xb0\x16\x3b\xae\x74\xac\xcc\x06\xc0\xd4\x4e\xf9\xa9\x11\xa2\x2b\x0d\x37\xfa\xf7\x72\x66\x21\x59\x1f\x93\x43\xea\x2f",
    .ok      = 1 },
  { .tc_id   = 110,
    .comment = "edge case for shared secret",
    .shared  = "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x03",
    .prv     = "\x60\xa3\xa4\xf1\x30\xb9\x8a\x5b\xe4\xb1\xce\xdb\x7c\xb8\x55\x84\xa3\x52\x0e\x14\x2d\x47\x4d\xc9\xcc\xb9\x09\xa0\x73\xa9\x76\x7f",
    .pub     = "\x7e\x26\xf8\xf2\x4c\xb5\x90\x02\x7f\x9d\x1b\xc4\x9b\x0e\x1a\x24\x2c\x7d\x8f\x43\x62\x4d\x3e\x8f\xab\x28\xee\x08\xe0\x2c\xb4\x5e",
    .ok      = 1 },
  { .tc_id   = 111,
    .comment = "edge case for shared secret",
    .shared  = "\xe5\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .prv     = "\x60\xa3\xa4\xf1\x30\xb9\x8a\x5b\xe4\xb1\xce\xdb\x7c\xb8\x55\x84\xa3\x52\x0e\x14\x2d\x47\x4d\xc9\xcc\xb9\x09\xa0\x73\xa9\x76\x7f",
    .pub     = "\xe9\x6d\x27\x80\xe5\x46\x9a\x74\x62\x0a\xb5\xaa\x2f\x62\x15\x1d\x14\x0c\x47\x33\x20\xdb\xe1\xb0\x28\xf1\xa4\x8f\x8e\x76\xf9\x5f",
    .ok      = 1 },
  { .tc_id   = 112,
    .comment = "edge case for shared secret",
    .shared  = "\xe3\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .prv     = "\x60\xa3\xa4\xf1\x30\xb9\x8a\x5b\xe4\xb1\xce\xdb\x7c\xb8\x55\x84\xa3\x52\x0e\x14\x2d\x47\x4d\xc9\xcc\xb9\x09\xa0\x73\xa9\x76\x7f",
    .pub     = "\x8d\x61\x2c\x58\x31\xaa\x64\xb0\x57\x30\x0e\x7e\x31\x0f\x3a\xa3\x32\xaf\x34\x06\x6f\xef\xca\xb2\xb0\x89\xc9\x59\x28\x78\xf8\x32",
    .ok      = 1 },
  { .tc_id   = 113,
    .comment = "edge case for shared secret",
    .shared  = "\xdd\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .prv     = "\x60\xa3\xa4\xf1\x30\xb9\x8a\x5b\xe4\xb1\xce\xdb\x7c\xb8\x55\x84\xa3\x52\x0e\x14\x2d\x47\x4d\xc9\xcc\xb9\x09\xa0\x73\xa9\x76\x7f",
    .pub     = "\x8d\x44\x10\x8d\x05\xd9\x40\xd3\xdf\xe5\x64\x7e\xa7\xa8\x7b\xe2\x4d\x0d\x03\x6c\x9f\x0a\x95\xa2\x38\x6b\x83\x9e\x7b\x7b\xf1\x45",
    .ok      = 1 },
  { .tc_id   = 114,
    .comment = "edge case for shared secret",
    .shared  = "\xdb\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .prv     = "\x60\xa3\xa4\xf1\x30\xb9\x8a\x5b\xe4\xb1\xce\xdb\x7c\xb8\x55\x84\xa3\x52\x0e\x14\x2d\x47\x4d\xc9\xcc\xb9\x09\xa0\x73\xa9\x76\x7f",
    .pub     = "\x21\xa3\x5d\x5d\xb1\xb6\x23\x7c\x73\x9b\x56\x34\x5a\x93\x0a\xee\xe3\x73\xcd\xcf\xb4\x70\x12\x66\x78\x2a\x8a\xc5\x94\x91\x3b\x29",
    .ok      = 1 },
  { .tc_id   = 115,
    .comment = "edge case for shared secret",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02",
    .prv     = "\x60\xa3\xa4\xf1\x30\xb9\x8a\x5b\xe4\xb1\xce\xdb\x7c\xb8\x55\x84\xa3\x52\x0e\x14\x2d\x47\x4d\xc9\xcc\xb9\x09\xa0\x73\xa9\x76\x7f",
    .pub     = "\x3e\x5e\xfb\x63\xc3\x52\xce\x94\x27\x62\x48\x2b\xc9\x33\x7a\x5d\x35\xba\x55\x66\x47\x43\xac\x5e\x93\xd1\x1f\x95\x73\x36\xcb\x10",
    .ok      = 1 },
  { .tc_id   = 116,
    .comment = "edge case for shared secret",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00",
    .prv     = "\x60\xa3\xa4\xf1\x30\xb9\x8a\x5b\xe4\xb1\xce\xdb\x7c\xb8\x55\x84\xa3\x52\x0e\x14\x2d\x47\x4d\xc9\xcc\xb9\x09\xa0\x73\xa9\x76\x7f",
    .pub     = "\x8e\x41\xf0\x5e\xa3\xc7\x65\x72\xbe\x10\x4a\xd8\x78\x8e\x97\x08\x63\xc6\xe2\xca\x3d\xaa\xe6\x4d\x1c\x2f\x46\xde\xcf\xff\xa5\x71",
    .ok      = 1 },
  { .tc_id   = 117,
    .comment = "special case public key",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\xc8\xd0\x7c\x46\xbb\xfb\x82\x77\x53\xb9\x2c\x70\xe4\x95\x83\xce\x8b\xfa\x44\x64\x1a\x73\x82\x25\x8e\xa9\x03\xd6\xa8\x32\xc9\x6b",
    .pub     = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 0 },
  { .tc_id   = 118,
    .comment = "special case public key",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x90\xb7\xef\x23\x7a\x05\x5f\x34\x8d\xcb\x4c\x43\x64\xa5\x9d\x7d\x31\xed\xc7\xab\x78\xf2\xca\x25\x4e\x2c\x81\x09\x75\xc3\xf5\x43",
    .pub     = "\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 0 },
  { .tc_id   = 119,
    .comment = "special case public key",
    .shared  = "\x0c\x50\xac\x2b\xfb\x68\x15\xb4\x7d\x07\x34\xc5\x98\x13\x79\x88\x2a\x24\xa2\xde\x61\x66\x85\x3c\x73\x53\x29\xd9\x78\xba\xee\x4d",
    .prv     = "\xe0\xa8\xbe\x63\x31\x5c\x4f\x0f\x0a\x3f\xee\x60\x7f\x44\xd3\x0a\x55\xbe\x63\xf0\x95\x61\xd9\xaf\x93\xe0\xa1\xc9\xcf\x0e\xd7\x51",
    .pub     = "\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 120,
    .comment = "special case public key",
    .shared  = "\x77\x55\x71\x37\xa2\xa2\xa6\x51\xc4\x96\x27\xa9\xb2\x39\xac\x1f\x2b\xf7\x8b\x8a\x3e\x72\x16\x8c\xce\xcc\x10\xa5\x1f\xc5\xae\x66",
    .prv     = "\x08\x40\xa8\xaf\x5b\xc4\xc4\x8d\xa8\x85\x0e\x97\x3d\x7e\x14\x22\x0f\x45\xc1\x92\xce\xa4\x02\x0d\x37\x7e\xec\xd2\x5c\x7c\x36\x43",
    .pub     = "\x12\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 121,
    .comment = "special case public key",
    .shared  = "\xc8\x8e\x71\x9a\xe5\xc2\x24\x8b\x5f\x90\xda\x34\x6a\x92\xae\x21\x4f\x44\xa5\xd1\x29\xfd\x4e\x9c\x26\xcf\x6a\x0d\xa1\xef\xe0\x77",
    .prv     = "\x00\x92\x22\x9c\x75\x3a\x71\x28\x4d\x08\x53\x90\x94\x70\xad\x84\x7a\xb6\x2f\x43\x9e\xa5\x14\x82\xfb\x41\xd3\x0c\xc3\xb4\x47\x43",
    .pub     = "\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 122,
    .comment = "special case public key",
    .shared  = "\x4b\xf6\x78\x9c\x7e\xa0\x36\xf9\x73\xcd\xe0\xaf\x02\xd6\xfd\xb9\xb6\x4a\x0b\x95\x70\x22\x11\x14\x39\x57\x0f\xad\x7d\x7a\x45\x3f",
    .prv     = "\xb8\xda\x2b\xd2\xd7\xcf\x25\xa3\xe5\x4e\x5f\x87\xee\x15\x91\x1e\xff\xb9\xff\x86\xba\xec\x40\x76\xd5\x6c\x8e\x95\x36\x70\xbf\x5b",
    .pub     = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 123,
    .comment = "special case public key",
    .shared  = "\xbc\xac\x23\x5a\xe1\x5c\xc7\x14\x83\x72\xe1\x1f\x93\x15\xe3\xbc\x76\xce\xb9\x04\xb3\xd2\xa8\x24\x6b\xd9\xd9\xbe\x20\x82\xbb\x62",
    .prv     = "\x68\x4c\xd4\x20\xaf\x41\xab\xb3\xd1\x0c\x61\xe7\x73\x23\x8c\xf7\x29\xc2\x15\x5f\x94\x1a\xc2\x7e\x15\xf4\xc3\x7f\x49\xb2\x95\x76",
    .pub     = "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 124,
    .comment = "special case public key",
    .shared  = "\x5d\xd7\xd1\x6f\xff\x25\xcc\x5f\xdf\x9e\x03\xc3\x15\x7c\xb0\xa2\x35\xce\xa1\x7d\x61\x8f\x36\xe6\xf1\x34\x61\x56\x7e\xde\xb9\x43",
    .prv     = "\x38\xcf\xac\xaa\x44\x60\x79\x6b\x4d\xe4\x34\xbd\xd6\x73\x9f\x0d\x04\x36\x71\xf9\x7f\xa8\x29\x51\x75\x11\xe6\xb4\x7a\xa9\x34\x74",
    .pub     = "\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 125,
    .comment = "special case public key",
    .shared  = "\x28\x16\xfd\x03\x1d\x51\xd6\x75\x0f\x92\x25\xed\xe9\x50\x62\x5c\xca\x47\x44\x1c\xa9\x7e\x43\x09\x26\x50\x39\x69\x91\xaf\xcb\x6d",
    .prv     = "\x30\x83\x2e\x8c\xb6\x27\xac\x19\x5f\x77\xb1\x10\x52\x58\xe4\xbb\x18\xb9\x9a\x5e\xd9\x44\x40\x4b\xfa\xcb\x3a\x03\x9f\xbd\xb1\x4b",
    .pub     = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 126,
    .comment = "special case public key",
    .shared  = "\x7e\xd8\xf2\xd5\x42\x4e\x7e\xbb\x3e\xdb\xdf\x4a\xbe\x45\x54\x47\xe5\xa4\x8b\x65\x8e\x64\xab\xd0\x6c\x21\x8f\x33\xbd\x15\x1f\x64",
    .prv     = "\xd8\x18\xfd\x69\x71\xe5\x46\x44\x7f\x36\x1d\x33\xd3\xdb\xb3\xea\xdc\xf0\x2f\xb2\x8f\x24\x6f\x1d\x51\x07\xb9\x07\x3a\x93\xcd\x4f",
    .pub     = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 127,
    .comment = "special case public key",
    .shared  = "\xe8\x62\x0e\xd5\xca\x89\xc7\x2c\x5e\xa5\x50\x3e\x6d\xcd\x01\x13\x1c\xd5\xe8\x75\xc3\x0e\x13\xd5\xdc\x61\x9c\xe2\x8e\xc7\xd5\x59",
    .prv     = "\x10\x21\xcd\x86\x82\xbd\xc3\xf5\xda\x91\x00\xad\xff\x5b\x22\x30\xb3\xac\xd8\x36\xb3\xa4\x55\xdb\x83\x52\xa2\xc2\x7e\x69\xd1\x7e",
    .pub     = "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 128,
    .comment = "special case public key",
    .shared  = "\xce\xad\xb2\x64\x37\x9d\xca\xdd\x6e\x3b\xb8\xad\x24\xdd\x65\x3d\x2a\x60\x9d\xd7\x03\xd4\x1d\xa6\xca\xf3\xad\x00\xf0\x01\x86\x2c",
    .prv     = "\x20\xe4\xc9\x24\x71\x02\x29\x26\x55\xd6\x76\x5d\x7d\x84\xc6\xfc\xe5\x30\x9b\x80\x04\x04\x5d\xae\xa6\xd7\xd7\xdc\xad\x46\x28\x71",
    .pub     = "\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 129,
    .comment = "special case public key",
    .shared  = "\xf8\x6c\xc7\xbf\x1b\xe4\x95\x74\xfc\x97\xa0\x74\x28\x2e\x9b\xb5\xcd\x23\x8e\x00\x2b\xc8\xe9\xa7\xb8\x55\x2b\x2d\x60\xec\xcb\x52",
    .prv     = "\x90\xb1\x50\xd4\x62\xde\x51\x20\x56\xd5\xbd\x55\x17\x30\x74\x96\x9b\x49\x6f\x26\x2f\xb6\x91\x6b\x73\x3f\x62\x63\xa8\x07\x89\x71",
    .pub     = "\xa8\xb9\xc7\x37\x21\x18\xa5\x3a\x9d\xe9\xea\xf0\x86\x8e\x3b\x1a\x3d\x88\xe8\x1c\xb2\xe4\x07\xff\x71\x25\xe9\xf5\xc5\x08\x87\x15",
    .ok      = 1 },
  { .tc_id   = 130,
    .comment = "special case public key",
    .shared  = "\xcc\xbb\x8f\xd9\xde\xe1\x65\xa3\x98\xb2\xdb\xd7\xc8\x39\x6f\x81\x73\x6c\x1b\x3d\xa3\x6b\x35\xfb\xec\x8f\x32\x6f\x38\xf9\x27\x67",
    .prv     = "\x98\x87\x28\x6b\x32\x61\xc8\xd8\x57\xa1\x6f\x6d\xb2\x12\x77\xf7\x5d\x88\xd4\xe8\x61\xb3\xeb\xe7\x59\x66\x99\x04\x7e\x81\x66\x68",
    .pub     = "\xaa\xb9\xc7\x37\x21\x18\xa5\x3a\x9d\xe9\xea\xf0\x86\x8e\x3b\x1a\x3d\x88\xe8\x1c\xb2\xe4\x07\xff\x71\x25\xe9\xf5\xc5\x08\x87\x15",
    .ok      = 1 },
  { .tc_id   = 131,
    .comment = "special case public key",
    .shared  = "\x46\xad\xd6\xf4\x8f\xff\xf4\x61\x77\x7d\x4f\x89\xb6\xfd\xf1\x15\x5a\xa0\x51\xa9\x63\x87\xd4\x5f\x3e\x5e\x37\x1a\x23\x6b\x6e\x52",
    .prv     = "\x20\xca\x2c\x85\xcc\x87\x62\xe9\x6b\x70\x47\xbf\x15\xc7\x1c\x05\x0f\xfe\x0e\xd1\x61\x60\x40\xa9\x53\xae\x32\xa1\x29\x7a\xd8\x71",
    .pub     = "\x58\x50\x07\xa5\x93\x0d\x77\x62\x3c\xf2\x97\x56\x03\x8c\xa1\x97\xd3\xeb\xfd\x9e\x4c\x80\xa6\x95\x85\xef\xe0\x27\x40\x92\xc1\x15",
    .ok      = 1 },
  { .tc_id   = 132,
    .comment = "special case public key",
    .shared  = "\x1a\xdb\xe3\x22\x07\xe2\x1f\x71\xe1\xaf\x53\x88\x4d\x2a\x22\x76\x48\x1e\x29\x8e\x55\x7f\x4d\xac\xb3\x72\x0f\x24\x58\xe3\x08\x2d",
    .prv     = "\xd0\x27\x65\x66\x05\xb1\x0b\xf1\x8d\xea\x28\xbc\x52\x54\x6f\x9f\x1f\x08\xce\xf0\x6c\xaf\xd2\x00\xfc\x84\xf8\x7d\xbb\x4e\xbe\x46",
    .pub     = "\xfb\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1f",
    .ok      = 1 },
  { .tc_id   = 133,
    .comment = "special case public key",
    .shared  = "\xe1\x2c\xc5\x8f\xbe\xb7\x0a\x5e\x35\xc8\x61\xc3\x37\x10\xbe\x65\x16\xa6\xa9\x2e\x52\x37\x60\x60\x21\x1b\x24\x87\xdb\x54\x2b\x4f",
    .prv     = "\x48\x67\xa8\x3e\xe9\xd0\x1b\x75\x10\x84\x08\x67\xdb\x1a\xf6\xa6\x04\x9b\xdb\xb0\x56\xb7\x44\x43\xf7\x0c\x35\x8e\x16\x2c\x88\x67",
    .pub     = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20",
    .ok      = 1 },
  { .tc_id   = 134,
    .comment = "special case public key",
    .shared  = "\x42\x1b\xed\x1b\x26\xda\x1e\x9a\xdb\xea\xda\x1f\x32\xb9\x1a\x0f\xb4\xce\xd0\xf1\x11\x0e\x0a\x4a\x88\xe7\x35\xa1\x9e\xe4\x57\x1e",
    .prv     = "\xa0\x15\x97\x0a\x8a\xdd\x94\x0f\xca\x5b\x1b\x5d\x23\x87\x53\x97\xd5\x47\xd8\xd4\x94\xfc\xb3\x14\xf2\x04\x5a\x67\xa2\xd1\x2c\x4b",
    .pub     = "\xaf\xa0\x0e\x4a\x27\x1b\xee\xc4\x78\xe4\x2f\xad\x06\x18\x43\x2f\xa7\xd7\xfb\x3d\x99\x00\x4d\x2b\x0b\xdf\xc1\x4f\x80\x24\x83\x2b",
    .ok      = 1 },
  { .tc_id   = 135,
    .comment = "special case public key",
    .shared  = "\xd7\xb4\x74\x63\xe2\xf4\xca\x9a\x1a\x7d\xee\xa0\x98\xda\x8e\x74\xac\x3b\x4a\x10\x90\x83\xd9\x97\x25\x9b\x12\x99\x2e\x7e\x7e\x06",
    .prv     = "\x40\x58\xcb\x6b\x9a\xab\xa0\x2a\x33\x8a\xaa\x39\x2d\xbc\x10\x03\x9e\x26\xe9\xe4\x44\x11\x7e\x75\x8e\x24\xc5\xd8\xb2\x32\xea\x5e",
    .pub     = "\xb1\xa0\x0e\x4a\x27\x1b\xee\xc4\x78\xe4\x2f\xad\x06\x18\x43\x2f\xa7\xd7\xfb\x3d\x99\x00\x4d\x2b\x0b\xdf\xc1\x4f\x80\x24\x83\x2b",
    .ok      = 1 },
  { .tc_id   = 136,
    .comment = "special case public key",
    .shared  = "\x68\x6e\xb9\x10\xa9\x37\x21\x1b\x91\x47\xc8\xa0\x51\xa1\x19\x79\x06\x81\x8f\xdc\x62\x66\x68\xeb\x5f\x5d\x39\x4a\xfd\x86\xd4\x1b",
    .prv     = "\xb8\x76\xb0\x5d\xaf\xf0\x53\x0b\x13\x9d\x9e\x11\x25\x05\x63\x41\x80\x77\x17\x82\x46\xc5\xfa\x70\x05\xba\x00\xe9\xb6\x64\x77\x63",
    .pub     = "\xfb\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2f",
    .ok      = 1 },
  { .tc_id   = 137,
    .comment = "special case public key",
    .shared  = "\x09\x55\x97\x33\xb3\x5b\xcc\x6b\xb8\xac\x57\x4b\x5a\xbe\x3a\x4d\x88\x41\xde\xff\x05\x1c\x29\x4a\x07\x48\x7e\x3e\xec\x3c\x55\x58",
    .prv     = "\xd8\x7f\xd6\xaa\x5d\x8d\xee\xf6\xde\xe9\x61\x9a\x56\x84\x6a\x08\x29\x62\x05\x90\xf2\xda\x40\x83\x5d\x8e\x25\x15\x97\xe3\x90\x78",
    .pub     = "\x22\x23\x1c\x64\xef\x73\xad\x62\x31\x8b\x8a\x87\xbc\x38\xe2\x72\xe1\xbb\x8b\xf1\xa6\x0d\x7c\x00\x47\x6d\x0b\x05\x9d\x7b\x3c\x35",
    .ok      = 1 },
  { .tc_id   = 138,
    .comment = "special case public key",
    .shared  = "\xf7\xd5\xcb\xcf\x39\xeb\x72\x2b\x01\xed\x20\xc8\x55\x63\xeb\xb8\x1d\x07\x65\x11\xae\xad\x4c\xcc\x42\x90\x27\x86\x6b\x9f\xd2\x70",
    .prv     = "\x90\x03\x63\x21\xb6\x37\x51\xf7\x62\x2a\xa9\x3d\xa3\x4d\x85\xe5\x9c\xe8\x10\x09\xac\x5b\x9a\x06\x89\x21\xd8\x3b\xc4\x71\x5b\x57",
    .pub     = "\xf6\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3f",
    .ok      = 1 },
  { .tc_id   = 139,
    .comment = "special case public key",
    .shared  = "\xe9\x95\xad\x6a\x1e\xc6\xc5\xab\x32\x92\x2c\xff\x9d\x20\x47\x21\x70\x46\x73\x14\x3c\x4a\x11\xde\xaa\x20\x3f\x3c\x81\x98\x9b\x3f",
    .prv     = "\xa0\x67\x81\xfd\x4c\x4a\x08\x74\xe0\x0e\x72\xba\x13\x1b\x9d\xd8\x7a\x83\xb2\x90\x4e\x29\x4d\xe1\x76\xe8\xa9\xaf\x1f\x69\x5d\x67",
    .pub     = "\xf7\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3f",
    .ok      = 1 },
  { .tc_id   = 140,
    .comment = "special case public key",
    .shared  = "\x32\xb6\xda\xbe\x01\xd1\x38\x67\xf3\xb5\xb0\x89\x2f\xef\xd8\x0d\xca\x66\x6f\x2e\xdc\x5a\xfb\x43\xcd\x0b\xaf\x70\x3c\x3e\x69\x26",
    .prv     = "\xb8\x22\xd7\x2d\x8b\x68\xbd\xb4\xfb\xf6\x7e\x56\xa6\x1d\x67\x2b\x2c\x77\x47\xe9\x44\x79\xfe\x5a\xe4\x07\x2d\x0a\xcc\xdd\x65\x71",
    .pub     = "\xfe\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3f",
    .ok      = 1 },
  { .tc_id   = 141,
    .comment = "special case public key",
    .shared  = "\xa9\x3d\x83\xfc\x9e\xa0\xf6\xcb\x0c\xc8\xb6\x31\xda\x60\x00\x19\xb7\x6c\xbb\x2e\xc5\x72\x22\xf2\xe4\x2d\xd5\x40\xe3\xda\x85\x0b",
    .prv     = "\xd0\x8c\xe1\x23\x7e\x24\x8d\x02\xcd\xf6\x19\xd2\x0b\xea\x58\x48\xad\xe4\xf6\xff\xd1\x71\xb8\xde\xe8\x79\x3f\xc6\x7c\x45\x96\x40",
    .pub     = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40",
    .ok      = 1 },
  { .tc_id   = 142,
    .comment = "special case public key",
    .shared  = "\x01\x7c\xbf\xa2\xb3\x8e\x9e\xf3\x29\x7a\x33\x9e\xcc\xe1\xa9\x17\xbd\xcf\x7e\x91\x00\x36\x08\x6a\x41\xd1\xe2\x2d\x04\x24\x18\x70",
    .prv     = "\x18\x0a\xe3\xc9\x28\x51\x4c\xfb\x9e\xdd\x06\xe7\xdc\x1d\x5d\x06\x61\x60\xe9\x67\x44\x5a\x5c\x58\xe4\x46\x3b\x69\xed\x20\x5e\x6d",
    .pub     = "\xcb\xdc\xe3\x9b\x10\x8c\x52\x9d\xce\x74\x75\x78\x43\xc7\x1d\x8d\x1e\x44\x74\x0e\x59\xf2\x83\xff\xb8\x92\xf4\xfa\x62\x84\xc3\x4a",
    .ok      = 1 },
  { .tc_id   = 143,
    .comment = "special case public key",
    .shared  = "\x71\x13\x39\x05\xb8\xa5\x7e\xa8\xc3\x8d\xe0\xec\xf2\x13\x69\x9a\x75\xb0\x96\xc2\xdf\x21\xf0\x7f\x7e\x9e\xb0\x3e\x9f\xa5\x3f\x5c",
    .prv     = "\xe8\x81\xd8\x06\xa1\x10\x56\x0c\xd8\xfe\xe8\x99\xd5\x9c\x02\x49\xf1\x23\x3a\x43\x22\xc4\x1a\xa3\x69\xc7\xa2\xa9\x9f\x5b\x59\x62",
    .pub     = "\x3c\x5f\xf1\xb5\xd8\xe4\x11\x3b\x87\x1b\xd0\x52\xf9\xe7\xbc\xd0\x58\x28\x04\xc2\x66\xff\xb2\xd4\xf4\x20\x3e\xb0\x7f\xdb\x7c\x54",
    .ok      = 1 },
  { .tc_id   = 144,
    .comment = "special case public key",
    .shared  = "\x3d\xc7\xb7\x0e\x11\x07\x66\xb2\xbf\x52\x52\x52\xeb\xed\x98\xa1\x00\xb2\xe5\x32\xdc\x69\x54\x44\x64\xda\x1b\xba\xb8\x62\x5f\x6d",
    .prv     = "\x08\xe4\x10\xe1\xd7\xe8\xb9\x41\x12\x36\xaf\x4a\x35\xd6\xb6\x2a\x5d\x89\x31\x47\x8e\x4c\x62\x19\x7c\xfa\xfb\x49\x14\x67\xb1\x62",
    .pub     = "\x3e\x5f\xf1\xb5\xd8\xe4\x11\x3b\x87\x1b\xd0\x52\xf9\xe7\xbc\xd0\x58\x28\x04\xc2\x66\xff\xb2\xd4\xf4\x20\x3e\xb0\x7f\xdb\x7c\x54",
    .ok      = 1 },
  { .tc_id   = 145,
    .comment = "special case public key",
    .shared  = "\xe3\x17\xe5\xcc\x43\x8b\x5f\x79\xea\xd5\x53\x3a\xc7\xc4\x55\x19\xa1\x17\xb3\x10\x33\xcc\x21\x40\xb1\x9e\xdf\x85\x72\x01\x12\x40",
    .prv     = "\xe0\x2f\xdf\x7e\x0e\xe3\xd5\x5b\x44\x40\xf0\x14\x32\xdd\x25\x3c\x94\x97\x93\xbc\x04\xda\x44\xdd\xec\xe8\x3e\x54\xc8\xc3\x9b\x40",
    .pub     = "\xf2\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5f",
    .ok      = 1 },
  { .tc_id   = 146,
    .comment = "special case public key",
    .shared  = "\xd8\x68\x10\x51\x6a\xed\xdc\x18\x06\x10\x36\xf5\x99\xa9\xeb\x84\xd1\xc6\x14\x6b\x0f\x54\x36\x52\xdd\x45\x26\x74\x3b\xa4\x2c\x04",
    .prv     = "\xf0\x5d\x18\xf6\x8e\xf7\xa5\x86\x5c\x14\xdb\x3a\x9c\x25\x5f\xdf\x2d\xab\xea\x2a\xa3\x65\x81\xe9\x4f\x68\xb7\x27\xb5\x82\x86\x7b",
    .pub     = "\xf6\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5f",
    .ok      = 1 },
  { .tc_id   = 147,
    .comment = "special case public key",
    .shared  = "\xdf\xa9\x88\xa4\x77\x00\x3b\xe1\x25\xb9\x5c\xcb\xf2\x22\x3d\x97\x72\x95\x77\xd2\x5e\x1d\x6e\x89\xe3\xda\x0a\xfa\xbd\xd0\xae\x71",
    .prv     = "\x00\xc1\x03\x57\x8d\x5c\x07\x9d\x7b\xcc\x22\xc1\xc3\x1e\x78\x7c\x1b\x15\xc5\x7f\xcb\x49\x3f\xda\xfe\xfa\x20\x37\x1c\xfc\x74\x6b",
    .pub     = "\x95\xaf\xf8\x5a\x6c\xf2\x88\x9d\xc3\x0d\x68\xa9\xfc\x73\x5e\x68\x2c\x14\x02\x61\xb3\x7f\x59\x6a\x7a\x10\x1f\xd8\xbf\x6d\x3e\x6a",
    .ok      = 1 },
  { .tc_id   = 148,
    .comment = "special case public key",
    .shared  = "\xd4\x50\xaf\x45\xb8\xed\x5f\xe1\x40\xcc\x52\x63\xff\xb7\xb5\x2e\x66\x73\x68\x99\xa8\xb8\x72\xb6\xe2\x85\x52\x12\x98\x19\xb2\x5b",
    .prv     = "\x70\x05\xbb\x92\x74\x85\xc4\x35\x64\x2b\x42\x4a\x3d\xde\x01\x4b\xcf\x76\x34\x5e\x5b\xe6\x4a\xe6\xe9\xb2\x4d\xb3\x9e\x1c\xdb\x51",
    .pub     = "\x43\x46\x38\xc8\xde\xe7\x5a\xc5\x62\x16\x15\x0f\x79\x71\xc4\xe5\xc2\x77\x17\xe3\x4d\x1b\xf8\x00\x8e\xda\x16\x0a\x3a\xf7\x78\x6a",
    .ok      = 1 },
  { .tc_id   = 149,
    .comment = "special case public key",
    .shared  = "\x58\x00\x2c\x89\xbf\x8b\xc3\x2a\xe6\xfc\x20\x5b\x79\x6a\xcd\x13\xef\x7f\x84\x76\xf6\x49\x2a\xe4\xb2\xbe\x47\xf1\x09\x5e\x8a\x4f",
    .prv     = "\x08\x22\x03\x9a\x5d\xc1\x3c\x40\xfc\xcc\xf3\x46\xe2\xa7\x76\x9b\x4f\xd2\x72\x05\x2d\x43\x26\x0a\xd6\x26\x46\x8a\x50\xd4\x41\x62",
    .pub     = "\x45\x46\x38\xc8\xde\xe7\x5a\xc5\x62\x16\x15\x0f\x79\x71\xc4\xe5\xc2\x77\x17\xe3\x4d\x1b\xf8\x00\x8e\xda\x16\x0a\x3a\xf7\x78\x6a",
    .ok      = 1 },
  { .tc_id   = 150,
    .comment = "special case public key",
    .shared  = "\x77\x73\xaa\xd6\xe7\x2e\xb1\x73\x5b\x65\xad\x51\xf7\xda\xd2\x58\xc1\x1d\x7b\xff\xf5\x30\x94\x42\x4c\xb1\x03\xcd\x6b\xfb\x43\x68",
    .prv     = "\x40\xa6\x34\x9c\x03\xf0\xdc\x0a\x42\x35\x8f\x63\x53\xca\x67\x63\x2a\xf6\x87\xb1\x4c\x9d\xff\x62\x6c\x54\xe2\x11\xe8\xfc\x35\x5a",
    .pub     = "\xec\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfe\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 151,
    .comment = "special case public key",
    .shared  = "\xc1\x18\xdd\xf6\x46\x2f\xbe\xa8\x0f\x14\xef\x1f\x29\x72\xa1\xab\x12\xca\xfa\x51\x1d\x13\x23\xd4\xd2\x2d\x0d\x42\x6d\x65\x1b\x5b",
    .prv     = "\x50\x69\x6d\x4d\x05\x20\x99\x71\xd6\xba\x06\x76\xea\x27\x42\x62\xba\x63\x9a\xac\x74\xfa\x75\xe5\xdf\x45\x70\x76\x8a\xd8\xae\x74",
    .pub     = "\xee\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfe\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 152,
    .comment = "special case public key",
    .shared  = "\xcc\x07\x75\xbf\xd9\x70\xa2\x70\x6b\x11\xc7\x22\x2a\x44\x36\xa3\xd1\x71\x60\x38\x2c\x83\xb7\x6f\x89\xb6\x61\x92\xc8\x1b\x44\x08",
    .prv     = "\x68\xbb\x68\x0c\x85\x3f\x4e\x4d\xaa\x47\xc5\x86\xdc\x88\x6c\xf4\x56\x8d\x7b\x03\x83\x77\x0f\x6d\xf4\x39\xa5\x3b\xe4\xa3\x23\x6d",
    .pub     = "\xed\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 153,
    .comment = "special case public key",
    .shared  = "\xf0\x09\x7f\xa0\xba\x70\xd0\x19\x12\x62\x77\xab\x15\xc5\x6e\xcc\x17\x0c\xa8\x81\x80\xb2\xbf\x9d\x80\xfc\xda\x3d\x7d\x74\x55\x2a",
    .prv     = "\xb0\xf6\xc2\x8d\xbd\xc6\x47\x06\x8a\x76\xd7\x18\x05\xef\x77\x0f\x08\x7c\xf7\x6b\x82\xaf\xdc\x0d\x26\xc4\x5b\x71\xac\xe4\x97\x68",
    .pub     = "\xeb\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 1 },
  { .tc_id   = 154,
    .comment = "special case public key",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x18\x63\x0f\x93\x59\x86\x37\xc3\x5d\xa6\x23\xa7\x45\x59\xcf\x94\x43\x74\xa5\x59\x11\x4c\x79\x37\x81\x10\x41\xfc\x86\x05\x56\x4a",
    .pub     = "\xec\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x7f",
    .ok      = 0 },
  { .tc_id   = 155,
    .comment = "special case for E in multiplication by 2",
    .shared  = "\x59\xe7\xb1\xe6\xf4\x70\x65\xa4\x8b\xd3\x49\x13\xd9\x10\x17\x6b\x67\x92\xa1\x37\x2a\xad\x22\xe7\x3c\xd7\xdf\x45\xfc\xf9\x1a\x0e",
    .prv     = "\x58\x1e\xcb\xda\x5a\x4a\x22\x80\x44\xfe\xfd\x6e\x03\xdf\x23\x45\x58\xc3\xc7\x91\x52\xc6\xe2\xc5\xe6\x0b\x14\x2c\x4f\x26\xa8\x51",
    .pub     = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .ok      = 1 },
  { .tc_id   = 156,
    .comment = "special case for E in multiplication by 2",
    .shared  = "\x17\x9f\x6b\x02\x07\x48\xac\xba\x34\x91\x33\xea\xa4\x51\x8f\x1b\xd8\xba\xb7\xbf\xc4\xfb\x05\xfd\x4c\x24\xe7\x55\x3d\xa1\xe9\x60",
    .prv     = "\xb0\x56\x1a\x38\x00\x07\x95\xb7\xcb\x53\x7b\x55\xe9\x75\xea\x45\x2c\x21\x18\x50\x62\x95\xd5\xeb\x15\xfd\x9c\x83\xb6\x7f\x7a\x50",
    .pub     = "\x77\xaf\x0d\x38\x97\xa7\x15\xdf\xe2\x5d\xf5\xd5\x38\xcf\x13\x3b\xc9\xab\x7a\xd5\x2d\xf6\xbd\x92\x2a\x2f\xb7\x56\x21\xd5\x99\x01",
    .ok      = 1 },
  { .tc_id   = 157,
    .comment = "special case for E in multiplication by 2",
    .shared  = "\x43\xc5\xee\x14\x51\xf2\x13\xef\x76\x24\x72\x9e\x59\x5a\x0f\xee\x7c\x9a\xf7\xee\x5d\x27\xeb\x03\x27\x8e\xe9\xf9\x4c\x20\x23\x52",
    .prv     = "\xb0\x0f\x7d\xf2\xd4\x71\x28\x44\x1c\x72\x70\xb9\xa8\x7e\xee\x45\xb6\x05\x6f\xc6\x42\x36\xa5\x7b\xdf\x81\xdb\xcc\xcf\x5f\x5d\x42",
    .pub     = "\x4e\x39\x86\x61\x27\xb6\xa1\x2a\x54\x91\x4e\x10\x6a\xab\x86\x46\x4a\xf5\x56\x31\xf3\xcb\x61\x76\x6d\x59\x99\xaa\x8d\x2e\x07\x0e",
    .ok      = 1 },
  { .tc_id   = 158,
    .comment = "special case for E in multiplication by 2",
    .shared  = "\x2f\x35\x0b\xcf\x0b\x40\x78\x4d\x1d\x75\x6c\x9c\xa3\xe3\x8e\xc9\xdd\x68\xba\x80\xfa\xf1\xf9\x84\x7d\xe5\x07\x79\xc0\xd4\x90\x2a",
    .prv     = "\xc8\xf7\xa0\xc0\xbf\xb1\xe9\xc7\x25\x76\xc5\x34\xf8\x68\x54\xfb\xe4\xaf\x52\x1d\x4f\xa8\x07\xf6\x7e\x24\x40\xe1\x00\xec\x88\x52",
    .pub     = "\xad\xc6\x79\x9e\xd8\x49\x5e\xd5\xab\x6e\xb1\xef\x95\x54\x79\xb9\xb5\x0a\xa9\xce\x0c\x34\x9e\x89\x92\xa6\x66\x55\x72\xd1\xf8\x11",
    .ok      = 1 },
  { .tc_id   = 159,
    .comment = "special case for E in multiplication by 2",
    .shared  = "\xd5\xd6\x50\xdc\x62\x10\x72\xec\xa9\x52\xe4\x34\x4e\xfc\x73\x20\xb2\xb1\x45\x9a\xba\x48\xf5\xe2\x48\x0d\xb8\x81\xc5\x0c\xc6\x50",
    .prv     = "\x58\x18\x1f\x58\x1a\xa3\x70\x22\xff\x71\xc5\x6c\x6e\x68\xe6\x17\x5d\x96\x7c\x5c\x99\x5a\x24\x98\x85\xf6\x65\x65\x07\x4d\xed\x4d",
    .pub     = "\x77\x0f\x42\x18\xef\x23\x4f\x5e\x18\x54\x66\xe3\x24\x42\xc3\x02\xbb\xec\x21\xbb\xb6\xcd\x28\xc9\x79\xe7\x83\xfe\x50\x13\x33\x3f",
    .ok      = 1 },
  { .tc_id   = 160,
    .comment = "special case for E in multiplication by 2",
    .shared  = "\x90\x9c\xc5\x72\x75\xd5\x4f\x20\xc6\x7b\x45\xf9\xaf\x94\x84\xfd\x67\x58\x1a\xfb\x7d\x88\x7b\xee\x1d\xb5\x46\x1f\x30\x3e\xf2\x57",
    .prv     = "\x30\x1c\x93\x5c\xae\x43\x57\x07\x0b\x0a\xda\xf9\xcd\x61\x92\x83\x0b\x2c\x98\x9c\x15\x37\x29\xee\xd9\x9f\x58\x9e\xb4\x5f\x88\x4b",
    .pub     = "\x5c\x61\x18\xc4\xc7\x4c\xfb\x84\x2d\x9a\x87\x44\x9f\x9d\x8d\xb8\xb9\x92\xd4\x6c\x5a\x90\x93\xce\x2f\xcb\x7a\x49\xb5\x35\xc4\x51",
    .ok      = 1 },
  { .tc_id   = 161,
    .comment = "special case for E in multiplication by 2",
    .shared  = "\x4a\x7e\x2c\x5c\xaf\x1d\x81\x80\xeb\x1c\x4f\x22\x69\x2f\x29\xa1\x4b\x4c\xdc\x9b\x19\x3b\xd1\xd1\x6e\x2f\x27\x43\x8e\xef\x14\x48",
    .prv     = "\xd0\x02\x29\x2d\x43\x59\xa3\xd4\x2b\xc8\x76\x7f\x13\x80\x00\x93\x32\xe7\xa0\xdf\x2f\x33\x79\x01\x1a\xb7\x8f\x78\x9f\x6b\xaa\x54",
    .pub     = "\x40\x39\x86\x61\x27\xb6\xa1\x2a\x54\x91\x4e\x10\x6a\xab\x86\x46\x4a\xf5\x56\x31\xf3\xcb\x61\x76\x6d\x59\x99\xaa\x8d\x2e\x07\x6e",
    .ok      = 1 },
  { .tc_id   = 162,
    .comment = "special case for E in multiplication by 2",
    .shared  = "\xc0\xee\x59\xd3\x68\x5f\xc2\xc3\xc8\x03\x60\x8b\x5e\xe3\x9a\x7f\x8d\xa3\x0b\x48\xe4\x29\x3a\xe0\x11\xf0\xea\x1e\x5a\xeb\x71\x73",
    .prv     = "\xd0\xc2\xc4\x9e\x64\x4a\xb7\x38\x27\x07\x07\xff\x99\x17\x06\x59\x42\x68\x7e\x2f\x12\x88\x6d\x96\x11\x61\xdb\x46\xc0\x5b\x56\x5f",
    .pub     = "\x07\x8f\xa5\x23\x49\x8f\xb5\x1c\xba\x11\x12\xd8\x3b\x20\xaf\x44\x8b\x80\x09\xd8\xee\xa1\x43\x68\x56\x4d\x01\xb8\xf9\xb6\x08\x6f",
    .ok      = 1 },
  { .tc_id   = 163,
    .comment = "special case for E in multiplication by 2",
    .shared  = "\xb2\x52\xbc\x8e\xab\xfa\xa6\x8c\x56\xe5\x4d\x61\xb9\x90\x61\xa3\x5d\x11\xe3\xa7\xb9\xbd\xa4\x17\xd9\x0f\x69\xb1\x11\x9b\xcf\x45",
    .prv     = "\xf0\x87\xd3\x8b\x27\x4c\x1d\xad\x1b\xce\x6e\xaa\x36\xb4\x8e\x21\x90\xb9\x0b\x9b\xf8\xca\x59\x66\x9c\xc5\xe0\x04\x64\x53\x43\x42",
    .pub     = "\x9f\xc6\x79\x9e\xd8\x49\x5e\xd5\xab\x6e\xb1\xef\x95\x54\x79\xb9\xb5\x0a\xa9\xce\x0c\x34\x9e\x89\x92\xa6\x66\x55\x72\xd1\xf8\x71",
    .ok      = 1 },
  { .tc_id   = 164,
    .comment = "special case for E in multiplication by 2",
    .shared  = "\xfb\xda\x33\xbc\x93\x0c\x08\xdf\x83\x72\x08\xe1\x9a\xfd\xc1\xcf\xe3\xfd\x0f\x8f\x0e\x39\x76\xbe\x34\x77\x5e\x58\xa4\xa7\x77\x1f",
    .prv     = "\x48\xdb\xcc\x5a\x69\x5f\x15\x14\xbb\xba\xa6\xad\x00\x84\x2b\x69\xd9\xae\x52\x16\xb1\x96\x3a\xdd\x07\xfb\x29\x47\xc9\x7b\x84\x47",
    .pub     = "\x76\x50\xf2\xc7\x68\x58\xea\x20\x1d\xa2\x02\x2a\xc7\x30\xec\xc4\x36\x54\x85\x2a\xd2\x09\x42\x6d\xd5\xd0\x48\xa9\xde\x2a\x66\x7e",
    .ok      = 1 },
  { .tc_id   = 165,
    .comment = "D = 0 in multiplication by 2",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\x58\x91\xc9\x27\x2c\xf9\xa1\x97\x73\x5b\x70\x1e\x57\x15\x26\x8d\x36\xd7\x43\x6b\x7e\x35\x1a\x3e\x99\x7a\x08\x62\xe4\x80\x7d\x4d",
    .pub     = "\xe0\xeb\x7a\x7c\x3b\x41\xb8\xae\x16\x56\xe3\xfa\xf1\x9f\xc4\x6a\xda\x09\x8d\xeb\x9c\x32\xb1\xfd\x86\x62\x05\x16\x5f\x49\xb8\x00",
    .ok      = 0 },
  { .tc_id   = 166,
    .comment = "D = 0 in multiplication by 2",
    .shared  = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
    .prv     = "\xc0\xf9\xc6\x0a\xea\x73\x73\x1d\x92\xab\x5e\xd9\xf4\xce\xa1\x22\xf9\xa6\xeb\x25\x77\xbd\xa7\x2f\x94\x94\x8f\xea\x4d\x4c\xc6\x5d",
    .pub     = "\x5f\x9c\x95\xbc\xa3\x50\x8c\x24\xb1\xd0\xb1\x55\x9c\x83\xef\x5b\x04\x44\x5c\xc4\x58\x1c\x8e\x86\xd8\x22\x4e\xdd\xd0\x9f\x11\x57",
    .ok      = 0 },
  { .tc_id   = 167,
    .comment = "special case for DA - CB in multiplication by 2",
    .shared  = "\x8d\xac\xfe\x7b\xea\xaa\x62\xb9\x4b\xf6\xe5\x0e\xe5\x21\x4d\x99\xad\x7c\xda\x5a\x43\x1e\xa0\xc6\x2f\x2b\x20\xa8\x9d\x73\xc6\x2e",
    .prv     = "\x00\x66\xdd\x76\x74\xfe\x51\xf9\x32\x6c\x1e\x23\x9b\x87\x5f\x8a\xc0\x70\x1a\xae\x69\xa8\x04\xc2\x5f\xe4\x35\x95\xe8\x66\x0b\x45",
    .pub     = "\xb0\x22\x4e\x71\x34\xcf\x92\xd4\x0a\x31\x51\x5f\x2f\x0e\x89\xc2\xa2\x77\x7e\x8a\xc2\xfe\x74\x1d\xb0\xdc\x39\x39\x9f\xdf\x27\x02",
    .ok      = 1 },
  { .tc_id   = 168,
    .comment = "special case for DA - CB in multiplication by 2",
    .shared  = "\x20\xf1\xd3\xfe\x90\xe0\x8b\xc6\xf1\x52\xbf\x5d\xac\xc3\xed\x35\x89\x97\x85\x33\x3f\x14\x70\xe6\xa6\x2c\x3b\x8c\xbe\x28\xd2\x60",
    .prv     = "\x80\x06\x7f\x30\xf4\x0d\x61\x31\x8b\x42\x0c\x85\x9f\xce\x12\x8c\x90\x17\xab\x81\xb4\x7b\x76\x02\x8a\x57\xbc\x30\xd5\x85\x68\x46",
    .pub     = "\x60\x1e\x3f\xeb\xb8\x48\xec\x3e\x57\xfc\xe6\x45\x88\xaa\xd8\x2a\xfc\x9c\x2a\xf9\x9b\xbc\xdf\xfc\xc4\xcd\x58\xd4\xb3\xd1\x5c\x07",
    .ok      = 1 },
  { .tc_id   = 169,
    .comment = "special case for DA - CB in multiplication by 2",
    .shared  = "\x2b\x28\xcc\x51\x40\xb8\x16\xad\xd5\xad\x3a\x77\xa8\x1b\x1c\x07\x3d\x67\xbf\x51\xbf\x95\xbd\xa2\x06\x4a\x14\xeb\x12\xd5\xf7\x66",
    .prv     = "\x58\x45\x77\x66\x9d\x21\xce\x0a\xe3\xe3\x0b\x02\xc9\x78\x3f\xfe\x97\x70\x9c\xbf\xe3\x96\x88\x9a\xa3\x1e\x8e\xe4\x33\x52\xdc\x52",
    .pub     = "\x82\xa3\x80\x7b\xbd\xec\x2f\xa9\x93\x8f\xb4\x14\x1e\x27\xdc\x57\x45\x66\x06\x30\x1f\x78\xff\x71\x33\xcf\x24\xf3\xd1\x3e\xe1\x17",
    .ok      = 1 },
  { .tc_id   = 170,
    .comment = "special case for DA - CB in multiplication by 2",
    .shared  = "\x83\x92\x16\x00\x83\xb9\xaf\x9e\x0e\xf4\x4f\xcf\xce\x53\xba\x8f\xf7\x28\x2e\xe7\xa6\xc7\x1a\xb6\x6f\x88\x43\xa5\x5d\x09\xcd\x68",
    .prv     = "\x18\xe5\x97\xa4\xe2\xcc\xdb\x5e\x80\x52\xd5\x7c\x90\x09\x93\x8c\x2d\x4c\x43\xd6\xd8\xc9\xf9\x3c\x98\x72\x7b\x73\x11\x03\x59\x53",
    .pub     = "\xf3\x29\xab\x23\x76\x46\x2e\x5f\x31\x28\xa2\x68\x20\x86\x25\x3c\x19\x22\x2a\xc1\xe2\xbc\xa4\x56\x92\xf0\xc3\xb5\x28\xf4\xc4\x28",
    .ok      = 1 },
  { .tc_id   = 171,
    .comment = "special case for DA in multiplication by 2",
    .shared  = "\x42\x18\x4e\x22\xc5\x35\x53\x0c\x45\x7b\xd3\xb4\xf1\x08\x4c\xbf\x5e\x29\x7f\x50\x2f\xe1\x36\xb8\xd1\xda\xec\xf5\x33\x4c\xc9\x6c",
    .prv     = "\x88\x28\x1c\xc5\x1d\x55\x12\xd8\x81\x4e\xa5\x24\x9b\x87\x9d\xcb\xad\x03\x23\xd3\x85\x12\xda\xfb\xdc\x7b\xa8\x5b\xba\x8c\x8d\x5d",
    .pub     = "\x4f\xce\x3b\xb6\xc8\xaa\xf0\x22\xdb\xd1\x00\xe3\xcd\xe3\x94\x1b\x37\xd5\x43\xf0\x04\x01\xdb\xa7\xda\x9b\xc1\x43\xdf\xc5\x57\x09",
    .ok      = 1 },
  { .tc_id   = 172,
    .comment = "special case for DA in multiplication by 2",
    .shared  = "\xf6\x54\xd7\x8e\x59\x45\xb2\x4b\xc6\x3e\x3e\x6d\x79\x0e\x0a\xe9\x86\xe5\x39\x37\x76\x40\x68\xb1\xbc\xe9\x20\xe1\xd7\x9b\x75\x6f",
    .prv     = "\xd0\xe7\x95\x45\x0d\xf0\xa8\x13\xc6\x57\x34\x96\xec\x57\x93\xca\x02\xe1\xbd\xba\xd1\x0e\xd0\x8d\xf8\x3f\xda\xed\x68\xb3\x38\x5f",
    .pub     = "\x15\xc6\x88\x51\xc1\xdb\x84\x4b\x5a\x1e\xf3\x45\x6a\x65\x9f\x18\x88\x54\xb1\xa7\x5f\xbd\xb2\xf6\x8f\x51\x4c\x92\x89\xce\x71\x1f",
    .ok      = 1 },
  { .tc_id   = 173,
    .comment = "special case for DA in multiplication by 2",
    .shared  = "\xcd\x8a\x09\xb0\x47\x95\xed\xcc\x70\x61\x86\x73\x73\x98\x1a\xa7\x48\x65\x1e\xbd\xce\x5e\xc2\x18\xa3\x35\xb8\x78\xce\xfe\x48\x72",
    .prv     = "\x30\xb6\x9a\x1c\xc1\xeb\x2d\x0b\x83\xea\x21\x38\x46\xe9\x0a\x2c\x92\x20\x88\xbd\xf2\x94\xa6\x99\x5b\xf6\xe6\xe7\x7c\x64\x6c\x41",
    .pub     = "\x42\x00\xa2\x42\x43\x43\x37\xb8\x91\x4f\x49\x34\x53\x01\xed\x78\x2b\x13\x59\x4f\x9e\xde\x08\x9c\x41\xfb\x1e\x7e\xa8\x2c\x90\x53",
    .ok      = 1 },
  { .tc_id   = 174,
    .comment = "special case for DA in multiplication by 2",
    .shared  = "\xc9\xf8\x25\x8f\x23\x7d\xb1\xc8\x07\x02\xc5\xc4\xd9\x04\x8d\xfb\xa9\xdf\xe2\x59\xda\x4a\xee\xe9\x0d\xc2\x94\x55\x26\x96\x12\x75",
    .prv     = "\x78\xb3\x0b\xb6\x3c\xd8\xad\xe7\x1b\x7a\x77\xd4\x26\xf4\x41\x9d\x05\xf1\x99\xff\xef\x34\x9e\x89\xfa\xa9\xd9\xa5\xf2\x1f\x66\x54",
    .pub     = "\xba\xab\xf0\x17\x4a\xaa\xea\x4d\xe4\x8c\xc8\x3a\xdf\xb0\x40\x14\x61\xa7\x41\x90\x3e\xa6\xfb\x13\x0d\x7d\x64\xb7\xbf\x03\xa9\x66",
    .ok      = 1 },
  { .tc_id   = 175,
    .comment = "special case for x_2 in multiplication by 2",
    .shared  = "\x66\x00\xcb\xe9\x00\x61\x6a\x77\x0a\x12\x6b\x8b\x19\x15\x6d\x5e\x27\xe1\x17\x4b\xd5\x38\xd0\x94\x4e\xb3\xc0\xbe\x48\x99\xc7\x58",
    .prv     = "\xc0\xb3\x86\xf4\xef\x0d\x46\x98\x68\x64\x04\x97\x7e\x7b\x60\xcb\x6c\x1f\x8b\x60\x12\xa2\x2e\x29\xd6\x22\x4c\x59\x47\x43\x90\x41",
    .pub     = "\xf1\x2f\x18\xbd\x59\xc1\x26\x34\x8f\x6a\x7a\x9f\x4a\x5f\xdd\x9f\xca\xf5\x81\x34\x50\x73\xa8\x51\xfb\xa0\x98\xe5\xd6\x4b\x4a\x0c",
    .ok      = 1 },
  { .tc_id   = 176,
    .comment = "special case for x_2 in multiplication by 2",
    .shared  = "\x3f\xe7\x10\xd6\x34\x4f\xf0\xcb\x34\x2e\x52\x34\x9e\x1c\x5b\x57\xb7\xa2\x71\xf2\xa1\x33\xbb\x52\x49\xbb\xe4\x0d\xc8\x6e\x1b\x40",
    .prv     = "\x98\x86\x60\x2e\x71\x9b\xac\xaf\xea\x09\x2b\xb7\x5b\x51\xae\x72\x58\xab\xe1\xa3\x64\xc1\x76\x85\x7f\x3d\xc1\x88\xc0\x3e\x67\x59",
    .pub     = "\xbe\xe3\x86\x52\x7b\x77\x24\x90\xae\xb9\x6f\xc4\xd2\x3b\x93\x04\x03\x7c\xb4\x43\x0f\x64\xb2\x28\xf3\xd8\xb3\xb4\x98\x31\x9f\x22",
    .ok      = 1 },
  { .tc_id   = 177,
    .comment = "special case for x_2 in multiplication by 2",
    .shared  = "\x71\x37\x3e\xbe\x67\xf3\x9a\x2c\x23\x00\x27\xc7\xdb\x4b\x3b\x74\xba\xb8\x0e\xd2\x12\xb2\x32\x67\x97\x85\xee\x10\xf4\x7c\x30\x4e",
    .prv     = "\xb8\x39\x60\xf5\xd0\x61\x3c\xda\xac\x6d\xda\x69\x03\x51\x66\x6e\x9f\x27\x7b\xba\x6b\xd4\x06\xb0\xe2\x7a\x18\x86\xbb\x2d\x3e\x46",
    .pub     = "\xcf\x91\x1a\xc9\x1b\x0d\x94\x40\x49\xce\xc6\x6a\xe5\xef\x0c\x45\x49\xd1\xe6\x12\xe1\x07\xc6\x8e\x87\x26\x3a\x2f\xbc\xf8\x32\x3f",
    .ok      = 1 },
  { .tc_id   = 178,
    .comment = "special case for x_2 in multiplication by 2",
    .shared  = "\x23\x8e\xef\x43\xc5\x89\x82\x2e\x1d\x3d\xe4\x1c\x1c\xc4\x6d\xcf\xec\x7a\x93\xfe\xbf\x37\xc8\x54\x6b\x66\x25\xe1\xa1\x23\x81\x5d",
    .prv     = "\xd0\x3b\x75\xf0\x9a\xc8\x07\xdf\xd2\xee\x35\x2c\x04\xa1\xf2\x59\x84\x72\x0f\x78\x5f\xfa\xa0\xaf\x88\xbc\x5d\xb6\xff\x9c\x34\x53",
    .pub     = "\x1e\x6e\xe5\x36\xe4\xf2\x6b\xbf\xb6\x31\x39\x95\x1a\x10\xf3\xba\xb6\x2e\x19\xed\x1e\xf8\x39\x71\x78\xd9\xc5\xd0\x43\x07\xcd\x40",
    .ok      = 1 },
  { .tc_id   = 179,
    .comment = "special case for x_2 in multiplication by 2",
    .shared  = "\x87\xa7\x9c\x9c\x23\x1d\x3b\x95\x26\xb4\x9b\xf3\xd6\x83\xbf\x38\xc3\xc3\x19\xaf\x7c\x7c\x5d\x14\x56\x48\x73\x98\xda\x53\x50\x10",
    .prv     = "\xd0\x36\x94\x8c\x0e\xc2\x23\xf0\xee\x57\x7e\x39\x0d\xbf\x87\x22\x23\x58\xed\x19\x9f\x28\x23\x34\x5a\xd1\x54\xbb\xc4\xcb\xcc\x47",
    .pub     = "\x2f\x1c\x79\xad\x84\x88\xdb\x6f\x51\x46\x90\x3b\x2d\xc4\x6c\xfb\xfc\x83\x4b\xbc\xf0\x9b\x4d\xd7\x0c\x27\x4c\x4b\x67\xce\x60\x5d",
    .ok      = 1 },
  { .tc_id   = 180,
    .comment = "special case for x_2 in multiplication by 2",
    .shared  = "\xd6\x83\xca\x61\x94\x45\x2d\x87\x8c\x12\xd7\xda\x35\xf2\x28\x33\xf9\x97\x28\xbb\xa8\x99\x31\xa5\x12\x74\xf6\x12\x10\x33\x6a\x5f",
    .prv     = "\xd0\x54\xde\xd6\x13\xfe\xbf\x29\x50\xac\x5c\x92\x7f\xcb\x12\x0c\x38\x7d\xe0\xba\x61\xb3\x31\xcd\x33\x02\x4c\x8b\x6e\x73\x70\x48",
    .pub     = "\xfc\xcf\xe7\x42\xa6\x3e\xd9\xcb\x70\x95\x85\x60\xb5\xa0\x22\x60\x35\x0a\x7e\xcb\xaf\x8c\x57\xae\x04\x5f\x67\x1a\x29\xb4\xb5\x73",
    .ok      = 1 },
  { .tc_id   = 181,
    .comment = "special case for AA in multiplication by 2",
    .shared  = "\xdb\xf6\x20\x35\x16\x63\x58\x40\xcf\x69\xa0\x2d\xb8\x7c\xf0\xd9\x5d\xae\x31\x5d\xa7\xfc\x1e\xc7\xce\x2b\x29\xe1\xf2\xdb\x66\x66",
    .prv     = "\xe8\x2c\x48\x06\x31\xfb\x15\x3b\xa2\x21\x1f\xe6\x03\x03\x2b\x3e\x71\xb1\x62\xdb\xd3\xc1\x1b\xec\x03\x20\x8f\xfc\xd5\x10\x65\x5f",
    .pub     = "\xcb\x3d\x4a\x90\xf8\x6b\x30\x11\xda\x33\x69\xd9\x98\x85\x97\xc7\xff\xf1\x49\x92\x73\xb4\xa0\x4f\x84\xd0\xe2\x6e\xd1\x68\x3c\x0d",
    .ok      = 1 },
  { .tc_id   = 182,
    .comment = "special case for AA in multiplication by 2",
    .shared  = "\x1f\xe3\x14\x74\x43\x90\xd5\x25\x27\x8b\x1f\x5f\xbf\x10\x81\x01\xb8\xde\xd5\x87\x08\x13\x75\xed\x4a\xc4\xac\x69\x0d\x92\x41\x4f",
    .prv     = "\xc0\xc0\x1d\x28\xc1\xca\xb0\x1f\x59\x70\x0a\xca\x5f\x18\xd2\x69\x76\x58\xb3\x7f\xdd\x54\xa3\x39\xff\x39\x1c\x0a\x1a\x1b\x16\x45",
    .pub     = "\x10\x1e\x13\xf7\xbc\x05\x70\xfa\x26\x38\xca\xa2\x0a\x67\xc6\xe0\xc2\x1d\xab\x13\x2f\x4b\x45\x61\x91\x59\x02\x64\xc4\x93\xd0\x18",
    .ok      = 1 },
  { .tc_id   = 183,
    .comment = "special case for AA in multiplication by 2",
    .shared  = "\xad\x45\x43\x95\xee\x39\x2b\xe6\x77\xbe\x7b\x9c\xb9\x14\x03\x8d\x57\xd2\xd8\x7e\xc5\x6c\xc9\x86\x78\xdd\x84\xf1\x99\x20\x91\x2b",
    .prv     = "\xc8\x2b\xde\x72\xdf\x36\x47\x96\x88\xc4\x85\xa8\xbf\x44\x2f\x4a\x34\x41\x2e\x42\x9c\x02\xdb\x97\x70\x4f\x03\xda\xf4\xdf\xd5\x42",
    .pub     = "\xdc\xe1\xec\x08\x43\xfa\x8f\x05\xd9\xc7\x35\x5d\xf5\x98\x39\x1f\x3d\xe2\x54\xec\xd0\xb4\xba\x9e\x6e\xa6\xfd\x9b\x3b\x6c\x2f\x67",
    .ok      = 1 },
  { .tc_id   = 184,
    .comment = "special case for AA in multiplication by 2",
    .shared  = "\xc6\xd6\x49\x92\x55\x13\x33\x98\xf9\xdd\x7f\x32\x52\x5d\xb9\x77\xa5\x38\x11\x88\x00\xbf\xaf\x3a\xad\x8b\xcd\x26\xf0\x2c\x38\x63",
    .prv     = "\x50\x3f\x69\x76\x17\xfb\x02\xa7\xb8\xef\x00\xba\x34\xe7\xfc\x8c\xe9\x3f\x9e\xc3\xe1\xcb\xfe\x4b\xf2\xc0\x5b\xce\xe0\xcb\x97\x57",
    .pub     = "\x21\xc2\xb5\x6f\x07\x94\xcf\xee\x25\xcc\x96\x26\x67\x7a\x68\x38\x00\x0e\xb6\x6d\x8c\x4b\x5f\xb0\x7b\x2f\x1d\x91\x2e\x97\xc3\x72",
    .ok      = 1 },
  { .tc_id   = 185,
    .comment = "special case for BB in multiplication by 2",
    .shared  = "\x0d\x74\x21\x4d\xa1\x34\x4b\x11\x1d\x59\xdf\xad\x37\x13\xeb\x56\xef\xfe\x7c\x56\x0c\x59\xcb\xbb\x99\xec\x31\x39\x62\xdb\xba\x58",
    .prv     = "\x58\xcd\x4c\xa1\xe4\x33\x11\x88\xde\x2b\x28\x89\x41\x9c\xe2\x0e\xc5\xef\x88\xa0\xe9\x3a\xf0\x92\x09\x90\x65\x55\x1b\x90\x4e\x41",
    .pub     = "\xcc\x3d\x4a\x90\xf8\x6b\x30\x11\xda\x33\x69\xd9\x98\x85\x97\xc7\xff\xf1\x49\x92\x73\xb4\xa0\x4f\x84\xd0\xe2\x6e\xd1\x68\x3c\x0d",
    .ok      = 1 },
  { .tc_id   = 186,
    .comment = "special case for BB in multiplication by 2",
    .shared  = "\x7b\x9d\xbf\x8d\x6c\x6d\x65\x89\x8b\x51\x81\x67\xbf\x40\x11\xd5\x4d\xdc\x26\x5d\x95\x3c\x07\x43\xd7\x86\x8e\x22\xd9\x90\x9e\x67",
    .prv     = "\x00\x4e\xa3\x44\x8b\x84\xca\x50\x9e\xfe\xc5\xfc\xc2\x4c\x63\xee\x98\x4d\xef\x63\xb2\x9d\xeb\x90\x37\x89\x47\x09\x70\x9c\x09\x57",
    .pub     = "\x11\x1e\x13\xf7\xbc\x05\x70\xfa\x26\x38\xca\xa2\x0a\x67\xc6\xe0\xc2\x1d\xab\x13\x2f\x4b\x45\x61\x91\x59\x02\x64\xc4\x93\xd0\x18",
    .ok      = 1 },
  { .tc_id   = 187,
    .comment = "special case for BB in multiplication by 2",
    .shared  = "\xfb\x0e\x02\x09\xc5\xb9\xd5\x1b\x40\x11\x83\xd7\xe5\x6a\x59\x08\x1d\x37\xa6\x2a\xb1\xe0\x57\x53\xa0\x66\x7e\xeb\xd3\x77\xfd\x39",
    .prv     = "\xc8\xa6\xeb\x00\xa4\xd7\x4b\xbd\xff\x23\x95\x22\xc3\xc8\x91\xed\x7c\xe1\x90\x4b\xe2\xa3\x29\xcd\x0a\xe0\x06\x1a\x25\x3c\x95\x42",
    .pub     = "\xdd\xe1\xec\x08\x43\xfa\x8f\x05\xd9\xc7\x35\x5d\xf5\x98\x39\x1f\x3d\xe2\x54\xec\xd0\xb4\xba\x9e\x6e\xa6\xfd\x9b\x3b\x6c\x2f\x67",
    .ok      = 1 },
  { .tc_id   = 188,
    .comment = "special case for BB in multiplication by 2",
    .shared  = "\xdb\xe7\xa1\xfe\x3b\x33\x7c\x97\x20\x12\x3e\x6f\xcc\x02\xcf\x96\x95\x3a\x17\xdc\x9b\x39\x5a\x22\x06\xcb\x1b\xf9\x1d\x41\x75\x6e",
    .prv     = "\x50\x32\x2f\xf0\xd0\xdc\xdd\x6b\x14\xf3\x07\xc0\x4d\xfe\xce\xfe\x5b\x7c\xde\xaf\x92\xbf\xfb\x91\x9e\x9d\x62\xed\x27\x07\x90\x40",
    .pub     = "\x22\xc2\xb5\x6f\x07\x94\xcf\xee\x25\xcc\x96\x26\x67\x7a\x68\x38\x00\x0e\xb6\x6d\x8c\x4b\x5f\xb0\x7b\x2f\x1d\x91\x2e\x97\xc3\x72",
    .ok      = 1 },
  { .tc_id   = 189,
    .comment = "special case for D in multiplication by 2",
    .shared  = "\x97\xbd\x42\x09\x3e\x0d\x48\xf9\x73\xf0\x59\xdd\x7a\xb9\xf9\x7d\x13\xd5\xb0\xd5\xee\xdf\xfd\xf6\xda\x3c\x3c\x43\x28\x72\xc5\x49",
    .prv     = "\xe0\x32\x8c\x7d\x18\x8d\x98\xfa\xf2\xac\x72\xd7\x28\xb7\xd1\x4f\x2b\xbb\xd7\xa9\x4d\x0f\xbd\x8e\x8f\x79\xab\xe0\xb1\xfe\x10\x55",
    .pub     = "\xe5\x8b\xac\xce\xde\x32\xbc\xf3\x3b\x3b\x6e\x3d\x69\xc0\x2a\xf8\x28\x4a\x96\x31\xde\x74\xb6\xaf\x3f\x04\x6a\x93\x69\xdf\x04\x0f",
    .ok      = 1 },
  { .tc_id   = 190,
    .comment = "special case for D in multiplication by 2",
    .shared  = "\x99\xbc\xbc\x7b\x9a\xa5\xe2\x55\x80\xf9\x2b\xf5\x89\xe9\x5d\xae\x87\x4b\x83\xe4\x20\x22\x5d\x8a\x93\xe1\x8e\x96\xda\xc0\x0b\x63",
    .prv     = "\x50\x17\x67\x9a\x17\xbd\x23\xad\xf9\x5a\xd4\x7e\x31\x0f\xc6\x52\x6f\x4b\xa9\xca\x3b\x08\x39\xb5\x3b\xd0\xd9\x28\x39\xeb\x5b\x4f",
    .pub     = "\xc6\xd5\xc6\x93\xfc\x0a\x4e\x2d\xf6\xb2\x90\x02\x68\x60\x56\x6a\x16\x6b\x6d\x7a\xeb\xe3\xc9\x88\x28\xd4\x92\x74\x5c\x8d\xf9\x36",
    .ok      = 1 },
  { .tc_id   = 191,
    .comment = "special case for D in multiplication by 2",
    .shared  = "\xaf\xa2\xad\xb5\x2a\x67\x0a\xa9\xc3\xec\x30\x20\xd5\xfd\xa2\x85\x47\x4e\xde\x5c\x4f\x4c\x30\xe9\x23\x8b\x88\x4a\x77\x96\x94\x43",
    .prv     = "\x28\x64\xaa\xf6\x1c\x14\x6d\xf0\x6c\xc2\x56\xb0\x65\xf6\x6b\x34\x98\x5c\xc0\x15\xda\x5b\x1d\x64\x7a\x6e\xd4\xe2\xc7\x6b\xfc\x43",
    .pub     = "\xd1\x5f\x4b\xf2\xef\x5c\x7b\xda\x4e\xe9\x51\x96\xf3\xc0\xdf\x71\x0d\xf5\xd3\xd2\x06\x36\x0f\xc3\x17\x4e\xa7\x5c\x3a\xa3\xa7\x43",
    .ok      = 1 },
  { .tc_id   = 192,
    .comment = "special case for D in multiplication by 2",
    .shared  = "\xe6\xa2\xfc\x8e\xd9\x3c\xe3\x53\x01\x78\xfe\xf9\x4b\xb0\x05\x6f\x43\x11\x8e\x5b\xe3\xa6\xea\xbe\xe7\xd2\xed\x38\x4a\x73\x80\x0c",
    .prv     = "\x18\x4a\x6c\xfb\xab\xcb\xd1\x50\x7a\x2e\xa4\x1f\x52\x79\x65\x83\xdb\xdb\x85\x1b\x88\xa8\x57\x81\xee\x8e\x3c\x28\x78\x2c\x33\x49",
    .pub     = "\x6d\xff\xb0\xa2\x58\x88\xbf\x23\xcf\x1a\xc7\x01\xbf\xbd\xed\xe8\xa1\x8e\x32\x3b\x9d\x4d\x3d\x31\xe5\x16\xa0\x5f\xce\x7c\xe8\x72",
    .ok      = 1 },
  { .tc_id   = 193,
    .comment = "special case for D in multiplication by 2",
    .shared  = "\x7f\xc2\x87\x81\x63\x14\x10\xc5\xa6\xf2\x5c\x9c\xfd\x91\xec\x0a\x84\x8a\xdb\x7a\x9e\xb4\x0b\xc5\xb4\x95\xd0\xf4\x75\x3f\x22\x60",
    .prv     = "\xc8\x5f\x95\x4b\x85\xbc\x10\x2a\xca\x79\x96\x71\x79\x34\x52\x17\x65\x38\xd0\x77\x86\x2e\xe4\x5e\x0b\x25\x36\x19\x76\x7d\xff\x42",
    .pub     = "\x21\xf8\x6d\x12\x3c\x92\x3a\x92\xaa\xf2\x56\x3d\xf9\x4b\x5b\x5c\x93\x87\x4f\x5b\x7a\xb9\x95\x4a\xaa\x53\xe3\xd7\x2f\x0f\xf6\x7e",
    .ok      = 1 },
  { .tc_id   = 194,
    .comment = "special case for D in multiplication by 2",
    .shared  = "\x31\x4d\x8a\x2b\x5c\x76\xcc\x7e\xe1\x21\x7d\xf2\x28\x3b\x7e\x67\x24\x43\x6e\x27\x3a\xeb\x80\x62\x8d\xce\x06\x00\xab\x47\x8a\x63",
    .prv     = "\x50\xe3\xe5\xa9\xa1\x9b\xe2\xee\x35\x48\xb0\x96\x46\x72\xfb\x5e\x31\x34\xcb\x0d\x2f\x7a\xdf\x00\x0e\x45\x56\xd0\xff\xa3\x76\x43",
    .pub     = "\x58\x7c\x34\x7c\x8c\xb2\x49\x56\x4a\xb7\x73\x83\xde\x35\x8c\xc2\xa1\x9f\xe7\x37\x0a\x84\x76\xd4\x30\x91\x12\x35\x98\x94\x1c\x7f",
    .ok      = 1 },
  { .tc_id   = 195,
    .comment = "special case for DA + CB in multiplication by 2",
    .shared  = "\x2b\xfd\x8e\x53\x08\xc3\x44\x98\xeb\x2b\x4d\xaf\x9e\xd5\x1c\xf6\x23\xda\x3b\xea\xeb\x0e\xfd\x3d\x68\x7f\x2b\x8b\xec\xbf\x31\x01",
    .prv     = "\x08\xec\xe5\x80\xbb\x6d\xdf\x96\x55\x9b\x81\xd7\xa9\x7d\xd4\x53\x1d\xef\x6c\xc7\x8d\x44\x8a\x70\xce\xba\xbd\xd2\x6c\xaa\xb1\x46",
    .pub     = "\xf5\xc6\x31\x1a\x1d\xd1\xb9\xe0\xf8\xcf\xd0\x34\xac\x6d\x01\xbf\x28\xd9\xd0\xf9\x62\xa1\x93\x4a\xe2\xcb\x97\xcb\x17\x3d\xd8\x10",
    .ok      = 1 },
  { .tc_id   = 196,
    .comment = "special case for DA + CB in multiplication by 2",
    .shared  = "\xd5\x3c\x3d\x6f\x53\x8c\x12\x6b\x93\x36\x78\x5d\x1d\x4e\x69\x35\xdc\x8b\x21\xf3\xd7\xe9\xc2\x5b\xc2\x40\xa0\x3e\x39\x02\x33\x63",
    .prv     = "\xa8\x86\x03\x3e\x9d\xc2\xb6\xa9\x13\xff\xfb\xc2\xbd\x40\x2e\x8c\x11\xec\x34\xd4\x9c\x0d\xc0\xfa\x14\x29\x32\x9b\x69\x4a\x28\x5f",
    .pub     = "\x93\x16\xc0\x6d\x27\xb2\x4a\xbc\x67\x3f\xfb\x51\x05\xc5\xb9\xa8\x9b\xdf\xaa\x79\xe8\x1c\xdb\xb8\x95\x56\x07\x43\x77\xc7\x03\x20",
    .ok      = 1 },
  { .tc_id   = 197,
    .comment = "special case for DA + CB in multiplication by 2",
    .shared  = "\x45\x31\x88\x1a\xd9\xcf\x01\x16\x93\xdd\xf0\x28\x42\xfb\xda\xb8\x6d\x71\xe2\x76\x80\xe9\xb4\xb3\xf9\x3b\x4c\xf1\x5e\x73\x7e\x50",
    .prv     = "\x98\xb1\xcc\x20\x20\xa8\xec\x57\x5d\x5c\x46\xc7\x60\x24\xcf\x7c\x7a\xd7\x62\x8e\xb9\x09\x73\x0b\xc4\xf4\x60\xaa\xf0\xe6\xda\x4b",
    .pub     = "\x8a\x41\x79\x80\x7b\x07\x64\x9e\x04\xf7\x11\xbf\x94\x73\xa7\x99\x93\xf8\x42\x93\xe4\xa8\xb9\xaf\xee\x44\xa2\x2e\xf1\x00\x0b\x21",
    .ok      = 1 },
  { .tc_id   = 198,
    .comment = "special case for DA + CB in multiplication by 2",
    .shared  = "\x7b\xa4\xd3\xde\x69\x7a\xa1\x1a\xdd\xf3\x91\x1e\x93\xc9\x4b\x7e\x94\x3b\xef\xf3\xe3\xb1\xb5\x6b\x7d\xe4\x46\x1f\x9e\x48\xbe\x6b",
    .prv     = "\xc8\xe1\x93\xde\x16\x2a\xa3\x49\xa3\x43\x2c\x7a\x0c\x05\x21\xd9\x2c\xbc\x5e\x3b\xf8\x26\x15\xe4\x29\x55\xdd\x67\xec\x12\x34\x5f",
    .pub     = "\xa7\x73\x27\x7a\xe1\x02\x9f\x85\x47\x49\x13\x7b\x0f\x3a\x02\xb5\xb3\x56\x0b\x9c\x4c\xa4\xdb\xde\xb3\x12\x5e\xc8\x96\xb8\x18\x41",
    .ok      = 1 },
  { .tc_id   = 199,
    .comment = "special case for DA + CB in multiplication by 2",
    .shared  = "\xbc\xf0\x88\x40\x52\xf9\x12\xa6\x3b\xba\xb8\xc5\xc6\x74\xb9\x1c\x49\x89\xae\x05\x1f\xa0\x7f\xcf\x30\xcb\x53\x17\xfb\x1f\x2e\x72",
    .prv     = "\x88\xe0\x12\x37\xb3\x36\x01\x40\x75\x67\x60\x82\xaf\xbd\xe5\x1d\x59\x5d\x47\xe1\xfa\x52\x14\xb5\x1a\x35\x1a\xbb\xf6\x49\x14\x42",
    .pub     = "\x1e\xce\xb2\xb3\x76\x32\x31\xbc\x3c\x99\xdc\x62\x26\x6a\x09\xab\x5d\x36\x61\xc7\x56\x52\x4c\xdd\xc5\xaa\xbc\xed\xee\x92\xda\x61",
    .ok      = 1 },
  { .tc_id   = 200,
    .comment = "special case for DA + CB in multiplication by 2",
    .shared  = "\xe5\x77\x2a\x92\xb1\x03\xee\x69\x6a\x99\x97\x05\xcf\x07\x11\x0c\x46\x0f\x05\x45\x68\x2d\xb3\xfa\xc5\xd8\x75\xd6\x96\x48\xbc\x68",
    .prv     = "\xe8\x23\x13\xe4\x51\xa1\x98\xdc\xe4\xae\x95\xc6\x83\x2a\x82\x81\xd8\x47\xfc\x87\xb2\x8d\xb0\x0f\xe4\x37\x57\xc1\x6c\xc4\x9c\x4a",
    .pub     = "\x9a\x2a\xcb\xb3\xb5\xa3\x86\xa6\x10\x2e\x37\x28\xbe\x3a\x97\xde\x03\x98\x1d\x5c\x71\xfd\x2d\x95\x46\x04\xbe\xe3\xd3\xd0\xce\x62",
    .ok      = 1 },
  { .tc_id   = 201,
    .comment = "special case for DA + CB in multiplication by 2",
    .shared  = "\x37\x8c\x29\xe3\xbe\x97\xa2\x1b\x9f\x81\xaf\xca\x0d\x0f\x5c\x24\x2f\xd4\xf8\x96\x11\x4f\x77\xa7\x71\x55\xd0\x6c\xe5\xfb\xfa\x5e",
    .prv     = "\x28\x28\x59\x4d\x16\x76\x8e\x58\x6d\xf3\x96\x01\xec\xc8\x6d\x3f\xad\x63\x89\xd8\x72\xb5\x3f\xca\x3e\xdc\xaf\x6f\xb9\x58\xf6\x53",
    .pub     = "\x27\x43\x0e\x1c\x2d\x30\x89\x70\x8b\xca\x56\xd7\xa5\xad\x03\x79\x28\x28\xd4\x76\x85\xb6\x13\x1e\x02\x3d\xd0\x80\x87\x16\xb8\x63",
    .ok      = 1 },
  { .tc_id   = 202,
    .comment = "special case for z_2 in multiplication by 2",
    .shared  = "\x7e\xb4\x8a\x60\xb1\x4f\xb9\xea\x57\x28\xf6\x41\x0a\xef\x62\x7d\x15\x22\xfa\xd4\x81\xb9\x34\xaf\x64\xe2\xc4\x83\xb6\x4d\x58\x5f",
    .prv     = "\xa8\x4f\x48\x8e\x19\x31\x39\xf9\x86\xb0\xe5\xb2\x49\x63\x5b\x13\x7d\x38\x5e\x42\x03\x42\xae\xf1\xf1\x94\xfc\xde\x1f\xe5\xe8\x50",
    .pub     = "\x4e\xf3\x67\x90\x1a\xac\x8b\xa9\x0a\x50\xe0\xcf\x86\xca\x4e\x4a\x3f\xf1\x64\xfb\x12\x16\x05\xbe\x34\x6e\x2e\x48\xd0\x4a\xc9\x12",
    .ok      = 1 },
  { .tc_id   = 203,
    .comment = "special case for z_2 in multiplication by 2",
    .shared  = "\xb7\x1b\xdb\xed\x78\x02\x3a\x06\xde\xed\x1c\x18\x2e\x14\xc9\x8f\x7c\xf4\x6b\xc6\x27\xa4\xa2\xc1\x02\xad\x23\xc4\x1c\xf3\x24\x54",
    .prv     = "\x30\xfd\x2a\x78\x1e\x09\x5c\x34\xa4\x83\x90\x7b\x3d\xd2\xd8\xbd\x27\x36\xe2\x79\x61\x7b\xfa\x6b\x8b\x4e\x0e\x1c\xf9\x0f\xbd\x46",
    .pub     = "\xd1\xde\x30\x3c\x4d\xdd\x05\xd5\x7c\x29\xdf\x92\xad\x17\x2d\xd8\xc8\xf4\x24\xe6\x3e\xc9\x34\x45\xbe\xae\xa4\x4f\x9d\x12\x4b\x17",
    .ok      = 1 },
  { .tc_id   = 204,
    .comment = "special case for z_2 in multiplication by 2",
    .shared  = "\x5b\xb5\x68\x77\xca\xf2\xcd\xac\x98\x61\x1b\x60\x36\x7f\xbb\x74\x26\x59\x84\x61\x4e\x5e\x73\x99\x6e\x8e\xa1\xbd\x6f\x74\x9f\x1a",
    .prv     = "\x28\x31\x2e\x17\xb4\x7d\xd3\x2d\x90\x56\x11\x68\x24\x51\x87\x96\x3c\x74\x69\xa3\x1c\x88\x1e\x4a\x5c\x94\x38\x42\x62\xb7\x19\x59",
    .pub     = "\x5b\xcc\xd7\x39\xfd\x75\x17\xd9\x34\x4b\xf6\xb2\xb0\xf1\x9a\x1e\x0c\x38\xd9\x34\x9a\x25\xad\x1f\x94\xaf\x4a\x2c\xdc\xf5\xe8\x37",
    .ok      = 1 },
  { .tc_id   = 205,
    .comment = "special case for z_2 in multiplication by 2",
    .shared  = "\xb5\x68\xed\x46\xd0\x4f\x62\x91\xf8\xc1\x76\xdc\xa8\xaf\xf6\xd2\x21\xde\x4c\x9c\xce\x4b\x40\x4d\x54\x01\xfb\xe7\x0a\x32\x45\x01",
    .prv     = "\xa8\x76\x40\xcf\x82\x37\xb4\x73\xc6\x38\xb3\xe9\xdf\x08\x64\x4e\x86\x07\xe5\x63\xb5\x96\x43\x63\xcc\xc4\x21\x33\xb2\x99\x67\x42",
    .pub     = "\x8a\x7a\x93\x93\x10\xdf\x7e\xa7\x68\x45\x4d\xf5\x1b\xcd\x0d\xfb\xd7\xbe\x4f\xcb\xb2\xff\xc9\x84\x29\xd9\x13\xec\x69\x11\xf3\x37",
    .ok      = 1 },
  { .tc_id   = 206,
    .comment = "special case for z_2 in multiplication by 2",
    .shared  = "\x11\xfb\x44\xe8\x10\xbc\xe8\x53\x6a\x95\x7e\xaa\x56\xe0\x2d\x04\xdd\x86\x67\x00\x29\x8f\x13\xb0\x4e\xbe\xb4\x8e\x20\xd9\x36\x47",
    .prv     = "\x78\x0c\x5b\x88\x27\x20\xd8\x5e\x5d\xdf\xaf\x10\x33\xe9\xa1\x38\x5d\xf9\xe2\x16\x89\xee\xda\x4d\xcc\x74\x44\xad\x28\x33\x0a\x50",
    .pub     = "\xfe\x35\x90\xfc\x38\x2d\xa7\xa8\x2e\x28\xd0\x7f\xaf\xe4\x0d\x4a\xfc\x91\x18\x3a\x45\x36\xe3\xe6\xb5\x50\xfe\xe8\x4a\x4b\x7b\x4b",
    .ok      = 1 },
  { .tc_id   = 207,
    .comment = "special case for z_2 in multiplication by 2",
    .shared  = "\x85\xd9\xdb\x8f\x18\x2b\xc6\x8d\xb6\x7d\xe3\x47\x1f\x78\x6b\x45\xb1\x61\x9a\xec\x0f\x32\xb1\x08\xac\xe3\x0e\xe7\xb2\x62\x43\x05",
    .prv     = "\x20\x9e\x5e\x0a\xe1\x99\x4b\xd8\x59\xce\x89\x92\xb6\x2e\xc3\xa6\x6d\xf2\xeb\x50\x23\x2b\xcc\x3a\x3d\x27\xb6\x61\x4f\x6b\x01\x4d",
    .pub     = "\xfa\xd9\xab\x3e\x80\x3b\x49\xfc\x81\xb2\x7e\xe6\x9d\xb6\xfc\x9f\xdb\x82\xe3\x54\x53\xb5\x9e\xf8\xfa\xb2\xa3\xbe\xb5\xe1\x13\x4c",
    .ok      = 1 },
  { .tc_id   = 208,
    .comment = "special case for z_2 in multiplication by 2",
    .shared  = "\x61\xd4\xef\x71\xcb\xe7\xbe\x31\x28\xbe\x82\x9a\xb2\x6e\xd3\x46\x3e\xb4\xab\x25\x93\x7c\x30\x97\x88\xe8\x76\xb2\x34\x12\xaa\x7c",
    .prv     = "\x80\x6d\x1d\xee\x5f\xf6\xae\xa8\x4a\x84\x89\x16\x99\x1a\x89\xef\x36\x25\x58\x3e\x1b\xd4\xae\x0b\x3d\xd2\x5c\x25\x24\xa4\xff\x46",
    .pub     = "\x98\xbe\xd9\x55\xf1\x51\x6c\x7a\x44\x27\x51\xac\x59\x00\x46\xd7\xd5\x2c\xa6\x4f\x76\xdf\x82\xbe\x09\xd3\x2e\x5d\x33\xb4\x90\x73",
    .ok      = 1 },
  { .tc_id   = 209,
    .comment = "special case for z_2 in multiplication by 2",
    .shared  = "\x5b\xa4\x39\x4e\xd1\xa6\x64\x81\x1b\x01\x55\x79\x44\xbe\xcf\x75\x85\x65\x2a\x8a\xcb\xdb\xf8\x06\x74\x29\x11\x20\x7b\xd7\x93\x46",
    .prv     = "\x00\xf9\x8b\x02\xae\x0d\xf5\x27\x4c\xc8\x99\xf5\x26\xeb\x1b\x87\x72\x89\xe0\x96\x34\x40\xa5\x7d\xd9\x7e\x41\x4c\xdd\x2f\x7c\x51",
    .pub     = "\xe5\x9b\xe4\x91\x7b\x3f\x05\xb6\xfc\x87\x48\xc9\xb9\x0f\x1b\x91\x02\x73\xc9\xc6\xe1\x7f\xf9\x6e\xf4\x15\xff\x3d\x92\x7d\x98\x7e",
    .ok      = 1 },
  { .tc_id   = 210,
    .comment = "special case for A in multiplication by 2",
    .shared  = "\xa5\x95\x25\x88\x61\x3e\xb7\xa5\xcd\x49\xdd\x52\x6f\x1f\x20\xa4\xf0\xff\xe9\x42\x3e\x82\xce\xa3\x02\xc2\xdd\x90\xce\x55\x99\x55",
    .prv     = "\xd8\x6c\x18\xf2\xbe\x39\x6b\x3b\xb7\x2f\x22\xe6\xec\xe2\x2e\x27\x3a\xf6\xe1\x50\x6a\x1c\x09\xad\x4d\x01\xbd\xd2\xf4\x39\xf8\x43",
    .pub     = "\x8c\x98\x85\xa2\x6c\xb3\x34\x05\x47\x00\xa2\x70\xf7\xa5\xf4\xaa\xc0\x6b\xad\x82\x63\xb6\x51\xeb\xf0\x71\x2e\xca\x1e\xbb\x64\x16",
    .ok      = 1 },
  { .tc_id   = 211,
    .comment = "special case for A in multiplication by 2",
    .shared  = "\xcb\x6f\xb6\x23\x08\x4b\x61\x97\x44\x3e\xc9\xba\x10\x50\xc0\x92\x33\x32\xe5\xe8\x29\xae\x01\x94\x26\x9c\xfa\xf9\x20\xa4\x36\x01",
    .prv     = "\xf8\x1a\xad\xb9\x05\x3e\xb6\x98\x99\x6d\x0f\x78\x1d\x9c\xda\x67\xf8\x2d\xde\xfa\x39\x87\xd2\x76\xff\x5a\x94\xff\xdf\x5d\x25\x5f",
    .pub     = "\xf6\x13\x5f\xe9\x74\x1c\x2c\x9d\xe7\xdc\xf7\x62\x7e\xf0\x88\x32\xf3\x51\xcb\x32\x5d\xbb\x3a\x26\xf9\x3a\x2b\x48\x62\x0e\x17\x27",
    .ok      = 1 },
  { .tc_id   = 212,
    .comment = "special case for A in multiplication by 2",
    .shared  = "\x9e\x52\x60\x79\xc2\xfc\xf1\x24\x26\xae\x6c\x2a\x54\xb5\xff\xb7\x0f\x2e\xc6\x62\xe2\x9e\xa5\xce\x0c\x83\x85\xc3\xb2\x1c\xd1\x62",
    .prv     = "\x30\x5b\x4d\xb4\x32\x1b\x49\x23\xfc\x55\x9b\xf9\x1d\xf6\x77\xd0\xe1\x2c\x3a\x31\xb1\x6e\xc6\x55\xcb\x70\x8b\x75\x9d\x7c\x11\x4d",
    .pub     = "\xf6\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xbf\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3f",
    .ok      = 1 },
  { .tc_id   = 213,
    .comment = "special case for A in multiplication by 2",
    .shared  = "\x63\x29\xc7\xdc\x23\x18\xec\x36\x15\x3e\xf4\xf6\xf9\x1b\xc6\xe7\xd1\xe0\x08\xf5\x29\x30\x65\xd9\x58\x6a\xb8\x8a\xbb\x58\xf2\x41",
    .prv     = "\x90\x06\x38\xd1\x97\x98\x02\xdb\x9b\x52\xe4\xdd\x84\xfa\x19\x57\x9f\x61\xcd\x7b\xef\x3c\x0b\x62\xfc\xcc\xae\xaa\x15\xfa\x48\x4d",
    .pub     = "\xf6\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40",
    .ok      = 1 },
  { .tc_id   = 214,
    .comment = "special case for A in multiplication by 2",
    .shared  = "\x60\x3f\x4f\xc4\x10\x08\x1f\x88\x09\x44\xe0\xe1\x3d\x56\xfc\x54\x2a\x43\x0e\xec\x81\x3f\xad\x30\x2b\x7c\x5a\xc3\x80\x57\x6f\x1c",
    .prv     = "\x38\x57\x5c\xf7\xc8\x69\x1e\xcc\x79\xcd\x5f\x8d\x7d\x47\x03\xaa\x48\x59\x2f\xf6\xe7\xf6\x47\x31\xc2\xd9\x8a\x19\xae\xae\x51\x4f",
    .pub     = "\xf6\xeb\xa0\x16\x8b\xe3\xd3\x62\x18\x23\x08\x9d\x81\x0f\x77\xcd\x0c\xae\x34\xcd\xa2\x44\xc5\xd9\x06\xc5\xd4\xb7\x9d\xf1\xe8\x58",
    .ok      = 1 },
  { .tc_id   = 215,
    .comment = "special case for A in multiplication by 2",
    .shared  = "\x83\x4b\xba\xd5\x47\x0e\x14\x98\xc4\xb0\x14\x87\x82\xdf\xe6\x30\xe8\xbf\xad\xff\x19\x97\xde\x80\x2a\xc8\xce\x30\x2a\x1b\xda\x28",
    .prv     = "\xe8\x8b\xd0\x2c\x70\x16\x54\x7a\x24\xf4\x28\xbc\x2a\x9d\xcc\xca\xd6\xc6\xf8\x80\xc1\x7b\xff\xcf\x66\xfc\x68\x45\x96\x27\xaf\x4e",
    .pub     = "\x60\x67\x7a\x5d\x93\x4c\xcb\xfa\xb8\xff\x5d\x8f\x08\x5a\x0b\x55\x3f\x94\x52\x7d\x9c\x49\xae\x14\x0f\x8e\xd1\x35\xe1\x44\x9b\x69",
    .ok      = 1 },
  { .tc_id   = 216,
    .comment = "special case for B in multiplication by 2",
    .shared  = "\xec\x90\x70\xad\x34\x91\xa5\xff\x50\xd7\xd0\xdb\x6c\x9c\x84\x47\x83\xdd\xe1\xc6\xfb\xd4\xfe\x16\x3e\x9a\xde\x1c\xe9\xcd\x04\x1d",
    .prv     = "\x90\x36\xed\x7d\x68\xf7\x44\x8a\xc4\x40\xdc\x51\x21\x6b\x49\x84\x0d\xca\xbd\x3d\x5e\x32\xe3\xb4\xff\xc3\x2a\x5f\xe9\xe9\x67\x42",
    .pub     = "\x8d\x98\x85\xa2\x6c\xb3\x34\x05\x47\x00\xa2\x70\xf7\xa5\xf4\xaa\xc0\x6b\xad\x82\x63\xb6\x51\xeb\xf0\x71\x2e\xca\x1e\xbb\x64\x16",
    .ok      = 1 },
  { .tc_id   = 217,
    .comment = "special case for B in multiplication by 2",
    .shared  = "\xdc\x6d\x05\xb9\x2e\xdc\xdb\x5d\xc3\x34\xb1\xfc\x3d\xff\x58\xfe\x5b\x24\xa5\xc5\xf0\xb2\xd4\x31\x15\x55\xd0\xfc\x94\x5d\x77\x59",
    .prv     = "\x90\xc5\x5e\x77\xaa\x0f\xe4\xaf\xb1\x28\x71\x09\xfd\x01\x0f\x52\x63\x64\xde\xa1\x8d\x88\xe2\xfd\x87\x0a\xc0\x1b\x66\xe3\xfa\x4e",
    .pub     = "\xf7\x13\x5f\xe9\x74\x1c\x2c\x9d\xe7\xdc\xf7\x62\x7e\xf0\x88\x32\xf3\x51\xcb\x32\x5d\xbb\x3a\x26\xf9\x3a\x2b\x48\x62\x0e\x17\x27",
    .ok      = 1 },
  { .tc_id   = 218,
    .comment = "special case for B in multiplication by 2",
    .shared  = "\x1b\x17\x4b\x18\x99\x81\xd8\x1b\xc6\x88\x79\x32\x08\x3e\x84\x88\xdf\x8b\xbb\xed\x57\xf9\x21\x4c\x9c\xfa\x59\xd5\x9b\x57\x23\x59",
    .prv     = "\xa0\x21\xba\x2f\xd4\xe3\xad\x57\xbc\xbf\x20\x4d\x6f\x6c\x3e\x80\x18\xd8\x97\x85\x52\x63\x3b\x6d\xff\x1b\x74\x47\xbf\x52\x94\x59",
    .pub     = "\xf7\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xbf\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3f",
    .ok      = 1 },
  { .tc_id   = 219,
    .comment = "special case for B in multiplication by 2",
    .shared  = "\x15\xa0\x52\x14\x8a\xba\xad\x1b\x0f\x2e\x74\x81\xa3\x4e\xdb\x61\x40\x35\x89\x43\x9b\x5b\xd5\xe5\x64\x6c\xec\xeb\xe2\xa1\xbe\x2b",
    .prv     = "\x30\x35\x08\x3e\x98\x48\x37\x58\x7f\x6b\x73\x46\xaf\x87\x1b\xf3\xfc\x95\x81\xc5\x0e\xb5\x5c\x83\xae\xfa\xbe\xed\x68\xce\xe3\x49",
    .pub     = "\xf7\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x3f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40",
    .ok      = 1 },
  { .tc_id   = 220,
    .comment = "special case for B in multiplication by 2",
    .shared  = "\x1d\x04\x8c\xbe\x2f\x8d\xf0\x7c\x23\x3a\x8f\x93\x70\x6f\x30\x7d\x17\x13\x0c\x24\x97\xfb\x75\x2e\xea\xa3\x1f\xe3\xed\xfc\x72\x5a",
    .prv     = "\x30\x43\x5c\xe1\x87\xf2\x72\x3f\x9a\x3b\xde\xa0\xee\xf8\x92\x20\x7e\x15\x2e\x4c\xee\x89\x85\xfa\x72\xd2\xdb\x41\x47\xbd\x2a\x53",
    .pub     = "\xf7\xeb\xa0\x16\x8b\xe3\xd3\x62\x18\x23\x08\x9d\x81\x0f\x77\xcd\x0c\xae\x34\xcd\xa2\x44\xc5\xd9\x06\xc5\xd4\xb7\x9d\xf1\xe8\x58",
    .ok      = 1 },
  { .tc_id   = 221,
    .comment = "special case for B in multiplication by 2",
    .shared  = "\xcb\x92\xa9\x8b\x6a\xa9\x9a\xc9\xe3\xc5\x75\x0c\xea\x6f\x08\x46\xb0\x18\x1f\xaa\x59\x92\x84\x5b\x79\x89\x23\xd4\x19\xe8\x27\x56",
    .prv     = "\x58\x0f\x0a\x9b\xba\x72\x81\xa3\x0f\xb0\x33\x49\x0e\x0f\x42\x9f\x22\xe3\xf2\x67\x85\x2c\xae\xac\xef\xa3\xe5\x29\x1f\x0e\x61\x4e",
    .pub     = "\x61\x67\x7a\x5d\x93\x4c\xcb\xfa\xb8\xff\x5d\x8f\x08\x5a\x0b\x55\x3f\x94\x52\x7d\x9c\x49\xae\x14\x0f\x8e\xd1\x35\xe1\x44\x9b\x69",
    .ok      = 1 },
  { .tc_id   = 222,
    .comment = "special case for C in multiplication by 2",
    .shared  = "\xf1\xbd\x12\xd9\xd3\x2c\x6f\x4c\x5b\x2d\xcb\x3a\x5c\x52\xd9\xfd\x45\x4d\x52\xca\x70\x4c\x2c\x13\x79\x56\xec\x8a\xd9\xae\xf1\x07",
    .prv     = "\x70\x90\x98\xfe\xb2\xe2\x5c\x67\xb4\xbf\xd3\xbe\x0a\x01\xaf\x40\x9a\xdb\x6d\xa5\x2b\x3f\xbe\x3d\x97\x06\x42\xdd\x2c\x98\x38\x56",
    .pub     = "\xc8\x23\x9b\x71\x01\x36\xfe\x43\x1f\xb4\xd9\x84\x36\x15\x7e\x47\xc9\xe7\x8a\x10\xf0\x9f\xf9\x2e\x98\xba\xff\x15\x99\x26\x06\x1c",
    .ok      = 1 },
  { .tc_id   = 223,
    .comment = "special case for C in multiplication by 2",
    .shared  = "\xe6\xf1\xc4\x94\xc9\xe4\xbd\x23\x25\xc1\x71\x83\xe8\x2d\x31\xab\x0b\xbe\xe6\xc8\x47\xd4\xb0\xe4\xa9\x9c\x7c\x68\x91\x11\x7c\x3f",
    .prv     = "\x18\x5a\xc6\x2e\x72\x9f\x88\x52\x89\x50\x92\x6c\x0d\xe7\xc4\x81\xc9\x24\xbf\x9c\xf2\x6a\x12\x2f\x44\x3b\x86\x1e\x8b\x6a\xf6\x40",
    .pub     = "\xb7\xa2\xf7\x9e\x0d\xe9\xb5\x81\x47\x69\x1b\x55\x46\xd9\xec\x46\x3d\xa8\x32\x5e\x14\x40\xe5\x8b\xb2\x0a\xa1\x29\xd1\xb9\x73\x27",
    .ok      = 1 },
  { .tc_id   = 224,
    .comment = "special case for C in multiplication by 2",
    .shared  = "\xaa\x2a\x12\xed\xf7\x52\xd2\x79\xbd\xb0\x00\xfb\x14\x05\xa5\xdf\x8c\x5f\x1d\x41\x30\x9b\x4f\x2b\xd4\x1a\xed\x7a\xc1\xed\x01\x49",
    .prv     = "\xf0\x37\x43\xee\xad\x7c\x2f\x77\x19\x79\x43\x24\xf2\x71\x07\x28\x17\xd1\xa0\x4c\xbd\xa4\x2b\x23\x2f\x3b\xee\x43\xf3\x97\xcc\x40",
    .pub     = "\x2d\xc6\x24\xe1\x66\x3f\x42\xa7\xb9\x33\x63\x50\xf2\x77\x54\x1b\x50\xb8\xdd\xc7\xee\x0d\x86\x13\x3a\xd5\x32\x73\xae\xd4\xe6\x2e",
    .ok      = 1 },
  { .tc_id   = 225,
    .comment = "special case for C in multiplication by 2",
    .shared  = "\x74\xd5\x60\x6b\xa0\xb6\xad\x1d\x8b\xa3\x6a\xe6\xf2\x64\xd6\x31\x5f\x47\x9b\x39\x84\xde\x57\x3e\x9b\x00\x1e\x05\x55\x24\x7c\x32",
    .prv     = "\xa8\xfb\xb4\xf9\x0d\xa4\x57\x94\x98\x14\x05\xd5\x9e\xf3\x10\x62\x1e\x3c\x3b\x6b\x77\x60\xb5\xe3\x03\x08\xc7\x82\x2c\x88\xae\x5f",
    .pub     = "\x0e\x5e\xce\xee\x91\x04\xa6\x4f\x82\xc9\x09\x3b\x9b\xf7\xb4\x07\x6e\xe5\xbc\x70\x81\x5a\xf7\xee\x9f\x94\x2e\xf0\x15\x75\x61\x76",
    .ok      = 1 },
  { .tc_id   = 226,
    .comment = "special case for CB in multiplication by 2",
    .shared  = "\x8c\xf4\x53\x8a\xe5\xf4\x45\xcc\x6d\x27\x3d\xf4\xad\x30\x0a\x45\xd7\xbb\x2f\x6e\x37\x3a\x56\x24\x40\xf1\xb3\x77\x73\x90\x4e\x32",
    .prv     = "\xc8\x87\x88\x6f\xd0\x71\x07\xc7\x22\x1f\x6d\x9d\xd3\x6c\x30\x5e\xc7\x79\xce\xca\x13\x2a\xc9\x33\xff\x77\xda\xb2\xbe\xac\x63\x45",
    .pub     = "\x73\x7d\x45\x47\x7e\x2b\xeb\x77\xa6\xc3\x8b\x98\xe2\xa1\x9b\x05\xc3\x95\xdf\x7d\xa9\x98\xcb\x91\xf6\xdf\xab\x58\x19\x61\x4f\x27",
    .ok      = 1 },
  { .tc_id   = 227,
    .comment = "special case for CB in multiplication by 2",
    .shared  = "\xd5\x76\x67\x53\x21\x1d\x99\x68\xde\x4a\xc2\x55\x99\x98\xf2\x2e\xf4\x4e\x8a\xa8\x79\xf3\x32\x8c\xbc\x46\xaa\x85\x8d\xcb\x43\x3c",
    .prv     = "\x58\x09\x6e\xe2\x93\x61\x97\x8f\x63\x0a\xd1\xfb\x00\xc1\x26\x7c\x5a\x90\x1f\x99\xc5\x02\xf9\x56\x9b\x93\x3a\xd0\xdc\xce\x0f\x50",
    .pub     = "\x87\x3f\x8b\x26\x0e\xa9\xd9\xdd\xac\x08\xb7\xb0\x30\x72\x7b\xf0\x07\x23\x15\xab\x54\x07\x5e\xcc\x39\x3a\x37\xa9\x75\x88\x2b\x7e",
    .ok      = 1 },
  { .tc_id   = 228,
    .comment = "special case for CB in multiplication by 2",
    .shared  = "\x76\x1d\x8c\xec\xf1\x3f\x93\xb3\x79\xa7\x72\xe5\xfa\xc5\xb9\xff\xe9\x96\xca\xd9\xaf\x06\x15\x25\x80\xaf\xe8\x7f\xf9\x65\x1c\x71",
    .prv     = "\x08\x29\xa4\x90\x46\xdc\xe2\xc0\x7a\xb2\x84\x40\xdb\xad\x14\x64\x53\xe1\x28\x96\x0e\x85\xdd\x2e\x6a\x69\xa1\x51\x28\x73\xdd\x44",
    .pub     = "\x75\xe1\x58\x7c\x5e\xef\xc8\x37\x15\xd7\x10\x20\xaa\x6b\xe5\x34\x7b\xb9\xec\x9d\x91\xce\x5b\x28\xa9\xbb\xb7\x4c\x92\xef\x40\x7e",
    .ok      = 1 },
  { .tc_id   = 229,
    .comment = "special case for x_2 in multiplication by 3",
    .shared  = "\xf1\x2a\xcd\x36\xf6\x29\x9a\x4d\x19\x2c\x03\xaa\x4e\xfe\xea\x7d\xf5\x1e\x2d\x15\xd7\x63\x17\x2e\x68\xac\xcf\x7b\xc6\xf5\xc2\x30",
    .prv     = "\x58\x7a\xc3\x6b\x9a\x23\x59\x46\x32\x67\x9a\xde\xa1\xa8\x26\xf2\xf6\x2d\x79\x73\x82\x20\xfb\x48\x74\x64\x03\x9f\x36\xca\x23\x72",
    .pub     = "\xf8\x5a\x06\x06\x5e\xa2\x52\x72\x38\xfc\x5e\xc1\xb7\x5e\xad\x92\x62\xe6\xb1\xae\xd6\x1f\xef\xf8\x3b\x91\x23\x0a\xeb\x4b\x7d\x01",
    .ok      = 1 },
  { .tc_id   = 230,
    .comment = "special case for x_2 in multiplication by 3",
    .shared  = "\xb2\xbb\xbd\x17\x3f\x41\xd9\x52\xd3\x29\x25\x1d\xa9\x73\xa9\x50\x03\x00\x62\x81\x77\xad\x0f\xb7\x9d\x01\xe2\xe2\x63\x90\x5b\x38",
    .prv     = "\xa8\xa4\x42\xb7\xc0\xa9\x92\x27\xb4\xcb\x5c\x75\xfb\x9e\x5a\x72\xce\xa2\x5e\xba\x8a\x0b\xdf\x07\x27\x1b\xb4\xa9\x3c\x2b\x66\x65",
    .pub     = "\x6e\x0f\x1d\x00\xb1\x09\x9d\x2a\x71\xf7\xbe\x86\x65\x5f\xeb\x89\x88\xbb\xa5\x57\x7b\x02\xf9\x64\x04\x3a\x49\xf0\x0c\x74\x96\x13",
    .ok      = 1 },
  { .tc_id   = 231,
    .comment = "special case for x_2 in multiplication by 3",
    .shared  = "\x45\xec\xfa\x27\x5f\x1d\xaa\x25\xd3\xfa\xdf\x33\xcd\xf8\x9a\x15\x2a\xfe\xa2\x5e\xae\x37\xe6\x8e\x00\xb3\x0c\x36\x77\x89\x88\x7a",
    .prv     = "\xd8\xf7\x23\x3e\x96\x12\xc0\x0c\x9d\xca\x2c\x75\x1e\xc1\xd3\xf5\xf6\x7b\xad\x77\xc2\xe7\x14\xa2\x0e\x71\xeb\x3f\x22\x0a\x66\x71",
    .pub     = "\x69\x67\x57\xce\xd3\x09\x7f\xa9\x60\xc8\x39\x0a\x09\xe8\xbd\x6d\x39\x0d\xbd\xe8\xd1\xfa\x17\x02\x61\xf3\x42\x2e\xdc\x19\x29\x29",
    .ok      = 1 },
  { .tc_id   = 232,
    .comment = "special case for x_2 in multiplication by 3",
    .shared  = "\x59\x5e\x14\x4e\x07\xbb\xe6\x5b\x38\xe0\xe4\x16\x3d\x02\xad\x75\xa6\x5e\x42\x2e\x74\x06\x7d\xb3\x5c\x90\xdf\xa6\xe0\x55\xd4\x56",
    .prv     = "\xd8\x0c\x7c\x75\x57\xc9\x90\x7e\x1b\x11\xe8\x44\xbf\x13\x69\xcb\xa6\x69\xbc\x38\xe9\xb7\xb2\x53\xe5\x1f\x23\x9b\xda\x32\x23\x74",
    .pub     = "\xfd\x84\xb3\xf2\xfb\xfa\x16\xae\xbf\x40\xc2\x7f\x46\xe1\x8d\x77\xba\xfa\x0c\x79\x71\xbe\xdd\xe4\x90\x92\x12\xe7\x71\xbd\x3c\x35",
    .ok      = 1 },
  { .tc_id   = 233,
    .comment = "special case for x_2 in multiplication by 3",
    .shared  = "\x22\x6e\x16\xa2\x79\xac\x81\xe2\x68\x43\x7e\xb3\xe0\x9e\x07\x40\x63\x24\xcb\x72\xa9\xd4\xee\x58\xe4\xcf\x00\x91\x47\x49\x72\x01",
    .prv     = "\x80\x02\xa8\x51\x15\xad\x7b\x41\xc5\x0f\x84\xf3\x5f\xac\x75\x0e\xe8\xe1\x97\x34\x80\x71\x02\x83\x0f\xf6\xa3\x06\xbe\xed\x44\x64",
    .pub     = "\x80\x54\x85\x70\x3c\xcf\xc4\xa2\x21\xef\x28\x12\x67\xf5\x2b\x61\xce\xbc\x87\x9f\x0f\x13\xb1\xe5\xf5\x21\xc1\x73\x52\xa0\x78\x4f",
    .ok      = 1 },
  { .tc_id   = 234,
    .comment = "special case for x_2 in multiplication by 3",
    .shared  = "\x79\x0d\x09\xb1\x72\x6d\x21\x09\x57\xce\x8f\x65\x86\x9c\xa1\xec\x8f\xa0\xb2\xb0\x6b\x6b\xcf\x94\x83\xb3\xeb\x55\xe4\x9e\x92\x72",
    .prv     = "\x78\x2d\xb0\xc8\xe3\xe6\x8f\x10\x6f\xe0\xc5\x64\x15\xe0\xbd\x13\xd8\x12\xde\xa0\xe9\x4c\xbd\x18\xbd\xf6\x76\x12\x95\x61\x3a\x6d",
    .pub     = "\x80\x64\x2a\x32\x79\xda\x6b\xf5\xfc\x13\xdb\x14\xa5\x69\xc7\x08\x9d\xb0\x14\x22\x5c\xfc\xae\x7d\xff\x5a\x0d\x25\xec\xc9\x23\x5b",
    .ok      = 1 },
  { .tc_id   = 235,
    .comment = "special case for z_2 in multiplication by 3",
    .shared  = "\x68\x4c\xc8\x3a\xf8\x06\xbc\xd9\xcd\x25\x1e\x18\x58\xf3\xc1\x0f\x01\x66\xe0\xa0\xcd\x2b\xe1\x54\x33\x9a\x88\x6b\x13\xe7\xc7\x6f",
    .prv     = "\x90\x9f\xb0\xbd\xbf\x53\xa6\x9a\x2f\xe3\x9c\x8b\x24\x97\xab\xd4\xfa\x57\xd2\xd5\x4e\x04\x6b\x5f\x51\x45\x95\xe2\xc0\xf3\x3d\x63",
    .pub     = "\x84\xe8\x27\xf7\x8c\xae\x0c\xf0\x63\xe4\x34\x01\x98\xf7\x88\xc2\x84\xe0\x74\x30\xb3\xa9\x4a\x38\x73\xdf\x38\xb1\xf8\x72\xce\x02",
    .ok      = 1 },
  { .tc_id   = 236,
    .comment = "special case for z_2 in multiplication by 3",
    .shared  = "\xe4\x26\xe4\xa3\xc5\x4d\x3e\x77\xf4\xf1\x57\x30\x1e\x0a\xc7\xd9\xe1\x23\x37\xa2\xb5\x8d\xf1\x67\x80\x04\x1c\xf6\xd6\x19\x8c\x5a",
    .prv     = "\x78\xa6\x79\x09\x75\x72\x48\x66\x5f\x79\x37\x1e\xb0\x14\x82\x5a\xb6\xbd\x4a\xf3\x57\x1f\x14\x03\x89\xc6\x36\xe0\x04\xbc\xf4\x6b",
    .pub     = "\xd4\x45\xe1\xdf\x00\x83\xbb\x6b\x8e\x88\x6e\x66\x32\x25\x18\x07\x17\x1d\x4e\x88\xc4\x18\x16\xfc\x68\x43\x73\xc0\x9d\x7e\x5d\x6e",
    .ok      = 1 },
  { .tc_id   = 237,
    .comment = "special case for z_2 in multiplication by 3",
    .shared  = "\x86\x2d\xf9\x2e\x25\x27\x7b\xd9\x4f\x9a\xf2\xe1\xdd\xa5\x1f\x90\x5a\x6e\x2a\x3f\x60\x68\xa9\x2f\xab\xfc\x6c\x53\xda\x21\xec\x11",
    .prv     = "\x28\x6a\x30\x2d\x5b\x07\x6d\x2a\xba\x7c\x2a\x4d\xaf\x9e\x7c\xc9\xd8\x53\x9b\x7c\x03\x91\x30\x7d\xb6\x5a\x2f\x42\x20\xd3\x0f\x70",
    .pub     = "\xf2\x6a\xa6\x15\x1a\x4b\x22\x39\x01\x76\xf6\x23\x3e\x74\x2f\x40\xf2\xec\xd5\x13\x71\x66\xfb\x2e\x1e\xc9\xb2\xf2\x45\x4a\xc2\x77",
    .ok      = 1 },
  { .tc_id   = 238,
    .comment = "special case for DA - CB in multiplication by 3",
    .shared  = "\x3f\x43\x8d\xbf\x03\x94\x79\x95\xc9\x9f\xd4\xcb\x36\x6c\xa7\xe0\x0e\x8c\xfb\xce\x64\xc3\x03\x9c\x26\xd9\xfa\xd0\x0f\xa4\x9c\x70",
    .prv     = "\xa8\x38\xb7\x0d\x17\x16\x1c\xb3\x82\x22\xf7\xbc\x69\xa3\xc8\x57\x60\x32\xd5\x80\x27\x5b\x3b\x7d\x63\xfb\xa0\x89\x08\xcb\x48\x79",
    .pub     = "\x2b\x02\xdb\x3c\x82\x47\x7f\xe2\x1a\xa7\xa9\x4d\x85\xdf\x37\x9f\x57\x1c\x84\x49\xb4\x3c\xbd\x06\x05\xd0\xac\xc5\x3c\x47\x2f\x05",
    .ok      = 1 },
  { .tc_id   = 239,
    .comment = "special case for DA - CB in multiplication by 3",
    .shared  = "\x95\xf3\xf1\x84\x9b\x0a\x07\x01\x84\xe6\x07\x7c\x92\xae\x36\xba\x33\x24\xbf\x14\x41\x16\x8b\x89\xbb\x4b\x91\x67\xed\xd6\x73\x08",
    .prv     = "\xb0\x73\x3b\x42\x03\x26\x7a\xb3\xc9\x4c\x50\x6a\xca\xdb\x94\x9a\x76\xcc\x60\x04\x86\xfc\xd6\x01\x47\x8f\xcd\xef\x79\xc2\x9d\x6c",
    .pub     = "\xd7\x1d\xd7\xdb\x12\x23\x30\xc9\xbb\xaa\xb5\xda\x6c\xf1\xf6\xe1\xc2\x53\x45\xee\x6a\x66\xb1\x75\x12\xb1\x80\x4a\xce\x28\x73\x59",
    .ok      = 1 },
  { .tc_id   = 240,
    .comment = "special case for BB in multiplication by 3",
    .shared  = "\x6a\x96\x9a\xf6\xd2\x36\xab\xa0\x8f\xa8\x31\x60\xf6\x99\xe9\xed\x76\xfb\x63\x55\xf0\x66\x2f\x03\xdb\xc5\x91\x5a\x3c\x23\x06\x3e",
    .prv     = "\xd8\x44\xa3\x6b\x58\xae\xfd\xb0\x8b\x98\x17\x96\x02\x9a\x27\x66\x10\x18\x84\xb3\x48\xf7\x0e\xed\x94\x7c\x25\x41\x06\x4c\xaf\x6a",
    .pub     = "\x73\x7b\xc0\x7d\xe0\x72\x9b\xbc\xfb\xee\x3a\x08\xe6\x96\xf9\x7f\x37\x70\x57\x7e\x4b\x01\xec\x10\x8f\x59\xca\xf4\x64\x06\xd2\x05",
    .ok      = 1 },
  { .tc_id   = 241,
    .comment = "special case for BB in multiplication by 3",
    .shared  = "\xab\x39\xdb\x4a\xa2\x9a\xc4\x01\x7c\x74\x46\xf1\xad\x0c\x7d\xaa\x9a\x37\xf1\xb6\xb4\xf2\xe9\xd2\x90\x2c\xce\xfb\x84\x83\x9d\x28",
    .prv     = "\xa0\xb7\xd3\x12\xd9\xb8\x32\xe1\x24\xd1\xbc\x8c\xb2\x1d\xb5\x45\x44\x0e\x3c\xf1\x4e\x74\x73\xee\x9c\xcb\xe9\xb6\x82\xf2\x15\x6c",
    .pub     = "\x97\x58\x06\x1a\x7b\x3e\x2c\x02\xfb\x5c\x20\x87\x5a\xe6\xb5\x5b\x11\xfb\x67\x95\x99\x0a\x0f\x4f\xdc\xd1\x14\x7b\xe5\x52\x16\x07",
    .ok      = 1 },
  { .tc_id   = 242,
    .comment = "special case for BB in multiplication by 3",
    .shared  = "\x13\xde\x41\x65\x9e\x3e\x30\x8d\x6e\x26\xc9\x42\x82\xfc\xc3\xe0\x36\x4d\xdf\x08\x09\xdd\xee\x6c\x8e\x7a\xbb\x50\x91\xb0\x2b\x00",
    .prv     = "\x78\x7f\x1d\xdd\x78\xcc\x64\x73\xd3\xe6\x39\x49\x40\x9a\xd3\xf3\x5b\xfe\x0c\xe0\x73\x8f\x25\x5d\xee\x68\x2f\x2b\xfb\xc8\x0f\x7f",
    .pub     = "\x37\xcd\x65\xd3\x30\x36\x20\x5f\x34\x49\xe8\x65\x5a\x50\xd4\xb0\xc8\x6f\xec\x02\x10\x0b\x4f\x2d\xb7\xda\x92\xdc\xf5\xe3\xaa\x0a",
    .ok      = 1 },
  { .tc_id   = 243,
    .comment = "special case for BB in multiplication by 3",
    .shared  = "\x69\xed\x8a\x0a\x27\x81\x2a\xe6\x74\x14\x74\xbd\x5c\x6a\x4e\x68\x3a\x12\x66\x49\xf7\x24\x5a\xa0\xf9\x1a\x3a\x38\x4b\xcd\xe2\x5a",
    .prv     = "\x40\x80\xae\x60\xa8\x5c\x1f\xa9\x5a\xad\x9b\xea\xbd\x98\xb4\x05\xe7\xf2\x81\x41\xbf\x08\xf2\xc9\xa4\xfd\xbd\xe1\xc5\x68\x02\x65",
    .pub     = "\xa9\xb6\xe8\x08\x14\x60\x38\x3a\xdc\x58\x7c\x8f\x91\xa0\x2c\x59\xa7\xa3\x55\x76\xca\x62\x43\x6c\xcd\x1b\x5f\xef\x1b\x92\x54\x5d",
    .ok      = 1 },
  { .tc_id   = 244,
    .comment = "special case for E in multiplication by 3",
    .shared  = "\x01\x02\x18\xbd\x67\xb1\xb9\x2f\xee\x3e\x7f\xa4\x57\x8c\x13\x61\x7d\x73\x19\x5d\xe1\x02\x79\x74\x7e\x53\xba\x01\xa2\x54\x52\x5a",
    .prv     = "\x08\xf9\xf4\xa4\xfa\xc4\xdb\x41\x33\x15\xf7\x4a\x59\x81\x8b\x24\x52\xfc\x7b\x76\x85\x59\x2e\x26\x55\x67\x75\xf9\xb8\x6d\x90\x7f",
    .pub     = "\xfd\x1a\x2c\xd1\x7a\x93\xf8\x50\xde\xb8\xc4\x5a\x2d\x34\x53\x92\x32\xdf\xd8\xa5\x58\x30\x42\x09\x78\x1c\x6c\xb5\x82\x29\x87\x0e",
    .ok      = 1 },
  { .tc_id   = 245,
    .comment = "special case for E in multiplication by 3",
    .shared  = "\xe6\xb2\x98\xde\x9c\xb6\x35\x8f\xbb\xb0\x0f\x11\x89\x0f\x57\x14\xa3\x85\x8e\x8f\x05\xa2\xa8\xd1\xcf\x39\xfe\x78\xcc\x55\xdd\x4e",
    .prv     = "\x18\x88\xcf\xae\x30\x85\x86\x76\x57\xb0\x94\x35\xc4\x2b\x74\xcc\x76\x24\x57\x83\x94\x51\xa3\x65\x9d\xb2\x18\xd4\x21\x4f\xdd\x63",
    .pub     = "\xb8\x81\x19\xe5\xae\x6d\x9e\x6b\x91\x2d\x52\x52\x47\x39\xe6\x12\xef\x19\xab\x7e\x5d\xd3\xd9\x46\xcb\x9b\xc0\x03\xc3\x78\xf8\x1f",
    .ok      = 1 },
  { .tc_id   = 246,
    .comment = "special case for E in multiplication by 3",
    .shared  = "\x96\x7b\xbe\x29\x84\x94\xb4\xa5\xf9\x58\x53\xcf\xde\x9d\xc8\x59\x70\xb2\xa4\xb5\xdd\x2c\x92\x78\x29\x01\xe8\x53\x95\x7f\x58\x09",
    .prv     = "\x78\x9c\xe1\x3e\xd0\x07\x81\x8d\x7a\x51\x81\xe6\x29\xee\xd9\x44\xa2\x0a\x05\x8c\xfe\x39\x66\x9c\x98\x31\xbf\xa5\x21\x5a\x12\x69",
    .pub     = "\x7b\x70\xe2\x9d\xce\x04\x79\xcd\xe4\xa3\x6c\x7f\x97\x86\x58\x2f\x10\x4b\xc0\x78\x8f\x04\x6b\x48\xaf\x49\x5e\x67\xbd\xb8\x8f\x36",
    .ok      = 1 },
  { .tc_id   = 247,
    .comment = "special case for E in multiplication by 3",
    .shared  = "\x9f\x66\x84\x86\x81\xd5\x34\xe5\x2b\x65\x99\x46\xea\x2c\x92\xd2\xfa\xbe\xd4\x3f\xe6\xe6\x90\x32\xc1\x11\x53\xdb\x43\xdc\xa7\x5b",
    .prv     = "\x00\x02\x2b\x43\x77\x5a\xb2\xf4\xb9\x1b\xc1\xcb\x54\xc9\x7f\x78\x02\x62\x89\xea\xaf\x02\xab\xee\xd0\x4c\xa8\x4f\x73\x6c\x68\x6c",
    .pub     = "\x2a\x20\x9e\x2a\xce\x0e\x3d\x69\x73\xff\xbf\x74\x03\xf9\x85\x7f\xf9\x7a\x5f\xdc\xd2\x7f\x2c\x70\x98\xb4\x44\xfc\x3c\x16\x67\x38",
    .ok      = 1 },
  { .tc_id   = 248,
    .comment = "special case for E in multiplication by 3",
    .shared  = "\xea\x75\x72\xe2\x7a\x91\x20\xde\x1f\x13\xb8\x57\x10\xba\x69\xa3\x47\x1b\x7b\x3f\x5d\x12\xbc\x43\x0c\x12\xc4\xbb\xf8\xaa\x39\x57",
    .prv     = "\x80\x97\xa5\x2f\xc5\x62\xe8\xa5\x16\x68\x2f\x53\x63\xcc\x5e\x7c\x88\xe9\xc7\x8e\x30\x8d\xf0\xde\xef\x40\x49\x7b\x35\xcc\x12\x7d",
    .pub     = "\xf5\x07\x09\xac\xa7\xf3\x14\xe8\xd0\x5b\x5f\xf9\x7a\x42\x7e\x42\x7b\xd5\xe8\x5c\x4e\x86\x71\x21\x25\x07\x6a\x77\x1b\xe2\x14\x48",
    .ok      = 1 },
  { .tc_id   = 249,
    .comment = "special case for E in multiplication by 3",
    .shared  = "\xe2\x3d\x63\xa4\x6b\xe6\x7c\x74\x43\xc0\x7b\x93\x71\xff\x6a\x06\xaf\xcd\x7a\x57\x94\xbf\x25\x37\x92\x60\x74\xb8\x81\x90\x30\x7a",
    .prv     = "\x40\x28\x80\x20\x30\xd8\xa8\x22\x1a\x71\x60\xee\xbb\xf1\x84\x61\x16\xc1\xc2\x53\xab\xc4\x67\xd6\xe4\x3c\xb8\x50\xf1\x45\x98\x60",
    .pub     = "\x0f\x13\x95\x59\x78\xb9\x3d\x7b\x9f\x9a\x2e\x70\xd9\x6d\xf9\x22\x85\x0a\x8f\xfd\x84\x12\xe2\x36\xfb\x07\x4a\xef\x99\xd3\x7d\x54",
    .ok      = 1 },
  { .tc_id   = 250,
    .comment = "special case for E in multiplication by 3",
    .shared  = "\x33\xcc\xaf\x24\xe1\xe2\x62\x90\xed\x7e\x46\x20\x93\xe9\xf7\x76\x07\xef\x52\xa0\x62\x6b\x2c\xd2\x51\x1c\x41\xcd\x24\xc1\x38\x49",
    .prv     = "\xd8\x51\x5d\x45\xc7\xab\x2b\x95\x29\x81\x65\x43\x15\x00\x68\xb8\xe4\xbb\x61\x4c\xf2\xb6\x8a\x8a\x99\x36\x39\x75\xaf\x50\x3d\x74",
    .pub     = "\x18\xff\xe9\x92\xa7\x29\xce\x70\xc3\xb7\xcd\xc5\x5b\xab\x55\xf2\x21\x0d\x27\x91\x34\xb3\x08\x2a\x9f\x68\x2d\x3a\x0b\x13\x12\x73",
    .ok      = 1 },
  { .tc_id   = 251,
    .comment = "special case for AA in multiplication by 3",
    .shared  = "\x74\xf9\x5b\x47\x00\xf0\x18\x5f\x33\xc5\xb5\x52\x8e\xd5\x01\x2a\x33\x63\xf8\xbb\xd6\xf6\xa8\x40\xaa\x1f\x0f\x3b\xdb\x7c\x96\x50",
    .prv     = "\xd8\x81\x5b\xd1\x44\x51\x8f\xa5\x26\xbe\xfd\xd3\x73\xf5\xf9\xcf\xf2\x54\xd5\xd3\xc4\x66\x0e\x8a\x90\xef\x2a\x22\xc6\x87\x6a\x74",
    .pub     = "\xc3\xba\x28\x05\x77\x28\xd0\x53\x39\x65\xec\x34\x97\x9f\xe7\xbd\x93\xcf\x6c\xb6\x44\xe8\xda\x03\x8b\xaa\x87\x99\x7b\x8d\xc2\x0e",
    .ok      = 1 },
  { .tc_id   = 252,
    .comment = "special case for AA in multiplication by 3",
    .shared  = "\xe9\x67\x7b\x85\x48\x51\xc4\x1c\xc4\x89\xe0\x39\x81\xae\x78\x69\x0b\xe6\xcb\xf0\x05\x4e\xa9\x83\x47\x59\xde\x3e\x27\xbc\xf0\x3e",
    .prv     = "\xa8\x2d\x99\x60\x93\xee\xfd\xaf\x28\x3f\x40\x49\xbb\xa4\xf5\xaf\x6e\xcc\x2e\x64\x89\x4f\x32\x5e\xe1\xf9\xca\x1e\x15\x6d\x05\x67",
    .pub     = "\x4e\xb0\x95\xa8\x6d\x1e\x78\x1b\xb1\x82\x23\x30\x75\xeb\xf1\xdb\x10\x9d\x57\x13\x5b\xf9\x1d\x54\xfd\xb1\x8e\xb3\x71\x42\x76\x40",
    .ok      = 1 },
  { .tc_id   = 253,
    .comment = "special case for AA in multiplication by 3",
    .shared  = "\xf1\x48\x71\x6e\xbe\x72\x69\xa7\x07\x6f\x0c\xf1\xf2\x2b\x69\x78\xd3\xc7\xe3\x60\x7b\x0b\xcc\x87\xa8\xc7\xa8\x5b\x9f\xd2\x0c\x2f",
    .prv     = "\xc0\x26\x09\xdf\x3d\x54\x36\xc1\x23\xdc\xd7\xee\x11\xf2\x3f\x1d\xa3\x21\x66\x6c\x09\xf3\x79\xd3\x79\x14\x20\x33\x40\x51\x08\x61",
    .pub     = "\x83\xf6\x7d\x7c\x92\xb1\x1c\x8f\xb0\x72\x48\x46\x42\xa0\x1f\x43\xde\xb0\x22\xb5\x4d\x94\xa4\x01\x5e\x39\x84\x9a\x2e\x2e\x95\x55",
    .ok      = 1 },
  { .tc_id   = 254,
    .comment = "special case for AA in multiplication by 3",
    .shared  = "\x1d\x5c\x12\x3e\x88\xe9\xdc\x7a\x3b\x16\xec\x90\xb6\x05\x78\xdf\xca\x7e\x11\xea\xb9\xb8\x8c\x6e\xca\x7b\xc3\x3d\x91\xfd\xe8\x3b",
    .prv     = "\xa0\xe3\xb7\x8c\x0f\x3b\xe2\xa7\x60\xb2\xc9\x16\xf2\x44\xdf\x21\x96\x24\xfd\xda\x2e\x9e\x31\xb1\x53\x28\xf4\xa7\x76\x90\x29\x6a",
    .pub     = "\x20\xcc\x75\xd3\x76\xd8\x45\x3b\x9d\x04\x9c\x84\xf5\x8e\xaf\xcf\x61\x12\x6c\x08\xa0\x36\x61\xe7\x35\xf0\xa8\xbe\x22\x8f\xd4\x66",
    .ok      = 1 },
  { .tc_id   = 255,
    .comment = "special case for AA in multiplication by 3",
    .shared  = "\x2f\xc0\x65\xba\x8f\x50\x40\xa0\xa6\x59\xf6\xf7\x33\x05\x54\xbd\x1b\x9d\x7c\x89\x3b\x91\xe3\x16\xe0\xaf\x90\xc3\x7a\xf4\xf1\x35",
    .prv     = "\x70\x1f\x13\x0a\x29\x05\x84\xcb\x28\xc7\xd6\x53\x95\x06\xa1\xa0\x54\xf9\x26\xa1\x7e\xf7\xc5\x68\xae\x43\x04\x7c\x05\xe1\x0f\x60",
    .pub     = "\xef\x31\xb4\x3d\x19\xc0\xa5\x43\x4d\xeb\x56\x12\x9c\x16\x29\x8a\x39\x4a\x70\x32\xa2\xe5\x2c\xb9\x97\x47\x6b\xde\xca\x32\x5b\x73",
    .ok      = 1 },
  { .tc_id   = 256,
    .comment = "special case for AA in multiplication by 3",
    .shared  = "\xef\x76\x12\xc1\x56\x07\x8d\xae\x3a\x81\xe5\x0e\xf3\x39\x51\xca\xb6\x61\xfb\x07\x73\x1d\x8f\x41\x9b\xc0\x10\x5c\x4d\x6d\x60\x50",
    .prv     = "\xd0\xe6\x7f\x68\x18\x3a\x4c\x1a\xed\x9c\x56\x86\x4b\x36\x27\x8b\xb7\xbb\x75\xd5\x7a\x78\x32\x1b\xc7\xc2\x4f\xf6\x16\x36\x60\x7a",
    .pub     = "\xd8\xc8\xe2\xc6\xf3\x3a\x98\x52\x5d\xf3\x76\x7d\x1d\x04\x43\x0d\xab\x0b\xda\x41\xf1\xf9\x04\xc9\x5b\xc6\x1c\xc1\x22\xca\xca\x74",
    .ok      = 1 },
  { .tc_id   = 257,
    .comment = "special case for AA in multiplication by 3",
    .shared  = "\xa3\xcf\x3d\x81\xec\x56\x89\x6a\x68\xfc\xa0\xda\x63\x35\x17\x1d\x0c\x62\x25\x68\x73\x8c\x0d\xb2\x6f\xe1\x17\x03\x37\x26\xa0\x49",
    .prv     = "\x88\xeb\x77\x75\xda\xcc\x32\xb0\x45\xce\xb3\x5f\x26\x1b\x36\x16\x31\x5e\xfa\x98\xb7\x80\xe0\x8c\x79\xd5\x44\xed\xad\xb5\x46\x7d",
    .pub     = "\x18\x33\x61\x95\x16\xb8\x0d\xb0\xc0\x5b\x22\x55\x09\xe6\x69\x8d\xf0\x28\xd8\x3b\x66\xed\x6b\xac\x6f\x0f\x63\x08\x97\x0d\x2c\x7d",
    .ok      = 1 },
  { .tc_id   = 258,
    .comment = "special case for AA in multiplication by 3",
    .shared  = "\xe7\xf4\x58\x23\xa4\x5b\x6a\x46\x19\x2b\x37\xd7\x3e\x86\x09\xb5\xbd\xa6\x8c\xd7\xcf\xbd\xcc\xaa\x49\x08\x20\x80\x99\x3e\x64\x0f",
    .prv     = "\x70\x55\xb1\xc0\x57\x6e\x7a\xb6\xc8\x9f\xcc\x1c\xe4\x9e\x79\xc8\xc3\x71\xbf\x9f\xc2\xb2\x2b\x8f\x83\x96\xa9\xb6\x4c\x5a\xe2\x6d",
    .pub     = "\xe2\xe9\x89\xaa\xd2\x39\x7f\xc3\x4b\x6c\xbe\x2d\xb2\x7d\x5a\xb6\x9b\x28\x04\x83\x83\xc9\x1d\x9e\x82\x26\xd5\x48\x25\x3f\xab\x7e",
    .ok      = 1 },
  { .tc_id   = 259,
    .comment = "special case for D in multiplication by 4",
    .shared  = "\x7c\x61\x48\x13\x4c\x9e\x8b\x2b\xa5\xda\xec\xa4\x1e\x6a\x1f\x3a\x82\xd8\xf7\x5d\x0b\x29\x2b\x23\xc4\x0f\xe7\xf5\xce\x0a\x2b\x7a",
    .prv     = "\x90\x6a\x9b\xfc\xfd\x71\x01\x4d\x18\x96\x76\x80\xd4\x50\x9e\xaa\x41\xc6\x66\x42\x4a\xf9\x8b\xf9\xff\x7f\xf4\x9e\xb1\xba\xba\x41",
    .pub     = "\xb9\xbd\x79\x36\x24\xd6\xa7\xe8\x08\x48\x61\x10\x05\x88\x53\xed\xb2\x5e\x13\x6b\xd4\xd6\xa7\x95\xd6\xd2\xef\x53\xb2\x5e\x38\x04",
    .ok      = 1 },
  { .tc_id   = 260,
    .comment = "special case for D in multiplication by 4",
    .shared  = "\xea\x5e\x77\x2b\xac\x46\x93\xce\x69\xea\x3a\xc7\x61\x01\x1f\xa7\x67\x40\x37\x65\x3a\x43\x3c\x7f\x05\x45\x6e\x72\x91\xcd\x3c\x4e",
    .prv     = "\x28\x39\x2b\x1b\x03\x5a\x84\x65\xaa\x22\xaa\xbb\x57\x10\x61\xc6\xef\xfe\xed\x40\xcc\x25\x30\xb6\x28\xe4\xfd\x40\x39\x5a\xe0\x4a",
    .pub     = "\xe3\xf4\x44\xe2\x08\xda\x90\x43\xf3\xf7\x4c\x20\xe2\x8d\x7f\x40\x4b\xb6\x87\xa3\x46\x70\x9a\xbc\xd5\x55\x15\x6f\x88\x60\x78\x20",
    .ok      = 1 },
  { .tc_id   = 261,
    .comment = "special case for D in multiplication by 4",
    .shared  = "\x81\xc3\x95\xae\xd5\xcc\x5f\x5e\x2a\x20\x6a\x8a\x4c\xac\xec\xd5\x01\xdf\x5b\x81\xe4\x94\x33\x83\x5a\xd8\xa3\x77\x9e\xdf\xfb\x30",
    .prv     = "\x78\xcb\xb3\x52\x04\xcc\x88\x67\x6c\x14\xe0\xff\x18\x17\x13\x92\xe9\x98\x41\x1b\x23\xd9\x05\xd4\xc4\xdc\xea\xb7\x05\x11\xf4\x42",
    .pub     = "\x87\xb4\x3f\x90\xf7\x6d\x12\xfb\x3a\x46\x9f\xa8\x68\x7c\x27\xe3\x69\xd4\xa8\x2f\x95\xcf\x95\xe8\xdc\x39\x70\xde\x8f\x86\xd9\x2b",
    .ok      = 1 },
  { .tc_id   = 262,
    .comment = "special case for D in multiplication by 4",
    .shared  = "\x51\x3e\xba\x58\x70\xdc\x51\x87\xe2\x55\x2f\xe3\xba\x82\x92\xb5\x16\xd2\xaf\x9e\xcb\x9a\x9b\xdc\x51\xea\xc2\xce\x2d\xe4\x01\x12",
    .prv     = "\xa8\x22\x5b\x49\xef\x7b\x73\x30\xe3\xde\x78\x7c\xbc\x40\x47\x96\x44\xdb\x7a\xb1\x26\x37\x02\x95\xc9\x41\x89\x67\x34\x30\xd7\x45",
    .pub     = "\x86\x44\x1e\xa0\x6c\x5c\xd2\xa3\x4c\x6b\x51\x26\x1e\x93\xa2\xf3\x0e\xa7\xdb\x0f\x74\xe1\x4c\x42\xf0\xfc\x44\x3c\x67\x35\x97\x3c",
    .ok      = 1 },
  { .tc_id   = 263,
    .comment = "special case for D in multiplication by 4",
    .shared  = "\x98\x3b\x7e\x23\x6f\xfa\xdd\xb4\xb7\x59\xb7\x35\x3f\xe8\x78\x46\xf5\x9f\xb6\xf2\x8a\x3e\xd6\x5c\x25\x61\x76\xb6\x60\x9b\x7c\x6e",
    .prv     = "\x08\x41\xe1\xa5\xc7\x42\x0b\x94\xb6\xcc\x69\x91\x31\x6e\xbd\xd6\x08\x62\x63\x39\xc0\x9d\x0f\x67\xb2\x40\x88\x58\x8b\x9d\x0d\x49",
    .pub     = "\x46\x24\xaa\x4a\xe9\xd1\x27\x25\xbf\x92\xb8\x5f\x93\xe3\xe8\xce\xa1\x6b\x7b\xd8\x3f\xda\x0e\xb1\x8f\xab\x2d\xbe\x0e\x8b\xf7\x42",
    .ok      = 1 },
  { .tc_id   = 264,
    .comment = "special case for D in multiplication by 4",
    .shared  = "\xc9\x41\x36\x9b\x08\x5c\x74\x65\xd5\x0d\x23\xce\xaf\x67\x17\xab\x06\xe2\x46\x38\xf2\x17\xa7\xb8\x05\x5c\xe8\xeb\xd3\xca\x12\x25",
    .prv     = "\x08\xec\xf7\x6e\x31\xa2\x30\x39\xea\x8a\x15\xee\x47\x4b\x62\x51\xa9\xd7\x25\xbf\xf1\xa5\x75\x1e\xb5\xec\xde\x9d\x7d\x4e\x2f\x49",
    .pub     = "\xa6\x25\xa5\xb7\xa0\x4c\xea\x46\x2d\x12\x3b\x48\x5c\x39\xea\x44\xa8\x07\x9a\xa2\x23\xc5\x9e\x9c\xa9\x7a\xbc\xd3\x0b\x50\x0e\x4b",
    .ok      = 1 },
  { .tc_id   = 265,
    .comment = "special case for D in multiplication by 4",
    .shared  = "\xa3\xf7\xe1\x69\xdb\x44\xd0\xd1\x79\xc2\x42\xe6\x63\x47\x36\x4a\xb9\x27\x44\xdc\x6a\xd8\x0e\x47\x75\xae\xf7\xf4\xff\x9d\x5f\x34",
    .prv     = "\x60\x38\xfb\x0a\x83\x0d\x10\x01\xca\x8e\xa7\x4a\x61\x3e\xa9\x8f\x6a\xb8\x51\x26\x44\xe5\x5e\x8d\x45\xa2\x90\x71\xbd\x4b\xef\x45",
    .pub     = "\x8a\x5f\x20\x63\xf2\x59\xf3\x31\x7a\xe3\xe0\xb4\x59\xf8\x2c\x46\x77\x66\x6e\x49\xa2\xeb\x9b\xf0\x36\x9a\xee\x66\x36\x31\x26\x5b",
    .ok      = 1 },
  { .tc_id   = 266,
    .comment = "special case for D in multiplication by 4",
    .shared  = "\x40\x1a\xab\xfb\xb7\x3f\xe6\x69\x4c\x44\x6e\xcf\xff\xb4\x30\x06\x42\x7a\x9d\x47\x56\xe0\x49\xa1\xff\xc7\x95\x78\xd6\x2f\x16\x60",
    .prv     = "\xc0\x4c\xf1\x29\xf0\xb3\x33\x32\xe2\x65\x4f\x8e\x45\x22\x5c\x04\x2d\x7f\xa6\xcb\xc7\x93\xc8\x8b\xd4\xc7\x31\x98\x52\x89\xb0\x45",
    .pub     = "\x54\xcf\xb6\xad\x0d\x03\xe3\x11\x5a\xca\xfe\xe1\x26\x06\x39\x7f\x2b\xb4\x6a\x8c\x5f\x32\x6a\x25\x5c\x49\x41\x18\xae\xad\x3b\x62",
    .ok      = 1 },
  { .tc_id   = 267,
    .comment = "special case for E in multiplication by 4",
    .shared  = "\x20\x32\x2d\xd0\x24\xfb\x5a\x40\xf3\x27\xcf\x7c\x00\xda\x20\x37\x34\xc2\xa2\x79\xb9\x66\x6a\x9f\xf7\xd8\x52\x7c\x92\x7b\x67\x5e",
    .prv     = "\x38\x06\xb0\x36\xc9\x2d\x7b\xc0\x77\x19\x98\xd2\x4d\xbd\xa2\x94\x5b\x60\x1d\x42\x44\x9b\xd3\xec\x4b\xbf\x37\x57\xd0\x1b\x89\x4d",
    .pub     = "\x0e\xe3\xbe\xe8\xcb\x3a\x0a\xfc\xec\x22\xfa\x22\x33\x70\x6e\x8e\xc2\x9c\xcf\x1a\xf2\x12\xc0\xa6\x74\x74\x5e\xbb\xa3\x4f\x9d\x08",
    .ok      = 1 },
  { .tc_id   = 268,
    .comment = "special case for E in multiplication by 4",
    .shared  = "\x46\x15\x2d\x59\xc2\xd2\xf3\xec\xf0\x3c\xe6\x52\xd2\xb6\x97\x8d\x40\x1d\x5e\xde\x45\x70\xa6\xc9\x11\x77\x1b\xdc\xfb\x37\xcd\x41",
    .prv     = "\x38\x0d\x90\x56\xb5\xa2\xf4\xb3\xdf\xfb\x30\xe6\xce\xb7\x22\xac\x46\x84\x24\x5f\x1b\xef\xaf\xb5\x66\x1b\xc8\xc7\xa9\xad\x4c\x43",
    .pub     = "\x79\x7e\xc7\x51\x2a\xfb\xf0\xad\x91\x8d\x0e\x49\x47\x90\x3b\xe9\x52\x34\xf3\xab\xf3\x67\x50\xa8\xf8\x54\x88\x8d\x11\x7b\x77\x4e",
    .ok      = 1 },
  { .tc_id   = 269,
    .comment = "special case for E in multiplication by 4",
    .shared  = "\x37\x56\x7f\x7e\xc0\x44\x9c\x7b\x82\x3c\xf7\xb0\xe2\x19\xe9\xdd\x88\x0e\x56\xa1\x46\x4d\x04\x17\xa9\xe6\x7e\xff\x42\x33\x28\x66",
    .prv     = "\x38\x49\x29\xa4\x2c\x8d\x8d\xf1\x46\xdb\x95\x08\xe2\xf2\x1a\x4e\x8c\xd4\xd9\x9c\x1b\x13\x38\xdf\x17\xa4\x57\xe8\x8a\xfb\x00\x43",
    .pub     = "\xd5\x70\xc7\x81\x0f\x69\xe5\x02\xb3\x55\x25\x3a\xfa\x7c\x66\x7b\xfa\x50\x60\xd9\x0d\xc8\x6e\x35\x8a\xb4\x45\xf6\x38\x1e\x41\x5d",
    .ok      = 1 },
  { .tc_id   = 270,
    .comment = "special case for E in multiplication by 4",
    .shared  = "\xfb\xf6\x58\x7e\xc1\x81\x11\x6c\xf1\xac\xe7\xdc\xd5\x48\x02\x9d\x69\xc1\x30\xe5\x0f\xcf\x6a\xd5\xdf\xcd\x25\xc2\x3e\xe9\xf9\x39",
    .prv     = "\x48\xa9\x86\x82\x5b\x26\x80\xe2\xf2\x54\x7b\xa7\x5a\x95\x99\xb0\x4e\xd5\x7f\x8e\xd1\x8d\x98\xe7\x09\x9c\x54\x4e\xfb\xdf\x28\x4b",
    .pub     = "\x2c\x61\x1c\xb9\x44\x48\xf1\xc7\x82\x24\x25\xa4\xcf\x53\x56\x23\x6b\x90\xa5\x55\xb1\xed\x47\x47\x82\x0b\xa7\xf7\x39\xc8\xf5\x7d",
    .ok      = 1 },
  { .tc_id   = 271,
    .comment = "special case for B in multiplication by 4",
    .shared  = "\xc7\xc6\xf6\xd7\xce\x1e\x4f\x54\xc7\x27\xe5\x90\x06\x86\xc3\x4e\x6a\x69\x53\x25\x4b\xd4\x70\xbb\xbf\x0c\x7c\x18\xbb\xdd\xad\x73",
    .prv     = "\x98\x45\x2a\xd7\xdf\x4e\x26\xbc\x4b\x3d\x40\x3f\x9e\xbf\x72\xbb\x2d\x7b\x6b\x7d\x58\x60\xdb\xf6\xfb\x9a\x4f\x78\xdc\x02\x70\x4a",
    .pub     = "\xe5\x59\xc4\x17\xda\x7f\xd5\x85\x13\x52\xf5\x08\xb9\x00\x31\xd4\x9b\x5d\x2d\x0a\xac\x88\xa9\xc8\xb5\xfb\x6e\x80\x16\x5a\xc1\x0b",
    .ok      = 1 },
  { .tc_id   = 272,
    .comment = "special case for B in multiplication by 4",
    .shared  = "\xcf\x7d\x2a\x66\xea\x4d\xfe\xd9\x44\x69\xb2\xd3\x43\x53\x3f\xf3\x02\xa5\x76\xf8\x40\x2e\xd2\x18\x79\x04\x43\x70\x38\xe5\x46\x65",
    .prv     = "\xa8\xdb\xc9\xbe\x50\x34\xed\x7f\xe7\xf4\x69\x26\x4f\x21\x35\xe9\xc6\x7c\xd3\x0f\x52\x55\x70\xd2\xd8\x41\xe4\xbd\xea\xc5\x23\x49",
    .pub     = "\x74\x6d\x97\xe7\x77\x42\x92\xa3\xd7\x03\xf6\x04\xe7\x9d\x87\x64\xc9\x9a\x6a\x2f\xe2\x80\xea\xa9\x81\x11\x15\xf5\xe0\x38\xf2\x1a",
    .ok      = 1 },
  { .tc_id   = 273,
    .comment = "special case for B in multiplication by 4",
    .shared  = "\xb2\x04\xd3\xbb\xcb\xdc\x62\x4f\x9f\x1a\x74\x3f\xa3\xda\xa8\xf4\xc8\x78\x5e\xd0\x88\xd3\x7d\x08\xcd\x13\xc6\x01\x17\x0a\x46\x1b",
    .prv     = "\xf8\xd2\x68\x78\xdf\xf2\x5c\xed\x02\xd3\xb2\x7c\xe7\x40\x02\x69\x5b\xb8\x79\xb3\xc4\x32\x89\x30\x93\x43\x15\xec\xae\x84\x2b\x47",
    .pub     = "\x1f\x35\x4a\xa8\xff\xc4\xea\xe2\xb4\x0d\xad\x2e\xbf\x83\x0d\xb3\xfe\xb0\x7e\x2a\x1a\x2d\xa3\x9e\x55\xdf\x87\xc8\xc6\x13\xde\x1d",
    .ok      = 1 },
  { .tc_id   = 274,
    .comment = "special case for B in multiplication by 4",
    .shared  = "\xb9\xf2\x14\x65\x61\x5f\x39\xdd\xdc\xc3\x75\x20\xce\x9b\x95\x6f\x7d\xe9\x88\x3a\xc9\x3a\x87\x0d\x74\xe3\x88\xb8\xe1\x77\x54\x63",
    .prv     = "\xd0\xf5\xe9\xc4\x3c\x95\xb1\xff\xc3\x6f\x83\x2b\x94\x36\x01\xd5\xe1\x76\x47\xf7\xd7\x8e\x2e\x77\x10\xac\xe6\x3f\xf2\x74\xd4\x47",
    .pub     = "\x9c\x3f\x00\x23\xe1\xa4\x83\x25\x86\xaf\x24\x83\xbb\xec\x64\xce\x9f\x06\xf3\xea\x80\x6d\x40\x19\xa5\xe4\xab\xb1\xb5\x62\x70\x29",
    .ok      = 1 },
  { .tc_id   = 275,
    .comment = "special case for B in multiplication by 4",
    .shared  = "\x20\xf1\xfc\x61\x38\x74\x49\x5f\x20\x56\x2c\x10\xb7\xa8\xbe\x47\xbf\xc1\x2c\x16\x8d\x82\x9d\x63\x21\xaa\x2d\xe1\x70\x60\xe4\x0d",
    .prv     = "\x70\x06\x79\xe8\xc2\x4d\xf8\x28\xf2\xe5\x21\x2a\x32\x63\xd5\xe9\x3e\xa6\x16\x79\x98\x82\x98\xba\xb3\xb4\x80\xf4\x6f\x96\x1a\x48",
    .pub     = "\xd0\x56\x56\xaa\x01\x4d\x47\x60\x22\xdf\xc5\x5e\x8d\x3b\x48\x84\xed\x0b\xdf\x85\x20\x9b\xe8\xb5\x53\x51\x39\x4d\x52\xbe\x68\x4b",
    .ok      = 1 },
  { .tc_id   = 276,
    .comment = "special case for B in multiplication by 4",
    .shared  = "\x65\x2b\x18\xff\xd4\x1c\xfb\x7d\x1f\x0b\x6d\xc7\x9b\xaa\x3b\x2a\x39\x2e\xf1\x61\x7f\x5c\xf6\x25\x9b\x5b\x4f\xf0\x65\x91\x6a\x16",
    .prv     = "\xd0\xd0\x77\xc9\x46\x1f\x74\x7e\x56\x60\xbe\x85\xcc\x62\x04\x28\xb4\xce\xfe\x80\x5d\xe0\xfd\x25\x4a\xda\xa4\x65\xea\x5e\x78\x4f",
    .pub     = "\xc4\xa1\x9b\x86\x86\xe1\x8c\x29\x35\x9a\xa5\x48\x42\x7f\x06\xa3\x68\xd5\x5a\x87\x37\x48\x3d\x48\x93\x52\x3a\xda\xc6\x79\x5a\x4c",
    .ok      = 1 },
  { .tc_id   = 277,
    .comment = "special case for B in multiplication by 4",
    .shared  = "\x67\x98\x25\xc2\x59\x39\x2d\x86\xf8\xed\xb1\x53\x28\xd4\xfa\xf5\x23\x00\x77\x9d\x97\x9a\x50\x3a\x76\xe2\x7b\xe3\xd7\xa8\x5e\x03",
    .prv     = "\x00\x71\x1a\xc0\x8e\xf8\x8c\x3d\x43\xa3\xcb\xda\x67\xb6\xfe\x5f\x34\xf5\x47\x23\xdb\xe6\xd7\x25\xc8\xa3\x56\x90\x70\xab\x9a\x4e",
    .pub     = "\x49\x89\xde\x79\x85\x3f\xf3\x5b\xe8\xc9\xf9\x2f\xc9\x46\x74\xfe\xef\x38\xa0\xe6\x57\x88\x47\x1c\x52\x1f\x8e\x25\x9a\xdf\x01\x5d",
    .ok      = 1 },
  { .tc_id   = 278,
    .comment = "special case for B in multiplication by 4",
    .shared  = "\x9c\xad\xc1\x4a\xc1\x53\xfa\x38\x3e\xf6\x6d\x18\x33\xf5\x89\x10\x0d\xff\x90\x52\x32\x72\xe3\x2b\x06\xe2\xc6\xf1\xf4\x42\x40\x40",
    .prv     = "\x98\x9a\x75\xb4\x04\x51\x13\x9e\xc3\x6c\xa6\xaa\x04\x37\x65\xc6\x1a\x18\xbe\x32\x3a\x59\x87\xfc\xb0\x25\xc2\xda\xd8\xd4\xbd\x40",
    .pub     = "\xa9\x81\x48\x3c\xb0\xea\x43\x85\xff\xbb\x55\x28\x26\xc3\xdd\x11\x0d\x4a\xe8\x9f\xf5\x2e\xd0\xcd\x60\x18\xf9\x9d\x33\x87\x98\x7b",
    .ok      = 1 },
  { .tc_id   = 279,
    .comment = "special case for BB in multiplication by 4",
    .shared  = "\xbc\xc9\x5f\xb4\x89\x0e\xd3\x11\xf3\xfb\x4f\x44\xc2\xb6\x08\x66\xcd\xdd\xec\x97\xdb\x82\x0a\x7f\x79\xf4\x75\x33\x7e\x16\x28\x4a",
    .prv     = "\x90\xc3\xcf\xed\xd9\x19\xa2\xcc\xd5\x1f\xb4\x55\x64\x9e\x3a\xd2\xda\x1e\xf0\xff\x61\x9b\x59\xa7\xf9\xc5\x5a\x68\xa8\x21\x96\x45",
    .pub     = "\x1d\xf3\xdf\xda\xb7\x4f\xf3\x81\x77\xda\xc2\x94\xb2\xda\x2f\x49\xa3\x48\xbc\x3b\x3b\xc6\xce\x93\x12\xbe\xa5\xef\x3e\xcd\xd3\x0b",
    .ok      = 1 },
  { .tc_id   = 280,
    .comment = "special case for BB in multiplication by 4",
    .shared  = "\x06\xf1\xb4\x95\xb0\x4a\x00\x10\x84\x5c\x9d\x39\xb1\x3b\xf2\x78\x4a\xde\x86\x0d\x96\x32\xc8\x84\x76\x18\xc0\xb3\x42\x97\xc2\x49",
    .prv     = "\xe8\xfe\xf5\xc9\xb6\x0f\x84\x98\x4e\x88\x36\xd5\x35\xac\xb3\x72\x09\x6b\xa8\x15\x98\x24\xa0\xb4\x9a\x17\xec\xcd\xa8\x43\xbd\x41",
    .pub     = "\xfc\x6b\x71\x8b\xa8\xb4\x7d\x24\xb1\xcf\xd6\xb5\xd0\xdd\x8b\x20\xfd\x92\x09\x60\xfa\xbc\x30\x2d\xbe\x4f\x93\xbd\x2a\x06\xe9\x33",
    .ok      = 1 },
  { .tc_id   = 281,
    .comment = "special case for BB in multiplication by 4",
    .shared  = "\xcc\xe7\xbb\x64\x4d\xf9\x45\x01\x42\x1d\xb4\x9d\x15\xe8\x21\xc7\xb0\xaa\xab\xec\xdf\x88\x37\xab\x98\x9b\x1f\x23\xba\xc0\x8f\x35",
    .prv     = "\xc0\xe0\x5b\xde\x77\x27\xdb\x4e\x35\x2b\x5e\x7f\x03\x53\x27\xb4\xd8\x6a\x42\xd5\x13\xca\x11\x6e\x22\xd6\x4a\x4e\xde\x56\x43\x4a",
    .pub     = "\xb2\x79\xb6\xc0\x65\xf9\x5c\x70\x40\xf1\x48\xbc\xb4\xa3\xd3\x10\xe3\x4b\xdb\x00\x59\x31\xa8\x79\xbe\x46\x95\x73\xde\xed\xd0\x41",
    .ok      = 1 },
  { .tc_id   = 282,
    .comment = "special case for BB in multiplication by 4",
    .shared  = "\x71\xfd\xd3\x40\x5c\x30\x80\x57\x01\xae\x4d\xfa\xd9\x8c\x49\x3a\xec\xfc\xf2\xe3\xb5\x63\xe7\x06\x83\x73\xc1\xb1\x91\x37\xc2\x68",
    .prv     = "\xd8\x73\x08\xbf\x75\x35\x73\xf5\x96\xac\x83\x30\xb2\x04\x01\x4b\x21\x52\xdb\xdf\xc9\x88\x1a\x0d\x99\x75\x05\x85\x82\xbd\xf6\x46",
    .pub     = "\x98\xe2\xcd\x4c\x10\x55\x4e\x41\xb0\xa3\xe4\x10\x82\xc8\xb6\xb6\x1b\x55\x44\x7d\x26\xc0\xaa\x97\xf9\xa0\x6b\xae\xeb\x54\xb5\x5b",
    .ok      = 1 },
  { .tc_id   = 283,
    .comment = "special case for BB in multiplication by 4",
    .shared  = "\xbf\x28\x0a\xee\xcb\x74\xab\x34\xe1\x31\x0a\xa6\xfe\x8d\xc9\x72\xf9\x4d\xc4\x0c\x7f\x88\xb7\x21\x37\xcc\xfe\x34\xed\x34\x3c\x13",
    .prv     = "\xd8\x00\x59\xa8\xa3\x87\xe1\x6f\x6d\xed\x6e\x7e\x98\x0e\x80\x6d\x1f\x78\xb4\x70\xbb\x61\x10\x3d\x0c\xa7\x06\x23\xcc\xee\x8b\x4f",
    .pub     = "\x87\x28\x97\xf1\xbd\x18\x85\xda\x08\xb9\xd0\x3e\x46\x81\x10\x44\xfb\xb0\x41\x86\xba\x30\xc8\x06\xf3\x8b\x94\xeb\xdc\x27\x18\x6a",
    .ok      = 1 },
  { .tc_id   = 284,
    .comment = "special case for x_2 in multiplication by 4",
    .shared  = "\x72\x56\x6a\x91\xcc\xd2\xbc\xf3\x8c\xf6\x39\xe4\xa5\xfc\xb2\x96\xf0\xb6\x7d\xe1\x92\xc6\x09\x12\x42\xa6\x2f\xae\x46\x7f\xb6\x35",
    .prv     = "\xb0\xa4\xfe\x63\x51\x51\x69\xbd\x82\x63\x9b\x51\x5f\xf7\xe5\xc4\xac\x85\xbb\xa0\xa5\x3b\xba\xca\x80\x47\x7e\xb3\xb4\x25\x0d\x44",
    .pub     = "\xc0\x8f\x72\x76\x0d\x9c\xb4\xa5\x42\xaa\xd6\xe2\xaf\x77\x79\x20\xc4\x45\x63\xbd\x90\x35\x61\x68\xc3\x60\x8c\x6b\x9a\xf2\xef\x0f",
    .ok      = 1 },
  { .tc_id   = 285,
    .comment = "special case for x_2 in multiplication by 4",
    .shared  = "\x24\xac\xb4\xaf\xa6\x39\x19\x62\x1d\xf7\x95\x20\x6c\x39\x29\xb5\x99\xec\x9d\x25\x36\x93\x89\x5d\x51\xa0\x55\x50\x72\xe8\x9a\x34",
    .prv     = "\x98\x42\x56\xb1\x2e\xf1\x54\xff\x6c\x2e\x1d\x03\x08\x26\x16\x4c\xba\x36\x14\xe3\xdf\x76\x88\xd8\x2b\x59\xe1\x62\x01\xc9\x11\x4d",
    .pub     = "\x4f\x03\x84\x9c\x24\xd5\x84\x53\x4d\x74\x30\x22\x20\xcf\xdc\x90\xe1\xbc\x36\x0b\xb5\xe2\x97\xc0\xfd\x0f\xd5\xf8\xd7\x99\xe4\x16",
    .ok      = 1 },
  { .tc_id   = 286,
    .comment = "special case for x_2 in multiplication by 4",
    .shared  = "\x5b\xa2\x11\x2a\x41\xb5\xbb\x38\x1f\x20\x24\x46\xfa\x9f\x23\xc5\x4d\x2d\xe1\x49\xf9\xad\x23\x37\x53\x41\x72\x63\x84\x0e\xa4\x32",
    .prv     = "\x68\x47\x14\x1d\x5d\x43\x77\xaf\x96\xa2\xa6\x47\xc6\x42\xee\x81\x60\x0f\xe4\x8d\x34\x67\xe3\xa7\x0f\x3e\xe3\x12\xbb\x62\x17\x42",
    .pub     = "\x49\x59\x77\x1a\x93\x1e\x24\x2d\x57\x13\xd5\xcb\x76\xf3\x33\x10\xc6\xa2\x83\xdf\x16\x64\x56\x04\x28\x95\x53\x80\x9c\xda\x65\x18",
    .ok      = 1 },
  { .tc_id   = 287,
    .comment = "special case for x_2 in multiplication by 4",
    .shared  = "\xa8\x7c\x9f\xdf\x40\xc4\x09\xb9\xed\xab\x48\x1b\x2c\xc6\x96\x87\xee\x1a\xb9\x2e\x34\x0c\x3d\xb0\x10\x7d\x40\xb5\xde\x6e\x7a\x20",
    .prv     = "\xe8\x5f\x11\x64\xe2\xab\x6f\xaf\x62\x66\x7c\x74\xb0\x3c\xe5\x29\xb4\x9a\x0e\x20\x41\xb1\xac\x0f\xa2\x42\xe5\x22\xd2\xb7\x69\x4c",
    .pub     = "\xf6\xfe\x69\x0c\xf5\x47\x04\x96\x35\xbb\x3a\x77\x85\x53\x7b\x43\x79\xc9\xee\x06\xb4\x61\x20\x49\x3b\x8b\xdb\x15\x2e\x09\xc8\x1d",
    .ok      = 1 },
  { .tc_id   = 288,
    .comment = "special case for x_2 in multiplication by 4",
    .shared  = "\x3b\xe9\x87\x98\xf0\x1e\x71\x63\x9f\x3c\xb8\xfd\x4a\x17\xbf\x27\x3e\x10\xc6\x7f\x89\x74\xdd\x98\x02\xee\xd5\x9d\x84\x7d\x40\x20",
    .prv     = "\x28\x1e\x1b\xbf\xa7\x11\xde\x69\x92\x1a\x64\xc5\xd2\x18\x3c\x33\x8d\xb5\x50\x46\x06\xce\x2b\x6b\x4c\xe1\xcd\xd5\x4b\x41\xe1\x4a",
    .pub     = "\xb4\x68\x68\x1a\x12\x75\x85\x0c\x11\xd3\x7e\xc7\x36\xaf\x93\x9a\x75\xa7\x09\x85\x14\xe0\x4c\xfc\x1c\x6c\xa7\x82\x39\xa8\x84\x26",
    .ok      = 1 },
  { .tc_id   = 289,
    .comment = "special case for x_2 in multiplication by 4",
    .shared  = "\x33\x8c\x99\x17\xdb\xf1\x1a\x0c\xab\xe8\xad\x4a\x65\x95\x92\x29\xbc\x00\xf9\x9c\x21\x1e\x75\x2b\x20\xb8\xb4\x9b\x87\x75\x6d\x0b",
    .prv     = "\x20\xaa\xcf\x19\x02\xb3\xcd\x60\x9d\x7e\xe1\x5c\xc9\x64\x53\xcc\x22\xe2\x89\x9d\x7d\x17\x85\x26\x80\xf2\xa7\x28\xba\xc6\xdc\x4a",
    .pub     = "\x2d\x71\xe8\x45\x70\x99\xe3\xf4\x45\xf9\xe2\xa1\x4f\x18\xb0\xf5\x91\x4b\xb3\x5f\x48\x2f\x9c\x06\x9b\x64\xbf\x63\x71\x0d\x42\x28",
    .ok      = 1 },
  { .tc_id   = 290,
    .comment = "special case for x_2 in multiplication by 4",
    .shared  = "\x56\xe2\xbf\xc7\xf6\xab\x7d\xa8\xfc\x73\x4a\xfc\x51\x5e\x57\xd0\x79\x4d\x00\x24\x34\xf9\xbc\x8e\x18\xbd\x0b\x72\xc0\xdf\x3c\x4a",
    .prv     = "\x00\x9e\x8e\x9f\xa9\x93\x80\x4d\xce\x94\xce\xcb\x96\xb1\xde\x25\x68\x24\x5a\x97\x05\x9e\x4d\x7a\xe1\x16\xec\xdb\x1b\xad\xd1\x41",
    .pub     = "\xfa\x8f\x24\xe9\x44\xde\x5d\x00\x37\x46\xd4\x63\x03\x50\xc0\xf4\xf6\x17\x5a\x32\x69\xc1\x91\x84\x82\x41\x05\x39\x8f\xbd\xd3\x29",
    .ok      = 1 },
  { .tc_id   = 291,
    .comment = "special case for x_2 in multiplication by 4",
    .shared  = "\x17\xfa\x12\x76\xd9\xfd\x50\x25\x17\x27\x36\x44\x9a\x1c\x0a\xe3\x35\x12\xe5\x03\x70\x14\xa1\x8d\xb5\x90\x3e\x47\xbb\x3b\xc9\x50",
    .prv     = "\xf0\x15\x74\x64\x3f\x23\x1f\xfa\xc0\x55\xbd\x23\x5e\xe7\x4d\xd4\x16\xb9\x4c\x8e\x55\xa2\xab\x2b\x4d\x13\xa8\xb7\x88\xd9\x01\x48",
    .pub     = "\xae\x4e\x37\xef\x53\xc7\x9e\x25\xe8\x27\x5a\x60\xf2\xfc\x1d\xfc\x27\x7e\xbc\x5d\x3b\x88\x42\x8c\x64\x32\xc3\xf9\x84\x94\x21\x2c",
    .ok      = 1 },
  { .tc_id   = 292,
    .comment = "special case for x_2 in multiplication by 4",
    .shared  = "\x16\x7a\x3b\x2f\xdc\xe9\x41\x3c\x89\xee\x89\x2d\xaf\x9f\x83\x9a\x2e\xea\x80\xea\x80\x44\x92\x40\x35\xdb\x17\x24\xa5\xb0\x21\x7c",
    .prv     = "\x38\x00\xa4\x26\x59\x95\x42\x81\xca\x26\x6d\x7c\xf1\xea\x9d\xb6\xd7\x98\x91\xa4\x06\xa7\x0f\x9e\x84\xc3\x57\x0a\x6a\x12\xd2\x4e",
    .pub     = "\x95\xe5\x6a\x83\x07\x92\x47\x8f\x7c\x42\x50\x40\x43\xa9\xca\xb8\xe2\xee\xbf\xf5\xfd\x90\x98\x37\x09\xe2\x9e\x03\xc0\xa4\x1b\x64",
    .ok      = 1 },
  { .tc_id   = 293,
    .comment = "special case for x_2 in multiplication by 4",
    .shared  = "\x30\xa4\xba\x79\x3f\x2d\xff\xe1\x70\x0c\x61\x42\x8b\x4d\x84\xb5\xfc\xd0\xaa\x99\xa2\x3b\x90\x3f\x84\xa4\x8e\xca\x5c\xc9\xfb\x0a",
    .prv     = "\x70\xa8\x26\xb1\x86\x96\x22\x18\xdb\xaf\xca\x11\x33\x19\xda\xef\xb5\xdd\xf3\xcf\x14\xe1\x5f\xe3\xfa\xad\xc4\xc0\xa2\xe4\x66\x48",
    .pub     = "\x5f\x16\xaa\x7c\xca\xbf\x4d\xa6\xb6\x86\xbd\x28\xc7\x46\x0e\x10\x6b\xb1\xb9\x7a\x82\x37\x92\x52\x77\x65\xc2\x9a\x9a\xd8\xfc\x71",
    .ok      = 1 },
  { .tc_id   = 294,
    .comment = "special case for DA + CB in multiplication by 4",
    .shared  = "\x2b\xf9\xab\x75\x0b\xd5\x8f\xf6\xf8\x77\xb7\x83\xed\xa4\x5a\x71\xa6\x5c\xc9\xb7\xc0\x37\xfc\xfe\xf4\xcb\x5f\x4c\x88\x42\xf5\x29",
    .prv     = "\xa8\x5a\x5e\xda\x0a\x26\x95\x00\xb3\xab\x0b\x58\x49\x5f\xc2\x54\xc2\x69\x10\x28\xac\x53\x34\x94\xb5\xf8\x6d\x44\xe9\xdc\x65\x4c",
    .pub     = "\x47\xfb\x78\x11\x18\x05\xa1\x19\x82\xa3\xd6\xc5\xd8\x3e\x8e\x18\x9e\x7f\xcc\x46\x2c\x9a\xbf\x80\x5d\x36\x25\xbe\x7a\x6e\xac\x11",
    .ok      = 1 },
  { .tc_id   = 295,
    .comment = "special case for DA + CB in multiplication by 4",
    .shared  = "\x35\xe9\x28\x92\x34\xbd\x5e\x53\x1d\xa6\x5d\x16\x1a\x06\x5a\x14\xf7\x85\x07\x60\x88\xd7\x41\xc9\xa2\xd8\x86\xef\xd7\xd1\x79\x21",
    .prv     = "\x18\x3f\x28\xec\x86\x76\x24\xef\x5e\xca\x48\x27\xed\x07\x14\xa5\x52\x5e\xf2\x1d\x5e\x35\x03\x8b\x24\xd3\x07\xa3\x39\x1a\x28\x46",
    .pub     = "\x03\xb8\xca\x5e\xfd\x17\x77\xd6\xd6\x25\xa9\x45\xdb\x52\xb8\x1f\x11\x21\x4d\xaf\x01\x5d\x09\xfd\xc9\xdf\x7d\x47\xb9\x85\x0e\x31",
    .ok      = 1 },
  { .tc_id   = 296,
    .comment = "special case for DA + CB in multiplication by 4",
    .shared  = "\x83\x3a\xfb\x86\x70\x54\xb8\xb9\xac\x70\xd6\x01\x3c\x16\x3e\x8b\x76\x76\xfd\x45\xae\x49\xa1\x32\x5f\x3a\xcb\x75\x97\x5d\x8c\x13",
    .prv     = "\x88\x8c\x64\x44\xff\x5e\xb4\x82\xb2\xb1\x0b\xd4\xe8\xa0\x1b\xdc\xcb\x65\xf3\x29\x34\xd8\x02\x61\x06\xf1\x6a\x91\x34\x9f\x48\x4c",
    .pub     = "\x4e\xca\x5f\x87\x31\xb0\xfa\x0c\x10\x6a\xcf\x57\x8b\x83\xa3\x50\xfa\x81\x73\xa2\x90\xf1\xeb\xa8\x03\x95\x6d\xe3\x4e\xeb\x76\x71",
    .ok      = 1 },
  { .tc_id   = 297,
    .comment = "special case for A in multiplication by 4",
    .shared  = "\x8a\x91\x47\x60\x12\x95\x75\xc8\xab\x32\x70\xd0\x4b\x04\x65\xfc\x2f\x32\x7a\xca\xf1\x67\x64\x63\x11\x38\x03\xbb\xb2\xec\x80\x21",
    .prv     = "\xc8\xa8\x5d\x14\x0b\xa1\x50\xf5\xc6\xa8\xd3\xcb\x36\x3b\xcb\xcb\x75\x36\x5e\x51\xc6\x16\x40\xe9\x74\xa0\x72\x5b\x5e\x9d\x59\x40",
    .pub     = "\xa5\x56\x2b\x4b\xa8\x6b\x46\x4d\xff\x4c\x2c\xfa\xe8\x5b\x38\x4b\xe2\x11\x77\x1e\xfe\x8a\x96\x97\xe5\x1d\x84\xde\x47\xf1\xeb\x14",
    .ok      = 1 },
  { .tc_id   = 298,
    .comment = "special case for A in multiplication by 4",
    .shared  = "\xc1\x98\x8b\x6e\x1f\x02\x01\x51\xec\x91\x3b\x4f\xb2\x69\x5b\xae\x2c\x21\xcc\x55\x3d\x0f\x91\xcf\x0c\x66\x86\x23\xa3\xe5\xa4\x3d",
    .prv     = "\x90\xa3\xae\xb1\x41\x7c\x3d\x61\xc1\xef\xef\x1a\xc0\x52\x21\x8f\xb5\x5d\x3a\x59\xc4\xfe\x93\x0b\x5a\x33\xcc\x51\x83\xb4\x85\x47",
    .pub     = "\x88\xae\x16\x31\xcd\x08\xab\x54\xc2\x4a\x31\xe1\xfe\xc8\x60\x39\x1f\xe2\x9b\xc5\x0d\xb2\x3e\xb6\x67\x09\x36\x2e\xc4\x26\x49\x29",
    .ok      = 1 },
  { .tc_id   = 299,
    .comment = "special case for A in multiplication by 4",
    .shared  = "\xbb\x24\x81\x7b\xd9\xff\xf4\x23\xdc\x09\x72\x90\x8e\x2c\x03\xfd\xdf\x4d\xbe\x10\x00\x16\xb4\x59\xf2\x8f\xe9\x59\x4a\xdb\x37\x14",
    .prv     = "\xb8\x58\xd7\x41\x4b\xd9\xab\x9a\x3e\xbe\xa7\x90\x64\xab\x87\xbc\x05\x0e\x74\x40\x7f\x4d\x47\x48\xf6\x2f\xa4\xd9\xd2\x03\xb6\x40",
    .pub     = "\xcb\xc4\xd5\x5d\x5b\xfd\xdd\x0b\xc5\xc5\xed\xbe\x3a\x04\x83\x6b\x2c\x70\x1d\x25\x19\x5b\x26\x22\x1c\xbe\xa1\x93\x11\xe5\x5a\x3d",
    .ok      = 1 },
  { .tc_id   = 300,
    .comment = "special case for A in multiplication by 4",
    .shared  = "\xb3\xb4\x51\x3f\x8a\x31\x02\xe1\xae\x78\x2f\xbc\x69\x88\x81\x77\xf2\xc2\x4c\x56\x93\x03\xa5\xd0\x1a\xb1\xc3\xc5\xe2\x85\x52\x4a",
    .prv     = "\xf8\x25\xed\xf1\xf7\x9e\xdd\xd7\x15\xa7\x2b\x3a\xc2\x67\xd6\xb2\xe9\x7e\x18\xbb\x13\xbc\xaf\xda\xc5\x94\x03\x70\xb8\x5b\xa6\x4b",
    .pub     = "\xd6\x6a\x2f\x9f\x75\x77\xe2\xdf\x4a\x56\xcb\x51\x96\x2b\x30\x56\xff\x5c\xc0\x49\x4c\x60\xf3\x95\x11\x78\x2e\x79\x92\x3e\xdd\x41",
    .ok      = 1 },
  { .tc_id   = 301,
    .comment = "special case for DA - CB in multiplication by 4",
    .shared  = "\x47\x1b\xa9\x1a\x99\x63\x4f\x9a\xcf\x34\xfd\x7f\xd5\x8f\x72\x68\x2b\xe9\x7e\xe1\xc8\x21\x48\x6d\x62\xba\x4e\x44\x8c\xbc\x04\x17",
    .prv     = "\xb0\xa7\x10\xb4\x70\xe3\x24\xbb\x56\xa7\xd8\xff\x87\x88\xd0\x5e\xb3\x27\x61\x61\x29\xb8\x49\x72\x48\x24\x25\xea\x4a\xd4\xf3\x4b",
    .pub     = "\xde\x0f\xed\x2f\xab\x6e\x01\x49\x26\x75\xbc\x75\xcb\xe4\x5d\x7b\x45\xb0\x30\x6c\xec\x8d\xc6\x76\x11\x69\x98\x11\xc9\xaa\xef\x16",
    .ok      = 1 },
  { .tc_id   = 302,
    .comment = "special case for DA - CB in multiplication by 4",
    .shared  = "\xcd\xb3\xca\x02\xd5\xfd\xb5\x36\xdb\xc7\x39\x5b\xab\x12\xbd\xcf\xd5\x5b\x1a\xe7\x71\xa4\x17\x6d\xed\xb5\x5e\xb4\xd7\x55\xc7\x52",
    .prv     = "\xb8\x98\xf0\x32\x97\x94\x74\x7d\x33\x26\x9a\x39\x89\xb6\x7e\x43\xa7\xab\x5a\x55\xfa\x12\x10\xb0\xe5\xdb\xa1\x93\xf4\xfa\x09\x4e",
    .pub     = "\x64\x18\xd4\x9f\xe4\x40\xa7\x55\xc9\xff\x1a\x35\x82\xd3\x5d\xc9\xb4\x4c\x81\x84\x98\xf1\x57\x82\xc9\x52\x84\xfe\x86\x8a\x91\x4c",
    .ok      = 1 },
  { .tc_id   = 303,
    .comment = "special case for DA - CB in multiplication by 4",
    .shared  = "\xcd\x32\x45\x40\x3f\xd9\xed\xfc\xf9\x1c\x95\x81\xeb\xb2\xeb\x7c\x77\xad\x68\x37\xfc\xa3\x72\x47\x9e\x78\xde\x9f\xaf\x60\xa3\x4a",
    .prv     = "\xa0\x52\x8e\xd9\xa8\xec\x22\xeb\xe9\xcc\x2e\x32\xfa\xfc\x3f\x46\x75\x00\xa9\xa2\x2f\x53\x77\x38\x2d\xf6\x60\x4e\xdc\xdf\x4f\x44",
    .pub     = "\xa8\x9b\xcf\xa2\x36\xbb\xcc\xf0\x7c\x43\x4b\x59\xf8\x65\x5f\xb0\x85\xb6\xcb\xe5\xed\x63\x76\x28\x1d\xf8\x13\xaf\xba\x22\xb7\x52",
    .ok      = 1 },
  { .tc_id   = 304,
    .comment = "special case for DA - CB in multiplication by 4",
    .shared  = "\xab\x7c\x47\xec\xb0\xc0\x16\x71\x56\xf4\x4f\x66\xa5\x27\x26\x4b\x95\x8f\xc9\x92\xc2\x1c\xe9\x8c\xef\x3a\xe2\x14\xd6\x6b\xd8\x2d",
    .prv     = "\xf0\x68\x88\xbd\xe7\x5d\x68\x9d\x05\x68\x74\xf6\x43\x60\x00\x49\x7d\x22\xd8\xad\x9b\x95\xa1\xc6\x7d\xe1\xdd\xa4\xad\xa3\x16\x4d",
    .pub     = "\xcd\xb1\xf9\x5f\x6e\xac\xc2\x4b\x6d\x02\x9c\x6e\xd9\x76\x66\x6d\xc5\x17\x94\xdb\x8e\x4a\xa9\x66\xba\x85\x0f\xd7\xf5\x04\x89\x65",
    .ok      = 1 },
  { .tc_id   = 305,
    .comment = "special case for DA - CB in multiplication by 4",
    .shared  = "\x1b\xfa\x26\x4a\x7c\x72\x29\x14\x7a\x20\xdd\x02\x12\x11\x89\x1e\x61\xf5\xd8\xc7\x6c\xd8\x3f\x0b\xe2\x4b\xc7\x0e\x46\x6a\x81\x5b",
    .prv     = "\xe0\x34\xfc\xaa\x3a\xe4\x06\x03\xf9\xb2\x2a\xf1\x59\xfd\x67\xef\x00\x93\x80\x94\x6d\xe9\x2c\xb1\xd8\x3c\xc4\x89\xe8\xb3\x50\x41",
    .pub     = "\x94\x91\xa8\x27\x44\xf1\xcb\x61\x05\xb7\x6b\x04\x42\xe5\x4e\x60\x5a\xc6\x7f\x47\xa1\xb2\xb3\xb5\x52\xd4\x86\xf7\x5b\xd9\x8e\x6a",
    .ok      = 1 },
  { .tc_id   = 306,
    .comment = "special case for C in multiplication by 4",
    .shared  = "\xc4\x60\x57\xfc\xf6\x30\x88\xb3\xa8\x0e\x0b\xe5\xce\x24\xc8\x02\x6d\xfa\xdd\x34\x1b\x5d\x82\x15\xb8\xaf\xcb\x2a\x5a\x02\xbb\x2b",
    .prv     = "\x70\x2a\x74\x48\xc0\xed\x58\xe1\xf4\xe0\xe3\x32\xd0\x96\xa3\x63\x60\xbe\xca\x2f\x69\x55\xc8\x15\xbc\x12\x0b\x3a\x69\x1d\x77\x42",
    .pub     = "\x4d\x19\xe1\x56\xe0\x84\xfe\x58\x2a\x0e\xb7\x9b\x2f\x12\xb6\x1d\x0b\x03\xf3\xf2\x29\x22\x7e\x79\x8a\x93\x3e\xea\x5a\x1b\x61\x29",
    .ok      = 1 },
  { .tc_id   = 307,
    .comment = "special case for C in multiplication by 4",
    .shared  = "\xd4\x36\x1e\x26\x12\x7a\xdf\xbe\x37\xc2\xed\x8f\x42\xcc\xe4\xeb\xab\x8a\xb7\x4e\xd9\xe7\x4f\x14\xc3\x43\x5d\x61\x2c\x1a\x99\x2a",
    .prv     = "\x50\x02\x5c\xb5\x08\xad\x4f\xaa\x06\xfa\xfd\x0f\x4a\x33\xb7\x47\xcc\xf1\xb3\x57\x38\x85\xd3\x42\x65\x00\xd5\x1b\x56\x30\x01\x44",
    .pub     = "\xcc\x47\x29\xc4\xea\xe2\x92\xe4\x31\xec\x3a\x5c\xf5\x02\x0e\x19\xf9\xbe\xa5\x0e\xf3\x21\x8d\x9a\x79\x00\x34\x52\x6c\x3e\xe1\x4a",
    .ok      = 1 },
  { .tc_id   = 308,
    .comment = "special case for C in multiplication by 4",
    .shared  = "\x80\xdf\xae\x7a\x28\xbb\x13\xd9\xe5\x1f\xf1\x99\x26\x7c\xec\x2a\x19\xdf\xc8\xb6\xf4\x97\x4e\x34\x46\xb2\xf6\x2f\xe9\xb6\x24\x70",
    .prv     = "\x70\x82\xfc\x53\x29\x9a\x4d\x30\xe5\xd0\xc3\x83\xc0\x35\x93\x5b\x1e\xee\xbd\x94\x08\xfe\x4d\x04\xb9\x3e\xec\x24\xbe\x52\xeb\x47",
    .pub     = "\x4a\x47\x42\x49\xaf\x8f\x77\x1f\x0c\xfb\x11\x16\xf2\x4f\xda\x4c\x42\xf4\x13\x6d\x2a\xfb\x76\x6d\x1b\x29\x1c\x73\xc6\x66\x8d\x5a",
    .ok      = 1 },
  { .tc_id   = 309,
    .comment = "special case for C in multiplication by 4",
    .shared  = "\x7a\x5c\x37\x30\x65\xe3\x39\xb2\x6e\xe5\x37\xcf\xf1\xcf\x45\x97\xcf\xcb\x4b\xf2\xdc\x7c\x4b\xcf\xec\x98\x84\x44\x32\x81\xc2\x73",
    .prv     = "\x98\xff\x7e\x71\x1d\x65\xcc\x7f\xd9\xd0\xac\x12\xdf\xe8\xb8\x94\xe0\xa9\x36\x02\xca\x9e\x75\xbf\x0e\xab\xbf\x0b\xfe\x67\x01\x48",
    .pub     = "\x0f\x2a\x5c\xbb\xe5\x03\x13\x95\x31\xac\x05\x29\x18\x3d\xa8\xe6\x24\xd2\x52\x86\xf6\xe3\x5d\x14\x07\xab\x1f\x4d\x76\xeb\xc2\x60",
    .ok      = 1 },
  { .tc_id   = 310,
    .comment = "special case for z_2 in multiplication by 4",
    .shared  = "\xc5\xed\xcc\x5d\x44\x70\x71\xc0\x8d\xfa\x82\x81\x41\x4a\xe6\xa0\x2d\xe7\x53\xe2\xf7\xbb\x80\xaf\x5f\x62\x53\xe5\x6d\xb4\x34\x22",
    .prv     = "\xb0\x80\xf4\xac\x1e\x75\x8b\xbf\xbf\xa8\x88\xa7\x8c\xb8\xd6\x24\xd9\x7b\x86\x88\x00\x2b\x20\x17\xe3\x5f\x52\xf3\xd7\xc7\x96\x49",
    .pub     = "\x2f\xe1\x1d\x72\x3d\xba\x63\x55\x9e\x1b\x96\x14\x78\x93\xcb\x7e\xc8\x62\x71\x18\x06\x31\x6d\xaa\x86\xcd\x4d\xa7\x69\xd4\xb2\x2d",
    .ok      = 1 },
  { .tc_id   = 311,
    .comment = "special case for z_2 in multiplication by 4",
    .shared  = "\x26\x3a\x38\xfe\x53\x8b\x50\xe8\xe9\x88\xbf\x07\xae\x86\xf3\x3d\x49\x88\x6b\x14\xc7\x14\x3e\xfd\x1d\x20\x25\xc8\x40\xe3\x6a\x25",
    .prv     = "\xe8\x15\xbf\x9a\x96\x7e\x12\x08\xaf\x8e\x74\xce\x9a\xf6\xd1\x13\xda\xb1\x7c\x01\xc9\x0f\x1a\xe2\xbc\x25\xe3\xe2\xf9\xe3\xa4\x4a",
    .pub     = "\x98\xe1\x21\x1d\xcf\x66\x51\xfa\x9f\x2d\x00\xeb\x08\x3a\xe5\x85\x58\x69\xa2\xa5\x3e\x83\x5f\x2e\x03\xb3\x0c\x0a\x19\xba\x80\x51",
    .ok      = 1 },
  { .tc_id   = 312,
    .comment = "special case for z_2 in multiplication by 4",
    .shared  = "\x34\x0a\xcf\x28\x01\xde\x71\xc1\x8f\x4c\x79\xcf\xea\x37\x2b\xc3\x54\xe4\xc8\xa5\xeb\x5c\x2c\xce\x8b\x45\xd8\x85\xdf\x16\x2f\x45",
    .prv     = "\x40\x51\xb0\x1c\xdf\x90\xaf\x38\xf0\xa9\x6f\xfb\x83\xf8\xd4\x13\x3a\xbe\x4f\xb0\x35\xb6\xfe\x6f\x65\x27\x64\x47\xca\xa7\x31\x4f",
    .pub     = "\x2f\x1b\x93\x8b\x81\xa4\xc9\x0e\x12\x51\x13\x5a\xd7\xfa\xbe\x83\x5f\x6a\x8b\xc5\xe2\x2d\x4b\x2a\xb1\x19\xf6\xf6\x77\x87\x76\x77",
    .ok      = 1 },
  { .tc_id   = 313,
    .comment = "special case for CB in multiplication by 4",
    .shared  = "\x9e\xfe\x5c\xd7\x11\x02\xd8\x99\xa3\x33\xa4\x5e\xa6\xd2\xc0\x89\x60\x4b\x92\x6d\xb8\xc2\x64\x5c\xe5\xff\x21\x49\x2f\x27\xa3\x14",
    .prv     = "\x98\xc0\x92\x36\x31\x84\xe5\x8a\xd6\xce\x51\x0b\xd3\x2b\x30\x9c\x9d\x5a\x46\xf8\xd9\xee\x6f\x64\xa6\x9d\x81\x80\xbb\xc6\xcb\x45",
    .pub     = "\x34\x0b\x9f\x61\x35\x50\xd1\x4e\x3c\x62\x56\xca\xf0\x29\xb3\x1c\xad\x3f\xe6\xdb\x58\x82\x94\xe2\xd3\xaf\x37\x60\x5a\x68\xd8\x37",
    .ok      = 1 },
  { .tc_id   = 314,
    .comment = "special case for CB in multiplication by 4",
    .shared  = "\x19\x61\x82\x09\x5b\xcd\x2e\xf4\x6b\x18\xf6\x4c\x63\x60\x7e\x0a\xb1\x62\xa0\x86\x9e\x62\x65\xac\x8a\xe3\x5e\x35\x8c\x3d\x8a\x63",
    .prv     = "\x68\x6e\x51\xc0\x01\x16\xd1\xc1\x91\xaa\x9d\x58\x23\xb9\x6e\x59\x56\x10\x2e\x8f\xe7\x5f\x5c\xf2\x37\x6d\x99\x98\x9f\x6f\x43\x42",
    .pub     = "\xed\xfb\xd6\xf0\x9a\xa3\x24\x35\x44\x0b\x0c\xa8\xba\x43\x63\x08\x31\x96\x13\xf8\xf2\xd5\x01\x13\x3c\x52\x6c\x3f\xf5\x5c\x7b\x3d",
    .ok      = 1 },
  { .tc_id   = 315,
    .comment = "special case for CB in multiplication by 4",
    .shared  = "\xa3\xc6\xb7\x51\x68\x21\x1e\x8e\x0a\x49\xca\x81\x5b\xfe\x3f\x46\x9f\x29\x86\x4d\xc8\x16\x61\x52\xb4\x56\xe7\x07\x4a\xfa\x9b\x5b",
    .prv     = "\x20\x8a\xf2\xc9\x44\x2b\x36\xb5\x21\xfc\x3a\x1e\xce\xfe\x34\x2a\xac\x30\x8b\xd6\xe6\x29\x6e\xe0\x91\xc1\x96\xdc\x02\xe7\xae\x40",
    .pub     = "\x9b\x05\x38\xcd\x61\x8b\x0a\x4d\xe0\x9e\x45\x42\x0f\x84\xd5\x4d\x74\x51\x4f\xbb\x1a\x31\xc1\xa4\xaa\x1e\x93\x30\x6f\x20\x72\x3f",
    .ok      = 1 },
  { .tc_id   = 316,
    .comment = "special case for CB in multiplication by 4",
    .shared  = "\xde\xaa\xe6\xc9\x95\x28\x44\xa3\xa1\xd0\x16\x88\xe7\x10\x5b\x0b\xbe\xad\xc1\x60\x76\x3c\x20\x02\xb6\xd0\xbc\xf3\x5c\x22\xd1\x23",
    .prv     = "\xc0\xd8\x61\xa6\xd5\xff\x91\xf9\x1e\x3b\xd0\x59\x34\x16\x1f\xf0\xab\x0f\x3c\xe7\xe4\xa2\xb5\xb4\xfc\xb3\x1a\xe3\x4b\x46\x66\x4f",
    .pub     = "\xae\x8c\xf2\xfc\xdd\xe7\x10\xc2\xc1\x18\x45\x24\xbc\x32\x43\x08\x74\xdf\xa0\x8c\x12\x5f\x61\xd6\x91\x9d\xaf\x8e\x66\xdb\x41\x5a",
    .ok      = 1 },
  { .tc_id   = 317,
    .comment = "special case for AA in multiplication by 4",
    .shared  = "\xc2\x04\xbd\x15\xf0\x1a\x11\xa2\xef\xda\xbe\x2e\x90\x2b\x7c\xd0\xaa\x07\x93\x16\xf6\x0e\x91\x1b\x3e\xe5\xd4\x62\x62\xe9\x86\x31",
    .prv     = "\x70\x78\x5c\xad\x16\x09\x72\xb7\x11\x31\x86\x59\xb4\x7b\x57\x4f\x69\x41\xef\x6d\xa1\xea\x06\x50\x8b\x26\x50\xf5\x7e\xc9\xe5\x4a",
    .pub     = "\x2a\x59\xf4\x78\x40\x2d\x28\x29\xcd\x3b\x62\xe9\xf7\xcc\x01\x44\x5e\x8e\x73\xa4\x2c\xb1\x1a\xf0\x0b\x6b\x9a\x9f\x0e\x44\xcb\x3b",
    .ok      = 1 },
  { .tc_id   = 318,
    .comment = "special case for AA in multiplication by 4",
    .shared  = "\xc5\x45\x74\x87\xe9\x09\x32\xf5\x7b\x94\xaf\x2e\x87\x50\x40\x3e\x09\xc9\xac\x72\x7e\x2b\xd2\x13\x59\x04\x62\xb6\x93\x7b\x07\x53",
    .prv     = "\x60\xaf\xc8\xeb\x1f\x87\xdf\x4b\x55\x28\x7f\x3c\x46\x98\xc5\xf8\xb9\x97\xb2\x8a\x73\xc5\x73\xfc\x27\x3e\x9c\x46\x7f\xb7\xe4\x4c",
    .pub     = "\x83\x6c\x8e\x45\xdd\x89\x0e\x65\x8c\x33\xe6\x9b\x6f\x57\x8a\x5a\x77\x4c\x48\xb4\x35\xbc\x3b\x91\xac\x69\x3d\xf9\x4a\x05\x58\x57",
    .ok      = 1 },
  { .tc_id   = 319,
    .comment = "special case for AA in multiplication by 4",
    .shared  = "\x4e\xd6\xf8\xd6\x29\x32\x54\x1c\x6b\xea\x16\xe0\x38\x35\xf1\xf7\x58\xa5\xc4\x17\x22\xb5\xc9\x98\x9c\x9c\x7c\xc0\x8e\x34\xe3\x7b",
    .prv     = "\xa8\x3c\x11\xb2\x83\x41\x36\xb9\xaa\xf0\x15\x2d\x90\xe7\x6e\x3c\x27\x17\x76\x93\xa2\x83\x4e\x8b\xed\xa0\xa3\x57\x1b\xce\x69\x47",
    .pub     = "\x59\x51\x9e\xad\x79\x95\xa6\xdf\x89\xbb\x54\xc8\x40\xd6\x1a\x84\x81\x88\x10\x98\xb8\xa4\xf8\x3c\x6a\x2f\x6b\xa8\x00\x33\x82\x57",
    .ok      = 1 },
  { .tc_id   = 320,
    .comment = "special case for AA in multiplication by 4",
    .shared  = "\x52\x1a\x5b\x81\x49\xa1\x32\xd1\x55\xe6\xb4\xed\x11\x39\x00\x50\x6c\xfc\x2f\x76\xd2\xa3\xe1\x41\x96\xd6\x9e\xb8\x5d\xb3\xc9\x52",
    .prv     = "\xb8\x0d\x87\x95\x73\x58\x06\x57\x9e\x71\x75\x98\x94\x93\x9d\x75\x88\x53\x59\x21\x27\xef\xe8\x4f\xc8\x2e\xb7\xcd\xee\x45\x01\x4f",
    .pub     = "\x32\xf3\x4d\xa8\x4a\xb4\xbf\xca\x36\x9c\x4b\x88\x46\x91\xbe\xcf\x54\xbe\x7f\xbe\xd1\x64\x49\xdc\x86\x96\x9d\xa7\xea\x9a\xbf\x62",
    .ok      = 1 },
  { .tc_id   = 321,
    .comment = "special case for AA in multiplication by 4",
    .shared  = "\xe8\x31\xd6\xce\xe9\x5c\xa1\xb4\xc9\x6b\xb8\x94\x57\x56\x2f\xff\x36\xcb\x4d\x08\xb8\x1d\xa8\x9b\x81\x0b\x42\x5e\xcd\xba\xfd\x78",
    .prv     = "\xe0\x8f\xfa\x45\xef\xbe\x1f\x96\x58\x4c\x76\x25\x45\x54\xad\xb9\x17\x7b\x58\xed\x09\x60\x9a\x6c\xe4\x99\xe5\xbd\x22\xd3\x5c\x45",
    .pub     = "\x82\xae\x48\xdc\xf5\x9b\xc5\xe4\x69\xf9\xa1\x1b\x18\xa3\x2d\x47\x53\xac\x81\x86\x92\xdf\xae\x27\xd6\x75\x41\x1a\x22\x72\xb3\x63",
    .ok      = 1 },
  { .tc_id   = 322,
    .comment = "special case for AA in multiplication by 4",
    .shared  = "\x35\x0e\x3a\xb9\xd0\xdb\xff\x78\xf3\xf2\x15\x74\x28\xbe\xba\x18\x93\x33\xbe\x27\x48\x27\xc1\x0d\x59\x67\x3f\x21\xc0\xc4\x8a\x24",
    .prv     = "\x68\x8e\x1b\xbb\x51\x14\xf3\x4e\x85\x31\xc2\x78\xb2\xd9\x71\x4b\xa0\x7c\x32\xa7\xae\xa6\xe6\x27\x13\x5b\xd1\xfc\x65\x23\x80\x45",
    .pub     = "\xb3\x3b\xd3\xad\x14\xb6\x68\x96\xf9\x71\xcb\xdf\x27\x78\x5f\xc3\xaa\x3c\xfb\x39\xad\xc6\xc2\x92\x57\xd2\x2e\xa4\xdf\x8c\xbf\x63",
    .ok      = 1 },
  { .tc_id   = 323,
    .comment = "special case for AA in multiplication by 4",
    .shared  = "\xad\xe7\x1d\x64\x60\x28\x7f\xe8\x08\xe9\x47\x56\x0e\x67\xa9\xd6\xff\x2f\x96\xea\xa1\x35\x5d\x2e\x9f\xbb\xe5\x49\xe8\x83\x38\x1b",
    .prv     = "\x80\x36\xa4\xe2\xe9\x3e\x9e\xd8\x2d\x99\xd7\x1a\x52\x2a\xac\x92\x89\xbd\x99\x05\xfe\x41\xd0\x1d\x08\xa4\x99\x37\x6a\x25\x84\x42",
    .pub     = "\x18\xe5\x8d\xf6\xbf\xbe\x18\x4b\x0e\x3c\x7c\x4b\xf2\xa0\x51\xed\x05\x5b\x79\x35\x01\xc0\xd4\xfc\x47\xbc\x8a\x95\xc4\xde\xec\x7c",
    .ok      = 1 },
  { .tc_id   = 324,
    .comment = "special case for DA in multiplication by 4",
    .shared  = "\x91\xa9\xbe\xc2\x8c\xf1\x8c\x70\x94\xe2\xd8\x0d\x27\x64\xdf\x59\xad\xa0\xcb\x19\x46\xbe\x42\x28\x64\xbd\x7a\xd0\xe5\x33\xb6\x63",
    .prv     = "\x90\x1b\x20\xf0\xcd\xa7\x40\x76\xc3\xd4\xbf\x4e\x02\x65\x3c\xd4\x06\xed\x48\x0c\x35\x51\x59\xe2\x2c\xa4\x4b\x98\x4f\x10\x76\x4f",
    .pub     = "\x77\x2e\x31\xe7\x76\xe8\xd4\xf2\x3b\x7a\xf2\x03\x7a\xf2\x8a\x37\xe6\x8f\x61\xe7\x40\xb3\x90\x4f\x4e\xc4\xc9\x01\x57\xbe\x14\x78",
    .ok      = 1 },
  { .tc_id   = 325,
    .comment = "special case for z_2 in multiplication by 5",
    .shared  = "\x6c\x1b\x8e\x24\x0e\xdf\xa5\xdb\x2a\xbb\x3d\xc1\x2b\xcf\x9e\x8a\xc9\xca\x10\xdd\x35\x07\x08\x37\x46\xf6\xf3\x6d\xc0\x35\xd7\x55",
    .prv     = "\xd8\x3e\xb7\xaf\xfd\x1b\xcc\x1e\xc0\xb4\x82\x3c\xee\x5c\xf0\xb1\x5b\x5f\x57\x08\x5a\xa2\x70\x8e\xd4\x37\xa2\x92\x53\x29\xb5\x50",
    .pub     = "\xa8\xd5\x5d\x5c\x11\x37\xe9\xbb\x62\x65\x57\xf9\xd6\xee\xa8\xd3\x12\x0e\x93\x64\xf8\xbc\xd9\xb6\x79\x34\x26\x0b\x1a\x09\x18\x01",
    .ok      = 1 },
  { .tc_id   = 326,
    .comment = "special case for z_2 in multiplication by 5",
    .shared  = "\xd4\xc3\xb3\x46\x77\x14\xf2\xd1\x05\x90\x4a\x84\xcc\x7e\x81\xd7\xf2\x91\x30\x4e\x90\x80\x41\x68\x2d\x89\x06\xa6\x83\xc1\x21\x25",
    .prv     = "\x98\x9e\xee\x31\x7b\x9c\x25\x4d\xc0\x23\xf9\xe3\x5e\xff\x02\x24\xbc\x2e\x0b\xc8\x71\x99\x6b\x94\x6a\x96\x97\x0e\x75\x06\xa8\x5e",
    .pub     = "\x33\xc9\x4b\xe5\x8b\x0f\x0e\x6c\xf3\x63\xe1\xb1\x2a\x2e\xbf\xb9\x30\x40\x71\x5b\xe9\x15\x18\xf2\x1d\xf2\x95\x3e\xea\xb5\xfb\x01",
    .ok      = 1 },
  { .tc_id   = 327,
    .comment = "special case for z_2 in multiplication by 5",
    .shared  = "\x1e\xbe\x6c\xa7\x11\xa6\x49\xae\x48\x7b\x33\x27\x47\xe3\xdc\x03\x06\x34\x05\x60\xca\xb6\xbc\x60\x29\xe4\x4f\x6a\x7e\x0e\xe4\x1c",
    .prv     = "\xb8\x35\x54\x55\xd3\x58\xf2\xdd\x7c\x57\x07\xb2\xc6\x97\x3c\x9c\x27\xb9\x9e\x7d\x8a\xc1\x65\x0c\x79\x1e\x5f\xdb\xcb\xea\x49\x57",
    .pub     = "\xa2\x18\xae\x96\x24\xb0\x7c\xe0\x51\x78\xb9\xd0\xcc\x1b\x71\xde\xe2\x1f\x27\x85\x2a\x2c\xeb\x18\x61\x0b\x40\x52\xb2\x44\xf0\x0f",
    .ok      = 1 },
  { .tc_id   = 328,
    .comment = "special case for z_2 in multiplication by 5",
    .shared  = "\x03\xe7\xa7\x77\xe6\x48\xbd\xc6\x12\x18\x9f\x3c\xd4\x2d\x34\xe3\x57\x36\xd3\xe5\x2e\x6e\xdc\x8a\xc8\x73\xa5\x8e\x24\x4a\x60\x73",
    .prv     = "\x80\x65\x56\x7e\xf0\x82\xb1\x6c\x20\x85\x34\x87\xf5\x48\x93\x01\x2b\xa4\x76\x22\x24\xe5\xc5\x9f\x25\x0d\xfb\xf8\x25\x81\xe8\x5a",
    .pub     = "\xd7\x06\x7f\xae\xaf\xd3\xe9\x66\xe5\x75\x25\xf9\x30\xb3\x31\x7c\x9e\x8b\x9c\x9a\x9a\xe9\x46\xe7\x6c\x1e\x46\x02\xa5\x9a\x7e\x33",
    .ok      = 1 },
  { .tc_id   = 329,
    .comment = "special case for z_2 in multiplication by 5",
    .shared  = "\x30\x8e\xf9\x9d\xae\x10\x64\xa4\x44\xfa\x90\x77\x5b\x5d\xd5\xb1\x95\x2d\x72\x24\xa0\xe5\xae\x03\x1d\xf4\x32\x64\x0f\x41\x62\x08",
    .prv     = "\x00\xb5\x14\x48\x13\x9a\x61\xfe\x6c\x5f\xbf\x93\x95\x87\x7d\x53\xd8\x20\xef\x59\xda\x3b\xe8\x56\x45\x8b\x5e\xb9\x09\x85\xba\x53",
    .pub     = "\x8d\xf9\x68\x2c\xbe\x88\x02\x47\x8a\x85\x31\x37\x7e\x75\x2c\xdd\xe5\x47\x38\xd5\x28\xd6\x39\xbe\xa9\xea\xf4\x77\x02\xf8\xbf\x3b",
    .ok      = 1 },
  { .tc_id   = 330,
    .comment = "special case for z_2 in multiplication by 5",
    .shared  = "\xf3\x3e\x2e\x86\x44\x3a\x2c\x68\x82\x3b\x72\xa2\xb5\x9d\x6a\x02\x8e\x0a\x8e\x28\x3c\xfe\x29\xfe\xa4\xf7\xaa\x22\xbd\x1a\xfe\x72",
    .prv     = "\xe8\xeb\x9f\x6f\x62\xf9\x3d\xbc\x32\x5b\x83\x3a\xa7\x63\xa9\x0f\x13\xf0\xac\xb2\xc2\xc4\xb8\xb3\x3d\xec\xd4\x71\xce\x70\xc4\x5f",
    .pub     = "\x7d\x92\x70\x68\x68\xaa\x09\x53\x86\x38\xd6\x33\xc2\x55\xf3\x33\xb9\xda\x03\xbc\x74\xb4\x9b\x35\x94\x1c\x57\x82\x0c\xd3\xfd\x47",
    .ok      = 1 },
  { .tc_id   = 331,
    .comment = "special case for E in multiplication by 5",
    .shared  = "\x7b\x53\x5f\xc3\x1c\x6c\x2a\x38\x03\xd8\xbd\x45\x41\x0a\x17\x81\xbd\x90\xa0\x92\x05\xda\x28\xc9\xdf\x12\x0d\xf2\x3a\x9f\xa3\x2d",
    .prv     = "\x68\xa1\xa7\xcc\xc5\x0b\xab\x4b\x01\xe5\x5e\x18\xcb\xd4\x64\xaf\xf4\x31\x31\xfb\x07\x41\xe6\x8d\x53\xcd\xeb\xfc\x54\xf3\x30\x51",
    .pub     = "\xdf\xb1\xff\xc1\x76\xaf\xf8\x4d\xb3\x01\x82\xd2\x37\x8f\x83\x72\x8f\x83\xdd\x1b\x33\xd7\x98\x56\xf3\xda\x54\x59\xcf\x9d\xf9\x07",
    .ok      = 1 },
  { .tc_id   = 332,
    .comment = "special case for E in multiplication by 5",
    .shared  = "\xca\x23\xa7\x81\xda\x09\x11\xe4\x11\x5a\x29\xa9\xf5\x64\x47\x15\x7c\x23\xbe\xe1\x87\xb0\xc1\x73\x69\xc4\xf7\x73\x0d\x78\x17\x18",
    .prv     = "\xe0\x75\xbc\xfc\x16\x5a\x47\x1b\x2f\x76\xc3\x00\x3f\xb0\x17\x2c\x82\xf7\x07\x13\x7d\xe2\xfa\x70\x82\xe4\x3a\x87\xa2\x55\x93\x5c",
    .pub     = "\x12\xe8\x1e\x83\x8b\x21\xea\xc9\x6d\xc1\x30\x43\x25\x71\x21\x6d\x7a\x9b\x4a\x81\x7f\x19\x38\x72\x1d\x22\x67\xdd\x15\x0e\xbf\x20",
    .ok      = 1 },
  { .tc_id   = 333,
    .comment = "special case for E in multiplication by 5",
    .shared  = "\xcd\x06\x86\xb3\x2e\xa4\xcd\xdb\x8e\x13\xff\x20\xa7\x8d\x38\x07\x49\xa5\xd4\xf6\xa3\xdc\x55\xd7\x2f\x48\x13\xd9\x49\xa0\xea\x57",
    .prv     = "\xc0\xe1\x96\x34\xdb\xf6\x46\x0e\x14\x86\x93\x0c\x46\xe8\x55\x6b\x3c\x16\xd6\xde\x95\x99\x04\x60\x05\x49\xbb\x3e\x08\x60\x34\x55",
    .pub     = "\x83\x2a\x46\xae\xc0\x22\x40\xd7\x16\xfe\x22\xde\xa9\x4a\xd5\x66\xa3\xfa\xfb\xee\xdc\xce\x35\xc8\x3e\x41\xe5\x80\x76\xc9\x97\x49",
    .ok      = 1 },
  { .tc_id   = 334,
    .comment = "special case for E in multiplication by 5",
    .shared  = "\xa9\x50\xaa\x57\xbb\x2b\xeb\x9e\xd5\xd3\x22\x8c\x7e\xf4\x48\xda\xb6\x95\x52\xf3\xd3\xb1\xe4\x66\xac\xcf\x41\xbf\xb6\xd5\xb8\x74",
    .prv     = "\xb8\x4c\xaa\x18\xac\xc3\xdb\x37\x22\x5d\x32\xca\xb4\xf6\x0e\x6f\xba\x4a\xca\xb1\x27\x7e\x20\x42\x5d\x30\xf9\x4c\xab\x2e\x2c\x55",
    .pub     = "\x8c\x80\x33\x43\x2b\xcc\x12\xd4\x79\xf6\x7d\x6d\x87\x6b\x1c\x8e\x89\xf1\x6a\x23\x4b\x9b\x09\x33\x22\xef\xfa\x9d\xee\x94\x55\x4d",
    .ok      = 1 },
  { .tc_id   = 335,
    .comment = "special case for E in multiplication by 5",
    .shared  = "\x54\xf5\xae\x57\xe6\x76\xd0\x8c\x8f\x8a\x3c\xf8\x91\xe3\x6d\xda\xab\x75\x10\x93\xf9\x2f\x40\x90\x60\xc5\x7e\x74\x59\x41\x70\x0e",
    .prv     = "\x28\x96\x81\x8c\xdd\xf5\x72\x52\x19\x43\xe9\xf0\xc5\xe8\x45\xf5\x30\xb7\x40\x42\x75\x88\xa0\xf6\xde\x25\x04\xbd\x5b\xf4\x0c\x53",
    .pub     = "\x6d\xf7\x99\xbb\xa6\xcd\xf5\xf4\x6a\x57\xab\x22\x7f\x93\xfb\xa4\x91\xda\xd2\x96\xa2\xfd\xb7\xe4\x91\x92\x1d\x61\x0c\xce\x8f\x5e",
    .ok      = 1 },
  { .tc_id   = 336,
    .comment = "special case for AA in multiplication by 5",
    .shared  = "\x2d\x49\xb0\x9f\x81\xf3\xf6\xfa\xb2\xc6\x7e\x32\xf1\xbc\xea\xd2\xad\x09\xac\x9e\x0d\x64\x2b\x08\x73\xbe\xcf\xb6\x4d\xe2\xab\x23",
    .prv     = "\xa0\x1f\x0c\xad\x98\xcf\x29\x05\xb8\x12\xd3\x53\x05\x31\xbb\x3a\xc8\x99\x39\x1a\xbd\x1e\xaf\x4a\x3e\xbe\xd9\x6a\xc6\x12\x6f\x58",
    .pub     = "\x0c\x80\x90\xe1\xcf\xe7\xf7\x61\xcf\xdf\x08\xd9\x44\xd4\xae\xb7\xa5\x09\xa0\x7a\x61\x01\x64\x5b\x9a\x4c\x7c\x9e\x9c\x3d\x46\x09",
    .ok      = 1 },
  { .tc_id   = 337,
    .comment = "special case for AA in multiplication by 5",
    .shared  = "\xa1\x99\x36\x8e\x68\x3c\x30\x36\xa4\x8f\x4c\x5f\x32\xb3\x2a\x54\x7d\xd3\x9f\x3d\x10\x07\xca\x0a\x0b\xeb\xca\xd0\xa8\xac\x6f\x5c",
    .prv     = "\x10\x6b\x36\x34\x4c\xc4\xa5\xa3\x89\xd8\x16\x81\x37\x78\x68\x06\xff\x03\xcd\x4a\x00\xf8\x63\x6b\xb7\xe7\x58\xd4\x56\x15\x1d\x59",
    .pub     = "\x08\x35\x29\x36\xc8\xaf\xd8\x54\x3a\xc9\x5f\x24\xbc\xe9\xa0\x7e\x3e\x32\x35\x76\x3e\xa5\x12\xa5\x84\x29\x89\x67\xb8\x3c\x07\x0a",
    .ok      = 1 },
  { .tc_id   = 338,
    .comment = "special case for AA in multiplication by 5",
    .shared  = "\x5a\xa7\x50\xde\x42\x07\x86\x9e\xc7\xfd\xda\xb3\x4c\x63\x95\x59\xb1\xeb\x27\xef\x24\x4a\xaf\x2a\x70\x2c\x84\x96\x3b\x6d\x6e\x7c",
    .prv     = "\x88\xf9\xa0\xd2\x35\x4a\xdf\xcb\xab\x2d\x12\xa0\xe0\x9b\x3c\x77\x19\xc9\x44\x38\x4e\xdf\xba\xa2\x7f\xe0\x73\x1c\xb9\xc6\xfc\x5a",
    .pub     = "\x73\xbd\xee\xf8\xcc\x04\x4f\x5a\xd8\xd6\xa2\x41\x27\x3e\x19\x95\xe0\x00\x7d\xc9\xe6\x57\x90\x46\xdf\x86\xaa\x6c\xd9\x7f\x5d\x2a",
    .ok      = 1 },
  { .tc_id   = 339,
    .comment = "special case for AA in multiplication by 5",
    .shared  = "\xa6\x94\x7e\xe0\x89\xff\x28\xce\x36\x44\xea\x4c\x6e\xb3\x3d\xbb\x20\xc7\x97\x4f\xb8\xd8\x53\xf4\xe1\x46\xe2\x46\x61\x77\x50\x2d",
    .prv     = "\x08\x11\xf2\xe5\x60\xa2\x05\xe9\x6e\x28\xbc\x31\x2b\xca\xd4\x5f\xe8\xbe\xfe\xfb\x7f\x6d\xa5\xfa\xa0\x35\x31\x1e\xed\x80\xb2\x51",
    .pub     = "\x7f\xdd\x39\x9b\x6e\xf4\xa3\xf5\xca\xde\x62\xe7\x41\x13\xb2\x9c\x27\xdb\x15\x20\x3f\x9b\x8e\x39\x8d\x2c\x6f\x23\x00\x51\xcd\x2b",
    .ok      = 1 },
  { .tc_id   = 340,
    .comment = "special case for DA - CB in multiplication by 5",
    .shared  = "\x23\x0b\x6a\xa1\xf2\x4d\xf9\x0a\x60\x83\x91\x79\xba\x5e\x9d\xe6\x73\xcf\xf1\x1c\xab\x59\xe8\x02\x0b\x20\x62\x6c\x22\x09\x0b\x0a",
    .prv     = "\x40\xad\x98\x40\x66\xa6\x90\x80\xfb\x4a\x31\x58\x78\xe7\x36\x09\x6c\xc5\x77\xda\xe4\xc4\x2c\x40\xd8\x93\xd8\xc2\x17\x3b\x78\x5a",
    .pub     = "\xf0\x17\x3a\x96\x27\x3c\x64\x6f\xb6\x3d\x13\xb0\xc6\x86\xb8\x9e\x37\x67\x6f\xcc\x71\x78\xfa\xf4\xa6\xf4\x60\x1f\x30\x68\x15\x0d",
    .ok      = 1 },
  { .tc_id   = 341,
    .comment = "special case for DA - CB in multiplication by 5",
    .shared  = "\x22\x99\xe3\x84\x95\x8b\xed\xd2\xc3\xd3\x67\x75\x91\x55\x13\x6d\x1f\xf7\x6e\x44\x34\xdc\x1d\x9e\x82\x12\xcd\xca\x52\xea\x84\x21",
    .prv     = "\x48\xb1\x0c\xd4\x56\x39\xbb\xbf\x83\xa0\xb2\x8f\x0d\xd3\xad\x0b\x7b\x00\xca\xf4\x8d\x05\x53\x44\x80\x55\x6a\x82\x78\x11\x6d\x59",
    .pub     = "\x25\x5b\xbe\x72\x30\xcd\x2b\xee\x90\xd2\x83\xf4\x18\xa4\x74\xab\x30\x14\x6c\xe5\xe8\x01\xa0\xf5\xed\x60\xee\x8d\xef\x3e\x65\x58",
    .ok      = 1 },
  { .tc_id   = 342,
    .comment = "special case for DA - CB in multiplication by 5",
    .shared  = "\x97\xfc\xa0\x65\xac\xd3\xb9\x43\xc6\x54\x99\x7c\x0f\x12\x57\x67\xf9\xab\xc4\xb7\xc9\xd8\xb7\x24\x69\x42\xf1\x2b\xe6\x5d\x92\x31",
    .prv     = "\xe8\xfa\xd7\x79\x46\xe0\xde\x4c\xf4\x23\x67\x98\x49\x0b\x83\x89\x48\xb8\x2c\xfb\x29\xf8\xe7\x68\x60\x01\xb1\x1e\x8d\x96\x16\x57",
    .pub     = "\x21\xac\xcf\x97\xb7\xfe\xe1\x73\x00\x1c\xcf\xca\xb2\x16\x37\xc1\x75\xef\x51\x86\xff\x00\x02\x50\x2b\x3d\x52\xfa\x8c\x51\xe7\x66",
    .ok      = 1 },
  { .tc_id   = 343,
    .comment = "special case for BB in multiplication by 5",
    .shared  = "\xf4\x82\x53\x1e\x52\x3d\x05\x8d\x6e\x3f\xe3\xa4\x27\xfc\x40\xdb\xce\x6d\xd6\xf1\x8d\xef\xbc\x09\x7b\xfd\x7d\x0c\xdd\x2f\x71\x0d",
    .prv     = "\xd0\x7b\xab\xed\x90\xb2\x7c\x4e\xac\xaf\xdc\x87\x17\x03\xbd\x03\x6b\x72\x0a\x82\xb5\xc0\x94\xdc\xeb\x47\x49\xee\xae\xb8\x10\x52",
    .pub     = "\x5b\x40\x77\x7e\x80\xff\x6e\xfe\x37\x8b\x5e\x81\x95\x9c\xcd\xcb\xb4\xca\x04\xb9\xd7\x7e\xdc\x6b\x30\x06\xde\xb9\x99\x26\xfa\x22",
    .ok      = 1 },
  { .tc_id   = 344,
    .comment = "special case for BB in multiplication by 5",
    .shared  = "\xde\x88\xaf\x90\x5d\x37\x41\x7d\x83\x31\x10\x53\x45\xda\xba\xab\x9f\xd2\xd3\xcb\x1e\xe9\x02\x91\x1c\x1c\x8e\xae\x29\x91\xd9\x11",
    .prv     = "\x68\xa3\x04\x9a\xef\x8c\x06\x9b\x90\x6c\xf7\x43\x28\x6d\x39\x52\xa8\x88\xbf\x2b\x9b\x93\xbc\x87\x75\xfb\x5a\xdd\xe0\x6e\x9f\x53",
    .pub     = "\x48\xd9\x52\xa2\x92\x4f\xf1\x67\xf0\x37\x70\x74\x69\xec\x71\x5d\xa7\x2b\xb6\x5f\x49\xaa\xf4\xdc\xe7\xec\x5a\x17\x03\x9d\xdb\x42",
    .ok      = 1 },
  { .tc_id   = 345,
    .comment = "special case for BB in multiplication by 5",
    .shared  = "\x07\x5d\x18\xcc\xc9\x84\x76\x1b\x70\x75\x22\x79\xe7\xf6\xa7\x57\x20\x8f\x6c\x11\xe2\x94\x80\xc3\x2b\x40\xab\xa1\x28\xa4\xd5\x2b",
    .prv     = "\x18\xd8\xc3\xd2\xa4\xe3\x66\x18\x5a\x85\xc3\x86\x98\xd9\x37\xe1\x3b\xbb\xaf\xdb\xda\xb1\xa0\xa8\x3d\xbb\xe8\x9b\xad\xf7\x07\x56",
    .pub     = "\xa5\xef\x26\x5c\xcb\xc5\xc5\x40\x21\xd3\x4f\x82\x36\x4a\x46\x24\x03\x0f\x5b\x9d\x5f\xf7\xe6\x3d\x7a\x37\x9e\x53\x3d\xe5\xe7\x42",
    .ok      = 1 },
  { .tc_id   = 346,
    .comment = "special case for x_2 in multiplication by 5",
    .shared  = "\x21\x2d\xbf\x9b\xc8\x9b\x68\x73\xa6\x0d\xfc\x87\x31\xa1\x0b\xe1\x1a\xb2\xdc\xa4\xb1\x72\x14\x2e\x6c\x9f\x06\x61\x4c\xd7\x28\x52",
    .prv     = "\x18\xef\xcd\x5f\xe3\x45\xbe\x49\x85\x31\x66\x95\x39\x1d\x2c\x95\x2e\xee\x13\xb0\xe1\xee\x75\x84\x72\x1f\xbe\x8b\x19\xd4\xfc\x5f",
    .pub     = "\x90\x51\xe5\x5a\x40\x50\xef\x4d\xce\x0b\x0c\x40\x81\x1f\x16\x37\x1e\x8b\x16\x93\x25\x41\xda\x37\xf0\x69\x40\x6d\x84\x8e\xa4\x24",
    .ok      = 1 },
  { .tc_id   = 347,
    .comment = "special case for x_2 in multiplication by 5",
    .shared  = "\x37\x9f\x92\x21\xab\xeb\xf3\x58\x26\x81\xa0\xe8\x57\xf3\xda\x57\x8a\x1b\x01\x21\x98\x2b\x96\xf1\x4b\x94\xde\x5d\xc8\xb2\x45\x28",
    .prv     = "\x28\xec\x7c\x69\x3e\x22\x2c\x72\xac\x08\x15\xf1\xfd\x36\x66\x13\x57\xe0\xa8\xda\x7b\xc9\x96\xda\xee\xea\xfc\xd2\x1c\x01\x34\x51",
    .pub     = "\x41\x9a\xdb\x8b\x1f\x2f\x87\xde\x01\x6b\x0c\x78\xd1\x02\x9a\x21\x04\x92\xeb\x8c\xad\xd1\x64\xb1\x2c\xd6\x5b\x1d\x57\xbf\x36\x34",
    .ok      = 1 },
  { .tc_id   = 348,
    .comment = "special case for x_2 in multiplication by 5",
    .shared  = "\xcf\xf2\x59\x6b\x7a\xfe\x36\xf4\xca\xb9\xc7\x01\x33\xd7\xaa\x0f\x99\x14\xf9\xab\xc6\xc3\xb9\x89\x54\x72\xe2\xa5\x89\x4a\x80\x37",
    .prv     = "\x78\xb3\x5e\x7a\xe5\x49\x30\x8b\x64\x14\xbb\x61\x01\x96\xc0\x4f\x2a\xf7\x9d\x42\x66\xc8\x6e\x8a\x9c\xe0\xc0\x2b\xbd\xb8\x8d\x59",
    .pub     = "\x13\xe0\x0d\xae\x3b\x1c\xcc\x97\xcc\xd6\x49\x08\x8c\x4a\x7f\x32\xca\x99\x76\x21\x4d\x64\x56\x67\xbd\x08\x20\x39\xbb\xd9\xab\x7a",
    .ok      = 1 },
  { .tc_id   = 349,
    .comment = "special case for C in multiplication by 6",
    .shared  = "\xd4\x7c\x46\xb4\x32\x9b\xed\xcb\xc1\x98\x6b\x3c\x6d\x2a\xa9\xbc\xd0\x27\xd6\xb6\x89\x25\x17\x5d\x35\xbb\xb5\x36\xb3\x44\x08\x01",
    .prv     = "\xf0\xde\x9c\x5f\x8a\x93\x72\xf3\x0c\x41\xca\x47\xa5\x57\x43\xce\x69\x7d\x46\xe3\x2e\x7a\x9a\xe2\x6d\x32\x50\x3f\xd5\x22\x27\x67",
    .pub     = "\x44\x1c\x48\x7a\x48\xf0\xa4\x98\x9d\x93\x1c\xd7\x7a\x61\x42\xa0\xa1\x3d\x1a\xab\xad\x82\x62\x3b\xa8\xd9\x4b\x5c\x37\x4f\x4f\x08",
    .ok      = 1 },
  { .tc_id   = 350,
    .comment = "special case for C in multiplication by 6",
    .shared  = "\x1d\x73\x01\x58\xda\x88\x05\x33\xdb\xf1\xe6\xc6\x4a\x8e\x99\xf9\x16\x96\x11\x66\x09\x69\xb0\xa8\x4f\xb4\x2d\xd8\xdc\x2e\xfa\x3d",
    .prv     = "\x68\x6b\xe5\xa1\x2b\x31\x04\x20\xf9\xbf\xb2\x09\x38\x1f\xd4\x59\xa5\xcc\xd5\x5c\x75\x2b\x88\x33\x7e\xbe\x89\xe1\x92\x1a\xe7\x65",
    .pub     = "\x0e\x67\xee\x5c\x6b\x65\xaa\x80\x22\x59\x81\x0b\x26\x05\xf8\xd7\xac\xcf\x9b\x49\xbf\x14\xcb\x4a\x53\x69\x28\xe8\x83\x17\x29\x15",
    .ok      = 1 },
  { .tc_id   = 351,
    .comment = "special case for C in multiplication by 6",
    .shared  = "\x07\x73\x25\x29\xa6\x28\xba\xde\xb8\xd7\x49\x46\x77\x5b\xa4\x57\xc7\x00\xbf\x83\x90\xf4\x6b\xc5\x23\xfb\x64\xe4\x71\xc8\x6a\x7e",
    .prv     = "\xa0\xc0\x33\x7c\x5b\xec\x5c\xa2\x4d\xea\x2f\x1d\x70\x14\x98\xae\x2b\xad\x87\xb8\x26\x9a\xc2\x3b\xe1\x13\x92\x9f\xe4\xeb\x19\x63",
    .pub     = "\xdc\x9d\x7e\xf1\xcb\x49\xc1\x91\xe2\x58\x66\x3a\x94\xe7\x31\xb9\xc0\x66\xc1\x1a\x17\xd8\xb5\xfd\xea\x19\x87\xf5\xd9\xa0\x05\x68",
    .ok      = 1 },
  { .tc_id   = 352,
    .comment = "special case for C in multiplication by 6",
    .shared  = "\x9e\x3a\xae\x35\xfa\x1c\xc8\x0a\x35\x98\x78\xe2\x12\x18\x02\x94\xff\x66\x08\xdc\xb4\x92\x9e\x91\x90\x1a\xbb\xf9\x76\xf3\x9c\x16",
    .prv     = "\xb8\x82\x4c\xfc\xe5\x55\x0b\x5e\x17\xb1\x2f\x74\xe2\x84\x59\xca\xb3\x4e\xb4\x98\x95\xcc\x36\xbf\x64\x5a\x0c\xf0\x0e\x3d\x2d\x67",
    .pub     = "\x55\x6b\x3e\xe7\xcd\x0d\x37\x97\x90\x56\xec\xc1\xf5\x6a\x56\x77\xa4\x93\x5b\xe6\xe4\x9c\xe2\x8e\x39\x4f\x8b\xfb\x73\xd1\x3b\x6a",
    .ok      = 1 },
  { .tc_id   = 353,
    .comment = "special case for C in multiplication by 6",
    .shared  = "\x88\x0f\x6d\xc7\x32\x20\x30\x7a\x59\x76\x70\xf3\x28\x2f\xc3\x66\xaa\x66\xf0\x4a\x0a\x9c\xa3\x0d\x89\x5f\xdd\xe3\x37\xaf\xe8\x25",
    .prv     = "\xe0\x2d\xba\x73\x35\xaf\x8f\xb9\x16\x8d\xe2\xfc\xd3\x10\xc2\xe2\xdf\x4a\x3e\x25\x26\x3e\x0a\xb9\xad\xa8\x7b\xfb\x82\x58\xa6\x6b",
    .pub     = "\x12\x11\xbe\x58\x09\x60\x5b\x54\xf5\x72\x7d\x23\x3c\x78\x3a\x2a\x19\x9a\x3d\xb2\x4e\xd4\x49\x9d\x7b\x48\xc7\x60\x3e\x4a\xd3\x71",
    .ok      = 1 },
  { .tc_id   = 354,
    .comment = "special case for CB in multiplication by 6",
    .shared  = "\xea\x62\xb0\xed\xa2\xd7\xb2\x49\xa4\x24\x17\x67\x5a\x2b\x82\xb1\xe6\xc0\xd6\x9a\x4e\x7c\xef\x33\x64\x48\x84\x4d\x2f\x43\x22\x51",
    .prv     = "\x30\xce\x71\xf8\x56\xce\xb8\x74\xfe\x58\x00\x39\xca\x67\xe8\x96\xe6\xd0\x82\x07\xa7\x3c\xd5\x5d\xb7\x05\x91\x27\xc1\x34\x2b\x67",
    .pub     = "\x50\x5e\x78\x51\xe2\x35\x2e\x31\x1c\xa9\x53\x6a\x1f\xe6\xc0\xd9\x5d\x64\x81\x97\x37\x4c\xe0\x8e\x4b\x8a\x0f\xbd\xdf\x62\x91\x0b",
    .ok      = 1 },
  { .tc_id   = 355,
    .comment = "special case for CB in multiplication by 6",
    .shared  = "\x30\x2c\x4f\x83\xb5\xc5\xbf\x30\xc1\xe3\xaf\xd9\xf6\x43\xf6\x5b\xfe\x56\xca\x16\x28\xee\x04\x2b\x1a\xb7\x39\x3b\xaf\xe3\x6c\x06",
    .prv     = "\xe8\x81\xf4\x6d\x41\x41\xea\x69\xa6\x71\x64\x9b\x93\xb6\x3e\x97\xdc\x67\xc1\x25\x21\xd4\x45\x86\x2f\x08\x7b\x26\x26\xfa\x2b\x6f",
    .pub     = "\xdd\xf4\xe9\x05\x03\xdd\x82\x61\x0c\x3a\x03\x4b\x92\x5a\x88\x0b\x72\xdb\xde\x30\xc6\x26\x00\x92\x02\xb3\x58\xc6\xeb\x00\xf4\x18",
    .ok      = 1 },
  { .tc_id   = 356,
    .comment = "special case for CB in multiplication by 6",
    .shared  = "\x8f\xf2\xac\x65\xc8\x5e\xe2\xfe\x94\x52\xfc\xe4\x60\xf8\xc8\x7f\x95\x70\xd7\x69\xca\xdd\xdc\x87\xfe\x93\xef\x8b\x76\x57\xc7\x26",
    .prv     = "\xe8\x79\x75\x26\x83\xcd\x73\xa8\x34\x25\x1c\x65\x74\x91\x35\xe0\x6e\xb9\x06\x4d\x3a\xe3\x50\x95\xd8\x8c\xde\x14\xa0\x2b\xa3\x66",
    .pub     = "\x0e\x9c\x44\x31\x99\x9e\xf1\xce\x17\x7e\x90\x0d\x37\xec\x6a\xe6\x65\xe3\x87\xe2\xd4\xfa\x27\xcb\xa8\xe7\xba\xeb\xc6\x5c\x65\x20",
    .ok      = 1 },
  { .tc_id   = 357,
    .comment = "special case for CB in multiplication by 6",
    .shared  = "\x97\xc9\x1a\x23\xc3\xe4\xf3\xff\x72\x7d\x18\x8a\x35\x2b\x67\xad\x49\x0b\x62\x38\x15\x66\xfb\x3e\x11\x1c\xb6\x7a\xa9\xe3\x43\x5c",
    .prv     = "\x20\x57\x6a\xb4\x56\xda\x26\xc1\x8d\xa5\xfb\xf0\x6e\xc4\xd1\x65\x64\xe1\x11\xbf\xae\x2a\x92\xb9\xf6\xe1\x92\x7c\x15\x77\x0a\x62",
    .pub     = "\x57\x61\xd6\xc0\x86\x24\x10\x4d\x41\x17\xff\x17\xc7\x5e\x92\x11\xa5\x91\xc9\xca\x9a\xec\xca\x3a\x66\x5a\x7e\xd8\x44\x19\x52\x25",
    .ok      = 1 },
  { .tc_id   = 358,
    .comment = "special case for CB in multiplication by 6",
    .shared  = "\x24\x34\x6b\xb1\x33\xdd\x9a\xe3\xff\x02\xd2\xf5\x05\x10\xb3\xa9\x2d\x90\x30\x83\x4d\x60\xe5\xaf\x08\xb0\xee\xbb\xf1\xd4\xdd\x6f",
    .prv     = "\xa8\x46\x74\x18\xb9\x24\xc2\xc0\x03\xc5\x6e\x16\x10\xa3\x54\x69\x35\x63\x60\xc2\x9d\x52\xaa\x55\x7a\x2b\xb3\x0f\xb8\xa9\xa4\x64",
    .pub     = "\xe9\x2d\x45\xb3\xec\x56\x53\x12\x66\x30\x3c\x51\x13\xc4\x63\x10\xc4\x16\x50\x00\x10\x65\xb4\xd8\x7b\x02\xb3\x82\xfc\x82\x66\x2e",
    .ok      = 1 },
  { .tc_id   = 359,
    .comment = "special case for CB in multiplication by 6",
    .shared  = "\xb3\x45\x3c\x9c\x82\xa2\xd1\xd9\x56\x15\x6d\xe2\x39\x9c\xb7\x0d\xd4\xe1\xec\x53\xae\xa9\x67\xe0\x35\x75\x3c\x1c\xda\xe1\x3c\x39",
    .prv     = "\xf0\xf5\xe1\x62\x92\x3d\x7c\x29\x93\x88\xbe\xd7\x81\x19\x94\x17\xad\xe0\x97\x47\x55\x15\x16\x2d\x95\x90\x97\x6a\x19\x6f\xb1\x6f",
    .pub     = "\xf3\x8b\x63\x45\x9d\x05\xe4\x22\xad\x02\x4c\x2d\xce\xa5\x02\x9a\x0a\x7a\x6b\x6c\x4c\x1d\x20\x93\xce\x55\x6a\xab\x33\x1e\x25\x40",
    .ok      = 1 },
  { .tc_id   = 360,
    .comment = "special case for CB in multiplication by 6",
    .shared  = "\xeb\xeb\x0c\x7b\x7a\x41\x65\xcd\x02\xa2\x78\xf3\xa2\x22\xc2\x36\xee\xd8\x32\x66\xb8\x06\xd1\x34\x94\xc1\xc3\xf9\x8a\x2f\x34\x25",
    .prv     = "\x60\x8f\xcf\x78\x7f\xe7\x89\x64\x4a\x09\xbc\xab\x95\x8f\x07\x37\xaa\x81\xa9\xe2\x9d\x50\x5f\x51\x03\x5c\x78\xe3\x74\xb9\xe4\x6b",
    .pub     = "\xa7\xde\xd0\xee\xa4\x5a\x40\x0b\x8f\x56\x37\x15\x4d\x42\x97\x4a\xa9\x8c\x92\x96\x23\x14\xd8\x22\xef\x88\xb0\x13\x83\xa9\xda\x4d",
    .ok      = 1 },
  { .tc_id   = 361,
    .comment = "special case for CB in multiplication by 6",
    .shared  = "\x92\x13\xa5\x3f\x22\xff\x0c\xb5\xec\xa8\x7b\x27\xb1\x93\xc7\x73\xbf\xdf\x4c\x01\xa1\x93\xa1\x1f\x37\xc1\x57\x47\x4e\x15\xcb\x07",
    .prv     = "\x58\xa3\x39\x6d\x29\x1e\xb2\x35\x71\xb5\x2d\x98\xa3\x15\x49\xe5\x14\xe5\x01\xe8\xd0\x95\x8a\xd9\xf2\x5f\xe5\xa7\x6c\x50\x3e\x69",
    .pub     = "\x7b\x0e\xcb\x4c\x72\xee\x14\x77\x89\xd7\x48\x13\xce\xd3\xeb\xe4\x0f\x45\xc3\xda\x52\x6e\xd1\x27\x29\x52\xe4\x53\xe4\x3b\x79\x6d",
    .ok      = 1 },
  { .tc_id   = 362,
    .comment = "special case for x_2 in multiplication by 6",
    .shared  = "\x66\x48\x4a\x41\x20\xe0\xeb\x0c\x7e\x05\x05\xe1\xd2\xc5\xd1\x5d\xe9\xb5\x2b\x72\xe0\x94\xc9\xba\xc8\x86\x34\x20\x0c\x55\x72\x67",
    .prv     = "\xd8\x05\xa7\x01\x47\x55\xdd\x65\x6f\x98\xd2\xb3\x31\xf2\xd2\xd4\x91\x27\x25\xef\x3d\x03\x75\x2f\x26\xf7\x4d\xc1\xad\x61\x66\x6a",
    .pub     = "\xa2\x44\x41\x3d\xdc\x3a\x20\x5d\x03\x8d\x64\x26\x68\x33\xee\xa1\xef\xba\x51\xba\x62\xc9\xc6\xcd\xcd\xbe\x94\x3b\xe5\x2b\xb0\x0c",
    .ok      = 1 },
  { .tc_id   = 363,
    .comment = "special case for x_2 in multiplication by 6",
    .shared  = "\x38\x4f\x22\x21\x61\x8e\x71\xd4\x56\xb1\x55\x16\x51\xef\xdb\x70\x8a\x16\x1d\x7f\x89\xf5\x60\x4b\x27\xeb\x87\x2d\x4a\xa9\x32\x76",
    .prv     = "\x40\xcb\x1f\xe0\x6b\x08\xf0\x68\xf7\x08\x0b\xa0\x7c\x69\x5e\xda\x91\xa2\xbe\xbe\xad\xd4\xdb\x95\xc9\x7d\xd7\xc9\x1a\xf2\x56\x6d",
    .pub     = "\xec\x3c\x8b\x0c\x10\xb1\xfa\x65\xdb\xbd\x17\xcf\x1b\xa5\xf8\x63\x81\x28\x47\x65\x70\x9b\x07\xc5\xf0\x42\x8e\x3d\x5b\xcd\x39\x20",
    .ok      = 1 },
  { .tc_id   = 364,
    .comment = "special case for x_2 in multiplication by 6",
    .shared  = "\x8d\xaf\x5f\x4b\x84\x73\x01\x44\xea\x8a\x53\xce\x39\xcc\x90\x7e\x39\xa8\x9e\xd0\x9f\x02\x02\xe7\xbe\x0d\x3b\xda\x38\xda\x66\x3b",
    .prv     = "\x80\x21\x46\x4c\x64\xc9\xd6\xd3\xc0\xc8\x52\xf6\x97\x2d\x11\x96\x9b\x04\xc9\xe0\x66\x56\x2f\xa7\xf0\xd5\xfa\x0d\x98\xeb\xad\x62",
    .pub     = "\x63\x30\xd3\xe2\x8a\x8b\x61\x26\xac\xe1\x65\xa9\xdf\xcc\xc6\xe4\xbd\x40\xdb\xc9\x76\x8c\xfb\x16\x33\x0c\xb7\xf2\x7f\x90\x62\x30",
    .ok      = 1 },
  { .tc_id   = 365,
    .comment = "special case for x_2 in multiplication by 6",
    .shared  = "\xda\x8b\x7e\xba\x6f\x72\xc3\xf3\xef\x33\xd8\x98\x20\x93\x49\x2e\x06\xbe\x39\xbb\x0d\xb2\x9c\x46\x5d\x95\xa8\xe5\x2e\xf6\x43\x41",
    .prv     = "\x70\x7a\x2d\x71\x0b\x32\xf5\x5c\x6e\xba\x34\x89\x80\x20\xa2\xfb\x98\x1d\x61\xb1\xe8\x22\xfc\xa8\x4c\x47\xd9\x32\x1e\x27\x92\x68",
    .pub     = "\x86\x78\xaa\x29\xcb\xc0\x6e\x78\xb2\x18\xd2\x2a\x3e\x66\xc3\x8e\xc0\xda\x8f\xdb\x0f\x25\x70\xc5\x85\xc6\x25\x17\xc9\x70\x4f\x37",
    .ok      = 1 },
  { .tc_id   = 366,
    .comment = "special case for x_2 in multiplication by 6",
    .shared  = "\x04\x19\xa7\x1a\x08\xd3\xfd\xd5\x74\xcb\xc9\x32\xe8\xf1\x60\x59\x33\xdd\xcd\xd9\x77\x4f\x56\x14\x26\x9b\x7e\xd8\x50\xc8\x65\x0e",
    .prv     = "\x20\x4a\x43\xde\xa7\x9d\x77\x95\x77\x58\x1b\x8c\x2a\x51\xbe\x66\xe1\xef\xfc\xe9\x64\x25\xb7\x42\x2b\x9c\xa6\x5b\xdf\x1a\x48\x67",
    .pub     = "\x30\x32\x89\xc2\xb1\x07\x9e\xa5\x94\x12\xfa\xcc\xfe\xba\x8c\x11\x3d\x22\x99\xb9\xdc\xfe\xde\xab\xc4\x26\x97\xb0\x82\x9c\x46\x58",
    .ok      = 1 },
  { .tc_id   = 367,
    .comment = "special case for x_2 in multiplication by 6",
    .shared  = "\x9f\x2f\xcd\x0c\x75\x62\x88\xc1\x71\x6e\xcd\x1f\x2a\x74\x86\x4b\x93\xa7\x71\x7b\xfa\xf5\x24\x88\x58\xdc\xb6\xfd\xbe\xa1\x28\x64",
    .prv     = "\x58\xe4\x74\x17\x35\xd2\x58\x93\x22\x15\x19\x47\xa1\xce\x2f\x58\x29\x90\x86\x26\x88\x69\x41\xcb\x16\x31\xd2\x5a\x8a\x68\x41\x69",
    .pub     = "\x3e\x6e\x16\xe0\x2d\x44\xeb\xd9\x46\x80\x83\x2e\x06\x5a\xed\xdc\xbb\x74\xaf\x64\xfb\xb7\xc6\xd8\x36\x7e\x76\x05\xbe\x13\xff\x5b",
    .ok      = 1 },
  { .tc_id   = 368,
    .comment = "special case for x_2 in multiplication by 6",
    .shared  = "\x26\x1a\xb6\x26\x7c\x35\xa9\x75\x53\x59\xe9\x57\x47\x38\x70\x52\x2b\x7f\x92\x3f\xe8\x39\xf2\xb1\x55\x40\x86\x49\xcc\x5e\x80\x04",
    .prv     = "\xd0\xaf\x34\x28\xea\x52\x05\xf6\xbf\x8d\x4f\x1b\x4e\x49\x03\xcd\x76\xf0\x42\x36\xa1\xc0\xb3\xec\xfd\xca\xf2\x8b\x21\x34\x8e\x63",
    .pub     = "\xa7\xc1\x71\x6a\x41\xed\x23\xa8\x87\x04\x38\x71\x4f\xf9\x74\x5f\xb0\xe4\x6f\x7a\x5b\xae\xb3\x7c\x9a\x2d\x83\xfe\x47\x7d\x14\x6c",
    .ok      = 1 },
  { .tc_id   = 369,
    .comment = "special case for DA - CB in multiplication by 6",
    .shared  = "\x90\x93\xbf\xa3\xed\x34\x91\xd0\x89\x1f\x02\xae\x46\x6e\x5e\x13\xc9\x80\xdf\x22\x9d\xb7\x40\x4c\x5b\x9d\x34\xe4\xed\x21\xc6\x53",
    .prv     = "\xc0\xea\x97\xe4\x42\xe5\xdc\x1c\x81\x42\xbf\xab\x70\x89\xec\xb9\xbb\x9c\x5a\xe3\x72\xf9\x90\x7c\x28\x25\xe6\x78\xde\xfa\xe5\x67",
    .pub     = "\xda\xd9\x81\x55\x2c\x57\x54\x1c\x57\xef\x39\x5e\xd7\x70\xce\x5e\xdc\x48\xf8\x01\x54\x61\xb2\xba\x7a\xa8\x31\xec\x59\x3c\xeb\x15",
    .ok      = 1 },
  { .tc_id   = 370,
    .comment = "special case for DA - CB in multiplication by 6",
    .shared  = "\x6e\x88\xbb\x6b\xf7\x55\x96\xbb\xe5\xf1\xfb\xe9\x1e\x36\x5a\x52\x7a\x15\x6f\x4f\x1b\x57\xc1\x3a\xc1\xe3\xe6\xdb\x93\x19\x12\x39",
    .prv     = "\xb0\x33\x3f\x09\xac\x1e\xaa\xcd\x3c\xd6\x17\xeb\x88\x32\xe9\xde\x48\x8b\x45\x8b\x73\x5c\xb4\xb5\x34\x5f\x51\x71\x30\xc2\x5d\x6b",
    .pub     = "\xc5\x88\xdf\xe6\xe7\x33\xd9\x05\x81\xcb\xe1\x12\x07\x97\x49\xd8\xeb\x30\xab\x86\x31\x13\x4e\xc2\x9a\xbf\xb9\x8b\x32\xe7\x65\x22",
    .ok      = 1 },
  { .tc_id   = 371,
    .comment = "special case for DA - CB in multiplication by 6",
    .shared  = "\xe6\xde\x74\xd2\xc5\xce\xa5\x40\x94\xd7\xa7\x0a\xf0\x3c\x76\x8a\xfe\x05\xd5\x2a\x03\x8b\xb7\x2d\x56\xdc\xac\xf0\xba\x50\x2d\x74",
    .prv     = "\x10\x71\x90\x99\xdc\x63\xbc\xc2\x82\xef\x52\x58\x45\xc1\x08\x89\x7a\xc9\xfa\xe9\x59\x0b\x59\x3e\x0d\x50\x5d\x1c\xf1\x67\xc0\x61",
    .pub     = "\x06\x70\x11\x6a\x43\x5e\x8d\x9b\x7a\x12\xff\xc4\x32\x2f\xd6\xb1\x49\xd0\xb1\xdc\x79\x9b\x5c\x09\x57\xd9\xd6\xe4\x25\x46\xe8\x24",
    .ok      = 1 },
  { .tc_id   = 372,
    .comment = "special case for DA - CB in multiplication by 6",
    .shared  = "\x78\xc9\xc3\xaf\xf9\x41\x6a\x53\x8c\xe3\xea\x8f\xa5\x53\x24\x45\x28\xd1\xfb\xec\xbc\xf9\x16\x95\xa3\x3c\xa4\x64\xef\x76\xb8\x5a",
    .prv     = "\x10\xe2\x0e\x4f\xda\x57\x08\x4c\xa9\x0f\x7a\xd5\x72\xa7\x8a\xa8\xe6\x57\x5c\x65\x9c\xd0\x1f\x30\xc4\x3c\x58\x04\x0c\x20\xe8\x60",
    .pub     = "\x8b\x20\x0d\xd2\x26\xc5\xc0\xf7\xe1\x16\xe5\x38\x8b\xa1\x62\x43\x8c\xaf\x1d\xdd\xf4\xed\xc3\xb6\xba\x83\x8c\x21\xb5\x92\x97\x37",
    .ok      = 1 },
  { .tc_id   = 373,
    .comment = "special case for DA - CB in multiplication by 6",
    .shared  = "\xc1\xa9\x6c\xcb\xa0\x8b\xdd\x82\xd0\xfc\x12\xe8\xcd\xe4\xcc\x1f\x25\xcf\xd5\x27\x6d\xce\x7f\x18\xe4\x07\xed\x0e\x4a\x89\x84\x66",
    .prv     = "\xa8\x31\x2d\xf4\x73\xad\xfe\xc7\x17\x1e\x16\x35\xf5\xba\xd4\x4f\x07\x53\xa8\x8a\x6b\x31\x74\xec\x5a\xe7\x62\x70\x3a\xe2\x5e\x60",
    .pub     = "\x41\x9a\x07\x6b\x17\x9f\x79\x72\x00\x96\xea\xab\xaf\x03\x47\x7e\x8f\x89\xd6\x1f\x88\x5c\x8d\x7f\x58\xf6\xea\xa4\xfa\x77\xdf\x5f",
    .ok      = 1 },
  { .tc_id   = 374,
    .comment = "special case for DA + CB in multiplication by 6",
    .shared  = "\x25\x33\xb8\x45\xbb\x83\xe3\xd4\x8c\xff\xa8\xdb\xd1\xed\xd5\xd6\x01\x77\x86\x62\xd5\xda\x03\x75\x91\x52\xa5\xe0\xa8\x4b\x35\x7d",
    .prv     = "\x10\x96\x97\xf4\x00\x21\x0f\x9a\x92\xde\x80\xa8\xbe\xd2\x64\x09\x71\x99\xbc\x24\x0e\x22\x76\x7b\x54\xd8\xbb\x22\x05\x0b\x7a\x61",
    .pub     = "\xaa\x34\xd7\x72\xe9\xac\xe4\x3c\x4d\x92\xf4\xf8\x55\x96\xab\x9c\xcd\x8c\x36\xc4\xf4\xcb\xdd\xc8\x19\xaf\xe2\xa3\x3c\xb8\xb2\x16",
    .ok      = 1 },
  { .tc_id   = 375,
    .comment = "special case for DA + CB in multiplication by 6",
    .shared  = "\xeb\x40\xa3\x97\x4b\x1b\x03\x10\xb1\x59\x7d\x1f\x1f\x41\x01\xc0\x8d\xca\x72\x74\x55\xa9\xd8\x22\x4c\xd0\x61\xa7\xaa\x3c\xb6\x28",
    .prv     = "\xd0\x36\x30\x8a\x53\xc1\x1b\xeb\xcb\x02\xe8\x36\x88\xad\x74\xfe\xc4\x3f\x84\x62\xef\x4d\x80\x62\x72\x67\x66\x37\xd9\x9b\x37\x65",
    .pub     = "\x1f\x06\xcf\xe4\x64\xcc\xc0\xe2\x7a\x5e\xc5\xf9\xed\xd9\xbc\x7b\xc8\x22\xad\x2f\xf5\x06\x8c\xa5\xc9\x63\xd2\x0e\xdd\x1a\x2d\x22",
    .ok      = 1 },
  { .tc_id   = 376,
    .comment = "special case for DA + CB in multiplication by 6",
    .shared  = "\x95\x09\x75\x7e\x28\x95\x53\xcf\xa2\xcc\x71\x31\x34\x73\xc3\xff\x1e\xeb\xce\x48\x4e\xe2\x37\xea\xe5\x54\xfd\xa3\xd3\xd2\x2f\x0e",
    .prv     = "\x78\x6e\x5a\x5f\xf3\x74\x05\xc7\x69\xd0\xd3\x78\x8c\x3c\x1b\x05\xa6\x2a\x84\x42\xc3\x85\x57\x0e\x44\x38\xbc\x5f\x2e\xaa\xcd\x67",
    .pub     = "\x9d\x4b\x2e\xd7\x81\x71\x32\xaf\x58\x30\xe8\x99\x62\x7e\xa9\x7d\xc3\x9b\xd3\x77\x2e\x82\xf2\xd0\x57\x69\xa9\x18\x27\x3d\xc0\x2e",
    .ok      = 1 },
  { .tc_id   = 377,
    .comment = "special case for DA + CB in multiplication by 6",
    .shared  = "\xba\xd9\xf7\xb2\x7d\xac\x64\xb0\xfc\x98\x0a\x41\xf1\xce\xfa\x50\xc5\xca\x40\xc7\x14\x29\x6c\x0c\x40\x42\x09\x5c\x2d\xb6\x0e\x11",
    .prv     = "\xc0\x1f\x66\xcb\x09\x42\x89\xd7\x28\x42\x1d\xd4\x6c\x6f\x97\x18\x41\x2e\x1c\x54\x6d\xad\x70\xe5\x86\x85\x1b\xe4\xda\x58\xbf\x67",
    .pub     = "\x4e\x05\x6b\x31\x7a\x31\xdd\x96\xf8\xec\x14\xb4\x84\x74\xaf\x58\x7d\x19\x5e\xfc\xc2\xa7\x0f\x01\xf0\x52\xef\x88\x2d\x7b\x3a\x45",
    .ok      = 1 },
  { .tc_id   = 378,
    .comment = "special case for DA + CB in multiplication by 6",
    .shared  = "\x51\xc3\x59\x76\x8a\xb0\x21\x90\x03\xaf\x19\x3e\x2b\xdb\x8e\x5c\xc9\xf8\xe1\x76\xb8\xdb\x49\xe5\x97\xaf\xca\x3e\x71\x25\xe3\x70",
    .prv     = "\x38\x77\xd9\xce\x25\xce\xde\xde\xb5\x72\x60\x4f\x2d\x12\x3d\xf6\x85\x69\x0c\x26\xe1\x81\xf7\x77\xed\x33\x30\x2b\x82\x08\x29\x66",
    .pub     = "\x72\xc6\x05\x35\xe9\xc4\x23\xf3\x02\xd6\xa1\x07\x96\xd9\x54\xd7\x78\x03\x2c\xd4\xdb\xd4\x0c\xa0\xf3\x59\xe2\x04\xd6\x7b\x6f\x4c",
    .ok      = 1 },
  { .tc_id   = 379,
    .comment = "special case for DA + CB in multiplication by 6",
    .shared  = "\xfa\x9f\xb0\xdf\x4c\xfb\xac\xd0\xfb\xf3\x26\x2d\x3a\x1b\xf8\xd7\xaa\xcb\x45\xf7\x3b\xf9\x46\x71\x77\x5e\x50\x9c\x80\x43\xdf\x7d",
    .prv     = "\x50\xb8\x46\x18\xd0\x73\xc4\x61\x8f\x9a\xa6\x9a\x3b\x85\x18\xda\x76\xdb\xb2\x12\x72\x86\x21\x4f\xb4\x3a\x2b\x44\x50\x3b\x99\x69",
    .pub     = "\x58\x56\x35\x8e\xd4\x20\x04\x7c\xd0\x84\xf1\x7a\xe6\x96\xba\xd7\x9a\x4d\x26\xc6\xd5\xbb\x79\xbf\xb8\x2b\xbc\x63\x32\x44\x2d\x51",
    .ok      = 1 },
  { .tc_id   = 380,
    .comment = "special case for DA + CB in multiplication by 6",
    .shared  = "\x91\xac\x72\xb0\xed\x8d\x7f\xc4\xc8\x84\x6b\x8a\x25\x30\xd9\xfb\x8f\x05\x32\x06\x48\x80\xc0\x0d\xab\x10\x0c\x97\x76\x97\xdb\x28",
    .prv     = "\x10\x9a\xcf\xa6\x38\xe1\x12\xf6\xbb\xec\x21\xe3\x52\xa7\x4e\x8f\xc9\xb7\xff\xe5\xd9\xdc\x28\x63\x4e\xeb\x51\x6e\x59\x83\x0a\x63",
    .pub     = "\xc3\x1e\x37\xb0\x43\x32\xab\xca\x83\x15\xf3\x17\x17\x15\x66\xae\xf3\x81\x11\xf6\x22\xd8\xbf\xfa\x29\xc2\x3c\x01\x51\xcd\xad\x6e",
    .ok      = 1 },
  { .tc_id   = 381,
    .comment = "special case for z_2 in multiplication by 6",
    .shared  = "\x11\x39\x3b\xb5\x48\x81\x3e\x04\xfb\x54\x13\x3e\xdb\xe0\x62\x64\x58\xe8\x09\x81\x88\x5e\x1f\xe5\xf3\x37\x7e\x8e\xbe\x9a\xfa\x52",
    .prv     = "\x68\x5c\x07\x84\xaa\x6d\x19\x4c\x1b\x85\x9b\xda\x44\xc4\xe2\x7c\xd1\xdf\xdf\x34\x77\x6e\x49\x8d\xd0\x3d\x09\xf8\x7a\xe6\x8a\x65",
    .pub     = "\xb7\x75\xe0\x16\xb3\x2a\x97\xf4\x99\x71\x12\x19\x06\x76\x3f\x3a\x0b\x41\x68\x90\x92\xb9\x58\x3b\x67\x10\xcf\x7d\xee\x03\xa6\x1c",
    .ok      = 1 },
  { .tc_id   = 382,
    .comment = "special case for z_2 in multiplication by 6",
    .shared  = "\x0a\x83\xa2\x24\xfb\xfc\xbc\x5d\x0f\x07\xf6\xdd\x8e\xbb\x2e\x9b\xbe\xe8\x13\x4f\x0f\xab\x26\x80\x02\xce\x83\x7f\x54\x95\xd8\x33",
    .prv     = "\x18\xe9\xa0\x5a\x20\x43\x6c\xf0\xdb\xc3\xd5\xb9\x2d\xac\x8d\x99\x6e\x62\xea\x11\xfb\xb3\x44\x5f\x29\x19\x5f\xc7\x5a\x8b\xeb\x69",
    .pub     = "\xf8\xbd\x0e\x7c\xf6\xec\x61\x86\xf2\x05\xab\x03\xab\x72\xc8\xf6\xb3\xcd\xe8\xf6\xad\x9b\x16\x69\x16\xa0\x4d\x43\xd1\xd6\xd5\x46",
    .ok      = 1 },
  { .tc_id   = 383,
    .comment = "special case for z_2 in multiplication by 6",
    .shared  = "\x45\xdc\x39\x83\x1f\x34\x71\xd7\x46\x6b\xbe\x29\xc8\x14\x2b\x1a\x6d\x6b\x00\xc4\x7f\xea\x02\x1b\xe2\xff\xc4\x52\xd9\x04\x68\x06",
    .prv     = "\x00\xe0\x99\xeb\x23\x12\x5d\xab\x5e\xc3\x5a\x41\x9d\x45\x5d\x0b\xa8\xc0\x1d\xa1\x60\xf9\x35\x4e\x9f\xb2\x1e\x6a\x55\xd5\x5c\x64",
    .pub     = "\x8d\xfe\xe4\x8a\xd8\xb3\x67\x48\x8e\xa4\xda\xfc\xf7\x08\x6e\x30\x53\x56\xa8\x09\x01\xf8\x7c\x72\x01\x49\xa5\xf5\x22\x33\x74\x53",
    .ok      = 1 },
  { .tc_id   = 384,
    .comment = "special case for z_2 in multiplication by 6",
    .shared  = "\xa2\x90\x05\xc6\xb9\xdb\xf1\x70\x7d\xc2\xad\xce\x45\x06\xb5\x58\x31\xe8\x67\x5b\x7d\x2d\x54\xb0\xc1\x03\x77\x41\xe3\xbc\x61\x1b",
    .prv     = "\xb0\xca\x25\x1e\x0d\xba\xe7\x32\x4a\x6c\xa0\xc2\xc8\xd6\xa8\x88\xed\xd1\x2d\x14\x47\xd4\x00\xa4\x7b\xcb\xa0\x04\xb6\x48\x71\x6e",
    .pub     = "\x8f\x68\xbf\xc5\x7d\x79\x2c\x32\x2e\xbb\x27\xf4\x4a\x37\xc1\xc9\x3e\x7e\xb1\x5c\x5d\x5f\xce\xdf\xfc\x1d\xe8\x50\x48\x7b\x33\x72",
    .ok      = 1 },
  { .tc_id   = 385,
    .comment = "special case for D in multiplication by 6",
    .shared  = "\x9f\x04\xe4\x2c\x1b\x2f\x31\x1d\x87\xe1\x47\x0a\x47\x08\xbb\xa2\x5a\xc6\xff\xd3\xf7\xb4\x86\xf9\xb6\xb5\x02\xec\xbb\x2c\x00\x4e",
    .prv     = "\xa8\xb6\x4b\x8e\xd3\x97\x77\x3b\x82\x90\x42\x5c\xa5\xc2\xf7\xc3\xe5\x0f\xac\x7a\x47\x81\xbd\x4a\x54\xc1\x33\x78\x1c\x9a\x13\x60",
    .pub     = "\xff\x0f\x15\xad\xea\xb3\x34\xaf\xed\xa3\x91\x67\x85\xdd\xd3\x8d\x25\x2d\xce\x98\x76\xc2\x35\x7b\x64\x3b\x5d\xc2\xc0\x6a\x3b\x1d",
    .ok      = 1 },
  { .tc_id   = 386,
    .comment = "special case for D in multiplication by 6",
    .shared  = "\x68\x80\x00\xbd\x60\xaf\x37\x5b\x4e\xea\xc4\xa7\xd0\xe0\x78\x2c\x0e\x61\x88\xea\xbd\xc6\x08\xb7\x32\xf4\x9b\x4d\x6c\xca\xb4\x4f",
    .prv     = "\xd0\xcd\x0d\xb5\x1f\xf2\x32\xaf\xa0\x91\x9d\x31\x06\xfc\xb3\xa8\xae\x58\x1e\xf1\x2d\x09\xc8\x77\xaa\x6f\x31\xef\x74\xee\xd0\x68",
    .pub     = "\x10\x76\xfd\xc8\x27\xf2\x55\x0e\xe9\x5f\xf9\xa1\x5d\x04\x4a\xed\xfa\xc6\x5b\x5e\x9b\xa8\x09\xf6\x24\x38\xcc\xea\x54\x63\x7a\x29",
    .ok      = 1 },
  { .tc_id   = 387,
    .comment = "special case for D in multiplication by 6",
    .shared  = "\xe0\xa8\x2f\x31\x30\x46\x02\x4b\x3c\xea\x93\xb9\x8e\x2f\x8e\xcf\x22\x8c\xbf\xab\x8a\xe1\x0b\x10\x29\x2c\x32\xfe\xcc\xff\x16\x03",
    .prv     = "\x20\x4a\x3b\x56\x52\x85\x4f\xf4\x8e\x25\xcd\x38\x5c\xab\xe6\x36\x0f\x64\xce\x44\xfe\xa5\x62\x1d\xb1\xfa\x2f\x6e\x21\x9f\x30\x63",
    .pub     = "\xed\x1c\x82\x08\x2b\x74\xcc\x2a\xae\xbf\x3d\xc7\x72\xba\x09\x55\x7c\x0f\xc1\x41\x39\xa8\x81\x4f\xc5\xf9\x37\x0b\xb8\xe9\x88\x58",
    .ok      = 1 },
  { .tc_id   = 388,
    .comment = "special case for D in multiplication by 6",
    .shared  = "\x1f\xcc\x50\x33\x3e\xb9\x07\x06\x93\x5f\x25\xb0\x2f\x43\x7b\xfd\x22\xb6\xb1\x6c\xc3\x75\xaf\xff\x8a\x1a\xa7\x43\x2f\xb8\x62\x51",
    .prv     = "\x88\x10\x9b\x1d\x0e\x7b\xac\xe4\x4d\x41\xa1\x5d\x5b\xcb\xcd\x36\x96\x8c\x5b\x8b\x47\xc0\xa2\xc6\x06\xb5\x7c\x4a\x68\xcc\x5f\x66",
    .pub     = "\x12\xe1\x58\x9a\x34\x09\x4a\xf5\xf1\x21\xc9\xbd\x3c\x11\x19\xf2\xb1\xf0\x52\x64\xc5\x73\xf6\x67\xa7\x48\x68\x3c\x56\x33\xa4\x7e",
    .ok      = 1 },
  { .tc_id   = 389,
    .comment = "special case for DA in multiplication by 6",
    .shared  = "\xfa\xc3\x0a\x74\xf4\xca\x99\xf6\xcf\x23\x30\x65\xe9\xac\xd8\x26\x69\x0c\xab\x36\x4b\xf6\x93\x20\xb5\x80\x95\x78\x3e\xd7\x6e\x11",
    .prv     = "\x50\x82\xe4\x97\xc4\x29\x79\xcd\xbf\xdd\x1b\x3b\x06\x53\xcf\xea\x6f\x2c\xeb\x7d\x07\x63\x9e\xbf\x35\x41\x86\x6b\xb6\x0e\xdb\x62",
    .pub     = "\x15\x1f\x54\xa8\xa8\x99\x71\x17\x57\xb3\xb1\x18\xfc\x55\x01\x77\x9d\x62\x1d\x25\x22\x7a\xf5\x3d\x0a\xf0\x0b\x75\x83\xba\x88\x24",
    .ok      = 1 },
  { .tc_id   = 390,
    .comment = "special case for DA in multiplication by 6",
    .shared  = "\x17\xf6\x54\x3c\x47\x27\xe7\xf1\x29\xee\x82\x47\x76\x55\x57\x76\x35\xc1\x25\xa2\x0c\x3d\xc8\xba\x20\x6c\xa3\xcc\x48\x54\xca\x6c",
    .prv     = "\xf8\x5a\x8d\xb4\x4f\x9e\x56\xb1\x17\x29\xf5\x16\x82\xa9\x76\x9f\xc5\x04\xf9\x35\x97\xcb\xe3\x94\x44\x61\x6b\x22\x45\x32\x10\x6e",
    .pub     = "\xa8\x19\xc6\x67\xed\x46\x6b\xd9\xa6\x9e\xa0\xb3\x86\x42\xee\x8e\x53\xf4\x0a\x50\x37\x7b\x05\x1e\xb5\x90\x14\x2d\xd2\x7e\x34\x31",
    .ok      = 1 },
  { .tc_id   = 391,
    .comment = "special case for DA in multiplication by 6",
    .shared  = "\x88\x9a\x8d\x61\x1e\x0a\x7d\xa7\x14\x75\xe7\xc9\x3a\x2d\x7f\x6f\x72\x28\xc7\x87\xa0\x0e\xe5\xcf\x55\x47\x4a\xdc\x37\x6f\xf7\x62",
    .prv     = "\x50\x5a\x07\x66\x41\xfa\xc3\x98\xfc\x7d\x8c\x62\x99\x37\xf4\x2d\xb5\x59\xdb\x5e\x12\x05\x2a\xd3\x66\xd4\x6d\x7b\x20\xe9\x57\x69",
    .pub     = "\x40\xb0\x53\xd0\x56\x66\x89\x82\xa1\xf5\x50\xbe\x95\xe1\x63\x48\xe3\x03\x94\x5f\x53\xa3\xac\x64\x49\x1a\x9a\x56\xd4\x09\x5b\x71",
    .ok      = 1 },
  { .tc_id   = 392,
    .comment = "special case for DA in multiplication by 6",
    .shared  = "\x37\x23\x2f\xb3\x97\xaf\x27\xf5\xfb\x5c\xa4\x93\x28\x4f\xf1\xc5\xd2\x57\x86\xb0\xd7\x16\xc7\x3b\x33\xac\xa8\xd4\x22\x65\xf3\x18",
    .prv     = "\xe8\xdb\x2b\xf1\xaf\x5b\x89\x07\x42\x07\x89\xc5\x6e\x71\x41\x47\x06\xae\xf0\xd9\xf6\xff\xae\xd0\xc2\x49\xc3\xb7\xab\x14\xbf\x65",
    .pub     = "\xe7\xdd\x05\x49\xa7\x65\xbb\xef\x34\xbe\x2e\x8d\xa1\x8a\x1b\xc1\xb9\x89\xa8\xb0\x61\x4d\x35\x8e\xbf\x38\xc1\x2a\x9c\xa6\x40\x79",
    .ok      = 1 },
  { .tc_id   = 393,
    .comment = "special case for z_2 in multiplication by 7",
    .shared  = "\xa1\xb3\x04\x18\x43\x6b\xa1\x90\x88\x04\xff\xcc\xe1\xbe\x2c\xdc\xf5\x0c\x61\xa8\xe3\x93\x8d\x95\xc7\x90\xab\xdb\x78\x6b\x80\x22",
    .prv     = "\xc0\x06\xab\x17\x62\x72\x08\x82\x01\x7d\x10\x6b\x9a\x46\x75\xfd\xd4\x70\x05\x65\x71\x55\xc9\x0c\xa6\x1d\x4c\xbf\x7c\xc4\xf9\x73",
    .pub     = "\x1e\xe1\xb9\xa7\x46\x04\xac\x31\xc3\xdb\x83\x28\x01\x70\xe3\x81\x15\x04\xfc\xc7\x8c\x76\x26\xb5\xb2\xc0\x7a\x99\xd8\x0d\xaa\x0a",
    .ok      = 1 },
  { .tc_id   = 394,
    .comment = "special case for z_2 in multiplication by 7",
    .shared  = "\xa5\x97\x6f\xda\x89\x95\x4a\x81\xe4\x42\x10\x7f\x9e\x41\x6a\x2b\x4b\x48\x1b\xbd\x46\x54\xeb\xc0\xc7\xb5\x7a\x78\xb4\x5b\x49\x79",
    .prv     = "\xd0\x71\x80\x7d\x60\x79\x53\xda\x43\x2d\x85\x74\xd5\xf3\xf4\x20\x67\x6d\xaf\xdb\xc6\xa2\x85\xa3\x6e\x1d\x73\x76\x24\xd7\x7c\x75",
    .pub     = "\xf2\x26\xc2\xd6\xbd\x78\x31\xed\xa1\xb5\x1e\xe5\xae\xc2\x94\x43\xa5\x07\xef\x9f\x7a\x04\xe2\x34\x0f\x34\x9d\xbf\x14\x93\x38\x44",
    .ok      = 1 },
  { .tc_id   = 395,
    .comment = "special case for z_2 in multiplication by 7",
    .shared  = "\x55\xb5\xb5\xeb\x38\xb1\x27\x61\x7f\xfe\x00\x05\x6d\x84\xd3\x5a\x50\x71\xd1\x87\x83\xe3\xa8\x2b\x5f\x4e\x13\x1b\x15\x38\xb1\x50",
    .prv     = "\x30\x4b\x52\x6f\x6f\xe9\x94\x73\x19\x80\xc0\x97\x55\x29\xbc\xa4\xd0\x61\x01\x7f\xbe\xc5\x6f\x60\x70\xd4\x26\x78\xd3\xe1\x11\x77",
    .pub     = "\xc5\x19\x73\x12\xde\x3a\x7a\x3e\xe1\x1b\x29\x87\x3b\xae\x3f\xc8\xc8\x51\x09\xc6\x67\x84\x80\x4f\x89\x43\x5d\xb2\x10\xfc\xc2\x4b",
    .ok      = 1 },
  { .tc_id   = 396,
    .comment = "special case for z_2 in multiplication by 7",
    .shared  = "\x00\x80\xe5\xb9\x98\x5a\x96\x0a\x83\x21\x33\x81\x2a\x7a\xb9\x95\x1c\x6b\x2c\x75\x89\x4d\xeb\x3e\x35\x50\x91\x90\xa6\xbd\xf4\x57",
    .prv     = "\x98\x2d\xdf\x2c\x03\x57\x89\x37\x9b\x8a\x58\x91\x7d\x5c\x3c\x6c\x06\x1b\x50\x3b\x19\xa0\x02\x8e\x01\x89\x4c\x2e\xb3\x71\xd0\x79",
    .pub     = "\x59\x0e\xd0\xb8\x79\x31\x9c\x38\xa1\x99\x62\xa5\xd2\x16\xff\x2b\xfa\xf3\x35\x55\x51\x88\x77\x96\x9c\x20\xc0\x54\xcb\xe4\x3e\x56",
    .ok      = 1 },
  { .tc_id   = 397,
    .comment = "special case for z_2 in multiplication by 7",
    .shared  = "\x52\x41\x22\x22\x26\x63\x8c\x4b\xbb\xc9\x87\x92\xcd\xbd\x74\x88\x2c\xa2\xe0\x8a\xa2\xed\xf3\x13\x07\x04\x25\x03\x10\x09\xe9\x25",
    .prv     = "\x78\xcc\x3e\xc0\x68\x7e\x3e\x53\xd9\xce\xc5\x6b\x79\xd1\x1b\xf0\x49\xd1\x73\xf1\x27\xf5\xb4\x0f\xae\x12\x2a\x6d\x00\x16\xcd\x76",
    .pub     = "\x7c\x5f\x01\x43\xa6\x68\x2f\x60\xcc\xad\x16\xf2\x11\x50\xc7\xbb\x5b\xc6\xf8\x07\x25\x4d\x08\xb3\x53\xfc\x96\xce\x07\xbc\xeb\x6f",
    .ok      = 1 },
  { .tc_id   = 398,
    .comment = "special case for BB in multiplication by 7",
    .shared  = "\x63\x78\x81\x90\xb1\x0d\x74\x51\xf5\xfc\x2b\x82\xc4\x21\x15\x1d\xb4\xf3\xe2\x27\x82\xe3\x92\xda\x6d\x8d\x3a\xba\x2c\x34\x43\x06",
    .prv     = "\xc8\x6f\xc7\x66\x50\xcf\x3b\x58\x83\x7a\xa0\xf0\x63\x35\x60\x41\x52\x41\xc6\xc4\xf8\xf2\x93\xba\x02\x22\xb7\xd6\xa3\x87\x57\x73",
    .pub     = "\x01\x08\x50\xa0\x97\x4d\x3e\x89\xc0\x29\xd2\x52\xb4\x6f\x73\x95\x48\x29\x4c\x0f\x9a\x23\x18\x38\x63\xf9\x45\x5b\x95\x59\xc2\x11",
    .ok      = 1 },
  { .tc_id   = 399,
    .comment = "special case for BB in multiplication by 7",
    .shared  = "\xe4\xb4\x09\x74\xa1\x66\xac\x49\xed\x83\x17\x15\xc0\x71\xc7\x51\x75\x27\x44\xb8\x91\x46\x5e\x6c\x45\x00\x18\x55\xaa\xcd\xc3\x62",
    .prv     = "\x88\x8d\x51\xc0\xa2\x23\x03\x69\xe5\xb6\x5a\x81\x4b\x32\x13\xdd\xe2\xe6\x2f\x2e\xb9\x5d\x09\x71\x48\x6b\x73\x3e\x4f\x90\xc1\x74",
    .pub     = "\xad\x1d\xd8\x2c\x23\xd6\xa0\xd5\xfe\x0f\x2a\x45\x61\xd1\xc1\x67\x33\xa3\xe1\xe6\xaf\xa6\xd9\x02\xdd\x07\x7d\xc4\x3a\x96\x16\x28",
    .ok      = 1 },
  { .tc_id   = 400,
    .comment = "special case for BB in multiplication by 7",
    .shared  = "\x51\x4a\x4c\xd0\x67\x6f\x1c\x31\x01\xc8\xc4\x5c\x17\xad\x41\x6b\xd3\x3e\x20\xa4\x05\x54\x4f\xc1\xa6\x04\x49\xab\xb2\x2f\xa1\x04",
    .prv     = "\x68\xbe\xd4\x25\xd5\x34\x31\x55\x84\xd8\x0f\x79\xda\x6e\xab\x9b\x7e\x60\x36\xb5\x1f\xe6\x2e\x1a\xd9\x33\xe2\x66\x64\x0b\x46\x73",
    .pub     = "\xd0\xc0\xd6\x39\x3c\x41\xf4\xd7\xe0\xd5\xe8\x50\xb7\x71\x6f\x40\x1e\xda\x1e\x02\x8a\x4e\xd4\xa0\x5b\xea\x8b\xf8\x1a\xcf\xd9\x30",
    .ok      = 1 },
  { .tc_id   = 401,
    .comment = "special case for E in multiplication by 7",
    .shared  = "\xed\x83\xe8\x10\xce\x5f\xf0\x86\x8f\x85\x89\x62\x3b\xb1\x34\x78\xde\xc1\xc2\x23\x26\xc9\x27\x65\xae\x5e\x48\xc8\x4b\xba\xbb\x24",
    .prv     = "\x98\xff\x28\x56\xef\x44\xb4\xfa\x14\xd8\x67\x82\xea\x79\x38\x28\xbd\xf6\xf1\xef\x9b\x66\x9c\xac\x1a\xae\x33\x8a\x7b\xb6\x93\x76",
    .pub     = "\x0f\x46\x01\x00\xd8\x8a\x1d\x31\x6d\xff\x02\xd1\xb2\x2f\xfb\x2e\x42\xd9\x9d\x0b\x92\x47\x4f\xc3\xec\x7d\x62\x56\x7d\x0c\xf1\x12",
    .ok      = 1 },
  { .tc_id   = 402,
    .comment = "special case for E in multiplication by 7",
    .shared  = "\xff\x94\x86\x21\x17\xd3\xc6\xed\xc9\xdd\x5f\x48\x52\xfa\x8a\x58\x94\x52\xb9\x24\xca\x8a\x75\xcb\x23\xb3\xd6\x8d\xfe\xd8\x8c\x4b",
    .prv     = "\xb0\xcd\xbf\xdd\x98\xbd\x98\x8d\x7c\x6a\x53\x04\x55\xc5\x1c\x57\xdd\x33\xfd\x2c\x7a\xee\x39\x61\x97\x1b\xd3\xa3\x13\x88\xfc\x71",
    .pub     = "\x13\x75\x6a\x41\x1f\xf3\xae\x0c\x39\x22\x2d\xde\x08\x10\xf0\x8c\x43\x24\x63\x16\x2d\x81\xef\x06\x10\x71\x24\x9a\x48\x43\x9e\x15",
    .ok      = 1 },
  { .tc_id   = 403,
    .comment = "special case for E in multiplication by 7",
    .shared  = "\x1c\x94\x86\x8b\xc8\xac\xb3\x13\x74\x98\x20\x9b\x28\x12\xfe\xb5\x35\x01\x38\x9f\x5a\xa3\x7f\xec\xbf\xd5\xcb\x54\xe1\x35\x8e\x0e",
    .prv     = "\xe0\x67\x76\x44\xed\x49\x35\xf0\x1e\x05\x2e\x99\x67\x30\x2d\x0f\xb7\x8f\xf2\x2b\xb9\x2f\xba\xe0\x60\x5f\x3e\xe5\x4e\x2f\x68\x78",
    .pub     = "\x8f\xc1\xfa\xe9\x69\xa6\x18\x54\x04\xdb\x22\x74\x9e\xf6\xd2\x25\xde\x86\x77\x3a\x4d\x1b\xf3\x85\x7e\xb8\xfb\xbd\x82\x9a\x1b\x47",
    .ok      = 1 },
  { .tc_id   = 404,
    .comment = "special case for E in multiplication by 7",
    .shared  = "\xad\xbf\x3b\x43\x9b\x16\xdb\xc6\x53\x57\x8f\x53\x37\x4e\xd3\xa8\x6f\x9c\x0b\xf1\xf7\x36\x57\x33\x49\x77\x3b\xc3\xb8\xd6\x07\x34",
    .prv     = "\x88\x7b\x61\x55\x38\x43\xca\x99\xad\x1c\xa9\x22\x53\xa6\xfe\x08\x2b\x82\x49\x47\x52\x51\x3f\xd5\x3f\xf6\x53\x0f\x54\xc4\x05\x72",
    .pub     = "\x7b\xab\x08\x91\xec\xb9\xe7\x2a\x15\x77\x1f\x0a\x4f\xff\x90\x54\x70\x24\x20\x63\x39\xc3\x40\xb1\xa2\xfd\xb5\x3b\xcf\xb8\x6b\x59",
    .ok      = 1 },
  { .tc_id   = 405,
    .comment = "special case for AA in multiplication by 7",
    .shared  = "\x39\x52\xef\xb9\x35\x73\xae\x9c\xe2\x16\x2d\x10\xe4\xb8\xc4\x64\x35\x85\x9f\x3f\x27\x78\xdb\x89\xf7\x2b\xc5\x79\xe6\x95\xcb\x51",
    .prv     = "\x00\x61\x5e\x46\x97\x01\x4f\xc1\x24\x84\xef\x53\xa1\x44\x02\x06\x41\x0a\x8d\xf7\x8c\xaa\x0b\xff\xf8\x21\x61\xdb\x83\xfe\xa5\x74",
    .pub     = "\x10\x2e\x95\xea\xdc\xa7\xc3\xc2\x8e\x5d\x52\x33\x6c\x85\x7b\xad\x99\xea\x24\x6f\x29\x9b\x06\x33\x4f\x40\x12\x76\xf4\x9c\xa8\x14",
    .ok      = 1 },
  { .tc_id   = 406,
    .comment = "special case for AA in multiplication by 7",
    .shared  = "\x96\x12\x8f\x92\x9f\xc0\x3c\x12\x69\xd4\x29\xf6\x09\xa1\xa8\xac\xac\x7a\x75\x8e\x34\x46\xa1\x25\xec\xf4\xa3\x59\xa0\xe3\x7b\x73",
    .prv     = "\x58\x17\x51\x13\x55\x0f\xaa\xd5\x64\x58\xfb\x37\x5a\x6c\xb3\xf0\x5d\xf2\xf6\xff\x3c\x4e\xe0\x9d\x4a\x6b\xa6\x43\xe0\x22\xd1\x7a",
    .pub     = "\x35\x48\xc1\x6b\xf3\x1a\xfd\xcd\x44\x5a\xd9\xbe\xf0\xe6\x0d\x7b\xd6\x19\x5a\xa5\x91\xca\x8c\x82\x81\x3c\xd7\xd4\x46\x22\x67\x20",
    .ok      = 1 },
  { .tc_id   = 407,
    .comment = "special case for AA in multiplication by 7",
    .shared  = "\xfe\xc3\xe9\x4c\xb5\xf3\x16\x62\x5b\x09\x0c\x2c\x82\x08\x28\xce\x0f\x3e\xe4\x31\xe8\xd6\xe1\x2a\xbc\xcc\x7e\xf2\xbd\x0b\xe8\x1a",
    .prv     = "\x00\x97\x38\xe1\xe6\xef\xef\x9e\x2c\xad\x8b\x41\x6f\xe9\x0a\x09\x8e\xb5\xcb\x01\x99\xf2\xdf\x52\x18\x16\x6c\x7b\x18\x1e\xa0\x79",
    .pub     = "\xba\x74\xe7\x66\xd4\x48\x55\xec\x93\xbd\x44\x1a\xa4\x10\x58\xa4\xc4\xad\x2b\xe6\x3c\x63\x9a\x3f\x9a\x87\xbd\xe5\x1e\xea\xba\x20",
    .ok      = 1 },
  { .tc_id   = 408,
    .comment = "special case for AA in multiplication by 7",
    .shared  = "\x96\x90\x3b\xac\x9d\xc6\x0b\x61\x78\xd7\x34\x89\x0c\x25\xdb\x4b\xed\x9e\xa4\xdb\xcf\x6f\xcb\xcd\xc9\x0e\x6f\x56\x94\xc8\xb2\x1c",
    .prv     = "\xc8\x20\x19\x15\x9b\xe7\x92\x74\x7a\x39\xf3\x88\xea\x48\xa8\xc5\x68\x59\x4e\x33\x83\x27\x3e\x51\x10\x07\x21\xb3\x76\xe8\xba\x73",
    .pub     = "\x9a\x5a\x1d\x37\xe5\x01\x0c\x35\x6a\xa8\x0a\xfb\x34\x7c\x3d\x61\x35\x42\xdd\xfa\x0b\xe7\xab\xb8\xe8\xcd\xcd\x66\x74\x41\x14\x49",
    .ok      = 1 },
  { .tc_id   = 409,
    .comment = "special case for AA in multiplication by 7",
    .shared  = "\x50\x05\x0d\x0a\xb1\xdd\xd2\xdd\x90\xc4\x60\xab\x8f\x09\xe1\xf8\x0e\x37\xca\xe5\x7d\x42\x31\xad\xae\x10\xc1\x0a\x4a\x2b\x00\x3e",
    .prv     = "\x10\xac\x9f\x83\x83\x26\x2e\xf2\x80\xfa\xac\x1e\x4d\xa1\x5a\x7d\xe4\xf2\xcb\x74\xaf\x33\xb5\x0e\x0d\x82\xdc\xb8\x5d\x8b\xcb\x70",
    .pub     = "\x63\x08\x47\xe2\x82\x74\xdb\xae\x54\x91\x21\x03\x03\xc8\x5a\x35\x90\x74\xee\x74\x29\x57\xb0\xfc\x3c\x9f\xf5\x5d\x9e\x01\x9a\x50",
    .ok      = 1 },
  { .tc_id   = 410,
    .comment = "special case for AA in multiplication by 7",
    .shared  = "\x91\x70\xc4\xc6\x28\xd5\xfc\xfd\x0e\xc7\x19\xcf\x6e\x17\x96\xda\xb0\xa6\x9e\x46\xd6\x37\x9f\xff\xa2\x47\xd4\x44\xa0\x05\x60\x41",
    .prv     = "\xb8\x4c\x09\x83\x82\xf6\xe3\x7d\x51\x0c\xc3\x3e\x62\xdd\xc6\x64\xe0\x2c\x8b\xb6\xed\x9e\xd0\xe5\xfa\x78\xcc\x09\x9a\x26\xfe\x73",
    .pub     = "\x11\x74\x9b\x00\xa4\x50\x67\xaf\x2c\x7e\x7d\x50\xf8\xd1\x78\xd5\xa9\xfe\xdb\x8f\x1b\x69\xb2\x39\x76\x38\x85\xbc\x61\x1b\x13\x6c",
    .ok      = 1 },
  { .tc_id   = 411,
    .comment = "special case for AA in multiplication by 7",
    .shared  = "\xd7\xd2\xa8\x29\x53\xf6\x80\xce\xe0\xc8\x1c\x4d\x00\xfe\x62\x8a\xc5\x30\xce\x68\x2e\xb7\xfb\x3b\x0a\xf2\x4f\x80\x4a\x58\xef\x5c",
    .prv     = "\x78\xcd\xe8\x93\x0a\x1d\x81\xae\xf6\x60\x1f\x71\x40\x97\x28\x85\x49\x87\x57\x8b\x0f\x83\x49\x58\x8c\x04\xad\xbe\x2c\x1f\x6e\x74",
    .pub     = "\xdf\x10\x21\xd8\xf9\x59\x50\xaf\xde\x77\xc8\x6b\xa5\xee\x2f\x58\x76\xef\x77\x83\x76\xa7\xfd\xc7\xef\xb8\xdf\xf0\xe4\x83\x6e\x7b",
    .ok      = 1 },
  { .tc_id   = 412,
    .comment = "special case for x_2 in multiplication by 7",
    .shared  = "\xa6\xb9\x7d\xa9\x89\xdc\xcf\x73\x0f\x12\x2d\x45\x51\x52\x32\x80\x51\xc8\xed\x9a\xbc\x18\x15\xc1\x9e\xec\x65\x01\xd6\xcf\xc7\x7c",
    .prv     = "\xb0\xfe\x7b\x06\xb9\x95\x06\x00\xb3\xa7\xce\x1d\x7b\xb2\xa1\xd9\x84\x19\x4c\xc9\xd6\xc8\x96\x45\x04\xc3\x64\xdd\x5c\x87\x5b\x74",
    .pub     = "\x27\x43\xba\x40\x8d\x5f\x68\xc6\x53\x24\xa4\x85\x08\x6a\x00\x4b\x6b\xbf\x78\x4c\xc9\xe8\xb1\xa7\xdb\xeb\x8c\x4b\x94\x14\xb0\x18",
    .ok      = 1 },
  { .tc_id   = 413,
    .comment = "special case for x_2 in multiplication by 7",
    .shared  = "\xb2\x10\xe3\x68\x72\x95\x01\xd9\xf9\xb6\xeb\xef\xbe\xba\xe3\x8f\x19\x5f\x91\xea\xf2\xa5\xa3\xa4\x92\x88\xbb\x61\x5f\xf2\x21\x6c",
    .prv     = "\xf0\xc9\xc3\x98\x48\x54\xd5\xbd\x59\x9d\x38\x19\x73\x8a\x02\x3e\xb7\x95\xe9\x35\x86\xdc\x0e\x5e\x29\xb1\xc8\x70\xc6\x12\xd1\x78",
    .pub     = "\xcc\x27\x5a\x2c\xdd\x91\x25\xe5\x2f\x20\xce\x2a\xba\xd4\x1f\x92\x0a\xfa\x5a\x64\x3f\xb7\xf2\x76\xef\x41\x6f\x76\x1d\x68\x9f\x1e",
    .ok      = 1 },
  { .tc_id   = 414,
    .comment = "special case for x_2 in multiplication by 7",
    .shared  = "\xb9\xe3\x79\x6c\x58\x70\x1d\xed\x42\x37\xc5\x29\x94\x50\x1c\xee\x14\xe1\x8f\x2f\xb0\x2b\x78\x1a\x84\x00\x92\x34\x84\xbd\x4a\x6c",
    .prv     = "\x90\x6c\x2f\x12\xbe\x89\x70\x2d\xb2\x6f\xa7\xee\x90\x5c\xe3\x65\x25\xd2\xde\xe4\xe9\x6a\x87\x9c\xa0\x7d\xa0\x97\xa6\xaa\x50\x75",
    .pub     = "\x49\x29\x54\x31\x01\xee\x7a\xe2\x39\x05\x9c\xd1\x34\xc3\x5d\x40\x0e\x50\xd0\x82\x14\x41\x35\x1d\x0f\xa6\xc3\xd5\x4e\xfb\x34\x2e",
    .ok      = 1 },
  { .tc_id   = 415,
    .comment = "special case for x_2 in multiplication by 7",
    .shared  = "\x6d\xcd\xf8\xe8\x69\x03\xb0\xca\xde\xd1\x24\xd8\xa7\xda\x18\xe6\x23\x43\x0c\xa8\x69\xaa\xf2\x67\xd3\x10\x29\xd9\x3d\xe9\x9e\x66",
    .prv     = "\xf0\x26\x03\x1e\xa3\x73\xe1\xd1\x6e\x6e\x7e\x03\x57\xbc\x96\xbc\x09\x3f\x4b\x6b\xb7\x6a\x73\x8c\xbb\x54\xfe\x6c\xfd\x2e\xa2\x71",
    .pub     = "\x13\x24\xe0\x36\x85\x97\xb3\x18\x15\x55\xbb\x5b\x2c\xc7\xb7\xeb\xba\x46\x93\x1a\xea\xbb\x6f\x05\xab\xab\xd4\x24\x0f\x0f\xb9\x33",
    .ok      = 1 },
  { .tc_id   = 416,
    .comment = "special case for x_2 in multiplication by 7",
    .shared  = "\x38\x5d\xdb\xf2\x50\x5e\xbf\x53\x7b\xf5\xe9\x76\xb6\x1a\x4b\x69\xd1\x90\xae\x96\x5b\x7e\x4a\x81\xae\x4e\x1c\x16\xb7\x14\x87\x48",
    .prv     = "\x70\x3f\x4a\xc8\x66\x7d\x77\xf9\x53\x60\x45\xcf\x74\x8f\x18\xd4\x23\x45\xe3\x9c\xca\xb1\x0c\x18\xdd\xe0\xf5\x17\x0d\x30\x7f\x73",
    .pub     = "\xc7\xf3\x84\x22\x97\xd6\x94\x1c\xac\x63\xd6\xf1\xbd\xae\xa0\x70\x94\x37\xc8\x2d\xbc\x91\x61\xfc\x1b\xae\x6c\x79\xd6\x68\xeb\x44",
    .ok      = 1 },
  { .tc_id   = 417,
    .comment = "special case for x_2 in multiplication by 7",
    .shared  = "\x0f\xba\xea\x73\xf9\x51\x87\x95\xe0\x26\xc1\xfc\x10\x79\xc3\x73\x8a\xeb\x9e\xe9\xc8\xdc\x97\x61\xd6\x5b\xbf\x8f\x94\xe3\x01\x54",
    .prv     = "\xc8\xa9\x6a\xe4\xe7\x72\x71\xa0\x68\x0d\xd2\x4f\xcb\x09\xf9\xc5\xd3\xee\x83\x16\x53\x6e\xec\x7c\xc2\x27\x65\x97\xe5\x0f\xe3\x7f",
    .pub     = "\x1e\x46\x60\xba\x86\x5f\xb8\x08\x5a\xfd\x46\x92\x88\x5d\x74\x23\x7f\xa3\xbc\xa5\xaf\x4b\x84\xba\x3d\xe4\x00\xf1\x6a\x5a\xc4\x5c",
    .ok      = 1 },
  { .tc_id   = 418,
    .comment = "special case for x_2 in multiplication by 7",
    .shared  = "\x51\x0c\x64\x15\x1e\x5d\x07\x37\xfc\x32\x4b\xd1\x5f\xb5\xd3\x96\x69\x08\x75\x1c\xd1\xa0\x69\x54\xb5\x56\x19\x66\x55\xee\x55\x40",
    .prv     = "\xd0\xdd\xe8\xed\xa3\x8c\x37\x83\x44\x28\x64\xc0\xcb\x46\xa0\xe9\x83\x2d\xcf\x78\x4c\x21\x26\x8a\x21\xbe\xd2\xca\xce\x87\xcd\x70",
    .pub     = "\x24\x88\xbb\x6f\xad\xb7\x9d\x46\x58\x5f\xf0\x1c\x16\x0c\x5b\x41\x72\x79\x9d\x92\xbd\x16\x8e\xdc\xeb\x65\xce\xde\xdc\x49\x27\x62",
    .ok      = 1 },
  { .tc_id   = 419,
    .comment = "special case for x_2 in multiplication by 7",
    .shared  = "\x23\xef\x82\x5e\x1c\x8e\x6e\x64\x42\x80\x01\xa7\x46\x3e\x32\xa9\x70\x1c\x81\xcf\x78\x20\x3e\x6a\xe7\x53\x74\x0c\x91\x57\x0e\x6b",
    .prv     = "\xc0\x9c\xd4\x7e\x1c\xe5\x36\x04\xf1\x4e\x4e\x13\x42\x6c\x8f\x08\x96\x2f\x55\x6b\xcd\x81\xf8\xd7\x53\x75\xb1\x50\x7c\x6f\xda\x78",
    .pub     = "\xa0\xc1\x08\x78\x11\xaf\x14\x91\x17\x1b\xc5\x16\x91\xb8\xca\x84\x71\x6a\xf3\x6c\x4b\xaa\x76\x4e\xc5\x36\x28\x0c\xc1\x98\x3d\x6d",
    .ok      = 1 },
  { .tc_id   = 420,
    .comment = "special case for x_2 in multiplication by 7",
    .shared  = "\x0e\x55\xa7\xec\x1a\x2d\xdb\xea\x1a\xc5\x98\x12\x00\x81\x22\x32\xf7\xf4\xc3\xa6\x0e\xe3\xc9\xab\x09\xf2\x16\x3b\xd1\x3d\xa3\x29",
    .prv     = "\xe0\x9a\x5f\x74\xf3\x18\xf0\x23\x03\x85\x7a\xa0\x20\x8d\x76\x91\x3d\x9e\x24\x0a\x80\x54\x9d\x12\x01\x31\x18\xba\xd6\x20\x59\x7f",
    .pub     = "\xcc\x5c\x97\x93\x46\x07\xd8\xb9\x81\xbc\xe1\xd6\xa2\x32\xbb\x3a\xec\xc3\x00\x1f\x69\x8a\xe1\xae\x84\x93\x8f\xbf\x28\x61\x07\x7b",
    .ok      = 1 },
  { .tc_id   = 421,
    .comment = "special case for DA - CB in multiplication by 7",
    .shared  = "\x06\x81\x03\x6a\x0d\x27\x58\x3b\xa6\xf2\xbe\x76\x30\x61\x31\x71\xa3\x3f\xb8\xa6\xc8\x99\x1c\x53\xb3\x79\x99\x9f\x0f\x15\x92\x3b",
    .prv     = "\x70\x6c\xee\x5f\x9b\x35\x7c\x03\xb2\xf1\x91\x32\x94\xf6\xe4\xf0\xca\x5a\x19\x0a\x87\xd3\x02\x68\x32\x7d\x0c\xb6\xbd\xd5\xbc\x79",
    .pub     = "\x23\x8d\xe7\xfc\xc8\xa3\xf1\x94\xc3\x55\x4c\x32\x8e\xfb\x12\x15\xd0\x64\x0a\xc6\x74\xb6\x1a\x98\xef\x93\x4e\xc0\x04\xcf\xd7\x3b",
    .ok      = 1 },
  { .tc_id   = 422,
    .comment = "special case for DA - CB in multiplication by 7",
    .shared  = "\x67\xb8\x87\x74\xf1\x9b\xd1\x08\x1d\x6f\x23\x65\x6a\x13\x58\x03\xe3\x4a\xe1\xcd\xca\xe1\x08\x18\x12\x4a\x78\x56\x9c\x29\x9f\x42",
    .prv     = "\x40\xe3\x00\xcb\x1f\xf2\x60\x57\x4f\x85\xb3\xf0\x4a\xac\x47\x84\x64\xa8\x6e\x62\x03\xb3\xd4\x65\x64\x18\xf4\x30\x51\x57\x87\x7b",
    .pub     = "\xac\x9f\xd8\x0a\x45\xda\x10\x9f\xa2\x32\x93\x90\xe5\xa9\x51\xcf\xc0\x30\x65\xd7\xbb\x4a\x78\x55\x82\x6c\xcb\x22\xc3\xbf\xeb\x3d",
    .ok      = 1 },
  { .tc_id   = 423,
    .comment = "special case for DA - CB in multiplication by 7",
    .shared  = "\xa5\x12\xe8\x64\xbd\x89\x8a\x5b\xa6\x55\x1a\xdc\xeb\xd8\x36\xc6\xa7\x8e\x78\x71\x72\x8e\x1b\x8e\xe5\x28\xd4\x83\xaf\x27\x61\x04",
    .prv     = "\x88\x2f\x78\xb4\x55\x8b\x7f\xaa\x83\x59\x04\xc9\x23\x5e\x32\xf3\x00\xfc\x8b\x5e\xf0\xa7\x18\x40\x6a\x5c\x85\x20\xca\x54\xd0\x71",
    .pub     = "\xa4\x5a\xb1\xdc\x2f\xa2\xc5\x07\x18\xfb\x49\x85\xd9\x79\x14\x01\xe8\xd2\xd3\x4f\xfe\x3c\xd9\x3c\xff\xb4\xe8\x70\xcc\xe5\xe8\x55",
    .ok      = 1 },
  { .tc_id   = 424,
    .comment = "special case for DA - CB in multiplication by 7",
    .shared  = "\x51\x8b\x77\x8c\xf5\xe9\x76\xc6\x02\x35\xab\xcf\x62\x11\xa1\x8b\xad\x2a\x8e\x69\x3a\xb2\x61\x07\x4c\x7f\xab\x43\xdb\xb5\xda\x27",
    .prv     = "\xd8\x64\x9b\x73\x55\x90\xa1\x7d\x0f\xc4\xc3\x78\xfb\xf4\xc2\xf7\xd6\x60\x05\x69\xb2\xe8\x4c\xbe\x0f\xf7\xbc\xdb\xac\x0b\x5f\x71",
    .pub     = "\x17\x61\xd3\xd5\x0b\xa4\x6b\x44\x66\x55\xaa\x6a\x8d\x9b\x8b\x75\xaa\x5b\xb2\x4a\x79\x53\x20\x8d\x5b\x69\xfc\xc3\x8f\x18\xec\x7a",
    .ok      = 1 },
  { .tc_id   = 425,
    .comment = "special case for D in multiplication by 8",
    .shared  = "\x6c\xfa\x93\x5f\x24\xb0\x31\xff\x26\x1a\x7c\xd3\x52\x66\x60\xfd\x6b\x39\x6c\x5c\x30\xe2\x99\x57\x5f\x6a\x32\x22\x81\x19\x1e\x03",
    .prv     = "\xa8\xed\xec\x59\xae\x6b\xa2\x38\x13\xec\x54\xd6\x6d\xf1\x52\xe0\x62\x67\x62\xb9\x7d\x4b\x0c\x20\xe0\xdd\x8a\x56\x95\xd8\x6e\x47",
    .pub     = "\xdc\x99\xad\x00\x31\x46\x3e\x45\x37\xc0\x1e\x16\x62\x99\x66\xd1\xb9\x62\xc0\xb4\xe4\x87\x2f\x06\x7c\xa3\xc2\x6c\xcc\x95\x70\x01",
    .ok      = 1 },
  { .tc_id   = 426,
    .comment = "special case for D in multiplication by 8",
    .shared  = "\xc6\x23\xe2\xd2\x08\x3f\x18\x11\x0a\x52\x5f\x2b\x66\xd8\x9e\xd8\x2d\x31\x3b\x6a\x2d\xd0\x82\xf6\xb7\xa6\xe7\x33\x13\x4f\x5a\x06",
    .prv     = "\x10\x98\x72\x3f\xfe\x56\x7e\xa6\xdc\xc8\xd0\x4e\xcc\x01\xef\xaf\xee\xa0\xae\xe4\x4e\x1c\x73\x3b\xe8\xb1\xe5\xd9\x7c\x8b\x80\x41",
    .pub     = "\xb3\x27\x50\xfd\x80\xd2\xd7\xc6\x2c\x6b\x8e\x39\x67\x06\x54\xba\xea\x57\x19\xa3\xe0\x72\xe9\x95\x07\xfd\x5b\xcb\x23\x89\x82\x64",
    .ok      = 1 },
  { .tc_id   = 427,
    .comment = "special case for D in multiplication by 8",
    .shared  = "\x38\x8e\xa4\x21\x65\x0a\x8d\x83\x7b\xad\x89\x04\x01\x81\x95\xe9\x9e\xf4\x94\xc2\xd1\x70\xb9\x3e\xe7\x21\xa6\x7d\x2c\x10\x87\x29",
    .prv     = "\xa0\xf2\x0d\xf9\x8b\x49\x21\x8a\xc8\x32\xf2\x6f\xa8\xc2\x18\xa0\xd6\x87\x2e\xb7\xae\xa0\x7c\x1d\x43\xc9\xff\x69\x9b\x46\x5b\x47",
    .pub     = "\xe7\xb3\x20\x57\x77\xb3\x75\xf1\xb1\x51\x5a\x50\xa1\x6a\x60\x67\x95\x3f\xf2\x21\xe1\x2b\x4f\x41\x6d\x74\xfb\x28\xc1\xc8\x58\x65",
    .ok      = 1 },
  { .tc_id   = 428,
    .comment = "special case for DA + CB in multiplication by 8",
    .shared  = "\xb9\xe5\x72\x8b\x37\x43\x5b\x1d\x33\x99\x88\xf9\x32\x67\xd5\x9f\x3b\xd1\xc5\x17\x85\x1c\x5a\x25\x8e\x74\xcb\x64\xae\xa7\x3d\x2d",
    .prv     = "\x30\x47\x3a\x77\xa9\x83\x74\xf6\x7d\x5b\xd4\x3d\xf2\x31\xce\x14\x29\x16\xae\xa0\xd2\x71\xe7\x23\x33\xfa\x47\xdc\x44\x1a\x02\x47",
    .pub     = "\x21\xcc\x33\x8d\x78\x69\xe5\x86\x33\x49\xcc\x73\x9c\x8a\x69\x46\xcf\xc7\x97\xcb\x82\xfb\xf6\x2d\xcd\x21\x54\x84\x4b\x10\x60\x03",
    .ok      = 1 },
  { .tc_id   = 429,
    .comment = "special case for DA + CB in multiplication by 8",
    .shared  = "\x20\xb6\x7b\x20\x5e\x22\xce\x87\xfd\x44\xa8\xe8\xfd\x10\xa6\xd8\x89\x0b\x92\x70\xb6\x0e\x1c\x6a\x68\xb4\xaa\x78\xe6\xe3\x79\x61",
    .prv     = "\xd8\x65\x7b\xe3\xa3\x0f\xc8\x5f\xb2\xf3\xa6\x8e\x92\xac\xe1\xb3\x1b\x26\xe7\x6e\x6b\xdb\x67\x27\xae\xa5\x07\xcb\x7c\x10\xdc\x45",
    .pub     = "\xc3\x42\x17\xc0\x20\x72\xd7\xe2\xbc\xa0\x45\x45\x25\x03\x07\x80\xcf\xb6\x02\x15\xd7\xca\x82\xdb\xec\x8f\x4a\x59\x03\x4c\x5f\x43",
    .ok      = 1 },
  { .tc_id   = 430,
    .comment = "special case for DA + CB in multiplication by 8",
    .shared  = "\x5f\xab\xa6\x45\xfc\x21\xf9\x42\x1e\xbd\x35\xc6\x9b\xdb\x1d\x85\xb4\x6f\x95\xe3\x74\x6f\xf7\xf4\x88\x6b\xc2\x80\xa9\xab\x25\x22",
    .prv     = "\x88\x2f\x55\x78\xae\x4a\x13\xd8\xf5\xaf\x47\x3b\xdd\xe1\x70\x9b\xf2\xe0\x59\xdf\x80\x9e\xe0\x5b\x50\x5f\x34\xde\x85\x7c\x34\x47",
    .pub     = "\x8a\xbb\x8c\xfd\x60\xc6\xf8\xa4\xd8\x4d\x07\x50\xd3\xb4\x0a\x4f\x84\x6b\x30\xed\xf2\x05\x2f\xef\x7d\xf8\x41\x42\xcd\x0d\x9e\x47",
    .ok      = 1 },
  { .tc_id   = 431,
    .comment = "special case for DA + CB in multiplication by 8",
    .shared  = "\x9c\xb8\xa0\xf4\xad\x86\xa2\x7b\x96\xca\x61\x24\x2e\xab\x19\x8d\xb2\x76\x7d\x38\x62\xdd\x32\x3e\x41\x36\x8f\xcd\xcc\x5f\xab\x68",
    .prv     = "\x98\x29\x4d\xb7\xcb\xf4\x95\x8b\xfb\x3e\xd2\x1d\x5d\x5c\x91\xe1\x3c\xc8\xdc\x27\xb3\xc7\x16\xc8\x6f\x71\x67\xa4\x81\x9f\x87\x41",
    .pub     = "\x9f\xd7\xb4\x9a\x08\xf2\x06\x68\x8d\x72\xdb\x73\x7d\xf8\xe5\x17\xaa\x7b\x76\x4f\x5d\xe7\xc9\xa2\xb1\xc3\xfc\xba\xa9\x85\xf6\x4c",
    .ok      = 1 },
  { .tc_id   = 432,
    .comment = "special case for DA + CB in multiplication by 8",
    .shared  = "\x4b\x42\xfc\xf8\x4b\x51\xb2\xb8\x2f\x1f\x70\xb3\xcf\x49\xbd\x9d\xc6\xab\x26\x72\x92\x0a\x8d\xe3\x7e\x81\xba\x7e\x99\xac\xf7\x34",
    .prv     = "\x78\x9b\xc4\x04\x7a\xd8\x1b\x9b\x66\x56\xee\xf2\x98\xb7\x66\xe8\x76\x3a\x2f\x8e\xa6\x4e\x37\x4a\x60\x3d\xc1\xfd\xf2\xee\xe1\x46",
    .pub     = "\xc4\xfe\xfa\xc7\xac\xd4\x48\xe8\xfd\x4d\x6a\xc4\xf5\xdd\x1b\xc2\x1f\x2c\x67\xd6\x38\x44\x40\x60\x91\x8f\xb3\x44\xaa\x77\xe7\x57",
    .ok      = 1 },
  { .tc_id   = 433,
    .comment = "special case for DA + CB in multiplication by 8",
    .shared  = "\xe5\x5f\xc9\x31\x66\x9b\xd0\x2d\x1c\x64\x68\x9e\xda\x62\x64\x82\x12\xb1\x07\x8c\x43\xb5\xca\xf9\x7c\xf9\x76\x3f\xf8\x7a\x34\x55",
    .prv     = "\x80\x1f\xfe\x4e\x0f\x6e\xeb\x8a\x50\xc8\xfe\x79\x66\x3f\xf5\x85\xf9\xd6\xae\xbc\xfb\xf4\xb7\xed\xc6\x76\xc6\x93\x90\x0c\xb1\x41",
    .pub     = "\xa8\x34\x1d\xee\xcc\x0b\xe6\xdb\x11\x40\x1e\xf7\xf8\x84\xac\x3a\xde\x35\x65\x0c\xc2\x1f\x14\xb5\xcd\xb0\xa5\xcf\x0e\xe6\xb1\x5a",
    .ok      = 1 },
  { .tc_id   = 434,
    .comment = "special case for DA + CB in multiplication by 8",
    .shared  = "\x87\xf7\x97\x6a\x17\xf3\xe0\x3a\x7f\x1e\xb7\x4e\x6d\xb9\x50\xb8\xc0\x99\x4f\x40\xb7\x90\x34\x95\x59\x9d\x22\x77\x25\x80\x9e\x01",
    .prv     = "\xe0\x4e\x41\x23\x83\xa6\x3b\x33\x8b\x70\xe1\xbe\x5f\xd7\x59\x95\x35\x03\x21\xde\xe4\x28\xaa\x4f\x3b\xa6\x2a\x50\xa3\xb0\xde\x44",
    .pub     = "\x55\xa0\xe6\x63\x1a\x52\xf2\x9f\xb9\x0a\x17\x77\xcc\xbc\x69\xff\x94\x54\x74\x59\xd5\x41\xf7\x2e\x83\x16\xe4\xd6\x16\x53\x5a\x67",
    .ok      = 1 },
  { .tc_id   = 435,
    .comment = "special case for DA + CB in multiplication by 8",
    .shared  = "\x3b\xb3\xe3\x01\x05\xa7\x19\x01\xb1\x15\x06\x5e\x39\xbd\xb3\xe0\x53\xd3\x87\xb3\x90\x27\xb1\x2c\x92\xcd\xf4\xc6\x38\xad\xf0\x0d",
    .prv     = "\x38\x2d\xbe\x9f\x10\x15\x8b\xfb\xb7\xd1\xd7\x9a\x35\xa7\x80\x92\x14\x89\x9a\x6b\x85\x72\xb3\x5b\x55\x87\x5d\x79\xbd\x2f\x16\x40",
    .pub     = "\x79\x76\xd5\x20\xf1\xa2\x51\x2d\x56\x4a\xf4\x1c\x68\x31\x3f\x53\x51\xb0\x15\x6d\x51\x18\xbe\x48\x17\xf1\x92\x79\x8a\xe9\x77\x7d",
    .ok      = 1 },
  { .tc_id   = 436,
    .comment = "special case for AA in multiplication by 8",
    .shared  = "\xf5\xcb\x3a\x1b\x76\x18\x5a\x29\xa6\x36\x0b\x21\x42\xfe\xeb\xb1\x1f\x3d\x08\xf4\xfd\x8d\x73\xdf\x3a\x52\x28\x62\x4a\x52\x1c\x02",
    .prv     = "\x60\xc9\xaf\x7f\x4d\x03\x13\x6a\x60\x34\xae\x52\xde\xad\xfd\x9d\x4f\x27\x4a\xd8\x12\x28\x12\xeb\x92\xa5\x31\x69\xc8\x35\x41\x41",
    .pub     = "\xa2\x6a\x72\x2f\x7b\xa7\x1c\xcf\xc9\x6e\xd8\xe1\x08\xd7\xc9\xf8\x42\xd1\x7f\x92\x05\x1e\xe7\xd4\x29\xea\x7f\xa7\x90\x8a\xb9\x07",
    .ok      = 1 },
  { .tc_id   = 437,
    .comment = "special case for AA in multiplication by 8",
    .shared  = "\xb0\xb4\x78\x68\xe7\x04\x65\xee\x2d\xd7\x37\xf1\xba\x5a\x63\x99\xe0\x9c\xd8\x13\xd7\x2d\xa7\x58\x5a\xb4\x5c\x94\x6c\xc2\x8d\x4d",
    .prv     = "\x28\x3f\xae\x8b\xd8\xb2\x94\xde\x28\x48\x05\x64\x49\x75\x19\x65\xab\xb5\xc7\xfa\x86\xba\x4c\x2c\x5c\xdc\x3b\xb5\x24\xda\xd1\x40",
    .pub     = "\xca\x3a\x2d\x96\xf5\xdd\xa4\x82\xb0\x02\x32\x4c\xbb\xdc\xf1\xda\xcc\x98\x15\xea\xb7\x97\xc7\x15\x1c\x3a\x88\xc7\x5c\xde\xd6\x21",
    .ok      = 1 },
  { .tc_id   = 438,
    .comment = "special case for AA in multiplication by 8",
    .shared  = "\x58\x1e\x4b\x12\xb0\xf3\x9a\x7c\xc4\x2d\xee\x45\x13\xec\xfd\xd2\x0b\x59\x5f\x90\x5f\x17\xad\x8c\x1f\xbf\x1b\x5c\xb2\x06\x8b\x31",
    .prv     = "\x40\x15\x39\x70\x3c\xa4\x98\x0d\xb4\xba\x42\xc5\x9f\xc2\x9e\x83\xb4\x18\x9f\x2d\xde\xa5\x3b\xa5\x4c\xa9\x66\xc0\x68\x98\xa6\x40",
    .pub     = "\xee\xbd\x85\x88\x50\xb5\x6f\xeb\xb7\x07\xf2\x7a\x7a\xad\x5f\xf5\xab\x4b\x0e\x0c\x73\xb9\xc8\x6e\xc4\xca\x0f\x42\xe7\xf3\x8e\x75",
    .ok      = 1 },
  { .tc_id   = 439,
    .comment = "special case for z_2 in multiplication by 8",
    .shared  = "\x6b\xf2\x64\x53\x2f\xc7\x0a\x6a\x7e\x45\x9f\x45\x79\xec\xa6\xb8\x4f\x8f\x76\xab\x85\xc3\x26\x4b\x20\xbc\xa7\x25\xa6\xeb\x6c\x40",
    .prv     = "\xc8\xeb\x05\x62\x86\xe0\x98\xe6\xb2\xc7\x9e\x42\xf0\x07\xeb\xc6\xab\x37\x05\x34\x6c\xdb\xda\xce\x94\x9b\x5d\xe1\xe8\xc3\x67\x43",
    .pub     = "\xc8\x00\xbf\x79\x97\x83\x27\x5e\xb9\x33\x12\xb4\x3d\xc0\x32\xcc\xdf\xb0\x0a\x4b\x77\xc8\xb3\x77\x2c\xd2\xfe\xc8\xdb\x7e\x4a\x09",
    .ok      = 1 },
  { .tc_id   = 440,
    .comment = "special case for z_2 in multiplication by 8",
    .shared  = "\x69\x03\x05\xc9\xe1\x92\xcd\x8a\x51\x3f\x70\x5b\x3f\x10\x1e\xcd\xf3\xdb\x1e\xa1\x5a\x09\xc4\xa1\xbc\xe3\xa8\xcd\xc3\xa1\xa9\x3f",
    .prv     = "\x48\x78\x82\x95\x6c\x49\xc6\x9f\xd0\xe2\xd7\x27\x7a\x24\xfb\x1d\xbe\x4b\x03\x65\xb3\x6a\x13\xf6\x34\x40\x24\x8b\xca\x2f\xbb\x42",
    .pub     = "\x7b\xbc\x50\x4e\x04\xd1\x34\xee\xdc\x13\xf0\x6d\xfd\xfc\x69\xc5\x18\x25\x7a\x3f\x37\x40\x40\xa4\x9a\x8d\x21\xda\xc1\x09\x11\x0c",
    .ok      = 1 },
  { .tc_id   = 441,
    .comment = "special case for z_2 in multiplication by 8",
    .shared  = "\xc5\x85\x91\xb3\x3e\x49\x0e\x47\x66\xff\x7a\xdd\xff\x57\x0c\xe4\xe8\x9a\x98\x33\x80\x15\xa5\x5d\xf3\xd2\xf2\x32\xae\xa3\xfc\x4f",
    .prv     = "\x98\x76\x01\x0f\x4d\x64\xc7\x7f\xfc\x4d\x7d\xcc\xd7\x2b\x9a\xc8\x20\x78\xde\xb8\x83\x60\x96\x50\xb8\xcf\xf8\xa6\x86\x71\x9d\x46",
    .pub     = "\x13\x25\x33\xdb\x62\xaf\xf4\xfa\x06\xe9\x63\x14\x38\x3b\xf5\x8e\xbd\xec\x51\x83\xa1\x9f\x2e\x4c\xb1\x75\x52\xae\x19\xa3\x36\x6e",
    .ok      = 1 },
  { .tc_id   = 442,
    .comment = "special case for B in multiplication by 8",
    .shared  = "\x3d\x14\x58\x51\xb6\xff\x2b\x92\xb5\x80\x7e\xd1\xdf\x21\xeb\x50\xc9\xf2\x4c\x44\x74\xd4\x72\x1d\xb3\xab\xb7\x35\x6d\xf7\xb7\x64",
    .prv     = "\xa8\xa5\xd4\xf7\x89\x4a\x51\x95\x37\xba\xbf\xac\x73\x6d\xe3\x60\x54\xf5\x08\xda\xe4\x34\xb4\xfe\x63\xcd\x56\x33\x84\x6a\x26\x47",
    .pub     = "\xce\xb9\x0c\x56\x50\x8c\xf3\x30\xc7\xf2\x5b\xab\x42\xb0\x5b\x56\x12\xa8\x31\x06\x90\x10\x7a\xc6\x3a\x40\x4c\x0a\xde\x78\x80\x09",
    .ok      = 1 },
  { .tc_id   = 443,
    .comment = "special case for B in multiplication by 8",
    .shared  = "\x14\x01\x82\x9a\xac\x4e\x64\xbc\xfa\x29\x7a\x7e\xff\xc6\x04\x77\x09\x0d\x36\x27\xa6\x4a\x35\xb8\x72\xae\x05\x5d\x20\x91\x78\x5f",
    .prv     = "\xf8\x3e\x46\x47\xe8\x2c\x56\x0a\xa0\x82\xc5\x96\x41\xe1\x3b\xf3\x66\xbe\x8f\x24\xdc\x01\xd1\x48\x01\xe6\x78\x41\x16\x0b\xed\x47",
    .pub     = "\x66\xa0\x97\x67\xa0\xd8\x3b\xb1\x8d\x40\x4e\x12\x00\x37\x5a\x74\x5d\x1f\x1f\x74\x9d\x5d\xc6\xf8\x4a\x20\x5e\xfa\x6a\x11\xbc\x65",
    .ok      = 1 },
  { .tc_id   = 444,
    .comment = "special case for B in multiplication by 8",
    .shared  = "\xa0\xeb\xe6\x90\x8c\x54\x72\xf9\x37\x76\x9b\x9a\xeb\x31\x32\x24\x43\x7f\xc5\xd7\x3f\x4f\x86\x6f\xe7\xef\x41\xf3\x0e\x35\x9e\x09",
    .prv     = "\x58\xc6\xb9\x4b\xce\x9b\x15\xf6\x49\x46\xc2\xaa\x6a\x4e\x38\x3b\x0b\x2d\x43\x65\xb7\x99\x7e\xb2\x31\x0a\xc4\xee\xf1\x80\x31\x45",
    .pub     = "\x39\xd4\x31\x31\x63\x07\xc8\x57\x47\xbd\x2b\xcf\x4f\x9e\x0f\x88\x92\xee\x45\xdf\x15\xf7\x80\x6c\xe6\x51\x47\xd9\x7f\x50\x34\x78",
    .ok      = 1 },
  { .tc_id   = 445,
    .comment = "special case for C in multiplication by 8",
    .shared  = "\x07\x53\x8f\x1b\x65\x83\x04\x1c\x49\x49\xfa\xfa\xe3\x34\x9d\x62\xf9\xdd\x30\x2d\x3d\x86\x85\x7a\xf0\xde\xdc\x0d\x5a\xd6\x74\x1f",
    .prv     = "\x78\x6a\x97\x20\x7a\xdb\xd4\xb0\xd6\xbf\xc9\xf4\x9b\x18\x66\x0a\xd3\x60\x6c\x12\xe3\x25\x04\x4b\x86\x90\xb4\xfa\x07\x87\x46\x41",
    .pub     = "\x84\xc9\x2d\x8e\xcf\x3d\x0c\xb2\x2d\xde\x7d\x72\x1f\x04\x14\x0c\x2d\x9c\x17\x9c\xc8\x13\xce\x6c\xf8\xdb\x2d\xce\x61\x68\x88\x0d",
    .ok      = 1 },
  { .tc_id   = 446,
    .comment = "special case for C in multiplication by 8",
    .shared  = "\x12\x23\x50\x5f\xbb\x53\x4c\x1b\xc6\x10\x8e\x6b\x98\xb4\xf0\xaf\x29\xe1\x11\x58\xc0\x2d\x33\x3d\x65\x59\xbe\xec\xd6\xd3\xe5\x58",
    .prv     = "\x28\x23\x10\x21\x0e\x57\x5a\x59\x39\x3c\xf1\x9b\xbe\x6e\x24\x75\x2d\xc2\x47\x70\x6f\x1e\x00\x31\xe5\xd3\x9b\x2d\xe4\xff\xf7\x45",
    .pub     = "\xa9\xce\xdb\x9e\x94\x2a\x47\x22\x1e\x42\x96\x95\x32\x20\xd1\x00\x07\xdb\x32\x7d\x2a\xcb\x68\xda\x6e\xf3\xa4\xf8\x77\xb8\xef\x1e",
    .ok      = 1 },
  { .tc_id   = 447,
    .comment = "special case for C in multiplication by 8",
    .shared  = "\xee\x03\x18\x68\x16\x5f\x45\x6f\x75\x90\x7b\xf3\x97\x42\xb8\x20\xe0\xf8\xe6\xdf\x9f\x97\x68\xd7\x57\xd4\x08\xe1\xcc\x92\xff\x7b",
    .prv     = "\xc8\xbf\x2f\xd4\xc4\x0d\x00\xf1\x46\x5a\xad\xa6\x82\xb1\x2f\xa9\x2d\xec\x10\x34\x34\x84\xab\x62\xb8\x87\x13\x37\xde\x1d\x33\x45",
    .pub     = "\x64\xe1\xc0\xc5\xf5\x94\x05\xbb\xc6\xc7\xdb\x41\xa3\x48\x5c\xc9\xf9\x1c\x18\x3b\x0f\x2b\x7e\x18\x94\xa7\xab\xd8\xfb\xbe\xeb\x23",
    .ok      = 1 },
  { .tc_id   = 448,
    .comment = "special case for C in multiplication by 8",
    .shared  = "\xc9\x54\xfa\x7b\x04\x2c\x32\x94\x3e\x03\x19\x1e\x36\x7d\x54\xbe\x00\x85\xfa\x89\x50\xef\x2b\xec\x99\x62\x0d\xf7\x9e\xcb\xea\x4b",
    .prv     = "\xc0\x6a\x4a\x4b\x70\xf6\x13\x13\x6f\x18\xc0\xf8\x8e\x22\x45\x08\x6c\x3d\x1a\x52\x71\x72\x10\xa2\x1a\xc9\xd6\x36\x82\xf2\xe7\x40",
    .pub     = "\xa6\x8d\x2f\x55\xe6\x0e\xac\x79\x83\x92\x63\x10\xf4\xfa\xe1\x3f\x95\xb2\xbb\xf1\x40\xbe\x5e\xa9\x17\x51\x88\x4d\x90\x0a\xb4\x4d",
    .ok      = 1 },
  { .tc_id   = 449,
    .comment = "special case for x_2 in multiplication by 8",
    .shared  = "\x7c\x32\x19\xb3\xc1\xfa\xe1\xf9\x55\x90\xac\x84\x3e\xfd\x20\x84\xa1\xf4\xbd\x3e\xfa\x2f\x59\x2f\x02\x20\x32\xdb\x64\xeb\xcd\x77",
    .prv     = "\x20\x59\x6e\x1d\xc5\x65\x96\x82\x3d\x37\x69\x8d\xfa\x69\x9c\x79\x87\x4a\xae\xfd\xe7\x97\xf8\x63\xef\x92\x13\x59\x80\xfb\x20\x43",
    .pub     = "\x6d\x3c\xd6\x23\xf2\x6a\x74\x53\xfa\x05\xa0\x1a\xe7\x58\xba\x84\xd3\xc5\x8d\x93\xd6\x0c\xe3\x27\x35\xa1\x5e\x0d\x05\x3d\x5b\x12",
    .ok      = 1 },
  { .tc_id   = 450,
    .comment = "special case for x_2 in multiplication by 8",
    .shared  = "\xa3\x1f\x6b\x24\x9d\x64\xa8\x7c\x4a\xed\x32\x9c\x6c\x05\xc3\xf2\x24\x0b\x3c\xa9\x38\xcc\xdc\x92\x0b\xa8\x01\x6c\x1a\xea\xeb\x45",
    .prv     = "\x38\x14\x15\x18\xe8\xe5\xef\xa1\xd0\x31\xc6\xc4\xd9\x54\x80\x23\x9f\x6c\x30\xb8\xcc\xd8\xc7\x51\xa9\xe0\x4b\xd3\xae\xc1\x73\x42",
    .pub     = "\x8f\x19\x55\x47\x34\x6b\x3d\x53\xb7\xea\x4f\x74\x2b\x22\xf1\xef\x7b\x3c\xc0\x1a\x7d\x3d\xcd\x19\xaa\x7c\x5b\x03\xf3\x1b\xd2\x14",
    .ok      = 1 },
  { .tc_id   = 451,
    .comment = "special case for x_2 in multiplication by 8",
    .shared  = "\x4c\xff\x9f\x53\xce\x82\x06\x48\x82\x32\x9a\x18\xea\x4e\x4d\x0b\xc6\xd8\x0a\x63\x1c\x87\xc9\xe6\xfd\xc9\x18\xf9\xc1\xbd\xa3\x4a",
    .prv     = "\x20\x71\x47\xf2\xb6\x8f\xef\x1e\xfc\x10\xa0\x4f\x98\x8f\x0e\xb1\x8b\x27\x3b\x0b\x5e\xd1\x7a\xa7\xaf\x32\xc9\x04\x80\xe1\x9b\x43",
    .pub     = "\xff\xc4\xfe\x2c\x21\x27\xa3\x09\xc7\x39\x56\x56\x51\xe9\x81\x2f\x83\x4a\x86\xdb\xad\xbb\x78\x77\x69\x77\xf7\x86\xec\xdb\x02\x17",
    .ok      = 1 },
  { .tc_id   = 452,
    .comment = "special case for x_2 in multiplication by 8",
    .shared  = "\x24\x8d\x3d\x1a\x49\xb7\xd1\x73\xeb\x08\x0a\xb7\x16\xac\x8f\xde\x6b\xd1\xc3\xed\x8e\x7f\xd5\xb4\x48\xaf\x21\xbc\xdc\x2c\x16\x16",
    .prv     = "\x48\x80\x84\x53\x7b\x84\x0f\x9c\x93\xca\x57\xb3\xee\x80\x49\x14\x18\xd4\x42\x21\x11\x3e\x03\xf5\x63\x55\x30\x26\x04\xd0\x35\x47",
    .pub     = "\x84\x75\xba\xbe\xea\xb9\x98\x0d\x42\x6a\xbd\x53\x23\xdf\xb3\x35\xb2\x19\xe1\x29\xbd\xda\xe4\xd6\xce\xbc\xda\x50\x75\x4a\x68\x25",
    .ok      = 1 },
  { .tc_id   = 453,
    .comment = "special case for x_2 in multiplication by 8",
    .shared  = "\x66\xc6\xe7\x0c\xf6\x30\xbe\x90\xa2\xc8\x8f\xcd\xe7\xf5\x8c\xff\x38\x68\x66\x0f\xa9\x64\x06\xe8\xdf\x4a\xc6\x77\xdb\xd8\x5f\x50",
    .prv     = "\x28\xcf\xc1\xd0\x3f\x5c\x74\x28\xff\x3e\x20\xb1\x37\x26\x8b\x33\xcc\xc7\x4d\xb0\x35\x82\xd2\x12\x7c\x56\x6d\xf4\xac\x99\xf4\x41",
    .pub     = "\x81\xf9\x0a\x2f\x66\x33\xd3\x0c\x2b\x72\xa2\x57\x95\xd2\xa4\x94\x63\xa8\x0b\x6b\x0e\xdc\x5a\xa6\x8b\xae\x4b\xf7\x38\x18\x55\x39",
    .ok      = 1 },
  { .tc_id   = 454,
    .comment = "special case for x_2 in multiplication by 8",
    .shared  = "\x06\x28\x3f\xcf\x69\xdc\x83\xe9\x9d\x92\xe5\x33\x6f\x49\x9a\x1d\x8f\xa7\x5e\xd2\xc8\x19\xb5\xae\x6e\xa8\x09\x44\x54\x32\x4b\x27",
    .prv     = "\xc8\xe3\x7d\x10\xf3\xd0\x3d\xb3\xf4\x3e\x46\x7b\xdd\xf9\x8f\x59\x5c\xb5\x29\xad\x25\x3c\x20\xd4\x91\x28\x2d\x14\x00\xb9\xe7\x40",
    .pub     = "\x41\x62\x6e\x33\xb3\xc8\xf4\x8b\xd1\x9e\x49\xde\xd3\x07\xf2\xb6\x3b\xde\x70\x5c\x4f\x3c\xdf\x9d\x4f\x92\xbf\x37\xc4\x8c\xba\x42",
    .ok      = 1 },
  { .tc_id   = 455,
    .comment = "special case for x_2 in multiplication by 8",
    .shared  = "\x7d\x2a\xff\xb4\x33\x55\xf5\xdb\x12\x94\xda\xff\x55\xf5\x9b\x1f\x17\xe7\xd2\x5b\xca\x20\x74\x6f\x12\x48\x4d\x78\xe5\x01\x55\x17",
    .prv     = "\x00\x23\x7e\x91\x40\x6a\x7b\x4d\xb6\x1e\x78\x0c\x59\x76\xfb\xb9\x26\xcd\xac\xe2\xfb\xdf\xdb\xcf\xce\x65\xe6\xdb\xe7\x78\x2a\x42",
    .pub     = "\xeb\xb3\x2f\x78\x1c\x0e\x89\xb2\x52\xe6\x11\xf9\xd8\xf7\x9f\x85\x67\x87\x4c\x96\x65\x98\x31\x4b\x2f\x16\xaa\x44\xcf\xc0\x78\x43",
    .ok      = 1 },
  { .tc_id   = 456,
    .comment = "special case for x_2 in multiplication by 8",
    .shared  = "\xef\x8e\x78\xca\xb0\x91\xd6\x67\x88\x84\x89\xfd\x3a\x2e\xc9\x3f\xb6\x33\x42\x7d\x02\xeb\x77\xb3\x28\xd5\x56\xf2\xb2\xb0\xe2\x66",
    .prv     = "\x48\x9c\x41\x84\xa2\x3a\x8f\x5e\xec\x68\xa3\x1b\x41\xaa\x2c\x03\x92\xcd\x6f\xb1\x23\xf1\x0a\xcd\xb4\xde\x75\x29\x2b\x4b\x9a\x43",
    .pub     = "\xfa\x75\xe6\xf0\x8c\xa8\x15\xb4\xe4\x2a\xf2\x4a\x8e\x05\x7c\x9e\x00\xe8\x28\xe3\x3d\x12\xc0\xe9\x4d\x10\x12\xa7\x58\x33\x67\x44",
    .ok      = 1 },
  { .tc_id   = 457,
    .comment = "special case for x_2 in multiplication by 8",
    .shared  = "\xc8\xd8\x5b\xfa\x74\xb4\xb2\x64\x61\x29\x7b\x35\x0c\x97\x51\x83\xfe\xa9\xd3\x3b\xa2\x9c\x3a\x49\x34\x50\x9c\x2e\xcd\xa5\x8a\x79",
    .prv     = "\xc0\x59\x57\xfb\xc3\xa0\xe2\xc2\x2a\x2a\xef\x62\x76\x51\xca\x1e\x99\x30\x7b\x82\xa0\xc6\x17\x0f\x79\x50\xa3\x34\xf3\x00\x49\x41",
    .pub     = "\x4d\x96\x32\x0c\xdb\x0c\xa5\x26\x55\xe9\x11\x18\xc3\x3f\x93\xaf\xe4\xae\x69\xe9\xe5\x13\xff\x45\x06\x75\x0b\x8e\xa7\x84\xce\x46",
    .ok      = 1 },
  { .tc_id   = 458,
    .comment = "special case for x_2 in multiplication by 8",
    .shared  = "\x22\x55\x7e\x0d\x87\x41\xed\x2a\x63\xaf\xd5\xe3\x13\xaa\x15\x79\xfc\x0c\x88\xc7\x77\x2e\x23\xa6\x76\xc9\x4b\x60\xc8\x9d\xf5\x77",
    .prv     = "\x60\x11\x1c\x66\x29\xf7\x36\x35\x98\x5b\xe9\x64\xb8\x45\xf8\x7a\x88\xae\x56\x52\xd4\x5b\xb1\x45\x1c\xe8\xcf\xd2\xea\x45\xfe\x41",
    .pub     = "\xc0\xef\x1b\x7c\x20\x23\x7d\xb3\x70\x50\x1f\x24\x27\x4e\x4e\xba\x91\x99\x8a\xe4\x54\x5f\x93\x70\x07\xe1\xc4\xa2\xea\xb6\x33\x65",
    .ok      = 1 },
  { .tc_id   = 459,
    .comment = "special case for x_2 in multiplication by 8",
    .shared  = "\x54\xd7\xfc\x17\xba\xd0\x02\x96\xba\x50\xb0\xf3\xd5\xbf\x8f\xb8\x3f\x82\xd5\x71\x95\x2a\x5f\xdb\x5a\x49\x41\x20\xcc\x61\x44\x6b",
    .prv     = "\x58\x78\x58\x89\xa2\x16\xd1\x54\x56\x58\x2d\x4e\x1e\x3d\xe9\xe9\xca\x4a\x43\x29\x54\x41\x6d\x81\xca\xf5\x2b\x2b\x43\x4c\x17\x46",
    .pub     = "\xd5\x34\xd8\xff\x4d\x56\xa7\x3e\xf7\x61\x5e\x94\x52\x3b\x17\xe3\x5e\xdb\x3d\x0f\xb8\x7e\x98\xc6\x85\x36\xf6\x3f\x11\x4a\x8d\x6c",
    .ok      = 1 },
  { .tc_id   = 460,
    .comment = "special case for x_2 in multiplication by 8",
    .shared  = "\xdb\x68\x51\xb1\x25\x85\xbc\x11\xbe\x93\x62\xc9\x6a\x54\x5c\x6f\x2b\xa5\x5f\x04\x00\x97\x92\x46\x3b\x96\xa3\x8c\xb9\xb3\xf0\x7c",
    .prv     = "\x60\xbe\xf3\x8a\x38\x90\xec\x1e\xd0\x5c\x29\x9f\xce\xb7\x7d\xb5\xea\xd4\xb8\x8d\x9e\x93\x1b\x0f\x21\xd6\x64\xf7\x7d\xf9\xb5\x44",
    .pub     = "\x73\x3a\x71\x1b\xa0\x1b\x6e\x9b\x64\xa0\xbe\x4c\xdc\xa8\xc7\xcf\x3c\x66\xdf\x24\x35\xd5\x24\x8f\xb4\x41\x3f\xec\x6e\xe0\x3f\x70",
    .ok      = 1 },
  { .tc_id   = 461,
    .comment = "special case for x_2 in multiplication by 8",
    .shared  = "\xf6\xd1\xa6\x64\x25\x7f\xa5\xde\x3d\x4d\x57\xf0\x4e\xda\x29\x76\xbf\x1e\x35\xcc\x3a\xc5\x13\xe1\xee\x84\xd5\x7d\x21\x35\xed\x13",
    .prv     = "\x58\x54\xee\x56\x68\x78\xef\x8b\x7e\xba\xf5\xa0\x58\x30\x6f\x25\x0e\xdf\x0c\x84\xfd\x52\xaf\x2d\x74\xb7\xce\x3c\x1e\xdd\xa7\x46",
    .pub     = "\x35\x73\x8d\xd5\x39\xd6\x0f\x69\xcd\x1a\x1c\xff\xc8\xa4\x2b\x6a\xf6\x8f\xe7\xde\x45\x39\x2d\x02\x83\x1e\x2a\x77\x50\x0e\xa2\x78",
    .ok      = 1 },
  { .tc_id   = 462,
    .comment = "special case for x_2 in multiplication by 8",
    .shared  = "\xf8\xf7\x62\x5a\xc5\xbd\xe6\x3f\x75\x3a\x9b\xb4\xae\xfb\xfb\x9c\x46\x47\x20\x77\x08\xaf\x9d\x77\x4e\xf0\x8f\xf1\xb1\xe5\xa3\x54",
    .prv     = "\x98\x5b\x55\x12\x61\xfc\xe3\x8d\xdc\x8f\xf3\xad\xd3\x2f\x5c\x26\x81\x1d\x27\x1b\x9a\x17\x94\xe2\x49\xdd\x76\xa3\x8d\xf2\x84\x46",
    .pub     = "\xce\x93\x2b\x5a\xf4\xbe\x47\x21\xf9\x6f\x7b\x79\xba\x1c\x43\xb2\x06\x87\xd4\xaf\x49\xc3\x7b\x58\xdc\x89\x42\x79\xe0\x4b\xb5\x78",
    .ok      = 1 },
  { .tc_id   = 463,
    .comment = "special case for E in multiplication by 8",
    .shared  = "\x5e\x10\xdf\xbf\xf4\x44\x3e\xfc\xae\x2c\xcc\x78\xc2\x89\xa4\x14\x60\xd5\xa8\x2f\x79\xdf\x72\x6b\x88\x24\xcc\xbe\xf7\x14\x6d\x40",
    .prv     = "\x88\x15\x05\x23\x44\xdc\xad\x97\xef\xd1\x34\x1e\x90\x72\xa8\x08\xcf\x99\x9e\x46\xe5\x2c\xf0\x4e\x0c\xfb\xcd\x99\x01\xe1\x8d\x43",
    .pub     = "\xe3\x65\x54\x48\x33\x9e\x48\x50\x80\x6e\xb5\x8a\xbb\xa0\xc8\x91\x85\x51\x1e\xa7\x2c\x37\xc4\x9e\x95\x83\xee\x6d\xd2\x35\xd2\x13",
    .ok      = 1 },
  { .tc_id   = 464,
    .comment = "special case for E in multiplication by 8",
    .shared  = "\x19\xd7\xb4\x4c\x18\x47\xc4\x4e\x8f\x37\xa2\x2a\xb6\x9c\x18\x0f\xd9\xd7\x87\xf2\x04\x12\x30\x13\xe1\xb1\x68\x00\xb9\xcd\x0f\x57",
    .prv     = "\xb8\xe0\x32\xe9\xe5\xff\xba\xa0\x04\x39\x0f\x3a\x0b\x90\x0b\xc7\xcf\x5d\x11\x23\x8b\x7e\xc9\x64\xaf\xc4\xbd\xa2\xaa\x6c\x34\x44",
    .pub     = "\x4d\x16\x96\x5b\x16\x37\xe9\xd7\xae\x8f\xeb\x49\x9e\xd0\x55\x39\x62\xa9\xaa\x00\x22\xd1\x62\x0c\x92\x80\x72\xf6\x50\x1b\xc4\x1b",
    .ok      = 1 },
  { .tc_id   = 465,
    .comment = "special case for E in multiplication by 8",
    .shared  = "\xdb\x99\x0d\x97\x9f\x4f\x22\xf7\x66\xe7\x82\x6d\x93\x55\x4e\x77\x1b\x36\x1d\xe4\x61\x27\x4d\x6c\x37\xba\xad\xeb\x8e\xf7\xbe\x4e",
    .prv     = "\x70\x12\x85\x22\x11\xf6\x53\x6f\xca\x79\x93\x7e\x7e\x31\x6c\x91\x49\xb0\xe2\x0e\xa0\x3f\x95\x1e\x1b\xb0\x72\x89\x5c\xa0\xe0\x44",
    .pub     = "\xc6\xb9\xe6\x28\x87\x37\xad\x40\x45\x2c\xec\x10\x22\x87\x1d\x90\xaf\x16\x42\xd1\x0b\xd0\xa9\x77\x92\xb1\xa9\xc8\x99\x8e\x22\x20",
    .ok      = 1 },
  { .tc_id   = 466,
    .comment = "special case for E in multiplication by 8",
    .shared  = "\x6d\x7f\xc5\xd4\xa8\xf5\x34\xb1\xbc\x0f\xa5\xe0\x78\x10\x42\x34\x67\x5c\x02\x66\x47\x36\x95\x7a\xbd\xb2\x7d\xf6\xfa\xf0\x7c\x00",
    .prv     = "\xd0\x39\xc1\xb9\xec\x47\x63\xe0\xad\x8a\x0e\xf2\xb0\x87\x02\x97\xd0\xf8\xb4\x87\xe6\x60\x59\x5a\x48\x41\x05\xd1\x80\xe1\x4a\x47",
    .pub     = "\xd5\x66\xfa\xb5\x05\xac\x4c\x7a\x3d\xc3\xb9\x40\x3e\xf1\x21\x39\x2c\xbb\xe2\x12\x16\xe5\xbc\xb8\xea\xb2\xdc\x94\x08\x98\x6e\x34",
    .ok      = 1 },
  { .tc_id   = 467,
    .comment = "special case for E in multiplication by 8",
    .shared  = "\x53\x9c\x8d\x62\x9a\xb5\x1c\x2f\x3e\xa7\x27\x8f\xd5\xf1\xc3\x1b\x6c\x15\x0a\x82\xfe\x3f\x78\x6b\x93\xff\xa1\x59\xfd\x6d\x93\x16",
    .prv     = "\x58\xef\xcb\xc8\x77\x7c\x1b\x54\xf0\x9c\x61\xa2\x16\xef\xd4\x27\x29\x2e\xb1\x23\x12\xdb\xb3\xb3\x2b\xd4\x52\x54\xa6\x68\x3e\x47",
    .pub     = "\x46\x8d\x35\xec\xfb\x6d\x9b\x72\x72\x52\x32\x76\xcc\x5e\x13\x76\x05\x19\x66\x7f\x0e\x1e\x38\x88\xda\x4c\x56\x95\x5f\xe9\x11\x51",
    .ok      = 1 },
  { .tc_id   = 468,
    .comment = "special case for E in multiplication by 8",
    .shared  = "\xde\xe3\xfd\x19\xc8\xf2\x96\x41\x54\x48\xb2\x1a\xf4\x43\x85\xec\x46\x72\x7b\xbe\x67\xd4\x83\x9b\x93\xef\xe2\xf6\x80\xe7\x6d\x34",
    .prv     = "\xc8\xd7\x34\x46\x02\x6c\xd0\xea\x79\x57\x73\xc2\xeb\x7b\x16\x34\x8c\xd5\xf2\x28\xe3\x52\xdb\xc7\x73\x28\xc2\xd8\xb9\xcd\xe2\x40",
    .pub     = "\x19\x29\x53\x87\x43\x97\x7d\xfe\xa2\x0b\xf4\x92\x7d\xda\xbb\x2f\x3b\xb1\x5c\xac\x24\x61\x05\x45\x08\x84\x97\x18\x85\x4b\x55\x68",
    .ok      = 1 },
  { .tc_id   = 469,
    .comment = "special case for E in multiplication by 8",
    .shared  = "\x2a\x03\x40\xaa\xaf\xa0\x5d\x00\x52\x9c\x09\x05\x7e\xd0\x14\x5f\x34\xd2\xde\x66\xa3\xe1\x49\xcf\x08\x4e\xa9\x71\x68\x91\x4f\x39",
    .prv     = "\x98\xb5\x59\x52\x3b\xc7\x78\xb0\x41\x8a\xf5\x3c\x0c\x32\xf6\xff\x5c\xf7\x71\xff\x5d\xf8\xae\x7c\xbf\x7c\x3b\x72\xae\xdb\x5b\x43",
    .pub     = "\x2d\x7a\xb4\xc6\xf5\x98\x65\x35\x5e\xe8\xe9\xde\x57\xdb\x19\xaa\xdf\x77\x08\xb7\xc1\xd1\xa8\x18\x48\x7c\x34\x06\x23\xba\xdc\x6d",
    .ok      = 1 },
  { .tc_id   = 470,
    .comment = "special case for E in multiplication by 8",
    .shared  = "\x00\x31\x37\x17\xd3\x3e\x3b\x41\xa0\x86\x59\x86\x15\x75\x82\xe0\x53\x50\x2a\x17\x2b\x88\xd0\x1b\xb7\xb1\x08\x31\xa9\xfc\x4e\x6c",
    .prv     = "\x58\x98\x15\x02\x7c\xaf\x82\x71\x4e\x96\xc9\xf9\x1b\xac\xe6\x6e\xc4\xba\x3e\x92\xdf\x3f\xa1\x4b\x9b\x8f\xe5\x03\x55\x6e\x45\x43",
    .pub     = "\x43\x83\x9f\x4a\x6a\xa2\x06\xc8\x2c\x5a\x73\xf4\x9d\x8c\x9e\x57\x38\x26\xb3\xba\x72\x35\xd3\x12\x98\x7c\x17\xae\xbe\xe6\x27\x76",
    .ok      = 1 },
  { .tc_id   = 471,
    .comment = "special case for E in multiplication by 8",
    .shared  = "\x9b\x6b\xe9\xe6\xf2\xfd\xb5\xd3\x32\x18\x42\x22\x5d\x3e\x91\xd1\x48\x28\xcc\x53\xba\x66\x54\xda\xbe\x19\x0b\x0c\x3e\xde\xb3\x09",
    .prv     = "\x80\x71\x5f\x67\x27\x0c\x99\x78\x98\x55\xce\xae\xa9\x9b\x99\x57\xcc\xda\x33\x32\x6f\x76\xbb\x44\x74\xab\x52\xab\x1e\xc3\x70\x41",
    .pub     = "\x3c\x32\x1e\x7f\x0b\x9e\x55\x5b\xc2\x64\xa2\xce\xa6\x17\xe6\xb2\xb5\x62\xeb\xab\x21\xfe\x0c\x22\x6c\x3e\x48\x7b\x7d\xf9\xa2\x7d",
    .ok      = 1 },
  { .tc_id   = 472,
    .comment = "special case for DA - CB in multiplication by 8",
    .shared  = "\x22\x3f\x1e\xb5\x52\x30\x83\x73\x02\x6d\x11\xc9\x54\x68\x4c\xe6\xdb\x87\x0b\x63\x8b\x19\x0b\x94\x43\xe5\x0a\xae\x21\x9f\x4e\x3e",
    .prv     = "\x10\x1b\x99\x0b\xd8\x3d\x68\x41\x26\xff\x04\x7d\x93\x0c\x27\xd0\x86\xa5\x88\xdd\x19\x68\x3d\x26\x29\xf0\xe3\x4f\x43\x74\xab\x41",
    .pub     = "\x42\xe5\xa6\xb8\xe9\x65\x4b\xb4\xad\x62\x4a\xf3\xf4\x91\x87\x79\x77\x51\x3c\xc8\x77\x5c\x8f\xb3\x12\xad\x19\xdb\xf3\x90\x3a\x28",
    .ok      = 1 },
  { .tc_id   = 473,
    .comment = "special case for DA - CB in multiplication by 8",
    .shared  = "\xfb\x95\xce\x4a\x3c\x1f\x32\x56\x38\xb7\xd4\x7f\x42\x16\xd3\x9a\x7c\x6c\x5d\xa9\xa0\x1c\xaa\x29\x7c\x37\xb6\x28\x16\x55\x5b\x2a",
    .prv     = "\x20\x00\x89\xb7\x12\xd9\xa2\x05\x05\x97\x77\x9d\x46\x37\x12\xfc\xd2\x23\xe3\xd6\x78\x79\xc0\xfb\x76\x06\xf8\xf5\xf0\xef\xee\x40",
    .pub     = "\x0a\x51\xdd\x90\xab\x98\x5f\x6d\xea\xf7\x2f\x16\xc4\x50\x14\xda\x26\xdf\x84\x86\x97\xf6\x58\x2d\x75\x68\x8f\x52\x23\x34\x2b\x51",
    .ok      = 1 },
  { .tc_id   = 474,
    .comment = "special case for DA - CB in multiplication by 8",
    .shared  = "\x48\x8b\x83\x41\xc9\xcb\x1b\xbf\x12\x45\x10\xb9\xf8\xda\xe4\xfa\xf2\xe0\xdc\xa9\xb8\x4e\x00\xe9\x52\xa6\x3b\x5a\xa3\x28\xa8\x60",
    .prv     = "\xf0\x4f\x87\xf4\xe6\x23\xaf\x4c\x31\xce\xca\x0b\xb8\x7f\xac\x2d\x5b\x12\x51\x7b\x5a\x72\x84\x90\x2a\xd7\x58\x38\xe6\x5f\x1e\x41",
    .pub     = "\x88\x42\x31\x73\x57\xbd\xe8\x25\xef\x43\x8a\x1c\x53\x90\x6f\xb8\xb0\x4e\xa3\x60\xf7\xef\x33\x8c\x78\xe6\x68\x58\x60\x47\x93\x6a",
    .ok      = 1 },
  { .tc_id   = 475,
    .comment = "special case for DA - CB in multiplication by 8",
    .shared  = "\x11\x29\xea\xe9\x7b\xf7\x5f\x73\x14\xf2\xe1\xb4\x03\xb1\x87\x37\xad\x83\x0c\x80\x42\x9e\x2b\xa0\xd4\x86\x6b\x36\x23\x99\x85\x5f",
    .prv     = "\x38\x3c\xbd\x5a\x3d\xd0\x90\x1d\x09\xa3\xca\xc3\xd3\xa7\x7a\x97\x9c\xec\xf1\x5e\x20\x6a\x55\x3e\x4c\xa3\xf2\x4b\x90\x78\x39\x45",
    .pub     = "\xc7\x1d\x92\xd3\xc9\x2d\xbf\xae\xd7\x55\xfb\x32\x79\x7b\x66\x7c\xc8\x6b\x0e\x79\x36\x24\x98\xe2\xac\xa3\x8c\x68\x97\x13\xb1\x6e",
    .ok      = 1 },
  { .tc_id   = 476,
    .comment = "special case for DA - CB in multiplication by 8",
    .shared  = "\x07\x2f\x51\xd9\x47\x27\xf3\x92\xd5\x9d\xc7\xca\xff\x1f\x44\x60\x45\x23\x52\xec\x39\xc3\x2a\x1c\x9f\x07\x1e\x38\x88\x33\xda\x56",
    .prv     = "\x70\x1d\xf0\x9e\x57\xb9\x8a\xec\x37\x57\x45\xdf\x14\x7b\x72\x94\x9a\x6b\x2b\xb2\xca\x3a\x34\x88\x15\x12\xee\x31\xe7\x90\xad\x42",
    .pub     = "\x3a\x21\xd1\xcf\x7b\x37\x44\xd1\xad\x26\x19\x73\x35\x84\x49\x82\xc2\xa0\xc6\xa5\xaa\x83\x54\x92\xbd\x03\xc4\x01\xa4\xfe\x67\x78",
    .ok      = 1 },
  { .tc_id   = 477,
    .comment = "special case for CB in multiplication by 8",
    .shared  = "\x30\x51\x21\x42\xd3\xe3\xa4\xca\xd6\x72\x6d\x9d\x35\xf2\xe0\x43\xfc\xa9\xdf\xb7\x50\x88\x4a\xe2\x2b\x25\x47\xc8\x40\xf3\x58\x7b",
    .prv     = "\xb0\xff\xa5\xf4\x92\x2b\xb1\x17\xad\x75\xff\x43\xac\xac\x62\x33\x1e\xfa\xa4\x55\x36\xfe\x88\x30\x6e\x4a\x4c\xb5\x8d\xb7\x3a\x47",
    .pub     = "\xd1\x28\xea\x3e\x13\x32\x5e\xd6\xeb\xd6\x53\x3a\x9f\xd3\x04\x5a\x55\xf2\x5a\xd8\xb6\x7d\xef\x30\x91\x28\x43\x50\x4c\x1a\xab\x29",
    .ok      = 1 },
  { .tc_id   = 478,
    .comment = "special case for CB in multiplication by 8",
    .shared  = "\x5b\x81\xb3\x76\x1a\x66\xd1\x99\xe8\xef\x99\xd2\x49\x4b\xd5\x7a\x02\x29\xd4\x56\x4a\x7f\x6d\x60\x55\xf2\x2a\xa4\x86\x81\xbd\x3a",
    .prv     = "\x68\x5e\x32\x71\xd2\x01\x57\x41\x75\x66\x12\xa9\x30\xe8\x58\xb9\x30\xac\xf2\x01\x81\x45\xf3\x82\xc8\x3d\x8c\xce\xd2\xe2\x20\x44",
    .pub     = "\xe0\x79\xc8\xf8\x42\x31\x65\xc7\xe0\xa2\xc4\x8b\x4a\xbe\x90\xae\xce\x4e\x6d\x90\x3d\x7a\x5a\x16\x25\xfa\xd0\x41\x0c\xd5\x5b\x32",
    .ok      = 1 },
  { .tc_id   = 479,
    .comment = "special case for BB in multiplication by 8",
    .shared  = "\x03\x8d\xe7\xfd\xb9\xcc\x00\x30\xf5\xc1\x1d\xda\x00\x58\x9f\x0a\x95\xf6\x56\x58\x81\x5b\x06\xed\x01\x35\x53\xa0\x2b\x6c\x50\x17",
    .prv     = "\xf8\xe1\x61\xd6\x92\x97\xe0\x17\xd7\xc5\x1b\x1b\x1f\xf3\xba\x70\x3d\x4c\x4c\xf8\xfc\x2b\x8f\xf4\x7f\x74\xc3\xff\x8c\x7d\x35\x41",
    .pub     = "\x65\x92\x2a\x06\xe9\xbe\x4e\x8a\x5e\x8a\xce\xb1\xa4\xe0\x8f\xe9\x0f\x01\xe1\x0e\xf2\xdd\x27\x31\x54\x27\xce\xdf\xcf\x95\xec\x32",
    .ok      = 1 },
  { .tc_id   = 480,
    .comment = "special case for BB in multiplication by 8",
    .shared  = "\x22\xb0\xde\xa3\xb3\xb7\xca\x55\xec\xee\xaa\xe6\x44\x34\x26\x54\x8c\x7c\x15\xcc\x7d\xdf\x31\x78\x03\x18\xd1\xc2\x38\x79\xc1\x6a",
    .prv     = "\x10\x5d\x75\x89\xf8\xab\xef\x0a\xcf\x09\x40\xda\x84\xa6\x9e\x8f\x2f\x30\x6f\xa7\x3c\x9a\xfd\x27\x34\x22\x87\xc1\xdb\xa8\x00\x44",
    .pub     = "\xd3\x6a\x24\x0e\x97\x2d\xc1\x6e\x9b\x97\xa9\x97\xad\xa3\x37\xf0\x27\x60\xd0\x5c\x46\xd7\xf8\xd7\xb4\xe9\xea\x9a\x63\x5c\x7c\x64",
    .ok      = 1 },
  { .tc_id   = 481,
    .comment = "special case for BB in multiplication by 8",
    .shared  = "\xa2\x5e\x13\x06\x68\x4a\xd7\x87\x0a\x31\xf0\x40\x45\x66\xe8\xd2\x8f\x2d\x83\xd4\xb9\x49\x78\x22\xc5\x7f\x87\x81\xb1\x8f\xec\x20",
    .prv     = "\x18\x93\xd4\x38\x8b\x0e\x90\xf0\xb5\x02\x08\xaa\x8f\x0c\xc2\x4f\x57\x6d\x03\x64\x1b\xaf\x1c\x3e\xdd\xb2\xa3\xef\xa6\x9c\x9d\x40",
    .pub     = "\x4f\x5b\x8b\x98\x92\xb8\xa4\x6d\xf0\x8d\x76\xa4\x74\x5b\x1c\x58\xd4\xe7\xa3\x94\x90\x54\x35\x87\x56\x88\xca\x11\xf1\xe9\xd8\x6a",
    .ok      = 1 },
  { .tc_id   = 482,
    .comment = "special case for BB in multiplication by 8",
    .shared  = "\xbb\x44\x31\xbe\xa7\xa5\x87\x1c\x1b\xe2\x7a\x26\x74\x09\x46\x27\xea\xaa\x44\x25\xc9\x9c\xd3\xfa\x41\xbd\x7e\x13\xcb\xd7\xbf\x7e",
    .prv     = "\x00\x65\x17\x13\x01\xbf\x6b\x90\xfb\x16\xef\xa3\x55\x09\x16\x1f\x1b\xd6\xb3\xb9\x31\x30\xd4\x90\xaf\x9f\xe2\x24\xdd\x15\x5f\x45",
    .pub     = "\xaa\x2f\x02\x62\x82\x69\x13\x9a\x7a\x8a\x16\xfd\xe9\x5c\x9b\xad\x7d\xa7\xff\xbd\x54\x39\xc3\x96\xa7\xd7\x7b\x6c\x32\x13\xe6\x7f",
    .ok      = 1 },
  { .tc_id   = 483,
    .comment = "special case for A in multiplication by 8",
    .shared  = "\x33\x0f\x5d\x0b\x5b\xcc\xc9\x0f\x76\x94\xdf\xdd\x9c\x64\x49\xa6\x2d\x93\xaf\x88\x40\xea\xf5\x71\xe3\xe0\x61\x0e\x01\x98\xb0\x3f",
    .prv     = "\x10\xc8\x1a\x4e\x78\xd8\x21\x45\xb2\x66\xe1\xd7\x4b\x38\x69\xbf\x1c\x27\x42\x78\x03\xeb\xb1\x1c\x92\xff\x80\x73\xd1\xe4\xcc\x46",
    .pub     = "\xd9\x95\xcb\x28\x7e\x9a\x9c\x57\x91\xf3\xca\xe3\xd4\x94\xa5\xb5\x16\xa1\xe2\x6c\xbc\x93\x0f\x43\xe7\x3c\x8b\x70\xb6\x9d\x78\x3b",
    .ok      = 1 },
  { .tc_id   = 484,
    .comment = "special case for A in multiplication by 8",
    .shared  = "\xbd\xef\x00\xca\xa5\x14\xb2\xf8\xab\x1f\xb2\x24\x1e\x83\x78\x7a\x02\x60\x1e\xcd\xff\x6c\xf1\x66\xc4\x21\x0f\x8c\x1a\xde\x42\x11",
    .prv     = "\x48\xb9\x8b\x4a\x99\xea\xdd\x73\x01\x2c\x07\xfe\x5c\x4a\x0b\x95\x90\xac\x55\xe8\x21\x35\x3b\x41\xd5\xf6\x65\xe1\x71\x88\xbc\x41",
    .pub     = "\x47\x9a\xfb\x1e\x73\xdc\x77\xc3\x74\x3e\x51\xe9\xec\x0b\xcc\x61\xce\x66\xed\x08\x4d\xc1\x0b\xfa\x27\x94\xb4\xc3\xe4\x95\x37\x69",
    .ok      = 1 },
  { .tc_id   = 485,
    .comment = "special case for DA in multiplication by 8",
    .shared  = "\xbf\xd5\xb5\xac\xd2\xd8\x9f\x21\x3a\x26\xca\xf5\x40\x62\xf9\xa2\x4e\x6f\x6f\xd8\xdd\xd0\xcd\x2e\x5e\x47\xb7\xfe\xa4\xa9\xc5\x37",
    .prv     = "\x18\x97\x67\x8e\x38\x22\x2a\x61\xfe\x10\x5d\xc6\x64\x3c\x1e\xb5\x94\x0e\x8d\xbc\x73\xed\x6c\x00\xf2\x5a\x34\x32\x8f\x43\xa6\x41",
    .pub     = "\x37\x8e\xda\x41\x47\x0b\x0f\x23\x8a\x20\x0f\x80\x80\x9a\xd5\x62\xca\x41\xe6\x24\x11\xa6\x1f\xeb\x7f\x7e\x9b\x75\x2b\x55\x46\x42",
    .ok      = 1 },
  { .tc_id   = 486,
    .comment = "special case for DA in multiplication by 8",
    .shared  = "\xc8\x08\x58\x77\x80\x0c\x17\x5e\x94\x9c\xdd\x88\xe1\x96\xeb\x9c\x48\x41\xda\x2a\xc4\x46\xdf\xed\x90\x85\xbd\xa5\xbb\xec\x26\x5d",
    .prv     = "\xa8\x98\xaf\x81\x38\xe1\x1a\xe4\x5b\xbc\xef\xa7\x37\x18\x2a\x57\x18\x85\xf9\x2d\x51\x5c\x32\x05\x6c\x7c\xb0\xd7\xde\xac\x47\x41",
    .pub     = "\x0c\xad\x75\x45\xad\xe2\xfd\x93\xfc\xae\x00\x7c\x97\x64\x83\x48\xf2\x6d\x85\x82\x9b\xdb\x72\x23\xa6\x3e\xcc\xb8\x4e\x56\xd4\x75",
    .ok      = 1 },
  { .tc_id   = 487,
    .comment = "special case for AA in multiplication by 9",
    .shared  = "\x4c\x30\x08\x95\x82\x73\x82\xa9\xd1\x07\x90\x28\xbd\x6f\x69\x4a\x7a\x12\xdd\xac\x9c\x76\xab\xac\x6f\xdf\x5d\x29\x45\x7a\x33\x10",
    .prv     = "\xb0\xbf\xef\x6e\xc0\x95\xb5\xa1\xf9\x39\x17\xd3\x2f\x16\xa2\x1d\x04\x62\xc1\xfd\xe1\x74\x46\xf5\xa5\x90\x23\x2d\x9c\x89\x5f\x4a",
    .pub     = "\x60\xf2\x7e\xd0\xa2\x78\x04\xce\xd2\x37\xcf\x3c\x1c\xc7\x76\x65\x0f\xb3\x20\xba\xe6\xd5\xac\xb5\x64\xe9\x7b\x56\xcb\xa2\x52\x10",
    .ok      = 1 },
  { .tc_id   = 488,
    .comment = "special case for AA in multiplication by 9",
    .shared  = "\x72\x85\xfb\xb3\xf7\x63\x40\xa9\x79\xab\x6e\x28\x87\x27\xa2\x11\x33\x32\xcf\x93\x38\x09\xb0\x18\xb8\x73\x9a\x79\x6a\x09\xd0\x0b",
    .prv     = "\x60\x49\x7d\x44\x64\xed\x88\x23\xc5\x0f\xbc\x6b\x68\x62\x08\x26\xc4\xf6\x29\xc1\xd9\x19\x30\x58\xdf\x6b\xf8\x57\xc6\xae\xcc\x4b",
    .pub     = "\xf9\x3a\x73\x27\x0a\xc1\x91\x94\xb8\xe4\xff\xd0\x2b\xe4\xb1\x43\x85\x25\xf8\x4a\x76\x22\x46\x88\xea\x89\xa9\xdd\x6a\x1b\xd6\x23",
    .ok      = 1 },
  { .tc_id   = 489,
    .comment = "special case for AA in multiplication by 9",
    .shared  = "\xda\xbc\x3b\xd4\x9f\x19\xcf\x70\x71\x80\x2e\x43\xc8\x63\xed\x0b\x1d\x93\xa8\x41\x58\x80\x98\xb9\x8a\x0c\x58\x1b\xf4\xfe\x0a\x11",
    .prv     = "\x08\xc6\xcb\xe0\x37\x92\xa3\x82\x9f\x06\xe8\xad\x54\xc5\x5d\xb1\x13\x23\x6a\xc0\xdc\xc9\xab\x6a\x9a\x6b\x10\xee\xd1\x04\x1b\x48",
    .pub     = "\xcf\x80\xc3\x0f\xcb\xfd\x53\x56\x66\xca\x1d\xa4\x99\xe2\xe9\x9c\xc5\x37\x06\x3e\x2d\xe1\x94\x58\xfc\xf9\x2f\x5e\xe3\x4a\xcf\x47",
    .ok      = 1 },
  { .tc_id   = 490,
    .comment = "special case for AA in multiplication by 9",
    .shared  = "\xa6\x1a\x3b\x15\x0b\x47\x70\x53\x23\x73\x67\x62\x98\xc9\xa5\xda\x28\xad\xcc\x43\x65\xb0\x6f\xe0\x7c\x95\x9c\xa8\x0e\x47\x7a\x57",
    .prv     = "\x50\x04\x4d\xa3\x31\x5d\xd0\x82\xe9\xdf\xb6\xa1\x99\x4a\xab\xb3\x31\xf5\x3e\x0d\x1c\x12\x63\x33\x83\xb2\xa3\xc8\x67\x8c\xfe\x4c",
    .pub     = "\x69\x8e\xff\xe0\xad\x42\xe1\x5e\xe1\xf4\x6f\xde\x6f\xc5\x07\x4f\xfd\xa1\x83\xbc\xf1\xb2\xdb\x86\x47\xf5\x61\xdd\xd1\x91\xdd\x60",
    .ok      = 1 },
  { .tc_id   = 491,
    .comment = "special case for AA in multiplication by 9",
    .shared  = "\x91\x6a\xb4\xf3\xbf\xc8\x32\x1e\x10\x87\xd9\xc5\x44\x4f\x8f\x7a\x43\xe9\xca\x6d\x29\xe7\xba\x98\xa1\x9d\xc0\x5f\xff\x34\xed\x4c",
    .prv     = "\x28\x56\x40\xda\x7a\x48\x25\x2e\x35\xdd\xce\x60\xc1\x4a\xdd\xb7\x30\x97\xfb\xc9\xac\x2f\x87\xc8\xd2\x77\x2c\xe8\x9a\xa6\xbe\x4d",
    .pub     = "\xbd\x15\x65\xb4\xa3\xf8\x51\x5d\xff\x57\x7b\xe6\xdc\xb4\x14\x51\x1d\x3d\x4e\xc2\xde\x15\xe0\xbd\x45\xb2\x8e\x9c\xc4\xca\xef\x60",
    .ok      = 1 },
  { .tc_id   = 492,
    .comment = "special case for AA in multiplication by 9",
    .shared  = "\x84\x4a\x5d\xd5\x13\x95\x54\xca\x7b\x41\xcb\xe6\xa4\x79\x61\x93\x91\x2e\x7a\xa4\xe2\x01\xcc\x68\x94\x4c\xe2\xa5\x57\x74\xa1\x0f",
    .prv     = "\x78\x32\x71\xc2\x11\x99\xba\x2e\x94\xea\xd9\x2c\xd9\xdd\x79\xf7\x0a\xab\x37\x8b\x59\x49\x74\x55\xd3\x27\xa5\x90\x7d\xaf\xcb\x4a",
    .pub     = "\xb8\x64\x9e\x13\x84\x3f\x80\xcf\x57\x02\x39\x8e\x4a\x9a\x8c\x37\x8f\x29\xda\x96\xdf\xd6\x57\x9f\x1e\xb4\xf7\xea\x34\xdf\x67\x65",
    .ok      = 1 },
  { .tc_id   = 493,
    .comment = "special case for AA in multiplication by 9",
    .shared  = "\x10\x78\x03\x33\xb2\xa6\x17\x01\x36\x26\x5b\xb5\xeb\xc6\xc8\x18\x81\x7f\x2e\x48\xae\x37\x25\x28\xc8\xf3\x44\x33\xfd\xd6\x21\x5a",
    .prv     = "\xd0\x67\x6a\x0b\x9a\x04\x6c\x62\xd5\xb2\xe7\x40\xd9\xcc\x43\xfa\x37\x96\x5d\xea\x93\xc2\x32\x54\xf7\xbf\x56\x9f\x2b\xeb\xaa\x4a",
    .pub     = "\xc3\x96\x93\x87\x37\xab\xdf\x79\x1e\x09\xa9\x7e\xba\x57\x7c\x43\x7d\x9b\x67\xc2\xda\xe9\x4e\x13\xea\xb7\x29\x6e\xc0\xfc\x73\x7e",
    .ok      = 1 },
  { .tc_id   = 494,
    .comment = "special case for DA - CB in multiplication by 9",
    .shared  = "\x5c\xe8\x48\x42\xdb\xae\x8b\x79\x5b\x3d\x54\x53\x43\x55\x80\x45\x50\x8f\x27\x13\x83\xbf\xb3\xdd\x39\x43\xf4\x10\x13\x98\xc8\x64",
    .prv     = "\x60\x8c\x84\xd2\xb7\x6f\xcc\xda\x57\x9e\x97\x4d\xb3\xd3\xb2\xce\x39\xa6\xbc\x0d\xad\x44\x05\x99\xdb\x22\x41\x1b\x60\x46\x78\x49",
    .pub     = "\x55\x7b\x82\x50\x12\xd9\x8f\x06\x5b\xb9\x5a\x2a\xb9\xb2\xd2\xd8\xb8\x3f\xd2\x03\x79\x12\x50\x8c\x26\x3f\x86\xd7\xe3\x6c\x4f\x24",
    .ok      = 1 },
  { .tc_id   = 495,
    .comment = "special case for z_2 in multiplication by 9",
    .shared  = "\x4f\x11\xaa\x0c\x31\x31\x95\xf9\x6f\x25\xca\xdc\xbf\x49\xf0\x6a\x93\x2d\x8b\x05\x18\x79\xea\x53\x7d\x1c\x6d\xfe\xe7\xf3\x6d\x35",
    .prv     = "\x80\xf2\x33\x93\x6a\x88\x21\x93\x6d\x39\x11\x4c\x84\xd9\x29\xe7\x97\x60\xb2\x76\x80\x77\x9e\x50\x09\xe1\x70\x94\x10\xdd\x8e\x4f",
    .pub     = "\xae\x98\x29\x6d\x4a\x2f\xbc\xbb\x40\xb4\x72\xf4\x06\x32\x31\x60\x8b\xb1\x46\x5c\x22\x6c\x8a\x4a\x2d\xff\x29\xaf\xd9\x15\x88\x2a",
    .ok      = 1 },
  { .tc_id   = 496,
    .comment = "special case for z_2 in multiplication by 9",
    .shared  = "\x1d\x61\x90\x70\xbf\x56\x26\x06\x4b\xe1\x00\x25\xe7\x4e\x33\x6c\x81\xef\x31\x66\xb7\x43\xf9\x9c\x75\x1f\xb9\x05\x87\xc3\x1d\x7e",
    .prv     = "\xc8\xd8\x0b\x1a\x34\xf2\x11\x94\xf0\x47\xa6\xf0\x32\x8b\xb9\x47\xe2\xe7\xaf\xf6\xa0\x43\x55\x3a\xa0\x7f\x2a\xbf\x99\xaa\xf0\x48",
    .pub     = "\x8b\x9d\x24\x98\x29\xfb\xe8\x13\x33\xd8\x50\x50\xda\x88\x99\x8f\x63\xfa\xc6\x65\x67\x9e\x27\xdb\xbe\x21\xb7\x45\xdd\x14\xe1\x45",
    .ok      = 1 },
  { .tc_id   = 497,
    .comment = "special case for z_2 in multiplication by 9",
    .shared  = "\x53\x2e\x79\x78\x61\xdb\x56\xb9\xd5\xdb\x88\x25\xfb\x72\xf8\x62\x9c\x24\x22\xf8\xab\xea\x72\x1a\xd2\xd7\xb9\xe7\x7a\x95\xb5\x76",
    .prv     = "\x90\x21\x47\x7b\x45\x23\x61\x58\x00\x59\x36\x4c\x6f\x94\xf4\x98\x1e\xe9\x4e\xa3\xf9\xb7\xd3\x74\x39\xbc\x82\xae\x45\x81\x6f\x4d",
    .pub     = "\x61\x89\x60\x93\xe2\x69\x7c\x78\x23\x0a\xfd\xda\x12\x63\x9c\xbe\x43\x42\x82\x7b\x8d\x2b\x09\x32\x81\xf1\x48\xeb\x60\xb9\x03\x4b",
    .ok      = 1 },
  { .tc_id   = 498,
    .comment = "special case for z_2 in multiplication by 9",
    .shared  = "\x4f\x67\x8b\x64\xfd\x1f\x85\xcb\xbd\x5f\x7e\x7f\x3c\x8a\xc9\x5e\xc7\x50\x0e\x10\x2e\x90\x06\xd6\xd4\x2f\x48\xfb\x24\x73\xab\x02",
    .prv     = "\x60\x79\xda\xe0\x4c\x40\xa5\x9e\xa4\xe0\xc8\xc1\x70\x92\xe4\xc8\x5e\xa9\x13\x3d\x14\x33\x07\x36\x34\x87\x83\x6d\xf4\xe3\x03\x49",
    .pub     = "\xcc\xc1\xdc\x18\x62\x29\xdb\xa9\xa9\x36\x0a\x0f\x7f\xf0\x02\x47\xa3\x73\x26\x25\xac\xaa\xcd\x18\xea\x13\xa9\xa8\xb4\x0f\xac\x4f",
    .ok      = 1 },
  { .tc_id   = 499,
    .comment = "special case for z_2 in multiplication by 9",
    .shared  = "\xe0\x69\xfd\x06\x70\x2f\x10\xf3\x3a\xdb\x8c\xf0\x76\x68\x80\x63\x48\x65\xb5\x10\xe2\xda\x40\x92\x41\xfb\x5f\x17\x80\x50\x51\x4a",
    .prv     = "\x28\x1d\xb6\xa5\xac\x9a\x47\xd4\xa7\xb2\xb9\x1a\x87\xf6\x53\x6c\xe6\x2d\x4e\x51\x29\xb8\xd6\x47\xb9\x7f\x9c\x50\x40\x14\x89\x4c",
    .pub     = "\x69\xe3\x68\xc0\xb7\xe7\x8e\xb9\xf3\xa5\x3b\xf4\x58\xf6\xe7\x9d\xc4\x88\x3b\xf9\x45\x8f\x04\xa8\xc1\x2c\x4d\xdd\x94\xd6\x21\x51",
    .ok      = 1 },
  { .tc_id   = 500,
    .comment = "special case for z_2 in multiplication by 9",
    .shared  = "\xfe\xe2\x18\xeb\x1f\x92\x86\x44\x86\xe8\x3c\x17\x31\xf0\x4b\xb8\xc7\xe6\xd7\x14\x3e\x39\x15\xbc\xbf\x80\xfe\x03\xff\x69\xdc\x77",
    .prv     = "\xd8\x30\xf3\xc4\x78\x58\x29\xa0\xf9\x45\x85\x7e\x0e\x85\xe0\xae\x72\x37\x02\xb5\x77\x83\xb9\x33\xcd\x2a\x2a\xd0\x54\x84\xfe\x49",
    .pub     = "\xf2\x1f\x9b\xad\xd9\x8d\xd8\xa1\x03\xcc\x2a\xb5\x48\x4f\xac\x6c\x2b\xfd\xd2\x67\x1e\xe6\xe6\x74\x13\x4a\x86\xb8\x9c\xee\x91\x60",
    .ok      = 1 },
  { .tc_id   = 501,
    .comment = "special case for E in multiplication by 9",
    .shared  = "\x64\xbd\xfa\x02\x07\xa1\x74\xca\x17\xee\xba\x8d\xf7\x4d\x79\xb2\x5f\x54\x51\x0e\x61\x74\x92\x30\x34\xa4\xd6\xee\x0c\x16\x7e\x7b",
    .prv     = "\x10\x23\x0b\xd0\x72\x1f\x4c\x8c\x4b\x92\x18\x81\xdd\x88\xc6\x03\xaf\x50\x1e\xe8\x0e\x21\x02\xf8\xac\xc3\x0c\xf8\xb2\xac\xd3\x49",
    .pub     = "\xe8\x53\x06\x2b\x2d\x6f\x38\xd0\x21\xd6\x45\x16\x3e\xa2\x08\xd0\xe1\x93\xa4\x79\xf1\x1f\x99\x97\x1b\x98\xe2\x11\x88\xfd\x0b\x2c",
    .ok      = 1 },
  { .tc_id   = 502,
    .comment = "special case for E in multiplication by 9",
    .shared  = "\xd7\xf4\x58\x3e\xe4\xfe\x86\xaf\x3a\x3f\x1d\xfc\xb2\x95\xba\x3a\x3e\x37\xbc\xed\x7b\x9c\x6f\x00\x0a\x95\x33\x65\x30\x31\x89\x02",
    .prv     = "\xf0\xa3\x4d\x6d\x76\x89\x6e\x17\xcb\x8f\x66\xfe\xda\x23\x11\x5f\xfb\x96\xf2\x46\xb8\x23\xbb\x63\xde\xc0\x83\x35\x78\x7d\xe7\x4c",
    .pub     = "\x36\x2e\xb9\x2d\xab\x9f\xb2\x9f\x7e\xd0\xe0\x38\x43\xdc\xc1\x57\x97\x92\x8c\x2b\x4e\x51\xec\x26\x02\x04\x17\x9c\x1c\x12\x94\x5f",
    .ok      = 1 },
  { .tc_id   = 503,
    .comment = "special case for E in multiplication by 9",
    .shared  = "\xc1\xb5\xe5\xf4\x40\x1c\x98\xfa\x14\xeb\xa8\xaa\xfa\xe3\x0a\x64\x1b\xfd\x8f\xb1\x32\xbe\x03\x41\x3f\x3b\xf2\x92\x90\xd4\x9e\x0b",
    .prv     = "\x90\x73\xc1\xd0\xa1\x73\xc7\xff\x02\xdc\x96\x6a\x16\x59\x93\xd9\xc4\xc9\x35\x75\x14\xf7\xa6\xbb\x7a\xaa\x4b\x08\x27\x71\x89\x48",
    .pub     = "\xff\x54\x3f\x1e\x81\x99\x6e\x88\x63\x1f\x03\x0c\xeb\xa7\xe6\x03\xb1\x30\x33\xef\xd2\x05\xe6\x8b\xd3\x6b\x28\x46\x81\x34\xaa\x73",
    .ok      = 1 },
  { .tc_id   = 504,
    .comment = "special case for x_2 in multiplication by 9",
    .shared  = "\x93\x69\xeb\xb3\xd2\xb7\x44\x34\x1c\xba\x77\x30\x27\x19\xa4\xb2\xd6\x3a\xff\x61\x28\x72\xf8\x6d\x98\x77\xa7\x6b\xc9\x19\xca\x1c",
    .prv     = "\xb0\xc1\x82\x25\x66\xe0\x16\xc1\x2a\xe3\x5e\xc0\x35\xed\xd0\x9a\xf3\xcb\x7a\x48\xf5\x5c\x90\x28\xe0\x5e\x11\x78\xa8\xc3\x82\x4e",
    .pub     = "\x90\xef\x70\x84\x4e\xad\x16\x13\xf6\x9d\xf7\xd7\x8c\x05\x78\x13\xf8\x66\xc0\xd9\x5e\x6d\x22\xca\xee\x4a\x01\x2b\x9c\x1c\x4b\x33",
    .ok      = 1 },
  { .tc_id   = 505,
    .comment = "special case for x_2 in multiplication by 9",
    .shared  = "\x33\x53\x94\xbe\x9c\x15\x49\x01\xc0\xb4\x06\x33\x00\x00\x18\x04\xb1\xcd\x01\xb2\x7f\xa5\x62\xe4\x4f\x33\x02\x16\x88\x37\x16\x6e",
    .prv     = "\xe0\x6f\xe6\x4e\x21\x17\x79\x6f\x99\x7b\xbc\xd3\xbc\xad\x30\x67\xcf\x12\x91\x64\x0a\x3a\x64\x3f\xb3\x59\x80\x9a\x40\x16\x83\x4d",
    .pub     = "\x88\xc1\xae\x57\x5a\xd0\x73\xdd\xa6\x6c\x6e\xac\xb7\xb7\xf4\x36\xe1\xf8\xad\x72\xa0\xdb\x5c\x04\xe5\x66\x0b\x7b\x71\x9e\x4c\x4b",
    .ok      = 1 },
  { .tc_id   = 506,
    .comment = "special case for x_2 in multiplication by 9",
    .shared  = "\x7e\xcd\xd5\x4c\x5e\x15\xf7\xb4\x06\x1b\xe2\xc3\x0b\x5a\x48\x84\xa0\x25\x65\x81\xf8\x7d\xf6\x0d\x57\x9a\x33\x45\x65\x3e\xb6\x41",
    .prv     = "\x70\x7e\xe8\x1f\x11\x3a\x24\x4c\x9d\x87\x60\x8b\x12\x15\x8c\x50\xf9\xac\x1f\x2c\x89\x48\xd1\x70\xad\x16\xab\x0a\xd8\x66\xd7\x4b",
    .pub     = "\xdc\xff\xc4\xc1\xe1\xfb\xa5\xfd\xa9\xd5\xc9\x84\x21\xd9\x9c\x25\x7a\xfa\x90\x92\x1b\xc2\x12\xa0\x46\xd9\x0f\x66\x83\xe8\xa4\x67",
    .ok      = 1 },
  { .tc_id   = 507,
    .comment = "special case for BB in multiplication by 9",
    .shared  = "\x0d\x8c\x21\xfa\x80\x0e\xe6\x3c\xe5\xe4\x73\xd4\xc2\x97\x54\x95\x06\x2d\x8a\xfa\x65\x50\x91\x12\x2c\xb4\x17\x99\xd3\x74\x59\x4f",
    .prv     = "\x70\x89\x65\x4b\xaa\xcb\xb6\x5b\xd0\x0c\xd8\xcb\x9d\xe4\x68\x0e\x74\x80\x75\xe8\x84\x2c\xa6\x9d\x44\x8f\xb5\x0f\xea\x85\xe7\x4e",
    .pub     = "\x6c\x00\x44\xcd\x10\x57\x8c\x5a\xff\x1f\xf4\x91\x7b\x04\x1b\x76\xc9\xa9\xae\x23\x66\x4e\xb8\xcf\x97\x8b\xd7\xaa\x19\x2c\xf2\x49",
    .ok      = 1 },
  { .tc_id   = 508,
    .comment = "special case for BB in multiplication by 9",
    .shared  = "\xdb\x6f\xec\x44\xbf\x11\x83\x16\xa6\xbd\xfb\xae\x9a\xf4\x47\xba\xed\xe4\xd8\x2d\xaa\x16\xbe\xd5\x96\xea\x6f\x05\xd4\xa5\x14\x00",
    .prv     = "\x80\x89\x78\x4c\x52\xcd\x67\xe4\x53\x6e\x56\x82\x18\xc7\xb7\x03\x3b\x28\x41\x3f\x94\x2f\xca\x24\xed\x69\xe4\x34\x96\xef\xa1\x4b",
    .pub     = "\xd9\x08\x9d\xe9\x02\xe1\x43\xdc\xd9\x10\x7e\x5a\x33\x93\xa3\xf7\xfe\x05\xd9\x26\xc3\x57\xb4\x7e\x30\x7a\x23\x6c\xb5\x90\xfd\x64",
    .ok      = 1 },
  { .tc_id   = 509,
    .comment = "special case for BB in multiplication by 9",
    .shared  = "\xec\xc1\x20\x4b\xc7\x53\xc4\xce\xc4\xc9\x05\x9f\xd7\xb5\x04\x94\x4e\xbf\x99\x5a\xb1\xb1\xd4\x9f\x0b\x3b\x32\x53\x53\xbe\x3a\x15",
    .prv     = "\x00\xe7\x3e\x4e\x01\x31\x48\xb9\xf0\x52\x73\xba\xd6\x26\xbb\x12\x6a\x40\xec\x45\x58\xf5\x42\x50\x96\xb4\x89\x47\xe0\xa9\xde\x4a",
    .pub     = "\x8c\x4a\x26\xaa\x31\x9c\x2c\xc4\xa4\x15\x8c\x2b\xc6\x9a\x0d\x5b\x34\x0b\x60\x62\x8a\x14\xcf\x31\xbb\x0a\xe5\xdd\xc3\x8a\xe8\x66",
    .ok      = 1 },
  { .tc_id   = 510,
    .comment = "special case for BB in multiplication by 9",
    .shared  = "\x37\x40\xde\x29\x7f\xf0\x12\x20\x67\x95\x1e\x89\x85\x24\x71\x23\x44\x0e\x0f\x27\x17\x1d\xa9\x9e\x26\x3d\x5b\x44\x50\xf5\x9f\x3d",
    .prv     = "\x78\xed\x4c\x9b\xf9\xf4\x4d\xb8\xd9\x33\x88\x98\x51\x91\xec\xf5\x92\x26\xb9\xc1\x20\x5f\xe7\xe7\x62\xc3\x27\x58\x1c\x75\x88\x4e",
    .pub     = "\xce\x72\x95\xd1\x22\x7c\x90\x62\xaa\xb9\xcf\x02\xfc\x56\x71\xfb\x81\x63\x2e\x72\x53\x67\xf1\x31\xd4\x12\x28\x24\xa6\x13\x2d\x68",
    .ok      = 1 },
  { .tc_id   = 511,
    .comment = "private key == -1 (mod order)",
    .shared  = "\x6c\x05\x87\x13\x52\xa4\x51\xdb\xe1\x82\xed\x5e\x6b\xa5\x54\xf2\x03\x44\x56\xff\xe0\x41\xa0\x54\xff\x9c\xc5\x6b\x8e\x94\x63\x76",
    .prv     = "\xa0\x23\xcd\xd0\x83\xef\x5b\xb8\x2f\x10\xd6\x2e\x59\xe1\x5a\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x50",
    .pub     = "\x6c\x05\x87\x13\x52\xa4\x51\xdb\xe1\x82\xed\x5e\x6b\xa5\x54\xf2\x03\x44\x56\xff\xe0\x41\xa0\x54\xff\x9c\xc5\x6b\x8e\x94\x63\x76",
    .ok      = 1 },
  { .tc_id   = 512,
    .comment = "private key == 1 (mod order) on twist",
    .shared  = "\x2e\xae\x5e\xc3\xdd\x49\x4e\x9f\x2d\x37\xd2\x58\xf8\x73\xa8\xe6\xe9\xd0\xdb\xd1\xe3\x83\xef\x64\xd9\x8b\xb9\x1b\x3e\x0b\xe0\x35",
    .prv     = "\x58\x08\x3d\xd2\x61\xad\x91\xef\xf9\x52\x32\x2e\xc8\x24\xc6\x82\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x5f",
    .pub     = "\x2e\xae\x5e\xc3\xdd\x49\x4e\x9f\x2d\x37\xd2\x58\xf8\x73\xa8\xe6\xe9\xd0\xdb\xd1\xe3\x83\xef\x64\xd9\x8b\xb9\x1b\x3e\x0b\xe0\x35",
    .ok      = 1 },
  { .tc_id   = 513,
    .comment = "special case private key",
    .shared  = "\x63\xef\x7d\x1c\x58\x64\x76\xec\x78\xbb\x7f\x74\x7e\x32\x1e\x01\x10\x21\x66\xbf\x96\x7a\x9e\xa9\xba\x97\x41\xf4\x9d\x43\x95\x10",
    .prv     = "\x48\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55",
    .pub     = "\x3e\x3e\x77\x08\xef\x72\xa6\xdd\x78\xd8\x58\x02\x50\x89\x76\x5b\x1c\x30\xa1\x97\x15\xac\x19\xe8\xd9\x17\x06\x7d\x20\x8e\x06\x66",
    .ok      = 1 },
  { .tc_id   = 514,
    .comment = "special case private key",
    .shared  = "\x8b\x98\xef\x4d\x6b\xf3\x0d\xf7\xf8\x8e\x58\xd5\x15\x05\xd3\x7e\xd6\x84\x5a\x96\x9f\xe5\x98\x74\x7c\x03\x3d\xcd\x08\x01\x40\x65",
    .prv     = "\x48\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55",
    .pub     = "\x9f\x40\xbb\x30\xf6\x8a\xb6\x7b\x1c\x4b\x8b\x66\x49\x82\xfd\xab\x04\xff\x38\x5c\xd8\x50\xde\xac\x73\x2f\x7f\xb7\x05\xe6\x01\x3a",
    .ok      = 1 },
  { .tc_id   = 515,
    .comment = "special case private key",
    .shared  = "\xcf\xa8\x3e\x09\x88\x29\xfe\x82\xfd\x4c\x14\x35\x5f\x70\x82\x90\x15\x21\x99\x42\xc0\x1e\x2b\x85\xbd\xd9\xac\x48\x89\xec\x29\x21",
    .prv     = "\x48\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55",
    .pub     = "\xbe\x3b\x3e\xde\xff\xaf\x83\xc5\x4a\xe5\x26\x37\x9b\x23\xdd\x79\xf1\xcb\x41\x44\x6e\x36\x87\xfe\xf3\x47\xeb\x9b\x5f\x0d\xc3\x08",
    .ok      = 1 },
  { .tc_id   = 516,
    .comment = "special case private key",
    .shared  = "\x47\x82\x03\x6d\x6b\x13\x6c\xa4\x4a\x2f\xd7\x67\x4d\x8a\xfb\x01\x69\x94\x32\x30\xac\x8e\xab\x51\x60\xa2\x12\x37\x6c\x06\xd7\x78",
    .prv     = "\xb8\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\x6a",
    .pub     = "\x3e\x3e\x77\x08\xef\x72\xa6\xdd\x78\xd8\x58\x02\x50\x89\x76\x5b\x1c\x30\xa1\x97\x15\xac\x19\xe8\xd9\x17\x06\x7d\x20\x8e\x06\x66",
    .ok      = 1 },
  { .tc_id   = 517,
    .comment = "special case private key",
    .shared  = "\x65\xfc\x1e\x74\x53\xa3\xf8\xc7\xeb\xcd\x57\x7a\xde\x4b\x8e\xfe\x10\x35\xef\xc1\x81\xab\x3b\xdb\x2f\xcc\x74\x84\xcb\xcf\x1e\x4e",
    .prv     = "\xb8\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\x6a",
    .pub     = "\x9f\x40\xbb\x30\xf6\x8a\xb6\x7b\x1c\x4b\x8b\x66\x49\x82\xfd\xab\x04\xff\x38\x5c\xd8\x50\xde\xac\x73\x2f\x7f\xb7\x05\xe6\x01\x3a",
    .ok      = 1 },
  { .tc_id   = 518,
    .comment = "special case private key",
    .shared  = "\xe3\xc6\x49\xbe\xae\x7c\xc4\xa0\x69\x8d\x51\x9a\x0a\x61\x93\x2e\xe5\x49\x3c\xbb\x59\x0d\xbe\x14\xdb\x02\x74\xcc\x86\x11\xf9\x14",
    .prv     = "\xb8\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\xaa\x6a",
    .pub     = "\xbe\x3b\x3e\xde\xff\xaf\x83\xc5\x4a\xe5\x26\x37\x9b\x23\xdd\x79\xf1\xcb\x41\x44\x6e\x36\x87\xfe\xf3\x47\xeb\x9b\x5f\x0d\xc3\x08",
    .ok      = 1 },
  {0}
};
