  /* interp_jump_table holds the sBPF interpreter jump table.  It is an
     array where each index is an opcode that can be jumped to be
     executed.  Invalid opcodes branch to the sigill label. */
#include "../../ballet/sbpf/fd_sbpf_loader.h"

  static void const * interp_jump_table[ FD_SBPF_VERSION_COUNT ][ 256 ] = {

#   define OPCODE(opcode) interp_##opcode
    /* SBPF version 0 */
    {
    /* 0x00 */ &&sigill,       /* 0x01 */ &&sigill,       /* 0x02 */ &&sigill,       /* 0x03 */ &&sigill,
    /* 0x04 */ &&OPCODE(0x04), /* 0x05 */ &&OPCODE(0x05), /* 0x06 */ &&sigill,       /* 0x07 */ &&OPCODE(0x07),
    /* 0x08 */ &&sigill,       /* 0x09 */ &&sigill,       /* 0x0a */ &&sigill,       /* 0x0b */ &&sigill,
    /* 0x0c */ &&OPCODE(0x0c), /* 0x0d */ &&sigill,       /* 0x0e */ &&sigill,       /* 0x0f */ &&OPCODE(0x0f),
    /* 0x10 */ &&sigill,       /* 0x11 */ &&sigill,       /* 0x12 */ &&sigill,       /* 0x13 */ &&sigill,
    /* 0x14 */ &&OPCODE(0x14), /* 0x15 */ &&OPCODE(0x15), /* 0x16 */ &&sigill,       /* 0x17 */ &&OPCODE(0x17),
    /* 0x18 */ &&sigill,       /* 0x19 */ &&sigill,       /* 0x1a */ &&sigill,       /* 0x1b */ &&sigill,
    /* 0x1c */ &&OPCODE(0x1c), /* 0x1d */ &&OPCODE(0x1d), /* 0x1e */ &&sigill,       /* 0x1f */ &&OPCODE(0x1f),
    /* 0x20 */ &&sigill,       /* 0x21 */ &&sigill,       /* 0x22 */ &&sigill,       /* 0x23 */ &&sigill,
    /* 0x24 */ &&sigill,       /* 0x25 */ &&OPCODE(0x25), /* 0x26 */ &&sigill,       /* 0x27 */ &&sigill,
    /* 0x28 */ &&sigill,       /* 0x29 */ &&sigill,       /* 0x2a */ &&sigill,       /* 0x2b */ &&sigill,
    /* 0x2c */ &&sigill,       /* 0x2d */ &&OPCODE(0x2d), /* 0x2e */ &&sigill,       /* 0x2f */ &&sigill,
    /* 0x30 */ &&sigill,       /* 0x31 */ &&sigill,       /* 0x32 */ &&sigill,       /* 0x33 */ &&sigill,
    /* 0x34 */ &&sigill,       /* 0x35 */ &&OPCODE(0x35), /* 0x36 */ &&OPCODE(0x36), /* 0x37 */ &&sigill,
    /* 0x38 */ &&sigill,       /* 0x39 */ &&sigill,       /* 0x3a */ &&sigill,       /* 0x3b */ &&sigill,
    /* 0x3c */ &&sigill,       /* 0x3d */ &&OPCODE(0x3d), /* 0x3e */ &&OPCODE(0x3e), /* 0x3f */ &&sigill,
    /* 0x40 */ &&sigill,       /* 0x41 */ &&sigill,       /* 0x42 */ &&sigill,       /* 0x43 */ &&sigill,
    /* 0x44 */ &&OPCODE(0x44), /* 0x45 */ &&OPCODE(0x45), /* 0x46 */ &&OPCODE(0x46), /* 0x47 */ &&OPCODE(0x47),
    /* 0x48 */ &&sigill,       /* 0x49 */ &&sigill,       /* 0x4a */ &&sigill,       /* 0x4b */ &&sigill,
    /* 0x4c */ &&OPCODE(0x4c), /* 0x4d */ &&OPCODE(0x4d), /* 0x4e */ &&OPCODE(0x4e), /* 0x4f */ &&OPCODE(0x4f),
    /* 0x50 */ &&sigill,       /* 0x51 */ &&sigill,       /* 0x52 */ &&sigill,       /* 0x53 */ &&sigill,
    /* 0x54 */ &&OPCODE(0x54), /* 0x55 */ &&OPCODE(0x55), /* 0x56 */ &&OPCODE(0x56), /* 0x57 */ &&OPCODE(0x57),
    /* 0x58 */ &&sigill,       /* 0x59 */ &&sigill,       /* 0x5a */ &&sigill,       /* 0x5b */ &&sigill,
    /* 0x5c */ &&OPCODE(0x5c), /* 0x5d */ &&OPCODE(0x5d), /* 0x5e */ &&OPCODE(0x5e), /* 0x5f */ &&OPCODE(0x5f),
    /* 0x60 */ &&sigill,       /* 0x61 */ &&sigill,       /* 0x62 */ &&sigill,       /* 0x63 */ &&sigill,
    /* 0x64 */ &&OPCODE(0x64), /* 0x65 */ &&OPCODE(0x65), /* 0x66 */ &&OPCODE(0x66), /* 0x67 */ &&OPCODE(0x67),
    /* 0x68 */ &&sigill,       /* 0x69 */ &&sigill,       /* 0x6a */ &&sigill,       /* 0x6b */ &&sigill,
    /* 0x6c */ &&OPCODE(0x6c), /* 0x6d */ &&OPCODE(0x6d), /* 0x6e */ &&OPCODE(0x6e), /* 0x6f */ &&OPCODE(0x6f),
    /* 0x70 */ &&sigill,       /* 0x71 */ &&sigill,       /* 0x72 */ &&sigill,       /* 0x73 */ &&sigill,
    /* 0x74 */ &&OPCODE(0x74), /* 0x75 */ &&OPCODE(0x75), /* 0x76 */ &&OPCODE(0x76), /* 0x77 */ &&OPCODE(0x77),
    /* 0x78 */ &&sigill,       /* 0x79 */ &&sigill,       /* 0x7a */ &&sigill,       /* 0x7b */ &&sigill,
    /* 0x7c */ &&OPCODE(0x7c), /* 0x7d */ &&OPCODE(0x7d), /* 0x7e */ &&OPCODE(0x7e), /* 0x7f */ &&OPCODE(0x7f),
    /* 0x80 */ &&sigill,       /* 0x81 */ &&sigill,       /* 0x82 */ &&sigill,       /* 0x83 */ &&sigill,
    /* 0x84 */ &&sigill,       /* 0x85 */ &&OPCODE(0x85), /* 0x86 */ &&OPCODE(0x86), /* 0x87 */ &&sigill,
    /* 0x88 */ &&sigill,       /* 0x89 */ &&sigill,       /* 0x8a */ &&sigill,       /* 0x8b */ &&sigill,
    /* 0x8c */ &&OPCODE(0x8c), /* 0x8d */ &&OPCODE(0x8d), /* 0x8e */ &&OPCODE(0x8e), /* 0x8f */ &&OPCODE(0x8f),
    /* 0x90 */ &&sigill,       /* 0x91 */ &&sigill,       /* 0x92 */ &&sigill,       /* 0x93 */ &&sigill,
    /* 0x94 */ &&sigill,       /* 0x95 */ &&OPCODE(0x95), /* 0x96 */ &&OPCODE(0x96), /* 0x97 */ &&sigill,
    /* 0x98 */ &&sigill,       /* 0x99 */ &&sigill,       /* 0x9a */ &&sigill,       /* 0x9b */ &&sigill,
    /* 0x9c */ &&sigill,       /* 0x9d */ &&sigill,       /* 0x9e */ &&OPCODE(0x9e), /* 0x9f */ &&sigill,
    /* 0xa0 */ &&sigill,       /* 0xa1 */ &&sigill,       /* 0xa2 */ &&sigill,       /* 0xa3 */ &&sigill,
    /* 0xa4 */ &&OPCODE(0xa4), /* 0xa5 */ &&OPCODE(0xa5), /* 0xa6 */ &&sigill,       /* 0xa7 */ &&OPCODE(0xa7),
    /* 0xa8 */ &&sigill,       /* 0xa9 */ &&sigill,       /* 0xaa */ &&sigill,       /* 0xab */ &&sigill,
    /* 0xac */ &&OPCODE(0xac), /* 0xad */ &&OPCODE(0xad), /* 0xae */ &&sigill,       /* 0xaf */ &&OPCODE(0xaf),
    /* 0xb0 */ &&sigill,       /* 0xb1 */ &&sigill,       /* 0xb2 */ &&sigill,       /* 0xb3 */ &&sigill,
    /* 0xb4 */ &&OPCODE(0xb4), /* 0xb5 */ &&OPCODE(0xb5), /* 0xb6 */ &&OPCODE(0xb6), /* 0xb7 */ &&OPCODE(0xb7),
    /* 0xb8 */ &&sigill,       /* 0xb9 */ &&sigill,       /* 0xba */ &&sigill,       /* 0xbb */ &&sigill,
    /* 0xbc */ &&OPCODE(0xbc), /* 0xbd */ &&OPCODE(0xbd), /* 0xbe */ &&OPCODE(0xbe), /* 0xbf */ &&OPCODE(0xbf),
    /* 0xc0 */ &&sigill,       /* 0xc1 */ &&sigill,       /* 0xc2 */ &&sigill,       /* 0xc3 */ &&sigill,
    /* 0xc4 */ &&OPCODE(0xc4), /* 0xc5 */ &&OPCODE(0xc5), /* 0xc6 */ &&OPCODE(0xc6), /* 0xc7 */ &&OPCODE(0xc7),
    /* 0xc8 */ &&sigill,       /* 0xc9 */ &&sigill,       /* 0xca */ &&sigill,       /* 0xcb */ &&sigill,
    /* 0xcc */ &&OPCODE(0xcc), /* 0xcd */ &&OPCODE(0xcd), /* 0xce */ &&OPCODE(0xce), /* 0xcf */ &&OPCODE(0xcf),
    /* 0xd0 */ &&sigill,       /* 0xd1 */ &&sigill,       /* 0xd2 */ &&sigill,       /* 0xd3 */ &&sigill,
    /* 0xd4 */ &&sigill,       /* 0xd5 */ &&OPCODE(0xd5), /* 0xd6 */ &&OPCODE(0xd6), /* 0xd7 */ &&sigill,
    /* 0xd8 */ &&sigill,       /* 0xd9 */ &&sigill,       /* 0xda */ &&sigill,       /* 0xdb */ &&sigill,
    /* 0xdc */ &&OPCODE(0xdc), /* 0xdd */ &&OPCODE(0xdd), /* 0xde */ &&OPCODE(0xde), /* 0xdf */ &&sigill,
    /* 0xe0 */ &&sigill,       /* 0xe1 */ &&sigill,       /* 0xe2 */ &&sigill,       /* 0xe3 */ &&sigill,
    /* 0xe4 */ &&sigill,       /* 0xe5 */ &&sigill,       /* 0xe6 */ &&OPCODE(0xe6), /* 0xe7 */ &&sigill,
    /* 0xe8 */ &&sigill,       /* 0xe9 */ &&sigill,       /* 0xea */ &&sigill,       /* 0xeb */ &&sigill,
    /* 0xec */ &&sigill,       /* 0xed */ &&sigill,       /* 0xee */ &&OPCODE(0xee), /* 0xef */ &&sigill,
    /* 0xf0 */ &&sigill,       /* 0xf1 */ &&sigill,       /* 0xf2 */ &&sigill,       /* 0xf3 */ &&sigill,
    /* 0xf4 */ &&sigill,       /* 0xf5 */ &&sigill,       /* 0xf6 */ &&OPCODE(0xf6), /* 0xf7 */ &&OPCODE(0xf7),
    /* 0xf8 */ &&sigill,       /* 0xf9 */ &&sigill,       /* 0xfa */ &&sigill,       /* 0xfb */ &&sigill,
    /* 0xfc */ &&sigill,       /* 0xfd */ &&sigill,       /* 0xfe */ &&OPCODE(0xfe), /* 0xff */ &&sigill,
    },{
    /* SBPF version 1 */
    /* 0x00 */ &&sigill,       /* 0x01 */ &&sigill,       /* 0x02 */ &&sigill,       /* 0x03 */ &&sigill,
    /* 0x04 */ &&OPCODE(0x04), /* 0x05 */ &&OPCODE(0x05), /* 0x06 */ &&sigill,       /* 0x07 */ &&OPCODE(0x07),
    /* 0x08 */ &&sigill,       /* 0x09 */ &&sigill,       /* 0x0a */ &&sigill,       /* 0x0b */ &&sigill,
    /* 0x0c */ &&OPCODE(0x0c), /* 0x0d */ &&sigill,       /* 0x0e */ &&sigill,       /* 0x0f */ &&OPCODE(0x0f),
    /* 0x10 */ &&sigill,       /* 0x11 */ &&sigill,       /* 0x12 */ &&sigill,       /* 0x13 */ &&sigill,
    /* 0x14 */ &&OPCODE(0x14), /* 0x15 */ &&OPCODE(0x15), /* 0x16 */ &&sigill,       /* 0x17 */ &&OPCODE(0x17),
    /* 0x18 */ &&sigill,       /* 0x19 */ &&sigill,       /* 0x1a */ &&sigill,       /* 0x1b */ &&sigill,
    /* 0x1c */ &&OPCODE(0x1c), /* 0x1d */ &&OPCODE(0x1d), /* 0x1e */ &&sigill,       /* 0x1f */ &&OPCODE(0x1f),
    /* 0x20 */ &&sigill,       /* 0x21 */ &&sigill,       /* 0x22 */ &&sigill,       /* 0x23 */ &&sigill,
    /* 0x24 */ &&sigill,       /* 0x25 */ &&OPCODE(0x25), /* 0x26 */ &&sigill,       /* 0x27 */ &&sigill,
    /* 0x28 */ &&sigill,       /* 0x29 */ &&sigill,       /* 0x2a */ &&sigill,       /* 0x2b */ &&sigill,
    /* 0x2c */ &&sigill,       /* 0x2d */ &&OPCODE(0x2d), /* 0x2e */ &&sigill,       /* 0x2f */ &&sigill,
    /* 0x30 */ &&sigill,       /* 0x31 */ &&sigill,       /* 0x32 */ &&sigill,       /* 0x33 */ &&sigill,
    /* 0x34 */ &&sigill,       /* 0x35 */ &&OPCODE(0x35), /* 0x36 */ &&OPCODE(0x36), /* 0x37 */ &&sigill,
    /* 0x38 */ &&sigill,       /* 0x39 */ &&sigill,       /* 0x3a */ &&sigill,       /* 0x3b */ &&sigill,
    /* 0x3c */ &&sigill,       /* 0x3d */ &&OPCODE(0x3d), /* 0x3e */ &&OPCODE(0x3e), /* 0x3f */ &&sigill,
    /* 0x40 */ &&sigill,       /* 0x41 */ &&sigill,       /* 0x42 */ &&sigill,       /* 0x43 */ &&sigill,
    /* 0x44 */ &&OPCODE(0x44), /* 0x45 */ &&OPCODE(0x45), /* 0x46 */ &&OPCODE(0x46), /* 0x47 */ &&OPCODE(0x47),
    /* 0x48 */ &&sigill,       /* 0x49 */ &&sigill,       /* 0x4a */ &&sigill,       /* 0x4b */ &&sigill,
    /* 0x4c */ &&OPCODE(0x4c), /* 0x4d */ &&OPCODE(0x4d), /* 0x4e */ &&OPCODE(0x4e), /* 0x4f */ &&OPCODE(0x4f),
    /* 0x50 */ &&sigill,       /* 0x51 */ &&sigill,       /* 0x52 */ &&sigill,       /* 0x53 */ &&sigill,
    /* 0x54 */ &&OPCODE(0x54), /* 0x55 */ &&OPCODE(0x55), /* 0x56 */ &&OPCODE(0x56), /* 0x57 */ &&OPCODE(0x57),
    /* 0x58 */ &&sigill,       /* 0x59 */ &&sigill,       /* 0x5a */ &&sigill,       /* 0x5b */ &&sigill,
    /* 0x5c */ &&OPCODE(0x5c), /* 0x5d */ &&OPCODE(0x5d), /* 0x5e */ &&OPCODE(0x5e), /* 0x5f */ &&OPCODE(0x5f),
    /* 0x60 */ &&sigill,       /* 0x61 */ &&sigill,       /* 0x62 */ &&sigill,       /* 0x63 */ &&sigill,
    /* 0x64 */ &&OPCODE(0x64), /* 0x65 */ &&OPCODE(0x65), /* 0x66 */ &&OPCODE(0x66), /* 0x67 */ &&OPCODE(0x67),
    /* 0x68 */ &&sigill,       /* 0x69 */ &&sigill,       /* 0x6a */ &&sigill,       /* 0x6b */ &&sigill,
    /* 0x6c */ &&OPCODE(0x6c), /* 0x6d */ &&OPCODE(0x6d), /* 0x6e */ &&OPCODE(0x6e), /* 0x6f */ &&OPCODE(0x6f),
    /* 0x70 */ &&sigill,       /* 0x71 */ &&sigill,       /* 0x72 */ &&sigill,       /* 0x73 */ &&sigill,
    /* 0x74 */ &&OPCODE(0x74), /* 0x75 */ &&OPCODE(0x75), /* 0x76 */ &&OPCODE(0x76), /* 0x77 */ &&OPCODE(0x77),
    /* 0x78 */ &&sigill,       /* 0x79 */ &&sigill,       /* 0x7a */ &&sigill,       /* 0x7b */ &&sigill,
    /* 0x7c */ &&OPCODE(0x7c), /* 0x7d */ &&OPCODE(0x7d), /* 0x7e */ &&OPCODE(0x7e), /* 0x7f */ &&OPCODE(0x7f),
    /* 0x80 */ &&sigill,       /* 0x81 */ &&sigill,       /* 0x82 */ &&sigill,       /* 0x83 */ &&sigill,
    /* 0x84 */ &&sigill,       /* 0x85 */ &&OPCODE(0x85), /* 0x86 */ &&OPCODE(0x86), /* 0x87 */ &&sigill,
    /* 0x88 */ &&sigill,       /* 0x89 */ &&sigill,       /* 0x8a */ &&sigill,       /* 0x8b */ &&sigill,
    /* 0x8c */ &&OPCODE(0x8c), /* 0x8d */ &&OPCODE(0x8d), /* 0x8e */ &&OPCODE(0x8e), /* 0x8f */ &&OPCODE(0x8f),
    /* 0x90 */ &&sigill,       /* 0x91 */ &&sigill,       /* 0x92 */ &&sigill,       /* 0x93 */ &&sigill,
    /* 0x94 */ &&sigill,       /* 0x95 */ &&OPCODE(0x95), /* 0x96 */ &&OPCODE(0x96), /* 0x97 */ &&sigill,
    /* 0x98 */ &&sigill,       /* 0x99 */ &&sigill,       /* 0x9a */ &&sigill,       /* 0x9b */ &&sigill,
    /* 0x9c */ &&sigill,       /* 0x9d */ &&sigill,       /* 0x9e */ &&OPCODE(0x9e), /* 0x9f */ &&sigill,
    /* 0xa0 */ &&sigill,       /* 0xa1 */ &&sigill,       /* 0xa2 */ &&sigill,       /* 0xa3 */ &&sigill,
    /* 0xa4 */ &&OPCODE(0xa4), /* 0xa5 */ &&OPCODE(0xa5), /* 0xa6 */ &&sigill,       /* 0xa7 */ &&OPCODE(0xa7),
    /* 0xa8 */ &&sigill,       /* 0xa9 */ &&sigill,       /* 0xaa */ &&sigill,       /* 0xab */ &&sigill,
    /* 0xac */ &&OPCODE(0xac), /* 0xad */ &&OPCODE(0xad), /* 0xae */ &&sigill,       /* 0xaf */ &&OPCODE(0xaf),
    /* 0xb0 */ &&sigill,       /* 0xb1 */ &&sigill,       /* 0xb2 */ &&sigill,       /* 0xb3 */ &&sigill,
    /* 0xb4 */ &&OPCODE(0xb4), /* 0xb5 */ &&OPCODE(0xb5), /* 0xb6 */ &&OPCODE(0xb6), /* 0xb7 */ &&OPCODE(0xb7),
    /* 0xb8 */ &&sigill,       /* 0xb9 */ &&sigill,       /* 0xba */ &&sigill,       /* 0xbb */ &&sigill,
    /* 0xbc */ &&OPCODE(0xbc), /* 0xbd */ &&OPCODE(0xbd), /* 0xbe */ &&OPCODE(0xbe), /* 0xbf */ &&OPCODE(0xbf),
    /* 0xc0 */ &&sigill,       /* 0xc1 */ &&sigill,       /* 0xc2 */ &&sigill,       /* 0xc3 */ &&sigill,
    /* 0xc4 */ &&OPCODE(0xc4), /* 0xc5 */ &&OPCODE(0xc5), /* 0xc6 */ &&OPCODE(0xc6), /* 0xc7 */ &&OPCODE(0xc7),
    /* 0xc8 */ &&sigill,       /* 0xc9 */ &&sigill,       /* 0xca */ &&sigill,       /* 0xcb */ &&sigill,
    /* 0xcc */ &&OPCODE(0xcc), /* 0xcd */ &&OPCODE(0xcd), /* 0xce */ &&OPCODE(0xce), /* 0xcf */ &&OPCODE(0xcf),
    /* 0xd0 */ &&sigill,       /* 0xd1 */ &&sigill,       /* 0xd2 */ &&sigill,       /* 0xd3 */ &&sigill,
    /* 0xd4 */ &&sigill,       /* 0xd5 */ &&OPCODE(0xd5), /* 0xd6 */ &&OPCODE(0xd6), /* 0xd7 */ &&sigill,
    /* 0xd8 */ &&sigill,       /* 0xd9 */ &&sigill,       /* 0xda */ &&sigill,       /* 0xdb */ &&sigill,
    /* 0xdc */ &&OPCODE(0xdc), /* 0xdd */ &&OPCODE(0xdd), /* 0xde */ &&OPCODE(0xde), /* 0xdf */ &&sigill,
    /* 0xe0 */ &&sigill,       /* 0xe1 */ &&sigill,       /* 0xe2 */ &&sigill,       /* 0xe3 */ &&sigill,
    /* 0xe4 */ &&sigill,       /* 0xe5 */ &&sigill,       /* 0xe6 */ &&OPCODE(0xe6), /* 0xe7 */ &&sigill,
    /* 0xe8 */ &&sigill,       /* 0xe9 */ &&sigill,       /* 0xea */ &&sigill,       /* 0xeb */ &&sigill,
    /* 0xec */ &&sigill,       /* 0xed */ &&sigill,       /* 0xee */ &&OPCODE(0xee), /* 0xef */ &&sigill,
    /* 0xf0 */ &&sigill,       /* 0xf1 */ &&sigill,       /* 0xf2 */ &&sigill,       /* 0xf3 */ &&sigill,
    /* 0xf4 */ &&sigill,       /* 0xf5 */ &&sigill,       /* 0xf6 */ &&OPCODE(0xf6), /* 0xf7 */ &&OPCODE(0xf7),
    /* 0xf8 */ &&sigill,       /* 0xf9 */ &&sigill,       /* 0xfa */ &&sigill,       /* 0xfb */ &&sigill,
    /* 0xfc */ &&sigill,       /* 0xfd */ &&sigill,       /* 0xfe */ &&OPCODE(0xfe), /* 0xff */ &&sigill,
    },{
    /* SBPF version 2 */
    /* 0x00 */ &&sigill,       /* 0x01 */ &&sigill,       /* 0x02 */ &&sigill,       /* 0x03 */ &&sigill,
    /* 0x04 */ &&OPCODE(0x04), /* 0x05 */ &&OPCODE(0x05), /* 0x06 */ &&sigill,       /* 0x07 */ &&OPCODE(0x07),
    /* 0x08 */ &&sigill,       /* 0x09 */ &&sigill,       /* 0x0a */ &&sigill,       /* 0x0b */ &&sigill,
    /* 0x0c */ &&OPCODE(0x0c), /* 0x0d */ &&sigill,       /* 0x0e */ &&sigill,       /* 0x0f */ &&OPCODE(0x0f),
    /* 0x10 */ &&sigill,       /* 0x11 */ &&sigill,       /* 0x12 */ &&sigill,       /* 0x13 */ &&sigill,
    /* 0x14 */ &&OPCODE(0x14), /* 0x15 */ &&OPCODE(0x15), /* 0x16 */ &&sigill,       /* 0x17 */ &&OPCODE(0x17),
    /* 0x18 */ &&sigill,       /* 0x19 */ &&sigill,       /* 0x1a */ &&sigill,       /* 0x1b */ &&sigill,
    /* 0x1c */ &&OPCODE(0x1c), /* 0x1d */ &&OPCODE(0x1d), /* 0x1e */ &&sigill,       /* 0x1f */ &&OPCODE(0x1f),
    /* 0x20 */ &&sigill,       /* 0x21 */ &&sigill,       /* 0x22 */ &&sigill,       /* 0x23 */ &&sigill,
    /* 0x24 */ &&sigill,       /* 0x25 */ &&OPCODE(0x25), /* 0x26 */ &&sigill,       /* 0x27 */ &&sigill,
    /* 0x28 */ &&sigill,       /* 0x29 */ &&sigill,       /* 0x2a */ &&sigill,       /* 0x2b */ &&sigill,
    /* 0x2c */ &&sigill,       /* 0x2d */ &&OPCODE(0x2d), /* 0x2e */ &&sigill,       /* 0x2f */ &&sigill,
    /* 0x30 */ &&sigill,       /* 0x31 */ &&sigill,       /* 0x32 */ &&sigill,       /* 0x33 */ &&sigill,
    /* 0x34 */ &&sigill,       /* 0x35 */ &&OPCODE(0x35), /* 0x36 */ &&OPCODE(0x36), /* 0x37 */ &&sigill,
    /* 0x38 */ &&sigill,       /* 0x39 */ &&sigill,       /* 0x3a */ &&sigill,       /* 0x3b */ &&sigill,
    /* 0x3c */ &&sigill,       /* 0x3d */ &&OPCODE(0x3d), /* 0x3e */ &&OPCODE(0x3e), /* 0x3f */ &&sigill,
    /* 0x40 */ &&sigill,       /* 0x41 */ &&sigill,       /* 0x42 */ &&sigill,       /* 0x43 */ &&sigill,
    /* 0x44 */ &&OPCODE(0x44), /* 0x45 */ &&OPCODE(0x45), /* 0x46 */ &&OPCODE(0x46), /* 0x47 */ &&OPCODE(0x47),
    /* 0x48 */ &&sigill,       /* 0x49 */ &&sigill,       /* 0x4a */ &&sigill,       /* 0x4b */ &&sigill,
    /* 0x4c */ &&OPCODE(0x4c), /* 0x4d */ &&OPCODE(0x4d), /* 0x4e */ &&OPCODE(0x4e), /* 0x4f */ &&OPCODE(0x4f),
    /* 0x50 */ &&sigill,       /* 0x51 */ &&sigill,       /* 0x52 */ &&sigill,       /* 0x53 */ &&sigill,
    /* 0x54 */ &&OPCODE(0x54), /* 0x55 */ &&OPCODE(0x55), /* 0x56 */ &&OPCODE(0x56), /* 0x57 */ &&OPCODE(0x57),
    /* 0x58 */ &&sigill,       /* 0x59 */ &&sigill,       /* 0x5a */ &&sigill,       /* 0x5b */ &&sigill,
    /* 0x5c */ &&OPCODE(0x5c), /* 0x5d */ &&OPCODE(0x5d), /* 0x5e */ &&OPCODE(0x5e), /* 0x5f */ &&OPCODE(0x5f),
    /* 0x60 */ &&sigill,       /* 0x61 */ &&sigill,       /* 0x62 */ &&sigill,       /* 0x63 */ &&sigill,
    /* 0x64 */ &&OPCODE(0x64), /* 0x65 */ &&OPCODE(0x65), /* 0x66 */ &&OPCODE(0x66), /* 0x67 */ &&OPCODE(0x67),
    /* 0x68 */ &&sigill,       /* 0x69 */ &&sigill,       /* 0x6a */ &&sigill,       /* 0x6b */ &&sigill,
    /* 0x6c */ &&OPCODE(0x6c), /* 0x6d */ &&OPCODE(0x6d), /* 0x6e */ &&OPCODE(0x6e), /* 0x6f */ &&OPCODE(0x6f),
    /* 0x70 */ &&sigill,       /* 0x71 */ &&sigill,       /* 0x72 */ &&sigill,       /* 0x73 */ &&sigill,
    /* 0x74 */ &&OPCODE(0x74), /* 0x75 */ &&OPCODE(0x75), /* 0x76 */ &&OPCODE(0x76), /* 0x77 */ &&OPCODE(0x77),
    /* 0x78 */ &&sigill,       /* 0x79 */ &&sigill,       /* 0x7a */ &&sigill,       /* 0x7b */ &&sigill,
    /* 0x7c */ &&OPCODE(0x7c), /* 0x7d */ &&OPCODE(0x7d), /* 0x7e */ &&OPCODE(0x7e), /* 0x7f */ &&OPCODE(0x7f),
    /* 0x80 */ &&sigill,       /* 0x81 */ &&sigill,       /* 0x82 */ &&sigill,       /* 0x83 */ &&sigill,
    /* 0x84 */ &&sigill,       /* 0x85 */ &&OPCODE(0x85), /* 0x86 */ &&OPCODE(0x86), /* 0x87 */ &&sigill,
    /* 0x88 */ &&sigill,       /* 0x89 */ &&sigill,       /* 0x8a */ &&sigill,       /* 0x8b */ &&sigill,
    /* 0x8c */ &&OPCODE(0x8c), /* 0x8d */ &&OPCODE(0x8d), /* 0x8e */ &&OPCODE(0x8e), /* 0x8f */ &&OPCODE(0x8f),
    /* 0x90 */ &&sigill,       /* 0x91 */ &&sigill,       /* 0x92 */ &&sigill,       /* 0x93 */ &&sigill,
    /* 0x94 */ &&sigill,       /* 0x95 */ &&OPCODE(0x95), /* 0x96 */ &&OPCODE(0x96), /* 0x97 */ &&sigill,
    /* 0x98 */ &&sigill,       /* 0x99 */ &&sigill,       /* 0x9a */ &&sigill,       /* 0x9b */ &&sigill,
    /* 0x9c */ &&sigill,       /* 0x9d */ &&sigill,       /* 0x9e */ &&OPCODE(0x9e), /* 0x9f */ &&sigill,
    /* 0xa0 */ &&sigill,       /* 0xa1 */ &&sigill,       /* 0xa2 */ &&sigill,       /* 0xa3 */ &&sigill,
    /* 0xa4 */ &&OPCODE(0xa4), /* 0xa5 */ &&OPCODE(0xa5), /* 0xa6 */ &&sigill,       /* 0xa7 */ &&OPCODE(0xa7),
    /* 0xa8 */ &&sigill,       /* 0xa9 */ &&sigill,       /* 0xaa */ &&sigill,       /* 0xab */ &&sigill,
    /* 0xac */ &&OPCODE(0xac), /* 0xad */ &&OPCODE(0xad), /* 0xae */ &&sigill,       /* 0xaf */ &&OPCODE(0xaf),
    /* 0xb0 */ &&sigill,       /* 0xb1 */ &&sigill,       /* 0xb2 */ &&sigill,       /* 0xb3 */ &&sigill,
    /* 0xb4 */ &&OPCODE(0xb4), /* 0xb5 */ &&OPCODE(0xb5), /* 0xb6 */ &&OPCODE(0xb6), /* 0xb7 */ &&OPCODE(0xb7),
    /* 0xb8 */ &&sigill,       /* 0xb9 */ &&sigill,       /* 0xba */ &&sigill,       /* 0xbb */ &&sigill,
    /* 0xbc */ &&OPCODE(0xbc), /* 0xbd */ &&OPCODE(0xbd), /* 0xbe */ &&OPCODE(0xbe), /* 0xbf */ &&OPCODE(0xbf),
    /* 0xc0 */ &&sigill,       /* 0xc1 */ &&sigill,       /* 0xc2 */ &&sigill,       /* 0xc3 */ &&sigill,
    /* 0xc4 */ &&OPCODE(0xc4), /* 0xc5 */ &&OPCODE(0xc5), /* 0xc6 */ &&OPCODE(0xc6), /* 0xc7 */ &&OPCODE(0xc7),
    /* 0xc8 */ &&sigill,       /* 0xc9 */ &&sigill,       /* 0xca */ &&sigill,       /* 0xcb */ &&sigill,
    /* 0xcc */ &&OPCODE(0xcc), /* 0xcd */ &&OPCODE(0xcd), /* 0xce */ &&OPCODE(0xce), /* 0xcf */ &&OPCODE(0xcf),
    /* 0xd0 */ &&sigill,       /* 0xd1 */ &&sigill,       /* 0xd2 */ &&sigill,       /* 0xd3 */ &&sigill,
    /* 0xd4 */ &&sigill,       /* 0xd5 */ &&OPCODE(0xd5), /* 0xd6 */ &&OPCODE(0xd6), /* 0xd7 */ &&sigill,
    /* 0xd8 */ &&sigill,       /* 0xd9 */ &&sigill,       /* 0xda */ &&sigill,       /* 0xdb */ &&sigill,
    /* 0xdc */ &&OPCODE(0xdc), /* 0xdd */ &&OPCODE(0xdd), /* 0xde */ &&OPCODE(0xde), /* 0xdf */ &&sigill,
    /* 0xe0 */ &&sigill,       /* 0xe1 */ &&sigill,       /* 0xe2 */ &&sigill,       /* 0xe3 */ &&sigill,
    /* 0xe4 */ &&sigill,       /* 0xe5 */ &&sigill,       /* 0xe6 */ &&OPCODE(0xe6), /* 0xe7 */ &&sigill,
    /* 0xe8 */ &&sigill,       /* 0xe9 */ &&sigill,       /* 0xea */ &&sigill,       /* 0xeb */ &&sigill,
    /* 0xec */ &&sigill,       /* 0xed */ &&sigill,       /* 0xee */ &&OPCODE(0xee), /* 0xef */ &&sigill,
    /* 0xf0 */ &&sigill,       /* 0xf1 */ &&sigill,       /* 0xf2 */ &&sigill,       /* 0xf3 */ &&sigill,
    /* 0xf4 */ &&sigill,       /* 0xf5 */ &&sigill,       /* 0xf6 */ &&OPCODE(0xf6), /* 0xf7 */ &&OPCODE(0xf7),
    /* 0xf8 */ &&sigill,       /* 0xf9 */ &&sigill,       /* 0xfa */ &&sigill,       /* 0xfb */ &&sigill,
    /* 0xfc */ &&sigill,       /* 0xfd */ &&sigill,       /* 0xfe */ &&OPCODE(0xfe), /* 0xff */ &&sigill,
    },{
    /* SBPF version 3 */
    /* 0x00 */ &&sigill,       /* 0x01 */ &&sigill,       /* 0x02 */ &&sigill,       /* 0x03 */ &&sigill,
    /* 0x04 */ &&OPCODE(0x04), /* 0x05 */ &&OPCODE(0x05), /* 0x06 */ &&sigill,       /* 0x07 */ &&OPCODE(0x07),
    /* 0x08 */ &&sigill,       /* 0x09 */ &&sigill,       /* 0x0a */ &&sigill,       /* 0x0b */ &&sigill,
    /* 0x0c */ &&OPCODE(0x0c), /* 0x0d */ &&sigill,       /* 0x0e */ &&sigill,       /* 0x0f */ &&OPCODE(0x0f),
    /* 0x10 */ &&sigill,       /* 0x11 */ &&sigill,       /* 0x12 */ &&sigill,       /* 0x13 */ &&sigill,
    /* 0x14 */ &&OPCODE(0x14), /* 0x15 */ &&OPCODE(0x15), /* 0x16 */ &&sigill,       /* 0x17 */ &&OPCODE(0x17),
    /* 0x18 */ &&sigill,       /* 0x19 */ &&sigill,       /* 0x1a */ &&sigill,       /* 0x1b */ &&sigill,
    /* 0x1c */ &&OPCODE(0x1c), /* 0x1d */ &&OPCODE(0x1d), /* 0x1e */ &&sigill,       /* 0x1f */ &&OPCODE(0x1f),
    /* 0x20 */ &&sigill,       /* 0x21 */ &&sigill,       /* 0x22 */ &&sigill,       /* 0x23 */ &&sigill,
    /* 0x24 */ &&sigill,       /* 0x25 */ &&OPCODE(0x25), /* 0x26 */ &&sigill,       /* 0x27 */ &&sigill,
    /* 0x28 */ &&sigill,       /* 0x29 */ &&sigill,       /* 0x2a */ &&sigill,       /* 0x2b */ &&sigill,
    /* 0x2c */ &&sigill,       /* 0x2d */ &&OPCODE(0x2d), /* 0x2e */ &&sigill,       /* 0x2f */ &&sigill,
    /* 0x30 */ &&sigill,       /* 0x31 */ &&sigill,       /* 0x32 */ &&sigill,       /* 0x33 */ &&sigill,
    /* 0x34 */ &&sigill,       /* 0x35 */ &&OPCODE(0x35), /* 0x36 */ &&OPCODE(0x36), /* 0x37 */ &&sigill,
    /* 0x38 */ &&sigill,       /* 0x39 */ &&sigill,       /* 0x3a */ &&sigill,       /* 0x3b */ &&sigill,
    /* 0x3c */ &&sigill,       /* 0x3d */ &&OPCODE(0x3d), /* 0x3e */ &&OPCODE(0x3e), /* 0x3f */ &&sigill,
    /* 0x40 */ &&sigill,       /* 0x41 */ &&sigill,       /* 0x42 */ &&sigill,       /* 0x43 */ &&sigill,
    /* 0x44 */ &&OPCODE(0x44), /* 0x45 */ &&OPCODE(0x45), /* 0x46 */ &&OPCODE(0x46), /* 0x47 */ &&OPCODE(0x47),
    /* 0x48 */ &&sigill,       /* 0x49 */ &&sigill,       /* 0x4a */ &&sigill,       /* 0x4b */ &&sigill,
    /* 0x4c */ &&OPCODE(0x4c), /* 0x4d */ &&OPCODE(0x4d), /* 0x4e */ &&OPCODE(0x4e), /* 0x4f */ &&OPCODE(0x4f),
    /* 0x50 */ &&sigill,       /* 0x51 */ &&sigill,       /* 0x52 */ &&sigill,       /* 0x53 */ &&sigill,
    /* 0x54 */ &&OPCODE(0x54), /* 0x55 */ &&OPCODE(0x55), /* 0x56 */ &&OPCODE(0x56), /* 0x57 */ &&OPCODE(0x57),
    /* 0x58 */ &&sigill,       /* 0x59 */ &&sigill,       /* 0x5a */ &&sigill,       /* 0x5b */ &&sigill,
    /* 0x5c */ &&OPCODE(0x5c), /* 0x5d */ &&OPCODE(0x5d), /* 0x5e */ &&OPCODE(0x5e), /* 0x5f */ &&OPCODE(0x5f),
    /* 0x60 */ &&sigill,       /* 0x61 */ &&sigill,       /* 0x62 */ &&sigill,       /* 0x63 */ &&sigill,
    /* 0x64 */ &&OPCODE(0x64), /* 0x65 */ &&OPCODE(0x65), /* 0x66 */ &&OPCODE(0x66), /* 0x67 */ &&OPCODE(0x67),
    /* 0x68 */ &&sigill,       /* 0x69 */ &&sigill,       /* 0x6a */ &&sigill,       /* 0x6b */ &&sigill,
    /* 0x6c */ &&OPCODE(0x6c), /* 0x6d */ &&OPCODE(0x6d), /* 0x6e */ &&OPCODE(0x6e), /* 0x6f */ &&OPCODE(0x6f),
    /* 0x70 */ &&sigill,       /* 0x71 */ &&sigill,       /* 0x72 */ &&sigill,       /* 0x73 */ &&sigill,
    /* 0x74 */ &&OPCODE(0x74), /* 0x75 */ &&OPCODE(0x75), /* 0x76 */ &&OPCODE(0x76), /* 0x77 */ &&OPCODE(0x77),
    /* 0x78 */ &&sigill,       /* 0x79 */ &&sigill,       /* 0x7a */ &&sigill,       /* 0x7b */ &&sigill,
    /* 0x7c */ &&OPCODE(0x7c), /* 0x7d */ &&OPCODE(0x7d), /* 0x7e */ &&OPCODE(0x7e), /* 0x7f */ &&OPCODE(0x7f),
    /* 0x80 */ &&sigill,       /* 0x81 */ &&sigill,       /* 0x82 */ &&sigill,       /* 0x83 */ &&sigill,
    /* 0x84 */ &&sigill,       /* 0x85 */ &&OPCODE(0x85), /* 0x86 */ &&OPCODE(0x86), /* 0x87 */ &&sigill,
    /* 0x88 */ &&sigill,       /* 0x89 */ &&sigill,       /* 0x8a */ &&sigill,       /* 0x8b */ &&sigill,
    /* 0x8c */ &&OPCODE(0x8c), /* 0x8d */ &&OPCODE(0x8d), /* 0x8e */ &&OPCODE(0x8e), /* 0x8f */ &&OPCODE(0x8f),
    /* 0x90 */ &&sigill,       /* 0x91 */ &&sigill,       /* 0x92 */ &&sigill,       /* 0x93 */ &&sigill,
    /* 0x94 */ &&sigill,       /* 0x95 */ &&OPCODE(0x95), /* 0x96 */ &&OPCODE(0x96), /* 0x97 */ &&sigill,
    /* 0x98 */ &&sigill,       /* 0x99 */ &&sigill,       /* 0x9a */ &&sigill,       /* 0x9b */ &&sigill,
    /* 0x9c */ &&sigill,       /* 0x9d */ &&sigill,       /* 0x9e */ &&OPCODE(0x9e), /* 0x9f */ &&sigill,
    /* 0xa0 */ &&sigill,       /* 0xa1 */ &&sigill,       /* 0xa2 */ &&sigill,       /* 0xa3 */ &&sigill,
    /* 0xa4 */ &&OPCODE(0xa4), /* 0xa5 */ &&OPCODE(0xa5), /* 0xa6 */ &&sigill,       /* 0xa7 */ &&OPCODE(0xa7),
    /* 0xa8 */ &&sigill,       /* 0xa9 */ &&sigill,       /* 0xaa */ &&sigill,       /* 0xab */ &&sigill,
    /* 0xac */ &&OPCODE(0xac), /* 0xad */ &&OPCODE(0xad), /* 0xae */ &&sigill,       /* 0xaf */ &&OPCODE(0xaf),
    /* 0xb0 */ &&sigill,       /* 0xb1 */ &&sigill,       /* 0xb2 */ &&sigill,       /* 0xb3 */ &&sigill,
    /* 0xb4 */ &&OPCODE(0xb4), /* 0xb5 */ &&OPCODE(0xb5), /* 0xb6 */ &&OPCODE(0xb6), /* 0xb7 */ &&OPCODE(0xb7),
    /* 0xb8 */ &&sigill,       /* 0xb9 */ &&sigill,       /* 0xba */ &&sigill,       /* 0xbb */ &&sigill,
    /* 0xbc */ &&OPCODE(0xbc), /* 0xbd */ &&OPCODE(0xbd), /* 0xbe */ &&OPCODE(0xbe), /* 0xbf */ &&OPCODE(0xbf),
    /* 0xc0 */ &&sigill,       /* 0xc1 */ &&sigill,       /* 0xc2 */ &&sigill,       /* 0xc3 */ &&sigill,
    /* 0xc4 */ &&OPCODE(0xc4), /* 0xc5 */ &&OPCODE(0xc5), /* 0xc6 */ &&OPCODE(0xc6), /* 0xc7 */ &&OPCODE(0xc7),
    /* 0xc8 */ &&sigill,       /* 0xc9 */ &&sigill,       /* 0xca */ &&sigill,       /* 0xcb */ &&sigill,
    /* 0xcc */ &&OPCODE(0xcc), /* 0xcd */ &&OPCODE(0xcd), /* 0xce */ &&OPCODE(0xce), /* 0xcf */ &&OPCODE(0xcf),
    /* 0xd0 */ &&sigill,       /* 0xd1 */ &&sigill,       /* 0xd2 */ &&sigill,       /* 0xd3 */ &&sigill,
    /* 0xd4 */ &&sigill,       /* 0xd5 */ &&OPCODE(0xd5), /* 0xd6 */ &&OPCODE(0xd6), /* 0xd7 */ &&sigill,
    /* 0xd8 */ &&sigill,       /* 0xd9 */ &&sigill,       /* 0xda */ &&sigill,       /* 0xdb */ &&sigill,
    /* 0xdc */ &&OPCODE(0xdc), /* 0xdd */ &&OPCODE(0xdd), /* 0xde */ &&OPCODE(0xde), /* 0xdf */ &&sigill,
    /* 0xe0 */ &&sigill,       /* 0xe1 */ &&sigill,       /* 0xe2 */ &&sigill,       /* 0xe3 */ &&sigill,
    /* 0xe4 */ &&sigill,       /* 0xe5 */ &&sigill,       /* 0xe6 */ &&OPCODE(0xe6), /* 0xe7 */ &&sigill,
    /* 0xe8 */ &&sigill,       /* 0xe9 */ &&sigill,       /* 0xea */ &&sigill,       /* 0xeb */ &&sigill,
    /* 0xec */ &&sigill,       /* 0xed */ &&sigill,       /* 0xee */ &&OPCODE(0xee), /* 0xef */ &&sigill,
    /* 0xf0 */ &&sigill,       /* 0xf1 */ &&sigill,       /* 0xf2 */ &&sigill,       /* 0xf3 */ &&sigill,
    /* 0xf4 */ &&sigill,       /* 0xf5 */ &&sigill,       /* 0xf6 */ &&OPCODE(0xf6), /* 0xf7 */ &&OPCODE(0xf7),
    /* 0xf8 */ &&sigill,       /* 0xf9 */ &&sigill,       /* 0xfa */ &&sigill,       /* 0xfb */ &&sigill,
    /* 0xfc */ &&sigill,       /* 0xfd */ &&sigill,       /* 0xfe */ &&OPCODE(0xfe), /* 0xff */ &&sigill
#   undef OPCODE
    }
  };
