/* Automatically generated nanopb header */
/* Generated by nanopb-1.0.0-dev */

#ifndef PB_AUTH_AUTH_PB_H_INCLUDED
#define PB_AUTH_AUTH_PB_H_INCLUDED
#include "../../../ballet/nanopb/pb_firedancer.h"
#include "timestamp.pb.h"

#if PB_PROTO_HEADER_VERSION != 40
#error Regenerate this file with the current version of nanopb generator.
#endif

/* Enum definitions */
typedef enum _auth_Role {
    auth_Role_RELAYER = 0,
    auth_Role_SEARCHER = 1,
    auth_Role_VALIDATOR = 2,
    auth_Role_SHREDSTREAM_SUBSCRIBER = 3
} auth_Role;

/* Struct definitions */
typedef PB_BYTES_ARRAY_T(32) auth_GenerateAuthChallengeRequest_pubkey_t;
typedef struct _auth_GenerateAuthChallengeRequest {
    /* / Role the client is attempting to generate tokens for. */
    auth_Role role;
    /* / Client's 32 byte pubkey. */
    auth_GenerateAuthChallengeRequest_pubkey_t pubkey;
} auth_GenerateAuthChallengeRequest;

typedef PB_BYTES_ARRAY_T(9) auth_GenerateAuthChallengeResponse_challenge_t;
typedef struct _auth_GenerateAuthChallengeResponse {
    auth_GenerateAuthChallengeResponse_challenge_t challenge; /* string */
} auth_GenerateAuthChallengeResponse;

typedef PB_BYTES_ARRAY_T(55) auth_GenerateAuthTokensRequest_challenge_t;
typedef PB_BYTES_ARRAY_T(32) auth_GenerateAuthTokensRequest_client_pubkey_t;
typedef PB_BYTES_ARRAY_T(64) auth_GenerateAuthTokensRequest_signed_challenge_t;
typedef struct _auth_GenerateAuthTokensRequest {
    /* / The pre-signed challenge. */
    auth_GenerateAuthTokensRequest_challenge_t challenge; /* string */
    /* / The signing keypair's corresponding 32 byte pubkey. */
    auth_GenerateAuthTokensRequest_client_pubkey_t client_pubkey;
    /* / The 64 byte signature of the challenge signed by the client's private key. The private key must correspond to
 the pubkey passed in the [GenerateAuthChallenge] method. The client is expected to sign the challenge token
 prepended with their pubkey. For example sign(pubkey, challenge). */
    auth_GenerateAuthTokensRequest_signed_challenge_t signed_challenge;
} auth_GenerateAuthTokensRequest;

typedef PB_BYTES_ARRAY_T(1024) auth_Token_value_t;
typedef struct _auth_Token {
    /* / The token. */
    auth_Token_value_t value; /* string */
    /* / When the token will expire. */
    bool has_expires_at_utc;
    google_protobuf_Timestamp expires_at_utc;
} auth_Token;

typedef struct _auth_GenerateAuthTokensResponse {
    /* / The token granting access to resources. */
    bool has_access_token;
    auth_Token access_token;
    /* / The token used to refresh the access_token. This has a longer TTL than the access_token. */
    bool has_refresh_token;
    auth_Token refresh_token;
} auth_GenerateAuthTokensResponse;

typedef PB_BYTES_ARRAY_T(1024) auth_RefreshAccessTokenRequest_refresh_token_t;
typedef struct _auth_RefreshAccessTokenRequest {
    /* / Non-expired refresh token obtained from the [GenerateAuthTokens] method. */
    auth_RefreshAccessTokenRequest_refresh_token_t refresh_token; /* string */
} auth_RefreshAccessTokenRequest;

typedef struct _auth_RefreshAccessTokenResponse {
    /* / Fresh access_token. */
    bool has_access_token;
    auth_Token access_token;
} auth_RefreshAccessTokenResponse;


#ifdef __cplusplus
extern "C" {
#endif

/* Helper constants for enums */
#define _auth_Role_MIN auth_Role_RELAYER
#define _auth_Role_MAX auth_Role_SHREDSTREAM_SUBSCRIBER
#define _auth_Role_ARRAYSIZE ((auth_Role)(auth_Role_SHREDSTREAM_SUBSCRIBER+1))

#define auth_GenerateAuthChallengeRequest_role_ENUMTYPE auth_Role








/* Initializer values for message structs */
#define auth_GenerateAuthChallengeRequest_init_default {_auth_Role_MIN, {0, {0}}}
#define auth_GenerateAuthChallengeResponse_init_default {{0, {0}}}
#define auth_GenerateAuthTokensRequest_init_default {{0, {0}}, {0, {0}}, {0, {0}}}
#define auth_Token_init_default                  {{0, {0}}, false, google_protobuf_Timestamp_init_default}
#define auth_GenerateAuthTokensResponse_init_default {false, auth_Token_init_default, false, auth_Token_init_default}
#define auth_RefreshAccessTokenRequest_init_default {{0, {0}}}
#define auth_RefreshAccessTokenResponse_init_default {false, auth_Token_init_default}
#define auth_GenerateAuthChallengeRequest_init_zero {_auth_Role_MIN, {0, {0}}}
#define auth_GenerateAuthChallengeResponse_init_zero {{0, {0}}}
#define auth_GenerateAuthTokensRequest_init_zero {{0, {0}}, {0, {0}}, {0, {0}}}
#define auth_Token_init_zero                     {{0, {0}}, false, google_protobuf_Timestamp_init_zero}
#define auth_GenerateAuthTokensResponse_init_zero {false, auth_Token_init_zero, false, auth_Token_init_zero}
#define auth_RefreshAccessTokenRequest_init_zero {{0, {0}}}
#define auth_RefreshAccessTokenResponse_init_zero {false, auth_Token_init_zero}

/* Field tags (for use in manual encoding/decoding) */
#define auth_GenerateAuthChallengeRequest_role_tag 1
#define auth_GenerateAuthChallengeRequest_pubkey_tag 2
#define auth_GenerateAuthChallengeResponse_challenge_tag 1
#define auth_GenerateAuthTokensRequest_challenge_tag 1
#define auth_GenerateAuthTokensRequest_client_pubkey_tag 2
#define auth_GenerateAuthTokensRequest_signed_challenge_tag 3
#define auth_Token_value_tag                     1
#define auth_Token_expires_at_utc_tag            2
#define auth_GenerateAuthTokensResponse_access_token_tag 1
#define auth_GenerateAuthTokensResponse_refresh_token_tag 2
#define auth_RefreshAccessTokenRequest_refresh_token_tag 1
#define auth_RefreshAccessTokenResponse_access_token_tag 1

/* Struct field encoding specification for nanopb */
#define auth_GenerateAuthChallengeRequest_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UENUM,    role,              1) \
X(a, STATIC,   SINGULAR, BYTES,    pubkey,            2)
#define auth_GenerateAuthChallengeRequest_CALLBACK NULL
#define auth_GenerateAuthChallengeRequest_DEFAULT NULL

#define auth_GenerateAuthChallengeResponse_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BYTES,    challenge,         1)
#define auth_GenerateAuthChallengeResponse_CALLBACK NULL
#define auth_GenerateAuthChallengeResponse_DEFAULT NULL

#define auth_GenerateAuthTokensRequest_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BYTES,    challenge,         1) \
X(a, STATIC,   SINGULAR, BYTES,    client_pubkey,     2) \
X(a, STATIC,   SINGULAR, BYTES,    signed_challenge,   3)
#define auth_GenerateAuthTokensRequest_CALLBACK NULL
#define auth_GenerateAuthTokensRequest_DEFAULT NULL

#define auth_Token_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BYTES,    value,             1) \
X(a, STATIC,   OPTIONAL, MESSAGE,  expires_at_utc,    2)
#define auth_Token_CALLBACK NULL
#define auth_Token_DEFAULT NULL
#define auth_Token_expires_at_utc_MSGTYPE google_protobuf_Timestamp

#define auth_GenerateAuthTokensResponse_FIELDLIST(X, a) \
X(a, STATIC,   OPTIONAL, MESSAGE,  access_token,      1) \
X(a, STATIC,   OPTIONAL, MESSAGE,  refresh_token,     2)
#define auth_GenerateAuthTokensResponse_CALLBACK NULL
#define auth_GenerateAuthTokensResponse_DEFAULT NULL
#define auth_GenerateAuthTokensResponse_access_token_MSGTYPE auth_Token
#define auth_GenerateAuthTokensResponse_refresh_token_MSGTYPE auth_Token

#define auth_RefreshAccessTokenRequest_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BYTES,    refresh_token,     1)
#define auth_RefreshAccessTokenRequest_CALLBACK NULL
#define auth_RefreshAccessTokenRequest_DEFAULT NULL

#define auth_RefreshAccessTokenResponse_FIELDLIST(X, a) \
X(a, STATIC,   OPTIONAL, MESSAGE,  access_token,      1)
#define auth_RefreshAccessTokenResponse_CALLBACK NULL
#define auth_RefreshAccessTokenResponse_DEFAULT NULL
#define auth_RefreshAccessTokenResponse_access_token_MSGTYPE auth_Token

extern const pb_msgdesc_t auth_GenerateAuthChallengeRequest_msg;
extern const pb_msgdesc_t auth_GenerateAuthChallengeResponse_msg;
extern const pb_msgdesc_t auth_GenerateAuthTokensRequest_msg;
extern const pb_msgdesc_t auth_Token_msg;
extern const pb_msgdesc_t auth_GenerateAuthTokensResponse_msg;
extern const pb_msgdesc_t auth_RefreshAccessTokenRequest_msg;
extern const pb_msgdesc_t auth_RefreshAccessTokenResponse_msg;

/* Defines for backwards compatibility with code written before nanopb-0.4.0 */
#define auth_GenerateAuthChallengeRequest_fields &auth_GenerateAuthChallengeRequest_msg
#define auth_GenerateAuthChallengeResponse_fields &auth_GenerateAuthChallengeResponse_msg
#define auth_GenerateAuthTokensRequest_fields &auth_GenerateAuthTokensRequest_msg
#define auth_Token_fields &auth_Token_msg
#define auth_GenerateAuthTokensResponse_fields &auth_GenerateAuthTokensResponse_msg
#define auth_RefreshAccessTokenRequest_fields &auth_RefreshAccessTokenRequest_msg
#define auth_RefreshAccessTokenResponse_fields &auth_RefreshAccessTokenResponse_msg

/* Maximum encoded size of messages (where known) */
#define AUTH_AUTH_PB_H_MAX_SIZE                  auth_GenerateAuthTokensResponse_size
#define auth_GenerateAuthChallengeRequest_size   36
#define auth_GenerateAuthChallengeResponse_size  11
#define auth_GenerateAuthTokensRequest_size      157
#define auth_GenerateAuthTokensResponse_size     2108
#define auth_RefreshAccessTokenRequest_size      1027
#define auth_RefreshAccessTokenResponse_size     1054
#define auth_Token_size                          1051

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
