/* Do not compile this directly.  These test vectors were computed by
   running the stock openssl-1.1.1g sha256 binary on a RHEL8 box on a
   number of randomly generated text strings (not including the
   terminating '\0'). */

#if 0 /* This code generated the input test strings for OpenSSL (rng seed was 0,0) */
double _sz = 0.f;
double fac = sqrt( sqrt( 2. ) );
while( _sz < 4096. ) {
  ulong sz = (ulong)(0.5 + _sz);
  char buf[128];
  sprintf( buf, "msg.%04lu.txt", sz );
  FILE * f = fopen( buf, "w" );
  for( ulong b=0UL; b<sz; b++ ) {
    uint r = fd_rng_uint( rng ) & 63L;
    int c;
    if(      r< 10U ) c = (int)'0' + (int) r;
    else if( r< 36U ) c = (int)'A' + (int)(r-10U);
    else if( r< 62U ) c = (int)'a' + (int)(r-36U);
    else if( r==62U ) c = (int)' ';
    else              c = (int)'.';
    fputc( c, f );
  }
  fclose( f );
  _sz = (_sz<1.) ? 1. : _sz*fac;
}
#endif

struct fd_sha256_test_vector {
  char const * msg;
  ulong        sz;
  uchar        hash[ 32UL ];
};

typedef struct fd_sha256_test_vector fd_sha256_test_vector_t;

#define _(v) ((uchar)0x##v)

static fd_sha256_test_vector_t const fd_sha256_test_vector[] = {
  { "",
       0UL, { _(e3),_(b0),_(c4),_(42),_(98),_(fc),_(1c),_(14),_(9a),_(fb),_(f4),_(c8),_(99),_(6f),_(b9),_(24),
              _(27),_(ae),_(41),_(e4),_(64),_(9b),_(93),_(4c),_(a4),_(95),_(99),_(1b),_(78),_(52),_(b8),_(55) } },
  { "b",
       1UL, { _(3e),_(23),_(e8),_(16),_(00),_(39),_(59),_(4a),_(33),_(89),_(4f),_(65),_(64),_(e1),_(b1),_(34),
              _(8b),_(bd),_(7a),_(00),_(88),_(d4),_(2c),_(4a),_(cb),_(73),_(ee),_(ae),_(d5),_(9c),_(00),_(9d) } },
  { "iD",
       2UL, { _(ae),_(d3),_(75),_(ce),_(32),_(c1),_(14),_(cc),_(bc),_(b5),_(43),_(2b),_(81),_(f6),_(f6),_(a3),
              _(10),_(fd),_(c8),_(bc),_(53),_(45),_(ef),_(94),_(26),_(81),_(7a),_(88),_(5d),_(42),_(29),_(d8) } },
  { "Fqq",
       3UL, { _(70),_(13),_(78),_(1b),_(b3),_(fa),_(82),_(3e),_(15),_(72),_(53),_(77),_(62),_(8f),_(cb),_(4e),
              _(d8),_(7a),_(95),_(eb),_(e9),_(97),_(43),_(e6),_(68),_(c3),_(ff),_(bb),_(4d),_(d4),_(cb),_(cf) } },
  { "VXMc",
       4UL, { _(b6),_(f5),_(ea),_(34),_(ac),_(0e),_(08),_(ba),_(82),_(fa),_(6d),_(67),_(b1),_(4d),_(82),_(8e),
              _(f0),_(5f),_(ca),_(c6),_(61),_(94),_(fd),_(5d),_(ef),_(29),_(33),_(24),_(37),_(40),_(35),_(42) } },
  { "NtJ1X",
       5UL, { _(23),_(ea),_(aa),_(98),_(db),_(85),_(14),_(b1),_(27),_(e7),_(18),_(09),_(50),_(b0),_(f4),_(c5),
              _(63),_(a1),_(3d),_(9c),_(2a),_(f3),_(e7),_(cc),_(2e),_(ad),_(86),_(f5),_(e6),_(7c),_(25),_(74) } },
  { "7KbaIg",
       6UL, { _(0e),_(8e),_(42),_(4b),_(1f),_(22),_(02),_(3b),_(01),_(d2),_(ea),_(91),_(9b),_(e1),_(8e),_(f4),
              _(b3),_(5f),_(2a),_(9a),_(0b),_(80),_(da),_(8b),_(6c),_(50),_(6e),_(0a),_(59),_(b9),_(08),_(d0) } },
  { "UygUSf0",
       7UL, { _(7b),_(6e),_(a5),_(2f),_(4d),_(91),_(8b),_(a2),_(ec),_(ef),_(56),_(43),_(76),_(e3),_(04),_(21),
              _(71),_(57),_(6c),_(95),_(62),_(34),_(a5),_(11),_(4f),_(0c),_(d2),_(73),_(3b),_(7a),_(f8),_(1e) } },
  { "9xV1XEz.",
       8UL, { _(f1),_(47),_(3f),_(b6),_(34),_(4c),_(68),_(49),_(f7),_(26),_(ec),_(4a),_(ec),_(27),_(42),_(de),
              _(77),_(ba),_(e5),_(dd),_(09),_(41),_(16),_(60),_(2f),_(93),_(21),_(8b),_(82),_(c6),_(11),_(12) } },
  { "jWxRR18K7I",
      10UL, { _(ba),_(8a),_(88),_(a3),_(24),_(44),_(23),_(96),_(55),_(b1),_(6b),_(58),_(2a),_(d6),_(9d),_(a6),
              _(ff),_(d2),_(09),_(ed),_(f7),_(f4),_(47),_(38),_(6f),_(d7),_(5d),_(fd),_(8b),_(9e),_(c5),_(8d) } },
  { "rTC7BzywcHB",
      11UL, { _(6e),_(31),_(77),_(d5),_(79),_(68),_(3e),_(83),_(a1),_(78),_(0f),_(fd),_(a0),_(84),_(13),_(d9),
              _(53),_(a8),_(a3),_(f3),_(d8),_(ae),_(37),_(87),_(e0),_(c4),_(b8),_(67),_(bd),_(d8),_(3b),_(da) } },
  { "KYDrejKUlixaO",
      13UL, { _(90),_(e1),_(4a),_(00),_(96),_(dd),_(6e),_(3b),_(46),_(aa),_(d7),_(7f),_(2a),_(22),_(26),_(05),
              _(4b),_(fe),_(f4),_(fd),_(31),_(03),_(db),_(43),_(d2),_(2a),_(a4),_(ce),_(f4),_(14),_(30),_(60) } },
  { "c3GYWgTxnU9bTsd ",
      16UL, { _(80),_(83),_(ad),_(df),_(9c),_(14),_(11),_(c1),_(df),_(cd),_(d2),_(50),_(d4),_(39),_(6b),_(72),
              _(08),_(a9),_(f4),_(5e),_(b9),_(63),_(b0),_(f5),_(36),_(5c),_(b2),_(b7),_(cb),_(dd),_(ae),_(29) } },
  { "BzxoAvk6xpc2SxYytT7",
      19UL, { _(ac),_(68),_(5a),_(a9),_(20),_(9a),_(dc),_(c0),_(66),_(89),_(61),_(2f),_(bb),_(5d),_(04),_(23),
              _(f0),_(ef),_(7e),_(91),_(99),_(a9),_(01),_(f5),_(42),_(95),_(63),_(84),_(93),_(ea),_(94),_(89) } },
  { "FLsH3bghT2blbH3zxmq0woF",
      23UL, { _(cd),_(0e),_(bb),_(b4),_(75),_(79),_(17),_(54),_(89),_(e9),_(0a),_(44),_(51),_(be),_(5d),_(f8),
              _(fa),_(3d),_(7f),_(50),_(ae),_(c9),_(15),_(3e),_(9b),_(4f),_(b6),_(5a),_(a4),_(ae),_(4a),_(6a) } },
  { "t3HE1Dtn7.y15ydE.yebYx94jvz",
      27UL, { _(56),_(24),_(c8),_(5f),_(48),_(37),_(8d),_(44),_(41),_(5d),_(37),_(19),_(56),_(c2),_(bd),_(ec),
              _(0c),_(b4),_(8f),_(9c),_(18),_(97),_(6f),_(2a),_(00),_(05),_(5e),_(a0),_(cd),_(a0),_(02),_(63) } },
  { "w5t2OIDcc53w8fwY2GMhmg6VprXdoFIY",
      32UL, { _(8a),_(0b),_(74),_(57),_(f9),_(61),_(9b),_(b2),_(a0),_(3c),_(c8),_(16),_(f5),_(cd),_(88),_(47),
              _(de),_(5b),_(f3),_(9f),_(e7),_(25),_(b2),_(ae),_(08),_(fe),_(6d),_(9f),_(93),_(7a),_(e5),_(d9) } },
  { "VDxLNtzPhVyoVWK2DyDxjxmsxMfYLk DfFqtOY",
      38UL, { _(e9),_(eb),_(bc),_(9b),_(94),_(e2),_(fc),_(9f),_(d7),_(90),_(05),_(91),_(47),_(eb),_(61),_(b3),
              _(34),_(6f),_(98),_(3d),_(64),_(ae),_(eb),_(9f),_(35),_(65),_(86),_(49),_(af),_(0c),_(30),_(07) } },
  { "2rlYRmoHRQ8hMBr9fQgyKF9vyrYhrCLRHbsjAuwRDXdAJ",
      45UL, { _(aa),_(90),_(d2),_(6a),_(9a),_(b0),_(34),_(94),_(67),_(dc),_(62),_(91),_(00),_(ba),_(2d),_(47),
              _(52),_(bd),_(1b),_(a5),_(f3),_(e7),_(4d),_(68),_(d2),_(12),_(ce),_(3c),_(b9),_(aa),_(ff),_(35) } },
  { "8eNyGBR30ORAgfusejk3mC.jDybK5z6fom5VyY5ohYY5qPVlR202Ni",
      54UL, { _(21),_(2a),_(11),_(bd),_(df),_(ae),_(f2),_(9a),_(5e),_(59),_(c0),_(d0),_(64),_(a7),_(e3),_(0c),
              _(b7),_(95),_(1e),_(c7),_(a5),_(c9),_(21),_(ee),_(b9),_(d3),_(d1),_(6f),_(6a),_(e5),_(23),_(b3) } },
  { "LDVCJ9QOBrNtcfcxNzoSAj5Fm92JNPd 6DyZqeUgbAxwjg8xBnrhyz43llylaCzd",
      64UL, { _(b5),_(6a),_(c8),_(93),_(9d),_(36),_(f8),_(49),_(bf),_(11),_(b1),_(95),_(b6),_(7b),_(f3),_(98),
              _(34),_(b3),_(37),_(57),_(17),_(3c),_(7b),_(16),_(ae),_(cd),_(9d),_(2e),_(45),_(58),_(37),_(59) } },
  { "tJ8Iob tRUbKa7gvyPl9cjj0H.Xxbc4i3DnwlBnx1aJq626jiFVRI9V mCuqVR1ZaZub HM.ZFgM",
      76UL, { _(ff),_(42),_(7e),_(cf),_(32),_(f1),_(15),_(16),_(ab),_(9d),_(8e),_(8e),_(29),_(ce),_(d1),_(38),
              _(f4),_(6b),_(b5),_(ce),_(79),_(73),_(48),_(03),_(83),_(c3),_(ae),_(a8),_(4c),_(d6),_(d2),_(30) } },
  { "c7uuV6Cbj oCB KWQXofgx.QdMOyuvpqPfQgn5Bjfjewozmop2sAYRKobfUvJzZTW1Xw.buIChdMaO6tcx6x4nDcHMO",
      91UL, { _(3f),_(74),_(5b),_(9a),_(e3),_(43),_(d1),_(7e),_(bc),_(7b),_(01),_(01),_(9f),_(27),_(63),_(33),
              _(d2),_(6f),_(ba),_(38),_(36),_(77),_(48),_(d8),_(95),_(ed),_(a3),_(c5),_(25),_(af),_(bb),_(2f) } },
  { "3LzFnapRglwpzIMbJ8EXctoh6WrerAxBJW9ZJuEOMSYkqfNpeei.doaKwmfrjTyNh6XEt6IBhjWpD8x7YIGlgOxZJqhY8C.bFLtRim1th6C2",
     108UL, { _(0d),_(fa),_(4f),_(8c),_(b7),_(d9),_(2d),_(09),_(93),_(c0),_(e4),_(44),_(73),_(b4),_(cb),_(cc),
              _(6f),_(db),_(a6),_(82),_(60),_(6e),_(8b),_(66),_(a5),_(0f),_(f6),_(cb),_(f2),_(b6),_(9b),_(a7) } },
  { "aEEXD5jg55tiiS1H 8E1y NAlvmjyePXt1kxyj 6NTolaU8M2YTW3rZEc80SdUyPA42j3OIP3bnwuT37DQX1qDUBqChI1p9x5EF100PvX1MDYI7SoxlMEKiIOj5W4"
    "was",
     128UL, { _(6a),_(ac),_(47),_(0c),_(0e),_(96),_(2e),_(6d),_(40),_(6f),_(6c),_(65),_(59),_(c2),_(ff),_(13),
              _(60),_(7b),_(27),_(0b),_(36),_(31),_(f2),_(04),_(42),_(83),_(83),_(4f),_(09),_(29),_(4c),_(95) } },
  { "JTFeoPLehfxOjTaCfqw7S8zNEdtju4fGksUUpRvwBhKLGQfoZbMhHDXSio.kSjbMqQ6BxELZojQPBHfa5ZAyTFvOTPOjao3FawDYx44gMXgAPE i1SiS0VPmmT747"
    ".E5aC jtqxiFRErF2dNUeEY9iPn",
     152UL, { _(96),_(88),_(ec),_(c6),_(70),_(f1),_(be),_(38),_(2d),_(a1),_(aa),_(43),_(fe),_(58),_(dc),_(1a),
              _(e2),_(ba),_(5e),_(f2),_(2b),_(cc),_(da),_(f9),_(df),_(9a),_(88),_(51),_(60),_(9e),_(99),_(fb) } },
  { "dPmQescywvBsp0VWULnS.judINZ Jl.LU5jEBX2SXMgVRIesVfVWEB928ua.Sl190EQ4123eOUB1crBGYNRmMtckS4AP9.mk472DFeDGJmnOo2H5zdBdQTo3Lbu b"
    "bwks3jo3.tc5WnEU2ltAfHxe0DNJnOX2nuf7whkjcjUvRAYVYXImfLWm",
     181UL, { _(f1),_(f0),_(43),_(20),_(bd),_(e0),_(77),_(f5),_(35),_(df),_(6b),_(58),_(f2),_(d8),_(06),_(1a),
              _(a8),_(91),_(bb),_(3f),_(10),_(07),_(ce),_(0d),_(88),_(8b),_(72),_(20),_(3e),_(6d),_(9b),_(0a) } },
  { "cMYp eDtMfODExuM92AUsd2NLrNsNdeTTLhk0sDfq XI5hD99ASJS4uEHhqXv2 4QkYURLQnqVNkMsruYfiGrBnD0T0 YeGeQlAV5zJeh4LhHxdgHbt798 4xlDzs"
    "8a7e5AIBWrfHFv9KEgxsvMvXR3WuGwU83AwF1OYhRb4 rk94PpyM219LYWetnmUHLdlRcxQxYJpvS2ScG3W5cTxDTv",
     215UL, { _(04),_(17),_(33),_(2f),_(06),_(12),_(c4),_(c8),_(40),_(9d),_(50),_(f2),_(aa),_(a1),_(ef),_(a8),
              _(d7),_(ab),_(80),_(4d),_(11),_(35),_(59),_(4f),_(60),_(2b),_(51),_(78),_(01),_(98),_(9f),_(71) } },
  { "mQl9H6F9D MTPTFzT7G6GP7VuT6GYEveeqDTEte1Km12NdGrT3HjQwWG6Ezx..6sAzMBJgVi1jG.YoH9TiuT0OCVlJWHMXKjFlCTjzsIQ7pcUAjy6ekdvR7YRNfaZ"
    "346diDvv5OSXC68rZnaC40zYcUb GPyHOF3yPl.iZ8aSukVQjg2M8HjpLjIE3 ZPGXnNUZatM27yFc8tS7FZSRursjpA0wzrlAd0s SggvbOT rX1fSuYHA0IRUKO"
    "IkyRhU",
     256UL, { _(95),_(17),_(dc),_(03),_(44),_(df),_(e3),_(89),_(c4),_(cd),_(53),_(09),_(a8),_(d4),_(62),_(51),
              _(a3),_(5b),_(8d),_(74),_(d9),_(44),_(06),_(e6),_(40),_(bb),_(ee),_(04),_(c8),_(6f),_(e7),_(ef) } },
  { "VXPfqVXkyYw2O.KTL3f8guAGunDE4KKwhLGNMwqYxFq7FPdxJB84GUiV.0YJiFUpvFl9sDCadLlvcpkbTIsZkJlTlClhIkhV.dSfBNzVT5ifRiIQc cuv8vS0.Qad"
    "P1zLmOrX47mDcY p.co0Nb1KEUvipvtw8M5oV1GVTBJUq7AXNoNS7VrEV5C0jDcxmKKFfqQBLfpucB.u2GwwTe3UhDJypCKyca74UNkzBz.DonJUg86k6Yp04BNgq"
    "muLmRuEKYEgfOuswgkjvj1x6rjzyzQVu4xzofkv86o1LwWtdWbC5j9",
     304UL, { _(4d),_(39),_(ec),_(df),_(29),_(23),_(e2),_(7a),_(13),_(79),_(6a),_(bf),_(6d),_(3f),_(ab),_(6c),
              _(81),_(7f),_(90),_(bd),_(28),_(ee),_(01),_(cf),_(56),_(bd),_(8d),_(26),_(ab),_(44),_(80),_(84) } },
  { "ebcrSLN7lJ82shVatZzxdutOHOtjc2vS5Pvnq2s0X0PhCcFz0VhyoI1bvYnfZTGWk9sr1OWv2jc8gPwyqlyhXEfhrGiFvPUzzD3E5tPozskN8AYQ 4YMomgtB2Uh2"
    "LyFVTXPyjD8kvYaNJpGcymQwEUtc2tjtB W5ZJ8wiMgCZTBMzSA53TQjtWO1OxUAf1Ic3GwfLBlDxz.3UV4w4ycabFmYK5pJZyuhwo8ve3wdGnmMEcnpgYjymVBiJ"
    "XX6IT2rXQyI.qbMbLNJ8y9ERRj hXt2tmlkninnbGxjQBLgcr4FC9NV.urXcfA5UWkY2oWBfEHO.kKAFRlLvUYC8ymvFbMbY990Rl9Fak5cNA3jk",
     362UL, { _(34),_(50),_(4f),_(60),_(b8),_(0a),_(a8),_(46),_(d7),_(d1),_(dd),_(e9),_(b8),_(cd),_(7f),_(b3),
              _(d6),_(4a),_(31),_(54),_(b3),_(ed),_(ef),_(d5),_(29),_(bb),_(d8),_(7a),_(01),_(a2),_(1a),_(5c) } },
  { "ll6AZPr89CaIJevIN0oQpKqt6J5suYPKhqEBf35GRLPT2MaNdVVMkDPFvCf2r5xJZLlTmKmEs3CJUTNsCbm.EJEHYaizX ejHpuUFvrZ2YRrXah6pmmgqo1Ahf9Ak"
    "j32tCMMmgJf76ipaxND1czDXz.tHjQQBT3W7I.9HqCNGD4FvOg7rbyWvDrS99VH3LKmSvAi5mNreB6kmJ Q2LAs5l32u3CJvsQRYHZKYHGjkEoAhWWv5m3qoki7LD"
    "A3jC75J3rZv2RX9Mn.IdO19ekyH52dwTkapMfoftBuwMIcwKUJBMGHdUP17HvevpOdw2xDbzWm1YDtwfY7ZoZdewaKj3rXWLrsg hYwenx7PthQITwhOTj1PT9GLT"
    "PU3DxnuITIjjYS68cK9qjSCrIYdekqVd8pONhA5TGCW1Xq8m. l2iuVD",
     431UL, { _(86),_(82),_(be),_(89),_(6e),_(52),_(89),_(d1),_(7c),_(96),_(56),_(26),_(ee),_(1f),_(00),_(b2),
              _(d7),_(1a),_(61),_(7b),_(54),_(b6),_(8d),_(5e),_(a4),_(3d),_(a9),_(04),_(4e),_(b6),_(41),_(3f) } },
  { "YZp0HS3RoTw0XFx2L0nEGsM6vn2NtNTF20uqi5yjW3j3AjYMLCmUXKk1qCplZWRVVR 1pym.md IVxBrPx5NHQBs307wYYtNEcrU5kUGYcEnH1OOCbx8mmb4BPFo2"
    "oqFgQ5fUDEFkAU yy5gDYA4p NBoBp1TA4A.H6hhuN5qB0 gWGEIcZX6aKPSO4bl7qfbBz8PWojfhpUr1zJzpPKYuSb70kSuV23tkMoeKczaoTwXmgwPlFsX5neLh"
    "cx8Dx ecH5wZyQQRz8p9TovLKypS1EQglcyRODQ i3vuuQ cNlxIyWKx3X NtkPaklSCPpEWFbsYVe7GnfmFWBJ6ddLNw3.hhIOP4tifsgOftuv5hVoeFvlIU Fxe"
    "19puwIigKB.jLuhAsjWQRfXCL0R8D76hZhaRJqaeXC9etXdPQ8hmaVSbcC ToUIjw8D19e.MQ38NfO0XSfpaDLhEkKVn7Gi.IU5ZAqaDgD2eMtJy.bI9NVPkrusPi"
    "GeZweXttrLYQ",
     512UL, { _(a7),_(67),_(01),_(3b),_(af),_(96),_(36),_(35),_(34),_(7d),_(b3),_(1e),_(70),_(80),_(44),_(5f),
              _(5e),_(ca),_(1d),_(ca),_(6d),_(33),_(99),_(51),_(57),_(ce),_(c6),_(8f),_(fa),_(c6),_(fe),_(c4) } },
  { ".b2FZRWd2tgg7BDrb.3BxqcNkDqXaYcXqEjRwCzqj d6EyOXlyIWJG5ZY2u26ErTn6eVFrBP0ujhbqpSxgJ1bogvetELE.JbWtQq8f5PxZDKAFqj5w5etAbH23Rax"
    "bbTIVVvKKrCosxJuOSxQe1.dtiYRalTdriwaokcnLqHtiprRaoi7.tPYgnyi.5Z16fX9K5ycwfyhSxMpEN XYRPtGRTVCJT2pR9x9G2jPM2TdS8uft8myJ0dPjRDA"
    "qnGeyc2u Mkm2oBcsC raimvwB8YSxDRfNrXuTlxCYBPnSOUngbtq N3KzzLceGF1VS0v3KU.t5Bi.6aO23L0rvL6vbzIx.gZLy1YtEwffou.SZXb26ZJie.4vwn8"
    "fyX61w8QjWBIvRuYKP2ybXwgZtG9uCmKBzYy3Hd E0tnOV zMmROIpy348fpyy7e6lHr23wB4KPtUvqxIZOJz.b94U889OmiXwI9t8wcM0TFAgyOynznNGUnOoEsB"
    "NKptYDC9.LXFiSxGFnBtPcQAQqUIGLurHwBQzU8aXJiqUEt1AblXuIWHsYLs29eY5lw2r8CKyxD ZUFGErnfDOqWlkXqsN8Xh75bzkxTpY9ku",
     609UL, { _(a6),_(66),_(3f),_(43),_(16),_(c7),_(61),_(c4),_(f2),_(3a),_(5e),_(80),_(f9),_(f4),_(16),_(23),
              _(73),_(2c),_(5a),_(7e),_(ae),_(f2),_(c5),_(64),_(f0),_(c1),_(8a),_(cd),_(86),_(f3),_(c3),_(aa) } },
  { "1wb0LjMy.IWN60afDWCBUSI7IEX8bRSPQTfxRfWfTUOmAsJtxi4GIk h8gdN.NiRrarivT7QYC56PNX7K4WWD.AppAVtPf.ROzKeigI0gIYjPqR6tdaDrSgxqNxbo"
    " DQaAZbt3nliNrYlE 4PrTXCP44fynwEjmv0fD8zdLsoEjLCMx7LmKp0db56rKpj0Bk3bzdrpEbKaR.u1eBusVfMdIMJQN0dKujgCDM4i23AoPbkvnnbgKi1Gp7Zz"
    "WRqVVsTTsuclthvZPUHcuT0WBkMgF.UhkA.BkfisSJjeju5CStBZ3ONWpz41HEiEuOVuXjvcXN.LUucpUkP8snDcQ3bDW18onXXcGt3iPgNts9DRwzJgdjdIfempR"
    "eYojvGZ5bVxEPFiN6Y9IP69mNKq32B8d08W48C0r3jgd6ZFOiNBSjegh9P9wdHsR.OtCiAXq1wU7YrKfSFJEG1WBc0k5MCwP2 k7Ib6hcyEpWrUrG9leOE8XmGgU7"
    "zLVwuvnLPXGA501VPQ6.EOmwXD4D1XPM7GBBOfrypULhLVm82cOOCEt0tDNIzz9Zm3mtpIRKsPZ43JwEipTR5eW81axm5MNBhdqibdwnxL6hA117kRjanwjPwRLaN"
    "991WBjTGbozLkLAXPTGH9pNBWidBx5h.MSRpjQYLdO4PsTsViNGOuUzbkQx O.8FpN55Oe2cDPiyrEM1EGZdXZMGyvYdXATAUp8",
     724UL, { _(09),_(8e),_(3e),_(25),_(1d),_(d1),_(fc),_(02),_(26),_(bd),_(e7),_(d7),_(9f),_(7c),_(01),_(54),
              _(99),_(a2),_(a9),_(ad),_(7b),_(c1),_(ed),_(00),_(2d),_(43),_(81),_(45),_(d2),_(5d),_(56),_(36) } },
  { "3H2vU qCDMJMYHXEO6vR1F rEgET5v.mcOsjAZdXNsXKob2n1tW3qbCxFK63u9g7J2aoE3c5f0K0.MkTxjVFtWwRPFSfnVK5CzUjDIl3.auxmyhP NHGu6N6bZrN."
    "aLccmX5iZy38t2G1xrfBvTDOx5c1.EwzZUoPJlynQbwygufbCI W42m8vYW8Os3Bn5IrNMwSYcUWsJ.HwAIK ExGhMAYHciZK6.JIuqMJjMtSu bOc6esQ2UErobp"
    "zwuJwuiUnIes2IUzIyqkn1v3srJVOxq EaLVceLTQxotV7GsjtHl5NIkGimd .QLqkJjbzV tXS0aetF5 PuZVE7K21NEV.ParKsay4sgzBQZKkt9d.O IFlFyni5"
    "JphlD9gCH26otp1 Ovyj5T tLsLBpjkYaslWNp8JrWyjRpLtTPYS4G.4aLgAVQzBvJteIQiwdU47HFMoDhZYCLWuhL1z3WJee1M09yzHUoiff3idTEy45rjKRsRxH"
    "5YTR6QIpiOb7.V9qbyNbsFeMZnIIxNPOwQYAygKiJBSqYPKQogauTEL2bAlTCpjolO ni08BMe53eqGKyMyTqgJHTfAmv0xYL2BkdXqj66pHmyv lK6S1HToy2j1h"
    "RQwH b03y0.Y4Cncawl..2L3G..uIJhQZ.Jo uneuqv76EF4i0Pm3qgZc.oASNBFmwODwKbEobaqEU0NZ2ZpNcLNuJySdYlXHdm7aLa IV0tUOtYTbNFIHCHnKIYq"
    "pORdIcPXGQzzwsB8OcbbBXqGFIZyX1Sn4U.hy4erjSyvdEKOnS0xwtHYLLpwW1K9h0bW8.FxZ9AD5iXJXtLJJU Mbt0xHWrtrGQgthoiKWBepJD",
     861UL, { _(9f),_(c0),_(1a),_(40),_(c5),_(85),_(61),_(d6),_(78),_(ab),_(29),_(0e),_(32),_(41),_(07),_(19),
              _(3e),_(69),_(5f),_(2c),_(04),_(60),_(14),_(63),_(bc),_(c0),_(f0),_(80),_(e8),_(cb),_(0b),_(b1) } },
  { "EHcDAJdRPo.XTa.L3J8 n5T0L4Nx0v FHR1hjv6LOBYfmvKA94yd4j4PzhlVDRpxc5hM8B8YISbaMHoNeiOH6JrDZ.o3inOXVRC8CuIS3txADvLF9zOpgqqyaeAfe"
    "KQO1cujwhpYvl1WxYfosvRUjvMSMQNmf I5iSBzNICf7mIvBxuIDQLJY3fatKHO.y8YKIMRehyZ9fD8XoeXNfBlGVHfiRdPaeC.QqazqXrndHgdDqC3VOGqAl.VuD"
    "Voa4S1KoIZ5BeH0gFtyMjCwI5kjxgBNr60e2VnHQ kD odro.XkZLylZbtycKsO9Nqrnn4C8ep5ANrsBhk9pSHmLThV9b2Z1vtmnKDVpFj7lYtL5RU4F4SnlWyXyS"
    "wicpyCBgg4jx2RP3xmm3nXl EyujZMNWaqCaNiB7.YEhAoFqNe5i1CmAUvH4fsHMeGd6dN1ELF0WdFDs8uIqKZDlz5j5bFQombwYnsB6IadA2bjzils0YMmjcySz0"
    "OyJ.vyI7q1Ap3K4lfeKrypPIjBcI9mcoR0frzj1mtC8lzECVo4hChYZYI2SpiWj17l  EomguaNJu0l7NRXrN8CBZ8UUCEOQ.7XKw7DrqsL02MEbYcR5EzkjGLTf4"
    "w8CEWLaVc4PrbhtUvcFys4UEKlazqBgkgJyJw 1o7d7 EIzbBFgoYE4D0ankKzwMBZQzg6RtLHCmWTBIK0C0dP8NOFmejFJJ.dScDOsLwePAsZyTv.NS9mHREv bJ"
    "zH2EAkqr.zouia0ZZAmXA.ut5CL4E6J1g2cIcJ e omI49S4F a0YZHJyTIBrlkjGfC9mGOFXTvmeJA2qdFIflhJELTKCpg04LTE2s QhteKttLk8ri1pxFZsAkwT"
    "4CiTV.0.TSlkD9vdvP84nhr9ErKSOb1NTgZk 48dEdtIKZ3nGlVmoYspUXSUP G.GGAvEAsdglDmh.ynrX8UQ4j6aqPGh15k8CJM3IFk3bGCBMZ2JV3RcRwB F7gk"
    "JF42pfllYgMPup1L t4iOAGm",
    1024UL, { _(44),_(7c),_(10),_(73),_(32),_(35),_(13),_(78),_(b2),_(52),_(2a),_(b9),_(b7),_(d8),_(1a),_(ef),
              _(0e),_(71),_(65),_(c6),_(6b),_(ca),_(6a),_(c5),_(41),_(83),_(b5),_(d3),_(27),_(39),_(93),_(42) } },
  { "daNzGqiGJT460qMeZC Uoi038mutAIk9wA.ACu75BnZyhH1BL8Nglb3kxAZqUYSovGaZtkqkpVINBzSoLsrAWSyGmsBLUO phAIXR.Lw.cwgoCFOMg1KwPP5C5FdN"
    "wxs8T1.K62uJwlxsArqEum6Fl45uIF5OVPt08i76qVsptq0LjK9hOovhUEQxsn8sy1eSh .v5GthlG3bqwf9IynBS4s4PY ujcTTVliejNiINSpCyDGEcgXZYbnbg"
    ".wAd LLkUPqjNumbUtfS85RQ9TWdfLbCOkGPIQj fQEZpC5BtGWY41fvO4YBY3QEd xIsxz1BCGqsUY15.viweWNv6oJ6ukom NY4jQiiOGTdCVzaVJhvH7VKJAvA"
    "rBjWmjAqV8O9pT2mWEYVDGlAxdPLQsE8IoJKCVLTzZju4sp1V4dBpBCQUIEgsZQak1QTG48VIfzhTZ3b5RzJK8SEK4NzgPq8QsAXFB8 2j7G4ebjSvrMmmbqWJF7J"
    "KOoz79VCe. H.stZvnC4ASU8mktNSM.FN8oOofhckLqjvFlbRbCqoc xh0M84aEXhVEqmTVHB TQytrT1j.6txEvkEBtRYOzRbLbooSU2e n7vl0Zru5DdOvt1PNX"
    "ucw8QtfizqcYu0 NueIvAxBf0m9CaEGorspqMBF9I00c05MSyRh65 2duXkK5urRS.AZvbxeUr3FuyGCfIHlI79Pkz.q29wuwX2s1LsOP 3aTrRWSrHmcirgl0Ib."
    "SpCGKOeOcnEC2aWrousGvlzNgVZRGyiXAE5ybTNezm4vC05ckjMBdmvtHg1cyCYEnkPH5eLfgMtF5VWTGRWjKy0xrqXd33gM4yMd3jQo99E7DCsqtADMS5r Swt8H"
    "55vULXs1JkBjwrPObIA1VDgvNo.3xlFD4xtQGPws85EGXC8..VOs0p7lbihc3zK.5sDcaAwPyj8gG5GQBbzmR4CTMlMBRcdLFiBRLFcpCjBJ50vNsd0n7B7h2NNea"
    "lPxvoHT479et8TzWe9TGs2Gr47KLYMmAhez8xXz0xp3 2FRnM8GI.ZQeu2Tf9yQz2F BMOoXYG.RwTJZWzAD8WTlCtm2K2FZnumtCJVbkrtbz3zRJcNnNJV p9WJp"
    "8feMc0g.58o1MIPx.c51bG3POkh5pkMDj5R9BAdQ8eN.x2IOwEjRNrjuQ8EKU GELUVq0Ez3ODhMyzN8k55g6rJyot3NG",
    1218UL, { _(c1),_(41),_(0e),_(40),_(4b),_(8b),_(af),_(c8),_(2b),_(2e),_(ff),_(68),_(d8),_(05),_(67),_(eb),
              _(9a),_(77),_(14),_(df),_(b4),_(cb),_(29),_(f3),_(04),_(8e),_(ba),_(86),_(1f),_(39),_(5c),_(10) } },
  { "WyaCHFRgfshEh.oin95IaGhqFWcimA9vbeVINPjPJKijfNYmyU EQOH2kAGFl2MCoXJcQfELiAFFp7pTHJR0BDAN4EEOUTNO NItsE6DmBObKhT0d OTu263PjcvT"
    "ZA0YIvikFKKl3dChfv459y0D7pQpG27FTISew2BA9T69lopaWL9vhHS6C3jsSOoBpftDuIzK87nWkBw K R417yL1dFLFZdWcMQPfoH9gNflfon P.WOz7TTP10RJ"
    " Ems96fm9Feg RGEZkRIeoMABnY8O6GbAaKBHpRSR2 hYXlU8FUTPCupP08ZFSCALpnrrd0JFI.WVHWfcRrAhZM J8kY4FJC75iUp pP3zPrF6heu2pR7Q8ky4I0D"
    "5LJmEJWb0T7XBSSiY2SBUcynkKl23ZwAFDeOhBsGZfPKo47Aij ir65B2DqrC2JE2PvBzLaUvAiS8WQAWCl6CdycMc2YeHP lhyTHE.pJk2fjsfB84o x0bzIqTFf"
    "cJYDkbSO NwSvbttAlaMnluF2Ug0cx7pnBDsMQ11xBN00Ld8s7PinDlsseHyktZA bN8zNRC31fpQQBJYkc1vKPs0n6KdNEprS3P bywomUEyaDtfzuDuO.UB.zf."
    "UWtc0ojxxTZkRsvk5ujY6DVb spoCRmwBct5d6b5bRUy9lHR56gXetVjF5MXZVaSTUwjeurb1J0tdfFxjIFNmX0j86p9bJTjIcvnuY 5wRE5F6ChD.EQSEud3RzIy"
    "dtOgsPAIwrG1EL8SulqTXMA5aegIGQKIoupI2yOF6kkSiQWcKNeM3NXsIKen8 H6Cyd 4iBSNARYo09YcD3MZk k.p9E0.8bN88RZfw974Al.OalzKNsZHs2wzVBK"
    "0R4vxDK0LtrOwGQNN1VUQXJykSpHbAZcavo8mjD xf8oO2yzlxqKuViVxnOIe.fNve1FWoHcRDzplzCdG4BxocjcQ.PGuMNEq6mE6CKJrK.OlaI0CLax1OJDvD1.M"
    "T4AeEcKS6VroTQ5 uAKMhEIAKzi5O9kYJ9hHBwz8c5sKoYE7JLIUKytGzDt.HOyr5CDx8qVtP2xQEf.R8xOm1TOd 0D2kiwOPqeLn6HVlqu2X1JMAUVakBEI Q7jo"
    "1ae8MWVDWxPR.3ZvSpEDb..Y.ZqED3Sq.nvcmbfiXt2mlMxc8Tj6cFlSx6 NU8tQ8cimIUkI.76N1slZdQ 34Zij9xTRR7tjFtnHWSwwXY9Wr06.57QsdSNvZvKfl"
    "D9lLTDU2BGa.gggpnJG5OnBduKWLs2wkrCRBUmjX928PP79ydscxMRivoXRUiy4.s9jIGel134RXUeLT7X9yWS1md 8DyB0m2.t21oFTS3P0CbcdzATRAxWQNrpyh"
    "ACLdNvwdHksaTiM9dk7L1ANjDMod0ChxAyE dgiJHKyjpkFRWb1O4ZQ2izDgwfZA10V1p4a7k",
    1448UL, { _(be),_(ff),_(3b),_(1f),_(16),_(cf),_(17),_(5f),_(14),_(27),_(d5),_(1c),_(52),_(f9),_(87),_(40),
              _(a6),_(fd),_(76),_(ee),_(44),_(57),_(cd),_(2c),_(7a),_(32),_(aa),_(49),_(25),_(40),_(0e),_(7c) } },
  { ".slPD.1ejQ250gpoe6TYnlY75g07MrvgACy2MscSFU0EBwfgPjjUYbZfxjj5d6D059ePtgop icffCdhODN54rIp3tr3H5gGf AKZ3kABOGVrH375P 18xwvebfWH"
    "4Hj87IeTFOwrZuVMI7AU6nj8 67yplooJ3M9EBoNAPWJuqrsD2QBSn6EMTFU8TBK4wnp9QATBRu.iWU.5ta8drgJUl7p3sJSCwpC0Zjp .UhiMnkHXZFRbctHu5Ac"
    "o2 OtdP9NGe4qGodpOBmT.sUJVYkg7oOp3u9nbENKe954n7AWUSB42zxe5pLi  hguSrp2ptqEA0fNIXW2VOLMPc2YcmVqUmZ jiUvNmUktciwx5xbef3wzj1AMNH"
    "QQH7GxrdmF2iDB.20n8RzCmNChi126UO2iiiIDMXoyuNjSwudcHB5U2OPj3ZulqXDiUnn9txfbjP0nAETGrF nbO7Cujnao 05BdcSG 5JCwIZbIY1jug8zDhvUgd"
    "NyM53MIsXNRxoKusC11R4BlS1iDZht2d6ccNusegPm1mbkwryZHxnjwfnzYjrmtjXxddp8w0TZMy9DM3KI76BneadIstBbHD7jtFVbfS kphGQPOkTloHsb4BkRfV"
    "Ot1s5umCxl0aWHMakwAFBdXcIzCjYkefEwMd3I6qXMijowAuZoeVR08h0tv1D57qgjhQxz30giGWvnFJuSEQ6 2ZqzL8QmD7kTkTPUAgfd4 cg5X1amXZE2egqSMH"
    "vThTAZCmoAI3SG1F3f2QsMrWdk..ZfoB zYrEM98bt7SJDUtDUwluvQ mswv mjsaaiaP2jjvRclnxcJR1rgzJlPIWKxkDXZzYfmJBzB4nT DzeUYZ7tMpErTWNYg"
    "SwbLOojROpunnX9tKpkKGN2jTWbI9GXvTjjHa HxfoJ144vgei4aDeuJXLwqqoB7SeDXibvhYAv2SgE4qD3notLTuKxJnsJk XxTwWUxoyaK0apFVRxLEUqNDeLsB"
    "puceqUdWFoifXG96Bk2GZHlP vuzBqckL9oMS2Yziao42KqbEjuo5eVGTgHg3fUVCItmNVhEsvOGryPxiwdKXrl 4P83r44W32hWrEqN8jBHJheE3kQPqR5L3iO.Y"
    "Y8uPr49qRz8Ott8SDNTnLYzej40h4 A2gybB KB180hh MhjGbR6RuUlPH9gfPwPWTH .OflxP8xroT63TEP2Qh6G6KbzGc13qGGGdP7FRUuU2Gth9aq4tMXU2R8G"
    "bpVkFetT.J1fYxNHeWfql.w WqIJv3OnaRuxn60wFmVk77DnbTCa.OUw.kmny1n6QNhf70CjHq1ZCm4fXZQxpy4Y4Ricu6Pl59biKCCc.ZtRBg9R1ppE3a2amwIGa"
    "of2tokr1nmXMTkdPNHLSOOBRZ.e9kGETffcYryHXs1I0UZHRkitZDaFtAAr4Kthzw.VtSGj09dnljtP2M41cJsVH4fl6wPAGf2IcNxawbjplUNvNx VTqYL4Gv x."
    "BzjbhJxuNaCT2qkeFAlTGCO9zJ6 hywIr0RajAuUixc5cR34fps5xNyVTyDyKCC1u654ISoEY9XfO0WYS4AoqrMMdcN0PoXp.abBy.JjGTyAX4is791dPmAkFJd.H"
    "Gvts9OvBtN5HVThOnr494.Z9QnTDG6u3owGhUbh9Ku6dkuJO3yp9acYUbuUiVBdbShZT6R3DR2HghjeIFX CDDMySxCxZx2IG",
    1722UL, { _(1a),_(74),_(36),_(c4),_(06),_(4e),_(74),_(15),_(76),_(72),_(ef),_(ff),_(06),_(7d),_(86),_(d4),
              _(f5),_(8b),_(6b),_(84),_(6b),_(70),_(c0),_(d2),_(40),_(50),_(95),_(87),_(c7),_(c6),_(fc),_(dc) } },
  { "qJtpqGFvaGbxJCuHRK9TAHOr6I3LpnTW0PS66IKN6ekEIkkhX6rgRnoq9D.rXQfUn2UHv6JX5vTlHljju3FOIcmyfGNr2DA6DafZMNvAivUYOHOtGmG2jXJdAhqDl"
    "9QgZ1MdAYAVgPEb6kcI8vsOeu3x EzG XnoQ0c.YHcViGzk.unaZoFyZnGjIiKNLau2wDLyG7aHT8ebJN8nV7tQYrpXJ6VRsFz0yCJgZoBBAaEIS RIFI3Ug3z9yX"
    "zZZb rP HvU3dhUFLVSbidasDaWAXhtS FHw5nQ6qY2QX4FadrACp72PMqvUJeQM1E0YmetzlqT X  nu2CygN91pR98Rp.jbfxHVryVsNywcM1G4rmkBKADaTbda"
    "IVBSRAqYclMlgY.nijWMKEio1q9BGyxhXi7y5YQ.l2kKipybw8CqSA1Jk4WOhzXe wTo0rVgWQFN2rS2rQiFOHo4qzrE8tWweWuhXzUQg7n8MZqJIkwESm6dMsIyQ"
    "atYpS4f.HMzfL28FAlGmm6GA0D1eTS6qW14mHXqKRN4ojkqvcGpnz  .i490TopUpJEcv3f643HqnnPGAS7FSuJ7n.5YHroA4XHSR46hygswu0WA5tQ9DZjAaikSQ"
    "Z8XGN2N2ITpvxb4f5r3eBhiHSPtbYT97zY yJ L WdC6JJzFeNGj9 ZHxuNIcaKDx3nBZBsXg90sWtErX6Fm 1yPbGjmZHx5BHBPFRLUDaRFq1JvDcVk hcCE7VBI"
    ".57lx2F3l690RG9Re5eHZr 4w5 KnmerBTGWq.JnhxVxPGG3IS6Lr4rkRMnFFmZkPscT8uiH4Y3scRRsMl nHjnKXIpTShZeIEDlPexaJQ8nTea1yPzWMVXk1KD 6"
    "qEqbdTIWntn39b4q8IrvEX hNIi7m2fgbPo3pJHw8luoz9HRM8M61ZU39njZ6VFsF9PgfyE4QEwuDTuqbUtjC32S AOrDCmbwTZRgYME1LOBkei0rwVFXkmXSgPbK"
    "gh1b QxZPDcXME5VpGBdcpWt zeMHD4Wpe5wFcYkSPEID8gxaoBly3C.gBiihXKVxQasTC CQ8t61Y2LJqwmSIkcBngRdYJNFFnvhSRPq6tSiyQ6VgSh1lgxEWLqa"
    "4H5nHmpY9AWYjdTpAFxEGfxl6bbZ54nDP.2SN2pyf1VnT6.VxRUUtYIjzgZbq9Lagvo.qTyz7bxD0vhv7v15bKrUR1HumziVElr2drQ.HeY37vm5Bu UMwiMUvcIz"
    "ARL35iV7P6fLMpjkd7jt4eV70McbBjpqSbAZgWY03l.aH7ENFkNheuWJ3kaOWiLmSBeVqqjCClyM.4De2FUnVlD4L8UteyBKJ1nwtS4Mye8whXUVG2t F6FWUxA.P"
    "kN AM3 touSf KSXTejP3yE MSH5RzmlYxIc9V4fF9o3BveKfp0O9Qgh rYT9zJT9i3U8ix85g78QdwPXXxmqfWLUbiF 8b7awVGUtHukbU6ghpR02ThroBEzRW4y"
    "rOlHdHBhF0nD 3FDCy1rLlq4H1EhucFSTtOgQoJ.Ax D.hAWlBWDn8BYqi4O7ierER8NbqB4.uinl24iR8esy9ETu2DKaLEcW6KuPrZxu42vxEADldzUEcZWce2nj"
    "ZKxdV2iSLFr5.nB9kucU3eCCbeoqhk 1UErxJIV4Rrq.W3Z5H09n2 cK.vS.FE6kFHWXBGkA0oL1PlmRQ4peFBUidxfLDBu5vk7lG5VK0UK87hdr.gQQFewe LQd."
    "Tbc1mZJGZbfZ5HVB8fMzTGYl3.N vbqnX99GAZmOrgh9VdNaTyWYoSGDscBxf6A70ltZXdqUoYEIVBVMc5IpLEp72C0yqVvfNZZYgF5vogBFLyvpLHFet5YnysSoz"
    "b53XhDpTyTgDXi2u1ZzBYUhdhkIAB9JGENjSfPujpvvZX1CEl7.YzjjBdCtK.gZXJ0CUKiG.aLgSjpaW8YrLVgTMpRnCZVvm7NG4QfHj1ZCaenw0tslr3jnWW4IEe"
    "tHcdIWAUHbfAHeqtDF cmvSpcPcJHvLg5bilLFxeHEXYlNBi",
    2048UL, { _(65),_(f8),_(2c),_(66),_(ec),_(7b),_(00),_(b2),_(73),_(ba),_(99),_(80),_(cf),_(49),_(2b),_(19),
              _(af),_(9e),_(39),_(6a),_(5d),_(f7),_(1b),_(72),_(56),_(ab),_(a6),_(4b),_(00),_(24),_(1a),_(15) } },
  { "f4fXl d Hbgzem1KvhdZuxIB6rv2ZpcI1RQ.upbyLH4ow8nLJO35p25BJJf755.5FiVIdSFVUVZZZPQxiO4Smj7drKoQ5nNaDOpzFkuLtKkDQsTYDziHObhjifWfq"
    "7UNh7UcYQbMlus24jk4IwAQm x1KIFmRs2yfB489AJ zpBLH Di01 5eP0AzGF7wu53JeGU7bGt9K8zbVJRJQ0e UhrTxr9HLFYtjHCXN6 m3IBfoBr89Ix.2CjKJ"
    "9EAUw5VxUKRgAP8xz0BR9.o2dN PRtbCtIAkyf8SQdr95hwdnk36KaDwXGGwIW649o0I sqPIDVRRMYgl2imunkzSFfXQMhtpV4ZhHMgcuiFl5LM1OVV40 bDmFUi"
    "9XSluUcRtbsNRyT9Sp8eAdtWT62aj87qThijGhPMVxCBhTmkyn8EbSMkGAdmfJGRQwMUuEqLgyzM6WR1lKj.o6NM3QetccW7KAPg6TTvmek9zQHuCvtJyD.o4aO0D"
    "mafadni1Yw6aAmF8Rdf5wNZAdExhq.45dDAUeeW27H7qDXKILirSQgKYG.VLPEMcA4wLFl2k3BWF75lhCqJmffDK 6PQprOkXREkG76HjPOmHhpyDFt8J0YfyVlmH"
    "ucdw o cC5.d6ghy 3OFThFEb3ppV7Dk2BDOiyoZ1BwA5.LC0KBuOYiUBkBsbkU4QOgnQ KklW3UezCyisXoA0pOjLDTk0L3V.sBBG1asGQOmtqSv VSOwy0B1Kzd"
    "x2lxu1byE cT25yCMQRUAzDzKzWFQ8fhLFJH3bflYTWggCkJXebdFBxwk MhdNH2k2UwuIl12pAzxFk1numiQvKWM14a5wCSo 8mj4FVopfcPQDdDY89ZUSM0WKer"
    "kN7cX1qu12IkxHkN5845fgLq5JlW7oM2GP22AxA.1510.1pr2cX RSQckHuxq38vryvIrN5b6J9tfYPAIXJFD7KNbsRaykOiKDMUvU5Kit3jbekAkUeoGtKrIj E9"
    "rZOmZOE3GlCPnlPaF0UrDeeFc8wk7A2gT7fkmi8431nIbElXe.ffhAduET3fpjEzLVBMKgHqrEMxQfczFS83C9XrlLVKilod.iJXBKLTJGDPf19p1BZXpUVq94oeU"
    "rA o3u5536NEd1vIyF VB2KFQXr1yz.aX7pD.7A3veTdavPNvpjqBqwbi5fa3wOEK1HMlw8tOQVlE3lGxXUfO2tfg0Og4NxWN3ZtUTXlQYaumDfB7CvPfxTMrGSvJ"
    "AratOpea9lvUvXEf9ifRSB uvQF2u7VT3UeSPhvGoSx3RcVB6ZRQQ22tDR qbkxnbjFY9GKmlOSNmpjdCKoFFqW2eVMe5iA8sICE25RvlLm4zaBOsEd6nwFsOfpNG"
    "nFLbRRDQJK jeM3tiS5Zxz5JYqwQ3Ld1U3sQObb6stf3YVy8qr6MHQrd3UXyNI47QCu.nABEFCf5Y 1sT67MiWrmiCRrCtdeVQJvmnEDo5FHoKvi5vdnIyavjMtUg"
    "h48x4mJVdaMKVX19C8JM99mbz3 WLtdyZM G6pAUroavCD XgNQhlw xkSKiNhAYmSycSW6wjjVyxoobq5Pgq99YOiyVG2l9QzKyVX2qEuJM7cdsMdcrw1SYdB Fq"
    "or9q23tqBNMok3MI6gJWQ1eGzqCdcbvV4GLOeN.qFKzLGExvVYirpLN1t hPpVlQX5NyFu7yU7yKM.JOT4DrMtpD47vajkCMOSJFvaomHeaJeD5y6fH21dYzGRKK2"
    "8d5zevIquueHqhGlauOR6sBlv1P1Bb198Sysbv9h6.LKP1tgOHqcUxzznTXtevZSIqL8H5z9WlBN2XBxq PF20W5McKSKiRT0gOv6tfG3ofeoq8JEY4N1RZAcPWA0"
    "fz2sAoLQF9NEATrHaxyBsSm7O2k5GEHUU.awyjaQ4C.qTwq1Dc3I0ptt0fO3nwFmYKvYVC0PZuNM7DLbTkPTEcpHS4Jp9wE.olPDOdqWoCYFGFU0NzzM9p4N8vsXH"
    "pcHEeoxmewyrW CjlMAEe9OUrM7NzRJbS8kmctCIXD4juvnYNBHi1tq9cAzmtsjCTIL5WaSt4LVzXr7QR6uxCmZwhDU6Sc7YA8MQvLye.7Xt1eZpQ3B0O42e3aAio"
    "sfQ376SSW0z13e1XarID43DfFaOcErW.feuv5t8bYGSacyu1vTQuCldByl8tAFoHXKV5mZuqiyDY1Wb.UbZQj1pB8vKuLYsPypxBDbEoRASvHJzP0u0l0Maq6csce"
    "TNxbctAAysTWIy59MJOcoD80t8qmlg2UV3JmKk2p5os 99QKCr2jmgtB2SaoxfDX0UftI8.f5MaS4tasHiQS0L8nAPIuAQVc83VqTXxpyhY 1wny 7UvQhuPzImAd"
    "6ZBszK8vQwfo5DL7Bmmlb4n7MmoXAh3HFda6Tx4RnDBX8w4RucEaLHUDQZAc",
    2435UL, { _(3b),_(75),_(29),_(3e),_(8b),_(13),_(47),_(ae),_(6e),_(54),_(72),_(e7),_(8b),_(41),_(b0),_(35),
              _(58),_(1e),_(ea),_(cd),_(2b),_(c1),_(5d),_(3b),_(b1),_(83),_(ad),_(74),_(bc),_(fe),_(4a),_(af) } },
  { "yVzRtPj.17eZmMjy0gUkG8E1Wa0AF.K0SubfN6azLeLypFuEbiRU6ShahaJCb.ElSjQ9SpQUX EyywSksDZ 32AKilxKggEp E93hxcxlJ7rANkPiUfuVrwflJ.3j"
    "xjjBxFDG9RUgzIooOT8yhiO1xh5JDTiWYWwoq6P6EdJ9DW4tYvMGNz2pmLKxWv9E6dV81iVv9O0IIE38Ua2j2xrycNUDxImnynHeXvJLW0.c3VsE2zD9R.fDdwes0"
    "PDAHC5j31JOJFfpAWtwC6PCh50NU6jcEjtaHFLIwLwZaiP1KmAQET881f4yZOE9taL5Envc8VR4xNnlUEyk8EXD8sL4iT84rSvfqdhrETUcqQhkV4BPC36 VC6c9A"
    "vypgl1jBWIeEO1qlftwm4iiy37rMaCIXmq20gV4dv6RL9UL6xRIg4jFRthnqXPD111wZXueM5fjSaCpe pLCvV41QuMEWTzQgr7GfPCd3HBp9BPryYccGptALvgU2"
    "aE9QX1JFKU2uHgzbYuqmWLfpUEYFhZvo8rwX2xk4bzKKfs39XJknRKkvB3xuvU2mCGG7lgCnmSAD1q0Buld0 VOzWA0ZrS9ntizjo1lLdL0tR.UAefc3hjUTdOCHZ"
    "7S.LCJgRdoyhWvt wcC9QixQnMvUFD0zPUlaPhclzEHp1YIQRdFnfsPHAwRd9Ecb4Bd8eB504Y1IlIpd9329c 9NLTzIDmsIvCRlC eF4b7lQ.2z3w1uB5mLChEyN"
    "U5A dP8f3XaqGgS 7ZHGOzjP5uRInQjxQ5rmp3vPl2NcgZ wZq4WfpDn68k4ekL3jVHSiubCqa9EBmYa4QScIOYOE0dI7kPJnjW6mVt4cRBP5 gIpX3JZt yCGizV"
    "LdBEtFKvTaGOWiGCJMf6NrDRxN oVP9nRvTU .yZ68XlGq3Z5eyNIGAcs6klQC39PT3DW6xgvLxISoOsY2FjMrqy8jO.5tjIf42m6vRXt0JaJnWJt93tGG3PcqsTK"
    "F4o83W4mloDXjBMW2V9p0yY o7cUoToZm.oSxopz9qVU2igSviRy87kvQjcrheH2AnjHpODgBk59ebjMYIQxwo2XiVQMVI9V1 AUAeEitMEolIL1EZdC7aRpurkG2"
    "BClr2Ks1UE3m4.KyTpNtXDjCqGRTdqAeL3isvl2gFO2F.jci6ROMCBgXdKYe9xozyvWIyrlt0WNDi9aRYR.8FtS HgK08Y hkK3JBGBUJEXq5znvGctHrdswpLI8j"
    "7O.8BGFttaflgVODdL1e5iWmllDGebWcmVtFnSAzemtM2lCpA.vzyu7c0cXxLZ1qEVfs8sMi4QTW91QKXd2bRUozYP3mXZMXaNAlgUdAdaV0TPZf8nsJOhZTMgIze"
    "3fEBLSokbPmks6aQROEyRKKTV9O1FJ9dPCYQDYhfGrH7MIgfluKo1NSK0q28FwMW3i.BP6CAn4JmjRGQqPAMG8oeCNECCR5XEoBn9bxCyB9.PPpY.nvbrhbbUGJ2I"
    "KbuIvFQMtFw FB3VylJDkTAkMxeeZ81lqnF.Bo9Y78xvYDm5rvojYaWrAEbsHTBwy4X7g4m1EUYnI4vaR8C2XPiEkwX5A.Fysx3VqnaX0rcDYun5LRbRmybVBJLkt"
    "q91VCuPYokJ7TVCxMKyynHkeMhm.NEjOvL2PT.2VKbFPYJ1u22vxUQqTi lXYECO0IgsV23gg2 ryCU3IpjBRDbIZJDBGA3sBQe.tN050tderdElp0mmoPFt1lB38"
    "4iYdHqiz40KxLlEXWArEbbT nGgKD37Qvw9FFQfVTueqYvrvJ6929FGAjVNMy6J5AbJEn6GFO7znbvPg2hBbpYDd98FCNjzRbNmsmsyRbiIhj5zb9F5TxavtiM7uB"
    "UYUIsFX FCrxckh3TEAehLCHuwCq5yBDULZFfOjw40Q7RatyN3.S21d1Id8LGtFkF4PT4GUKnd 9ITMVj28s0k9Z1wooQmtR0v0WcgMy8TqyW8G67jR0RgEhYURyG"
    "jxgAEWHKd774qsGDbLnvrkflljARkhAqTm1b5mjsNGDq9xm1NX0ZvM70kBbMFnfNpLYXvvWIvwOtkcAS6kNBbKTsa7ZVf2jk0qpGdE H6eihMWyxutGqUYFiHZNgy"
    "z.wivolJH lpmJJ08iUFpUUdPPf9SyRobvKr1zsOfdckZO2xyBG0VBX1V2HhDoke sRqr0g7tAYxB7KcJsSQ3r1qZbxvCLiqt2tOo Ec0D.G4cCpLwrdj x JOX.L"
    "HCsDyoFFJ7CEAUSvcNy49AYkI3uxUOxbHWdCovVrn2pFgIqC1UYo8FUHzDq0cvP9EqZ5UAGdXK0zRRbic8cfFuzDotyVy2GymiUXnKcXSEhbDk zJ6gO8lUU43 oM"
    "e4P57V0Jw2XuL 3r3Y8SiilV9H82dd16UYSr8UapqjQyO.MCd7vCunZIuBK1OuXo4N2.OduHy5ax33igzcf fVFnSyqTETkkMKBVjJWVeyWx0OtEJKCL8JgMd cLP"
    "TU4MKqanEcSImZ4iDiJfBoGwNorpkE.f5XSA cwT5yXq49ME2OM.aRxI0iB BokWAUp19wjQrdh7Fo49zKHiX bUfYeuaPBF oI1CjQ5GM5LAEpmJg7vHsu uiJWn"
    "L819cuq04UxDa PEJ93e2I4evrUc4C8Xo4HLQ7X7arWWnognV8q3sAc1QzTqVJgZJwI8q8wKB9gJg6RoNlhekx9c8U9FONfbYrJT8GdFxHxiVhjd9kIITEDkfnlgp"
    "UqkDdSJ1edXyalI5nDdHFnLL52LSo8gLvIdSpenTou JOBNkovymhTNp2 27DFp9o9DSZyQXEBMJUja2aJk3vFJ uMwQYJBBlVMSiS7vJTc26tcYEo0F0rvdj.V1y"
    "cSYLnVow vMdTQ6M4h3Ud",
    2896UL, { _(74),_(37),_(ef),_(ba),_(4f),_(77),_(25),_(fd),_(19),_(61),_(7b),_(6d),_(51),_(cd),_(2a),_(39),
              _(f7),_(35),_(a0),_(48),_(d0),_(2c),_(ed),_(9c),_(3c),_(72),_(45),_(66),_(eb),_(4f),_(02),_(06) } },
  { "n8to4sc zBazWfisknLAjdCso w7WbNg.xm6fGFFymzY1awSjmTRwDyeIBiPoD2Vgh FOAP0jDpgyIfS8L06NtPwbdPlC2dhy7ekKN02aaVPWPwe6Ex1HC4RSMP1q"
    "wiGLpOYO3nsdhCJ820yjLLmXZ9Y88VdPdXEFNfPp2SJeyOzsBbZfVzYPzTss1UbdQ20tUB45TR3gcAyJ0xnpjhUH1WHu x96MOzEwm2qscMahHi61gE8iXjgJ.0MR"
    "ZFX7XBjywQMHmfYyn4oa9lwFDUhBiKiohmFWtWJjnnXGbfquJcZJFqCGhagtd6STIyCrlg0 fPsBKdeLdkiyttTILz6BxpHSWot5jXvtu4k0Lielkea1IB2sognZ5"
    "wSeyNpHnm60U2orvmMxqRFJEI1wHl fDdngrhBRRoyruaicZWt2jVdgfZUZ7v9lVc PWDp0VH.kmgB9yR7BLTIFV5LpGVF7 xp5bfNbmfK1fHCBGsB5QchnLw6x8W"
    "0e0hpdxLWd24cvF5w5TmFX91vpTamjMSHVoBT3wKYdTs67tgXicAV8zAeYjP5nffO76xG63J5yA6LKnt6uwWcnxYIUCS8JzIagoP 6gA47GAMByihF42FFFw1Z8qq"
    "XW9tr.Cuh.ci pfAu1  0ZDHVMBpva7CwXnyBDwmGaYJTrD.SCu4A.FyhByjcMyuwR2u4 qLx0EUA1ZTKzAYKvze.o qGkpiCb.vysHGMBkJZ67fQsK5gbv0er5qv"
    "uVCN3nTkqLBXs6d0sniBspuoeaLl7UHTZ yty6.X8XN0qxWufzYHVb6iRf1SUE5Y3XcRjX2hPuvLOTSp tK8UZEmG5EAFfusc3vooczUoRz3QD2LyosCf4Q xt4VL"
    " BO.pEvh6cYGY8PIocsfiDMSCVwWZ2maggoY9NBdci1pFruRxgg.myPw LA9799em4nazwEckowBHr1qkVhJpiFK 7gZafumYzJMCnCd5h0XGOWHgb0iJDbav.uIj"
    "aF4JG4X7AbW2UY0Z 7LiZOb A7t2mlqDoOUM6eYzKh.gXYxcM8GXZ7OjDRz1pX2qcs2FCWX9YPWrM2pxlszZE3TS2WW1.bcuDNcHfrGcyuRgOxGwcSWVkqddczBK6"
    "kjw2fpXATB1cu81LPk0U0rnnMsQ6nveQOmf8P1W6VIqBvomBWvKlGsMjJdFnzMyTDrbXY0I1sM7YIdauYJIICMnWFe7ru ecuijUCPhxLIXCgUj030wH8wNjnYulm"
    "G4.h3mrWZyYVER9GNE.lpcXnCmMmbuZ720DqVzobQXlKfsCN RUWiHAWf 0O4lWD6m1gCv.ViuqjWKIKgflsl7NFxrJpuClJg2XywlGS68lXNLKHAeNzf7q46O Nq"
    "vSVELogVuCK9jsvmGBatT9STIHoDgMXMlHk64ccjdwMnRHAeiLwpps8 AKQM2SRDULSptqqBJtKwfXPmv8SphYhGixWsoYwlqb7SlHF aDX1ClaC3MNgNePLzDd1Y"
    "rEEcje ClIxq9OHT85PTU0i 4QHiut5PSCHX4e85 dwVq6U5Yn9izrzsL5dBFZIMrKnZrpEbP xjv9IAE9SbFUYkfmBj9VtwUu0EeSfm5AXOdmgslLMHRvGK5d1sO"
    "ROT4U9lgUwAqibTpAdtWgEB.ut6B8TwVP7teTLgwHiKEHyEhWQGvoHTwgyMXKLOojLbfHdUEH86 lJ70cjxYYtWoDLiuVkG3O7udCrAjDvYCvcyEL60vCVIZvAW.1"
    "3db9cB36 mST KBFs5XsTOVuQqQdYl5mAAHpgn5gTKEcocrAOEzE3j4pyyQrysmWhkcMIHRV6GIG4jXRvlz9zQayMIip4AGImjkZdi8WJVUMNFTqk20GGMG3RxPYw"
    "EtB ChVMuOggUwq7aMbPBJV3FjeoRuJkrmOSp0uz4lbWuznlg2N80zO2 By0cC.san9od mngGb2DRDy0cikLs2pUM1XLbTPf9BVQdncbiZi.KN9FmQxMCV9nLl2a"
    "wu.c69cQsQEOpRLOea87m.ccTizwQJw3W60FVL8CvjEKYLH U7ddFsrY bmFYNmQEQUXGQcZY9XfF3r0vvR Uaqp7rgdWpVR4tnlhuzUq1CMX34C4dImyqem YV4R"
    "hB5oxObgmCMBnx5Ai d4S36PfF258i.WBEejSkSM8ftAogQ2sNuu0BNP8FftJ l5601sWtEdSb9JZRoqCP VHELYWDIGSN23SlH.TpK9mzGCPVNNthK9MIpfJzWTM"
    "qhuj0ycc3.TTD2hVYBb .NnsWcL5jeRveqg9Vtn62BIMab.1iKXv12dUMTMiOhK5SnmtPhMtqJbicfUGJKhJd5NZRrpIn4aE.zCPIKcsAMeeakNJ7E6oMnUj tIME"
    "NEOTF2Pzp93FC.8kwRt9SsjdvwRXZa8S7zffeb5gCKmxsoNK5f8b hSw4bJEfR.Hbif0C4mwJC20 Vl3ZJisk4pv 4XxbpMgQ2hdn4rVFhvHpm2V5xtucAQGR4fDd"
    "PjvfskSl1E.DnsRI.0i89PuDCeIPJVLDjY8TkGiDbXmHPiiBIrdvtl7LVMXkG7vye2AKfreSqsh0fZTesk7Nnvt7OMalse.Age rmi1mLo2yf8tssKZsQ96npTu7f"
    "KU aOqX8HJDJ3tjkDUCe.eAZW09OCmUUJcic5sKWBG.gN6Ir zzkZn4fZg24pbWfr3Ijfw38ehQhBJlQkonbO6ZOXfCB6 YvWia62NiGO99Hwg0tELLVeznDcMLiS"
    "tL7pU5EZvrqic8aiqAJC5tLs6IDM3SDm Eu8EOPotbLGtgeL6Y916AA.tpNYD18FPjKzQinybSklJ Rixtp3IZYLdqaKIL9Vx2ktNcDnddp 8YGum07r96mjZZ1Y9"
    "hL3Ua6Qk2jwkoRmqu8CA F3Yy8HgM3t.ZFxEJGDoqZMbYpAedRoHcQ9 YtsXDo3.0cyrJ0WmMQxqGYTJvek7oTjzgZnaT.SNHONdSA8xH4MGznX0WIM75PYxvnlqT"
    "f daH5uE8kWsDDkQBu795kdDHgMP3.qbVpg.nXPfSyR6lkRNXlbwu9Q.FrXY8XvP9Bc4uT31VBdB18isYG5ZpGVlIu oNIPhBLRiKsFPgPtUaMzFoFnN63Q8W4vCn"
    "VewMKkyEcMYJBgPRt1gBHyIrnD6R6JlT.xa0taQFnytEuXPyyZTS3 T0GPWAQ1mMwqTC.uSvwSRVsLfmTvGuvXYf7cEP.AELTACBseVzDxWgRvkHjC0RPVhH4x6bw"
    "E srpcLOJ38Hzo91S.7nNlPt30UeFOcubXNHSu5LfXG6AVQCbCXvvmG2 uhpXrKjeVkA1c9T6Esrc5IpMbNMqcztiEWiC3cN5.YCMxrMb8BnYLK4SEM3PuOWfq.o9"
    ".e1hqcDXFbkMp2LhCDrreKQPuaQt2oYMbN6ErE570DMjE3oz4vOV655WBmEtMTmwjXhZp",
    3444UL, { _(94),_(88),_(cc),_(af),_(2c),_(bb),_(21),_(18),_(44),_(91),_(db),_(b2),_(76),_(8b),_(ab),_(6f),
              _(bd),_(a2),_(24),_(41),_(25),_(52),_(b3),_(82),_(b8),_(3f),_(64),_(46),_(c5),_(99),_(3c),_(99) } },
# if 0 /* skip due to pedantic language limitations */
  { "gWiBgQgb4tlBXu2 R9mxJ3QPc6uhARweI2NxW3aenLX1Qv kj MHy1okscc8HfMDBujAhrcvdDUxyGfMAH6Rcx 7zc8thdHHIgRE6gOYGpql1qeNHdQjibP8LgqD3"
    "G.OdZoLkP01Qtv8OaRSI7NMbCBhucFC.men4.3bQHCnAAsxGxtaoQ3lQJSWwc42sIY0m5.ssVPY798GgPcRMLn1VeFy459ikUhVTCjmc XdUnfBSk8j1WeVrrgxYZ"
    "6aiaMaOcqzbUb4sYtMyUJon.Vbn  cGJf53YHCoB4glAaaCMaL6oGnovlFWMXx5aYm1aqzvhc.W9yegrZrU H3Ve4ocdr.P2FJRISEEs5ODhyO4RKLaWjt7mZPKKe"
    "E8Eknr40V3kSsX3v9TSfIwjBItctZEtiI0lJZMO93ttALpxnD0H4M2s7Z.KaYIqFyf3apcNnVVcm leCunV5ZfORkpt6fpYVWDyIkYi7Nzcg1Ybsgg9oz0jElxkCM"
    "WOqq2yFtofsN5AouzOJCjQ9OUeyd0O7GpnJw rv.M21GwmDYnfaQ9wqEs5xxIREPHMtwpgWjdVkFT4T9RL3aRtsrnARipGjSoBUFD61lLy8sZjh.rQmgz8oS6ghgv"
    "6t.WNIyUyPFlsmrlH3sLoXHNbvCKbRuwp8F0Pe97Ac.RgECbhS7qOSQTgVQW4KyntE9 m L47j8EN etygbkEYlNsl74U0lexy5j8lju7tH7DRnAWr2ATQq7nscho"
    "7r5kyxVyDMXV3SRhuKMf4prQhvCRbWfHxfv7ggsYkHP12pWlu8sGrxAnV2TnXXPRz8eUAZvz.sYmWQnqYG5a3vhjVPstn ZiBRI0hXoduStwEOFH66qRILhcYetOt"
    "2byi7.hw82aFXyTGwdAfG0D5rjU.RSiUfx3C98oP5wIjw2bPjOEuue3pQa03JguysDV2Lwy3nwMsORENnZX.YH.2mS6VrM3TKPBAAgbD3GDaDg5kvdBMS0erEx6ON"
    "ezPiyQC6sVVfKTtS0d3RJXLZLUWMb36RmsaiAhSltkMNjAVsmSvwbk7hAuKpltFscts 6Ho4Ztl3gBNM4QPpng1xcuIWJm5XkBbzKfPfFlMaUwkfm0CZcAXN4sMJ6"
    "b7h2rQgQ0e.W  LOogyrsGXenTaH5El4qRJrNK75G4qb THWPw9.YH1uuLSQ4C. CRt82iVYX0inNVyLzVBq8mxgpMJCrhEmVgOsLWmc.QtV8 Sb7 jHG7ex2Tame"
    "BN3spHQhpc4AYMowa9Tvbel2g8aFwBaJXO7PC57oSJ9iZXsApaqVWFSwYPdic8CDUX7WW4.wmvSPF0q.6VV1j139BhxkZ3lkt8ygdor1TBY7kEQpWGtRAlWenIAl6"
    "v9VPiVGRBha7dWT9ZOkggFjy21XYANI.LOL97qVL95QRBLvK89tHhUk.5q6b4nivVHncgmQt5yvGUPATB83DAuIixduXLIuzrct6NFeYm9kFmYf3vEgy 3eb5eFRa"
    "CnnnlrL0ov3QS1VezPtjc5jaQ0C1Q18lmWYemOP ONlpD9q3ymsP5yBrXJ8ICNd5wRjb3sCspU1UTPW.PJMor9RfDAedxqUmOFH5TnQA7guy95AM76JqVc29CFfRJ"
    "F8oitsDGROF65QlDA vnsMJuFBpBhxfOtI5KY EQbPkUSuv6tS53y 0ZVZFEYlWfjsjKxNv9w4y7Fn93wxfcwZBOUr1MiftAXBzHaVy.JWCDKw 0g O6mz9A72oyA"
    "OfFZ znEuPV4TQ5cX.kfKjwhw0hB4G4PW1s8Qd0V A591aS6IjSHySFUvzw4pCU6jyZ8xLdIv5PIKWsLaWcdsOOQ7i vSfOXda34SjbsxNsDd5TP5GZ8vCR6lGONI"
    "wA2bDF4OEPElA.xsPT5RCdcy53FedQ3 RasyAiFZkZ3bffJIvmctACZXBhZ1g.HaRfNzrBzLh MMh.67ue4onxNXuuschk1b8E2xw.pEe0t4kYWTYoVBDWAu4WYy0"
    "14WxKYPrvUMPwdgo wWRkLWldjJ78gTfY5L8nKhggqVP19r1Xq5ehDF5wVHe 4uylUTsxKweQbMVuKu62nGgJnRtYEe9rAlW3htTXFSOgilQu9oOf MrA3OtWUava"
    "b0TtLS2OWTtkQaLow66HwG2KYdGK.Z0vChmB2lBHG0Ul D 3hIeU0NzqQ1ps5XsSCyapqdjv79qGJloIP3RClNA30zEzWa2dLk2YF60RSFjfsgVgz5D WkHXjJ7FM"
    "LQCfaTUzGXnTIbYivvCD0AHWzKOP0Xu4CHmCNy2hNXQyE1TD4Baz7CHMeWq6Ba2AqJsj0k60r1SjbTnFwLt2J uCDr7a8Hiz4ELm1j7BdP1rly55gN3iHGb3aRD9m"
    "E.n2zfuVZ.whEsHrRKRo90KRJhI8WEKqei23u4KejJzzcDEa104 sAM7P5NJUnS9f4R19UaPv5HseNrm1qY49Vu8lNbuzFL5pNPEGanf0CseysfHN4IbffwJOEOkh"
    "xeyCbbp7TbI kAmjjfz2602g5u5UEPv4hMdwG7nJCF7FTe9R0mu.dtUPXoqSE5l1nR06 fW3oaadPgKQi8lzz4ByXQ6TWCP1hXUQM2gUGB5ibsihkXPZgN3JPE1 t"
    "2fekDwbGN6f0vMJxGEfCz51TVq113SnSUe2jVWIupxYZFzUJo8sak5Wyp4Pu8RasQWO9BZG N0pXWmIn1NIRmJ1CkY3H52QyUm4TByjmsAhqMsOb6Hu.mibMVXbWo"
    "uWeYhwTzNJ1vbyNGgWmCeS.TCrIjVAe6s1Xgv2N8Kj26ZoGMexs4I2lkYPX41gxPxbw4QWwbS.  1spqQDrLQIf2miXNSyjn7MOj10deN TEnSKuFp c.in8asyPv"
    "Bnx2ZoOgr9fXt7fjm8H.iNQFSTIk3v2zrWppCl6kVTdqAkrfJGv.BL9cZuMo23NktRVD9VHJ7WNNPhqgmDedN2.yq9ozKQuhxpGHyooUBLZBipAtNMwyTXfbd.CGb"
    "zAIzzI9hnOht4JJslzv8zTtd3cssAQ2hf6b9eOLrTigZVdXnIxLP uenbwxQUs5.UTA6JihYvFoVtwjCBAnap YQWiOZgzZ11iaYDblK1jatHo2rtLHL2kkI8b2Jl"
    "AKurROMwmP6ZGUtMGenyiCKgbhSL lZ9bBH4U9Ve61x1hOh.4OZZumZei2r6f1Jdl0hispS2pxzcpL8FKDYwaVfK7MhWiKpekawfMd2qSj7MeZGS2YuDa.5T9Mwg5"
    "g7IkA2mYlfffda3bMpP06xvjNm2cfA51gjl9LH.f8Fb0g8ZG33Z7oTfy244wmdKJP58oCAoxyd2NlpRDmHdW9jfUitsobgxqc8c.ZoYNG9v 4VHn DncziRJBYefl"
    "mbOlEHUBI.tc.1VWJ41X0nvisJkUQmwKH6g.NvzsBIAUN4ysZIhmcrYu0zAK 9cE0tz7eftfv7p75KIz1UrKy28 OaD2XZiDi11hB.1UVpPKTEfpqJAjbfRONxerR"
    "6ETJg5UiLYibAkPsVWZvXfMv6QchKTKTyHsyrzM3BTXbHAZpEN4rjOEJDzfD56df QX4RJu1kqokLFA27hAPfYYcGOTO4KELUARrsWRV 9TtV1ud07NfbzxuACXVK"
    "8dcryL6b7NSGA5QgM655 7S6P RFjPDR 81B0CWJKyzFSdmy2TUXsfWuQFPNyB1Wr8ybMqheW0gioAzKdx9bAnFmruzmULVfgzKuqbV2fQk L0nePsUq1R77lZvEM"
    "Wbc72f3SLgZ5hazfeaAc9qAg99tu6lF8ZbNvAXP1WSMxsogYE4TsJEL5poxMFxGknokfOhcbyQNqx8rgR1MRVJf3oYk6iJW6AXjpPPHIRMoUGFiO3gVc20AXfhimu"
    "6 IaTn4cCOxcWkTEmwjo0E163Oitnkek1utXhdxPo43VEBAMtmETd9nbf368orrMnULFTck62ndNeZ0pO KZfyTFbTpjH3PwXvd8KvCBng7CUR4P5jMDo8AHi8D.U"
    "M3YkA RLC5zWPBVsxvCgmz90U9Iig0szTLGcxeS.pjicBc7yA QOiAA9OreTZ3xNjJuYdUoVzTex6sRlEP55O 3O0zvK16Ey",
    4096UL, { _(26),_(2d),_(98),_(fc),_(ed),_(9c),_(62),_(14),_(ed),_(87),_(76),_(80),_(3c),_(cb),_(2e),_(43),
              _(47),_(6f),_(1d),_(53),_(04),_(8a),_(d0),_(7c),_(83),_(46),_(df),_(46),_(a6),_(41),_(31),_(f5) } },
# endif
  { NULL, /* Terminate the list of vectors */
       0UL, { _(00),_(00),_(00),_(00),_(00),_(00),_(00),_(00), _(00),_(00),_(00),_(00),_(00),_(00),_(00),_(00),
              _(00),_(00),_(00),_(00),_(00),_(00),_(00),_(00), _(00),_(00),_(00),_(00),_(00),_(00),_(00),_(00) } }
};

#undef _
