---
title: Validation Stake Delegation
---

**Subject to change.**

Running a Solana validation-client required relatively modest upfront hardware capital investment. **Table 2** provides an example hardware configuration to support ~1M tx/s with estimated ‘off-the-shelf’ costs:

| Component         | Example                                          | Estimated Cost |
| :---------------- | :----------------------------------------------- | :------------- |
| GPU               | 2x 2080 Ti                                       | \$2500         |
| or                | 4x 1080 Ti                                       | \$2800         |
| OS/Ledger Storage | Samsung 860 Evo 2TB                              | \$370          |
| Accounts storage  | 2x Samsung 970 Pro M.2 512GB                     | \$340          |
| RAM               | 32 Gb                                            | \$300          |
| Motherboard       | AMD x399                                         | \$400          |
| CPU               | AMD Threadripper 2920x                           | \$650          |
| Case              |                                                  | \$100          |
| Power supply      | EVGA 1600W                                       | \$300          |
| Network           | &gt; 500 mbps                                    |                |
| Network \(1\)     | Google webpass business bay area 1gbps unlimited | \$5500/mo      |
| Network \(2\)     | Hurricane Electric bay area colo 1gbps           | \$500/mo       |

**Table 2** example high-end hardware setup for running a Solana client.

Despite the low-barrier to entry as a validation-client, from a capital investment perspective, as in any developing economy, there will be much opportunity and need for competent validation services as evidenced by node reliability, UX/UI, APIs and other software accessibility tools. Additionally, although Solana’s validator node startup costs are nominal when compared to similar networks, they may still be somewhat restrictive for some potential participants. In the spirit of developing a true decentralized, permissionless network, these interested parties can become involved in the Solana network/economy via delegation of previously acquired tokens with a reliable validation node to earn a portion of the interest generated.

Delegation of tokens to validation-clients provides a way for passive Solana token holders to become part of the active Solana economy and earn interest rates proportional to the interest rate generated by the delegated validation-client. Additionally, this feature intends to create a healthy validation-client market, with potential validation-client nodes competing to build reliable, transparent and profitable delegation services.
